package org.immutables.fixture;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code HasTypeAnnotation}.
 * @see ImmutableHasTypeAnnotation
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture", generator = "Gsons")
public final class GsonAdaptersHasTypeAnnotation implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (HasTypeAnnotationTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new HasTypeAnnotationTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersHasTypeAnnotation(HasTypeAnnotation)";
  }

  @org.immutables.value.Generated(from = "HasTypeAnnotation", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class HasTypeAnnotationTypeAdapter extends TypeAdapter<HasTypeAnnotation> {
    public final java.lang.@TypeA @TypeB String strTypeSample = null;
    private final TypeAdapter<java.lang.@TypeA @TypeB String> strTypeAdapter;
    private final TypeAdapter<byte[]> bteTypeAdapter;

    HasTypeAnnotationTypeAdapter(Gson gson) {
      this.strTypeAdapter = gson.getAdapter( String.class);
      this.bteTypeAdapter = gson.getAdapter(byte[].class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return HasTypeAnnotation.class == type.getRawType()
          || ImmutableHasTypeAnnotation.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, HasTypeAnnotation value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeHasTypeAnnotation(out, value);
      }
    }

    @Override
    public HasTypeAnnotation read(JsonReader in) throws IOException {
      return readHasTypeAnnotation(in);
    }

    private void writeHasTypeAnnotation(JsonWriter out, HasTypeAnnotation instance)
        throws IOException {
      out.beginObject();
      @Nullable java.lang.@TypeA @TypeB String strValue = instance.str();
      if (strValue != null) {
        out.name("str");
        strTypeAdapter.write(out, strValue);
      } else if (out.getSerializeNulls()) {
        out.name("str");
        out.nullValue();
      }
      @Nullable byte[] bteValue = instance.bte();
      if (bteValue != null) {
        out.name("bte");
        bteTypeAdapter.write(out, bteValue);
      } else if (out.getSerializeNulls()) {
        out.name("bte");
        out.nullValue();
      }
      @Nullable java.util.@TypeA @TypeB Map<String, String> mapMapping = instance.map();
      if (mapMapping != null) {
        out.name("map");
        out.beginObject();
        for (java.util.Map.Entry<String, String> e : mapMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          String value = e.getValue();
          out.value(value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("map");
        out.nullValue();
      }
      out.endObject();
    }

    private  HasTypeAnnotation readHasTypeAnnotation(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableHasTypeAnnotation.Builder builder = ImmutableHasTypeAnnotation.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableHasTypeAnnotation.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 's':
        if ("str".equals(attributeName)) {
          readInStr(in, builder);
          return;
        }
        break;
      case 'b':
        if ("bte".equals(attributeName)) {
          readInBte(in, builder);
          return;
        }
        break;
      case 'm':
        if ("map".equals(attributeName)) {
          readInMap(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInStr(JsonReader in, ImmutableHasTypeAnnotation.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.str(in.nextString());
      }
    }

    private void readInBte(JsonReader in, ImmutableHasTypeAnnotation.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        byte[] value = bteTypeAdapter.read(in);
        builder.bte(value);
      }
    }

    private void readInMap(JsonReader in, ImmutableHasTypeAnnotation.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          in.beginObject();
          boolean empty = true;
          while(in.hasNext()) {
            String rawKey = in.nextName();
            String key = rawKey;
            String value = in.nextString();
            builder.putMap(key, value);
            empty = false;
          }
          if (empty) {
            builder.putAllMap(Collections.<String, String>emptyMap());
          }
          in.endObject();
        }
      }
    }
  }
}
