package nonimmutables;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Type.Nested.Deeper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeeper.builder()}.
 */
@Generated(from = "Type.Nested.Deeper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDeeper extends Type.Nested.Deeper {

  private ImmutableDeeper(ImmutableDeeper.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeeper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeeper
        && equalTo(0, (ImmutableDeeper) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableDeeper another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -813061589;
  }

  /**
   * Prints the immutable value {@code Deeper}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Deeper{}";
  }

  /**
   * Creates an immutable copy of a {@link Type.Nested.Deeper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Deeper instance
   */
  public static ImmutableDeeper copyOf(Type.Nested.Deeper instance) {
    if (instance instanceof ImmutableDeeper) {
      return (ImmutableDeeper) instance;
    }
    return ImmutableDeeper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeeper ImmutableDeeper}.
   * <pre>
   * ImmutableDeeper.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableDeeper builder
   */
  public static ImmutableDeeper.Builder builder() {
    return new ImmutableDeeper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeeper ImmutableDeeper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Type.Nested.Deeper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Deeper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Type.Nested.Deeper instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeeper ImmutableDeeper}.
     * @return An immutable instance of Deeper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeeper build() {
      return new ImmutableDeeper(this);
    }
  }
}
