/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.repository;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.immutables.mongo.bson4gson.GsonCodecs;
import org.immutables.mongo.types.TypeAdapters;

@ThreadSafe
public final class RepositorySetup {
    final ListeningExecutorService executor;
    final CodecRegistry codecRegistry;
    final MongoDatabase database;
    final FieldNamingStrategy fieldNamingStrategy;
    private static final int DEFAULT_THREAD_POOL_CORE_SIZE = 5;
    private static final int DEFAULT_THREAD_POOL_MAXIMUM_SIZE = 15;
    private static final long DEFAULT_THREAD_POOL_KEEP_ALIVE_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat(RepositorySetup.class.getPackage().getName() + "-%s").setDaemon(true).build();

    private RepositorySetup(ListeningExecutorService executor, MongoDatabase database, CodecRegistry codecRegistry, FieldNamingStrategy fieldNamingStrategy) {
        this.executor = executor;
        this.database = database;
        this.codecRegistry = codecRegistry;
        this.fieldNamingStrategy = (FieldNamingStrategy)Preconditions.checkNotNull((Object)fieldNamingStrategy, (Object)"fieldNamingStrategy");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RepositorySetup forUri(String uri) {
        MongoClientURI clientUri = new MongoClientURI(uri);
        String databaseName = clientUri.getDatabase();
        Preconditions.checkArgument((databaseName != null ? 1 : 0) != 0, (Object)"URI should contain database path segment");
        return RepositorySetup.builder().database(RepositorySetup.newMongoClient(clientUri).getDatabase(databaseName)).executor(RepositorySetup.newExecutor()).gson(RepositorySetup.createGson()).build();
    }

    private static Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new TypeAdapters());
        for (TypeAdapterFactory factory : ServiceLoader.load(TypeAdapterFactory.class)) {
            gsonBuilder.registerTypeAdapterFactory(factory);
        }
        return gsonBuilder.create();
    }

    private static MongoClient newMongoClient(MongoClientURI clientUri) {
        return new MongoClient(clientUri);
    }

    private static ListeningExecutorService newExecutor() {
        return MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)new ThreadPoolExecutor(5, 15, DEFAULT_THREAD_POOL_KEEP_ALIVE_MILLIS, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), DEFAULT_THREAD_FACTORY)));
    }

    @NotThreadSafe
    public static class Builder {
        @Nullable
        private ListeningExecutorService executor;
        @Nullable
        private MongoDatabase database;
        @Nullable
        private CodecRegistry codecRegistry;
        @Nullable
        private FieldNamingStrategy fieldNamingStrategy;

        private Builder() {
        }

        public Builder executor(ListeningExecutorService executor) {
            this.executor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor);
            return this;
        }

        public Builder database(MongoDatabase database) {
            this.database = (MongoDatabase)Preconditions.checkNotNull((Object)database);
            return this;
        }

        public Builder gson(Gson gson) {
            Preconditions.checkNotNull((Object)gson, (Object)"gson");
            TypeAdapterFactory bsonAdapterFactory = GsonCodecs.delegatingTypeAdapterFactory(MongoClientSettings.getDefaultCodecRegistry());
            Gson newGson = gson.newBuilder().registerTypeAdapterFactory(bsonAdapterFactory).create();
            CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{GsonCodecs.codecRegistryFromGson(newGson)});
            return this.codecRegistry(codecRegistry, new FieldNamingStrategy.GsonNamingStrategy(gson));
        }

        public Builder codecRegistry(CodecRegistry registry, FieldNamingStrategy fieldNamingStrategy) {
            this.codecRegistry = (CodecRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
            this.fieldNamingStrategy = (FieldNamingStrategy)Preconditions.checkNotNull((Object)fieldNamingStrategy, (Object)"fieldNamingStrategy");
            return this;
        }

        public Builder codecRegistry(CodecRegistry registry) {
            return this.codecRegistry(registry, FieldNamingStrategy.DEFAULT);
        }

        public RepositorySetup build() {
            Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"executor is not set");
            Preconditions.checkState((this.database != null ? 1 : 0) != 0, (Object)"database is not set");
            Preconditions.checkState((this.codecRegistry != null ? 1 : 0) != 0, (Object)"codecRegistry is not set");
            Preconditions.checkState((this.fieldNamingStrategy != null ? 1 : 0) != 0, (Object)"fieldNamingStrategy is not set");
            return new RepositorySetup(this.executor, this.database, this.codecRegistry, this.fieldNamingStrategy);
        }
    }

    public static interface FieldNamingStrategy {
        public static final FieldNamingStrategy DEFAULT = new FieldNamingStrategy(){

            @Override
            public String translateName(Member member) {
                return member.getName();
            }
        };

        public String translateName(Member var1);

        public static class GsonNamingStrategy
        implements FieldNamingStrategy {
            private final Gson gson;

            private GsonNamingStrategy(Gson gson) {
                this.gson = (Gson)Preconditions.checkNotNull((Object)gson, (Object)"gson");
            }

            @Override
            public String translateName(Member member) {
                return this.gson.fieldNamingStrategy().translateName((Field)member);
            }
        }
    }
}

