/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.mongo.bson4gson;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.AbstractBsonReader;
import org.bson.BsonType;
import org.immutables.mongo.Wrapper;

@NotThreadSafe
public class BsonReader
extends JsonReader
implements Wrapper<org.bson.BsonReader> {
    private static final Reader UNREADABLE_READER = new Reader(){

        @Override
        public int read(char[] buffer, int offset, int count) throws IOException {
            throw new AssertionError();
        }

        @Override
        public void close() throws IOException {
            throw new AssertionError();
        }
    };
    private final AbstractBsonReader delegate;

    BsonReader(AbstractBsonReader delegate) {
        super(UNREADABLE_READER);
        this.delegate = (AbstractBsonReader)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
    }

    @Override
    public org.bson.BsonReader unwrap() {
        return this.delegate;
    }

    private BsonType advance() {
        return this.delegate.readBsonType();
    }

    public void beginArray() throws IOException {
        this.delegate.readStartArray();
    }

    public void endArray() throws IOException {
        this.delegate.readEndArray();
    }

    public void beginObject() throws IOException {
        this.delegate.readStartDocument();
    }

    public void endObject() throws IOException {
        this.delegate.readEndDocument();
    }

    public boolean hasNext() throws IOException {
        if (!this.hasMoreElements()) {
            return false;
        }
        this.advance();
        return this.hasMoreElements();
    }

    private boolean hasMoreElements() {
        switch (this.state()) {
            case END_OF_DOCUMENT: 
            case END_OF_ARRAY: 
            case DONE: {
                return false;
            }
        }
        return true;
    }

    public JsonToken peek() throws IOException {
        switch (this.state()) {
            case INITIAL: 
            case SCOPE_DOCUMENT: 
            case TYPE: {
                this.advance();
                return this.peek();
            }
            case NAME: {
                return JsonToken.NAME;
            }
            case END_OF_DOCUMENT: {
                return JsonToken.END_OBJECT;
            }
            case END_OF_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case DONE: {
                return JsonToken.END_DOCUMENT;
            }
            case VALUE: {
                return BsonReader.toGsonToken(this.delegate.getCurrentBsonType());
            }
        }
        throw new IllegalStateException("Unexpected state: " + this.state() + " currentType:" + this.delegate.getCurrentBsonType());
    }

    private AbstractBsonReader.State state() {
        return this.delegate.getState();
    }

    private static JsonToken toGsonToken(BsonType type) {
        switch (type) {
            case END_OF_DOCUMENT: {
                return JsonToken.END_DOCUMENT;
            }
            case DOCUMENT: {
                return JsonToken.BEGIN_OBJECT;
            }
            case ARRAY: {
                return JsonToken.BEGIN_ARRAY;
            }
            case BOOLEAN: {
                return JsonToken.BOOLEAN;
            }
            case STRING: 
            case SYMBOL: 
            case OBJECT_ID: 
            case BINARY: 
            case REGULAR_EXPRESSION: {
                return JsonToken.STRING;
            }
            case DATE_TIME: 
            case DOUBLE: 
            case INT32: 
            case INT64: 
            case TIMESTAMP: 
            case DECIMAL128: {
                return JsonToken.NUMBER;
            }
            case NULL: 
            case UNDEFINED: {
                return JsonToken.NULL;
            }
        }
        return JsonToken.NULL;
    }

    public String nextName() throws IOException {
        return this.delegate.readName();
    }

    public String nextString() throws IOException {
        return this.scalarToString();
    }

    private String scalarToString() {
        BsonType type = this.delegate.getCurrentBsonType();
        switch (type) {
            case STRING: {
                return this.delegate.readString();
            }
            case SYMBOL: {
                return this.delegate.readSymbol();
            }
            case INT32: {
                return Integer.toString(this.delegate.readInt32());
            }
            case INT64: {
                return Long.toString(this.delegate.readInt64());
            }
            case DOUBLE: {
                return Double.toString(this.delegate.readDouble());
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().toString();
            }
            case REGULAR_EXPRESSION: {
                return this.delegate.readRegularExpression().getPattern();
            }
            case OBJECT_ID: {
                return this.delegate.readObjectId().toHexString();
            }
        }
        throw new IllegalStateException("Unknown scalar type to be converted to string: " + type);
    }

    public boolean nextBoolean() throws IOException {
        return this.delegate.readBoolean();
    }

    public void nextNull() throws IOException {
        BsonType type = this.delegate.getCurrentBsonType();
        if (type == BsonType.NULL) {
            this.delegate.readNull();
        } else if (type == BsonType.UNDEFINED) {
            this.delegate.readUndefined();
        } else {
            throw new IllegalStateException(String.format("Expected bson type %s or %s but got %s", BsonType.NULL, BsonType.UNDEFINED, type));
        }
    }

    public double nextDouble() throws IOException {
        BsonType type = this.delegate.getCurrentBsonType();
        switch (type) {
            case DOUBLE: {
                return this.delegate.readDouble();
            }
            case INT32: {
                return this.delegate.readInt32();
            }
            case INT64: {
                return this.delegate.readInt64();
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().bigDecimalValue().doubleValue();
            }
            case DATE_TIME: {
                return this.delegate.readDateTime();
            }
            case TIMESTAMP: {
                return this.delegate.readTimestamp().getValue();
            }
        }
        throw new IllegalStateException(String.format("Expected numeric bson type (double) but got %s (as json:%s)", type, BsonReader.toGsonToken(type)));
    }

    public long nextLong() throws IOException {
        BsonType type = this.delegate.getCurrentBsonType();
        switch (type) {
            case INT64: {
                return this.delegate.readInt64();
            }
            case INT32: {
                return this.delegate.readInt32();
            }
            case DOUBLE: {
                return (long)this.delegate.readDouble();
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().bigDecimalValue().longValueExact();
            }
            case DATE_TIME: {
                return this.delegate.readDateTime();
            }
            case TIMESTAMP: {
                return this.delegate.readTimestamp().getValue();
            }
        }
        throw new IllegalStateException(String.format("Expected numeric bson type (long) but got %s (as json:%s)", type, BsonReader.toGsonToken(type)));
    }

    public int nextInt() throws IOException {
        BsonType type = this.delegate.getCurrentBsonType();
        switch (type) {
            case INT32: {
                return this.delegate.readInt32();
            }
            case INT64: {
                return (int)this.delegate.readInt64();
            }
            case DOUBLE: {
                return (int)this.delegate.readDouble();
            }
            case DECIMAL128: {
                return this.delegate.readDecimal128().bigDecimalValue().intValueExact();
            }
            case DATE_TIME: {
                return (int)this.delegate.readDateTime();
            }
            case TIMESTAMP: {
                return (int)this.delegate.readTimestamp().getValue();
            }
        }
        throw new IllegalStateException(String.format("Expected numeric bson type (int) but got %s (as json:%s)", type, BsonReader.toGsonToken(type)));
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void skipValue() throws IOException {
        this.delegate.skipValue();
    }
}

