/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.adapter;

import com.google.gson.internal.;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public final class Types {
    private Types() {
    }

    public static <T> TypeToken<T> tokenFor(Class<?> sampleType, String fieldName, Type[] arguments, String ... variables) {
        try {
            Type typeWithVariables = sampleType.getField(fieldName).getGenericType();
            Type typeWithArguments = Types.substituteVariables(typeWithVariables, arguments, variables);
            return TypeToken.get((Type)typeWithArguments);
        }
        catch (Exception ex) {
            throw new AssertionError("Cannot get generic type for " + sampleType.getSimpleName() + "." + fieldName, ex);
        }
    }

    public static Type substituteVariables(final Type parameterized, final Type[] arguments, final String[] variables) {
        class Substitution {
            Substitution() {
            }

            Type process(Type type) {
                if (type instanceof ParameterizedType) {
                    ParameterizedType p = (ParameterizedType)type;
                    return Types.newParameterized(p.getOwnerType(), p.getRawType(), this.processAll(p.getActualTypeArguments()));
                }
                if (type instanceof GenericArrayType) {
                    GenericArrayType g = (GenericArrayType)type;
                    return Types.newArray(this.process(g.getGenericComponentType()));
                }
                if (type instanceof WildcardType) {
                    WildcardType w = (WildcardType)type;
                    return Types.newWildcard(this.processAll(w.getUpperBounds()), this.processAll(w.getLowerBounds()));
                }
                if (type instanceof TypeVariable) {
                    return this.substitute((TypeVariable)type);
                }
                return type;
            }

            Type[] processAll(Type[] types) {
                for (int i = 0; i < types.length; ++i) {
                    types[i] = this.process(types[i]);
                }
                return types;
            }

            Type substitute(TypeVariable<?> variable) {
                String name = variable.getName();
                int index = 0;
                for (String v : variables) {
                    if (name.equals(v)) {
                        return arguments[index];
                    }
                    ++index;
                }
                throw new IllegalStateException("type variable " + name + " not substituted in " + parameterized);
            }
        }
        return new Substitution().process(parameterized);
    }

    static ParameterizedType newParameterized(Type ownerType, Type rawType, Type ... typeArguments) {
        return .Gson.Types.newParameterizedTypeWithOwner((Type)ownerType, (Type)rawType, (Type[])typeArguments);
    }

    static GenericArrayType newArray(Type componentType) {
        return .Gson.Types.arrayOf((Type)componentType);
    }

    static WildcardType newWildcard(Type[] upperBounds, Type[] lowerBounds) {
        if (lowerBounds.length == 0) {
            return .Gson.Types.supertypeOf((Type)upperBounds[0]);
        }
        return .Gson.Types.subtypeOf((Type)lowerBounds[0]);
    }
}

