/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.gson.adapter;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import sun.reflect.ReflectionFactory;

public final class FieldNamingTranslator {
    private static final AtomicBoolean complained = new AtomicBoolean();
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    private final FieldNamingStrategy fieldNamingStrategy;

    public FieldNamingTranslator(Gson gson) {
        this(FieldNamingTranslator.namingStrategyFrom(gson));
    }

    public FieldNamingTranslator(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    public String translateName(Class<?> declaringClass, Class<?> type, String name, String overridenSerializedName) {
        if (!overridenSerializedName.isEmpty()) {
            return overridenSerializedName;
        }
        Field synthethicField = REFLECTION_FACTORY.newField(declaringClass, name, type, 0, 0, "", new byte[0]);
        return this.fieldNamingStrategy.translateName(synthethicField);
    }

    private static FieldNamingStrategy namingStrategyFrom(Gson gson) {
        Object factories = FieldNamingTranslator.readPrivateField(gson, "factories");
        if (factories instanceof Iterable) {
            for (Object factory : (Iterable)factories) {
                Object strategy;
                if (!(factory instanceof ReflectiveTypeAdapterFactory) || !((strategy = FieldNamingTranslator.readPrivateField(factory, "fieldNamingPolicy")) instanceof FieldNamingStrategy)) continue;
                return (FieldNamingStrategy)strategy;
            }
        }
        FieldNamingTranslator.complainOnce();
        return FieldNamingPolicy.IDENTITY;
    }

    private static void complainOnce() {
        if (complained.compareAndSet(false, true)) {
            Logger.getLogger(FieldNamingTranslator.class.getName()).warning("Gson FieldNamingStrategy will not work for some serialized immutable objects: runtime incompatibility");
        }
    }

    private static Object readPrivateField(Object object, String name) {
        try {
            Field field = object.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }
}

