/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.roster.provider.RosterPacketProvider;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdatalayout.provider.DataLayoutProvider;
import org.jivesoftware.smackx.xdatavalidation.provider.DataValidationProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataFormProvider
extends ExtensionElementProvider<DataForm> {
    public static final DataFormProvider INSTANCE = new DataFormProvider();

    /*
     * Enabled aggressive block sorting
     */
    public DataForm parse(XmlPullParser parser, int initialDepth) throws Exception {
        DataForm.Type dataFormType = DataForm.Type.fromString(parser.getAttributeValue("", "type"));
        DataForm dataForm = new DataForm(dataFormType);
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (name) {
                        case "instructions": {
                            dataForm.addInstruction(parser.nextText());
                            break;
                        }
                        case "title": {
                            dataForm.setTitle(parser.nextText());
                            break;
                        }
                        case "field": {
                            dataForm.addField(DataFormProvider.parseField(parser));
                            break;
                        }
                        case "item": {
                            dataForm.addItem(DataFormProvider.parseItem(parser));
                            break;
                        }
                        case "reported": {
                            dataForm.setReportedData(DataFormProvider.parseReported(parser));
                            break;
                        }
                        case "query": {
                            if (namespace.equals("jabber:iq:roster")) {
                                dataForm.addExtensionElement(RosterPacketProvider.INSTANCE.parse(parser));
                                break;
                            }
                            break block0;
                        }
                        case "page": {
                            if (namespace.equals("http://jabber.org/protocol/xdata-layout")) {
                                dataForm.addExtensionElement((Element)DataLayoutProvider.parse(parser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return dataForm;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FormField parseField(XmlPullParser parser) throws XmlPullParserException, IOException {
        FormField formField;
        int initialDepth = parser.getDepth();
        String var = parser.getAttributeValue("", "var");
        FormField.Type type = FormField.Type.fromString(parser.getAttributeValue("", "type"));
        if (type == FormField.Type.fixed) {
            formField = new FormField();
        } else {
            formField = new FormField(var);
            formField.setType(type);
        }
        formField.setLabel(parser.getAttributeValue("", "label"));
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (name) {
                        case "desc": {
                            formField.setDescription(parser.nextText());
                            break;
                        }
                        case "value": {
                            formField.addValue(parser.nextText());
                            break;
                        }
                        case "required": {
                            formField.setRequired(true);
                            break;
                        }
                        case "option": {
                            formField.addOption(DataFormProvider.parseOption(parser));
                            break;
                        }
                        case "validate": {
                            if (namespace.equals("http://jabber.org/protocol/xdata-validate")) {
                                formField.setValidateElement(DataValidationProvider.parse(parser));
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return formField;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.Item parseItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            fields.add(DataFormProvider.parseField(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.Item(fields);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static DataForm.ReportedData parseReported(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "field": {
                            fields.add(DataFormProvider.parseField(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return new DataForm.ReportedData(fields);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static FormField.Option parseOption(XmlPullParser parser) throws XmlPullParserException, IOException {
        int initialDepth = parser.getDepth();
        FormField.Option option = null;
        String label = parser.getAttributeValue("", "label");
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String name;
                    switch (name = parser.getName()) {
                        case "value": {
                            option = new FormField.Option(label, parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return option;
                }
            }
        }
    }
}

