/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.ArrayList;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.NfsFileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.FileCompleter;
import org.hyperic.sigar.util.GetlineCompleter;

public class Df
extends SigarCommandBase {
    private static final String OUTPUT_FORMAT = "%-15s %4s %4s %5s %4s %-15s %s";
    private static final String[] HEADER = new String[]{"Filesystem", "Size", "Used", "Avail", "Use%", "Mounted on", "Type"};
    private GetlineCompleter completer;

    public Df(Shell shell) {
        super(shell);
        this.setOutputFormat(OUTPUT_FORMAT);
        this.completer = new FileCompleter(shell);
    }

    public Df() {
        this.setOutputFormat(OUTPUT_FORMAT);
    }

    public GetlineCompleter getCompleter() {
        return this.completer;
    }

    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    public String getSyntaxArgs() {
        return "[filesystem]";
    }

    public String getUsageShort() {
        return "Report filesystem disk space usage";
    }

    public void printHeader() {
        this.printf(HEADER);
    }

    public void output(String[] args) throws SigarException {
        if (args.length == 1) {
            String name;
            FileSystemMap mounts = this.proxy.getFileSystemMap();
            FileSystem fs = mounts.getMountPoint(name = FileCompleter.expand(args[0]));
            if (fs != null) {
                this.printHeader();
                this.output(fs);
                return;
            }
            throw new SigarException(args[0] + " No such file or directory");
        }
        FileSystem[] fslist = this.proxy.getFileSystemList();
        this.printHeader();
        for (int i = 0; i < fslist.length; ++i) {
            this.output(fslist[i]);
        }
    }

    public void output(FileSystem fs) throws SigarException {
        long pct;
        long total;
        long avail;
        long used;
        try {
            NfsFileSystem nfs;
            if (fs instanceof NfsFileSystem && !(nfs = (NfsFileSystem)fs).ping()) {
                this.println(nfs.getUnreachableMessage());
                return;
            }
            FileSystemUsage usage = this.sigar.getFileSystemUsage(fs.getDirName());
            used = usage.getTotal() - usage.getFree();
            avail = usage.getAvail();
            total = usage.getTotal();
            pct = (long)(usage.getUsePercent() * 100.0);
        }
        catch (SigarException e) {
            pct = 0L;
            total = 0L;
            avail = 0L;
            used = 0L;
        }
        String usePct = pct == 0L ? "-" : pct + "%";
        ArrayList<String> items = new ArrayList<String>();
        items.add(fs.getDevName());
        items.add(Df.formatSize(total));
        items.add(Df.formatSize(used));
        items.add(Df.formatSize(avail));
        items.add(usePct);
        items.add(fs.getDirName());
        items.add(fs.getSysTypeName() + "/" + fs.getTypeName());
        this.printf(items);
    }

    private static String formatSize(long size) {
        return Sigar.formatSize(size * 1024L);
    }

    public static void main(String[] args) throws Exception {
        new Df().processCommand(args);
    }
}

