/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

public class HTMLEntitiesParser {
    public static final int STATE_START = 0;
    private static final int STATE_ENDS_WITH_SEMICOLON = -2;
    private static final int STATE_HEXADECIMAL_CHAR = -102;
    private static final int STATE_DECIMAL_CHAR = -104;
    private static final int STATE_NUMERIC_CHAR_END_SEMICOLON_MISSING = -105;
    private int state = 0;
    private int consumedCount;
    private String match;
    private int code;
    private int matchLength;

    public String getMatch() {
        return this.match;
    }

    public int getMatchLength() {
        return this.matchLength;
    }

    public int getRewindCount() {
        return this.consumedCount - this.matchLength;
    }

    public boolean endsWithSemicolon() {
        return -2 == this.state;
    }

    public void setMatchFromCode() {
        if (this.code == 0 || this.code > 0x10FFFF) {
            this.match = "\ufffd";
            this.matchLength = this.consumedCount;
            return;
        }
        if (Character.isSurrogate((char)this.code)) {
            this.match = "\ufffd";
            return;
        }
        switch (this.code) {
            case 128: {
                this.match = "\u20ac";
                this.matchLength = this.consumedCount;
                return;
            }
            case 130: {
                this.match = "\u201a";
                this.matchLength = this.consumedCount;
                return;
            }
            case 131: {
                this.match = "\u0192";
                this.matchLength = this.consumedCount;
                return;
            }
            case 132: {
                this.match = "\u201e";
                this.matchLength = this.consumedCount;
                return;
            }
            case 133: {
                this.match = "\u2026";
                this.matchLength = this.consumedCount;
                return;
            }
            case 134: {
                this.match = "\u2020";
                this.matchLength = this.consumedCount;
                return;
            }
            case 135: {
                this.match = "\u2021";
                this.matchLength = this.consumedCount;
                return;
            }
            case 136: {
                this.match = "\u02c6";
                this.matchLength = this.consumedCount;
                return;
            }
            case 137: {
                this.match = "\u2030";
                this.matchLength = this.consumedCount;
                return;
            }
            case 138: {
                this.match = "\u0160";
                this.matchLength = this.consumedCount;
                return;
            }
            case 139: {
                this.match = "\u2039";
                this.matchLength = this.consumedCount;
                return;
            }
            case 140: {
                this.match = "\u0152";
                this.matchLength = this.consumedCount;
                return;
            }
            case 142: {
                this.match = "\u017d";
                this.matchLength = this.consumedCount;
                return;
            }
            case 145: {
                this.match = "\u2018";
                this.matchLength = this.consumedCount;
                return;
            }
            case 146: {
                this.match = "\u2019";
                this.matchLength = this.consumedCount;
                return;
            }
            case 147: {
                this.match = "\u201c";
                this.matchLength = this.consumedCount;
                return;
            }
            case 148: {
                this.match = "\u201d";
                this.matchLength = this.consumedCount;
                return;
            }
            case 149: {
                this.match = "\u2022";
                this.matchLength = this.consumedCount;
                return;
            }
            case 150: {
                this.match = "\u2013";
                this.matchLength = this.consumedCount;
                return;
            }
            case 151: {
                this.match = "\u2014";
                this.matchLength = this.consumedCount;
                return;
            }
            case 152: {
                this.match = "\u20dc";
                this.matchLength = this.consumedCount;
                return;
            }
            case 153: {
                this.match = "\u2122";
                this.matchLength = this.consumedCount;
                return;
            }
            case 154: {
                this.match = "\u0161";
                this.matchLength = this.consumedCount;
                return;
            }
            case 155: {
                this.match = "\u203a";
                this.matchLength = this.consumedCount;
                return;
            }
            case 156: {
                this.match = "\u0153";
                this.matchLength = this.consumedCount;
                return;
            }
            case 158: {
                this.match = "\u017e";
                this.matchLength = this.consumedCount;
                return;
            }
            case 159: {
                this.match = "\u0178";
                this.matchLength = this.consumedCount;
                return;
            }
        }
        this.match = new String(Character.toChars(this.code));
        this.matchLength = this.consumedCount;
    }

    public boolean parseNumeric(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 0: {
                if (88 == current || 120 == current) {
                    this.state = -102;
                    return true;
                }
                if (48 > current || current > 57) break;
                this.state = -104;
                this.code = this.code * 10 + current - 48;
                return true;
            }
            case -102: {
                if (48 <= current && current <= 57) {
                    this.code = this.code * 16 + current - 48;
                    return true;
                }
                if (65 <= current && current <= 70) {
                    this.code = this.code * 16 + current - 55;
                    return true;
                }
                if (97 <= current && current <= 102) {
                    this.code = this.code * 16 + current - 87;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state = -105;
                this.setMatchFromCode();
                this.matchLength = this.consumedCount - 1;
                break;
            }
            case -104: {
                if (48 <= current && current <= 57) {
                    this.code = this.code * 10 + current - 48;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state = -105;
                this.setMatchFromCode();
                this.matchLength = this.consumedCount - 1;
            }
        }
        return false;
    }

    private boolean parse1(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 0: {
                switch (current) {
                    case 65: {
                        this.state = 1;
                        return true;
                    }
                    case 66: {
                        this.state = 77;
                        return true;
                    }
                    case 67: {
                        this.state = 126;
                        return true;
                    }
                    case 68: {
                        this.state = 342;
                        return true;
                    }
                    case 69: {
                        this.state = 666;
                        return true;
                    }
                    case 70: {
                        this.state = 788;
                        return true;
                    }
                    case 71: {
                        this.state = 842;
                        return true;
                    }
                    case 72: {
                        this.state = 929;
                        return true;
                    }
                    case 73: {
                        this.state = 995;
                        return true;
                    }
                    case 74: {
                        this.state = 1096;
                        return true;
                    }
                    case 75: {
                        this.state = 1118;
                        return true;
                    }
                    case 76: {
                        this.state = 1143;
                        return true;
                    }
                    case 77: {
                        this.state = 1514;
                        return true;
                    }
                    case 78: {
                        this.state = 1553;
                        return true;
                    }
                    case 79: {
                        this.state = 2064;
                        return true;
                    }
                    case 80: {
                        this.state = 2173;
                        return true;
                    }
                    case 81: {
                        this.state = 2258;
                        return true;
                    }
                    case 82: {
                        this.state = 2270;
                        return true;
                    }
                    case 83: {
                        this.state = 2525;
                        return true;
                    }
                    case 84: {
                        this.state = 2722;
                        return true;
                    }
                    case 85: {
                        this.state = 2817;
                        return true;
                    }
                    case 86: {
                        this.state = 2997;
                        return true;
                    }
                    case 87: {
                        this.state = 3067;
                        return true;
                    }
                    case 88: {
                        this.state = 3084;
                        return true;
                    }
                    case 89: {
                        this.state = 3094;
                        return true;
                    }
                    case 90: {
                        this.state = 3125;
                        return true;
                    }
                    case 97: {
                        this.state = 3166;
                        return true;
                    }
                    case 98: {
                        this.state = 3311;
                        return true;
                    }
                    case 99: {
                        this.state = 3623;
                        return true;
                    }
                    case 100: {
                        this.state = 3915;
                        return true;
                    }
                    case 101: {
                        this.state = 4156;
                        return true;
                    }
                    case 102: {
                        this.state = 4342;
                        return true;
                    }
                    case 103: {
                        this.state = 4442;
                        return true;
                    }
                    case 104: {
                        this.state = 4588;
                        return true;
                    }
                    case 105: {
                        this.state = 4704;
                        return true;
                    }
                    case 106: {
                        this.state = 4847;
                        return true;
                    }
                    case 107: {
                        this.state = 4873;
                        return true;
                    }
                    case 108: {
                        this.state = 4904;
                        return true;
                    }
                    case 109: {
                        this.state = 5397;
                        return true;
                    }
                    case 110: {
                        this.state = 5510;
                        return true;
                    }
                    case 111: {
                        this.state = 5945;
                        return true;
                    }
                    case 112: {
                        this.state = 6092;
                        return true;
                    }
                    case 113: {
                        this.state = 6272;
                        return true;
                    }
                    case 114: {
                        this.state = 6309;
                        return true;
                    }
                    case 115: {
                        this.state = 6642;
                        return true;
                    }
                    case 116: {
                        this.state = 7043;
                        return true;
                    }
                    case 117: {
                        this.state = 7238;
                        return true;
                    }
                    case 118: {
                        this.state = 7408;
                        return true;
                    }
                    case 119: {
                        this.state = 7562;
                        return true;
                    }
                    case 120: {
                        this.state = 7593;
                        return true;
                    }
                    case 121: {
                        this.state = 7672;
                        return true;
                    }
                    case 122: {
                        this.state = 7702;
                        return true;
                    }
                }
                break;
            }
            case 1: {
                switch (current) {
                    case 69: {
                        this.state = 2;
                        return true;
                    }
                    case 77: {
                        this.state = 6;
                        return true;
                    }
                    case 97: {
                        this.state = 8;
                        return true;
                    }
                    case 98: {
                        this.state = 13;
                        return true;
                    }
                    case 99: {
                        this.state = 18;
                        return true;
                    }
                    case 102: {
                        this.state = 23;
                        return true;
                    }
                    case 103: {
                        this.state = 25;
                        return true;
                    }
                    case 108: {
                        this.state = 30;
                        return true;
                    }
                    case 109: {
                        this.state = 34;
                        return true;
                    }
                    case 110: {
                        this.state = 38;
                        return true;
                    }
                    case 111: {
                        this.state = 40;
                        return true;
                    }
                    case 112: {
                        this.state = 46;
                        return true;
                    }
                    case 114: {
                        this.state = 58;
                        return true;
                    }
                    case 115: {
                        this.state = 62;
                        return true;
                    }
                    case 116: {
                        this.state = 69;
                        return true;
                    }
                    case 117: {
                        this.state = 74;
                        return true;
                    }
                }
                break;
            }
            case 2: {
                if (108 != current) break;
                this.state = 3;
                return true;
            }
            case 3: {
                if (105 != current) break;
                this.state = 4;
                return true;
            }
            case 4: {
                if (103 != current) break;
                this.match = "\u00c6";
                this.matchLength = this.consumedCount;
                this.state = 5;
                return true;
            }
            case 5: {
                if (59 != current) break;
                this.match = "\u00c6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 6: {
                if (80 != current) break;
                this.match = "&";
                this.matchLength = this.consumedCount;
                this.state = 7;
                return true;
            }
            case 7: {
                if (59 != current) break;
                this.match = "&";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 8: {
                if (99 != current) break;
                this.state = 9;
                return true;
            }
            case 9: {
                if (117 != current) break;
                this.state = 10;
                return true;
            }
            case 10: {
                if (116 != current) break;
                this.state = 11;
                return true;
            }
            case 11: {
                if (101 != current) break;
                this.match = "\u00c1";
                this.matchLength = this.consumedCount;
                this.state = 12;
                return true;
            }
            case 12: {
                if (59 != current) break;
                this.match = "\u00c1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 13: {
                if (114 != current) break;
                this.state = 14;
                return true;
            }
            case 14: {
                if (101 != current) break;
                this.state = 15;
                return true;
            }
            case 15: {
                if (118 != current) break;
                this.state = 16;
                return true;
            }
            case 16: {
                if (101 != current) break;
                this.state = 17;
                return true;
            }
            case 17: {
                if (59 != current) break;
                this.match = "\u0102";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 18: {
                if (105 == current) {
                    this.state = 19;
                    return true;
                }
                if (121 != current) break;
                this.state = 22;
                return true;
            }
            case 19: {
                if (114 != current) break;
                this.state = 20;
                return true;
            }
            case 20: {
                if (99 != current) break;
                this.match = "\u00c2";
                this.matchLength = this.consumedCount;
                this.state = 21;
                return true;
            }
            case 21: {
                if (59 != current) break;
                this.match = "\u00c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 22: {
                if (59 != current) break;
                this.match = "\u0410";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 23: {
                if (114 != current) break;
                this.state = 24;
                return true;
            }
            case 24: {
                if (59 != current) break;
                this.match = "\ud835\udd04";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 25: {
                if (114 != current) break;
                this.state = 26;
                return true;
            }
            case 26: {
                if (97 != current) break;
                this.state = 27;
                return true;
            }
            case 27: {
                if (118 != current) break;
                this.state = 28;
                return true;
            }
            case 28: {
                if (101 != current) break;
                this.match = "\u00c0";
                this.matchLength = this.consumedCount;
                this.state = 29;
                return true;
            }
            case 29: {
                if (59 != current) break;
                this.match = "\u00c0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 30: {
                if (112 != current) break;
                this.state = 31;
                return true;
            }
            case 31: {
                if (104 != current) break;
                this.state = 32;
                return true;
            }
            case 32: {
                if (97 != current) break;
                this.state = 33;
                return true;
            }
            case 33: {
                if (59 != current) break;
                this.match = "\u0391";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 34: {
                if (97 != current) break;
                this.state = 35;
                return true;
            }
            case 35: {
                if (99 != current) break;
                this.state = 36;
                return true;
            }
            case 36: {
                if (114 != current) break;
                this.state = 37;
                return true;
            }
            case 37: {
                if (59 != current) break;
                this.match = "\u0100";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 38: {
                if (100 != current) break;
                this.state = 39;
                return true;
            }
            case 39: {
                if (59 != current) break;
                this.match = "\u2a53";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 40: {
                if (103 == current) {
                    this.state = 41;
                    return true;
                }
                if (112 != current) break;
                this.state = 44;
                return true;
            }
            case 41: {
                if (111 != current) break;
                this.state = 42;
                return true;
            }
            case 42: {
                if (110 != current) break;
                this.state = 43;
                return true;
            }
            case 43: {
                if (59 != current) break;
                this.match = "\u0104";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 44: {
                if (102 != current) break;
                this.state = 45;
                return true;
            }
            case 45: {
                if (59 != current) break;
                this.match = "\ud835\udd38";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 46: {
                if (112 != current) break;
                this.state = 47;
                return true;
            }
            case 47: {
                if (108 != current) break;
                this.state = 48;
                return true;
            }
            case 48: {
                if (121 != current) break;
                this.state = 49;
                return true;
            }
            case 49: {
                if (70 != current) break;
                this.state = 50;
                return true;
            }
            case 50: {
                if (117 != current) break;
                this.state = 51;
                return true;
            }
            case 51: {
                if (110 != current) break;
                this.state = 52;
                return true;
            }
            case 52: {
                if (99 != current) break;
                this.state = 53;
                return true;
            }
            case 53: {
                if (116 != current) break;
                this.state = 54;
                return true;
            }
            case 54: {
                if (105 != current) break;
                this.state = 55;
                return true;
            }
            case 55: {
                if (111 != current) break;
                this.state = 56;
                return true;
            }
            case 56: {
                if (110 != current) break;
                this.state = 57;
                return true;
            }
            case 57: {
                if (59 != current) break;
                this.match = "\u2061";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 58: {
                if (105 != current) break;
                this.state = 59;
                return true;
            }
            case 59: {
                if (110 != current) break;
                this.state = 60;
                return true;
            }
            case 60: {
                if (103 != current) break;
                this.match = "\u00c5";
                this.matchLength = this.consumedCount;
                this.state = 61;
                return true;
            }
            case 61: {
                if (59 != current) break;
                this.match = "\u00c5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 62: {
                if (99 == current) {
                    this.state = 63;
                    return true;
                }
                if (115 != current) break;
                this.state = 65;
                return true;
            }
            case 63: {
                if (114 != current) break;
                this.state = 64;
                return true;
            }
            case 64: {
                if (59 != current) break;
                this.match = "\ud835\udc9c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 65: {
                if (105 != current) break;
                this.state = 66;
                return true;
            }
            case 66: {
                if (103 != current) break;
                this.state = 67;
                return true;
            }
            case 67: {
                if (110 != current) break;
                this.state = 68;
                return true;
            }
            case 68: {
                if (59 != current) break;
                this.match = "\u2254";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 69: {
                if (105 != current) break;
                this.state = 70;
                return true;
            }
            case 70: {
                if (108 != current) break;
                this.state = 71;
                return true;
            }
            case 71: {
                if (100 != current) break;
                this.state = 72;
                return true;
            }
            case 72: {
                if (101 != current) break;
                this.match = "\u00c3";
                this.matchLength = this.consumedCount;
                this.state = 73;
                return true;
            }
            case 73: {
                if (59 != current) break;
                this.match = "\u00c3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 74: {
                if (109 != current) break;
                this.state = 75;
                return true;
            }
            case 75: {
                if (108 != current) break;
                this.match = "\u00c4";
                this.matchLength = this.consumedCount;
                this.state = 76;
                return true;
            }
            case 76: {
                if (59 != current) break;
                this.match = "\u00c4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 77: {
                switch (current) {
                    case 97: {
                        this.state = 78;
                        return true;
                    }
                    case 99: {
                        this.state = 91;
                        return true;
                    }
                    case 101: {
                        this.state = 93;
                        return true;
                    }
                    case 102: {
                        this.state = 109;
                        return true;
                    }
                    case 111: {
                        this.state = 111;
                        return true;
                    }
                    case 114: {
                        this.state = 114;
                        return true;
                    }
                    case 115: {
                        this.state = 118;
                        return true;
                    }
                    case 117: {
                        this.state = 121;
                        return true;
                    }
                }
                break;
            }
            case 78: {
                if (99 == current) {
                    this.state = 79;
                    return true;
                }
                if (114 != current) break;
                this.state = 86;
                return true;
            }
            case 79: {
                if (107 != current) break;
                this.state = 80;
                return true;
            }
            case 80: {
                if (115 != current) break;
                this.state = 81;
                return true;
            }
            case 81: {
                if (108 != current) break;
                this.state = 82;
                return true;
            }
            case 82: {
                if (97 != current) break;
                this.state = 83;
                return true;
            }
            case 83: {
                if (115 != current) break;
                this.state = 84;
                return true;
            }
            case 84: {
                if (104 != current) break;
                this.state = 85;
                return true;
            }
            case 85: {
                if (59 != current) break;
                this.match = "\u2216";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 86: {
                if (118 == current) {
                    this.state = 87;
                    return true;
                }
                if (119 != current) break;
                this.state = 88;
                return true;
            }
            case 87: {
                if (59 != current) break;
                this.match = "\u2ae7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 88: {
                if (101 != current) break;
                this.state = 89;
                return true;
            }
            case 89: {
                if (100 != current) break;
                this.state = 90;
                return true;
            }
            case 90: {
                if (59 != current) break;
                this.match = "\u2306";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 91: {
                if (121 != current) break;
                this.state = 92;
                return true;
            }
            case 92: {
                if (59 != current) break;
                this.match = "\u0411";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 93: {
                switch (current) {
                    case 99: {
                        this.state = 94;
                        return true;
                    }
                    case 114: {
                        this.state = 99;
                        return true;
                    }
                    case 116: {
                        this.state = 107;
                        return true;
                    }
                }
                break;
            }
            case 94: {
                if (97 != current) break;
                this.state = 95;
                return true;
            }
            case 95: {
                if (117 != current) break;
                this.state = 96;
                return true;
            }
            case 96: {
                if (115 != current) break;
                this.state = 97;
                return true;
            }
            case 97: {
                if (101 != current) break;
                this.state = 98;
                return true;
            }
            case 98: {
                if (59 != current) break;
                this.match = "\u2235";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 99: {
                if (110 != current) break;
                this.state = 100;
                return true;
            }
            case 100: {
                if (111 != current) break;
                this.state = 101;
                return true;
            }
            case 101: {
                if (117 != current) break;
                this.state = 102;
                return true;
            }
            case 102: {
                if (108 != current) break;
                this.state = 103;
                return true;
            }
            case 103: {
                if (108 != current) break;
                this.state = 104;
                return true;
            }
            case 104: {
                if (105 != current) break;
                this.state = 105;
                return true;
            }
            case 105: {
                if (115 != current) break;
                this.state = 106;
                return true;
            }
            case 106: {
                if (59 != current) break;
                this.match = "\u212c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 107: {
                if (97 != current) break;
                this.state = 108;
                return true;
            }
            case 108: {
                if (59 != current) break;
                this.match = "\u0392";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 109: {
                if (114 != current) break;
                this.state = 110;
                return true;
            }
            case 110: {
                if (59 != current) break;
                this.match = "\ud835\udd05";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 111: {
                if (112 != current) break;
                this.state = 112;
                return true;
            }
            case 112: {
                if (102 != current) break;
                this.state = 113;
                return true;
            }
            case 113: {
                if (59 != current) break;
                this.match = "\ud835\udd39";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 114: {
                if (101 != current) break;
                this.state = 115;
                return true;
            }
            case 115: {
                if (118 != current) break;
                this.state = 116;
                return true;
            }
            case 116: {
                if (101 != current) break;
                this.state = 117;
                return true;
            }
            case 117: {
                if (59 != current) break;
                this.match = "\u02d8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 118: {
                if (99 != current) break;
                this.state = 119;
                return true;
            }
            case 119: {
                if (114 != current) break;
                this.state = 120;
                return true;
            }
            case 120: {
                if (59 != current) break;
                this.match = "\u212c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 121: {
                if (109 != current) break;
                this.state = 122;
                return true;
            }
            case 122: {
                if (112 != current) break;
                this.state = 123;
                return true;
            }
            case 123: {
                if (101 != current) break;
                this.state = 124;
                return true;
            }
            case 124: {
                if (113 != current) break;
                this.state = 125;
                return true;
            }
            case 125: {
                if (59 != current) break;
                this.match = "\u224e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 126: {
                switch (current) {
                    case 72: {
                        this.state = 127;
                        return true;
                    }
                    case 79: {
                        this.state = 130;
                        return true;
                    }
                    case 97: {
                        this.state = 133;
                        return true;
                    }
                    case 99: {
                        this.state = 161;
                        return true;
                    }
                    case 100: {
                        this.state = 178;
                        return true;
                    }
                    case 101: {
                        this.state = 181;
                        return true;
                    }
                    case 102: {
                        this.state = 194;
                        return true;
                    }
                    case 104: {
                        this.state = 196;
                        return true;
                    }
                    case 105: {
                        this.state = 198;
                        return true;
                    }
                    case 108: {
                        this.state = 220;
                        return true;
                    }
                    case 111: {
                        this.state = 266;
                        return true;
                    }
                    case 114: {
                        this.state = 330;
                        return true;
                    }
                    case 115: {
                        this.state = 334;
                        return true;
                    }
                    case 117: {
                        this.state = 337;
                        return true;
                    }
                }
                break;
            }
            case 127: {
                if (99 != current) break;
                this.state = 128;
                return true;
            }
            case 128: {
                if (121 != current) break;
                this.state = 129;
                return true;
            }
            case 129: {
                if (59 != current) break;
                this.match = "\u0427";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 130: {
                if (80 != current) break;
                this.state = 131;
                return true;
            }
            case 131: {
                if (89 != current) break;
                this.match = "\u00a9";
                this.matchLength = this.consumedCount;
                this.state = 132;
                return true;
            }
            case 132: {
                if (59 != current) break;
                this.match = "\u00a9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 133: {
                switch (current) {
                    case 99: {
                        this.state = 134;
                        return true;
                    }
                    case 112: {
                        this.state = 138;
                        return true;
                    }
                    case 121: {
                        this.state = 156;
                        return true;
                    }
                }
                break;
            }
            case 134: {
                if (117 != current) break;
                this.state = 135;
                return true;
            }
            case 135: {
                if (116 != current) break;
                this.state = 136;
                return true;
            }
            case 136: {
                if (101 != current) break;
                this.state = 137;
                return true;
            }
            case 137: {
                if (59 != current) break;
                this.match = "\u0106";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 138: {
                if (59 == current) {
                    this.match = "\u22d2";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (105 != current) break;
                this.state = 139;
                return true;
            }
            case 139: {
                if (116 != current) break;
                this.state = 140;
                return true;
            }
            case 140: {
                if (97 != current) break;
                this.state = 141;
                return true;
            }
            case 141: {
                if (108 != current) break;
                this.state = 142;
                return true;
            }
            case 142: {
                if (68 != current) break;
                this.state = 143;
                return true;
            }
            case 143: {
                if (105 != current) break;
                this.state = 144;
                return true;
            }
            case 144: {
                if (102 != current) break;
                this.state = 145;
                return true;
            }
            case 145: {
                if (102 != current) break;
                this.state = 146;
                return true;
            }
            case 146: {
                if (101 != current) break;
                this.state = 147;
                return true;
            }
            case 147: {
                if (114 != current) break;
                this.state = 148;
                return true;
            }
            case 148: {
                if (101 != current) break;
                this.state = 149;
                return true;
            }
            case 149: {
                if (110 != current) break;
                this.state = 150;
                return true;
            }
            case 150: {
                if (116 != current) break;
                this.state = 151;
                return true;
            }
            case 151: {
                if (105 != current) break;
                this.state = 152;
                return true;
            }
            case 152: {
                if (97 != current) break;
                this.state = 153;
                return true;
            }
            case 153: {
                if (108 != current) break;
                this.state = 154;
                return true;
            }
            case 154: {
                if (68 != current) break;
                this.state = 155;
                return true;
            }
            case 155: {
                if (59 != current) break;
                this.match = "\u2145";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 156: {
                if (108 != current) break;
                this.state = 157;
                return true;
            }
            case 157: {
                if (101 != current) break;
                this.state = 158;
                return true;
            }
            case 158: {
                if (121 != current) break;
                this.state = 159;
                return true;
            }
            case 159: {
                if (115 != current) break;
                this.state = 160;
                return true;
            }
            case 160: {
                if (59 != current) break;
                this.match = "\u212d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 161: {
                switch (current) {
                    case 97: {
                        this.state = 162;
                        return true;
                    }
                    case 101: {
                        this.state = 166;
                        return true;
                    }
                    case 105: {
                        this.state = 170;
                        return true;
                    }
                    case 111: {
                        this.state = 173;
                        return true;
                    }
                }
                break;
            }
            case 162: {
                if (114 != current) break;
                this.state = 163;
                return true;
            }
            case 163: {
                if (111 != current) break;
                this.state = 164;
                return true;
            }
            case 164: {
                if (110 != current) break;
                this.state = 165;
                return true;
            }
            case 165: {
                if (59 != current) break;
                this.match = "\u010c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 166: {
                if (100 != current) break;
                this.state = 167;
                return true;
            }
            case 167: {
                if (105 != current) break;
                this.state = 168;
                return true;
            }
            case 168: {
                if (108 != current) break;
                this.match = "\u00c7";
                this.matchLength = this.consumedCount;
                this.state = 169;
                return true;
            }
            case 169: {
                if (59 != current) break;
                this.match = "\u00c7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 170: {
                if (114 != current) break;
                this.state = 171;
                return true;
            }
            case 171: {
                if (99 != current) break;
                this.state = 172;
                return true;
            }
            case 172: {
                if (59 != current) break;
                this.match = "\u0108";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 173: {
                if (110 != current) break;
                this.state = 174;
                return true;
            }
            case 174: {
                if (105 != current) break;
                this.state = 175;
                return true;
            }
            case 175: {
                if (110 != current) break;
                this.state = 176;
                return true;
            }
            case 176: {
                if (116 != current) break;
                this.state = 177;
                return true;
            }
            case 177: {
                if (59 != current) break;
                this.match = "\u2230";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 178: {
                if (111 != current) break;
                this.state = 179;
                return true;
            }
            case 179: {
                if (116 != current) break;
                this.state = 180;
                return true;
            }
            case 180: {
                if (59 != current) break;
                this.match = "\u010a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 181: {
                if (100 == current) {
                    this.state = 182;
                    return true;
                }
                if (110 != current) break;
                this.state = 187;
                return true;
            }
            case 182: {
                if (105 != current) break;
                this.state = 183;
                return true;
            }
            case 183: {
                if (108 != current) break;
                this.state = 184;
                return true;
            }
            case 184: {
                if (108 != current) break;
                this.state = 185;
                return true;
            }
            case 185: {
                if (97 != current) break;
                this.state = 186;
                return true;
            }
            case 186: {
                if (59 != current) break;
                this.match = "\u00b8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 187: {
                if (116 != current) break;
                this.state = 188;
                return true;
            }
            case 188: {
                if (101 != current) break;
                this.state = 189;
                return true;
            }
            case 189: {
                if (114 != current) break;
                this.state = 190;
                return true;
            }
            case 190: {
                if (68 != current) break;
                this.state = 191;
                return true;
            }
            case 191: {
                if (111 != current) break;
                this.state = 192;
                return true;
            }
            case 192: {
                if (116 != current) break;
                this.state = 193;
                return true;
            }
            case 193: {
                if (59 != current) break;
                this.match = "\u00b7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 194: {
                if (114 != current) break;
                this.state = 195;
                return true;
            }
            case 195: {
                if (59 != current) break;
                this.match = "\u212d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 196: {
                if (105 != current) break;
                this.state = 197;
                return true;
            }
            case 197: {
                if (59 != current) break;
                this.match = "\u03a7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 198: {
                if (114 != current) break;
                this.state = 199;
                return true;
            }
            case 199: {
                if (99 != current) break;
                this.state = 200;
                return true;
            }
            case 200: {
                if (108 != current) break;
                this.state = 201;
                return true;
            }
            case 201: {
                if (101 != current) break;
                this.state = 202;
                return true;
            }
            case 202: {
                switch (current) {
                    case 68: {
                        this.state = 203;
                        return true;
                    }
                    case 77: {
                        this.state = 206;
                        return true;
                    }
                    case 80: {
                        this.state = 211;
                        return true;
                    }
                    case 84: {
                        this.state = 215;
                        return true;
                    }
                }
                break;
            }
            case 203: {
                if (111 != current) break;
                this.state = 204;
                return true;
            }
            case 204: {
                if (116 != current) break;
                this.state = 205;
                return true;
            }
            case 205: {
                if (59 != current) break;
                this.match = "\u2299";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 206: {
                if (105 != current) break;
                this.state = 207;
                return true;
            }
            case 207: {
                if (110 != current) break;
                this.state = 208;
                return true;
            }
            case 208: {
                if (117 != current) break;
                this.state = 209;
                return true;
            }
            case 209: {
                if (115 != current) break;
                this.state = 210;
                return true;
            }
            case 210: {
                if (59 != current) break;
                this.match = "\u2296";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 211: {
                if (108 != current) break;
                this.state = 212;
                return true;
            }
            case 212: {
                if (117 != current) break;
                this.state = 213;
                return true;
            }
            case 213: {
                if (115 != current) break;
                this.state = 214;
                return true;
            }
            case 214: {
                if (59 != current) break;
                this.match = "\u2295";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 215: {
                if (105 != current) break;
                this.state = 216;
                return true;
            }
            case 216: {
                if (109 != current) break;
                this.state = 217;
                return true;
            }
            case 217: {
                if (101 != current) break;
                this.state = 218;
                return true;
            }
            case 218: {
                if (115 != current) break;
                this.state = 219;
                return true;
            }
            case 219: {
                if (59 != current) break;
                this.match = "\u2297";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 220: {
                if (111 != current) break;
                this.state = 221;
                return true;
            }
            case 221: {
                if (99 == current) {
                    this.state = 222;
                    return true;
                }
                if (115 != current) break;
                this.state = 243;
                return true;
            }
            case 222: {
                if (107 != current) break;
                this.state = 223;
                return true;
            }
            case 223: {
                if (119 != current) break;
                this.state = 224;
                return true;
            }
            case 224: {
                if (105 != current) break;
                this.state = 225;
                return true;
            }
            case 225: {
                if (115 != current) break;
                this.state = 226;
                return true;
            }
            case 226: {
                if (101 != current) break;
                this.state = 227;
                return true;
            }
            case 227: {
                if (67 != current) break;
                this.state = 228;
                return true;
            }
            case 228: {
                if (111 != current) break;
                this.state = 229;
                return true;
            }
            case 229: {
                if (110 != current) break;
                this.state = 230;
                return true;
            }
            case 230: {
                if (116 != current) break;
                this.state = 231;
                return true;
            }
            case 231: {
                if (111 != current) break;
                this.state = 232;
                return true;
            }
            case 232: {
                if (117 != current) break;
                this.state = 233;
                return true;
            }
            case 233: {
                if (114 != current) break;
                this.state = 234;
                return true;
            }
            case 234: {
                if (73 != current) break;
                this.state = 235;
                return true;
            }
            case 235: {
                if (110 != current) break;
                this.state = 236;
                return true;
            }
            case 236: {
                if (116 != current) break;
                this.state = 237;
                return true;
            }
            case 237: {
                if (101 != current) break;
                this.state = 238;
                return true;
            }
            case 238: {
                if (103 != current) break;
                this.state = 239;
                return true;
            }
            case 239: {
                if (114 != current) break;
                this.state = 240;
                return true;
            }
            case 240: {
                if (97 != current) break;
                this.state = 241;
                return true;
            }
            case 241: {
                if (108 != current) break;
                this.state = 242;
                return true;
            }
            case 242: {
                if (59 != current) break;
                this.match = "\u2232";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 243: {
                if (101 != current) break;
                this.state = 244;
                return true;
            }
            case 244: {
                if (67 != current) break;
                this.state = 245;
                return true;
            }
            case 245: {
                if (117 != current) break;
                this.state = 246;
                return true;
            }
            case 246: {
                if (114 != current) break;
                this.state = 247;
                return true;
            }
            case 247: {
                if (108 != current) break;
                this.state = 248;
                return true;
            }
            case 248: {
                if (121 != current) break;
                this.state = 249;
                return true;
            }
            case 249: {
                if (68 == current) {
                    this.state = 250;
                    return true;
                }
                if (81 != current) break;
                this.state = 261;
                return true;
            }
            case 250: {
                if (111 != current) break;
                this.state = 251;
                return true;
            }
            case 251: {
                if (117 != current) break;
                this.state = 252;
                return true;
            }
            case 252: {
                if (98 != current) break;
                this.state = 253;
                return true;
            }
            case 253: {
                if (108 != current) break;
                this.state = 254;
                return true;
            }
            case 254: {
                if (101 != current) break;
                this.state = 255;
                return true;
            }
            case 255: {
                if (81 != current) break;
                this.state = 256;
                return true;
            }
            case 256: {
                if (117 != current) break;
                this.state = 257;
                return true;
            }
            case 257: {
                if (111 != current) break;
                this.state = 258;
                return true;
            }
            case 258: {
                if (116 != current) break;
                this.state = 259;
                return true;
            }
            case 259: {
                if (101 != current) break;
                this.state = 260;
                return true;
            }
            case 260: {
                if (59 != current) break;
                this.match = "\u201d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 261: {
                if (117 != current) break;
                this.state = 262;
                return true;
            }
            case 262: {
                if (111 != current) break;
                this.state = 263;
                return true;
            }
            case 263: {
                if (116 != current) break;
                this.state = 264;
                return true;
            }
            case 264: {
                if (101 != current) break;
                this.state = 265;
                return true;
            }
            case 265: {
                if (59 != current) break;
                this.match = "\u2019";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 266: {
                switch (current) {
                    case 108: {
                        this.state = 267;
                        return true;
                    }
                    case 110: {
                        this.state = 271;
                        return true;
                    }
                    case 112: {
                        this.state = 293;
                        return true;
                    }
                    case 117: {
                        this.state = 301;
                        return true;
                    }
                }
                break;
            }
            case 267: {
                if (111 != current) break;
                this.state = 268;
                return true;
            }
            case 268: {
                if (110 != current) break;
                this.state = 269;
                return true;
            }
            case 269: {
                if (59 == current) {
                    this.match = "\u2237";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 270;
                return true;
            }
            case 270: {
                if (59 != current) break;
                this.match = "\u2a74";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 271: {
                switch (current) {
                    case 103: {
                        this.state = 272;
                        return true;
                    }
                    case 105: {
                        this.state = 278;
                        return true;
                    }
                    case 116: {
                        this.state = 281;
                        return true;
                    }
                }
                break;
            }
            case 272: {
                if (114 != current) break;
                this.state = 273;
                return true;
            }
            case 273: {
                if (117 != current) break;
                this.state = 274;
                return true;
            }
            case 274: {
                if (101 != current) break;
                this.state = 275;
                return true;
            }
            case 275: {
                if (110 != current) break;
                this.state = 276;
                return true;
            }
            case 276: {
                if (116 != current) break;
                this.state = 277;
                return true;
            }
            case 277: {
                if (59 != current) break;
                this.match = "\u2261";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 278: {
                if (110 != current) break;
                this.state = 279;
                return true;
            }
            case 279: {
                if (116 != current) break;
                this.state = 280;
                return true;
            }
            case 280: {
                if (59 != current) break;
                this.match = "\u222f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 281: {
                if (111 != current) break;
                this.state = 282;
                return true;
            }
            case 282: {
                if (117 != current) break;
                this.state = 283;
                return true;
            }
            case 283: {
                if (114 != current) break;
                this.state = 284;
                return true;
            }
            case 284: {
                if (73 != current) break;
                this.state = 285;
                return true;
            }
            case 285: {
                if (110 != current) break;
                this.state = 286;
                return true;
            }
            case 286: {
                if (116 != current) break;
                this.state = 287;
                return true;
            }
            case 287: {
                if (101 != current) break;
                this.state = 288;
                return true;
            }
            case 288: {
                if (103 != current) break;
                this.state = 289;
                return true;
            }
            case 289: {
                if (114 != current) break;
                this.state = 290;
                return true;
            }
            case 290: {
                if (97 != current) break;
                this.state = 291;
                return true;
            }
            case 291: {
                if (108 != current) break;
                this.state = 292;
                return true;
            }
            case 292: {
                if (59 != current) break;
                this.match = "\u222e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 293: {
                if (102 == current) {
                    this.state = 294;
                    return true;
                }
                if (114 != current) break;
                this.state = 295;
                return true;
            }
            case 294: {
                if (59 != current) break;
                this.match = "\u2102";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 295: {
                if (111 != current) break;
                this.state = 296;
                return true;
            }
            case 296: {
                if (100 != current) break;
                this.state = 297;
                return true;
            }
            case 297: {
                if (117 != current) break;
                this.state = 298;
                return true;
            }
            case 298: {
                if (99 != current) break;
                this.state = 299;
                return true;
            }
            case 299: {
                if (116 != current) break;
                this.state = 300;
                return true;
            }
            case 300: {
                if (59 != current) break;
                this.match = "\u2210";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 301: {
                if (110 != current) break;
                this.state = 302;
                return true;
            }
            case 302: {
                if (116 != current) break;
                this.state = 303;
                return true;
            }
            case 303: {
                if (101 != current) break;
                this.state = 304;
                return true;
            }
            case 304: {
                if (114 != current) break;
                this.state = 305;
                return true;
            }
            case 305: {
                if (67 != current) break;
                this.state = 306;
                return true;
            }
            case 306: {
                if (108 != current) break;
                this.state = 307;
                return true;
            }
            case 307: {
                if (111 != current) break;
                this.state = 308;
                return true;
            }
            case 308: {
                if (99 != current) break;
                this.state = 309;
                return true;
            }
            case 309: {
                if (107 != current) break;
                this.state = 310;
                return true;
            }
            case 310: {
                if (119 != current) break;
                this.state = 311;
                return true;
            }
            case 311: {
                if (105 != current) break;
                this.state = 312;
                return true;
            }
            case 312: {
                if (115 != current) break;
                this.state = 313;
                return true;
            }
            case 313: {
                if (101 != current) break;
                this.state = 314;
                return true;
            }
            case 314: {
                if (67 != current) break;
                this.state = 315;
                return true;
            }
            case 315: {
                if (111 != current) break;
                this.state = 316;
                return true;
            }
            case 316: {
                if (110 != current) break;
                this.state = 317;
                return true;
            }
            case 317: {
                if (116 != current) break;
                this.state = 318;
                return true;
            }
            case 318: {
                if (111 != current) break;
                this.state = 319;
                return true;
            }
            case 319: {
                if (117 != current) break;
                this.state = 320;
                return true;
            }
            case 320: {
                if (114 != current) break;
                this.state = 321;
                return true;
            }
            case 321: {
                if (73 != current) break;
                this.state = 322;
                return true;
            }
            case 322: {
                if (110 != current) break;
                this.state = 323;
                return true;
            }
            case 323: {
                if (116 != current) break;
                this.state = 324;
                return true;
            }
            case 324: {
                if (101 != current) break;
                this.state = 325;
                return true;
            }
            case 325: {
                if (103 != current) break;
                this.state = 326;
                return true;
            }
            case 326: {
                if (114 != current) break;
                this.state = 327;
                return true;
            }
            case 327: {
                if (97 != current) break;
                this.state = 328;
                return true;
            }
            case 328: {
                if (108 != current) break;
                this.state = 329;
                return true;
            }
            case 329: {
                if (59 != current) break;
                this.match = "\u2233";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 330: {
                if (111 != current) break;
                this.state = 331;
                return true;
            }
            case 331: {
                if (115 != current) break;
                this.state = 332;
                return true;
            }
            case 332: {
                if (115 != current) break;
                this.state = 333;
                return true;
            }
            case 333: {
                if (59 != current) break;
                this.match = "\u2a2f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 334: {
                if (99 != current) break;
                this.state = 335;
                return true;
            }
            case 335: {
                if (114 != current) break;
                this.state = 336;
                return true;
            }
            case 336: {
                if (59 != current) break;
                this.match = "\ud835\udc9e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 337: {
                if (112 != current) break;
                this.state = 338;
                return true;
            }
            case 338: {
                if (59 == current) {
                    this.match = "\u22d3";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (67 != current) break;
                this.state = 339;
                return true;
            }
            case 339: {
                if (97 != current) break;
                this.state = 340;
                return true;
            }
            case 340: {
                if (112 != current) break;
                this.state = 341;
                return true;
            }
            case 341: {
                if (59 != current) break;
                this.match = "\u224d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 342: {
                switch (current) {
                    case 68: {
                        this.state = 343;
                        return true;
                    }
                    case 74: {
                        this.state = 350;
                        return true;
                    }
                    case 83: {
                        this.state = 353;
                        return true;
                    }
                    case 90: {
                        this.state = 356;
                        return true;
                    }
                    case 97: {
                        this.state = 359;
                        return true;
                    }
                    case 99: {
                        this.state = 369;
                        return true;
                    }
                    case 101: {
                        this.state = 375;
                        return true;
                    }
                    case 102: {
                        this.state = 379;
                        return true;
                    }
                    case 105: {
                        this.state = 381;
                        return true;
                    }
                    case 111: {
                        this.state = 433;
                        return true;
                    }
                    case 115: {
                        this.state = 659;
                        return true;
                    }
                }
                break;
            }
            case 343: {
                if (59 == current) {
                    this.match = "\u2145";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (111 != current) break;
                this.state = 344;
                return true;
            }
            case 344: {
                if (116 != current) break;
                this.state = 345;
                return true;
            }
            case 345: {
                if (114 != current) break;
                this.state = 346;
                return true;
            }
            case 346: {
                if (97 != current) break;
                this.state = 347;
                return true;
            }
            case 347: {
                if (104 != current) break;
                this.state = 348;
                return true;
            }
            case 348: {
                if (100 != current) break;
                this.state = 349;
                return true;
            }
            case 349: {
                if (59 != current) break;
                this.match = "\u2911";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 350: {
                if (99 != current) break;
                this.state = 351;
                return true;
            }
            case 351: {
                if (121 != current) break;
                this.state = 352;
                return true;
            }
            case 352: {
                if (59 != current) break;
                this.match = "\u0402";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 353: {
                if (99 != current) break;
                this.state = 354;
                return true;
            }
            case 354: {
                if (121 != current) break;
                this.state = 355;
                return true;
            }
            case 355: {
                if (59 != current) break;
                this.match = "\u0405";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 356: {
                if (99 != current) break;
                this.state = 357;
                return true;
            }
            case 357: {
                if (121 != current) break;
                this.state = 358;
                return true;
            }
            case 358: {
                if (59 != current) break;
                this.match = "\u040f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 359: {
                switch (current) {
                    case 103: {
                        this.state = 360;
                        return true;
                    }
                    case 114: {
                        this.state = 364;
                        return true;
                    }
                    case 115: {
                        this.state = 366;
                        return true;
                    }
                }
                break;
            }
            case 360: {
                if (103 != current) break;
                this.state = 361;
                return true;
            }
            case 361: {
                if (101 != current) break;
                this.state = 362;
                return true;
            }
            case 362: {
                if (114 != current) break;
                this.state = 363;
                return true;
            }
            case 363: {
                if (59 != current) break;
                this.match = "\u2021";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 364: {
                if (114 != current) break;
                this.state = 365;
                return true;
            }
            case 365: {
                if (59 != current) break;
                this.match = "\u21a1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 366: {
                if (104 != current) break;
                this.state = 367;
                return true;
            }
            case 367: {
                if (118 != current) break;
                this.state = 368;
                return true;
            }
            case 368: {
                if (59 != current) break;
                this.match = "\u2ae4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 369: {
                if (97 == current) {
                    this.state = 370;
                    return true;
                }
                if (121 != current) break;
                this.state = 374;
                return true;
            }
            case 370: {
                if (114 != current) break;
                this.state = 371;
                return true;
            }
            case 371: {
                if (111 != current) break;
                this.state = 372;
                return true;
            }
            case 372: {
                if (110 != current) break;
                this.state = 373;
                return true;
            }
            case 373: {
                if (59 != current) break;
                this.match = "\u010e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 374: {
                if (59 != current) break;
                this.match = "\u0414";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 375: {
                if (108 != current) break;
                this.state = 376;
                return true;
            }
            case 376: {
                if (59 == current) {
                    this.match = "\u2207";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (116 != current) break;
                this.state = 377;
                return true;
            }
            case 377: {
                if (97 != current) break;
                this.state = 378;
                return true;
            }
            case 378: {
                if (59 != current) break;
                this.match = "\u0394";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 379: {
                if (114 != current) break;
                this.state = 380;
                return true;
            }
            case 380: {
                if (59 != current) break;
                this.match = "\ud835\udd07";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 381: {
                if (97 == current) {
                    this.state = 382;
                    return true;
                }
                if (102 != current) break;
                this.state = 422;
                return true;
            }
            case 382: {
                if (99 == current) {
                    this.state = 383;
                    return true;
                }
                if (109 != current) break;
                this.state = 418;
                return true;
            }
            case 383: {
                if (114 != current) break;
                this.state = 384;
                return true;
            }
            case 384: {
                if (105 != current) break;
                this.state = 385;
                return true;
            }
            case 385: {
                if (116 != current) break;
                this.state = 386;
                return true;
            }
            case 386: {
                if (105 != current) break;
                this.state = 387;
                return true;
            }
            case 387: {
                if (99 != current) break;
                this.state = 388;
                return true;
            }
            case 388: {
                if (97 != current) break;
                this.state = 389;
                return true;
            }
            case 389: {
                if (108 != current) break;
                this.state = 390;
                return true;
            }
            case 390: {
                switch (current) {
                    case 65: {
                        this.state = 391;
                        return true;
                    }
                    case 68: {
                        this.state = 396;
                        return true;
                    }
                    case 71: {
                        this.state = 408;
                        return true;
                    }
                    case 84: {
                        this.state = 413;
                        return true;
                    }
                }
                break;
            }
            case 391: {
                if (99 != current) break;
                this.state = 392;
                return true;
            }
            case 392: {
                if (117 != current) break;
                this.state = 393;
                return true;
            }
            case 393: {
                if (116 != current) break;
                this.state = 394;
                return true;
            }
            case 394: {
                if (101 != current) break;
                this.state = 395;
                return true;
            }
            case 395: {
                if (59 != current) break;
                this.match = "\u00b4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 396: {
                if (111 != current) break;
                this.state = 397;
                return true;
            }
            case 397: {
                if (116 == current) {
                    this.state = 398;
                    return true;
                }
                if (117 != current) break;
                this.state = 399;
                return true;
            }
            case 398: {
                if (59 != current) break;
                this.match = "\u02d9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 399: {
                if (98 != current) break;
                this.state = 400;
                return true;
            }
            case 400: {
                if (108 != current) break;
                this.state = 401;
                return true;
            }
            case 401: {
                if (101 != current) break;
                this.state = 402;
                return true;
            }
            case 402: {
                if (65 != current) break;
                this.state = 403;
                return true;
            }
            case 403: {
                if (99 != current) break;
                this.state = 404;
                return true;
            }
            case 404: {
                if (117 != current) break;
                this.state = 405;
                return true;
            }
            case 405: {
                if (116 != current) break;
                this.state = 406;
                return true;
            }
            case 406: {
                if (101 != current) break;
                this.state = 407;
                return true;
            }
            case 407: {
                if (59 != current) break;
                this.match = "\u02dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 408: {
                if (114 != current) break;
                this.state = 409;
                return true;
            }
            case 409: {
                if (97 != current) break;
                this.state = 410;
                return true;
            }
            case 410: {
                if (118 != current) break;
                this.state = 411;
                return true;
            }
            case 411: {
                if (101 != current) break;
                this.state = 412;
                return true;
            }
            case 412: {
                if (59 != current) break;
                this.match = "`";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 413: {
                if (105 != current) break;
                this.state = 414;
                return true;
            }
            case 414: {
                if (108 != current) break;
                this.state = 415;
                return true;
            }
            case 415: {
                if (100 != current) break;
                this.state = 416;
                return true;
            }
            case 416: {
                if (101 != current) break;
                this.state = 417;
                return true;
            }
            case 417: {
                if (59 != current) break;
                this.match = "\u02dc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 418: {
                if (111 != current) break;
                this.state = 419;
                return true;
            }
            case 419: {
                if (110 != current) break;
                this.state = 420;
                return true;
            }
            case 420: {
                if (100 != current) break;
                this.state = 421;
                return true;
            }
            case 421: {
                if (59 != current) break;
                this.match = "\u22c4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 422: {
                if (102 != current) break;
                this.state = 423;
                return true;
            }
            case 423: {
                if (101 != current) break;
                this.state = 424;
                return true;
            }
            case 424: {
                if (114 != current) break;
                this.state = 425;
                return true;
            }
            case 425: {
                if (101 != current) break;
                this.state = 426;
                return true;
            }
            case 426: {
                if (110 != current) break;
                this.state = 427;
                return true;
            }
            case 427: {
                if (116 != current) break;
                this.state = 428;
                return true;
            }
            case 428: {
                if (105 != current) break;
                this.state = 429;
                return true;
            }
            case 429: {
                if (97 != current) break;
                this.state = 430;
                return true;
            }
            case 430: {
                if (108 != current) break;
                this.state = 431;
                return true;
            }
            case 431: {
                if (68 != current) break;
                this.state = 432;
                return true;
            }
            case 432: {
                if (59 != current) break;
                this.match = "\u2146";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 433: {
                switch (current) {
                    case 112: {
                        this.state = 434;
                        return true;
                    }
                    case 116: {
                        this.state = 436;
                        return true;
                    }
                    case 117: {
                        this.state = 445;
                        return true;
                    }
                    case 119: {
                        this.state = 568;
                        return true;
                    }
                }
                break;
            }
            case 434: {
                if (102 != current) break;
                this.state = 435;
                return true;
            }
            case 435: {
                if (59 != current) break;
                this.match = "\ud835\udd3b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 436: {
                switch (current) {
                    case 59: {
                        this.match = "\u00a8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 68: {
                        this.state = 437;
                        return true;
                    }
                    case 69: {
                        this.state = 440;
                        return true;
                    }
                }
                break;
            }
            case 437: {
                if (111 != current) break;
                this.state = 438;
                return true;
            }
            case 438: {
                if (116 != current) break;
                this.state = 439;
                return true;
            }
            case 439: {
                if (59 != current) break;
                this.match = "\u20dc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 440: {
                if (113 != current) break;
                this.state = 441;
                return true;
            }
            case 441: {
                if (117 != current) break;
                this.state = 442;
                return true;
            }
            case 442: {
                if (97 != current) break;
                this.state = 443;
                return true;
            }
            case 443: {
                if (108 != current) break;
                this.state = 444;
                return true;
            }
            case 444: {
                if (59 != current) break;
                this.match = "\u2250";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 445: {
                if (98 != current) break;
                this.state = 446;
                return true;
            }
            case 446: {
                if (108 != current) break;
                this.state = 447;
                return true;
            }
            case 447: {
                if (101 != current) break;
                this.state = 448;
                return true;
            }
            case 448: {
                switch (current) {
                    case 67: {
                        this.state = 449;
                        return true;
                    }
                    case 68: {
                        this.state = 464;
                        return true;
                    }
                    case 76: {
                        this.state = 474;
                        return true;
                    }
                    case 82: {
                        this.state = 528;
                        return true;
                    }
                    case 85: {
                        this.state = 541;
                        return true;
                    }
                    case 86: {
                        this.state = 557;
                        return true;
                    }
                }
                break;
            }
            case 449: {
                if (111 != current) break;
                this.state = 450;
                return true;
            }
            case 450: {
                if (110 != current) break;
                this.state = 451;
                return true;
            }
            case 451: {
                if (116 != current) break;
                this.state = 452;
                return true;
            }
            case 452: {
                if (111 != current) break;
                this.state = 453;
                return true;
            }
            case 453: {
                if (117 != current) break;
                this.state = 454;
                return true;
            }
            case 454: {
                if (114 != current) break;
                this.state = 455;
                return true;
            }
            case 455: {
                if (73 != current) break;
                this.state = 456;
                return true;
            }
            case 456: {
                if (110 != current) break;
                this.state = 457;
                return true;
            }
            case 457: {
                if (116 != current) break;
                this.state = 458;
                return true;
            }
            case 458: {
                if (101 != current) break;
                this.state = 459;
                return true;
            }
            case 459: {
                if (103 != current) break;
                this.state = 460;
                return true;
            }
            case 460: {
                if (114 != current) break;
                this.state = 461;
                return true;
            }
            case 461: {
                if (97 != current) break;
                this.state = 462;
                return true;
            }
            case 462: {
                if (108 != current) break;
                this.state = 463;
                return true;
            }
            case 463: {
                if (59 != current) break;
                this.match = "\u222f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 464: {
                if (111 != current) break;
                this.state = 465;
                return true;
            }
            case 465: {
                if (116 == current) {
                    this.state = 466;
                    return true;
                }
                if (119 != current) break;
                this.state = 467;
                return true;
            }
            case 466: {
                if (59 != current) break;
                this.match = "\u00a8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 467: {
                if (110 != current) break;
                this.state = 468;
                return true;
            }
            case 468: {
                if (65 != current) break;
                this.state = 469;
                return true;
            }
            case 469: {
                if (114 != current) break;
                this.state = 470;
                return true;
            }
            case 470: {
                if (114 != current) break;
                this.state = 471;
                return true;
            }
            case 471: {
                if (111 != current) break;
                this.state = 472;
                return true;
            }
            case 472: {
                if (119 != current) break;
                this.state = 473;
                return true;
            }
            case 473: {
                if (59 != current) break;
                this.match = "\u21d3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 474: {
                if (101 == current) {
                    this.state = 475;
                    return true;
                }
                if (111 != current) break;
                this.state = 496;
                return true;
            }
            case 475: {
                if (102 != current) break;
                this.state = 476;
                return true;
            }
            case 476: {
                if (116 != current) break;
                this.state = 477;
                return true;
            }
            case 477: {
                switch (current) {
                    case 65: {
                        this.state = 478;
                        return true;
                    }
                    case 82: {
                        this.state = 483;
                        return true;
                    }
                    case 84: {
                        this.state = 493;
                        return true;
                    }
                }
                break;
            }
            case 478: {
                if (114 != current) break;
                this.state = 479;
                return true;
            }
            case 479: {
                if (114 != current) break;
                this.state = 480;
                return true;
            }
            case 480: {
                if (111 != current) break;
                this.state = 481;
                return true;
            }
            case 481: {
                if (119 != current) break;
                this.state = 482;
                return true;
            }
            case 482: {
                if (59 != current) break;
                this.match = "\u21d0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 483: {
                if (105 != current) break;
                this.state = 484;
                return true;
            }
            case 484: {
                if (103 != current) break;
                this.state = 485;
                return true;
            }
            case 485: {
                if (104 != current) break;
                this.state = 486;
                return true;
            }
            case 486: {
                if (116 != current) break;
                this.state = 487;
                return true;
            }
            case 487: {
                if (65 != current) break;
                this.state = 488;
                return true;
            }
            case 488: {
                if (114 != current) break;
                this.state = 489;
                return true;
            }
            case 489: {
                if (114 != current) break;
                this.state = 490;
                return true;
            }
            case 490: {
                if (111 != current) break;
                this.state = 491;
                return true;
            }
            case 491: {
                if (119 != current) break;
                this.state = 492;
                return true;
            }
            case 492: {
                if (59 != current) break;
                this.match = "\u21d4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 493: {
                if (101 != current) break;
                this.state = 494;
                return true;
            }
            case 494: {
                if (101 != current) break;
                this.state = 495;
                return true;
            }
            case 495: {
                if (59 != current) break;
                this.match = "\u2ae4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 496: {
                if (110 != current) break;
                this.state = 497;
                return true;
            }
            case 497: {
                if (103 != current) break;
                this.state = 498;
                return true;
            }
            case 498: {
                if (76 == current) {
                    this.state = 499;
                    return true;
                }
                if (82 != current) break;
                this.state = 518;
                return true;
            }
            case 499: {
                if (101 != current) break;
                this.state = 500;
                return true;
            }
            case 500: {
                if (102 != current) break;
                this.state = 501;
                return true;
            }
            case 501: {
                if (116 != current) break;
                this.state = 502;
                return true;
            }
            case 502: {
                if (65 == current) {
                    this.state = 503;
                    return true;
                }
                if (82 != current) break;
                this.state = 508;
                return true;
            }
            case 503: {
                if (114 != current) break;
                this.state = 504;
                return true;
            }
            case 504: {
                if (114 != current) break;
                this.state = 505;
                return true;
            }
            case 505: {
                if (111 != current) break;
                this.state = 506;
                return true;
            }
            case 506: {
                if (119 != current) break;
                this.state = 507;
                return true;
            }
            case 507: {
                if (59 != current) break;
                this.match = "\u27f8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 508: {
                if (105 != current) break;
                this.state = 509;
                return true;
            }
            case 509: {
                if (103 != current) break;
                this.state = 510;
                return true;
            }
            case 510: {
                if (104 != current) break;
                this.state = 511;
                return true;
            }
            case 511: {
                if (116 != current) break;
                this.state = 512;
                return true;
            }
            case 512: {
                if (65 != current) break;
                this.state = 513;
                return true;
            }
            case 513: {
                if (114 != current) break;
                this.state = 514;
                return true;
            }
            case 514: {
                if (114 != current) break;
                this.state = 515;
                return true;
            }
            case 515: {
                if (111 != current) break;
                this.state = 516;
                return true;
            }
            case 516: {
                if (119 != current) break;
                this.state = 517;
                return true;
            }
            case 517: {
                if (59 != current) break;
                this.match = "\u27fa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 518: {
                if (105 != current) break;
                this.state = 519;
                return true;
            }
            case 519: {
                if (103 != current) break;
                this.state = 520;
                return true;
            }
            case 520: {
                if (104 != current) break;
                this.state = 521;
                return true;
            }
            case 521: {
                if (116 != current) break;
                this.state = 522;
                return true;
            }
            case 522: {
                if (65 != current) break;
                this.state = 523;
                return true;
            }
            case 523: {
                if (114 != current) break;
                this.state = 524;
                return true;
            }
            case 524: {
                if (114 != current) break;
                this.state = 525;
                return true;
            }
            case 525: {
                if (111 != current) break;
                this.state = 526;
                return true;
            }
            case 526: {
                if (119 != current) break;
                this.state = 527;
                return true;
            }
            case 527: {
                if (59 != current) break;
                this.match = "\u27f9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 528: {
                if (105 != current) break;
                this.state = 529;
                return true;
            }
            case 529: {
                if (103 != current) break;
                this.state = 530;
                return true;
            }
            case 530: {
                if (104 != current) break;
                this.state = 531;
                return true;
            }
            case 531: {
                if (116 != current) break;
                this.state = 532;
                return true;
            }
            case 532: {
                if (65 == current) {
                    this.state = 533;
                    return true;
                }
                if (84 != current) break;
                this.state = 538;
                return true;
            }
            case 533: {
                if (114 != current) break;
                this.state = 534;
                return true;
            }
            case 534: {
                if (114 != current) break;
                this.state = 535;
                return true;
            }
            case 535: {
                if (111 != current) break;
                this.state = 536;
                return true;
            }
            case 536: {
                if (119 != current) break;
                this.state = 537;
                return true;
            }
            case 537: {
                if (59 != current) break;
                this.match = "\u21d2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 538: {
                if (101 != current) break;
                this.state = 539;
                return true;
            }
            case 539: {
                if (101 != current) break;
                this.state = 540;
                return true;
            }
            case 540: {
                if (59 != current) break;
                this.match = "\u22a8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 541: {
                if (112 != current) break;
                this.state = 542;
                return true;
            }
            case 542: {
                if (65 == current) {
                    this.state = 543;
                    return true;
                }
                if (68 != current) break;
                this.state = 548;
                return true;
            }
            case 543: {
                if (114 != current) break;
                this.state = 544;
                return true;
            }
            case 544: {
                if (114 != current) break;
                this.state = 545;
                return true;
            }
            case 545: {
                if (111 != current) break;
                this.state = 546;
                return true;
            }
            case 546: {
                if (119 != current) break;
                this.state = 547;
                return true;
            }
            case 547: {
                if (59 != current) break;
                this.match = "\u21d1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 548: {
                if (111 != current) break;
                this.state = 549;
                return true;
            }
            case 549: {
                if (119 != current) break;
                this.state = 550;
                return true;
            }
            case 550: {
                if (110 != current) break;
                this.state = 551;
                return true;
            }
            case 551: {
                if (65 != current) break;
                this.state = 552;
                return true;
            }
            case 552: {
                if (114 != current) break;
                this.state = 553;
                return true;
            }
            case 553: {
                if (114 != current) break;
                this.state = 554;
                return true;
            }
            case 554: {
                if (111 != current) break;
                this.state = 555;
                return true;
            }
            case 555: {
                if (119 != current) break;
                this.state = 556;
                return true;
            }
            case 556: {
                if (59 != current) break;
                this.match = "\u21d5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 557: {
                if (101 != current) break;
                this.state = 558;
                return true;
            }
            case 558: {
                if (114 != current) break;
                this.state = 559;
                return true;
            }
            case 559: {
                if (116 != current) break;
                this.state = 560;
                return true;
            }
            case 560: {
                if (105 != current) break;
                this.state = 561;
                return true;
            }
            case 561: {
                if (99 != current) break;
                this.state = 562;
                return true;
            }
            case 562: {
                if (97 != current) break;
                this.state = 563;
                return true;
            }
            case 563: {
                if (108 != current) break;
                this.state = 564;
                return true;
            }
            case 564: {
                if (66 != current) break;
                this.state = 565;
                return true;
            }
            case 565: {
                if (97 != current) break;
                this.state = 566;
                return true;
            }
            case 566: {
                if (114 != current) break;
                this.state = 567;
                return true;
            }
            case 567: {
                if (59 != current) break;
                this.match = "\u2225";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 568: {
                if (110 != current) break;
                this.state = 569;
                return true;
            }
            case 569: {
                switch (current) {
                    case 65: {
                        this.state = 570;
                        return true;
                    }
                    case 66: {
                        this.state = 585;
                        return true;
                    }
                    case 76: {
                        this.state = 590;
                        return true;
                    }
                    case 82: {
                        this.state = 623;
                        return true;
                    }
                    case 84: {
                        this.state = 646;
                        return true;
                    }
                    case 97: {
                        this.state = 654;
                        return true;
                    }
                }
                break;
            }
            case 570: {
                if (114 != current) break;
                this.state = 571;
                return true;
            }
            case 571: {
                if (114 != current) break;
                this.state = 572;
                return true;
            }
            case 572: {
                if (111 != current) break;
                this.state = 573;
                return true;
            }
            case 573: {
                if (119 != current) break;
                this.state = 574;
                return true;
            }
            case 574: {
                switch (current) {
                    case 59: {
                        this.match = "\u2193";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 575;
                        return true;
                    }
                    case 85: {
                        this.state = 578;
                        return true;
                    }
                }
                break;
            }
            case 575: {
                if (97 != current) break;
                this.state = 576;
                return true;
            }
            case 576: {
                if (114 != current) break;
                this.state = 577;
                return true;
            }
            case 577: {
                if (59 != current) break;
                this.match = "\u2913";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 578: {
                if (112 != current) break;
                this.state = 579;
                return true;
            }
            case 579: {
                if (65 != current) break;
                this.state = 580;
                return true;
            }
            case 580: {
                if (114 != current) break;
                this.state = 581;
                return true;
            }
            case 581: {
                if (114 != current) break;
                this.state = 582;
                return true;
            }
            case 582: {
                if (111 != current) break;
                this.state = 583;
                return true;
            }
            case 583: {
                if (119 != current) break;
                this.state = 584;
                return true;
            }
            case 584: {
                if (59 != current) break;
                this.match = "\u21f5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 585: {
                if (114 != current) break;
                this.state = 586;
                return true;
            }
            case 586: {
                if (101 != current) break;
                this.state = 587;
                return true;
            }
            case 587: {
                if (118 != current) break;
                this.state = 588;
                return true;
            }
            case 588: {
                if (101 != current) break;
                this.state = 589;
                return true;
            }
            case 589: {
                if (59 != current) break;
                this.match = "\u0311";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 590: {
                if (101 != current) break;
                this.state = 591;
                return true;
            }
            case 591: {
                if (102 != current) break;
                this.state = 592;
                return true;
            }
            case 592: {
                if (116 != current) break;
                this.state = 593;
                return true;
            }
            case 593: {
                switch (current) {
                    case 82: {
                        this.state = 594;
                        return true;
                    }
                    case 84: {
                        this.state = 605;
                        return true;
                    }
                    case 86: {
                        this.state = 614;
                        return true;
                    }
                }
                break;
            }
            case 594: {
                if (105 != current) break;
                this.state = 595;
                return true;
            }
            case 595: {
                if (103 != current) break;
                this.state = 596;
                return true;
            }
            case 596: {
                if (104 != current) break;
                this.state = 597;
                return true;
            }
            case 597: {
                if (116 != current) break;
                this.state = 598;
                return true;
            }
            case 598: {
                if (86 != current) break;
                this.state = 599;
                return true;
            }
            case 599: {
                if (101 != current) break;
                this.state = 600;
                return true;
            }
            case 600: {
                if (99 != current) break;
                this.state = 601;
                return true;
            }
            case 601: {
                if (116 != current) break;
                this.state = 602;
                return true;
            }
            case 602: {
                if (111 != current) break;
                this.state = 603;
                return true;
            }
            case 603: {
                if (114 != current) break;
                this.state = 604;
                return true;
            }
            case 604: {
                if (59 != current) break;
                this.match = "\u2950";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 605: {
                if (101 != current) break;
                this.state = 606;
                return true;
            }
            case 606: {
                if (101 != current) break;
                this.state = 607;
                return true;
            }
            case 607: {
                if (86 != current) break;
                this.state = 608;
                return true;
            }
            case 608: {
                if (101 != current) break;
                this.state = 609;
                return true;
            }
            case 609: {
                if (99 != current) break;
                this.state = 610;
                return true;
            }
            case 610: {
                if (116 != current) break;
                this.state = 611;
                return true;
            }
            case 611: {
                if (111 != current) break;
                this.state = 612;
                return true;
            }
            case 612: {
                if (114 != current) break;
                this.state = 613;
                return true;
            }
            case 613: {
                if (59 != current) break;
                this.match = "\u295e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 614: {
                if (101 != current) break;
                this.state = 615;
                return true;
            }
            case 615: {
                if (99 != current) break;
                this.state = 616;
                return true;
            }
            case 616: {
                if (116 != current) break;
                this.state = 617;
                return true;
            }
            case 617: {
                if (111 != current) break;
                this.state = 618;
                return true;
            }
            case 618: {
                if (114 != current) break;
                this.state = 619;
                return true;
            }
            case 619: {
                if (59 == current) {
                    this.match = "\u21bd";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 620;
                return true;
            }
            case 620: {
                if (97 != current) break;
                this.state = 621;
                return true;
            }
            case 621: {
                if (114 != current) break;
                this.state = 622;
                return true;
            }
            case 622: {
                if (59 != current) break;
                this.match = "\u2956";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 623: {
                if (105 != current) break;
                this.state = 624;
                return true;
            }
            case 624: {
                if (103 != current) break;
                this.state = 625;
                return true;
            }
            case 625: {
                if (104 != current) break;
                this.state = 626;
                return true;
            }
            case 626: {
                if (116 != current) break;
                this.state = 627;
                return true;
            }
            case 627: {
                if (84 == current) {
                    this.state = 628;
                    return true;
                }
                if (86 != current) break;
                this.state = 637;
                return true;
            }
            case 628: {
                if (101 != current) break;
                this.state = 629;
                return true;
            }
            case 629: {
                if (101 != current) break;
                this.state = 630;
                return true;
            }
            case 630: {
                if (86 != current) break;
                this.state = 631;
                return true;
            }
            case 631: {
                if (101 != current) break;
                this.state = 632;
                return true;
            }
            case 632: {
                if (99 != current) break;
                this.state = 633;
                return true;
            }
            case 633: {
                if (116 != current) break;
                this.state = 634;
                return true;
            }
            case 634: {
                if (111 != current) break;
                this.state = 635;
                return true;
            }
            case 635: {
                if (114 != current) break;
                this.state = 636;
                return true;
            }
            case 636: {
                if (59 != current) break;
                this.match = "\u295f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 637: {
                if (101 != current) break;
                this.state = 638;
                return true;
            }
            case 638: {
                if (99 != current) break;
                this.state = 639;
                return true;
            }
            case 639: {
                if (116 != current) break;
                this.state = 640;
                return true;
            }
            case 640: {
                if (111 != current) break;
                this.state = 641;
                return true;
            }
            case 641: {
                if (114 != current) break;
                this.state = 642;
                return true;
            }
            case 642: {
                if (59 == current) {
                    this.match = "\u21c1";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 643;
                return true;
            }
            case 643: {
                if (97 != current) break;
                this.state = 644;
                return true;
            }
            case 644: {
                if (114 != current) break;
                this.state = 645;
                return true;
            }
            case 645: {
                if (59 != current) break;
                this.match = "\u2957";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 646: {
                if (101 != current) break;
                this.state = 647;
                return true;
            }
            case 647: {
                if (101 != current) break;
                this.state = 648;
                return true;
            }
            case 648: {
                if (59 == current) {
                    this.match = "\u22a4";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (65 != current) break;
                this.state = 649;
                return true;
            }
            case 649: {
                if (114 != current) break;
                this.state = 650;
                return true;
            }
            case 650: {
                if (114 != current) break;
                this.state = 651;
                return true;
            }
            case 651: {
                if (111 != current) break;
                this.state = 652;
                return true;
            }
            case 652: {
                if (119 != current) break;
                this.state = 653;
                return true;
            }
            case 653: {
                if (59 != current) break;
                this.match = "\u21a7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 654: {
                if (114 != current) break;
                this.state = 655;
                return true;
            }
            case 655: {
                if (114 != current) break;
                this.state = 656;
                return true;
            }
            case 656: {
                if (111 != current) break;
                this.state = 657;
                return true;
            }
            case 657: {
                if (119 != current) break;
                this.state = 658;
                return true;
            }
            case 658: {
                if (59 != current) break;
                this.match = "\u21d3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 659: {
                if (99 == current) {
                    this.state = 660;
                    return true;
                }
                if (116 != current) break;
                this.state = 662;
                return true;
            }
            case 660: {
                if (114 != current) break;
                this.state = 661;
                return true;
            }
            case 661: {
                if (59 != current) break;
                this.match = "\ud835\udc9f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 662: {
                if (114 != current) break;
                this.state = 663;
                return true;
            }
            case 663: {
                if (111 != current) break;
                this.state = 664;
                return true;
            }
            case 664: {
                if (107 != current) break;
                this.state = 665;
                return true;
            }
            case 665: {
                if (59 != current) break;
                this.match = "\u0110";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 666: {
                switch (current) {
                    case 78: {
                        this.state = 667;
                        return true;
                    }
                    case 84: {
                        this.state = 669;
                        return true;
                    }
                    case 97: {
                        this.state = 671;
                        return true;
                    }
                    case 99: {
                        this.state = 676;
                        return true;
                    }
                    case 100: {
                        this.state = 685;
                        return true;
                    }
                    case 102: {
                        this.state = 688;
                        return true;
                    }
                    case 103: {
                        this.state = 690;
                        return true;
                    }
                    case 108: {
                        this.state = 695;
                        return true;
                    }
                    case 109: {
                        this.state = 701;
                        return true;
                    }
                    case 111: {
                        this.state = 734;
                        return true;
                    }
                    case 112: {
                        this.state = 740;
                        return true;
                    }
                    case 113: {
                        this.state = 746;
                        return true;
                    }
                    case 115: {
                        this.state = 763;
                        return true;
                    }
                    case 116: {
                        this.state = 768;
                        return true;
                    }
                    case 117: {
                        this.state = 770;
                        return true;
                    }
                    case 120: {
                        this.state = 773;
                        return true;
                    }
                }
                break;
            }
            case 667: {
                if (71 != current) break;
                this.state = 668;
                return true;
            }
            case 668: {
                if (59 != current) break;
                this.match = "\u014a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 669: {
                if (72 != current) break;
                this.match = "\u00d0";
                this.matchLength = this.consumedCount;
                this.state = 670;
                return true;
            }
            case 670: {
                if (59 != current) break;
                this.match = "\u00d0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 671: {
                if (99 != current) break;
                this.state = 672;
                return true;
            }
            case 672: {
                if (117 != current) break;
                this.state = 673;
                return true;
            }
            case 673: {
                if (116 != current) break;
                this.state = 674;
                return true;
            }
            case 674: {
                if (101 != current) break;
                this.match = "\u00c9";
                this.matchLength = this.consumedCount;
                this.state = 675;
                return true;
            }
            case 675: {
                if (59 != current) break;
                this.match = "\u00c9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 676: {
                switch (current) {
                    case 97: {
                        this.state = 677;
                        return true;
                    }
                    case 105: {
                        this.state = 681;
                        return true;
                    }
                    case 121: {
                        this.state = 684;
                        return true;
                    }
                }
                break;
            }
            case 677: {
                if (114 != current) break;
                this.state = 678;
                return true;
            }
            case 678: {
                if (111 != current) break;
                this.state = 679;
                return true;
            }
            case 679: {
                if (110 != current) break;
                this.state = 680;
                return true;
            }
            case 680: {
                if (59 != current) break;
                this.match = "\u011a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 681: {
                if (114 != current) break;
                this.state = 682;
                return true;
            }
            case 682: {
                if (99 != current) break;
                this.match = "\u00ca";
                this.matchLength = this.consumedCount;
                this.state = 683;
                return true;
            }
            case 683: {
                if (59 != current) break;
                this.match = "\u00ca";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 684: {
                if (59 != current) break;
                this.match = "\u042d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 685: {
                if (111 != current) break;
                this.state = 686;
                return true;
            }
            case 686: {
                if (116 != current) break;
                this.state = 687;
                return true;
            }
            case 687: {
                if (59 != current) break;
                this.match = "\u0116";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 688: {
                if (114 != current) break;
                this.state = 689;
                return true;
            }
            case 689: {
                if (59 != current) break;
                this.match = "\ud835\udd08";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 690: {
                if (114 != current) break;
                this.state = 691;
                return true;
            }
            case 691: {
                if (97 != current) break;
                this.state = 692;
                return true;
            }
            case 692: {
                if (118 != current) break;
                this.state = 693;
                return true;
            }
            case 693: {
                if (101 != current) break;
                this.match = "\u00c8";
                this.matchLength = this.consumedCount;
                this.state = 694;
                return true;
            }
            case 694: {
                if (59 != current) break;
                this.match = "\u00c8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 695: {
                if (101 != current) break;
                this.state = 696;
                return true;
            }
            case 696: {
                if (109 != current) break;
                this.state = 697;
                return true;
            }
            case 697: {
                if (101 != current) break;
                this.state = 698;
                return true;
            }
            case 698: {
                if (110 != current) break;
                this.state = 699;
                return true;
            }
            case 699: {
                if (116 != current) break;
                this.state = 700;
                return true;
            }
            case 700: {
                if (59 != current) break;
                this.match = "\u2208";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 701: {
                if (97 == current) {
                    this.state = 702;
                    return true;
                }
                if (112 != current) break;
                this.state = 705;
                return true;
            }
            case 702: {
                if (99 != current) break;
                this.state = 703;
                return true;
            }
            case 703: {
                if (114 != current) break;
                this.state = 704;
                return true;
            }
            case 704: {
                if (59 != current) break;
                this.match = "\u0112";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 705: {
                if (116 != current) break;
                this.state = 706;
                return true;
            }
            case 706: {
                if (121 != current) break;
                this.state = 707;
                return true;
            }
            case 707: {
                if (83 == current) {
                    this.state = 708;
                    return true;
                }
                if (86 != current) break;
                this.state = 719;
                return true;
            }
            case 708: {
                if (109 != current) break;
                this.state = 709;
                return true;
            }
            case 709: {
                if (97 != current) break;
                this.state = 710;
                return true;
            }
            case 710: {
                if (108 != current) break;
                this.state = 711;
                return true;
            }
            case 711: {
                if (108 != current) break;
                this.state = 712;
                return true;
            }
            case 712: {
                if (83 != current) break;
                this.state = 713;
                return true;
            }
            case 713: {
                if (113 != current) break;
                this.state = 714;
                return true;
            }
            case 714: {
                if (117 != current) break;
                this.state = 715;
                return true;
            }
            case 715: {
                if (97 != current) break;
                this.state = 716;
                return true;
            }
            case 716: {
                if (114 != current) break;
                this.state = 717;
                return true;
            }
            case 717: {
                if (101 != current) break;
                this.state = 718;
                return true;
            }
            case 718: {
                if (59 != current) break;
                this.match = "\u25fb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 719: {
                if (101 != current) break;
                this.state = 720;
                return true;
            }
            case 720: {
                if (114 != current) break;
                this.state = 721;
                return true;
            }
            case 721: {
                if (121 != current) break;
                this.state = 722;
                return true;
            }
            case 722: {
                if (83 != current) break;
                this.state = 723;
                return true;
            }
            case 723: {
                if (109 != current) break;
                this.state = 724;
                return true;
            }
            case 724: {
                if (97 != current) break;
                this.state = 725;
                return true;
            }
            case 725: {
                if (108 != current) break;
                this.state = 726;
                return true;
            }
            case 726: {
                if (108 != current) break;
                this.state = 727;
                return true;
            }
            case 727: {
                if (83 != current) break;
                this.state = 728;
                return true;
            }
            case 728: {
                if (113 != current) break;
                this.state = 729;
                return true;
            }
            case 729: {
                if (117 != current) break;
                this.state = 730;
                return true;
            }
            case 730: {
                if (97 != current) break;
                this.state = 731;
                return true;
            }
            case 731: {
                if (114 != current) break;
                this.state = 732;
                return true;
            }
            case 732: {
                if (101 != current) break;
                this.state = 733;
                return true;
            }
            case 733: {
                if (59 != current) break;
                this.match = "\u25ab";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 734: {
                if (103 == current) {
                    this.state = 735;
                    return true;
                }
                if (112 != current) break;
                this.state = 738;
                return true;
            }
            case 735: {
                if (111 != current) break;
                this.state = 736;
                return true;
            }
            case 736: {
                if (110 != current) break;
                this.state = 737;
                return true;
            }
            case 737: {
                if (59 != current) break;
                this.match = "\u0118";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 738: {
                if (102 != current) break;
                this.state = 739;
                return true;
            }
            case 739: {
                if (59 != current) break;
                this.match = "\ud835\udd3c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 740: {
                if (115 != current) break;
                this.state = 741;
                return true;
            }
            case 741: {
                if (105 != current) break;
                this.state = 742;
                return true;
            }
            case 742: {
                if (108 != current) break;
                this.state = 743;
                return true;
            }
            case 743: {
                if (111 != current) break;
                this.state = 744;
                return true;
            }
            case 744: {
                if (110 != current) break;
                this.state = 745;
                return true;
            }
            case 745: {
                if (59 != current) break;
                this.match = "\u0395";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 746: {
                if (117 != current) break;
                this.state = 747;
                return true;
            }
            case 747: {
                if (97 == current) {
                    this.state = 748;
                    return true;
                }
                if (105 != current) break;
                this.state = 755;
                return true;
            }
            case 748: {
                if (108 != current) break;
                this.state = 749;
                return true;
            }
            case 749: {
                if (59 == current) {
                    this.match = "\u2a75";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (84 != current) break;
                this.state = 750;
                return true;
            }
            case 750: {
                if (105 != current) break;
                this.state = 751;
                return true;
            }
            case 751: {
                if (108 != current) break;
                this.state = 752;
                return true;
            }
            case 752: {
                if (100 != current) break;
                this.state = 753;
                return true;
            }
            case 753: {
                if (101 != current) break;
                this.state = 754;
                return true;
            }
            case 754: {
                if (59 != current) break;
                this.match = "\u2242";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 755: {
                if (108 != current) break;
                this.state = 756;
                return true;
            }
            case 756: {
                if (105 != current) break;
                this.state = 757;
                return true;
            }
            case 757: {
                if (98 != current) break;
                this.state = 758;
                return true;
            }
            case 758: {
                if (114 != current) break;
                this.state = 759;
                return true;
            }
            case 759: {
                if (105 != current) break;
                this.state = 760;
                return true;
            }
            case 760: {
                if (117 != current) break;
                this.state = 761;
                return true;
            }
            case 761: {
                if (109 != current) break;
                this.state = 762;
                return true;
            }
            case 762: {
                if (59 != current) break;
                this.match = "\u21cc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 763: {
                if (99 == current) {
                    this.state = 764;
                    return true;
                }
                if (105 != current) break;
                this.state = 766;
                return true;
            }
            case 764: {
                if (114 != current) break;
                this.state = 765;
                return true;
            }
            case 765: {
                if (59 != current) break;
                this.match = "\u2130";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 766: {
                if (109 != current) break;
                this.state = 767;
                return true;
            }
            case 767: {
                if (59 != current) break;
                this.match = "\u2a73";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 768: {
                if (97 != current) break;
                this.state = 769;
                return true;
            }
            case 769: {
                if (59 != current) break;
                this.match = "\u0397";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 770: {
                if (109 != current) break;
                this.state = 771;
                return true;
            }
            case 771: {
                if (108 != current) break;
                this.match = "\u00cb";
                this.matchLength = this.consumedCount;
                this.state = 772;
                return true;
            }
            case 772: {
                if (59 != current) break;
                this.match = "\u00cb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 773: {
                if (105 == current) {
                    this.state = 774;
                    return true;
                }
                if (112 != current) break;
                this.state = 778;
                return true;
            }
            case 774: {
                if (115 != current) break;
                this.state = 775;
                return true;
            }
            case 775: {
                if (116 != current) break;
                this.state = 776;
                return true;
            }
            case 776: {
                if (115 != current) break;
                this.state = 777;
                return true;
            }
            case 777: {
                if (59 != current) break;
                this.match = "\u2203";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 778: {
                if (111 != current) break;
                this.state = 779;
                return true;
            }
            case 779: {
                if (110 != current) break;
                this.state = 780;
                return true;
            }
            case 780: {
                if (101 != current) break;
                this.state = 781;
                return true;
            }
            case 781: {
                if (110 != current) break;
                this.state = 782;
                return true;
            }
            case 782: {
                if (116 != current) break;
                this.state = 783;
                return true;
            }
            case 783: {
                if (105 != current) break;
                this.state = 784;
                return true;
            }
            case 784: {
                if (97 != current) break;
                this.state = 785;
                return true;
            }
            case 785: {
                if (108 != current) break;
                this.state = 786;
                return true;
            }
            case 786: {
                if (69 != current) break;
                this.state = 787;
                return true;
            }
            case 787: {
                if (59 != current) break;
                this.match = "\u2147";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 788: {
                switch (current) {
                    case 99: {
                        this.state = 789;
                        return true;
                    }
                    case 102: {
                        this.state = 791;
                        return true;
                    }
                    case 105: {
                        this.state = 793;
                        return true;
                    }
                    case 111: {
                        this.state = 824;
                        return true;
                    }
                    case 115: {
                        this.state = 839;
                        return true;
                    }
                }
                break;
            }
            case 789: {
                if (121 != current) break;
                this.state = 790;
                return true;
            }
            case 790: {
                if (59 != current) break;
                this.match = "\u0424";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 791: {
                if (114 != current) break;
                this.state = 792;
                return true;
            }
            case 792: {
                if (59 != current) break;
                this.match = "\ud835\udd09";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 793: {
                if (108 != current) break;
                this.state = 794;
                return true;
            }
            case 794: {
                if (108 != current) break;
                this.state = 795;
                return true;
            }
            case 795: {
                if (101 != current) break;
                this.state = 796;
                return true;
            }
            case 796: {
                if (100 != current) break;
                this.state = 797;
                return true;
            }
            case 797: {
                if (83 == current) {
                    this.state = 798;
                    return true;
                }
                if (86 != current) break;
                this.state = 809;
                return true;
            }
            case 798: {
                if (109 != current) break;
                this.state = 799;
                return true;
            }
            case 799: {
                if (97 != current) break;
                this.state = 800;
                return true;
            }
            case 800: {
                if (108 != current) break;
                this.state = 801;
                return true;
            }
            case 801: {
                if (108 != current) break;
                this.state = 802;
                return true;
            }
            case 802: {
                if (83 != current) break;
                this.state = 803;
                return true;
            }
            case 803: {
                if (113 != current) break;
                this.state = 804;
                return true;
            }
            case 804: {
                if (117 != current) break;
                this.state = 805;
                return true;
            }
            case 805: {
                if (97 != current) break;
                this.state = 806;
                return true;
            }
            case 806: {
                if (114 != current) break;
                this.state = 807;
                return true;
            }
            case 807: {
                if (101 != current) break;
                this.state = 808;
                return true;
            }
            case 808: {
                if (59 != current) break;
                this.match = "\u25fc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 809: {
                if (101 != current) break;
                this.state = 810;
                return true;
            }
            case 810: {
                if (114 != current) break;
                this.state = 811;
                return true;
            }
            case 811: {
                if (121 != current) break;
                this.state = 812;
                return true;
            }
            case 812: {
                if (83 != current) break;
                this.state = 813;
                return true;
            }
            case 813: {
                if (109 != current) break;
                this.state = 814;
                return true;
            }
            case 814: {
                if (97 != current) break;
                this.state = 815;
                return true;
            }
            case 815: {
                if (108 != current) break;
                this.state = 816;
                return true;
            }
            case 816: {
                if (108 != current) break;
                this.state = 817;
                return true;
            }
            case 817: {
                if (83 != current) break;
                this.state = 818;
                return true;
            }
            case 818: {
                if (113 != current) break;
                this.state = 819;
                return true;
            }
            case 819: {
                if (117 != current) break;
                this.state = 820;
                return true;
            }
            case 820: {
                if (97 != current) break;
                this.state = 821;
                return true;
            }
            case 821: {
                if (114 != current) break;
                this.state = 822;
                return true;
            }
            case 822: {
                if (101 != current) break;
                this.state = 823;
                return true;
            }
            case 823: {
                if (59 != current) break;
                this.match = "\u25aa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 824: {
                switch (current) {
                    case 112: {
                        this.state = 825;
                        return true;
                    }
                    case 114: {
                        this.state = 827;
                        return true;
                    }
                    case 117: {
                        this.state = 831;
                        return true;
                    }
                }
                break;
            }
            case 825: {
                if (102 != current) break;
                this.state = 826;
                return true;
            }
            case 826: {
                if (59 != current) break;
                this.match = "\ud835\udd3d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 827: {
                if (65 != current) break;
                this.state = 828;
                return true;
            }
            case 828: {
                if (108 != current) break;
                this.state = 829;
                return true;
            }
            case 829: {
                if (108 != current) break;
                this.state = 830;
                return true;
            }
            case 830: {
                if (59 != current) break;
                this.match = "\u2200";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 831: {
                if (114 != current) break;
                this.state = 832;
                return true;
            }
            case 832: {
                if (105 != current) break;
                this.state = 833;
                return true;
            }
            case 833: {
                if (101 != current) break;
                this.state = 834;
                return true;
            }
            case 834: {
                if (114 != current) break;
                this.state = 835;
                return true;
            }
            case 835: {
                if (116 != current) break;
                this.state = 836;
                return true;
            }
            case 836: {
                if (114 != current) break;
                this.state = 837;
                return true;
            }
            case 837: {
                if (102 != current) break;
                this.state = 838;
                return true;
            }
            case 838: {
                if (59 != current) break;
                this.match = "\u2131";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 839: {
                if (99 != current) break;
                this.state = 840;
                return true;
            }
            case 840: {
                if (114 != current) break;
                this.state = 841;
                return true;
            }
            case 841: {
                if (59 != current) break;
                this.match = "\u2131";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 842: {
                switch (current) {
                    case 74: {
                        this.state = 843;
                        return true;
                    }
                    case 84: {
                        this.match = ">";
                        this.matchLength = this.consumedCount;
                        this.state = 846;
                        return true;
                    }
                    case 97: {
                        this.state = 847;
                        return true;
                    }
                    case 98: {
                        this.state = 852;
                        return true;
                    }
                    case 99: {
                        this.state = 857;
                        return true;
                    }
                    case 100: {
                        this.state = 866;
                        return true;
                    }
                    case 102: {
                        this.state = 869;
                        return true;
                    }
                    case 103: {
                        this.state = 871;
                        return true;
                    }
                    case 111: {
                        this.state = 872;
                        return true;
                    }
                    case 114: {
                        this.state = 875;
                        return true;
                    }
                    case 115: {
                        this.state = 925;
                        return true;
                    }
                    case 116: {
                        this.state = 928;
                        return true;
                    }
                }
                break;
            }
            case 843: {
                if (99 != current) break;
                this.state = 844;
                return true;
            }
            case 844: {
                if (121 != current) break;
                this.state = 845;
                return true;
            }
            case 845: {
                if (59 != current) break;
                this.match = "\u0403";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 846: {
                if (59 != current) break;
                this.match = ">";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 847: {
                if (109 != current) break;
                this.state = 848;
                return true;
            }
            case 848: {
                if (109 != current) break;
                this.state = 849;
                return true;
            }
            case 849: {
                if (97 != current) break;
                this.state = 850;
                return true;
            }
            case 850: {
                if (59 == current) {
                    this.match = "\u0393";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 851;
                return true;
            }
            case 851: {
                if (59 != current) break;
                this.match = "\u03dc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 852: {
                if (114 != current) break;
                this.state = 853;
                return true;
            }
            case 853: {
                if (101 != current) break;
                this.state = 854;
                return true;
            }
            case 854: {
                if (118 != current) break;
                this.state = 855;
                return true;
            }
            case 855: {
                if (101 != current) break;
                this.state = 856;
                return true;
            }
            case 856: {
                if (59 != current) break;
                this.match = "\u011e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 857: {
                switch (current) {
                    case 101: {
                        this.state = 858;
                        return true;
                    }
                    case 105: {
                        this.state = 862;
                        return true;
                    }
                    case 121: {
                        this.state = 865;
                        return true;
                    }
                }
                break;
            }
            case 858: {
                if (100 != current) break;
                this.state = 859;
                return true;
            }
            case 859: {
                if (105 != current) break;
                this.state = 860;
                return true;
            }
            case 860: {
                if (108 != current) break;
                this.state = 861;
                return true;
            }
            case 861: {
                if (59 != current) break;
                this.match = "\u0122";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 862: {
                if (114 != current) break;
                this.state = 863;
                return true;
            }
            case 863: {
                if (99 != current) break;
                this.state = 864;
                return true;
            }
            case 864: {
                if (59 != current) break;
                this.match = "\u011c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 865: {
                if (59 != current) break;
                this.match = "\u0413";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 866: {
                if (111 != current) break;
                this.state = 867;
                return true;
            }
            case 867: {
                if (116 != current) break;
                this.state = 868;
                return true;
            }
            case 868: {
                if (59 != current) break;
                this.match = "\u0120";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 869: {
                if (114 != current) break;
                this.state = 870;
                return true;
            }
            case 870: {
                if (59 != current) break;
                this.match = "\ud835\udd0a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 871: {
                if (59 != current) break;
                this.match = "\u22d9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 872: {
                if (112 != current) break;
                this.state = 873;
                return true;
            }
            case 873: {
                if (102 != current) break;
                this.state = 874;
                return true;
            }
            case 874: {
                if (59 != current) break;
                this.match = "\ud835\udd3e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 875: {
                if (101 != current) break;
                this.state = 876;
                return true;
            }
            case 876: {
                if (97 != current) break;
                this.state = 877;
                return true;
            }
            case 877: {
                if (116 != current) break;
                this.state = 878;
                return true;
            }
            case 878: {
                if (101 != current) break;
                this.state = 879;
                return true;
            }
            case 879: {
                if (114 != current) break;
                this.state = 880;
                return true;
            }
            case 880: {
                switch (current) {
                    case 69: {
                        this.state = 881;
                        return true;
                    }
                    case 70: {
                        this.state = 890;
                        return true;
                    }
                    case 71: {
                        this.state = 899;
                        return true;
                    }
                    case 76: {
                        this.state = 906;
                        return true;
                    }
                    case 83: {
                        this.state = 910;
                        return true;
                    }
                    case 84: {
                        this.state = 920;
                        return true;
                    }
                }
                break;
            }
            case 881: {
                if (113 != current) break;
                this.state = 882;
                return true;
            }
            case 882: {
                if (117 != current) break;
                this.state = 883;
                return true;
            }
            case 883: {
                if (97 != current) break;
                this.state = 884;
                return true;
            }
            case 884: {
                if (108 != current) break;
                this.state = 885;
                return true;
            }
            case 885: {
                if (59 == current) {
                    this.match = "\u2265";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (76 != current) break;
                this.state = 886;
                return true;
            }
            case 886: {
                if (101 != current) break;
                this.state = 887;
                return true;
            }
            case 887: {
                if (115 != current) break;
                this.state = 888;
                return true;
            }
            case 888: {
                if (115 != current) break;
                this.state = 889;
                return true;
            }
            case 889: {
                if (59 != current) break;
                this.match = "\u22db";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 890: {
                if (117 != current) break;
                this.state = 891;
                return true;
            }
            case 891: {
                if (108 != current) break;
                this.state = 892;
                return true;
            }
            case 892: {
                if (108 != current) break;
                this.state = 893;
                return true;
            }
            case 893: {
                if (69 != current) break;
                this.state = 894;
                return true;
            }
            case 894: {
                if (113 != current) break;
                this.state = 895;
                return true;
            }
            case 895: {
                if (117 != current) break;
                this.state = 896;
                return true;
            }
            case 896: {
                if (97 != current) break;
                this.state = 897;
                return true;
            }
            case 897: {
                if (108 != current) break;
                this.state = 898;
                return true;
            }
            case 898: {
                if (59 != current) break;
                this.match = "\u2267";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 899: {
                if (114 != current) break;
                this.state = 900;
                return true;
            }
            case 900: {
                if (101 != current) break;
                this.state = 901;
                return true;
            }
            case 901: {
                if (97 != current) break;
                this.state = 902;
                return true;
            }
            case 902: {
                if (116 != current) break;
                this.state = 903;
                return true;
            }
            case 903: {
                if (101 != current) break;
                this.state = 904;
                return true;
            }
            case 904: {
                if (114 != current) break;
                this.state = 905;
                return true;
            }
            case 905: {
                if (59 != current) break;
                this.match = "\u2aa2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 906: {
                if (101 != current) break;
                this.state = 907;
                return true;
            }
            case 907: {
                if (115 != current) break;
                this.state = 908;
                return true;
            }
            case 908: {
                if (115 != current) break;
                this.state = 909;
                return true;
            }
            case 909: {
                if (59 != current) break;
                this.match = "\u2277";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 910: {
                if (108 != current) break;
                this.state = 911;
                return true;
            }
            case 911: {
                if (97 != current) break;
                this.state = 912;
                return true;
            }
            case 912: {
                if (110 != current) break;
                this.state = 913;
                return true;
            }
            case 913: {
                if (116 != current) break;
                this.state = 914;
                return true;
            }
            case 914: {
                if (69 != current) break;
                this.state = 915;
                return true;
            }
            case 915: {
                if (113 != current) break;
                this.state = 916;
                return true;
            }
            case 916: {
                if (117 != current) break;
                this.state = 917;
                return true;
            }
            case 917: {
                if (97 != current) break;
                this.state = 918;
                return true;
            }
            case 918: {
                if (108 != current) break;
                this.state = 919;
                return true;
            }
            case 919: {
                if (59 != current) break;
                this.match = "\u2a7e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 920: {
                if (105 != current) break;
                this.state = 921;
                return true;
            }
            case 921: {
                if (108 != current) break;
                this.state = 922;
                return true;
            }
            case 922: {
                if (100 != current) break;
                this.state = 923;
                return true;
            }
            case 923: {
                if (101 != current) break;
                this.state = 924;
                return true;
            }
            case 924: {
                if (59 != current) break;
                this.match = "\u2273";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 925: {
                if (99 != current) break;
                this.state = 926;
                return true;
            }
            case 926: {
                if (114 != current) break;
                this.state = 927;
                return true;
            }
            case 927: {
                if (59 != current) break;
                this.match = "\ud835\udca2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 928: {
                if (59 != current) break;
                this.match = "\u226b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 929: {
                switch (current) {
                    case 65: {
                        this.state = 930;
                        return true;
                    }
                    case 97: {
                        this.state = 935;
                        return true;
                    }
                    case 99: {
                        this.state = 940;
                        return true;
                    }
                    case 102: {
                        this.state = 944;
                        return true;
                    }
                    case 105: {
                        this.state = 946;
                        return true;
                    }
                    case 111: {
                        this.state = 957;
                        return true;
                    }
                    case 115: {
                        this.state = 972;
                        return true;
                    }
                    case 117: {
                        this.state = 979;
                        return true;
                    }
                }
                break;
            }
            case 930: {
                if (82 != current) break;
                this.state = 931;
                return true;
            }
            case 931: {
                if (68 != current) break;
                this.state = 932;
                return true;
            }
            case 932: {
                if (99 != current) break;
                this.state = 933;
                return true;
            }
            case 933: {
                if (121 != current) break;
                this.state = 934;
                return true;
            }
            case 934: {
                if (59 != current) break;
                this.match = "\u042a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 935: {
                if (99 == current) {
                    this.state = 936;
                    return true;
                }
                if (116 != current) break;
                this.state = 939;
                return true;
            }
            case 936: {
                if (101 != current) break;
                this.state = 937;
                return true;
            }
            case 937: {
                if (107 != current) break;
                this.state = 938;
                return true;
            }
            case 938: {
                if (59 != current) break;
                this.match = "\u02c7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 939: {
                if (59 != current) break;
                this.match = "^";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 940: {
                if (105 != current) break;
                this.state = 941;
                return true;
            }
            case 941: {
                if (114 != current) break;
                this.state = 942;
                return true;
            }
            case 942: {
                if (99 != current) break;
                this.state = 943;
                return true;
            }
            case 943: {
                if (59 != current) break;
                this.match = "\u0124";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 944: {
                if (114 != current) break;
                this.state = 945;
                return true;
            }
            case 945: {
                if (59 != current) break;
                this.match = "\u210c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 946: {
                if (108 != current) break;
                this.state = 947;
                return true;
            }
            case 947: {
                if (98 != current) break;
                this.state = 948;
                return true;
            }
            case 948: {
                if (101 != current) break;
                this.state = 949;
                return true;
            }
            case 949: {
                if (114 != current) break;
                this.state = 950;
                return true;
            }
            case 950: {
                if (116 != current) break;
                this.state = 951;
                return true;
            }
            case 951: {
                if (83 != current) break;
                this.state = 952;
                return true;
            }
            case 952: {
                if (112 != current) break;
                this.state = 953;
                return true;
            }
            case 953: {
                if (97 != current) break;
                this.state = 954;
                return true;
            }
            case 954: {
                if (99 != current) break;
                this.state = 955;
                return true;
            }
            case 955: {
                if (101 != current) break;
                this.state = 956;
                return true;
            }
            case 956: {
                if (59 != current) break;
                this.match = "\u210b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 957: {
                if (112 == current) {
                    this.state = 958;
                    return true;
                }
                if (114 != current) break;
                this.state = 960;
                return true;
            }
            case 958: {
                if (102 != current) break;
                this.state = 959;
                return true;
            }
            case 959: {
                if (59 != current) break;
                this.match = "\u210d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 960: {
                if (105 != current) break;
                this.state = 961;
                return true;
            }
            case 961: {
                if (122 != current) break;
                this.state = 962;
                return true;
            }
            case 962: {
                if (111 != current) break;
                this.state = 963;
                return true;
            }
            case 963: {
                if (110 != current) break;
                this.state = 964;
                return true;
            }
            case 964: {
                if (116 != current) break;
                this.state = 965;
                return true;
            }
            case 965: {
                if (97 != current) break;
                this.state = 966;
                return true;
            }
            case 966: {
                if (108 != current) break;
                this.state = 967;
                return true;
            }
            case 967: {
                if (76 != current) break;
                this.state = 968;
                return true;
            }
            case 968: {
                if (105 != current) break;
                this.state = 969;
                return true;
            }
            case 969: {
                if (110 != current) break;
                this.state = 970;
                return true;
            }
            case 970: {
                if (101 != current) break;
                this.state = 971;
                return true;
            }
            case 971: {
                if (59 != current) break;
                this.match = "\u2500";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 972: {
                if (99 == current) {
                    this.state = 973;
                    return true;
                }
                if (116 != current) break;
                this.state = 975;
                return true;
            }
            case 973: {
                if (114 != current) break;
                this.state = 974;
                return true;
            }
            case 974: {
                if (59 != current) break;
                this.match = "\u210b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 975: {
                if (114 != current) break;
                this.state = 976;
                return true;
            }
            case 976: {
                if (111 != current) break;
                this.state = 977;
                return true;
            }
            case 977: {
                if (107 != current) break;
                this.state = 978;
                return true;
            }
            case 978: {
                if (59 != current) break;
                this.match = "\u0126";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 979: {
                if (109 != current) break;
                this.state = 980;
                return true;
            }
            case 980: {
                if (112 != current) break;
                this.state = 981;
                return true;
            }
            case 981: {
                if (68 == current) {
                    this.state = 982;
                    return true;
                }
                if (69 != current) break;
                this.state = 990;
                return true;
            }
            case 982: {
                if (111 != current) break;
                this.state = 983;
                return true;
            }
            case 983: {
                if (119 != current) break;
                this.state = 984;
                return true;
            }
            case 984: {
                if (110 != current) break;
                this.state = 985;
                return true;
            }
            case 985: {
                if (72 != current) break;
                this.state = 986;
                return true;
            }
            case 986: {
                if (117 != current) break;
                this.state = 987;
                return true;
            }
            case 987: {
                if (109 != current) break;
                this.state = 988;
                return true;
            }
            case 988: {
                if (112 != current) break;
                this.state = 989;
                return true;
            }
            case 989: {
                if (59 != current) break;
                this.match = "\u224e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 990: {
                if (113 != current) break;
                this.state = 991;
                return true;
            }
            case 991: {
                if (117 != current) break;
                this.state = 992;
                return true;
            }
            case 992: {
                if (97 != current) break;
                this.state = 993;
                return true;
            }
            case 993: {
                if (108 != current) break;
                this.state = 994;
                return true;
            }
            case 994: {
                if (59 != current) break;
                this.match = "\u224f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 995: {
                switch (current) {
                    case 69: {
                        this.state = 996;
                        return true;
                    }
                    case 74: {
                        this.state = 999;
                        return true;
                    }
                    case 79: {
                        this.state = 1003;
                        return true;
                    }
                    case 97: {
                        this.state = 1006;
                        return true;
                    }
                    case 99: {
                        this.state = 1011;
                        return true;
                    }
                    case 100: {
                        this.state = 1016;
                        return true;
                    }
                    case 102: {
                        this.state = 1019;
                        return true;
                    }
                    case 103: {
                        this.state = 1021;
                        return true;
                    }
                    case 109: {
                        this.state = 1026;
                        return true;
                    }
                    case 110: {
                        this.state = 1042;
                        return true;
                    }
                    case 111: {
                        this.state = 1074;
                        return true;
                    }
                    case 115: {
                        this.state = 1082;
                        return true;
                    }
                    case 116: {
                        this.state = 1085;
                        return true;
                    }
                    case 117: {
                        this.state = 1090;
                        return true;
                    }
                }
                break;
            }
            case 996: {
                if (99 != current) break;
                this.state = 997;
                return true;
            }
            case 997: {
                if (121 != current) break;
                this.state = 998;
                return true;
            }
            case 998: {
                if (59 != current) break;
                this.match = "\u0415";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 999: {
                if (108 != current) break;
                this.state = 1000;
                return true;
            }
        }
        return false;
    }

    private boolean parse2(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 1000: {
                if (105 != current) break;
                this.state = 1001;
                return true;
            }
            case 1001: {
                if (103 != current) break;
                this.state = 1002;
                return true;
            }
            case 1002: {
                if (59 != current) break;
                this.match = "\u0132";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1003: {
                if (99 != current) break;
                this.state = 1004;
                return true;
            }
            case 1004: {
                if (121 != current) break;
                this.state = 1005;
                return true;
            }
            case 1005: {
                if (59 != current) break;
                this.match = "\u0401";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1006: {
                if (99 != current) break;
                this.state = 1007;
                return true;
            }
            case 1007: {
                if (117 != current) break;
                this.state = 1008;
                return true;
            }
            case 1008: {
                if (116 != current) break;
                this.state = 1009;
                return true;
            }
            case 1009: {
                if (101 != current) break;
                this.match = "\u00cd";
                this.matchLength = this.consumedCount;
                this.state = 1010;
                return true;
            }
            case 1010: {
                if (59 != current) break;
                this.match = "\u00cd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1011: {
                if (105 == current) {
                    this.state = 1012;
                    return true;
                }
                if (121 != current) break;
                this.state = 1015;
                return true;
            }
            case 1012: {
                if (114 != current) break;
                this.state = 1013;
                return true;
            }
            case 1013: {
                if (99 != current) break;
                this.match = "\u00ce";
                this.matchLength = this.consumedCount;
                this.state = 1014;
                return true;
            }
            case 1014: {
                if (59 != current) break;
                this.match = "\u00ce";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1015: {
                if (59 != current) break;
                this.match = "\u0418";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1016: {
                if (111 != current) break;
                this.state = 1017;
                return true;
            }
            case 1017: {
                if (116 != current) break;
                this.state = 1018;
                return true;
            }
            case 1018: {
                if (59 != current) break;
                this.match = "\u0130";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1019: {
                if (114 != current) break;
                this.state = 1020;
                return true;
            }
            case 1020: {
                if (59 != current) break;
                this.match = "\u2111";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1021: {
                if (114 != current) break;
                this.state = 1022;
                return true;
            }
            case 1022: {
                if (97 != current) break;
                this.state = 1023;
                return true;
            }
            case 1023: {
                if (118 != current) break;
                this.state = 1024;
                return true;
            }
            case 1024: {
                if (101 != current) break;
                this.match = "\u00cc";
                this.matchLength = this.consumedCount;
                this.state = 1025;
                return true;
            }
            case 1025: {
                if (59 != current) break;
                this.match = "\u00cc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1026: {
                switch (current) {
                    case 59: {
                        this.match = "\u2111";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 1027;
                        return true;
                    }
                    case 112: {
                        this.state = 1037;
                        return true;
                    }
                }
                break;
            }
            case 1027: {
                if (99 == current) {
                    this.state = 1028;
                    return true;
                }
                if (103 != current) break;
                this.state = 1030;
                return true;
            }
            case 1028: {
                if (114 != current) break;
                this.state = 1029;
                return true;
            }
            case 1029: {
                if (59 != current) break;
                this.match = "\u012a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1030: {
                if (105 != current) break;
                this.state = 1031;
                return true;
            }
            case 1031: {
                if (110 != current) break;
                this.state = 1032;
                return true;
            }
            case 1032: {
                if (97 != current) break;
                this.state = 1033;
                return true;
            }
            case 1033: {
                if (114 != current) break;
                this.state = 1034;
                return true;
            }
            case 1034: {
                if (121 != current) break;
                this.state = 1035;
                return true;
            }
            case 1035: {
                if (73 != current) break;
                this.state = 1036;
                return true;
            }
            case 1036: {
                if (59 != current) break;
                this.match = "\u2148";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1037: {
                if (108 != current) break;
                this.state = 1038;
                return true;
            }
            case 1038: {
                if (105 != current) break;
                this.state = 1039;
                return true;
            }
            case 1039: {
                if (101 != current) break;
                this.state = 1040;
                return true;
            }
            case 1040: {
                if (115 != current) break;
                this.state = 1041;
                return true;
            }
            case 1041: {
                if (59 != current) break;
                this.match = "\u21d2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1042: {
                if (116 == current) {
                    this.state = 1043;
                    return true;
                }
                if (118 != current) break;
                this.state = 1057;
                return true;
            }
            case 1043: {
                if (59 == current) {
                    this.match = "\u222c";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 1044;
                return true;
            }
            case 1044: {
                if (103 == current) {
                    this.state = 1045;
                    return true;
                }
                if (114 != current) break;
                this.state = 1049;
                return true;
            }
            case 1045: {
                if (114 != current) break;
                this.state = 1046;
                return true;
            }
            case 1046: {
                if (97 != current) break;
                this.state = 1047;
                return true;
            }
            case 1047: {
                if (108 != current) break;
                this.state = 1048;
                return true;
            }
            case 1048: {
                if (59 != current) break;
                this.match = "\u222b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1049: {
                if (115 != current) break;
                this.state = 1050;
                return true;
            }
            case 1050: {
                if (101 != current) break;
                this.state = 1051;
                return true;
            }
            case 1051: {
                if (99 != current) break;
                this.state = 1052;
                return true;
            }
            case 1052: {
                if (116 != current) break;
                this.state = 1053;
                return true;
            }
            case 1053: {
                if (105 != current) break;
                this.state = 1054;
                return true;
            }
            case 1054: {
                if (111 != current) break;
                this.state = 1055;
                return true;
            }
            case 1055: {
                if (110 != current) break;
                this.state = 1056;
                return true;
            }
            case 1056: {
                if (59 != current) break;
                this.match = "\u22c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1057: {
                if (105 != current) break;
                this.state = 1058;
                return true;
            }
            case 1058: {
                if (115 != current) break;
                this.state = 1059;
                return true;
            }
            case 1059: {
                if (105 != current) break;
                this.state = 1060;
                return true;
            }
            case 1060: {
                if (98 != current) break;
                this.state = 1061;
                return true;
            }
            case 1061: {
                if (108 != current) break;
                this.state = 1062;
                return true;
            }
            case 1062: {
                if (101 != current) break;
                this.state = 1063;
                return true;
            }
            case 1063: {
                if (67 == current) {
                    this.state = 1064;
                    return true;
                }
                if (84 != current) break;
                this.state = 1069;
                return true;
            }
            case 1064: {
                if (111 != current) break;
                this.state = 1065;
                return true;
            }
            case 1065: {
                if (109 != current) break;
                this.state = 1066;
                return true;
            }
            case 1066: {
                if (109 != current) break;
                this.state = 1067;
                return true;
            }
            case 1067: {
                if (97 != current) break;
                this.state = 1068;
                return true;
            }
            case 1068: {
                if (59 != current) break;
                this.match = "\u2063";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1069: {
                if (105 != current) break;
                this.state = 1070;
                return true;
            }
            case 1070: {
                if (109 != current) break;
                this.state = 1071;
                return true;
            }
            case 1071: {
                if (101 != current) break;
                this.state = 1072;
                return true;
            }
            case 1072: {
                if (115 != current) break;
                this.state = 1073;
                return true;
            }
            case 1073: {
                if (59 != current) break;
                this.match = "\u2062";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1074: {
                switch (current) {
                    case 103: {
                        this.state = 1075;
                        return true;
                    }
                    case 112: {
                        this.state = 1078;
                        return true;
                    }
                    case 116: {
                        this.state = 1080;
                        return true;
                    }
                }
                break;
            }
            case 1075: {
                if (111 != current) break;
                this.state = 1076;
                return true;
            }
            case 1076: {
                if (110 != current) break;
                this.state = 1077;
                return true;
            }
            case 1077: {
                if (59 != current) break;
                this.match = "\u012e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1078: {
                if (102 != current) break;
                this.state = 1079;
                return true;
            }
            case 1079: {
                if (59 != current) break;
                this.match = "\ud835\udd40";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1080: {
                if (97 != current) break;
                this.state = 1081;
                return true;
            }
            case 1081: {
                if (59 != current) break;
                this.match = "\u0399";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1082: {
                if (99 != current) break;
                this.state = 1083;
                return true;
            }
            case 1083: {
                if (114 != current) break;
                this.state = 1084;
                return true;
            }
            case 1084: {
                if (59 != current) break;
                this.match = "\u2110";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1085: {
                if (105 != current) break;
                this.state = 1086;
                return true;
            }
            case 1086: {
                if (108 != current) break;
                this.state = 1087;
                return true;
            }
            case 1087: {
                if (100 != current) break;
                this.state = 1088;
                return true;
            }
            case 1088: {
                if (101 != current) break;
                this.state = 1089;
                return true;
            }
            case 1089: {
                if (59 != current) break;
                this.match = "\u0128";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1090: {
                if (107 == current) {
                    this.state = 1091;
                    return true;
                }
                if (109 != current) break;
                this.state = 1094;
                return true;
            }
            case 1091: {
                if (99 != current) break;
                this.state = 1092;
                return true;
            }
            case 1092: {
                if (121 != current) break;
                this.state = 1093;
                return true;
            }
            case 1093: {
                if (59 != current) break;
                this.match = "\u0406";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1094: {
                if (108 != current) break;
                this.match = "\u00cf";
                this.matchLength = this.consumedCount;
                this.state = 1095;
                return true;
            }
            case 1095: {
                if (59 != current) break;
                this.match = "\u00cf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1096: {
                switch (current) {
                    case 99: {
                        this.state = 1097;
                        return true;
                    }
                    case 102: {
                        this.state = 1102;
                        return true;
                    }
                    case 111: {
                        this.state = 1104;
                        return true;
                    }
                    case 115: {
                        this.state = 1107;
                        return true;
                    }
                    case 117: {
                        this.state = 1114;
                        return true;
                    }
                }
                break;
            }
            case 1097: {
                if (105 == current) {
                    this.state = 1098;
                    return true;
                }
                if (121 != current) break;
                this.state = 1101;
                return true;
            }
            case 1098: {
                if (114 != current) break;
                this.state = 1099;
                return true;
            }
            case 1099: {
                if (99 != current) break;
                this.state = 1100;
                return true;
            }
            case 1100: {
                if (59 != current) break;
                this.match = "\u0134";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1101: {
                if (59 != current) break;
                this.match = "\u0419";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1102: {
                if (114 != current) break;
                this.state = 1103;
                return true;
            }
            case 1103: {
                if (59 != current) break;
                this.match = "\ud835\udd0d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1104: {
                if (112 != current) break;
                this.state = 1105;
                return true;
            }
            case 1105: {
                if (102 != current) break;
                this.state = 1106;
                return true;
            }
            case 1106: {
                if (59 != current) break;
                this.match = "\ud835\udd41";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1107: {
                if (99 == current) {
                    this.state = 1108;
                    return true;
                }
                if (101 != current) break;
                this.state = 1110;
                return true;
            }
            case 1108: {
                if (114 != current) break;
                this.state = 1109;
                return true;
            }
            case 1109: {
                if (59 != current) break;
                this.match = "\ud835\udca5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1110: {
                if (114 != current) break;
                this.state = 1111;
                return true;
            }
            case 1111: {
                if (99 != current) break;
                this.state = 1112;
                return true;
            }
            case 1112: {
                if (121 != current) break;
                this.state = 1113;
                return true;
            }
            case 1113: {
                if (59 != current) break;
                this.match = "\u0408";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1114: {
                if (107 != current) break;
                this.state = 1115;
                return true;
            }
            case 1115: {
                if (99 != current) break;
                this.state = 1116;
                return true;
            }
            case 1116: {
                if (121 != current) break;
                this.state = 1117;
                return true;
            }
            case 1117: {
                if (59 != current) break;
                this.match = "\u0404";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1118: {
                switch (current) {
                    case 72: {
                        this.state = 1119;
                        return true;
                    }
                    case 74: {
                        this.state = 1122;
                        return true;
                    }
                    case 97: {
                        this.state = 1125;
                        return true;
                    }
                    case 99: {
                        this.state = 1129;
                        return true;
                    }
                    case 102: {
                        this.state = 1135;
                        return true;
                    }
                    case 111: {
                        this.state = 1137;
                        return true;
                    }
                    case 115: {
                        this.state = 1140;
                        return true;
                    }
                }
                break;
            }
            case 1119: {
                if (99 != current) break;
                this.state = 1120;
                return true;
            }
            case 1120: {
                if (121 != current) break;
                this.state = 1121;
                return true;
            }
            case 1121: {
                if (59 != current) break;
                this.match = "\u0425";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1122: {
                if (99 != current) break;
                this.state = 1123;
                return true;
            }
            case 1123: {
                if (121 != current) break;
                this.state = 1124;
                return true;
            }
            case 1124: {
                if (59 != current) break;
                this.match = "\u040c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1125: {
                if (112 != current) break;
                this.state = 1126;
                return true;
            }
            case 1126: {
                if (112 != current) break;
                this.state = 1127;
                return true;
            }
            case 1127: {
                if (97 != current) break;
                this.state = 1128;
                return true;
            }
            case 1128: {
                if (59 != current) break;
                this.match = "\u039a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1129: {
                if (101 == current) {
                    this.state = 1130;
                    return true;
                }
                if (121 != current) break;
                this.state = 1134;
                return true;
            }
            case 1130: {
                if (100 != current) break;
                this.state = 1131;
                return true;
            }
            case 1131: {
                if (105 != current) break;
                this.state = 1132;
                return true;
            }
            case 1132: {
                if (108 != current) break;
                this.state = 1133;
                return true;
            }
            case 1133: {
                if (59 != current) break;
                this.match = "\u0136";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1134: {
                if (59 != current) break;
                this.match = "\u041a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1135: {
                if (114 != current) break;
                this.state = 1136;
                return true;
            }
            case 1136: {
                if (59 != current) break;
                this.match = "\ud835\udd0e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1137: {
                if (112 != current) break;
                this.state = 1138;
                return true;
            }
            case 1138: {
                if (102 != current) break;
                this.state = 1139;
                return true;
            }
            case 1139: {
                if (59 != current) break;
                this.match = "\ud835\udd42";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1140: {
                if (99 != current) break;
                this.state = 1141;
                return true;
            }
            case 1141: {
                if (114 != current) break;
                this.state = 1142;
                return true;
            }
            case 1142: {
                if (59 != current) break;
                this.match = "\ud835\udca6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1143: {
                switch (current) {
                    case 74: {
                        this.state = 1144;
                        return true;
                    }
                    case 84: {
                        this.match = "<";
                        this.matchLength = this.consumedCount;
                        this.state = 1147;
                        return true;
                    }
                    case 97: {
                        this.state = 1148;
                        return true;
                    }
                    case 99: {
                        this.state = 1169;
                        return true;
                    }
                    case 101: {
                        this.state = 1179;
                        return true;
                    }
                    case 102: {
                        this.state = 1404;
                        return true;
                    }
                    case 108: {
                        this.state = 1406;
                        return true;
                    }
                    case 109: {
                        this.state = 1415;
                        return true;
                    }
                    case 111: {
                        this.state = 1420;
                        return true;
                    }
                    case 115: {
                        this.state = 1505;
                        return true;
                    }
                    case 116: {
                        this.state = 1513;
                        return true;
                    }
                }
                break;
            }
            case 1144: {
                if (99 != current) break;
                this.state = 1145;
                return true;
            }
            case 1145: {
                if (121 != current) break;
                this.state = 1146;
                return true;
            }
            case 1146: {
                if (59 != current) break;
                this.match = "\u0409";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1147: {
                if (59 != current) break;
                this.match = "<";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1148: {
                switch (current) {
                    case 99: {
                        this.state = 1149;
                        return true;
                    }
                    case 109: {
                        this.state = 1153;
                        return true;
                    }
                    case 110: {
                        this.state = 1157;
                        return true;
                    }
                    case 112: {
                        this.state = 1159;
                        return true;
                    }
                    case 114: {
                        this.state = 1167;
                        return true;
                    }
                }
                break;
            }
            case 1149: {
                if (117 != current) break;
                this.state = 1150;
                return true;
            }
            case 1150: {
                if (116 != current) break;
                this.state = 1151;
                return true;
            }
            case 1151: {
                if (101 != current) break;
                this.state = 1152;
                return true;
            }
            case 1152: {
                if (59 != current) break;
                this.match = "\u0139";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1153: {
                if (98 != current) break;
                this.state = 1154;
                return true;
            }
            case 1154: {
                if (100 != current) break;
                this.state = 1155;
                return true;
            }
            case 1155: {
                if (97 != current) break;
                this.state = 1156;
                return true;
            }
            case 1156: {
                if (59 != current) break;
                this.match = "\u039b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1157: {
                if (103 != current) break;
                this.state = 1158;
                return true;
            }
            case 1158: {
                if (59 != current) break;
                this.match = "\u27ea";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1159: {
                if (108 != current) break;
                this.state = 1160;
                return true;
            }
            case 1160: {
                if (97 != current) break;
                this.state = 1161;
                return true;
            }
            case 1161: {
                if (99 != current) break;
                this.state = 1162;
                return true;
            }
            case 1162: {
                if (101 != current) break;
                this.state = 1163;
                return true;
            }
            case 1163: {
                if (116 != current) break;
                this.state = 1164;
                return true;
            }
            case 1164: {
                if (114 != current) break;
                this.state = 1165;
                return true;
            }
            case 1165: {
                if (102 != current) break;
                this.state = 1166;
                return true;
            }
            case 1166: {
                if (59 != current) break;
                this.match = "\u2112";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1167: {
                if (114 != current) break;
                this.state = 1168;
                return true;
            }
            case 1168: {
                if (59 != current) break;
                this.match = "\u219e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1169: {
                switch (current) {
                    case 97: {
                        this.state = 1170;
                        return true;
                    }
                    case 101: {
                        this.state = 1174;
                        return true;
                    }
                    case 121: {
                        this.state = 1178;
                        return true;
                    }
                }
                break;
            }
            case 1170: {
                if (114 != current) break;
                this.state = 1171;
                return true;
            }
            case 1171: {
                if (111 != current) break;
                this.state = 1172;
                return true;
            }
            case 1172: {
                if (110 != current) break;
                this.state = 1173;
                return true;
            }
            case 1173: {
                if (59 != current) break;
                this.match = "\u013d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1174: {
                if (100 != current) break;
                this.state = 1175;
                return true;
            }
            case 1175: {
                if (105 != current) break;
                this.state = 1176;
                return true;
            }
            case 1176: {
                if (108 != current) break;
                this.state = 1177;
                return true;
            }
            case 1177: {
                if (59 != current) break;
                this.match = "\u013b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1178: {
                if (59 != current) break;
                this.match = "\u041b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1179: {
                if (102 == current) {
                    this.state = 1180;
                    return true;
                }
                if (115 != current) break;
                this.state = 1355;
                return true;
            }
            case 1180: {
                if (116 != current) break;
                this.state = 1181;
                return true;
            }
            case 1181: {
                switch (current) {
                    case 65: {
                        this.state = 1182;
                        return true;
                    }
                    case 67: {
                        this.state = 1211;
                        return true;
                    }
                    case 68: {
                        this.state = 1218;
                        return true;
                    }
                    case 70: {
                        this.state = 1251;
                        return true;
                    }
                    case 82: {
                        this.state = 1256;
                        return true;
                    }
                    case 84: {
                        this.state = 1272;
                        return true;
                    }
                    case 85: {
                        this.state = 1301;
                        return true;
                    }
                    case 86: {
                        this.state = 1331;
                        return true;
                    }
                    case 97: {
                        this.state = 1340;
                        return true;
                    }
                    case 114: {
                        this.state = 1345;
                        return true;
                    }
                }
                break;
            }
            case 1182: {
                if (110 == current) {
                    this.state = 1183;
                    return true;
                }
                if (114 != current) break;
                this.state = 1194;
                return true;
            }
            case 1183: {
                if (103 != current) break;
                this.state = 1184;
                return true;
            }
            case 1184: {
                if (108 != current) break;
                this.state = 1185;
                return true;
            }
            case 1185: {
                if (101 != current) break;
                this.state = 1186;
                return true;
            }
            case 1186: {
                if (66 != current) break;
                this.state = 1187;
                return true;
            }
            case 1187: {
                if (114 != current) break;
                this.state = 1188;
                return true;
            }
            case 1188: {
                if (97 != current) break;
                this.state = 1189;
                return true;
            }
            case 1189: {
                if (99 != current) break;
                this.state = 1190;
                return true;
            }
            case 1190: {
                if (107 != current) break;
                this.state = 1191;
                return true;
            }
            case 1191: {
                if (101 != current) break;
                this.state = 1192;
                return true;
            }
            case 1192: {
                if (116 != current) break;
                this.state = 1193;
                return true;
            }
            case 1193: {
                if (59 != current) break;
                this.match = "\u27e8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1194: {
                if (114 != current) break;
                this.state = 1195;
                return true;
            }
            case 1195: {
                if (111 != current) break;
                this.state = 1196;
                return true;
            }
            case 1196: {
                if (119 != current) break;
                this.state = 1197;
                return true;
            }
            case 1197: {
                switch (current) {
                    case 59: {
                        this.match = "\u2190";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1198;
                        return true;
                    }
                    case 82: {
                        this.state = 1201;
                        return true;
                    }
                }
                break;
            }
            case 1198: {
                if (97 != current) break;
                this.state = 1199;
                return true;
            }
            case 1199: {
                if (114 != current) break;
                this.state = 1200;
                return true;
            }
            case 1200: {
                if (59 != current) break;
                this.match = "\u21e4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1201: {
                if (105 != current) break;
                this.state = 1202;
                return true;
            }
            case 1202: {
                if (103 != current) break;
                this.state = 1203;
                return true;
            }
            case 1203: {
                if (104 != current) break;
                this.state = 1204;
                return true;
            }
            case 1204: {
                if (116 != current) break;
                this.state = 1205;
                return true;
            }
            case 1205: {
                if (65 != current) break;
                this.state = 1206;
                return true;
            }
            case 1206: {
                if (114 != current) break;
                this.state = 1207;
                return true;
            }
            case 1207: {
                if (114 != current) break;
                this.state = 1208;
                return true;
            }
            case 1208: {
                if (111 != current) break;
                this.state = 1209;
                return true;
            }
            case 1209: {
                if (119 != current) break;
                this.state = 1210;
                return true;
            }
            case 1210: {
                if (59 != current) break;
                this.match = "\u21c6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1211: {
                if (101 != current) break;
                this.state = 1212;
                return true;
            }
            case 1212: {
                if (105 != current) break;
                this.state = 1213;
                return true;
            }
            case 1213: {
                if (108 != current) break;
                this.state = 1214;
                return true;
            }
            case 1214: {
                if (105 != current) break;
                this.state = 1215;
                return true;
            }
            case 1215: {
                if (110 != current) break;
                this.state = 1216;
                return true;
            }
            case 1216: {
                if (103 != current) break;
                this.state = 1217;
                return true;
            }
            case 1217: {
                if (59 != current) break;
                this.match = "\u2308";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1218: {
                if (111 != current) break;
                this.state = 1219;
                return true;
            }
            case 1219: {
                if (117 == current) {
                    this.state = 1220;
                    return true;
                }
                if (119 != current) break;
                this.state = 1231;
                return true;
            }
            case 1220: {
                if (98 != current) break;
                this.state = 1221;
                return true;
            }
            case 1221: {
                if (108 != current) break;
                this.state = 1222;
                return true;
            }
            case 1222: {
                if (101 != current) break;
                this.state = 1223;
                return true;
            }
            case 1223: {
                if (66 != current) break;
                this.state = 1224;
                return true;
            }
            case 1224: {
                if (114 != current) break;
                this.state = 1225;
                return true;
            }
            case 1225: {
                if (97 != current) break;
                this.state = 1226;
                return true;
            }
            case 1226: {
                if (99 != current) break;
                this.state = 1227;
                return true;
            }
            case 1227: {
                if (107 != current) break;
                this.state = 1228;
                return true;
            }
            case 1228: {
                if (101 != current) break;
                this.state = 1229;
                return true;
            }
            case 1229: {
                if (116 != current) break;
                this.state = 1230;
                return true;
            }
            case 1230: {
                if (59 != current) break;
                this.match = "\u27e6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1231: {
                if (110 != current) break;
                this.state = 1232;
                return true;
            }
            case 1232: {
                if (84 == current) {
                    this.state = 1233;
                    return true;
                }
                if (86 != current) break;
                this.state = 1242;
                return true;
            }
            case 1233: {
                if (101 != current) break;
                this.state = 1234;
                return true;
            }
            case 1234: {
                if (101 != current) break;
                this.state = 1235;
                return true;
            }
            case 1235: {
                if (86 != current) break;
                this.state = 1236;
                return true;
            }
            case 1236: {
                if (101 != current) break;
                this.state = 1237;
                return true;
            }
            case 1237: {
                if (99 != current) break;
                this.state = 1238;
                return true;
            }
            case 1238: {
                if (116 != current) break;
                this.state = 1239;
                return true;
            }
            case 1239: {
                if (111 != current) break;
                this.state = 1240;
                return true;
            }
            case 1240: {
                if (114 != current) break;
                this.state = 1241;
                return true;
            }
            case 1241: {
                if (59 != current) break;
                this.match = "\u2961";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1242: {
                if (101 != current) break;
                this.state = 1243;
                return true;
            }
            case 1243: {
                if (99 != current) break;
                this.state = 1244;
                return true;
            }
            case 1244: {
                if (116 != current) break;
                this.state = 1245;
                return true;
            }
            case 1245: {
                if (111 != current) break;
                this.state = 1246;
                return true;
            }
            case 1246: {
                if (114 != current) break;
                this.state = 1247;
                return true;
            }
            case 1247: {
                if (59 == current) {
                    this.match = "\u21c3";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 1248;
                return true;
            }
            case 1248: {
                if (97 != current) break;
                this.state = 1249;
                return true;
            }
            case 1249: {
                if (114 != current) break;
                this.state = 1250;
                return true;
            }
            case 1250: {
                if (59 != current) break;
                this.match = "\u2959";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1251: {
                if (108 != current) break;
                this.state = 1252;
                return true;
            }
            case 1252: {
                if (111 != current) break;
                this.state = 1253;
                return true;
            }
            case 1253: {
                if (111 != current) break;
                this.state = 1254;
                return true;
            }
            case 1254: {
                if (114 != current) break;
                this.state = 1255;
                return true;
            }
            case 1255: {
                if (59 != current) break;
                this.match = "\u230a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1256: {
                if (105 != current) break;
                this.state = 1257;
                return true;
            }
            case 1257: {
                if (103 != current) break;
                this.state = 1258;
                return true;
            }
            case 1258: {
                if (104 != current) break;
                this.state = 1259;
                return true;
            }
            case 1259: {
                if (116 != current) break;
                this.state = 1260;
                return true;
            }
            case 1260: {
                if (65 == current) {
                    this.state = 1261;
                    return true;
                }
                if (86 != current) break;
                this.state = 1266;
                return true;
            }
            case 1261: {
                if (114 != current) break;
                this.state = 1262;
                return true;
            }
            case 1262: {
                if (114 != current) break;
                this.state = 1263;
                return true;
            }
            case 1263: {
                if (111 != current) break;
                this.state = 1264;
                return true;
            }
            case 1264: {
                if (119 != current) break;
                this.state = 1265;
                return true;
            }
            case 1265: {
                if (59 != current) break;
                this.match = "\u2194";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1266: {
                if (101 != current) break;
                this.state = 1267;
                return true;
            }
            case 1267: {
                if (99 != current) break;
                this.state = 1268;
                return true;
            }
            case 1268: {
                if (116 != current) break;
                this.state = 1269;
                return true;
            }
            case 1269: {
                if (111 != current) break;
                this.state = 1270;
                return true;
            }
            case 1270: {
                if (114 != current) break;
                this.state = 1271;
                return true;
            }
            case 1271: {
                if (59 != current) break;
                this.match = "\u294e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1272: {
                if (101 == current) {
                    this.state = 1273;
                    return true;
                }
                if (114 != current) break;
                this.state = 1286;
                return true;
            }
            case 1273: {
                if (101 != current) break;
                this.state = 1274;
                return true;
            }
            case 1274: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 65: {
                        this.state = 1275;
                        return true;
                    }
                    case 86: {
                        this.state = 1280;
                        return true;
                    }
                }
                break;
            }
            case 1275: {
                if (114 != current) break;
                this.state = 1276;
                return true;
            }
            case 1276: {
                if (114 != current) break;
                this.state = 1277;
                return true;
            }
            case 1277: {
                if (111 != current) break;
                this.state = 1278;
                return true;
            }
            case 1278: {
                if (119 != current) break;
                this.state = 1279;
                return true;
            }
            case 1279: {
                if (59 != current) break;
                this.match = "\u21a4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1280: {
                if (101 != current) break;
                this.state = 1281;
                return true;
            }
            case 1281: {
                if (99 != current) break;
                this.state = 1282;
                return true;
            }
            case 1282: {
                if (116 != current) break;
                this.state = 1283;
                return true;
            }
            case 1283: {
                if (111 != current) break;
                this.state = 1284;
                return true;
            }
            case 1284: {
                if (114 != current) break;
                this.state = 1285;
                return true;
            }
            case 1285: {
                if (59 != current) break;
                this.match = "\u295a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1286: {
                if (105 != current) break;
                this.state = 1287;
                return true;
            }
            case 1287: {
                if (97 != current) break;
                this.state = 1288;
                return true;
            }
            case 1288: {
                if (110 != current) break;
                this.state = 1289;
                return true;
            }
            case 1289: {
                if (103 != current) break;
                this.state = 1290;
                return true;
            }
            case 1290: {
                if (108 != current) break;
                this.state = 1291;
                return true;
            }
            case 1291: {
                if (101 != current) break;
                this.state = 1292;
                return true;
            }
            case 1292: {
                switch (current) {
                    case 59: {
                        this.match = "\u22b2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1293;
                        return true;
                    }
                    case 69: {
                        this.state = 1296;
                        return true;
                    }
                }
                break;
            }
            case 1293: {
                if (97 != current) break;
                this.state = 1294;
                return true;
            }
            case 1294: {
                if (114 != current) break;
                this.state = 1295;
                return true;
            }
            case 1295: {
                if (59 != current) break;
                this.match = "\u29cf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1296: {
                if (113 != current) break;
                this.state = 1297;
                return true;
            }
            case 1297: {
                if (117 != current) break;
                this.state = 1298;
                return true;
            }
            case 1298: {
                if (97 != current) break;
                this.state = 1299;
                return true;
            }
            case 1299: {
                if (108 != current) break;
                this.state = 1300;
                return true;
            }
            case 1300: {
                if (59 != current) break;
                this.match = "\u22b4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1301: {
                if (112 != current) break;
                this.state = 1302;
                return true;
            }
            case 1302: {
                switch (current) {
                    case 68: {
                        this.state = 1303;
                        return true;
                    }
                    case 84: {
                        this.state = 1313;
                        return true;
                    }
                    case 86: {
                        this.state = 1322;
                        return true;
                    }
                }
                break;
            }
            case 1303: {
                if (111 != current) break;
                this.state = 1304;
                return true;
            }
            case 1304: {
                if (119 != current) break;
                this.state = 1305;
                return true;
            }
            case 1305: {
                if (110 != current) break;
                this.state = 1306;
                return true;
            }
            case 1306: {
                if (86 != current) break;
                this.state = 1307;
                return true;
            }
            case 1307: {
                if (101 != current) break;
                this.state = 1308;
                return true;
            }
            case 1308: {
                if (99 != current) break;
                this.state = 1309;
                return true;
            }
            case 1309: {
                if (116 != current) break;
                this.state = 1310;
                return true;
            }
            case 1310: {
                if (111 != current) break;
                this.state = 1311;
                return true;
            }
            case 1311: {
                if (114 != current) break;
                this.state = 1312;
                return true;
            }
            case 1312: {
                if (59 != current) break;
                this.match = "\u2951";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1313: {
                if (101 != current) break;
                this.state = 1314;
                return true;
            }
            case 1314: {
                if (101 != current) break;
                this.state = 1315;
                return true;
            }
            case 1315: {
                if (86 != current) break;
                this.state = 1316;
                return true;
            }
            case 1316: {
                if (101 != current) break;
                this.state = 1317;
                return true;
            }
            case 1317: {
                if (99 != current) break;
                this.state = 1318;
                return true;
            }
            case 1318: {
                if (116 != current) break;
                this.state = 1319;
                return true;
            }
            case 1319: {
                if (111 != current) break;
                this.state = 1320;
                return true;
            }
            case 1320: {
                if (114 != current) break;
                this.state = 1321;
                return true;
            }
            case 1321: {
                if (59 != current) break;
                this.match = "\u2960";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1322: {
                if (101 != current) break;
                this.state = 1323;
                return true;
            }
            case 1323: {
                if (99 != current) break;
                this.state = 1324;
                return true;
            }
            case 1324: {
                if (116 != current) break;
                this.state = 1325;
                return true;
            }
            case 1325: {
                if (111 != current) break;
                this.state = 1326;
                return true;
            }
            case 1326: {
                if (114 != current) break;
                this.state = 1327;
                return true;
            }
            case 1327: {
                if (59 == current) {
                    this.match = "\u21bf";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 1328;
                return true;
            }
            case 1328: {
                if (97 != current) break;
                this.state = 1329;
                return true;
            }
            case 1329: {
                if (114 != current) break;
                this.state = 1330;
                return true;
            }
            case 1330: {
                if (59 != current) break;
                this.match = "\u2958";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1331: {
                if (101 != current) break;
                this.state = 1332;
                return true;
            }
            case 1332: {
                if (99 != current) break;
                this.state = 1333;
                return true;
            }
            case 1333: {
                if (116 != current) break;
                this.state = 1334;
                return true;
            }
            case 1334: {
                if (111 != current) break;
                this.state = 1335;
                return true;
            }
            case 1335: {
                if (114 != current) break;
                this.state = 1336;
                return true;
            }
            case 1336: {
                if (59 == current) {
                    this.match = "\u21bc";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 1337;
                return true;
            }
            case 1337: {
                if (97 != current) break;
                this.state = 1338;
                return true;
            }
            case 1338: {
                if (114 != current) break;
                this.state = 1339;
                return true;
            }
            case 1339: {
                if (59 != current) break;
                this.match = "\u2952";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1340: {
                if (114 != current) break;
                this.state = 1341;
                return true;
            }
            case 1341: {
                if (114 != current) break;
                this.state = 1342;
                return true;
            }
            case 1342: {
                if (111 != current) break;
                this.state = 1343;
                return true;
            }
            case 1343: {
                if (119 != current) break;
                this.state = 1344;
                return true;
            }
            case 1344: {
                if (59 != current) break;
                this.match = "\u21d0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1345: {
                if (105 != current) break;
                this.state = 1346;
                return true;
            }
            case 1346: {
                if (103 != current) break;
                this.state = 1347;
                return true;
            }
            case 1347: {
                if (104 != current) break;
                this.state = 1348;
                return true;
            }
            case 1348: {
                if (116 != current) break;
                this.state = 1349;
                return true;
            }
            case 1349: {
                if (97 != current) break;
                this.state = 1350;
                return true;
            }
            case 1350: {
                if (114 != current) break;
                this.state = 1351;
                return true;
            }
            case 1351: {
                if (114 != current) break;
                this.state = 1352;
                return true;
            }
            case 1352: {
                if (111 != current) break;
                this.state = 1353;
                return true;
            }
            case 1353: {
                if (119 != current) break;
                this.state = 1354;
                return true;
            }
            case 1354: {
                if (59 != current) break;
                this.match = "\u21d4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1355: {
                if (115 != current) break;
                this.state = 1356;
                return true;
            }
            case 1356: {
                switch (current) {
                    case 69: {
                        this.state = 1357;
                        return true;
                    }
                    case 70: {
                        this.state = 1369;
                        return true;
                    }
                    case 71: {
                        this.state = 1378;
                        return true;
                    }
                    case 76: {
                        this.state = 1385;
                        return true;
                    }
                    case 83: {
                        this.state = 1389;
                        return true;
                    }
                    case 84: {
                        this.state = 1399;
                        return true;
                    }
                }
                break;
            }
            case 1357: {
                if (113 != current) break;
                this.state = 1358;
                return true;
            }
            case 1358: {
                if (117 != current) break;
                this.state = 1359;
                return true;
            }
            case 1359: {
                if (97 != current) break;
                this.state = 1360;
                return true;
            }
            case 1360: {
                if (108 != current) break;
                this.state = 1361;
                return true;
            }
            case 1361: {
                if (71 != current) break;
                this.state = 1362;
                return true;
            }
            case 1362: {
                if (114 != current) break;
                this.state = 1363;
                return true;
            }
            case 1363: {
                if (101 != current) break;
                this.state = 1364;
                return true;
            }
            case 1364: {
                if (97 != current) break;
                this.state = 1365;
                return true;
            }
            case 1365: {
                if (116 != current) break;
                this.state = 1366;
                return true;
            }
            case 1366: {
                if (101 != current) break;
                this.state = 1367;
                return true;
            }
            case 1367: {
                if (114 != current) break;
                this.state = 1368;
                return true;
            }
            case 1368: {
                if (59 != current) break;
                this.match = "\u22da";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1369: {
                if (117 != current) break;
                this.state = 1370;
                return true;
            }
            case 1370: {
                if (108 != current) break;
                this.state = 1371;
                return true;
            }
            case 1371: {
                if (108 != current) break;
                this.state = 1372;
                return true;
            }
            case 1372: {
                if (69 != current) break;
                this.state = 1373;
                return true;
            }
            case 1373: {
                if (113 != current) break;
                this.state = 1374;
                return true;
            }
            case 1374: {
                if (117 != current) break;
                this.state = 1375;
                return true;
            }
            case 1375: {
                if (97 != current) break;
                this.state = 1376;
                return true;
            }
            case 1376: {
                if (108 != current) break;
                this.state = 1377;
                return true;
            }
            case 1377: {
                if (59 != current) break;
                this.match = "\u2266";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1378: {
                if (114 != current) break;
                this.state = 1379;
                return true;
            }
            case 1379: {
                if (101 != current) break;
                this.state = 1380;
                return true;
            }
            case 1380: {
                if (97 != current) break;
                this.state = 1381;
                return true;
            }
            case 1381: {
                if (116 != current) break;
                this.state = 1382;
                return true;
            }
            case 1382: {
                if (101 != current) break;
                this.state = 1383;
                return true;
            }
            case 1383: {
                if (114 != current) break;
                this.state = 1384;
                return true;
            }
            case 1384: {
                if (59 != current) break;
                this.match = "\u2276";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1385: {
                if (101 != current) break;
                this.state = 1386;
                return true;
            }
            case 1386: {
                if (115 != current) break;
                this.state = 1387;
                return true;
            }
            case 1387: {
                if (115 != current) break;
                this.state = 1388;
                return true;
            }
            case 1388: {
                if (59 != current) break;
                this.match = "\u2aa1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1389: {
                if (108 != current) break;
                this.state = 1390;
                return true;
            }
            case 1390: {
                if (97 != current) break;
                this.state = 1391;
                return true;
            }
            case 1391: {
                if (110 != current) break;
                this.state = 1392;
                return true;
            }
            case 1392: {
                if (116 != current) break;
                this.state = 1393;
                return true;
            }
            case 1393: {
                if (69 != current) break;
                this.state = 1394;
                return true;
            }
            case 1394: {
                if (113 != current) break;
                this.state = 1395;
                return true;
            }
            case 1395: {
                if (117 != current) break;
                this.state = 1396;
                return true;
            }
            case 1396: {
                if (97 != current) break;
                this.state = 1397;
                return true;
            }
            case 1397: {
                if (108 != current) break;
                this.state = 1398;
                return true;
            }
            case 1398: {
                if (59 != current) break;
                this.match = "\u2a7d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1399: {
                if (105 != current) break;
                this.state = 1400;
                return true;
            }
            case 1400: {
                if (108 != current) break;
                this.state = 1401;
                return true;
            }
            case 1401: {
                if (100 != current) break;
                this.state = 1402;
                return true;
            }
            case 1402: {
                if (101 != current) break;
                this.state = 1403;
                return true;
            }
            case 1403: {
                if (59 != current) break;
                this.match = "\u2272";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1404: {
                if (114 != current) break;
                this.state = 1405;
                return true;
            }
            case 1405: {
                if (59 != current) break;
                this.match = "\ud835\udd0f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1406: {
                if (59 == current) {
                    this.match = "\u22d8";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 1407;
                return true;
            }
            case 1407: {
                if (102 != current) break;
                this.state = 1408;
                return true;
            }
            case 1408: {
                if (116 != current) break;
                this.state = 1409;
                return true;
            }
            case 1409: {
                if (97 != current) break;
                this.state = 1410;
                return true;
            }
            case 1410: {
                if (114 != current) break;
                this.state = 1411;
                return true;
            }
            case 1411: {
                if (114 != current) break;
                this.state = 1412;
                return true;
            }
            case 1412: {
                if (111 != current) break;
                this.state = 1413;
                return true;
            }
            case 1413: {
                if (119 != current) break;
                this.state = 1414;
                return true;
            }
            case 1414: {
                if (59 != current) break;
                this.match = "\u21da";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1415: {
                if (105 != current) break;
                this.state = 1416;
                return true;
            }
            case 1416: {
                if (100 != current) break;
                this.state = 1417;
                return true;
            }
            case 1417: {
                if (111 != current) break;
                this.state = 1418;
                return true;
            }
            case 1418: {
                if (116 != current) break;
                this.state = 1419;
                return true;
            }
            case 1419: {
                if (59 != current) break;
                this.match = "\u013f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1420: {
                switch (current) {
                    case 110: {
                        this.state = 1421;
                        return true;
                    }
                    case 112: {
                        this.state = 1481;
                        return true;
                    }
                    case 119: {
                        this.state = 1483;
                        return true;
                    }
                }
                break;
            }
            case 1421: {
                if (103 != current) break;
                this.state = 1422;
                return true;
            }
            case 1422: {
                switch (current) {
                    case 76: {
                        this.state = 1423;
                        return true;
                    }
                    case 82: {
                        this.state = 1442;
                        return true;
                    }
                    case 108: {
                        this.state = 1452;
                        return true;
                    }
                    case 114: {
                        this.state = 1471;
                        return true;
                    }
                }
                break;
            }
            case 1423: {
                if (101 != current) break;
                this.state = 1424;
                return true;
            }
            case 1424: {
                if (102 != current) break;
                this.state = 1425;
                return true;
            }
            case 1425: {
                if (116 != current) break;
                this.state = 1426;
                return true;
            }
            case 1426: {
                if (65 == current) {
                    this.state = 1427;
                    return true;
                }
                if (82 != current) break;
                this.state = 1432;
                return true;
            }
            case 1427: {
                if (114 != current) break;
                this.state = 1428;
                return true;
            }
            case 1428: {
                if (114 != current) break;
                this.state = 1429;
                return true;
            }
            case 1429: {
                if (111 != current) break;
                this.state = 1430;
                return true;
            }
            case 1430: {
                if (119 != current) break;
                this.state = 1431;
                return true;
            }
            case 1431: {
                if (59 != current) break;
                this.match = "\u27f5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1432: {
                if (105 != current) break;
                this.state = 1433;
                return true;
            }
            case 1433: {
                if (103 != current) break;
                this.state = 1434;
                return true;
            }
            case 1434: {
                if (104 != current) break;
                this.state = 1435;
                return true;
            }
            case 1435: {
                if (116 != current) break;
                this.state = 1436;
                return true;
            }
            case 1436: {
                if (65 != current) break;
                this.state = 1437;
                return true;
            }
            case 1437: {
                if (114 != current) break;
                this.state = 1438;
                return true;
            }
            case 1438: {
                if (114 != current) break;
                this.state = 1439;
                return true;
            }
            case 1439: {
                if (111 != current) break;
                this.state = 1440;
                return true;
            }
            case 1440: {
                if (119 != current) break;
                this.state = 1441;
                return true;
            }
            case 1441: {
                if (59 != current) break;
                this.match = "\u27f7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1442: {
                if (105 != current) break;
                this.state = 1443;
                return true;
            }
            case 1443: {
                if (103 != current) break;
                this.state = 1444;
                return true;
            }
            case 1444: {
                if (104 != current) break;
                this.state = 1445;
                return true;
            }
            case 1445: {
                if (116 != current) break;
                this.state = 1446;
                return true;
            }
            case 1446: {
                if (65 != current) break;
                this.state = 1447;
                return true;
            }
            case 1447: {
                if (114 != current) break;
                this.state = 1448;
                return true;
            }
            case 1448: {
                if (114 != current) break;
                this.state = 1449;
                return true;
            }
            case 1449: {
                if (111 != current) break;
                this.state = 1450;
                return true;
            }
            case 1450: {
                if (119 != current) break;
                this.state = 1451;
                return true;
            }
            case 1451: {
                if (59 != current) break;
                this.match = "\u27f6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1452: {
                if (101 != current) break;
                this.state = 1453;
                return true;
            }
            case 1453: {
                if (102 != current) break;
                this.state = 1454;
                return true;
            }
            case 1454: {
                if (116 != current) break;
                this.state = 1455;
                return true;
            }
            case 1455: {
                if (97 == current) {
                    this.state = 1456;
                    return true;
                }
                if (114 != current) break;
                this.state = 1461;
                return true;
            }
            case 1456: {
                if (114 != current) break;
                this.state = 1457;
                return true;
            }
            case 1457: {
                if (114 != current) break;
                this.state = 1458;
                return true;
            }
            case 1458: {
                if (111 != current) break;
                this.state = 1459;
                return true;
            }
            case 1459: {
                if (119 != current) break;
                this.state = 1460;
                return true;
            }
            case 1460: {
                if (59 != current) break;
                this.match = "\u27f8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1461: {
                if (105 != current) break;
                this.state = 1462;
                return true;
            }
            case 1462: {
                if (103 != current) break;
                this.state = 1463;
                return true;
            }
            case 1463: {
                if (104 != current) break;
                this.state = 1464;
                return true;
            }
            case 1464: {
                if (116 != current) break;
                this.state = 1465;
                return true;
            }
            case 1465: {
                if (97 != current) break;
                this.state = 1466;
                return true;
            }
            case 1466: {
                if (114 != current) break;
                this.state = 1467;
                return true;
            }
            case 1467: {
                if (114 != current) break;
                this.state = 1468;
                return true;
            }
            case 1468: {
                if (111 != current) break;
                this.state = 1469;
                return true;
            }
            case 1469: {
                if (119 != current) break;
                this.state = 1470;
                return true;
            }
            case 1470: {
                if (59 != current) break;
                this.match = "\u27fa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1471: {
                if (105 != current) break;
                this.state = 1472;
                return true;
            }
            case 1472: {
                if (103 != current) break;
                this.state = 1473;
                return true;
            }
            case 1473: {
                if (104 != current) break;
                this.state = 1474;
                return true;
            }
            case 1474: {
                if (116 != current) break;
                this.state = 1475;
                return true;
            }
            case 1475: {
                if (97 != current) break;
                this.state = 1476;
                return true;
            }
            case 1476: {
                if (114 != current) break;
                this.state = 1477;
                return true;
            }
            case 1477: {
                if (114 != current) break;
                this.state = 1478;
                return true;
            }
            case 1478: {
                if (111 != current) break;
                this.state = 1479;
                return true;
            }
            case 1479: {
                if (119 != current) break;
                this.state = 1480;
                return true;
            }
            case 1480: {
                if (59 != current) break;
                this.match = "\u27f9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1481: {
                if (102 != current) break;
                this.state = 1482;
                return true;
            }
            case 1482: {
                if (59 != current) break;
                this.match = "\ud835\udd43";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1483: {
                if (101 != current) break;
                this.state = 1484;
                return true;
            }
            case 1484: {
                if (114 != current) break;
                this.state = 1485;
                return true;
            }
            case 1485: {
                if (76 == current) {
                    this.state = 1486;
                    return true;
                }
                if (82 != current) break;
                this.state = 1495;
                return true;
            }
            case 1486: {
                if (101 != current) break;
                this.state = 1487;
                return true;
            }
            case 1487: {
                if (102 != current) break;
                this.state = 1488;
                return true;
            }
            case 1488: {
                if (116 != current) break;
                this.state = 1489;
                return true;
            }
            case 1489: {
                if (65 != current) break;
                this.state = 1490;
                return true;
            }
            case 1490: {
                if (114 != current) break;
                this.state = 1491;
                return true;
            }
            case 1491: {
                if (114 != current) break;
                this.state = 1492;
                return true;
            }
            case 1492: {
                if (111 != current) break;
                this.state = 1493;
                return true;
            }
            case 1493: {
                if (119 != current) break;
                this.state = 1494;
                return true;
            }
            case 1494: {
                if (59 != current) break;
                this.match = "\u2199";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1495: {
                if (105 != current) break;
                this.state = 1496;
                return true;
            }
            case 1496: {
                if (103 != current) break;
                this.state = 1497;
                return true;
            }
            case 1497: {
                if (104 != current) break;
                this.state = 1498;
                return true;
            }
            case 1498: {
                if (116 != current) break;
                this.state = 1499;
                return true;
            }
            case 1499: {
                if (65 != current) break;
                this.state = 1500;
                return true;
            }
            case 1500: {
                if (114 != current) break;
                this.state = 1501;
                return true;
            }
            case 1501: {
                if (114 != current) break;
                this.state = 1502;
                return true;
            }
            case 1502: {
                if (111 != current) break;
                this.state = 1503;
                return true;
            }
            case 1503: {
                if (119 != current) break;
                this.state = 1504;
                return true;
            }
            case 1504: {
                if (59 != current) break;
                this.match = "\u2198";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1505: {
                switch (current) {
                    case 99: {
                        this.state = 1506;
                        return true;
                    }
                    case 104: {
                        this.state = 1508;
                        return true;
                    }
                    case 116: {
                        this.state = 1509;
                        return true;
                    }
                }
                break;
            }
            case 1506: {
                if (114 != current) break;
                this.state = 1507;
                return true;
            }
            case 1507: {
                if (59 != current) break;
                this.match = "\u2112";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1508: {
                if (59 != current) break;
                this.match = "\u21b0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1509: {
                if (114 != current) break;
                this.state = 1510;
                return true;
            }
            case 1510: {
                if (111 != current) break;
                this.state = 1511;
                return true;
            }
            case 1511: {
                if (107 != current) break;
                this.state = 1512;
                return true;
            }
            case 1512: {
                if (59 != current) break;
                this.match = "\u0141";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1513: {
                if (59 != current) break;
                this.match = "\u226a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1514: {
                switch (current) {
                    case 97: {
                        this.state = 1515;
                        return true;
                    }
                    case 99: {
                        this.state = 1517;
                        return true;
                    }
                    case 101: {
                        this.state = 1519;
                        return true;
                    }
                    case 102: {
                        this.state = 1536;
                        return true;
                    }
                    case 105: {
                        this.state = 1538;
                        return true;
                    }
                    case 111: {
                        this.state = 1546;
                        return true;
                    }
                    case 115: {
                        this.state = 1549;
                        return true;
                    }
                    case 117: {
                        this.state = 1552;
                        return true;
                    }
                }
                break;
            }
            case 1515: {
                if (112 != current) break;
                this.state = 1516;
                return true;
            }
            case 1516: {
                if (59 != current) break;
                this.match = "\u2905";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1517: {
                if (121 != current) break;
                this.state = 1518;
                return true;
            }
            case 1518: {
                if (59 != current) break;
                this.match = "\u041c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1519: {
                if (100 == current) {
                    this.state = 1520;
                    return true;
                }
                if (108 != current) break;
                this.state = 1529;
                return true;
            }
            case 1520: {
                if (105 != current) break;
                this.state = 1521;
                return true;
            }
            case 1521: {
                if (117 != current) break;
                this.state = 1522;
                return true;
            }
            case 1522: {
                if (109 != current) break;
                this.state = 1523;
                return true;
            }
            case 1523: {
                if (83 != current) break;
                this.state = 1524;
                return true;
            }
            case 1524: {
                if (112 != current) break;
                this.state = 1525;
                return true;
            }
            case 1525: {
                if (97 != current) break;
                this.state = 1526;
                return true;
            }
            case 1526: {
                if (99 != current) break;
                this.state = 1527;
                return true;
            }
            case 1527: {
                if (101 != current) break;
                this.state = 1528;
                return true;
            }
            case 1528: {
                if (59 != current) break;
                this.match = "\u205f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1529: {
                if (108 != current) break;
                this.state = 1530;
                return true;
            }
            case 1530: {
                if (105 != current) break;
                this.state = 1531;
                return true;
            }
            case 1531: {
                if (110 != current) break;
                this.state = 1532;
                return true;
            }
            case 1532: {
                if (116 != current) break;
                this.state = 1533;
                return true;
            }
            case 1533: {
                if (114 != current) break;
                this.state = 1534;
                return true;
            }
            case 1534: {
                if (102 != current) break;
                this.state = 1535;
                return true;
            }
            case 1535: {
                if (59 != current) break;
                this.match = "\u2133";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1536: {
                if (114 != current) break;
                this.state = 1537;
                return true;
            }
            case 1537: {
                if (59 != current) break;
                this.match = "\ud835\udd10";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1538: {
                if (110 != current) break;
                this.state = 1539;
                return true;
            }
            case 1539: {
                if (117 != current) break;
                this.state = 1540;
                return true;
            }
            case 1540: {
                if (115 != current) break;
                this.state = 1541;
                return true;
            }
            case 1541: {
                if (80 != current) break;
                this.state = 1542;
                return true;
            }
            case 1542: {
                if (108 != current) break;
                this.state = 1543;
                return true;
            }
            case 1543: {
                if (117 != current) break;
                this.state = 1544;
                return true;
            }
            case 1544: {
                if (115 != current) break;
                this.state = 1545;
                return true;
            }
            case 1545: {
                if (59 != current) break;
                this.match = "\u2213";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1546: {
                if (112 != current) break;
                this.state = 1547;
                return true;
            }
            case 1547: {
                if (102 != current) break;
                this.state = 1548;
                return true;
            }
            case 1548: {
                if (59 != current) break;
                this.match = "\ud835\udd44";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1549: {
                if (99 != current) break;
                this.state = 1550;
                return true;
            }
            case 1550: {
                if (114 != current) break;
                this.state = 1551;
                return true;
            }
            case 1551: {
                if (59 != current) break;
                this.match = "\u2133";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1552: {
                if (59 != current) break;
                this.match = "\u039c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1553: {
                switch (current) {
                    case 74: {
                        this.state = 1554;
                        return true;
                    }
                    case 97: {
                        this.state = 1557;
                        return true;
                    }
                    case 99: {
                        this.state = 1562;
                        return true;
                    }
                    case 101: {
                        this.state = 1572;
                        return true;
                    }
                    case 102: {
                        this.state = 1650;
                        return true;
                    }
                    case 111: {
                        this.state = 1652;
                        return true;
                    }
                    case 115: {
                        this.state = 2055;
                        return true;
                    }
                    case 116: {
                        this.state = 2058;
                        return true;
                    }
                    case 117: {
                        this.state = 2063;
                        return true;
                    }
                }
                break;
            }
            case 1554: {
                if (99 != current) break;
                this.state = 1555;
                return true;
            }
            case 1555: {
                if (121 != current) break;
                this.state = 1556;
                return true;
            }
            case 1556: {
                if (59 != current) break;
                this.match = "\u040a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1557: {
                if (99 != current) break;
                this.state = 1558;
                return true;
            }
            case 1558: {
                if (117 != current) break;
                this.state = 1559;
                return true;
            }
            case 1559: {
                if (116 != current) break;
                this.state = 1560;
                return true;
            }
            case 1560: {
                if (101 != current) break;
                this.state = 1561;
                return true;
            }
            case 1561: {
                if (59 != current) break;
                this.match = "\u0143";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1562: {
                switch (current) {
                    case 97: {
                        this.state = 1563;
                        return true;
                    }
                    case 101: {
                        this.state = 1567;
                        return true;
                    }
                    case 121: {
                        this.state = 1571;
                        return true;
                    }
                }
                break;
            }
            case 1563: {
                if (114 != current) break;
                this.state = 1564;
                return true;
            }
            case 1564: {
                if (111 != current) break;
                this.state = 1565;
                return true;
            }
            case 1565: {
                if (110 != current) break;
                this.state = 1566;
                return true;
            }
            case 1566: {
                if (59 != current) break;
                this.match = "\u0147";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1567: {
                if (100 != current) break;
                this.state = 1568;
                return true;
            }
            case 1568: {
                if (105 != current) break;
                this.state = 1569;
                return true;
            }
            case 1569: {
                if (108 != current) break;
                this.state = 1570;
                return true;
            }
            case 1570: {
                if (59 != current) break;
                this.match = "\u0145";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1571: {
                if (59 != current) break;
                this.match = "\u041d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1572: {
                switch (current) {
                    case 103: {
                        this.state = 1573;
                        return true;
                    }
                    case 115: {
                        this.state = 1619;
                        return true;
                    }
                    case 119: {
                        this.state = 1645;
                        return true;
                    }
                }
                break;
            }
            case 1573: {
                if (97 != current) break;
                this.state = 1574;
                return true;
            }
            case 1574: {
                if (116 != current) break;
                this.state = 1575;
                return true;
            }
            case 1575: {
                if (105 != current) break;
                this.state = 1576;
                return true;
            }
            case 1576: {
                if (118 != current) break;
                this.state = 1577;
                return true;
            }
            case 1577: {
                if (101 != current) break;
                this.state = 1578;
                return true;
            }
            case 1578: {
                switch (current) {
                    case 77: {
                        this.state = 1579;
                        return true;
                    }
                    case 84: {
                        this.state = 1590;
                        return true;
                    }
                    case 86: {
                        this.state = 1606;
                        return true;
                    }
                }
                break;
            }
            case 1579: {
                if (101 != current) break;
                this.state = 1580;
                return true;
            }
            case 1580: {
                if (100 != current) break;
                this.state = 1581;
                return true;
            }
            case 1581: {
                if (105 != current) break;
                this.state = 1582;
                return true;
            }
            case 1582: {
                if (117 != current) break;
                this.state = 1583;
                return true;
            }
            case 1583: {
                if (109 != current) break;
                this.state = 1584;
                return true;
            }
            case 1584: {
                if (83 != current) break;
                this.state = 1585;
                return true;
            }
            case 1585: {
                if (112 != current) break;
                this.state = 1586;
                return true;
            }
            case 1586: {
                if (97 != current) break;
                this.state = 1587;
                return true;
            }
            case 1587: {
                if (99 != current) break;
                this.state = 1588;
                return true;
            }
            case 1588: {
                if (101 != current) break;
                this.state = 1589;
                return true;
            }
            case 1589: {
                if (59 != current) break;
                this.match = "\u200b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1590: {
                if (104 != current) break;
                this.state = 1591;
                return true;
            }
            case 1591: {
                if (105 != current) break;
                this.state = 1592;
                return true;
            }
            case 1592: {
                if (99 == current) {
                    this.state = 1593;
                    return true;
                }
                if (110 != current) break;
                this.state = 1600;
                return true;
            }
            case 1593: {
                if (107 != current) break;
                this.state = 1594;
                return true;
            }
            case 1594: {
                if (83 != current) break;
                this.state = 1595;
                return true;
            }
            case 1595: {
                if (112 != current) break;
                this.state = 1596;
                return true;
            }
            case 1596: {
                if (97 != current) break;
                this.state = 1597;
                return true;
            }
            case 1597: {
                if (99 != current) break;
                this.state = 1598;
                return true;
            }
            case 1598: {
                if (101 != current) break;
                this.state = 1599;
                return true;
            }
            case 1599: {
                if (59 != current) break;
                this.match = "\u200b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1600: {
                if (83 != current) break;
                this.state = 1601;
                return true;
            }
            case 1601: {
                if (112 != current) break;
                this.state = 1602;
                return true;
            }
            case 1602: {
                if (97 != current) break;
                this.state = 1603;
                return true;
            }
            case 1603: {
                if (99 != current) break;
                this.state = 1604;
                return true;
            }
            case 1604: {
                if (101 != current) break;
                this.state = 1605;
                return true;
            }
            case 1605: {
                if (59 != current) break;
                this.match = "\u200b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1606: {
                if (101 != current) break;
                this.state = 1607;
                return true;
            }
            case 1607: {
                if (114 != current) break;
                this.state = 1608;
                return true;
            }
            case 1608: {
                if (121 != current) break;
                this.state = 1609;
                return true;
            }
            case 1609: {
                if (84 != current) break;
                this.state = 1610;
                return true;
            }
            case 1610: {
                if (104 != current) break;
                this.state = 1611;
                return true;
            }
            case 1611: {
                if (105 != current) break;
                this.state = 1612;
                return true;
            }
            case 1612: {
                if (110 != current) break;
                this.state = 1613;
                return true;
            }
            case 1613: {
                if (83 != current) break;
                this.state = 1614;
                return true;
            }
            case 1614: {
                if (112 != current) break;
                this.state = 1615;
                return true;
            }
            case 1615: {
                if (97 != current) break;
                this.state = 1616;
                return true;
            }
            case 1616: {
                if (99 != current) break;
                this.state = 1617;
                return true;
            }
            case 1617: {
                if (101 != current) break;
                this.state = 1618;
                return true;
            }
            case 1618: {
                if (59 != current) break;
                this.match = "\u200b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1619: {
                if (116 != current) break;
                this.state = 1620;
                return true;
            }
            case 1620: {
                if (101 != current) break;
                this.state = 1621;
                return true;
            }
            case 1621: {
                if (100 != current) break;
                this.state = 1622;
                return true;
            }
            case 1622: {
                if (71 == current) {
                    this.state = 1623;
                    return true;
                }
                if (76 != current) break;
                this.state = 1637;
                return true;
            }
            case 1623: {
                if (114 != current) break;
                this.state = 1624;
                return true;
            }
            case 1624: {
                if (101 != current) break;
                this.state = 1625;
                return true;
            }
            case 1625: {
                if (97 != current) break;
                this.state = 1626;
                return true;
            }
            case 1626: {
                if (116 != current) break;
                this.state = 1627;
                return true;
            }
            case 1627: {
                if (101 != current) break;
                this.state = 1628;
                return true;
            }
            case 1628: {
                if (114 != current) break;
                this.state = 1629;
                return true;
            }
            case 1629: {
                if (71 != current) break;
                this.state = 1630;
                return true;
            }
            case 1630: {
                if (114 != current) break;
                this.state = 1631;
                return true;
            }
            case 1631: {
                if (101 != current) break;
                this.state = 1632;
                return true;
            }
            case 1632: {
                if (97 != current) break;
                this.state = 1633;
                return true;
            }
            case 1633: {
                if (116 != current) break;
                this.state = 1634;
                return true;
            }
            case 1634: {
                if (101 != current) break;
                this.state = 1635;
                return true;
            }
            case 1635: {
                if (114 != current) break;
                this.state = 1636;
                return true;
            }
            case 1636: {
                if (59 != current) break;
                this.match = "\u226b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1637: {
                if (101 != current) break;
                this.state = 1638;
                return true;
            }
            case 1638: {
                if (115 != current) break;
                this.state = 1639;
                return true;
            }
            case 1639: {
                if (115 != current) break;
                this.state = 1640;
                return true;
            }
            case 1640: {
                if (76 != current) break;
                this.state = 1641;
                return true;
            }
            case 1641: {
                if (101 != current) break;
                this.state = 1642;
                return true;
            }
            case 1642: {
                if (115 != current) break;
                this.state = 1643;
                return true;
            }
            case 1643: {
                if (115 != current) break;
                this.state = 1644;
                return true;
            }
            case 1644: {
                if (59 != current) break;
                this.match = "\u226a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1645: {
                if (76 != current) break;
                this.state = 1646;
                return true;
            }
            case 1646: {
                if (105 != current) break;
                this.state = 1647;
                return true;
            }
            case 1647: {
                if (110 != current) break;
                this.state = 1648;
                return true;
            }
            case 1648: {
                if (101 != current) break;
                this.state = 1649;
                return true;
            }
            case 1649: {
                if (59 != current) break;
                this.match = "\n";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1650: {
                if (114 != current) break;
                this.state = 1651;
                return true;
            }
            case 1651: {
                if (59 != current) break;
                this.match = "\ud835\udd11";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1652: {
                switch (current) {
                    case 66: {
                        this.state = 1653;
                        return true;
                    }
                    case 110: {
                        this.state = 1658;
                        return true;
                    }
                    case 112: {
                        this.state = 1672;
                        return true;
                    }
                    case 116: {
                        this.state = 1674;
                        return true;
                    }
                }
                break;
            }
            case 1653: {
                if (114 != current) break;
                this.state = 1654;
                return true;
            }
            case 1654: {
                if (101 != current) break;
                this.state = 1655;
                return true;
            }
            case 1655: {
                if (97 != current) break;
                this.state = 1656;
                return true;
            }
            case 1656: {
                if (107 != current) break;
                this.state = 1657;
                return true;
            }
            case 1657: {
                if (59 != current) break;
                this.match = "\u2060";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1658: {
                if (66 != current) break;
                this.state = 1659;
                return true;
            }
            case 1659: {
                if (114 != current) break;
                this.state = 1660;
                return true;
            }
            case 1660: {
                if (101 != current) break;
                this.state = 1661;
                return true;
            }
            case 1661: {
                if (97 != current) break;
                this.state = 1662;
                return true;
            }
            case 1662: {
                if (107 != current) break;
                this.state = 1663;
                return true;
            }
            case 1663: {
                if (105 != current) break;
                this.state = 1664;
                return true;
            }
            case 1664: {
                if (110 != current) break;
                this.state = 1665;
                return true;
            }
            case 1665: {
                if (103 != current) break;
                this.state = 1666;
                return true;
            }
            case 1666: {
                if (83 != current) break;
                this.state = 1667;
                return true;
            }
            case 1667: {
                if (112 != current) break;
                this.state = 1668;
                return true;
            }
            case 1668: {
                if (97 != current) break;
                this.state = 1669;
                return true;
            }
            case 1669: {
                if (99 != current) break;
                this.state = 1670;
                return true;
            }
            case 1670: {
                if (101 != current) break;
                this.state = 1671;
                return true;
            }
            case 1671: {
                if (59 != current) break;
                this.match = "\u00a0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1672: {
                if (102 != current) break;
                this.state = 1673;
                return true;
            }
            case 1673: {
                if (59 != current) break;
                this.match = "\u2115";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1674: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aec";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 67: {
                        this.state = 1675;
                        return true;
                    }
                    case 68: {
                        this.state = 1689;
                        return true;
                    }
                    case 69: {
                        this.state = 1706;
                        return true;
                    }
                    case 71: {
                        this.state = 1727;
                        return true;
                    }
                    case 72: {
                        this.state = 1780;
                        return true;
                    }
                    case 76: {
                        this.state = 1801;
                        return true;
                    }
                    case 78: {
                        this.state = 1860;
                        return true;
                    }
                    case 80: {
                        this.state = 1888;
                        return true;
                    }
                    case 82: {
                        this.state = 1911;
                        return true;
                    }
                    case 83: {
                        this.state = 1945;
                        return true;
                    }
                    case 84: {
                        this.state = 2020;
                        return true;
                    }
                    case 86: {
                        this.state = 2044;
                        return true;
                    }
                }
                break;
            }
            case 1675: {
                if (111 == current) {
                    this.state = 1676;
                    return true;
                }
                if (117 != current) break;
                this.state = 1684;
                return true;
            }
            case 1676: {
                if (110 != current) break;
                this.state = 1677;
                return true;
            }
            case 1677: {
                if (103 != current) break;
                this.state = 1678;
                return true;
            }
            case 1678: {
                if (114 != current) break;
                this.state = 1679;
                return true;
            }
            case 1679: {
                if (117 != current) break;
                this.state = 1680;
                return true;
            }
            case 1680: {
                if (101 != current) break;
                this.state = 1681;
                return true;
            }
            case 1681: {
                if (110 != current) break;
                this.state = 1682;
                return true;
            }
            case 1682: {
                if (116 != current) break;
                this.state = 1683;
                return true;
            }
            case 1683: {
                if (59 != current) break;
                this.match = "\u2262";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1684: {
                if (112 != current) break;
                this.state = 1685;
                return true;
            }
            case 1685: {
                if (67 != current) break;
                this.state = 1686;
                return true;
            }
            case 1686: {
                if (97 != current) break;
                this.state = 1687;
                return true;
            }
            case 1687: {
                if (112 != current) break;
                this.state = 1688;
                return true;
            }
            case 1688: {
                if (59 != current) break;
                this.match = "\u226d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1689: {
                if (111 != current) break;
                this.state = 1690;
                return true;
            }
            case 1690: {
                if (117 != current) break;
                this.state = 1691;
                return true;
            }
            case 1691: {
                if (98 != current) break;
                this.state = 1692;
                return true;
            }
            case 1692: {
                if (108 != current) break;
                this.state = 1693;
                return true;
            }
            case 1693: {
                if (101 != current) break;
                this.state = 1694;
                return true;
            }
            case 1694: {
                if (86 != current) break;
                this.state = 1695;
                return true;
            }
            case 1695: {
                if (101 != current) break;
                this.state = 1696;
                return true;
            }
            case 1696: {
                if (114 != current) break;
                this.state = 1697;
                return true;
            }
            case 1697: {
                if (116 != current) break;
                this.state = 1698;
                return true;
            }
            case 1698: {
                if (105 != current) break;
                this.state = 1699;
                return true;
            }
            case 1699: {
                if (99 != current) break;
                this.state = 1700;
                return true;
            }
            case 1700: {
                if (97 != current) break;
                this.state = 1701;
                return true;
            }
            case 1701: {
                if (108 != current) break;
                this.state = 1702;
                return true;
            }
            case 1702: {
                if (66 != current) break;
                this.state = 1703;
                return true;
            }
            case 1703: {
                if (97 != current) break;
                this.state = 1704;
                return true;
            }
            case 1704: {
                if (114 != current) break;
                this.state = 1705;
                return true;
            }
            case 1705: {
                if (59 != current) break;
                this.match = "\u2226";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1706: {
                switch (current) {
                    case 108: {
                        this.state = 1707;
                        return true;
                    }
                    case 113: {
                        this.state = 1713;
                        return true;
                    }
                    case 120: {
                        this.state = 1722;
                        return true;
                    }
                }
                break;
            }
            case 1707: {
                if (101 != current) break;
                this.state = 1708;
                return true;
            }
            case 1708: {
                if (109 != current) break;
                this.state = 1709;
                return true;
            }
            case 1709: {
                if (101 != current) break;
                this.state = 1710;
                return true;
            }
            case 1710: {
                if (110 != current) break;
                this.state = 1711;
                return true;
            }
            case 1711: {
                if (116 != current) break;
                this.state = 1712;
                return true;
            }
            case 1712: {
                if (59 != current) break;
                this.match = "\u2209";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1713: {
                if (117 != current) break;
                this.state = 1714;
                return true;
            }
            case 1714: {
                if (97 != current) break;
                this.state = 1715;
                return true;
            }
            case 1715: {
                if (108 != current) break;
                this.state = 1716;
                return true;
            }
            case 1716: {
                if (59 == current) {
                    this.match = "\u2260";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (84 != current) break;
                this.state = 1717;
                return true;
            }
            case 1717: {
                if (105 != current) break;
                this.state = 1718;
                return true;
            }
            case 1718: {
                if (108 != current) break;
                this.state = 1719;
                return true;
            }
            case 1719: {
                if (100 != current) break;
                this.state = 1720;
                return true;
            }
            case 1720: {
                if (101 != current) break;
                this.state = 1721;
                return true;
            }
            case 1721: {
                if (59 != current) break;
                this.match = "\u2242\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1722: {
                if (105 != current) break;
                this.state = 1723;
                return true;
            }
            case 1723: {
                if (115 != current) break;
                this.state = 1724;
                return true;
            }
            case 1724: {
                if (116 != current) break;
                this.state = 1725;
                return true;
            }
            case 1725: {
                if (115 != current) break;
                this.state = 1726;
                return true;
            }
            case 1726: {
                if (59 != current) break;
                this.match = "\u2204";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1727: {
                if (114 != current) break;
                this.state = 1728;
                return true;
            }
            case 1728: {
                if (101 != current) break;
                this.state = 1729;
                return true;
            }
            case 1729: {
                if (97 != current) break;
                this.state = 1730;
                return true;
            }
            case 1730: {
                if (116 != current) break;
                this.state = 1731;
                return true;
            }
            case 1731: {
                if (101 != current) break;
                this.state = 1732;
                return true;
            }
            case 1732: {
                if (114 != current) break;
                this.state = 1733;
                return true;
            }
            case 1733: {
                switch (current) {
                    case 59: {
                        this.match = "\u226f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1734;
                        return true;
                    }
                    case 70: {
                        this.state = 1739;
                        return true;
                    }
                    case 71: {
                        this.state = 1750;
                        return true;
                    }
                    case 76: {
                        this.state = 1759;
                        return true;
                    }
                    case 83: {
                        this.state = 1763;
                        return true;
                    }
                    case 84: {
                        this.state = 1775;
                        return true;
                    }
                }
                break;
            }
            case 1734: {
                if (113 != current) break;
                this.state = 1735;
                return true;
            }
            case 1735: {
                if (117 != current) break;
                this.state = 1736;
                return true;
            }
            case 1736: {
                if (97 != current) break;
                this.state = 1737;
                return true;
            }
            case 1737: {
                if (108 != current) break;
                this.state = 1738;
                return true;
            }
            case 1738: {
                if (59 != current) break;
                this.match = "\u2271";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1739: {
                if (117 != current) break;
                this.state = 1740;
                return true;
            }
            case 1740: {
                if (108 != current) break;
                this.state = 1741;
                return true;
            }
            case 1741: {
                if (108 != current) break;
                this.state = 1742;
                return true;
            }
            case 1742: {
                if (69 != current) break;
                this.state = 1743;
                return true;
            }
            case 1743: {
                if (113 != current) break;
                this.state = 1744;
                return true;
            }
            case 1744: {
                if (117 != current) break;
                this.state = 1745;
                return true;
            }
            case 1745: {
                if (97 != current) break;
                this.state = 1746;
                return true;
            }
            case 1746: {
                if (108 != current) break;
                this.state = 1747;
                return true;
            }
            case 1747: {
                if (59 != current) break;
                this.state = 1748;
                return true;
            }
            case 1748: {
                if (8807 != current) break;
                this.state = 1749;
                return true;
            }
            case 1749: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1750: {
                if (114 != current) break;
                this.state = 1751;
                return true;
            }
            case 1751: {
                if (101 != current) break;
                this.state = 1752;
                return true;
            }
            case 1752: {
                if (97 != current) break;
                this.state = 1753;
                return true;
            }
            case 1753: {
                if (116 != current) break;
                this.state = 1754;
                return true;
            }
            case 1754: {
                if (101 != current) break;
                this.state = 1755;
                return true;
            }
            case 1755: {
                if (114 != current) break;
                this.state = 1756;
                return true;
            }
            case 1756: {
                if (59 != current) break;
                this.state = 1757;
                return true;
            }
            case 1757: {
                if (8811 != current) break;
                this.state = 1758;
                return true;
            }
            case 1758: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1759: {
                if (101 != current) break;
                this.state = 1760;
                return true;
            }
            case 1760: {
                if (115 != current) break;
                this.state = 1761;
                return true;
            }
            case 1761: {
                if (115 != current) break;
                this.state = 1762;
                return true;
            }
            case 1762: {
                if (59 != current) break;
                this.match = "\u2279";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1763: {
                if (108 != current) break;
                this.state = 1764;
                return true;
            }
            case 1764: {
                if (97 != current) break;
                this.state = 1765;
                return true;
            }
            case 1765: {
                if (110 != current) break;
                this.state = 1766;
                return true;
            }
            case 1766: {
                if (116 != current) break;
                this.state = 1767;
                return true;
            }
            case 1767: {
                if (69 != current) break;
                this.state = 1768;
                return true;
            }
            case 1768: {
                if (113 != current) break;
                this.state = 1769;
                return true;
            }
            case 1769: {
                if (117 != current) break;
                this.state = 1770;
                return true;
            }
            case 1770: {
                if (97 != current) break;
                this.state = 1771;
                return true;
            }
            case 1771: {
                if (108 != current) break;
                this.state = 1772;
                return true;
            }
            case 1772: {
                if (59 != current) break;
                this.state = 1773;
                return true;
            }
            case 1773: {
                if (10878 != current) break;
                this.state = 1774;
                return true;
            }
            case 1774: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1775: {
                if (105 != current) break;
                this.state = 1776;
                return true;
            }
            case 1776: {
                if (108 != current) break;
                this.state = 1777;
                return true;
            }
            case 1777: {
                if (100 != current) break;
                this.state = 1778;
                return true;
            }
            case 1778: {
                if (101 != current) break;
                this.state = 1779;
                return true;
            }
            case 1779: {
                if (59 != current) break;
                this.match = "\u2275";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1780: {
                if (117 != current) break;
                this.state = 1781;
                return true;
            }
            case 1781: {
                if (109 != current) break;
                this.state = 1782;
                return true;
            }
            case 1782: {
                if (112 != current) break;
                this.state = 1783;
                return true;
            }
            case 1783: {
                if (68 == current) {
                    this.state = 1784;
                    return true;
                }
                if (69 != current) break;
                this.state = 1794;
                return true;
            }
            case 1784: {
                if (111 != current) break;
                this.state = 1785;
                return true;
            }
            case 1785: {
                if (119 != current) break;
                this.state = 1786;
                return true;
            }
            case 1786: {
                if (110 != current) break;
                this.state = 1787;
                return true;
            }
            case 1787: {
                if (72 != current) break;
                this.state = 1788;
                return true;
            }
            case 1788: {
                if (117 != current) break;
                this.state = 1789;
                return true;
            }
            case 1789: {
                if (109 != current) break;
                this.state = 1790;
                return true;
            }
            case 1790: {
                if (112 != current) break;
                this.state = 1791;
                return true;
            }
            case 1791: {
                if (59 != current) break;
                this.state = 1792;
                return true;
            }
            case 1792: {
                if (8782 != current) break;
                this.state = 1793;
                return true;
            }
            case 1793: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1794: {
                if (113 != current) break;
                this.state = 1795;
                return true;
            }
            case 1795: {
                if (117 != current) break;
                this.state = 1796;
                return true;
            }
            case 1796: {
                if (97 != current) break;
                this.state = 1797;
                return true;
            }
            case 1797: {
                if (108 != current) break;
                this.state = 1798;
                return true;
            }
            case 1798: {
                if (59 != current) break;
                this.state = 1799;
                return true;
            }
            case 1799: {
                if (8783 != current) break;
                this.state = 1800;
                return true;
            }
            case 1800: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1801: {
                if (101 != current) break;
                this.state = 1802;
                return true;
            }
            case 1802: {
                if (102 == current) {
                    this.state = 1803;
                    return true;
                }
                if (115 != current) break;
                this.state = 1823;
                return true;
            }
            case 1803: {
                if (116 != current) break;
                this.state = 1804;
                return true;
            }
            case 1804: {
                if (84 != current) break;
                this.state = 1805;
                return true;
            }
            case 1805: {
                if (114 != current) break;
                this.state = 1806;
                return true;
            }
            case 1806: {
                if (105 != current) break;
                this.state = 1807;
                return true;
            }
            case 1807: {
                if (97 != current) break;
                this.state = 1808;
                return true;
            }
            case 1808: {
                if (110 != current) break;
                this.state = 1809;
                return true;
            }
            case 1809: {
                if (103 != current) break;
                this.state = 1810;
                return true;
            }
            case 1810: {
                if (108 != current) break;
                this.state = 1811;
                return true;
            }
            case 1811: {
                if (101 != current) break;
                this.state = 1812;
                return true;
            }
            case 1812: {
                switch (current) {
                    case 59: {
                        this.match = "\u22ea";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1813;
                        return true;
                    }
                    case 69: {
                        this.state = 1818;
                        return true;
                    }
                }
                break;
            }
            case 1813: {
                if (97 != current) break;
                this.state = 1814;
                return true;
            }
            case 1814: {
                if (114 != current) break;
                this.state = 1815;
                return true;
            }
            case 1815: {
                if (59 != current) break;
                this.state = 1816;
                return true;
            }
            case 1816: {
                if (10703 != current) break;
                this.state = 1817;
                return true;
            }
            case 1817: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1818: {
                if (113 != current) break;
                this.state = 1819;
                return true;
            }
            case 1819: {
                if (117 != current) break;
                this.state = 1820;
                return true;
            }
            case 1820: {
                if (97 != current) break;
                this.state = 1821;
                return true;
            }
            case 1821: {
                if (108 != current) break;
                this.state = 1822;
                return true;
            }
            case 1822: {
                if (59 != current) break;
                this.match = "\u22ec";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1823: {
                if (115 != current) break;
                this.state = 1824;
                return true;
            }
            case 1824: {
                switch (current) {
                    case 59: {
                        this.match = "\u226e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1825;
                        return true;
                    }
                    case 71: {
                        this.state = 1830;
                        return true;
                    }
                    case 76: {
                        this.state = 1837;
                        return true;
                    }
                    case 83: {
                        this.state = 1843;
                        return true;
                    }
                    case 84: {
                        this.state = 1855;
                        return true;
                    }
                }
                break;
            }
            case 1825: {
                if (113 != current) break;
                this.state = 1826;
                return true;
            }
            case 1826: {
                if (117 != current) break;
                this.state = 1827;
                return true;
            }
            case 1827: {
                if (97 != current) break;
                this.state = 1828;
                return true;
            }
            case 1828: {
                if (108 != current) break;
                this.state = 1829;
                return true;
            }
            case 1829: {
                if (59 != current) break;
                this.match = "\u2270";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1830: {
                if (114 != current) break;
                this.state = 1831;
                return true;
            }
            case 1831: {
                if (101 != current) break;
                this.state = 1832;
                return true;
            }
            case 1832: {
                if (97 != current) break;
                this.state = 1833;
                return true;
            }
            case 1833: {
                if (116 != current) break;
                this.state = 1834;
                return true;
            }
            case 1834: {
                if (101 != current) break;
                this.state = 1835;
                return true;
            }
            case 1835: {
                if (114 != current) break;
                this.state = 1836;
                return true;
            }
            case 1836: {
                if (59 != current) break;
                this.match = "\u2278";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1837: {
                if (101 != current) break;
                this.state = 1838;
                return true;
            }
            case 1838: {
                if (115 != current) break;
                this.state = 1839;
                return true;
            }
            case 1839: {
                if (115 != current) break;
                this.state = 1840;
                return true;
            }
            case 1840: {
                if (59 != current) break;
                this.state = 1841;
                return true;
            }
            case 1841: {
                if (8810 != current) break;
                this.state = 1842;
                return true;
            }
            case 1842: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1843: {
                if (108 != current) break;
                this.state = 1844;
                return true;
            }
            case 1844: {
                if (97 != current) break;
                this.state = 1845;
                return true;
            }
            case 1845: {
                if (110 != current) break;
                this.state = 1846;
                return true;
            }
            case 1846: {
                if (116 != current) break;
                this.state = 1847;
                return true;
            }
            case 1847: {
                if (69 != current) break;
                this.state = 1848;
                return true;
            }
            case 1848: {
                if (113 != current) break;
                this.state = 1849;
                return true;
            }
            case 1849: {
                if (117 != current) break;
                this.state = 1850;
                return true;
            }
            case 1850: {
                if (97 != current) break;
                this.state = 1851;
                return true;
            }
            case 1851: {
                if (108 != current) break;
                this.state = 1852;
                return true;
            }
            case 1852: {
                if (59 != current) break;
                this.state = 1853;
                return true;
            }
            case 1853: {
                if (10877 != current) break;
                this.state = 1854;
                return true;
            }
            case 1854: {
                if (824 != current) break;
                this.match = "";
                this.matchLength = this.consumedCount;
                return false;
            }
            case 1855: {
                if (105 != current) break;
                this.state = 1856;
                return true;
            }
            case 1856: {
                if (108 != current) break;
                this.state = 1857;
                return true;
            }
            case 1857: {
                if (100 != current) break;
                this.state = 1858;
                return true;
            }
            case 1858: {
                if (101 != current) break;
                this.state = 1859;
                return true;
            }
            case 1859: {
                if (59 != current) break;
                this.match = "\u2274";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1860: {
                if (101 != current) break;
                this.state = 1861;
                return true;
            }
            case 1861: {
                if (115 != current) break;
                this.state = 1862;
                return true;
            }
            case 1862: {
                if (116 != current) break;
                this.state = 1863;
                return true;
            }
            case 1863: {
                if (101 != current) break;
                this.state = 1864;
                return true;
            }
            case 1864: {
                if (100 != current) break;
                this.state = 1865;
                return true;
            }
            case 1865: {
                if (71 == current) {
                    this.state = 1866;
                    return true;
                }
                if (76 != current) break;
                this.state = 1880;
                return true;
            }
            case 1866: {
                if (114 != current) break;
                this.state = 1867;
                return true;
            }
            case 1867: {
                if (101 != current) break;
                this.state = 1868;
                return true;
            }
            case 1868: {
                if (97 != current) break;
                this.state = 1869;
                return true;
            }
            case 1869: {
                if (116 != current) break;
                this.state = 1870;
                return true;
            }
            case 1870: {
                if (101 != current) break;
                this.state = 1871;
                return true;
            }
            case 1871: {
                if (114 != current) break;
                this.state = 1872;
                return true;
            }
            case 1872: {
                if (71 != current) break;
                this.state = 1873;
                return true;
            }
            case 1873: {
                if (114 != current) break;
                this.state = 1874;
                return true;
            }
            case 1874: {
                if (101 != current) break;
                this.state = 1875;
                return true;
            }
            case 1875: {
                if (97 != current) break;
                this.state = 1876;
                return true;
            }
            case 1876: {
                if (116 != current) break;
                this.state = 1877;
                return true;
            }
            case 1877: {
                if (101 != current) break;
                this.state = 1878;
                return true;
            }
            case 1878: {
                if (114 != current) break;
                this.state = 1879;
                return true;
            }
            case 1879: {
                if (59 != current) break;
                this.match = "\u2aa2\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1880: {
                if (101 != current) break;
                this.state = 1881;
                return true;
            }
            case 1881: {
                if (115 != current) break;
                this.state = 1882;
                return true;
            }
            case 1882: {
                if (115 != current) break;
                this.state = 1883;
                return true;
            }
            case 1883: {
                if (76 != current) break;
                this.state = 1884;
                return true;
            }
            case 1884: {
                if (101 != current) break;
                this.state = 1885;
                return true;
            }
            case 1885: {
                if (115 != current) break;
                this.state = 1886;
                return true;
            }
            case 1886: {
                if (115 != current) break;
                this.state = 1887;
                return true;
            }
            case 1887: {
                if (59 != current) break;
                this.match = "\u2aa1\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1888: {
                if (114 != current) break;
                this.state = 1889;
                return true;
            }
            case 1889: {
                if (101 != current) break;
                this.state = 1890;
                return true;
            }
            case 1890: {
                if (99 != current) break;
                this.state = 1891;
                return true;
            }
            case 1891: {
                if (101 != current) break;
                this.state = 1892;
                return true;
            }
            case 1892: {
                if (100 != current) break;
                this.state = 1893;
                return true;
            }
            case 1893: {
                if (101 != current) break;
                this.state = 1894;
                return true;
            }
            case 1894: {
                if (115 != current) break;
                this.state = 1895;
                return true;
            }
            case 1895: {
                switch (current) {
                    case 59: {
                        this.match = "\u2280";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1896;
                        return true;
                    }
                    case 83: {
                        this.state = 1901;
                        return true;
                    }
                }
                break;
            }
            case 1896: {
                if (113 != current) break;
                this.state = 1897;
                return true;
            }
            case 1897: {
                if (117 != current) break;
                this.state = 1898;
                return true;
            }
            case 1898: {
                if (97 != current) break;
                this.state = 1899;
                return true;
            }
            case 1899: {
                if (108 != current) break;
                this.state = 1900;
                return true;
            }
            case 1900: {
                if (59 != current) break;
                this.match = "\u2aaf\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1901: {
                if (108 != current) break;
                this.state = 1902;
                return true;
            }
            case 1902: {
                if (97 != current) break;
                this.state = 1903;
                return true;
            }
            case 1903: {
                if (110 != current) break;
                this.state = 1904;
                return true;
            }
            case 1904: {
                if (116 != current) break;
                this.state = 1905;
                return true;
            }
            case 1905: {
                if (69 != current) break;
                this.state = 1906;
                return true;
            }
            case 1906: {
                if (113 != current) break;
                this.state = 1907;
                return true;
            }
            case 1907: {
                if (117 != current) break;
                this.state = 1908;
                return true;
            }
            case 1908: {
                if (97 != current) break;
                this.state = 1909;
                return true;
            }
            case 1909: {
                if (108 != current) break;
                this.state = 1910;
                return true;
            }
            case 1910: {
                if (59 != current) break;
                this.match = "\u22e0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1911: {
                if (101 == current) {
                    this.state = 1912;
                    return true;
                }
                if (105 != current) break;
                this.state = 1925;
                return true;
            }
            case 1912: {
                if (118 != current) break;
                this.state = 1913;
                return true;
            }
            case 1913: {
                if (101 != current) break;
                this.state = 1914;
                return true;
            }
            case 1914: {
                if (114 != current) break;
                this.state = 1915;
                return true;
            }
            case 1915: {
                if (115 != current) break;
                this.state = 1916;
                return true;
            }
            case 1916: {
                if (101 != current) break;
                this.state = 1917;
                return true;
            }
            case 1917: {
                if (69 != current) break;
                this.state = 1918;
                return true;
            }
            case 1918: {
                if (108 != current) break;
                this.state = 1919;
                return true;
            }
            case 1919: {
                if (101 != current) break;
                this.state = 1920;
                return true;
            }
            case 1920: {
                if (109 != current) break;
                this.state = 1921;
                return true;
            }
            case 1921: {
                if (101 != current) break;
                this.state = 1922;
                return true;
            }
            case 1922: {
                if (110 != current) break;
                this.state = 1923;
                return true;
            }
            case 1923: {
                if (116 != current) break;
                this.state = 1924;
                return true;
            }
            case 1924: {
                if (59 != current) break;
                this.match = "\u220c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1925: {
                if (103 != current) break;
                this.state = 1926;
                return true;
            }
            case 1926: {
                if (104 != current) break;
                this.state = 1927;
                return true;
            }
            case 1927: {
                if (116 != current) break;
                this.state = 1928;
                return true;
            }
            case 1928: {
                if (84 != current) break;
                this.state = 1929;
                return true;
            }
            case 1929: {
                if (114 != current) break;
                this.state = 1930;
                return true;
            }
            case 1930: {
                if (105 != current) break;
                this.state = 1931;
                return true;
            }
            case 1931: {
                if (97 != current) break;
                this.state = 1932;
                return true;
            }
            case 1932: {
                if (110 != current) break;
                this.state = 1933;
                return true;
            }
            case 1933: {
                if (103 != current) break;
                this.state = 1934;
                return true;
            }
            case 1934: {
                if (108 != current) break;
                this.state = 1935;
                return true;
            }
            case 1935: {
                if (101 != current) break;
                this.state = 1936;
                return true;
            }
            case 1936: {
                switch (current) {
                    case 59: {
                        this.match = "\u22eb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1937;
                        return true;
                    }
                    case 69: {
                        this.state = 1940;
                        return true;
                    }
                }
                break;
            }
            case 1937: {
                if (97 != current) break;
                this.state = 1938;
                return true;
            }
            case 1938: {
                if (114 != current) break;
                this.state = 1939;
                return true;
            }
            case 1939: {
                if (59 != current) break;
                this.match = "\u29d0\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1940: {
                if (113 != current) break;
                this.state = 1941;
                return true;
            }
            case 1941: {
                if (117 != current) break;
                this.state = 1942;
                return true;
            }
            case 1942: {
                if (97 != current) break;
                this.state = 1943;
                return true;
            }
            case 1943: {
                if (108 != current) break;
                this.state = 1944;
                return true;
            }
            case 1944: {
                if (59 != current) break;
                this.match = "\u22ed";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1945: {
                if (113 == current) {
                    this.state = 1946;
                    return true;
                }
                if (117 != current) break;
                this.state = 1973;
                return true;
            }
            case 1946: {
                if (117 != current) break;
                this.state = 1947;
                return true;
            }
            case 1947: {
                if (97 != current) break;
                this.state = 1948;
                return true;
            }
            case 1948: {
                if (114 != current) break;
                this.state = 1949;
                return true;
            }
            case 1949: {
                if (101 != current) break;
                this.state = 1950;
                return true;
            }
            case 1950: {
                if (83 != current) break;
                this.state = 1951;
                return true;
            }
            case 1951: {
                if (117 != current) break;
                this.state = 1952;
                return true;
            }
            case 1952: {
                if (98 == current) {
                    this.state = 1953;
                    return true;
                }
                if (112 != current) break;
                this.state = 1962;
                return true;
            }
            case 1953: {
                if (115 != current) break;
                this.state = 1954;
                return true;
            }
            case 1954: {
                if (101 != current) break;
                this.state = 1955;
                return true;
            }
            case 1955: {
                if (116 != current) break;
                this.state = 1956;
                return true;
            }
            case 1956: {
                if (59 == current) {
                    this.match = "\u228f\u0338";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 1957;
                return true;
            }
            case 1957: {
                if (113 != current) break;
                this.state = 1958;
                return true;
            }
            case 1958: {
                if (117 != current) break;
                this.state = 1959;
                return true;
            }
            case 1959: {
                if (97 != current) break;
                this.state = 1960;
                return true;
            }
            case 1960: {
                if (108 != current) break;
                this.state = 1961;
                return true;
            }
            case 1961: {
                if (59 != current) break;
                this.match = "\u22e2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1962: {
                if (101 != current) break;
                this.state = 1963;
                return true;
            }
            case 1963: {
                if (114 != current) break;
                this.state = 1964;
                return true;
            }
            case 1964: {
                if (115 != current) break;
                this.state = 1965;
                return true;
            }
            case 1965: {
                if (101 != current) break;
                this.state = 1966;
                return true;
            }
            case 1966: {
                if (116 != current) break;
                this.state = 1967;
                return true;
            }
            case 1967: {
                if (59 == current) {
                    this.match = "\u2290\u0338";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 1968;
                return true;
            }
            case 1968: {
                if (113 != current) break;
                this.state = 1969;
                return true;
            }
            case 1969: {
                if (117 != current) break;
                this.state = 1970;
                return true;
            }
            case 1970: {
                if (97 != current) break;
                this.state = 1971;
                return true;
            }
            case 1971: {
                if (108 != current) break;
                this.state = 1972;
                return true;
            }
            case 1972: {
                if (59 != current) break;
                this.match = "\u22e3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1973: {
                switch (current) {
                    case 98: {
                        this.state = 1974;
                        return true;
                    }
                    case 99: {
                        this.state = 1983;
                        return true;
                    }
                    case 112: {
                        this.state = 2009;
                        return true;
                    }
                }
                break;
            }
            case 1974: {
                if (115 != current) break;
                this.state = 1975;
                return true;
            }
            case 1975: {
                if (101 != current) break;
                this.state = 1976;
                return true;
            }
            case 1976: {
                if (116 != current) break;
                this.state = 1977;
                return true;
            }
            case 1977: {
                if (59 == current) {
                    this.match = "\u2282\u20d2";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 1978;
                return true;
            }
            case 1978: {
                if (113 != current) break;
                this.state = 1979;
                return true;
            }
            case 1979: {
                if (117 != current) break;
                this.state = 1980;
                return true;
            }
            case 1980: {
                if (97 != current) break;
                this.state = 1981;
                return true;
            }
            case 1981: {
                if (108 != current) break;
                this.state = 1982;
                return true;
            }
            case 1982: {
                if (59 != current) break;
                this.match = "\u2288";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1983: {
                if (99 != current) break;
                this.state = 1984;
                return true;
            }
            case 1984: {
                if (101 != current) break;
                this.state = 1985;
                return true;
            }
            case 1985: {
                if (101 != current) break;
                this.state = 1986;
                return true;
            }
            case 1986: {
                if (100 != current) break;
                this.state = 1987;
                return true;
            }
            case 1987: {
                if (115 != current) break;
                this.state = 1988;
                return true;
            }
            case 1988: {
                switch (current) {
                    case 59: {
                        this.match = "\u2281";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1989;
                        return true;
                    }
                    case 83: {
                        this.state = 1994;
                        return true;
                    }
                    case 84: {
                        this.state = 2004;
                        return true;
                    }
                }
                break;
            }
            case 1989: {
                if (113 != current) break;
                this.state = 1990;
                return true;
            }
            case 1990: {
                if (117 != current) break;
                this.state = 1991;
                return true;
            }
            case 1991: {
                if (97 != current) break;
                this.state = 1992;
                return true;
            }
            case 1992: {
                if (108 != current) break;
                this.state = 1993;
                return true;
            }
            case 1993: {
                if (59 != current) break;
                this.match = "\u2ab0\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 1994: {
                if (108 != current) break;
                this.state = 1995;
                return true;
            }
            case 1995: {
                if (97 != current) break;
                this.state = 1996;
                return true;
            }
            case 1996: {
                if (110 != current) break;
                this.state = 1997;
                return true;
            }
            case 1997: {
                if (116 != current) break;
                this.state = 1998;
                return true;
            }
            case 1998: {
                if (69 != current) break;
                this.state = 1999;
                return true;
            }
            case 1999: {
                if (113 != current) break;
                this.state = 2000;
                return true;
            }
        }
        return false;
    }

    private boolean parse3(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 2000: {
                if (117 != current) break;
                this.state = 2001;
                return true;
            }
            case 2001: {
                if (97 != current) break;
                this.state = 2002;
                return true;
            }
            case 2002: {
                if (108 != current) break;
                this.state = 2003;
                return true;
            }
            case 2003: {
                if (59 != current) break;
                this.match = "\u22e1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2004: {
                if (105 != current) break;
                this.state = 2005;
                return true;
            }
            case 2005: {
                if (108 != current) break;
                this.state = 2006;
                return true;
            }
            case 2006: {
                if (100 != current) break;
                this.state = 2007;
                return true;
            }
            case 2007: {
                if (101 != current) break;
                this.state = 2008;
                return true;
            }
            case 2008: {
                if (59 != current) break;
                this.match = "\u227f\u0338";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2009: {
                if (101 != current) break;
                this.state = 2010;
                return true;
            }
            case 2010: {
                if (114 != current) break;
                this.state = 2011;
                return true;
            }
            case 2011: {
                if (115 != current) break;
                this.state = 2012;
                return true;
            }
            case 2012: {
                if (101 != current) break;
                this.state = 2013;
                return true;
            }
            case 2013: {
                if (116 != current) break;
                this.state = 2014;
                return true;
            }
            case 2014: {
                if (59 == current) {
                    this.match = "\u2283\u20d2";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 2015;
                return true;
            }
            case 2015: {
                if (113 != current) break;
                this.state = 2016;
                return true;
            }
            case 2016: {
                if (117 != current) break;
                this.state = 2017;
                return true;
            }
            case 2017: {
                if (97 != current) break;
                this.state = 2018;
                return true;
            }
            case 2018: {
                if (108 != current) break;
                this.state = 2019;
                return true;
            }
            case 2019: {
                if (59 != current) break;
                this.match = "\u2289";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2020: {
                if (105 != current) break;
                this.state = 2021;
                return true;
            }
            case 2021: {
                if (108 != current) break;
                this.state = 2022;
                return true;
            }
            case 2022: {
                if (100 != current) break;
                this.state = 2023;
                return true;
            }
            case 2023: {
                if (101 != current) break;
                this.state = 2024;
                return true;
            }
            case 2024: {
                switch (current) {
                    case 59: {
                        this.match = "\u2241";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2025;
                        return true;
                    }
                    case 70: {
                        this.state = 2030;
                        return true;
                    }
                    case 84: {
                        this.state = 2039;
                        return true;
                    }
                }
                break;
            }
            case 2025: {
                if (113 != current) break;
                this.state = 2026;
                return true;
            }
            case 2026: {
                if (117 != current) break;
                this.state = 2027;
                return true;
            }
            case 2027: {
                if (97 != current) break;
                this.state = 2028;
                return true;
            }
            case 2028: {
                if (108 != current) break;
                this.state = 2029;
                return true;
            }
            case 2029: {
                if (59 != current) break;
                this.match = "\u2244";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2030: {
                if (117 != current) break;
                this.state = 2031;
                return true;
            }
            case 2031: {
                if (108 != current) break;
                this.state = 2032;
                return true;
            }
            case 2032: {
                if (108 != current) break;
                this.state = 2033;
                return true;
            }
            case 2033: {
                if (69 != current) break;
                this.state = 2034;
                return true;
            }
            case 2034: {
                if (113 != current) break;
                this.state = 2035;
                return true;
            }
            case 2035: {
                if (117 != current) break;
                this.state = 2036;
                return true;
            }
            case 2036: {
                if (97 != current) break;
                this.state = 2037;
                return true;
            }
            case 2037: {
                if (108 != current) break;
                this.state = 2038;
                return true;
            }
            case 2038: {
                if (59 != current) break;
                this.match = "\u2247";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2039: {
                if (105 != current) break;
                this.state = 2040;
                return true;
            }
            case 2040: {
                if (108 != current) break;
                this.state = 2041;
                return true;
            }
            case 2041: {
                if (100 != current) break;
                this.state = 2042;
                return true;
            }
            case 2042: {
                if (101 != current) break;
                this.state = 2043;
                return true;
            }
            case 2043: {
                if (59 != current) break;
                this.match = "\u2249";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2044: {
                if (101 != current) break;
                this.state = 2045;
                return true;
            }
            case 2045: {
                if (114 != current) break;
                this.state = 2046;
                return true;
            }
            case 2046: {
                if (116 != current) break;
                this.state = 2047;
                return true;
            }
            case 2047: {
                if (105 != current) break;
                this.state = 2048;
                return true;
            }
            case 2048: {
                if (99 != current) break;
                this.state = 2049;
                return true;
            }
            case 2049: {
                if (97 != current) break;
                this.state = 2050;
                return true;
            }
            case 2050: {
                if (108 != current) break;
                this.state = 2051;
                return true;
            }
            case 2051: {
                if (66 != current) break;
                this.state = 2052;
                return true;
            }
            case 2052: {
                if (97 != current) break;
                this.state = 2053;
                return true;
            }
            case 2053: {
                if (114 != current) break;
                this.state = 2054;
                return true;
            }
            case 2054: {
                if (59 != current) break;
                this.match = "\u2224";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2055: {
                if (99 != current) break;
                this.state = 2056;
                return true;
            }
            case 2056: {
                if (114 != current) break;
                this.state = 2057;
                return true;
            }
            case 2057: {
                if (59 != current) break;
                this.match = "\ud835\udca9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2058: {
                if (105 != current) break;
                this.state = 2059;
                return true;
            }
            case 2059: {
                if (108 != current) break;
                this.state = 2060;
                return true;
            }
            case 2060: {
                if (100 != current) break;
                this.state = 2061;
                return true;
            }
            case 2061: {
                if (101 != current) break;
                this.match = "\u00d1";
                this.matchLength = this.consumedCount;
                this.state = 2062;
                return true;
            }
            case 2062: {
                if (59 != current) break;
                this.match = "\u00d1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2063: {
                if (59 != current) break;
                this.match = "\u039d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2064: {
                switch (current) {
                    case 69: {
                        this.state = 2065;
                        return true;
                    }
                    case 97: {
                        this.state = 2069;
                        return true;
                    }
                    case 99: {
                        this.state = 2074;
                        return true;
                    }
                    case 100: {
                        this.state = 2079;
                        return true;
                    }
                    case 102: {
                        this.state = 2084;
                        return true;
                    }
                    case 103: {
                        this.state = 2086;
                        return true;
                    }
                    case 109: {
                        this.state = 2091;
                        return true;
                    }
                    case 111: {
                        this.state = 2103;
                        return true;
                    }
                    case 112: {
                        this.state = 2106;
                        return true;
                    }
                    case 114: {
                        this.state = 2130;
                        return true;
                    }
                    case 115: {
                        this.state = 2131;
                        return true;
                    }
                    case 116: {
                        this.state = 2138;
                        return true;
                    }
                    case 117: {
                        this.state = 2146;
                        return true;
                    }
                    case 118: {
                        this.state = 2149;
                        return true;
                    }
                }
                break;
            }
            case 2065: {
                if (108 != current) break;
                this.state = 2066;
                return true;
            }
            case 2066: {
                if (105 != current) break;
                this.state = 2067;
                return true;
            }
            case 2067: {
                if (103 != current) break;
                this.state = 2068;
                return true;
            }
            case 2068: {
                if (59 != current) break;
                this.match = "\u0152";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2069: {
                if (99 != current) break;
                this.state = 2070;
                return true;
            }
            case 2070: {
                if (117 != current) break;
                this.state = 2071;
                return true;
            }
            case 2071: {
                if (116 != current) break;
                this.state = 2072;
                return true;
            }
            case 2072: {
                if (101 != current) break;
                this.match = "\u00d3";
                this.matchLength = this.consumedCount;
                this.state = 2073;
                return true;
            }
            case 2073: {
                if (59 != current) break;
                this.match = "\u00d3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2074: {
                if (105 == current) {
                    this.state = 2075;
                    return true;
                }
                if (121 != current) break;
                this.state = 2078;
                return true;
            }
            case 2075: {
                if (114 != current) break;
                this.state = 2076;
                return true;
            }
            case 2076: {
                if (99 != current) break;
                this.match = "\u00d4";
                this.matchLength = this.consumedCount;
                this.state = 2077;
                return true;
            }
            case 2077: {
                if (59 != current) break;
                this.match = "\u00d4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2078: {
                if (59 != current) break;
                this.match = "\u041e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2079: {
                if (98 != current) break;
                this.state = 2080;
                return true;
            }
            case 2080: {
                if (108 != current) break;
                this.state = 2081;
                return true;
            }
            case 2081: {
                if (97 != current) break;
                this.state = 2082;
                return true;
            }
            case 2082: {
                if (99 != current) break;
                this.state = 2083;
                return true;
            }
            case 2083: {
                if (59 != current) break;
                this.match = "\u0150";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2084: {
                if (114 != current) break;
                this.state = 2085;
                return true;
            }
            case 2085: {
                if (59 != current) break;
                this.match = "\ud835\udd12";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2086: {
                if (114 != current) break;
                this.state = 2087;
                return true;
            }
            case 2087: {
                if (97 != current) break;
                this.state = 2088;
                return true;
            }
            case 2088: {
                if (118 != current) break;
                this.state = 2089;
                return true;
            }
            case 2089: {
                if (101 != current) break;
                this.match = "\u00d2";
                this.matchLength = this.consumedCount;
                this.state = 2090;
                return true;
            }
            case 2090: {
                if (59 != current) break;
                this.match = "\u00d2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2091: {
                switch (current) {
                    case 97: {
                        this.state = 2092;
                        return true;
                    }
                    case 101: {
                        this.state = 2095;
                        return true;
                    }
                    case 105: {
                        this.state = 2098;
                        return true;
                    }
                }
                break;
            }
            case 2092: {
                if (99 != current) break;
                this.state = 2093;
                return true;
            }
            case 2093: {
                if (114 != current) break;
                this.state = 2094;
                return true;
            }
            case 2094: {
                if (59 != current) break;
                this.match = "\u014c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2095: {
                if (103 != current) break;
                this.state = 2096;
                return true;
            }
            case 2096: {
                if (97 != current) break;
                this.state = 2097;
                return true;
            }
            case 2097: {
                if (59 != current) break;
                this.match = "\u03a9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2098: {
                if (99 != current) break;
                this.state = 2099;
                return true;
            }
            case 2099: {
                if (114 != current) break;
                this.state = 2100;
                return true;
            }
            case 2100: {
                if (111 != current) break;
                this.state = 2101;
                return true;
            }
            case 2101: {
                if (110 != current) break;
                this.state = 2102;
                return true;
            }
            case 2102: {
                if (59 != current) break;
                this.match = "\u039f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2103: {
                if (112 != current) break;
                this.state = 2104;
                return true;
            }
            case 2104: {
                if (102 != current) break;
                this.state = 2105;
                return true;
            }
            case 2105: {
                if (59 != current) break;
                this.match = "\ud835\udd46";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2106: {
                if (101 != current) break;
                this.state = 2107;
                return true;
            }
            case 2107: {
                if (110 != current) break;
                this.state = 2108;
                return true;
            }
            case 2108: {
                if (67 != current) break;
                this.state = 2109;
                return true;
            }
            case 2109: {
                if (117 != current) break;
                this.state = 2110;
                return true;
            }
            case 2110: {
                if (114 != current) break;
                this.state = 2111;
                return true;
            }
            case 2111: {
                if (108 != current) break;
                this.state = 2112;
                return true;
            }
            case 2112: {
                if (121 != current) break;
                this.state = 2113;
                return true;
            }
            case 2113: {
                if (68 == current) {
                    this.state = 2114;
                    return true;
                }
                if (81 != current) break;
                this.state = 2125;
                return true;
            }
            case 2114: {
                if (111 != current) break;
                this.state = 2115;
                return true;
            }
            case 2115: {
                if (117 != current) break;
                this.state = 2116;
                return true;
            }
            case 2116: {
                if (98 != current) break;
                this.state = 2117;
                return true;
            }
            case 2117: {
                if (108 != current) break;
                this.state = 2118;
                return true;
            }
            case 2118: {
                if (101 != current) break;
                this.state = 2119;
                return true;
            }
            case 2119: {
                if (81 != current) break;
                this.state = 2120;
                return true;
            }
            case 2120: {
                if (117 != current) break;
                this.state = 2121;
                return true;
            }
            case 2121: {
                if (111 != current) break;
                this.state = 2122;
                return true;
            }
            case 2122: {
                if (116 != current) break;
                this.state = 2123;
                return true;
            }
            case 2123: {
                if (101 != current) break;
                this.state = 2124;
                return true;
            }
            case 2124: {
                if (59 != current) break;
                this.match = "\u201c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2125: {
                if (117 != current) break;
                this.state = 2126;
                return true;
            }
            case 2126: {
                if (111 != current) break;
                this.state = 2127;
                return true;
            }
            case 2127: {
                if (116 != current) break;
                this.state = 2128;
                return true;
            }
            case 2128: {
                if (101 != current) break;
                this.state = 2129;
                return true;
            }
            case 2129: {
                if (59 != current) break;
                this.match = "\u2018";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2130: {
                if (59 != current) break;
                this.match = "\u2a54";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2131: {
                if (99 == current) {
                    this.state = 2132;
                    return true;
                }
                if (108 != current) break;
                this.state = 2134;
                return true;
            }
            case 2132: {
                if (114 != current) break;
                this.state = 2133;
                return true;
            }
            case 2133: {
                if (59 != current) break;
                this.match = "\ud835\udcaa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2134: {
                if (97 != current) break;
                this.state = 2135;
                return true;
            }
            case 2135: {
                if (115 != current) break;
                this.state = 2136;
                return true;
            }
            case 2136: {
                if (104 != current) break;
                this.match = "\u00d8";
                this.matchLength = this.consumedCount;
                this.state = 2137;
                return true;
            }
            case 2137: {
                if (59 != current) break;
                this.match = "\u00d8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2138: {
                if (105 != current) break;
                this.state = 2139;
                return true;
            }
            case 2139: {
                if (108 == current) {
                    this.state = 2140;
                    return true;
                }
                if (109 != current) break;
                this.state = 2143;
                return true;
            }
            case 2140: {
                if (100 != current) break;
                this.state = 2141;
                return true;
            }
            case 2141: {
                if (101 != current) break;
                this.match = "\u00d5";
                this.matchLength = this.consumedCount;
                this.state = 2142;
                return true;
            }
            case 2142: {
                if (59 != current) break;
                this.match = "\u00d5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2143: {
                if (101 != current) break;
                this.state = 2144;
                return true;
            }
            case 2144: {
                if (115 != current) break;
                this.state = 2145;
                return true;
            }
            case 2145: {
                if (59 != current) break;
                this.match = "\u2a37";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2146: {
                if (109 != current) break;
                this.state = 2147;
                return true;
            }
            case 2147: {
                if (108 != current) break;
                this.match = "\u00d6";
                this.matchLength = this.consumedCount;
                this.state = 2148;
                return true;
            }
            case 2148: {
                if (59 != current) break;
                this.match = "\u00d6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2149: {
                if (101 != current) break;
                this.state = 2150;
                return true;
            }
            case 2150: {
                if (114 != current) break;
                this.state = 2151;
                return true;
            }
            case 2151: {
                if (66 == current) {
                    this.state = 2152;
                    return true;
                }
                if (80 != current) break;
                this.state = 2162;
                return true;
            }
            case 2152: {
                if (97 == current) {
                    this.state = 2153;
                    return true;
                }
                if (114 != current) break;
                this.state = 2155;
                return true;
            }
            case 2153: {
                if (114 != current) break;
                this.state = 2154;
                return true;
            }
            case 2154: {
                if (59 != current) break;
                this.match = "\u203e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2155: {
                if (97 != current) break;
                this.state = 2156;
                return true;
            }
            case 2156: {
                if (99 != current) break;
                this.state = 2157;
                return true;
            }
            case 2157: {
                if (101 == current) {
                    this.state = 2158;
                    return true;
                }
                if (107 != current) break;
                this.state = 2159;
                return true;
            }
            case 2158: {
                if (59 != current) break;
                this.match = "\u23de";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2159: {
                if (101 != current) break;
                this.state = 2160;
                return true;
            }
            case 2160: {
                if (116 != current) break;
                this.state = 2161;
                return true;
            }
            case 2161: {
                if (59 != current) break;
                this.match = "\u23b4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2162: {
                if (97 != current) break;
                this.state = 2163;
                return true;
            }
            case 2163: {
                if (114 != current) break;
                this.state = 2164;
                return true;
            }
            case 2164: {
                if (101 != current) break;
                this.state = 2165;
                return true;
            }
            case 2165: {
                if (110 != current) break;
                this.state = 2166;
                return true;
            }
            case 2166: {
                if (116 != current) break;
                this.state = 2167;
                return true;
            }
            case 2167: {
                if (104 != current) break;
                this.state = 2168;
                return true;
            }
            case 2168: {
                if (101 != current) break;
                this.state = 2169;
                return true;
            }
            case 2169: {
                if (115 != current) break;
                this.state = 2170;
                return true;
            }
            case 2170: {
                if (105 != current) break;
                this.state = 2171;
                return true;
            }
            case 2171: {
                if (115 != current) break;
                this.state = 2172;
                return true;
            }
            case 2172: {
                if (59 != current) break;
                this.match = "\u23dc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2173: {
                switch (current) {
                    case 97: {
                        this.state = 2174;
                        return true;
                    }
                    case 99: {
                        this.state = 2181;
                        return true;
                    }
                    case 102: {
                        this.state = 2183;
                        return true;
                    }
                    case 104: {
                        this.state = 2185;
                        return true;
                    }
                    case 105: {
                        this.state = 2187;
                        return true;
                    }
                    case 108: {
                        this.state = 2188;
                        return true;
                    }
                    case 111: {
                        this.state = 2196;
                        return true;
                    }
                    case 114: {
                        this.state = 2210;
                        return true;
                    }
                    case 115: {
                        this.state = 2254;
                        return true;
                    }
                }
                break;
            }
            case 2174: {
                if (114 != current) break;
                this.state = 2175;
                return true;
            }
            case 2175: {
                if (116 != current) break;
                this.state = 2176;
                return true;
            }
            case 2176: {
                if (105 != current) break;
                this.state = 2177;
                return true;
            }
            case 2177: {
                if (97 != current) break;
                this.state = 2178;
                return true;
            }
            case 2178: {
                if (108 != current) break;
                this.state = 2179;
                return true;
            }
            case 2179: {
                if (68 != current) break;
                this.state = 2180;
                return true;
            }
            case 2180: {
                if (59 != current) break;
                this.match = "\u2202";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2181: {
                if (121 != current) break;
                this.state = 2182;
                return true;
            }
            case 2182: {
                if (59 != current) break;
                this.match = "\u041f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2183: {
                if (114 != current) break;
                this.state = 2184;
                return true;
            }
            case 2184: {
                if (59 != current) break;
                this.match = "\ud835\udd13";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2185: {
                if (105 != current) break;
                this.state = 2186;
                return true;
            }
            case 2186: {
                if (59 != current) break;
                this.match = "\u03a6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2187: {
                if (59 != current) break;
                this.match = "\u03a0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2188: {
                if (117 != current) break;
                this.state = 2189;
                return true;
            }
            case 2189: {
                if (115 != current) break;
                this.state = 2190;
                return true;
            }
            case 2190: {
                if (77 != current) break;
                this.state = 2191;
                return true;
            }
            case 2191: {
                if (105 != current) break;
                this.state = 2192;
                return true;
            }
            case 2192: {
                if (110 != current) break;
                this.state = 2193;
                return true;
            }
            case 2193: {
                if (117 != current) break;
                this.state = 2194;
                return true;
            }
            case 2194: {
                if (115 != current) break;
                this.state = 2195;
                return true;
            }
            case 2195: {
                if (59 != current) break;
                this.match = "\u00b1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2196: {
                if (105 == current) {
                    this.state = 2197;
                    return true;
                }
                if (112 != current) break;
                this.state = 2208;
                return true;
            }
            case 2197: {
                if (110 != current) break;
                this.state = 2198;
                return true;
            }
            case 2198: {
                if (99 != current) break;
                this.state = 2199;
                return true;
            }
            case 2199: {
                if (97 != current) break;
                this.state = 2200;
                return true;
            }
            case 2200: {
                if (114 != current) break;
                this.state = 2201;
                return true;
            }
            case 2201: {
                if (101 != current) break;
                this.state = 2202;
                return true;
            }
            case 2202: {
                if (112 != current) break;
                this.state = 2203;
                return true;
            }
            case 2203: {
                if (108 != current) break;
                this.state = 2204;
                return true;
            }
            case 2204: {
                if (97 != current) break;
                this.state = 2205;
                return true;
            }
            case 2205: {
                if (110 != current) break;
                this.state = 2206;
                return true;
            }
            case 2206: {
                if (101 != current) break;
                this.state = 2207;
                return true;
            }
            case 2207: {
                if (59 != current) break;
                this.match = "\u210c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2208: {
                if (102 != current) break;
                this.state = 2209;
                return true;
            }
            case 2209: {
                if (59 != current) break;
                this.match = "\u2119";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2210: {
                switch (current) {
                    case 59: {
                        this.match = "\u2abb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 2211;
                        return true;
                    }
                    case 105: {
                        this.state = 2237;
                        return true;
                    }
                    case 111: {
                        this.state = 2240;
                        return true;
                    }
                }
                break;
            }
            case 2211: {
                if (99 != current) break;
                this.state = 2212;
                return true;
            }
            case 2212: {
                if (101 != current) break;
                this.state = 2213;
                return true;
            }
            case 2213: {
                if (100 != current) break;
                this.state = 2214;
                return true;
            }
            case 2214: {
                if (101 != current) break;
                this.state = 2215;
                return true;
            }
            case 2215: {
                if (115 != current) break;
                this.state = 2216;
                return true;
            }
            case 2216: {
                switch (current) {
                    case 59: {
                        this.match = "\u227a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2217;
                        return true;
                    }
                    case 83: {
                        this.state = 2222;
                        return true;
                    }
                    case 84: {
                        this.state = 2232;
                        return true;
                    }
                }
                break;
            }
            case 2217: {
                if (113 != current) break;
                this.state = 2218;
                return true;
            }
            case 2218: {
                if (117 != current) break;
                this.state = 2219;
                return true;
            }
            case 2219: {
                if (97 != current) break;
                this.state = 2220;
                return true;
            }
            case 2220: {
                if (108 != current) break;
                this.state = 2221;
                return true;
            }
            case 2221: {
                if (59 != current) break;
                this.match = "\u2aaf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2222: {
                if (108 != current) break;
                this.state = 2223;
                return true;
            }
            case 2223: {
                if (97 != current) break;
                this.state = 2224;
                return true;
            }
            case 2224: {
                if (110 != current) break;
                this.state = 2225;
                return true;
            }
            case 2225: {
                if (116 != current) break;
                this.state = 2226;
                return true;
            }
            case 2226: {
                if (69 != current) break;
                this.state = 2227;
                return true;
            }
            case 2227: {
                if (113 != current) break;
                this.state = 2228;
                return true;
            }
            case 2228: {
                if (117 != current) break;
                this.state = 2229;
                return true;
            }
            case 2229: {
                if (97 != current) break;
                this.state = 2230;
                return true;
            }
            case 2230: {
                if (108 != current) break;
                this.state = 2231;
                return true;
            }
            case 2231: {
                if (59 != current) break;
                this.match = "\u227c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2232: {
                if (105 != current) break;
                this.state = 2233;
                return true;
            }
            case 2233: {
                if (108 != current) break;
                this.state = 2234;
                return true;
            }
            case 2234: {
                if (100 != current) break;
                this.state = 2235;
                return true;
            }
            case 2235: {
                if (101 != current) break;
                this.state = 2236;
                return true;
            }
            case 2236: {
                if (59 != current) break;
                this.match = "\u227e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2237: {
                if (109 != current) break;
                this.state = 2238;
                return true;
            }
            case 2238: {
                if (101 != current) break;
                this.state = 2239;
                return true;
            }
            case 2239: {
                if (59 != current) break;
                this.match = "\u2033";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2240: {
                if (100 == current) {
                    this.state = 2241;
                    return true;
                }
                if (112 != current) break;
                this.state = 2245;
                return true;
            }
            case 2241: {
                if (117 != current) break;
                this.state = 2242;
                return true;
            }
            case 2242: {
                if (99 != current) break;
                this.state = 2243;
                return true;
            }
            case 2243: {
                if (116 != current) break;
                this.state = 2244;
                return true;
            }
            case 2244: {
                if (59 != current) break;
                this.match = "\u220f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2245: {
                if (111 != current) break;
                this.state = 2246;
                return true;
            }
            case 2246: {
                if (114 != current) break;
                this.state = 2247;
                return true;
            }
            case 2247: {
                if (116 != current) break;
                this.state = 2248;
                return true;
            }
            case 2248: {
                if (105 != current) break;
                this.state = 2249;
                return true;
            }
            case 2249: {
                if (111 != current) break;
                this.state = 2250;
                return true;
            }
            case 2250: {
                if (110 != current) break;
                this.state = 2251;
                return true;
            }
            case 2251: {
                if (59 == current) {
                    this.match = "\u2237";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (97 != current) break;
                this.state = 2252;
                return true;
            }
            case 2252: {
                if (108 != current) break;
                this.state = 2253;
                return true;
            }
            case 2253: {
                if (59 != current) break;
                this.match = "\u221d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2254: {
                if (99 == current) {
                    this.state = 2255;
                    return true;
                }
                if (105 != current) break;
                this.state = 2257;
                return true;
            }
            case 2255: {
                if (114 != current) break;
                this.state = 2256;
                return true;
            }
            case 2256: {
                if (59 != current) break;
                this.match = "\ud835\udcab";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2257: {
                if (59 != current) break;
                this.match = "\u03a8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2258: {
                switch (current) {
                    case 85: {
                        this.state = 2259;
                        return true;
                    }
                    case 102: {
                        this.state = 2262;
                        return true;
                    }
                    case 111: {
                        this.state = 2264;
                        return true;
                    }
                    case 115: {
                        this.state = 2267;
                        return true;
                    }
                }
                break;
            }
            case 2259: {
                if (79 != current) break;
                this.state = 2260;
                return true;
            }
            case 2260: {
                if (84 != current) break;
                this.match = "\"";
                this.matchLength = this.consumedCount;
                this.state = 2261;
                return true;
            }
            case 2261: {
                if (59 != current) break;
                this.match = "\"";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2262: {
                if (114 != current) break;
                this.state = 2263;
                return true;
            }
            case 2263: {
                if (59 != current) break;
                this.match = "\ud835\udd14";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2264: {
                if (112 != current) break;
                this.state = 2265;
                return true;
            }
            case 2265: {
                if (102 != current) break;
                this.state = 2266;
                return true;
            }
            case 2266: {
                if (59 != current) break;
                this.match = "\u211a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2267: {
                if (99 != current) break;
                this.state = 2268;
                return true;
            }
            case 2268: {
                if (114 != current) break;
                this.state = 2269;
                return true;
            }
            case 2269: {
                if (59 != current) break;
                this.match = "\ud835\udcac";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2270: {
                switch (current) {
                    case 66: {
                        this.state = 2271;
                        return true;
                    }
                    case 69: {
                        this.state = 2275;
                        return true;
                    }
                    case 97: {
                        this.state = 2277;
                        return true;
                    }
                    case 99: {
                        this.state = 2288;
                        return true;
                    }
                    case 101: {
                        this.state = 2298;
                        return true;
                    }
                    case 102: {
                        this.state = 2334;
                        return true;
                    }
                    case 104: {
                        this.state = 2336;
                        return true;
                    }
                    case 105: {
                        this.state = 2338;
                        return true;
                    }
                    case 111: {
                        this.state = 2488;
                        return true;
                    }
                    case 114: {
                        this.state = 2501;
                        return true;
                    }
                    case 115: {
                        this.state = 2511;
                        return true;
                    }
                    case 117: {
                        this.state = 2515;
                        return true;
                    }
                }
                break;
            }
            case 2271: {
                if (97 != current) break;
                this.state = 2272;
                return true;
            }
            case 2272: {
                if (114 != current) break;
                this.state = 2273;
                return true;
            }
            case 2273: {
                if (114 != current) break;
                this.state = 2274;
                return true;
            }
            case 2274: {
                if (59 != current) break;
                this.match = "\u2910";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2275: {
                if (71 != current) break;
                this.match = "\u00ae";
                this.matchLength = this.consumedCount;
                this.state = 2276;
                return true;
            }
            case 2276: {
                if (59 != current) break;
                this.match = "\u00ae";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2277: {
                switch (current) {
                    case 99: {
                        this.state = 2278;
                        return true;
                    }
                    case 110: {
                        this.state = 2282;
                        return true;
                    }
                    case 114: {
                        this.state = 2284;
                        return true;
                    }
                }
                break;
            }
            case 2278: {
                if (117 != current) break;
                this.state = 2279;
                return true;
            }
            case 2279: {
                if (116 != current) break;
                this.state = 2280;
                return true;
            }
            case 2280: {
                if (101 != current) break;
                this.state = 2281;
                return true;
            }
            case 2281: {
                if (59 != current) break;
                this.match = "\u0154";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2282: {
                if (103 != current) break;
                this.state = 2283;
                return true;
            }
            case 2283: {
                if (59 != current) break;
                this.match = "\u27eb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2284: {
                if (114 != current) break;
                this.state = 2285;
                return true;
            }
            case 2285: {
                if (59 == current) {
                    this.match = "\u21a0";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (116 != current) break;
                this.state = 2286;
                return true;
            }
            case 2286: {
                if (108 != current) break;
                this.state = 2287;
                return true;
            }
            case 2287: {
                if (59 != current) break;
                this.match = "\u2916";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2288: {
                switch (current) {
                    case 97: {
                        this.state = 2289;
                        return true;
                    }
                    case 101: {
                        this.state = 2293;
                        return true;
                    }
                    case 121: {
                        this.state = 2297;
                        return true;
                    }
                }
                break;
            }
            case 2289: {
                if (114 != current) break;
                this.state = 2290;
                return true;
            }
            case 2290: {
                if (111 != current) break;
                this.state = 2291;
                return true;
            }
            case 2291: {
                if (110 != current) break;
                this.state = 2292;
                return true;
            }
            case 2292: {
                if (59 != current) break;
                this.match = "\u0158";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2293: {
                if (100 != current) break;
                this.state = 2294;
                return true;
            }
            case 2294: {
                if (105 != current) break;
                this.state = 2295;
                return true;
            }
            case 2295: {
                if (108 != current) break;
                this.state = 2296;
                return true;
            }
            case 2296: {
                if (59 != current) break;
                this.match = "\u0156";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2297: {
                if (59 != current) break;
                this.match = "\u0420";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2298: {
                if (59 == current) {
                    this.match = "\u211c";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (118 != current) break;
                this.state = 2299;
                return true;
            }
            case 2299: {
                if (101 != current) break;
                this.state = 2300;
                return true;
            }
            case 2300: {
                if (114 != current) break;
                this.state = 2301;
                return true;
            }
            case 2301: {
                if (115 != current) break;
                this.state = 2302;
                return true;
            }
            case 2302: {
                if (101 != current) break;
                this.state = 2303;
                return true;
            }
            case 2303: {
                if (69 == current) {
                    this.state = 2304;
                    return true;
                }
                if (85 != current) break;
                this.state = 2321;
                return true;
            }
            case 2304: {
                if (108 == current) {
                    this.state = 2305;
                    return true;
                }
                if (113 != current) break;
                this.state = 2311;
                return true;
            }
            case 2305: {
                if (101 != current) break;
                this.state = 2306;
                return true;
            }
            case 2306: {
                if (109 != current) break;
                this.state = 2307;
                return true;
            }
            case 2307: {
                if (101 != current) break;
                this.state = 2308;
                return true;
            }
            case 2308: {
                if (110 != current) break;
                this.state = 2309;
                return true;
            }
            case 2309: {
                if (116 != current) break;
                this.state = 2310;
                return true;
            }
            case 2310: {
                if (59 != current) break;
                this.match = "\u220b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2311: {
                if (117 != current) break;
                this.state = 2312;
                return true;
            }
            case 2312: {
                if (105 != current) break;
                this.state = 2313;
                return true;
            }
            case 2313: {
                if (108 != current) break;
                this.state = 2314;
                return true;
            }
            case 2314: {
                if (105 != current) break;
                this.state = 2315;
                return true;
            }
            case 2315: {
                if (98 != current) break;
                this.state = 2316;
                return true;
            }
            case 2316: {
                if (114 != current) break;
                this.state = 2317;
                return true;
            }
            case 2317: {
                if (105 != current) break;
                this.state = 2318;
                return true;
            }
            case 2318: {
                if (117 != current) break;
                this.state = 2319;
                return true;
            }
            case 2319: {
                if (109 != current) break;
                this.state = 2320;
                return true;
            }
            case 2320: {
                if (59 != current) break;
                this.match = "\u21cb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2321: {
                if (112 != current) break;
                this.state = 2322;
                return true;
            }
            case 2322: {
                if (69 != current) break;
                this.state = 2323;
                return true;
            }
            case 2323: {
                if (113 != current) break;
                this.state = 2324;
                return true;
            }
            case 2324: {
                if (117 != current) break;
                this.state = 2325;
                return true;
            }
            case 2325: {
                if (105 != current) break;
                this.state = 2326;
                return true;
            }
            case 2326: {
                if (108 != current) break;
                this.state = 2327;
                return true;
            }
            case 2327: {
                if (105 != current) break;
                this.state = 2328;
                return true;
            }
            case 2328: {
                if (98 != current) break;
                this.state = 2329;
                return true;
            }
            case 2329: {
                if (114 != current) break;
                this.state = 2330;
                return true;
            }
            case 2330: {
                if (105 != current) break;
                this.state = 2331;
                return true;
            }
            case 2331: {
                if (117 != current) break;
                this.state = 2332;
                return true;
            }
            case 2332: {
                if (109 != current) break;
                this.state = 2333;
                return true;
            }
            case 2333: {
                if (59 != current) break;
                this.match = "\u296f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2334: {
                if (114 != current) break;
                this.state = 2335;
                return true;
            }
            case 2335: {
                if (59 != current) break;
                this.match = "\u211c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2336: {
                if (111 != current) break;
                this.state = 2337;
                return true;
            }
            case 2337: {
                if (59 != current) break;
                this.match = "\u03a1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2338: {
                if (103 != current) break;
                this.state = 2339;
                return true;
            }
            case 2339: {
                if (104 != current) break;
                this.state = 2340;
                return true;
            }
            case 2340: {
                if (116 != current) break;
                this.state = 2341;
                return true;
            }
            case 2341: {
                switch (current) {
                    case 65: {
                        this.state = 2342;
                        return true;
                    }
                    case 67: {
                        this.state = 2370;
                        return true;
                    }
                    case 68: {
                        this.state = 2377;
                        return true;
                    }
                    case 70: {
                        this.state = 2410;
                        return true;
                    }
                    case 84: {
                        this.state = 2415;
                        return true;
                    }
                    case 85: {
                        this.state = 2444;
                        return true;
                    }
                    case 86: {
                        this.state = 2474;
                        return true;
                    }
                    case 97: {
                        this.state = 2483;
                        return true;
                    }
                }
                break;
            }
            case 2342: {
                if (110 == current) {
                    this.state = 2343;
                    return true;
                }
                if (114 != current) break;
                this.state = 2354;
                return true;
            }
            case 2343: {
                if (103 != current) break;
                this.state = 2344;
                return true;
            }
            case 2344: {
                if (108 != current) break;
                this.state = 2345;
                return true;
            }
            case 2345: {
                if (101 != current) break;
                this.state = 2346;
                return true;
            }
            case 2346: {
                if (66 != current) break;
                this.state = 2347;
                return true;
            }
            case 2347: {
                if (114 != current) break;
                this.state = 2348;
                return true;
            }
            case 2348: {
                if (97 != current) break;
                this.state = 2349;
                return true;
            }
            case 2349: {
                if (99 != current) break;
                this.state = 2350;
                return true;
            }
            case 2350: {
                if (107 != current) break;
                this.state = 2351;
                return true;
            }
            case 2351: {
                if (101 != current) break;
                this.state = 2352;
                return true;
            }
            case 2352: {
                if (116 != current) break;
                this.state = 2353;
                return true;
            }
            case 2353: {
                if (59 != current) break;
                this.match = "\u27e9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2354: {
                if (114 != current) break;
                this.state = 2355;
                return true;
            }
            case 2355: {
                if (111 != current) break;
                this.state = 2356;
                return true;
            }
            case 2356: {
                if (119 != current) break;
                this.state = 2357;
                return true;
            }
            case 2357: {
                switch (current) {
                    case 59: {
                        this.match = "\u2192";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2358;
                        return true;
                    }
                    case 76: {
                        this.state = 2361;
                        return true;
                    }
                }
                break;
            }
            case 2358: {
                if (97 != current) break;
                this.state = 2359;
                return true;
            }
            case 2359: {
                if (114 != current) break;
                this.state = 2360;
                return true;
            }
            case 2360: {
                if (59 != current) break;
                this.match = "\u21e5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2361: {
                if (101 != current) break;
                this.state = 2362;
                return true;
            }
            case 2362: {
                if (102 != current) break;
                this.state = 2363;
                return true;
            }
            case 2363: {
                if (116 != current) break;
                this.state = 2364;
                return true;
            }
            case 2364: {
                if (65 != current) break;
                this.state = 2365;
                return true;
            }
            case 2365: {
                if (114 != current) break;
                this.state = 2366;
                return true;
            }
            case 2366: {
                if (114 != current) break;
                this.state = 2367;
                return true;
            }
            case 2367: {
                if (111 != current) break;
                this.state = 2368;
                return true;
            }
            case 2368: {
                if (119 != current) break;
                this.state = 2369;
                return true;
            }
            case 2369: {
                if (59 != current) break;
                this.match = "\u21c4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2370: {
                if (101 != current) break;
                this.state = 2371;
                return true;
            }
            case 2371: {
                if (105 != current) break;
                this.state = 2372;
                return true;
            }
            case 2372: {
                if (108 != current) break;
                this.state = 2373;
                return true;
            }
            case 2373: {
                if (105 != current) break;
                this.state = 2374;
                return true;
            }
            case 2374: {
                if (110 != current) break;
                this.state = 2375;
                return true;
            }
            case 2375: {
                if (103 != current) break;
                this.state = 2376;
                return true;
            }
            case 2376: {
                if (59 != current) break;
                this.match = "\u2309";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2377: {
                if (111 != current) break;
                this.state = 2378;
                return true;
            }
            case 2378: {
                if (117 == current) {
                    this.state = 2379;
                    return true;
                }
                if (119 != current) break;
                this.state = 2390;
                return true;
            }
            case 2379: {
                if (98 != current) break;
                this.state = 2380;
                return true;
            }
            case 2380: {
                if (108 != current) break;
                this.state = 2381;
                return true;
            }
            case 2381: {
                if (101 != current) break;
                this.state = 2382;
                return true;
            }
            case 2382: {
                if (66 != current) break;
                this.state = 2383;
                return true;
            }
            case 2383: {
                if (114 != current) break;
                this.state = 2384;
                return true;
            }
            case 2384: {
                if (97 != current) break;
                this.state = 2385;
                return true;
            }
            case 2385: {
                if (99 != current) break;
                this.state = 2386;
                return true;
            }
            case 2386: {
                if (107 != current) break;
                this.state = 2387;
                return true;
            }
            case 2387: {
                if (101 != current) break;
                this.state = 2388;
                return true;
            }
            case 2388: {
                if (116 != current) break;
                this.state = 2389;
                return true;
            }
            case 2389: {
                if (59 != current) break;
                this.match = "\u27e7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2390: {
                if (110 != current) break;
                this.state = 2391;
                return true;
            }
            case 2391: {
                if (84 == current) {
                    this.state = 2392;
                    return true;
                }
                if (86 != current) break;
                this.state = 2401;
                return true;
            }
            case 2392: {
                if (101 != current) break;
                this.state = 2393;
                return true;
            }
            case 2393: {
                if (101 != current) break;
                this.state = 2394;
                return true;
            }
            case 2394: {
                if (86 != current) break;
                this.state = 2395;
                return true;
            }
            case 2395: {
                if (101 != current) break;
                this.state = 2396;
                return true;
            }
            case 2396: {
                if (99 != current) break;
                this.state = 2397;
                return true;
            }
            case 2397: {
                if (116 != current) break;
                this.state = 2398;
                return true;
            }
            case 2398: {
                if (111 != current) break;
                this.state = 2399;
                return true;
            }
            case 2399: {
                if (114 != current) break;
                this.state = 2400;
                return true;
            }
            case 2400: {
                if (59 != current) break;
                this.match = "\u295d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2401: {
                if (101 != current) break;
                this.state = 2402;
                return true;
            }
            case 2402: {
                if (99 != current) break;
                this.state = 2403;
                return true;
            }
            case 2403: {
                if (116 != current) break;
                this.state = 2404;
                return true;
            }
            case 2404: {
                if (111 != current) break;
                this.state = 2405;
                return true;
            }
            case 2405: {
                if (114 != current) break;
                this.state = 2406;
                return true;
            }
            case 2406: {
                if (59 == current) {
                    this.match = "\u21c2";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 2407;
                return true;
            }
            case 2407: {
                if (97 != current) break;
                this.state = 2408;
                return true;
            }
            case 2408: {
                if (114 != current) break;
                this.state = 2409;
                return true;
            }
            case 2409: {
                if (59 != current) break;
                this.match = "\u2955";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2410: {
                if (108 != current) break;
                this.state = 2411;
                return true;
            }
            case 2411: {
                if (111 != current) break;
                this.state = 2412;
                return true;
            }
            case 2412: {
                if (111 != current) break;
                this.state = 2413;
                return true;
            }
            case 2413: {
                if (114 != current) break;
                this.state = 2414;
                return true;
            }
            case 2414: {
                if (59 != current) break;
                this.match = "\u230b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2415: {
                if (101 == current) {
                    this.state = 2416;
                    return true;
                }
                if (114 != current) break;
                this.state = 2429;
                return true;
            }
            case 2416: {
                if (101 != current) break;
                this.state = 2417;
                return true;
            }
            case 2417: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 65: {
                        this.state = 2418;
                        return true;
                    }
                    case 86: {
                        this.state = 2423;
                        return true;
                    }
                }
                break;
            }
            case 2418: {
                if (114 != current) break;
                this.state = 2419;
                return true;
            }
            case 2419: {
                if (114 != current) break;
                this.state = 2420;
                return true;
            }
            case 2420: {
                if (111 != current) break;
                this.state = 2421;
                return true;
            }
            case 2421: {
                if (119 != current) break;
                this.state = 2422;
                return true;
            }
            case 2422: {
                if (59 != current) break;
                this.match = "\u21a6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2423: {
                if (101 != current) break;
                this.state = 2424;
                return true;
            }
            case 2424: {
                if (99 != current) break;
                this.state = 2425;
                return true;
            }
            case 2425: {
                if (116 != current) break;
                this.state = 2426;
                return true;
            }
            case 2426: {
                if (111 != current) break;
                this.state = 2427;
                return true;
            }
            case 2427: {
                if (114 != current) break;
                this.state = 2428;
                return true;
            }
            case 2428: {
                if (59 != current) break;
                this.match = "\u295b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2429: {
                if (105 != current) break;
                this.state = 2430;
                return true;
            }
            case 2430: {
                if (97 != current) break;
                this.state = 2431;
                return true;
            }
            case 2431: {
                if (110 != current) break;
                this.state = 2432;
                return true;
            }
            case 2432: {
                if (103 != current) break;
                this.state = 2433;
                return true;
            }
            case 2433: {
                if (108 != current) break;
                this.state = 2434;
                return true;
            }
            case 2434: {
                if (101 != current) break;
                this.state = 2435;
                return true;
            }
            case 2435: {
                switch (current) {
                    case 59: {
                        this.match = "\u22b3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2436;
                        return true;
                    }
                    case 69: {
                        this.state = 2439;
                        return true;
                    }
                }
                break;
            }
            case 2436: {
                if (97 != current) break;
                this.state = 2437;
                return true;
            }
            case 2437: {
                if (114 != current) break;
                this.state = 2438;
                return true;
            }
            case 2438: {
                if (59 != current) break;
                this.match = "\u29d0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2439: {
                if (113 != current) break;
                this.state = 2440;
                return true;
            }
            case 2440: {
                if (117 != current) break;
                this.state = 2441;
                return true;
            }
            case 2441: {
                if (97 != current) break;
                this.state = 2442;
                return true;
            }
            case 2442: {
                if (108 != current) break;
                this.state = 2443;
                return true;
            }
            case 2443: {
                if (59 != current) break;
                this.match = "\u22b5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2444: {
                if (112 != current) break;
                this.state = 2445;
                return true;
            }
            case 2445: {
                switch (current) {
                    case 68: {
                        this.state = 2446;
                        return true;
                    }
                    case 84: {
                        this.state = 2456;
                        return true;
                    }
                    case 86: {
                        this.state = 2465;
                        return true;
                    }
                }
                break;
            }
            case 2446: {
                if (111 != current) break;
                this.state = 2447;
                return true;
            }
            case 2447: {
                if (119 != current) break;
                this.state = 2448;
                return true;
            }
            case 2448: {
                if (110 != current) break;
                this.state = 2449;
                return true;
            }
            case 2449: {
                if (86 != current) break;
                this.state = 2450;
                return true;
            }
            case 2450: {
                if (101 != current) break;
                this.state = 2451;
                return true;
            }
            case 2451: {
                if (99 != current) break;
                this.state = 2452;
                return true;
            }
            case 2452: {
                if (116 != current) break;
                this.state = 2453;
                return true;
            }
            case 2453: {
                if (111 != current) break;
                this.state = 2454;
                return true;
            }
            case 2454: {
                if (114 != current) break;
                this.state = 2455;
                return true;
            }
            case 2455: {
                if (59 != current) break;
                this.match = "\u294f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2456: {
                if (101 != current) break;
                this.state = 2457;
                return true;
            }
            case 2457: {
                if (101 != current) break;
                this.state = 2458;
                return true;
            }
            case 2458: {
                if (86 != current) break;
                this.state = 2459;
                return true;
            }
            case 2459: {
                if (101 != current) break;
                this.state = 2460;
                return true;
            }
            case 2460: {
                if (99 != current) break;
                this.state = 2461;
                return true;
            }
            case 2461: {
                if (116 != current) break;
                this.state = 2462;
                return true;
            }
            case 2462: {
                if (111 != current) break;
                this.state = 2463;
                return true;
            }
            case 2463: {
                if (114 != current) break;
                this.state = 2464;
                return true;
            }
            case 2464: {
                if (59 != current) break;
                this.match = "\u295c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2465: {
                if (101 != current) break;
                this.state = 2466;
                return true;
            }
            case 2466: {
                if (99 != current) break;
                this.state = 2467;
                return true;
            }
            case 2467: {
                if (116 != current) break;
                this.state = 2468;
                return true;
            }
            case 2468: {
                if (111 != current) break;
                this.state = 2469;
                return true;
            }
            case 2469: {
                if (114 != current) break;
                this.state = 2470;
                return true;
            }
            case 2470: {
                if (59 == current) {
                    this.match = "\u21be";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 2471;
                return true;
            }
            case 2471: {
                if (97 != current) break;
                this.state = 2472;
                return true;
            }
            case 2472: {
                if (114 != current) break;
                this.state = 2473;
                return true;
            }
            case 2473: {
                if (59 != current) break;
                this.match = "\u2954";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2474: {
                if (101 != current) break;
                this.state = 2475;
                return true;
            }
            case 2475: {
                if (99 != current) break;
                this.state = 2476;
                return true;
            }
            case 2476: {
                if (116 != current) break;
                this.state = 2477;
                return true;
            }
            case 2477: {
                if (111 != current) break;
                this.state = 2478;
                return true;
            }
            case 2478: {
                if (114 != current) break;
                this.state = 2479;
                return true;
            }
            case 2479: {
                if (59 == current) {
                    this.match = "\u21c0";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (66 != current) break;
                this.state = 2480;
                return true;
            }
            case 2480: {
                if (97 != current) break;
                this.state = 2481;
                return true;
            }
            case 2481: {
                if (114 != current) break;
                this.state = 2482;
                return true;
            }
            case 2482: {
                if (59 != current) break;
                this.match = "\u2953";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2483: {
                if (114 != current) break;
                this.state = 2484;
                return true;
            }
            case 2484: {
                if (114 != current) break;
                this.state = 2485;
                return true;
            }
            case 2485: {
                if (111 != current) break;
                this.state = 2486;
                return true;
            }
            case 2486: {
                if (119 != current) break;
                this.state = 2487;
                return true;
            }
            case 2487: {
                if (59 != current) break;
                this.match = "\u21d2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2488: {
                if (112 == current) {
                    this.state = 2489;
                    return true;
                }
                if (117 != current) break;
                this.state = 2491;
                return true;
            }
            case 2489: {
                if (102 != current) break;
                this.state = 2490;
                return true;
            }
            case 2490: {
                if (59 != current) break;
                this.match = "\u211d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2491: {
                if (110 != current) break;
                this.state = 2492;
                return true;
            }
            case 2492: {
                if (100 != current) break;
                this.state = 2493;
                return true;
            }
            case 2493: {
                if (73 != current) break;
                this.state = 2494;
                return true;
            }
            case 2494: {
                if (109 != current) break;
                this.state = 2495;
                return true;
            }
            case 2495: {
                if (112 != current) break;
                this.state = 2496;
                return true;
            }
            case 2496: {
                if (108 != current) break;
                this.state = 2497;
                return true;
            }
            case 2497: {
                if (105 != current) break;
                this.state = 2498;
                return true;
            }
            case 2498: {
                if (101 != current) break;
                this.state = 2499;
                return true;
            }
            case 2499: {
                if (115 != current) break;
                this.state = 2500;
                return true;
            }
            case 2500: {
                if (59 != current) break;
                this.match = "\u2970";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2501: {
                if (105 != current) break;
                this.state = 2502;
                return true;
            }
            case 2502: {
                if (103 != current) break;
                this.state = 2503;
                return true;
            }
            case 2503: {
                if (104 != current) break;
                this.state = 2504;
                return true;
            }
            case 2504: {
                if (116 != current) break;
                this.state = 2505;
                return true;
            }
            case 2505: {
                if (97 != current) break;
                this.state = 2506;
                return true;
            }
            case 2506: {
                if (114 != current) break;
                this.state = 2507;
                return true;
            }
            case 2507: {
                if (114 != current) break;
                this.state = 2508;
                return true;
            }
            case 2508: {
                if (111 != current) break;
                this.state = 2509;
                return true;
            }
            case 2509: {
                if (119 != current) break;
                this.state = 2510;
                return true;
            }
            case 2510: {
                if (59 != current) break;
                this.match = "\u21db";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2511: {
                if (99 == current) {
                    this.state = 2512;
                    return true;
                }
                if (104 != current) break;
                this.state = 2514;
                return true;
            }
            case 2512: {
                if (114 != current) break;
                this.state = 2513;
                return true;
            }
            case 2513: {
                if (59 != current) break;
                this.match = "\u211b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2514: {
                if (59 != current) break;
                this.match = "\u21b1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2515: {
                if (108 != current) break;
                this.state = 2516;
                return true;
            }
            case 2516: {
                if (101 != current) break;
                this.state = 2517;
                return true;
            }
            case 2517: {
                if (68 != current) break;
                this.state = 2518;
                return true;
            }
            case 2518: {
                if (101 != current) break;
                this.state = 2519;
                return true;
            }
            case 2519: {
                if (108 != current) break;
                this.state = 2520;
                return true;
            }
            case 2520: {
                if (97 != current) break;
                this.state = 2521;
                return true;
            }
            case 2521: {
                if (121 != current) break;
                this.state = 2522;
                return true;
            }
            case 2522: {
                if (101 != current) break;
                this.state = 2523;
                return true;
            }
            case 2523: {
                if (100 != current) break;
                this.state = 2524;
                return true;
            }
            case 2524: {
                if (59 != current) break;
                this.match = "\u29f4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2525: {
                switch (current) {
                    case 72: {
                        this.state = 2526;
                        return true;
                    }
                    case 79: {
                        this.state = 2533;
                        return true;
                    }
                    case 97: {
                        this.state = 2538;
                        return true;
                    }
                    case 99: {
                        this.state = 2543;
                        return true;
                    }
                    case 102: {
                        this.state = 2556;
                        return true;
                    }
                    case 104: {
                        this.state = 2558;
                        return true;
                    }
                    case 105: {
                        this.state = 2597;
                        return true;
                    }
                    case 109: {
                        this.state = 2601;
                        return true;
                    }
                    case 111: {
                        this.state = 2611;
                        return true;
                    }
                    case 113: {
                        this.state = 2614;
                        return true;
                    }
                    case 115: {
                        this.state = 2660;
                        return true;
                    }
                    case 116: {
                        this.state = 2663;
                        return true;
                    }
                    case 117: {
                        this.state = 2666;
                        return true;
                    }
                }
                break;
            }
            case 2526: {
                if (67 == current) {
                    this.state = 2527;
                    return true;
                }
                if (99 != current) break;
                this.state = 2531;
                return true;
            }
            case 2527: {
                if (72 != current) break;
                this.state = 2528;
                return true;
            }
            case 2528: {
                if (99 != current) break;
                this.state = 2529;
                return true;
            }
            case 2529: {
                if (121 != current) break;
                this.state = 2530;
                return true;
            }
            case 2530: {
                if (59 != current) break;
                this.match = "\u0429";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2531: {
                if (121 != current) break;
                this.state = 2532;
                return true;
            }
            case 2532: {
                if (59 != current) break;
                this.match = "\u0428";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2533: {
                if (70 != current) break;
                this.state = 2534;
                return true;
            }
            case 2534: {
                if (84 != current) break;
                this.state = 2535;
                return true;
            }
            case 2535: {
                if (99 != current) break;
                this.state = 2536;
                return true;
            }
            case 2536: {
                if (121 != current) break;
                this.state = 2537;
                return true;
            }
            case 2537: {
                if (59 != current) break;
                this.match = "\u042c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2538: {
                if (99 != current) break;
                this.state = 2539;
                return true;
            }
            case 2539: {
                if (117 != current) break;
                this.state = 2540;
                return true;
            }
            case 2540: {
                if (116 != current) break;
                this.state = 2541;
                return true;
            }
            case 2541: {
                if (101 != current) break;
                this.state = 2542;
                return true;
            }
            case 2542: {
                if (59 != current) break;
                this.match = "\u015a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2543: {
                switch (current) {
                    case 59: {
                        this.match = "\u2abc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 2544;
                        return true;
                    }
                    case 101: {
                        this.state = 2548;
                        return true;
                    }
                    case 105: {
                        this.state = 2552;
                        return true;
                    }
                    case 121: {
                        this.state = 2555;
                        return true;
                    }
                }
                break;
            }
            case 2544: {
                if (114 != current) break;
                this.state = 2545;
                return true;
            }
            case 2545: {
                if (111 != current) break;
                this.state = 2546;
                return true;
            }
            case 2546: {
                if (110 != current) break;
                this.state = 2547;
                return true;
            }
            case 2547: {
                if (59 != current) break;
                this.match = "\u0160";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2548: {
                if (100 != current) break;
                this.state = 2549;
                return true;
            }
            case 2549: {
                if (105 != current) break;
                this.state = 2550;
                return true;
            }
            case 2550: {
                if (108 != current) break;
                this.state = 2551;
                return true;
            }
            case 2551: {
                if (59 != current) break;
                this.match = "\u015e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2552: {
                if (114 != current) break;
                this.state = 2553;
                return true;
            }
            case 2553: {
                if (99 != current) break;
                this.state = 2554;
                return true;
            }
            case 2554: {
                if (59 != current) break;
                this.match = "\u015c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2555: {
                if (59 != current) break;
                this.match = "\u0421";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2556: {
                if (114 != current) break;
                this.state = 2557;
                return true;
            }
            case 2557: {
                if (59 != current) break;
                this.match = "\ud835\udd16";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2558: {
                if (111 != current) break;
                this.state = 2559;
                return true;
            }
            case 2559: {
                if (114 != current) break;
                this.state = 2560;
                return true;
            }
            case 2560: {
                if (116 != current) break;
                this.state = 2561;
                return true;
            }
            case 2561: {
                switch (current) {
                    case 68: {
                        this.state = 2562;
                        return true;
                    }
                    case 76: {
                        this.state = 2571;
                        return true;
                    }
                    case 82: {
                        this.state = 2580;
                        return true;
                    }
                    case 85: {
                        this.state = 2590;
                        return true;
                    }
                }
                break;
            }
            case 2562: {
                if (111 != current) break;
                this.state = 2563;
                return true;
            }
            case 2563: {
                if (119 != current) break;
                this.state = 2564;
                return true;
            }
            case 2564: {
                if (110 != current) break;
                this.state = 2565;
                return true;
            }
            case 2565: {
                if (65 != current) break;
                this.state = 2566;
                return true;
            }
            case 2566: {
                if (114 != current) break;
                this.state = 2567;
                return true;
            }
            case 2567: {
                if (114 != current) break;
                this.state = 2568;
                return true;
            }
            case 2568: {
                if (111 != current) break;
                this.state = 2569;
                return true;
            }
            case 2569: {
                if (119 != current) break;
                this.state = 2570;
                return true;
            }
            case 2570: {
                if (59 != current) break;
                this.match = "\u2193";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2571: {
                if (101 != current) break;
                this.state = 2572;
                return true;
            }
            case 2572: {
                if (102 != current) break;
                this.state = 2573;
                return true;
            }
            case 2573: {
                if (116 != current) break;
                this.state = 2574;
                return true;
            }
            case 2574: {
                if (65 != current) break;
                this.state = 2575;
                return true;
            }
            case 2575: {
                if (114 != current) break;
                this.state = 2576;
                return true;
            }
            case 2576: {
                if (114 != current) break;
                this.state = 2577;
                return true;
            }
            case 2577: {
                if (111 != current) break;
                this.state = 2578;
                return true;
            }
            case 2578: {
                if (119 != current) break;
                this.state = 2579;
                return true;
            }
            case 2579: {
                if (59 != current) break;
                this.match = "\u2190";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2580: {
                if (105 != current) break;
                this.state = 2581;
                return true;
            }
            case 2581: {
                if (103 != current) break;
                this.state = 2582;
                return true;
            }
            case 2582: {
                if (104 != current) break;
                this.state = 2583;
                return true;
            }
            case 2583: {
                if (116 != current) break;
                this.state = 2584;
                return true;
            }
            case 2584: {
                if (65 != current) break;
                this.state = 2585;
                return true;
            }
            case 2585: {
                if (114 != current) break;
                this.state = 2586;
                return true;
            }
            case 2586: {
                if (114 != current) break;
                this.state = 2587;
                return true;
            }
            case 2587: {
                if (111 != current) break;
                this.state = 2588;
                return true;
            }
            case 2588: {
                if (119 != current) break;
                this.state = 2589;
                return true;
            }
            case 2589: {
                if (59 != current) break;
                this.match = "\u2192";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2590: {
                if (112 != current) break;
                this.state = 2591;
                return true;
            }
            case 2591: {
                if (65 != current) break;
                this.state = 2592;
                return true;
            }
            case 2592: {
                if (114 != current) break;
                this.state = 2593;
                return true;
            }
            case 2593: {
                if (114 != current) break;
                this.state = 2594;
                return true;
            }
            case 2594: {
                if (111 != current) break;
                this.state = 2595;
                return true;
            }
            case 2595: {
                if (119 != current) break;
                this.state = 2596;
                return true;
            }
            case 2596: {
                if (59 != current) break;
                this.match = "\u2191";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2597: {
                if (103 != current) break;
                this.state = 2598;
                return true;
            }
            case 2598: {
                if (109 != current) break;
                this.state = 2599;
                return true;
            }
            case 2599: {
                if (97 != current) break;
                this.state = 2600;
                return true;
            }
            case 2600: {
                if (59 != current) break;
                this.match = "\u03a3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2601: {
                if (97 != current) break;
                this.state = 2602;
                return true;
            }
            case 2602: {
                if (108 != current) break;
                this.state = 2603;
                return true;
            }
            case 2603: {
                if (108 != current) break;
                this.state = 2604;
                return true;
            }
            case 2604: {
                if (67 != current) break;
                this.state = 2605;
                return true;
            }
            case 2605: {
                if (105 != current) break;
                this.state = 2606;
                return true;
            }
            case 2606: {
                if (114 != current) break;
                this.state = 2607;
                return true;
            }
            case 2607: {
                if (99 != current) break;
                this.state = 2608;
                return true;
            }
            case 2608: {
                if (108 != current) break;
                this.state = 2609;
                return true;
            }
            case 2609: {
                if (101 != current) break;
                this.state = 2610;
                return true;
            }
            case 2610: {
                if (59 != current) break;
                this.match = "\u2218";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2611: {
                if (112 != current) break;
                this.state = 2612;
                return true;
            }
            case 2612: {
                if (102 != current) break;
                this.state = 2613;
                return true;
            }
            case 2613: {
                if (59 != current) break;
                this.match = "\ud835\udd4a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2614: {
                if (114 == current) {
                    this.state = 2615;
                    return true;
                }
                if (117 != current) break;
                this.state = 2617;
                return true;
            }
            case 2615: {
                if (116 != current) break;
                this.state = 2616;
                return true;
            }
            case 2616: {
                if (59 != current) break;
                this.match = "\u221a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2617: {
                if (97 != current) break;
                this.state = 2618;
                return true;
            }
            case 2618: {
                if (114 != current) break;
                this.state = 2619;
                return true;
            }
            case 2619: {
                if (101 != current) break;
                this.state = 2620;
                return true;
            }
            case 2620: {
                switch (current) {
                    case 59: {
                        this.match = "\u25a1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 73: {
                        this.state = 2621;
                        return true;
                    }
                    case 83: {
                        this.state = 2633;
                        return true;
                    }
                    case 85: {
                        this.state = 2655;
                        return true;
                    }
                }
                break;
            }
            case 2621: {
                if (110 != current) break;
                this.state = 2622;
                return true;
            }
            case 2622: {
                if (116 != current) break;
                this.state = 2623;
                return true;
            }
            case 2623: {
                if (101 != current) break;
                this.state = 2624;
                return true;
            }
            case 2624: {
                if (114 != current) break;
                this.state = 2625;
                return true;
            }
            case 2625: {
                if (115 != current) break;
                this.state = 2626;
                return true;
            }
            case 2626: {
                if (101 != current) break;
                this.state = 2627;
                return true;
            }
            case 2627: {
                if (99 != current) break;
                this.state = 2628;
                return true;
            }
            case 2628: {
                if (116 != current) break;
                this.state = 2629;
                return true;
            }
            case 2629: {
                if (105 != current) break;
                this.state = 2630;
                return true;
            }
            case 2630: {
                if (111 != current) break;
                this.state = 2631;
                return true;
            }
            case 2631: {
                if (110 != current) break;
                this.state = 2632;
                return true;
            }
            case 2632: {
                if (59 != current) break;
                this.match = "\u2293";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2633: {
                if (117 != current) break;
                this.state = 2634;
                return true;
            }
            case 2634: {
                if (98 == current) {
                    this.state = 2635;
                    return true;
                }
                if (112 != current) break;
                this.state = 2644;
                return true;
            }
            case 2635: {
                if (115 != current) break;
                this.state = 2636;
                return true;
            }
            case 2636: {
                if (101 != current) break;
                this.state = 2637;
                return true;
            }
            case 2637: {
                if (116 != current) break;
                this.state = 2638;
                return true;
            }
            case 2638: {
                if (59 == current) {
                    this.match = "\u228f";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 2639;
                return true;
            }
            case 2639: {
                if (113 != current) break;
                this.state = 2640;
                return true;
            }
            case 2640: {
                if (117 != current) break;
                this.state = 2641;
                return true;
            }
            case 2641: {
                if (97 != current) break;
                this.state = 2642;
                return true;
            }
            case 2642: {
                if (108 != current) break;
                this.state = 2643;
                return true;
            }
            case 2643: {
                if (59 != current) break;
                this.match = "\u2291";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2644: {
                if (101 != current) break;
                this.state = 2645;
                return true;
            }
            case 2645: {
                if (114 != current) break;
                this.state = 2646;
                return true;
            }
            case 2646: {
                if (115 != current) break;
                this.state = 2647;
                return true;
            }
            case 2647: {
                if (101 != current) break;
                this.state = 2648;
                return true;
            }
            case 2648: {
                if (116 != current) break;
                this.state = 2649;
                return true;
            }
            case 2649: {
                if (59 == current) {
                    this.match = "\u2290";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 2650;
                return true;
            }
            case 2650: {
                if (113 != current) break;
                this.state = 2651;
                return true;
            }
            case 2651: {
                if (117 != current) break;
                this.state = 2652;
                return true;
            }
            case 2652: {
                if (97 != current) break;
                this.state = 2653;
                return true;
            }
            case 2653: {
                if (108 != current) break;
                this.state = 2654;
                return true;
            }
            case 2654: {
                if (59 != current) break;
                this.match = "\u2292";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2655: {
                if (110 != current) break;
                this.state = 2656;
                return true;
            }
            case 2656: {
                if (105 != current) break;
                this.state = 2657;
                return true;
            }
            case 2657: {
                if (111 != current) break;
                this.state = 2658;
                return true;
            }
            case 2658: {
                if (110 != current) break;
                this.state = 2659;
                return true;
            }
            case 2659: {
                if (59 != current) break;
                this.match = "\u2294";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2660: {
                if (99 != current) break;
                this.state = 2661;
                return true;
            }
            case 2661: {
                if (114 != current) break;
                this.state = 2662;
                return true;
            }
            case 2662: {
                if (59 != current) break;
                this.match = "\ud835\udcae";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2663: {
                if (97 != current) break;
                this.state = 2664;
                return true;
            }
            case 2664: {
                if (114 != current) break;
                this.state = 2665;
                return true;
            }
            case 2665: {
                if (59 != current) break;
                this.match = "\u22c6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2666: {
                switch (current) {
                    case 98: {
                        this.state = 2667;
                        return true;
                    }
                    case 99: {
                        this.state = 2676;
                        return true;
                    }
                    case 109: {
                        this.state = 2707;
                        return true;
                    }
                    case 112: {
                        this.state = 2708;
                        return true;
                    }
                }
                break;
            }
            case 2667: {
                if (59 == current) {
                    this.match = "\u22d0";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (115 != current) break;
                this.state = 2668;
                return true;
            }
            case 2668: {
                if (101 != current) break;
                this.state = 2669;
                return true;
            }
            case 2669: {
                if (116 != current) break;
                this.state = 2670;
                return true;
            }
            case 2670: {
                if (59 == current) {
                    this.match = "\u22d0";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 2671;
                return true;
            }
            case 2671: {
                if (113 != current) break;
                this.state = 2672;
                return true;
            }
            case 2672: {
                if (117 != current) break;
                this.state = 2673;
                return true;
            }
            case 2673: {
                if (97 != current) break;
                this.state = 2674;
                return true;
            }
            case 2674: {
                if (108 != current) break;
                this.state = 2675;
                return true;
            }
            case 2675: {
                if (59 != current) break;
                this.match = "\u2286";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2676: {
                if (99 == current) {
                    this.state = 2677;
                    return true;
                }
                if (104 != current) break;
                this.state = 2702;
                return true;
            }
            case 2677: {
                if (101 != current) break;
                this.state = 2678;
                return true;
            }
            case 2678: {
                if (101 != current) break;
                this.state = 2679;
                return true;
            }
            case 2679: {
                if (100 != current) break;
                this.state = 2680;
                return true;
            }
            case 2680: {
                if (115 != current) break;
                this.state = 2681;
                return true;
            }
            case 2681: {
                switch (current) {
                    case 59: {
                        this.match = "\u227b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2682;
                        return true;
                    }
                    case 83: {
                        this.state = 2687;
                        return true;
                    }
                    case 84: {
                        this.state = 2697;
                        return true;
                    }
                }
                break;
            }
            case 2682: {
                if (113 != current) break;
                this.state = 2683;
                return true;
            }
            case 2683: {
                if (117 != current) break;
                this.state = 2684;
                return true;
            }
            case 2684: {
                if (97 != current) break;
                this.state = 2685;
                return true;
            }
            case 2685: {
                if (108 != current) break;
                this.state = 2686;
                return true;
            }
            case 2686: {
                if (59 != current) break;
                this.match = "\u2ab0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2687: {
                if (108 != current) break;
                this.state = 2688;
                return true;
            }
            case 2688: {
                if (97 != current) break;
                this.state = 2689;
                return true;
            }
            case 2689: {
                if (110 != current) break;
                this.state = 2690;
                return true;
            }
            case 2690: {
                if (116 != current) break;
                this.state = 2691;
                return true;
            }
            case 2691: {
                if (69 != current) break;
                this.state = 2692;
                return true;
            }
            case 2692: {
                if (113 != current) break;
                this.state = 2693;
                return true;
            }
            case 2693: {
                if (117 != current) break;
                this.state = 2694;
                return true;
            }
            case 2694: {
                if (97 != current) break;
                this.state = 2695;
                return true;
            }
            case 2695: {
                if (108 != current) break;
                this.state = 2696;
                return true;
            }
            case 2696: {
                if (59 != current) break;
                this.match = "\u227d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2697: {
                if (105 != current) break;
                this.state = 2698;
                return true;
            }
            case 2698: {
                if (108 != current) break;
                this.state = 2699;
                return true;
            }
            case 2699: {
                if (100 != current) break;
                this.state = 2700;
                return true;
            }
            case 2700: {
                if (101 != current) break;
                this.state = 2701;
                return true;
            }
            case 2701: {
                if (59 != current) break;
                this.match = "\u227f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2702: {
                if (84 != current) break;
                this.state = 2703;
                return true;
            }
            case 2703: {
                if (104 != current) break;
                this.state = 2704;
                return true;
            }
            case 2704: {
                if (97 != current) break;
                this.state = 2705;
                return true;
            }
            case 2705: {
                if (116 != current) break;
                this.state = 2706;
                return true;
            }
            case 2706: {
                if (59 != current) break;
                this.match = "\u220b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2707: {
                if (59 != current) break;
                this.match = "\u2211";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2708: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 2709;
                        return true;
                    }
                    case 115: {
                        this.state = 2719;
                        return true;
                    }
                }
                break;
            }
            case 2709: {
                if (114 != current) break;
                this.state = 2710;
                return true;
            }
            case 2710: {
                if (115 != current) break;
                this.state = 2711;
                return true;
            }
            case 2711: {
                if (101 != current) break;
                this.state = 2712;
                return true;
            }
            case 2712: {
                if (116 != current) break;
                this.state = 2713;
                return true;
            }
            case 2713: {
                if (59 == current) {
                    this.match = "\u2283";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (69 != current) break;
                this.state = 2714;
                return true;
            }
            case 2714: {
                if (113 != current) break;
                this.state = 2715;
                return true;
            }
            case 2715: {
                if (117 != current) break;
                this.state = 2716;
                return true;
            }
            case 2716: {
                if (97 != current) break;
                this.state = 2717;
                return true;
            }
            case 2717: {
                if (108 != current) break;
                this.state = 2718;
                return true;
            }
            case 2718: {
                if (59 != current) break;
                this.match = "\u2287";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2719: {
                if (101 != current) break;
                this.state = 2720;
                return true;
            }
            case 2720: {
                if (116 != current) break;
                this.state = 2721;
                return true;
            }
            case 2721: {
                if (59 != current) break;
                this.match = "\u22d1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2722: {
                switch (current) {
                    case 72: {
                        this.state = 2723;
                        return true;
                    }
                    case 82: {
                        this.state = 2727;
                        return true;
                    }
                    case 83: {
                        this.state = 2731;
                        return true;
                    }
                    case 97: {
                        this.state = 2737;
                        return true;
                    }
                    case 99: {
                        this.state = 2740;
                        return true;
                    }
                    case 102: {
                        this.state = 2750;
                        return true;
                    }
                    case 104: {
                        this.state = 2752;
                        return true;
                    }
                    case 105: {
                        this.state = 2776;
                        return true;
                    }
                    case 111: {
                        this.state = 2799;
                        return true;
                    }
                    case 114: {
                        this.state = 2802;
                        return true;
                    }
                    case 115: {
                        this.state = 2810;
                        return true;
                    }
                }
                break;
            }
            case 2723: {
                if (79 != current) break;
                this.state = 2724;
                return true;
            }
            case 2724: {
                if (82 != current) break;
                this.state = 2725;
                return true;
            }
            case 2725: {
                if (78 != current) break;
                this.match = "\u00de";
                this.matchLength = this.consumedCount;
                this.state = 2726;
                return true;
            }
            case 2726: {
                if (59 != current) break;
                this.match = "\u00de";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2727: {
                if (65 != current) break;
                this.state = 2728;
                return true;
            }
            case 2728: {
                if (68 != current) break;
                this.state = 2729;
                return true;
            }
            case 2729: {
                if (69 != current) break;
                this.state = 2730;
                return true;
            }
            case 2730: {
                if (59 != current) break;
                this.match = "\u2122";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2731: {
                if (72 == current) {
                    this.state = 2732;
                    return true;
                }
                if (99 != current) break;
                this.state = 2735;
                return true;
            }
            case 2732: {
                if (99 != current) break;
                this.state = 2733;
                return true;
            }
            case 2733: {
                if (121 != current) break;
                this.state = 2734;
                return true;
            }
            case 2734: {
                if (59 != current) break;
                this.match = "\u040b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2735: {
                if (121 != current) break;
                this.state = 2736;
                return true;
            }
            case 2736: {
                if (59 != current) break;
                this.match = "\u0426";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2737: {
                if (98 == current) {
                    this.state = 2738;
                    return true;
                }
                if (117 != current) break;
                this.state = 2739;
                return true;
            }
            case 2738: {
                if (59 != current) break;
                this.match = "\t";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2739: {
                if (59 != current) break;
                this.match = "\u03a4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2740: {
                switch (current) {
                    case 97: {
                        this.state = 2741;
                        return true;
                    }
                    case 101: {
                        this.state = 2745;
                        return true;
                    }
                    case 121: {
                        this.state = 2749;
                        return true;
                    }
                }
                break;
            }
            case 2741: {
                if (114 != current) break;
                this.state = 2742;
                return true;
            }
            case 2742: {
                if (111 != current) break;
                this.state = 2743;
                return true;
            }
            case 2743: {
                if (110 != current) break;
                this.state = 2744;
                return true;
            }
            case 2744: {
                if (59 != current) break;
                this.match = "\u0164";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2745: {
                if (100 != current) break;
                this.state = 2746;
                return true;
            }
            case 2746: {
                if (105 != current) break;
                this.state = 2747;
                return true;
            }
            case 2747: {
                if (108 != current) break;
                this.state = 2748;
                return true;
            }
            case 2748: {
                if (59 != current) break;
                this.match = "\u0162";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2749: {
                if (59 != current) break;
                this.match = "\u0422";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2750: {
                if (114 != current) break;
                this.state = 2751;
                return true;
            }
            case 2751: {
                if (59 != current) break;
                this.match = "\ud835\udd17";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2752: {
                if (101 == current) {
                    this.state = 2753;
                    return true;
                }
                if (105 != current) break;
                this.state = 2762;
                return true;
            }
            case 2753: {
                if (114 == current) {
                    this.state = 2754;
                    return true;
                }
                if (116 != current) break;
                this.state = 2760;
                return true;
            }
            case 2754: {
                if (101 != current) break;
                this.state = 2755;
                return true;
            }
            case 2755: {
                if (102 != current) break;
                this.state = 2756;
                return true;
            }
            case 2756: {
                if (111 != current) break;
                this.state = 2757;
                return true;
            }
            case 2757: {
                if (114 != current) break;
                this.state = 2758;
                return true;
            }
            case 2758: {
                if (101 != current) break;
                this.state = 2759;
                return true;
            }
            case 2759: {
                if (59 != current) break;
                this.match = "\u2234";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2760: {
                if (97 != current) break;
                this.state = 2761;
                return true;
            }
            case 2761: {
                if (59 != current) break;
                this.match = "\u0398";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2762: {
                if (99 == current) {
                    this.state = 2763;
                    return true;
                }
                if (110 != current) break;
                this.state = 2770;
                return true;
            }
            case 2763: {
                if (107 != current) break;
                this.state = 2764;
                return true;
            }
            case 2764: {
                if (83 != current) break;
                this.state = 2765;
                return true;
            }
            case 2765: {
                if (112 != current) break;
                this.state = 2766;
                return true;
            }
            case 2766: {
                if (97 != current) break;
                this.state = 2767;
                return true;
            }
            case 2767: {
                if (99 != current) break;
                this.state = 2768;
                return true;
            }
            case 2768: {
                if (101 != current) break;
                this.state = 2769;
                return true;
            }
            case 2769: {
                if (59 != current) break;
                this.match = "\u205f\u200a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2770: {
                if (83 != current) break;
                this.state = 2771;
                return true;
            }
            case 2771: {
                if (112 != current) break;
                this.state = 2772;
                return true;
            }
            case 2772: {
                if (97 != current) break;
                this.state = 2773;
                return true;
            }
            case 2773: {
                if (99 != current) break;
                this.state = 2774;
                return true;
            }
            case 2774: {
                if (101 != current) break;
                this.state = 2775;
                return true;
            }
            case 2775: {
                if (59 != current) break;
                this.match = "\u2009";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2776: {
                if (108 != current) break;
                this.state = 2777;
                return true;
            }
            case 2777: {
                if (100 != current) break;
                this.state = 2778;
                return true;
            }
            case 2778: {
                if (101 != current) break;
                this.state = 2779;
                return true;
            }
            case 2779: {
                switch (current) {
                    case 59: {
                        this.match = "\u223c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2780;
                        return true;
                    }
                    case 70: {
                        this.state = 2785;
                        return true;
                    }
                    case 84: {
                        this.state = 2794;
                        return true;
                    }
                }
                break;
            }
            case 2780: {
                if (113 != current) break;
                this.state = 2781;
                return true;
            }
            case 2781: {
                if (117 != current) break;
                this.state = 2782;
                return true;
            }
            case 2782: {
                if (97 != current) break;
                this.state = 2783;
                return true;
            }
            case 2783: {
                if (108 != current) break;
                this.state = 2784;
                return true;
            }
            case 2784: {
                if (59 != current) break;
                this.match = "\u2243";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2785: {
                if (117 != current) break;
                this.state = 2786;
                return true;
            }
            case 2786: {
                if (108 != current) break;
                this.state = 2787;
                return true;
            }
            case 2787: {
                if (108 != current) break;
                this.state = 2788;
                return true;
            }
            case 2788: {
                if (69 != current) break;
                this.state = 2789;
                return true;
            }
            case 2789: {
                if (113 != current) break;
                this.state = 2790;
                return true;
            }
            case 2790: {
                if (117 != current) break;
                this.state = 2791;
                return true;
            }
            case 2791: {
                if (97 != current) break;
                this.state = 2792;
                return true;
            }
            case 2792: {
                if (108 != current) break;
                this.state = 2793;
                return true;
            }
            case 2793: {
                if (59 != current) break;
                this.match = "\u2245";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2794: {
                if (105 != current) break;
                this.state = 2795;
                return true;
            }
            case 2795: {
                if (108 != current) break;
                this.state = 2796;
                return true;
            }
            case 2796: {
                if (100 != current) break;
                this.state = 2797;
                return true;
            }
            case 2797: {
                if (101 != current) break;
                this.state = 2798;
                return true;
            }
            case 2798: {
                if (59 != current) break;
                this.match = "\u2248";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2799: {
                if (112 != current) break;
                this.state = 2800;
                return true;
            }
            case 2800: {
                if (102 != current) break;
                this.state = 2801;
                return true;
            }
            case 2801: {
                if (59 != current) break;
                this.match = "\ud835\udd4b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2802: {
                if (105 != current) break;
                this.state = 2803;
                return true;
            }
            case 2803: {
                if (112 != current) break;
                this.state = 2804;
                return true;
            }
            case 2804: {
                if (108 != current) break;
                this.state = 2805;
                return true;
            }
            case 2805: {
                if (101 != current) break;
                this.state = 2806;
                return true;
            }
            case 2806: {
                if (68 != current) break;
                this.state = 2807;
                return true;
            }
            case 2807: {
                if (111 != current) break;
                this.state = 2808;
                return true;
            }
            case 2808: {
                if (116 != current) break;
                this.state = 2809;
                return true;
            }
            case 2809: {
                if (59 != current) break;
                this.match = "\u20db";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2810: {
                if (99 == current) {
                    this.state = 2811;
                    return true;
                }
                if (116 != current) break;
                this.state = 2813;
                return true;
            }
            case 2811: {
                if (114 != current) break;
                this.state = 2812;
                return true;
            }
            case 2812: {
                if (59 != current) break;
                this.match = "\ud835\udcaf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2813: {
                if (114 != current) break;
                this.state = 2814;
                return true;
            }
            case 2814: {
                if (111 != current) break;
                this.state = 2815;
                return true;
            }
            case 2815: {
                if (107 != current) break;
                this.state = 2816;
                return true;
            }
            case 2816: {
                if (59 != current) break;
                this.match = "\u0166";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2817: {
                switch (current) {
                    case 97: {
                        this.state = 2818;
                        return true;
                    }
                    case 98: {
                        this.state = 2829;
                        return true;
                    }
                    case 99: {
                        this.state = 2836;
                        return true;
                    }
                    case 100: {
                        this.state = 2841;
                        return true;
                    }
                    case 102: {
                        this.state = 2846;
                        return true;
                    }
                    case 103: {
                        this.state = 2848;
                        return true;
                    }
                    case 109: {
                        this.state = 2853;
                        return true;
                    }
                    case 110: {
                        this.state = 2857;
                        return true;
                    }
                    case 111: {
                        this.state = 2889;
                        return true;
                    }
                    case 112: {
                        this.state = 2895;
                        return true;
                    }
                    case 114: {
                        this.state = 2982;
                        return true;
                    }
                    case 115: {
                        this.state = 2986;
                        return true;
                    }
                    case 116: {
                        this.state = 2989;
                        return true;
                    }
                    case 117: {
                        this.state = 2994;
                        return true;
                    }
                }
                break;
            }
            case 2818: {
                if (99 == current) {
                    this.state = 2819;
                    return true;
                }
                if (114 != current) break;
                this.state = 2823;
                return true;
            }
            case 2819: {
                if (117 != current) break;
                this.state = 2820;
                return true;
            }
            case 2820: {
                if (116 != current) break;
                this.state = 2821;
                return true;
            }
            case 2821: {
                if (101 != current) break;
                this.match = "\u00da";
                this.matchLength = this.consumedCount;
                this.state = 2822;
                return true;
            }
            case 2822: {
                if (59 != current) break;
                this.match = "\u00da";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2823: {
                if (114 != current) break;
                this.state = 2824;
                return true;
            }
            case 2824: {
                if (59 == current) {
                    this.match = "\u219f";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (111 != current) break;
                this.state = 2825;
                return true;
            }
            case 2825: {
                if (99 != current) break;
                this.state = 2826;
                return true;
            }
            case 2826: {
                if (105 != current) break;
                this.state = 2827;
                return true;
            }
            case 2827: {
                if (114 != current) break;
                this.state = 2828;
                return true;
            }
            case 2828: {
                if (59 != current) break;
                this.match = "\u2949";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2829: {
                if (114 != current) break;
                this.state = 2830;
                return true;
            }
            case 2830: {
                if (99 == current) {
                    this.state = 2831;
                    return true;
                }
                if (101 != current) break;
                this.state = 2833;
                return true;
            }
            case 2831: {
                if (121 != current) break;
                this.state = 2832;
                return true;
            }
            case 2832: {
                if (59 != current) break;
                this.match = "\u040e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2833: {
                if (118 != current) break;
                this.state = 2834;
                return true;
            }
            case 2834: {
                if (101 != current) break;
                this.state = 2835;
                return true;
            }
            case 2835: {
                if (59 != current) break;
                this.match = "\u016c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2836: {
                if (105 == current) {
                    this.state = 2837;
                    return true;
                }
                if (121 != current) break;
                this.state = 2840;
                return true;
            }
            case 2837: {
                if (114 != current) break;
                this.state = 2838;
                return true;
            }
            case 2838: {
                if (99 != current) break;
                this.match = "\u00db";
                this.matchLength = this.consumedCount;
                this.state = 2839;
                return true;
            }
            case 2839: {
                if (59 != current) break;
                this.match = "\u00db";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2840: {
                if (59 != current) break;
                this.match = "\u0423";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2841: {
                if (98 != current) break;
                this.state = 2842;
                return true;
            }
            case 2842: {
                if (108 != current) break;
                this.state = 2843;
                return true;
            }
            case 2843: {
                if (97 != current) break;
                this.state = 2844;
                return true;
            }
            case 2844: {
                if (99 != current) break;
                this.state = 2845;
                return true;
            }
            case 2845: {
                if (59 != current) break;
                this.match = "\u0170";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2846: {
                if (114 != current) break;
                this.state = 2847;
                return true;
            }
            case 2847: {
                if (59 != current) break;
                this.match = "\ud835\udd18";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2848: {
                if (114 != current) break;
                this.state = 2849;
                return true;
            }
            case 2849: {
                if (97 != current) break;
                this.state = 2850;
                return true;
            }
            case 2850: {
                if (118 != current) break;
                this.state = 2851;
                return true;
            }
            case 2851: {
                if (101 != current) break;
                this.match = "\u00d9";
                this.matchLength = this.consumedCount;
                this.state = 2852;
                return true;
            }
            case 2852: {
                if (59 != current) break;
                this.match = "\u00d9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2853: {
                if (97 != current) break;
                this.state = 2854;
                return true;
            }
            case 2854: {
                if (99 != current) break;
                this.state = 2855;
                return true;
            }
            case 2855: {
                if (114 != current) break;
                this.state = 2856;
                return true;
            }
            case 2856: {
                if (59 != current) break;
                this.match = "\u016a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2857: {
                if (100 == current) {
                    this.state = 2858;
                    return true;
                }
                if (105 != current) break;
                this.state = 2882;
                return true;
            }
            case 2858: {
                if (101 != current) break;
                this.state = 2859;
                return true;
            }
            case 2859: {
                if (114 != current) break;
                this.state = 2860;
                return true;
            }
            case 2860: {
                if (66 == current) {
                    this.state = 2861;
                    return true;
                }
                if (80 != current) break;
                this.state = 2871;
                return true;
            }
            case 2861: {
                if (97 == current) {
                    this.state = 2862;
                    return true;
                }
                if (114 != current) break;
                this.state = 2864;
                return true;
            }
            case 2862: {
                if (114 != current) break;
                this.state = 2863;
                return true;
            }
            case 2863: {
                if (59 != current) break;
                this.match = "_";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2864: {
                if (97 != current) break;
                this.state = 2865;
                return true;
            }
            case 2865: {
                if (99 != current) break;
                this.state = 2866;
                return true;
            }
            case 2866: {
                if (101 == current) {
                    this.state = 2867;
                    return true;
                }
                if (107 != current) break;
                this.state = 2868;
                return true;
            }
            case 2867: {
                if (59 != current) break;
                this.match = "\u23df";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2868: {
                if (101 != current) break;
                this.state = 2869;
                return true;
            }
            case 2869: {
                if (116 != current) break;
                this.state = 2870;
                return true;
            }
            case 2870: {
                if (59 != current) break;
                this.match = "\u23b5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2871: {
                if (97 != current) break;
                this.state = 2872;
                return true;
            }
            case 2872: {
                if (114 != current) break;
                this.state = 2873;
                return true;
            }
            case 2873: {
                if (101 != current) break;
                this.state = 2874;
                return true;
            }
            case 2874: {
                if (110 != current) break;
                this.state = 2875;
                return true;
            }
            case 2875: {
                if (116 != current) break;
                this.state = 2876;
                return true;
            }
            case 2876: {
                if (104 != current) break;
                this.state = 2877;
                return true;
            }
            case 2877: {
                if (101 != current) break;
                this.state = 2878;
                return true;
            }
            case 2878: {
                if (115 != current) break;
                this.state = 2879;
                return true;
            }
            case 2879: {
                if (105 != current) break;
                this.state = 2880;
                return true;
            }
            case 2880: {
                if (115 != current) break;
                this.state = 2881;
                return true;
            }
            case 2881: {
                if (59 != current) break;
                this.match = "\u23dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2882: {
                if (111 != current) break;
                this.state = 2883;
                return true;
            }
            case 2883: {
                if (110 != current) break;
                this.state = 2884;
                return true;
            }
            case 2884: {
                if (59 == current) {
                    this.match = "\u22c3";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (80 != current) break;
                this.state = 2885;
                return true;
            }
            case 2885: {
                if (108 != current) break;
                this.state = 2886;
                return true;
            }
            case 2886: {
                if (117 != current) break;
                this.state = 2887;
                return true;
            }
            case 2887: {
                if (115 != current) break;
                this.state = 2888;
                return true;
            }
            case 2888: {
                if (59 != current) break;
                this.match = "\u228e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2889: {
                if (103 == current) {
                    this.state = 2890;
                    return true;
                }
                if (112 != current) break;
                this.state = 2893;
                return true;
            }
            case 2890: {
                if (111 != current) break;
                this.state = 2891;
                return true;
            }
            case 2891: {
                if (110 != current) break;
                this.state = 2892;
                return true;
            }
            case 2892: {
                if (59 != current) break;
                this.match = "\u0172";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2893: {
                if (102 != current) break;
                this.state = 2894;
                return true;
            }
            case 2894: {
                if (59 != current) break;
                this.match = "\ud835\udd4c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2895: {
                switch (current) {
                    case 65: {
                        this.state = 2896;
                        return true;
                    }
                    case 68: {
                        this.state = 2913;
                        return true;
                    }
                    case 69: {
                        this.state = 2922;
                        return true;
                    }
                    case 84: {
                        this.state = 2933;
                        return true;
                    }
                    case 97: {
                        this.state = 2941;
                        return true;
                    }
                    case 100: {
                        this.state = 2946;
                        return true;
                    }
                    case 112: {
                        this.state = 2955;
                        return true;
                    }
                    case 115: {
                        this.state = 2977;
                        return true;
                    }
                }
                break;
            }
            case 2896: {
                if (114 != current) break;
                this.state = 2897;
                return true;
            }
            case 2897: {
                if (114 != current) break;
                this.state = 2898;
                return true;
            }
            case 2898: {
                if (111 != current) break;
                this.state = 2899;
                return true;
            }
            case 2899: {
                if (119 != current) break;
                this.state = 2900;
                return true;
            }
            case 2900: {
                switch (current) {
                    case 59: {
                        this.match = "\u2191";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2901;
                        return true;
                    }
                    case 68: {
                        this.state = 2904;
                        return true;
                    }
                }
                break;
            }
            case 2901: {
                if (97 != current) break;
                this.state = 2902;
                return true;
            }
            case 2902: {
                if (114 != current) break;
                this.state = 2903;
                return true;
            }
            case 2903: {
                if (59 != current) break;
                this.match = "\u2912";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2904: {
                if (111 != current) break;
                this.state = 2905;
                return true;
            }
            case 2905: {
                if (119 != current) break;
                this.state = 2906;
                return true;
            }
            case 2906: {
                if (110 != current) break;
                this.state = 2907;
                return true;
            }
            case 2907: {
                if (65 != current) break;
                this.state = 2908;
                return true;
            }
            case 2908: {
                if (114 != current) break;
                this.state = 2909;
                return true;
            }
            case 2909: {
                if (114 != current) break;
                this.state = 2910;
                return true;
            }
            case 2910: {
                if (111 != current) break;
                this.state = 2911;
                return true;
            }
            case 2911: {
                if (119 != current) break;
                this.state = 2912;
                return true;
            }
            case 2912: {
                if (59 != current) break;
                this.match = "\u21c5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2913: {
                if (111 != current) break;
                this.state = 2914;
                return true;
            }
            case 2914: {
                if (119 != current) break;
                this.state = 2915;
                return true;
            }
            case 2915: {
                if (110 != current) break;
                this.state = 2916;
                return true;
            }
            case 2916: {
                if (65 != current) break;
                this.state = 2917;
                return true;
            }
            case 2917: {
                if (114 != current) break;
                this.state = 2918;
                return true;
            }
            case 2918: {
                if (114 != current) break;
                this.state = 2919;
                return true;
            }
            case 2919: {
                if (111 != current) break;
                this.state = 2920;
                return true;
            }
            case 2920: {
                if (119 != current) break;
                this.state = 2921;
                return true;
            }
            case 2921: {
                if (59 != current) break;
                this.match = "\u2195";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2922: {
                if (113 != current) break;
                this.state = 2923;
                return true;
            }
            case 2923: {
                if (117 != current) break;
                this.state = 2924;
                return true;
            }
            case 2924: {
                if (105 != current) break;
                this.state = 2925;
                return true;
            }
            case 2925: {
                if (108 != current) break;
                this.state = 2926;
                return true;
            }
            case 2926: {
                if (105 != current) break;
                this.state = 2927;
                return true;
            }
            case 2927: {
                if (98 != current) break;
                this.state = 2928;
                return true;
            }
            case 2928: {
                if (114 != current) break;
                this.state = 2929;
                return true;
            }
            case 2929: {
                if (105 != current) break;
                this.state = 2930;
                return true;
            }
            case 2930: {
                if (117 != current) break;
                this.state = 2931;
                return true;
            }
            case 2931: {
                if (109 != current) break;
                this.state = 2932;
                return true;
            }
            case 2932: {
                if (59 != current) break;
                this.match = "\u296e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2933: {
                if (101 != current) break;
                this.state = 2934;
                return true;
            }
            case 2934: {
                if (101 != current) break;
                this.state = 2935;
                return true;
            }
            case 2935: {
                if (59 == current) {
                    this.match = "\u22a5";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (65 != current) break;
                this.state = 2936;
                return true;
            }
            case 2936: {
                if (114 != current) break;
                this.state = 2937;
                return true;
            }
            case 2937: {
                if (114 != current) break;
                this.state = 2938;
                return true;
            }
            case 2938: {
                if (111 != current) break;
                this.state = 2939;
                return true;
            }
            case 2939: {
                if (119 != current) break;
                this.state = 2940;
                return true;
            }
            case 2940: {
                if (59 != current) break;
                this.match = "\u21a5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2941: {
                if (114 != current) break;
                this.state = 2942;
                return true;
            }
            case 2942: {
                if (114 != current) break;
                this.state = 2943;
                return true;
            }
            case 2943: {
                if (111 != current) break;
                this.state = 2944;
                return true;
            }
            case 2944: {
                if (119 != current) break;
                this.state = 2945;
                return true;
            }
            case 2945: {
                if (59 != current) break;
                this.match = "\u21d1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2946: {
                if (111 != current) break;
                this.state = 2947;
                return true;
            }
            case 2947: {
                if (119 != current) break;
                this.state = 2948;
                return true;
            }
            case 2948: {
                if (110 != current) break;
                this.state = 2949;
                return true;
            }
            case 2949: {
                if (97 != current) break;
                this.state = 2950;
                return true;
            }
            case 2950: {
                if (114 != current) break;
                this.state = 2951;
                return true;
            }
            case 2951: {
                if (114 != current) break;
                this.state = 2952;
                return true;
            }
            case 2952: {
                if (111 != current) break;
                this.state = 2953;
                return true;
            }
            case 2953: {
                if (119 != current) break;
                this.state = 2954;
                return true;
            }
            case 2954: {
                if (59 != current) break;
                this.match = "\u21d5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2955: {
                if (101 != current) break;
                this.state = 2956;
                return true;
            }
            case 2956: {
                if (114 != current) break;
                this.state = 2957;
                return true;
            }
            case 2957: {
                if (76 == current) {
                    this.state = 2958;
                    return true;
                }
                if (82 != current) break;
                this.state = 2967;
                return true;
            }
            case 2958: {
                if (101 != current) break;
                this.state = 2959;
                return true;
            }
            case 2959: {
                if (102 != current) break;
                this.state = 2960;
                return true;
            }
            case 2960: {
                if (116 != current) break;
                this.state = 2961;
                return true;
            }
            case 2961: {
                if (65 != current) break;
                this.state = 2962;
                return true;
            }
            case 2962: {
                if (114 != current) break;
                this.state = 2963;
                return true;
            }
            case 2963: {
                if (114 != current) break;
                this.state = 2964;
                return true;
            }
            case 2964: {
                if (111 != current) break;
                this.state = 2965;
                return true;
            }
            case 2965: {
                if (119 != current) break;
                this.state = 2966;
                return true;
            }
            case 2966: {
                if (59 != current) break;
                this.match = "\u2196";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2967: {
                if (105 != current) break;
                this.state = 2968;
                return true;
            }
            case 2968: {
                if (103 != current) break;
                this.state = 2969;
                return true;
            }
            case 2969: {
                if (104 != current) break;
                this.state = 2970;
                return true;
            }
            case 2970: {
                if (116 != current) break;
                this.state = 2971;
                return true;
            }
            case 2971: {
                if (65 != current) break;
                this.state = 2972;
                return true;
            }
            case 2972: {
                if (114 != current) break;
                this.state = 2973;
                return true;
            }
            case 2973: {
                if (114 != current) break;
                this.state = 2974;
                return true;
            }
            case 2974: {
                if (111 != current) break;
                this.state = 2975;
                return true;
            }
            case 2975: {
                if (119 != current) break;
                this.state = 2976;
                return true;
            }
            case 2976: {
                if (59 != current) break;
                this.match = "\u2197";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2977: {
                if (105 != current) break;
                this.state = 2978;
                return true;
            }
            case 2978: {
                if (59 == current) {
                    this.match = "\u03d2";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (108 != current) break;
                this.state = 2979;
                return true;
            }
            case 2979: {
                if (111 != current) break;
                this.state = 2980;
                return true;
            }
            case 2980: {
                if (110 != current) break;
                this.state = 2981;
                return true;
            }
            case 2981: {
                if (59 != current) break;
                this.match = "\u03a5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2982: {
                if (105 != current) break;
                this.state = 2983;
                return true;
            }
            case 2983: {
                if (110 != current) break;
                this.state = 2984;
                return true;
            }
            case 2984: {
                if (103 != current) break;
                this.state = 2985;
                return true;
            }
            case 2985: {
                if (59 != current) break;
                this.match = "\u016e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2986: {
                if (99 != current) break;
                this.state = 2987;
                return true;
            }
            case 2987: {
                if (114 != current) break;
                this.state = 2988;
                return true;
            }
            case 2988: {
                if (59 != current) break;
                this.match = "\ud835\udcb0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2989: {
                if (105 != current) break;
                this.state = 2990;
                return true;
            }
            case 2990: {
                if (108 != current) break;
                this.state = 2991;
                return true;
            }
            case 2991: {
                if (100 != current) break;
                this.state = 2992;
                return true;
            }
            case 2992: {
                if (101 != current) break;
                this.state = 2993;
                return true;
            }
            case 2993: {
                if (59 != current) break;
                this.match = "\u0168";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2994: {
                if (109 != current) break;
                this.state = 2995;
                return true;
            }
            case 2995: {
                if (108 != current) break;
                this.match = "\u00dc";
                this.matchLength = this.consumedCount;
                this.state = 2996;
                return true;
            }
            case 2996: {
                if (59 != current) break;
                this.match = "\u00dc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 2997: {
                switch (current) {
                    case 68: {
                        this.state = 2998;
                        return true;
                    }
                    case 98: {
                        this.state = 3002;
                        return true;
                    }
                    case 99: {
                        this.state = 3005;
                        return true;
                    }
                    case 100: {
                        this.state = 3007;
                        return true;
                    }
                    case 101: {
                        this.state = 3012;
                        return true;
                    }
                    case 102: {
                        this.state = 3054;
                        return true;
                    }
                    case 111: {
                        this.state = 3056;
                        return true;
                    }
                    case 115: {
                        this.state = 3059;
                        return true;
                    }
                    case 118: {
                        this.state = 3062;
                        return true;
                    }
                }
                break;
            }
            case 2998: {
                if (97 != current) break;
                this.state = 2999;
                return true;
            }
            case 2999: {
                if (115 != current) break;
                this.state = 3000;
                return true;
            }
        }
        return false;
    }

    private boolean parse4(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 3000: {
                if (104 != current) break;
                this.state = 3001;
                return true;
            }
            case 3001: {
                if (59 != current) break;
                this.match = "\u22ab";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3002: {
                if (97 != current) break;
                this.state = 3003;
                return true;
            }
            case 3003: {
                if (114 != current) break;
                this.state = 3004;
                return true;
            }
            case 3004: {
                if (59 != current) break;
                this.match = "\u2aeb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3005: {
                if (121 != current) break;
                this.state = 3006;
                return true;
            }
            case 3006: {
                if (59 != current) break;
                this.match = "\u0412";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3007: {
                if (97 != current) break;
                this.state = 3008;
                return true;
            }
            case 3008: {
                if (115 != current) break;
                this.state = 3009;
                return true;
            }
            case 3009: {
                if (104 != current) break;
                this.state = 3010;
                return true;
            }
            case 3010: {
                if (59 == current) {
                    this.match = "\u22a9";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (108 != current) break;
                this.state = 3011;
                return true;
            }
            case 3011: {
                if (59 != current) break;
                this.match = "\u2ae6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3012: {
                if (101 == current) {
                    this.state = 3013;
                    return true;
                }
                if (114 != current) break;
                this.state = 3014;
                return true;
            }
            case 3013: {
                if (59 != current) break;
                this.match = "\u22c1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3014: {
                switch (current) {
                    case 98: {
                        this.state = 3015;
                        return true;
                    }
                    case 116: {
                        this.state = 3018;
                        return true;
                    }
                    case 121: {
                        this.state = 3044;
                        return true;
                    }
                }
                break;
            }
            case 3015: {
                if (97 != current) break;
                this.state = 3016;
                return true;
            }
            case 3016: {
                if (114 != current) break;
                this.state = 3017;
                return true;
            }
            case 3017: {
                if (59 != current) break;
                this.match = "\u2016";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3018: {
                if (59 == current) {
                    this.match = "\u2016";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (105 != current) break;
                this.state = 3019;
                return true;
            }
            case 3019: {
                if (99 != current) break;
                this.state = 3020;
                return true;
            }
            case 3020: {
                if (97 != current) break;
                this.state = 3021;
                return true;
            }
            case 3021: {
                if (108 != current) break;
                this.state = 3022;
                return true;
            }
            case 3022: {
                switch (current) {
                    case 66: {
                        this.state = 3023;
                        return true;
                    }
                    case 76: {
                        this.state = 3026;
                        return true;
                    }
                    case 83: {
                        this.state = 3030;
                        return true;
                    }
                    case 84: {
                        this.state = 3039;
                        return true;
                    }
                }
                break;
            }
            case 3023: {
                if (97 != current) break;
                this.state = 3024;
                return true;
            }
            case 3024: {
                if (114 != current) break;
                this.state = 3025;
                return true;
            }
            case 3025: {
                if (59 != current) break;
                this.match = "\u2223";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3026: {
                if (105 != current) break;
                this.state = 3027;
                return true;
            }
            case 3027: {
                if (110 != current) break;
                this.state = 3028;
                return true;
            }
            case 3028: {
                if (101 != current) break;
                this.state = 3029;
                return true;
            }
            case 3029: {
                if (59 != current) break;
                this.match = "|";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3030: {
                if (101 != current) break;
                this.state = 3031;
                return true;
            }
            case 3031: {
                if (112 != current) break;
                this.state = 3032;
                return true;
            }
            case 3032: {
                if (97 != current) break;
                this.state = 3033;
                return true;
            }
            case 3033: {
                if (114 != current) break;
                this.state = 3034;
                return true;
            }
            case 3034: {
                if (97 != current) break;
                this.state = 3035;
                return true;
            }
            case 3035: {
                if (116 != current) break;
                this.state = 3036;
                return true;
            }
            case 3036: {
                if (111 != current) break;
                this.state = 3037;
                return true;
            }
            case 3037: {
                if (114 != current) break;
                this.state = 3038;
                return true;
            }
            case 3038: {
                if (59 != current) break;
                this.match = "\u2758";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3039: {
                if (105 != current) break;
                this.state = 3040;
                return true;
            }
            case 3040: {
                if (108 != current) break;
                this.state = 3041;
                return true;
            }
            case 3041: {
                if (100 != current) break;
                this.state = 3042;
                return true;
            }
            case 3042: {
                if (101 != current) break;
                this.state = 3043;
                return true;
            }
            case 3043: {
                if (59 != current) break;
                this.match = "\u2240";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3044: {
                if (84 != current) break;
                this.state = 3045;
                return true;
            }
            case 3045: {
                if (104 != current) break;
                this.state = 3046;
                return true;
            }
            case 3046: {
                if (105 != current) break;
                this.state = 3047;
                return true;
            }
            case 3047: {
                if (110 != current) break;
                this.state = 3048;
                return true;
            }
            case 3048: {
                if (83 != current) break;
                this.state = 3049;
                return true;
            }
            case 3049: {
                if (112 != current) break;
                this.state = 3050;
                return true;
            }
            case 3050: {
                if (97 != current) break;
                this.state = 3051;
                return true;
            }
            case 3051: {
                if (99 != current) break;
                this.state = 3052;
                return true;
            }
            case 3052: {
                if (101 != current) break;
                this.state = 3053;
                return true;
            }
            case 3053: {
                if (59 != current) break;
                this.match = "\u200a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3054: {
                if (114 != current) break;
                this.state = 3055;
                return true;
            }
            case 3055: {
                if (59 != current) break;
                this.match = "\ud835\udd19";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3056: {
                if (112 != current) break;
                this.state = 3057;
                return true;
            }
            case 3057: {
                if (102 != current) break;
                this.state = 3058;
                return true;
            }
            case 3058: {
                if (59 != current) break;
                this.match = "\ud835\udd4d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3059: {
                if (99 != current) break;
                this.state = 3060;
                return true;
            }
            case 3060: {
                if (114 != current) break;
                this.state = 3061;
                return true;
            }
            case 3061: {
                if (59 != current) break;
                this.match = "\ud835\udcb1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3062: {
                if (100 != current) break;
                this.state = 3063;
                return true;
            }
            case 3063: {
                if (97 != current) break;
                this.state = 3064;
                return true;
            }
            case 3064: {
                if (115 != current) break;
                this.state = 3065;
                return true;
            }
            case 3065: {
                if (104 != current) break;
                this.state = 3066;
                return true;
            }
            case 3066: {
                if (59 != current) break;
                this.match = "\u22aa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3067: {
                switch (current) {
                    case 99: {
                        this.state = 3068;
                        return true;
                    }
                    case 101: {
                        this.state = 3072;
                        return true;
                    }
                    case 102: {
                        this.state = 3076;
                        return true;
                    }
                    case 111: {
                        this.state = 3078;
                        return true;
                    }
                    case 115: {
                        this.state = 3081;
                        return true;
                    }
                }
                break;
            }
            case 3068: {
                if (105 != current) break;
                this.state = 3069;
                return true;
            }
            case 3069: {
                if (114 != current) break;
                this.state = 3070;
                return true;
            }
            case 3070: {
                if (99 != current) break;
                this.state = 3071;
                return true;
            }
            case 3071: {
                if (59 != current) break;
                this.match = "\u0174";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3072: {
                if (100 != current) break;
                this.state = 3073;
                return true;
            }
            case 3073: {
                if (103 != current) break;
                this.state = 3074;
                return true;
            }
            case 3074: {
                if (101 != current) break;
                this.state = 3075;
                return true;
            }
            case 3075: {
                if (59 != current) break;
                this.match = "\u22c0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3076: {
                if (114 != current) break;
                this.state = 3077;
                return true;
            }
            case 3077: {
                if (59 != current) break;
                this.match = "\ud835\udd1a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3078: {
                if (112 != current) break;
                this.state = 3079;
                return true;
            }
            case 3079: {
                if (102 != current) break;
                this.state = 3080;
                return true;
            }
            case 3080: {
                if (59 != current) break;
                this.match = "\ud835\udd4e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3081: {
                if (99 != current) break;
                this.state = 3082;
                return true;
            }
            case 3082: {
                if (114 != current) break;
                this.state = 3083;
                return true;
            }
            case 3083: {
                if (59 != current) break;
                this.match = "\ud835\udcb2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3084: {
                switch (current) {
                    case 102: {
                        this.state = 3085;
                        return true;
                    }
                    case 105: {
                        this.state = 3087;
                        return true;
                    }
                    case 111: {
                        this.state = 3088;
                        return true;
                    }
                    case 115: {
                        this.state = 3091;
                        return true;
                    }
                }
                break;
            }
            case 3085: {
                if (114 != current) break;
                this.state = 3086;
                return true;
            }
            case 3086: {
                if (59 != current) break;
                this.match = "\ud835\udd1b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3087: {
                if (59 != current) break;
                this.match = "\u039e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3088: {
                if (112 != current) break;
                this.state = 3089;
                return true;
            }
            case 3089: {
                if (102 != current) break;
                this.state = 3090;
                return true;
            }
            case 3090: {
                if (59 != current) break;
                this.match = "\ud835\udd4f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3091: {
                if (99 != current) break;
                this.state = 3092;
                return true;
            }
            case 3092: {
                if (114 != current) break;
                this.state = 3093;
                return true;
            }
            case 3093: {
                if (59 != current) break;
                this.match = "\ud835\udcb3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3094: {
                switch (current) {
                    case 65: {
                        this.state = 3095;
                        return true;
                    }
                    case 73: {
                        this.state = 3098;
                        return true;
                    }
                    case 85: {
                        this.state = 3101;
                        return true;
                    }
                    case 97: {
                        this.state = 3104;
                        return true;
                    }
                    case 99: {
                        this.state = 3109;
                        return true;
                    }
                    case 102: {
                        this.state = 3114;
                        return true;
                    }
                    case 111: {
                        this.state = 3116;
                        return true;
                    }
                    case 115: {
                        this.state = 3119;
                        return true;
                    }
                    case 117: {
                        this.state = 3122;
                        return true;
                    }
                }
                break;
            }
            case 3095: {
                if (99 != current) break;
                this.state = 3096;
                return true;
            }
            case 3096: {
                if (121 != current) break;
                this.state = 3097;
                return true;
            }
            case 3097: {
                if (59 != current) break;
                this.match = "\u042f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3098: {
                if (99 != current) break;
                this.state = 3099;
                return true;
            }
            case 3099: {
                if (121 != current) break;
                this.state = 3100;
                return true;
            }
            case 3100: {
                if (59 != current) break;
                this.match = "\u0407";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3101: {
                if (99 != current) break;
                this.state = 3102;
                return true;
            }
            case 3102: {
                if (121 != current) break;
                this.state = 3103;
                return true;
            }
            case 3103: {
                if (59 != current) break;
                this.match = "\u042e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3104: {
                if (99 != current) break;
                this.state = 3105;
                return true;
            }
            case 3105: {
                if (117 != current) break;
                this.state = 3106;
                return true;
            }
            case 3106: {
                if (116 != current) break;
                this.state = 3107;
                return true;
            }
            case 3107: {
                if (101 != current) break;
                this.match = "\u00dd";
                this.matchLength = this.consumedCount;
                this.state = 3108;
                return true;
            }
            case 3108: {
                if (59 != current) break;
                this.match = "\u00dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3109: {
                if (105 == current) {
                    this.state = 3110;
                    return true;
                }
                if (121 != current) break;
                this.state = 3113;
                return true;
            }
            case 3110: {
                if (114 != current) break;
                this.state = 3111;
                return true;
            }
            case 3111: {
                if (99 != current) break;
                this.state = 3112;
                return true;
            }
            case 3112: {
                if (59 != current) break;
                this.match = "\u0176";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3113: {
                if (59 != current) break;
                this.match = "\u042b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3114: {
                if (114 != current) break;
                this.state = 3115;
                return true;
            }
            case 3115: {
                if (59 != current) break;
                this.match = "\ud835\udd1c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3116: {
                if (112 != current) break;
                this.state = 3117;
                return true;
            }
            case 3117: {
                if (102 != current) break;
                this.state = 3118;
                return true;
            }
            case 3118: {
                if (59 != current) break;
                this.match = "\ud835\udd50";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3119: {
                if (99 != current) break;
                this.state = 3120;
                return true;
            }
            case 3120: {
                if (114 != current) break;
                this.state = 3121;
                return true;
            }
            case 3121: {
                if (59 != current) break;
                this.match = "\ud835\udcb4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3122: {
                if (109 != current) break;
                this.state = 3123;
                return true;
            }
            case 3123: {
                if (108 != current) break;
                this.state = 3124;
                return true;
            }
            case 3124: {
                if (59 != current) break;
                this.match = "\u0178";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3125: {
                switch (current) {
                    case 72: {
                        this.state = 3126;
                        return true;
                    }
                    case 97: {
                        this.state = 3129;
                        return true;
                    }
                    case 99: {
                        this.state = 3134;
                        return true;
                    }
                    case 100: {
                        this.state = 3140;
                        return true;
                    }
                    case 101: {
                        this.state = 3143;
                        return true;
                    }
                    case 102: {
                        this.state = 3158;
                        return true;
                    }
                    case 111: {
                        this.state = 3160;
                        return true;
                    }
                    case 115: {
                        this.state = 3163;
                        return true;
                    }
                }
                break;
            }
            case 3126: {
                if (99 != current) break;
                this.state = 3127;
                return true;
            }
            case 3127: {
                if (121 != current) break;
                this.state = 3128;
                return true;
            }
            case 3128: {
                if (59 != current) break;
                this.match = "\u0416";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3129: {
                if (99 != current) break;
                this.state = 3130;
                return true;
            }
            case 3130: {
                if (117 != current) break;
                this.state = 3131;
                return true;
            }
            case 3131: {
                if (116 != current) break;
                this.state = 3132;
                return true;
            }
            case 3132: {
                if (101 != current) break;
                this.state = 3133;
                return true;
            }
            case 3133: {
                if (59 != current) break;
                this.match = "\u0179";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3134: {
                if (97 == current) {
                    this.state = 3135;
                    return true;
                }
                if (121 != current) break;
                this.state = 3139;
                return true;
            }
            case 3135: {
                if (114 != current) break;
                this.state = 3136;
                return true;
            }
            case 3136: {
                if (111 != current) break;
                this.state = 3137;
                return true;
            }
            case 3137: {
                if (110 != current) break;
                this.state = 3138;
                return true;
            }
            case 3138: {
                if (59 != current) break;
                this.match = "\u017d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3139: {
                if (59 != current) break;
                this.match = "\u0417";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3140: {
                if (111 != current) break;
                this.state = 3141;
                return true;
            }
            case 3141: {
                if (116 != current) break;
                this.state = 3142;
                return true;
            }
            case 3142: {
                if (59 != current) break;
                this.match = "\u017b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3143: {
                if (114 == current) {
                    this.state = 3144;
                    return true;
                }
                if (116 != current) break;
                this.state = 3156;
                return true;
            }
            case 3144: {
                if (111 != current) break;
                this.state = 3145;
                return true;
            }
            case 3145: {
                if (87 != current) break;
                this.state = 3146;
                return true;
            }
            case 3146: {
                if (105 != current) break;
                this.state = 3147;
                return true;
            }
            case 3147: {
                if (100 != current) break;
                this.state = 3148;
                return true;
            }
            case 3148: {
                if (116 != current) break;
                this.state = 3149;
                return true;
            }
            case 3149: {
                if (104 != current) break;
                this.state = 3150;
                return true;
            }
            case 3150: {
                if (83 != current) break;
                this.state = 3151;
                return true;
            }
            case 3151: {
                if (112 != current) break;
                this.state = 3152;
                return true;
            }
            case 3152: {
                if (97 != current) break;
                this.state = 3153;
                return true;
            }
            case 3153: {
                if (99 != current) break;
                this.state = 3154;
                return true;
            }
            case 3154: {
                if (101 != current) break;
                this.state = 3155;
                return true;
            }
            case 3155: {
                if (59 != current) break;
                this.match = "\u200b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3156: {
                if (97 != current) break;
                this.state = 3157;
                return true;
            }
            case 3157: {
                if (59 != current) break;
                this.match = "\u0396";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3158: {
                if (114 != current) break;
                this.state = 3159;
                return true;
            }
            case 3159: {
                if (59 != current) break;
                this.match = "\u2128";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3160: {
                if (112 != current) break;
                this.state = 3161;
                return true;
            }
            case 3161: {
                if (102 != current) break;
                this.state = 3162;
                return true;
            }
            case 3162: {
                if (59 != current) break;
                this.match = "\u2124";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3163: {
                if (99 != current) break;
                this.state = 3164;
                return true;
            }
            case 3164: {
                if (114 != current) break;
                this.state = 3165;
                return true;
            }
            case 3165: {
                if (59 != current) break;
                this.match = "\ud835\udcb5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3166: {
                switch (current) {
                    case 97: {
                        this.state = 3167;
                        return true;
                    }
                    case 98: {
                        this.state = 3172;
                        return true;
                    }
                    case 99: {
                        this.state = 3177;
                        return true;
                    }
                    case 101: {
                        this.state = 3187;
                        return true;
                    }
                    case 102: {
                        this.state = 3191;
                        return true;
                    }
                    case 103: {
                        this.state = 3193;
                        return true;
                    }
                    case 108: {
                        this.state = 3198;
                        return true;
                    }
                    case 109: {
                        this.state = 3209;
                        return true;
                    }
                    case 110: {
                        this.state = 3216;
                        return true;
                    }
                    case 111: {
                        this.state = 3257;
                        return true;
                    }
                    case 112: {
                        this.state = 3263;
                        return true;
                    }
                    case 114: {
                        this.state = 3280;
                        return true;
                    }
                    case 115: {
                        this.state = 3284;
                        return true;
                    }
                    case 116: {
                        this.state = 3293;
                        return true;
                    }
                    case 117: {
                        this.state = 3298;
                        return true;
                    }
                    case 119: {
                        this.state = 3301;
                        return true;
                    }
                }
                break;
            }
            case 3167: {
                if (99 != current) break;
                this.state = 3168;
                return true;
            }
            case 3168: {
                if (117 != current) break;
                this.state = 3169;
                return true;
            }
            case 3169: {
                if (116 != current) break;
                this.state = 3170;
                return true;
            }
            case 3170: {
                if (101 != current) break;
                this.match = "\u00e1";
                this.matchLength = this.consumedCount;
                this.state = 3171;
                return true;
            }
            case 3171: {
                if (59 != current) break;
                this.match = "\u00e1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3172: {
                if (114 != current) break;
                this.state = 3173;
                return true;
            }
            case 3173: {
                if (101 != current) break;
                this.state = 3174;
                return true;
            }
            case 3174: {
                if (118 != current) break;
                this.state = 3175;
                return true;
            }
            case 3175: {
                if (101 != current) break;
                this.state = 3176;
                return true;
            }
            case 3176: {
                if (59 != current) break;
                this.match = "\u0103";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3177: {
                switch (current) {
                    case 59: {
                        this.match = "\u223e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 3178;
                        return true;
                    }
                    case 100: {
                        this.state = 3179;
                        return true;
                    }
                    case 105: {
                        this.state = 3180;
                        return true;
                    }
                    case 117: {
                        this.state = 3183;
                        return true;
                    }
                    case 121: {
                        this.state = 3186;
                        return true;
                    }
                }
                break;
            }
            case 3178: {
                if (59 != current) break;
                this.match = "\u223e\u0333";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3179: {
                if (59 != current) break;
                this.match = "\u223f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3180: {
                if (114 != current) break;
                this.state = 3181;
                return true;
            }
            case 3181: {
                if (99 != current) break;
                this.match = "\u00e2";
                this.matchLength = this.consumedCount;
                this.state = 3182;
                return true;
            }
            case 3182: {
                if (59 != current) break;
                this.match = "\u00e2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3183: {
                if (116 != current) break;
                this.state = 3184;
                return true;
            }
            case 3184: {
                if (101 != current) break;
                this.match = "\u00b4";
                this.matchLength = this.consumedCount;
                this.state = 3185;
                return true;
            }
            case 3185: {
                if (59 != current) break;
                this.match = "\u00b4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3186: {
                if (59 != current) break;
                this.match = "\u0430";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3187: {
                if (108 != current) break;
                this.state = 3188;
                return true;
            }
            case 3188: {
                if (105 != current) break;
                this.state = 3189;
                return true;
            }
            case 3189: {
                if (103 != current) break;
                this.match = "\u00e6";
                this.matchLength = this.consumedCount;
                this.state = 3190;
                return true;
            }
            case 3190: {
                if (59 != current) break;
                this.match = "\u00e6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3191: {
                if (59 == current) {
                    this.match = "\u2061";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (114 != current) break;
                this.state = 3192;
                return true;
            }
            case 3192: {
                if (59 != current) break;
                this.match = "\ud835\udd1e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3193: {
                if (114 != current) break;
                this.state = 3194;
                return true;
            }
            case 3194: {
                if (97 != current) break;
                this.state = 3195;
                return true;
            }
            case 3195: {
                if (118 != current) break;
                this.state = 3196;
                return true;
            }
            case 3196: {
                if (101 != current) break;
                this.match = "\u00e0";
                this.matchLength = this.consumedCount;
                this.state = 3197;
                return true;
            }
            case 3197: {
                if (59 != current) break;
                this.match = "\u00e0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3198: {
                if (101 == current) {
                    this.state = 3199;
                    return true;
                }
                if (112 != current) break;
                this.state = 3206;
                return true;
            }
            case 3199: {
                if (102 == current) {
                    this.state = 3200;
                    return true;
                }
                if (112 != current) break;
                this.state = 3204;
                return true;
            }
            case 3200: {
                if (115 != current) break;
                this.state = 3201;
                return true;
            }
            case 3201: {
                if (121 != current) break;
                this.state = 3202;
                return true;
            }
            case 3202: {
                if (109 != current) break;
                this.state = 3203;
                return true;
            }
            case 3203: {
                if (59 != current) break;
                this.match = "\u2135";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3204: {
                if (104 != current) break;
                this.state = 3205;
                return true;
            }
            case 3205: {
                if (59 != current) break;
                this.match = "\u2135";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3206: {
                if (104 != current) break;
                this.state = 3207;
                return true;
            }
            case 3207: {
                if (97 != current) break;
                this.state = 3208;
                return true;
            }
            case 3208: {
                if (59 != current) break;
                this.match = "\u03b1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3209: {
                if (97 == current) {
                    this.state = 3210;
                    return true;
                }
                if (112 != current) break;
                this.match = "&";
                this.matchLength = this.consumedCount;
                this.state = 3215;
                return true;
            }
            case 3210: {
                if (99 == current) {
                    this.state = 3211;
                    return true;
                }
                if (108 != current) break;
                this.state = 3213;
                return true;
            }
            case 3211: {
                if (114 != current) break;
                this.state = 3212;
                return true;
            }
            case 3212: {
                if (59 != current) break;
                this.match = "\u0101";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3213: {
                if (103 != current) break;
                this.state = 3214;
                return true;
            }
            case 3214: {
                if (59 != current) break;
                this.match = "\u2a3f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3215: {
                if (59 != current) break;
                this.match = "&";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3216: {
                if (100 == current) {
                    this.state = 3217;
                    return true;
                }
                if (103 != current) break;
                this.state = 3228;
                return true;
            }
            case 3217: {
                switch (current) {
                    case 59: {
                        this.match = "\u2227";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 3218;
                        return true;
                    }
                    case 100: {
                        this.state = 3221;
                        return true;
                    }
                    case 115: {
                        this.state = 3222;
                        return true;
                    }
                    case 118: {
                        this.state = 3227;
                        return true;
                    }
                }
                break;
            }
            case 3218: {
                if (110 != current) break;
                this.state = 3219;
                return true;
            }
            case 3219: {
                if (100 != current) break;
                this.state = 3220;
                return true;
            }
            case 3220: {
                if (59 != current) break;
                this.match = "\u2a55";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3221: {
                if (59 != current) break;
                this.match = "\u2a5c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3222: {
                if (108 != current) break;
                this.state = 3223;
                return true;
            }
            case 3223: {
                if (111 != current) break;
                this.state = 3224;
                return true;
            }
            case 3224: {
                if (112 != current) break;
                this.state = 3225;
                return true;
            }
            case 3225: {
                if (101 != current) break;
                this.state = 3226;
                return true;
            }
            case 3226: {
                if (59 != current) break;
                this.match = "\u2a58";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3227: {
                if (59 != current) break;
                this.match = "\u2a5a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3228: {
                switch (current) {
                    case 59: {
                        this.match = "\u2220";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 3229;
                        return true;
                    }
                    case 108: {
                        this.state = 3230;
                        return true;
                    }
                    case 109: {
                        this.state = 3232;
                        return true;
                    }
                    case 114: {
                        this.state = 3244;
                        return true;
                    }
                    case 115: {
                        this.state = 3249;
                        return true;
                    }
                    case 122: {
                        this.state = 3253;
                        return true;
                    }
                }
                break;
            }
            case 3229: {
                if (59 != current) break;
                this.match = "\u29a4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3230: {
                if (101 != current) break;
                this.state = 3231;
                return true;
            }
            case 3231: {
                if (59 != current) break;
                this.match = "\u2220";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3232: {
                if (115 != current) break;
                this.state = 3233;
                return true;
            }
            case 3233: {
                if (100 != current) break;
                this.state = 3234;
                return true;
            }
            case 3234: {
                if (59 == current) {
                    this.match = "\u2221";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (97 != current) break;
                this.state = 3235;
                return true;
            }
            case 3235: {
                switch (current) {
                    case 97: {
                        this.state = 3236;
                        return true;
                    }
                    case 98: {
                        this.state = 3237;
                        return true;
                    }
                    case 99: {
                        this.state = 3238;
                        return true;
                    }
                    case 100: {
                        this.state = 3239;
                        return true;
                    }
                    case 101: {
                        this.state = 3240;
                        return true;
                    }
                    case 102: {
                        this.state = 3241;
                        return true;
                    }
                    case 103: {
                        this.state = 3242;
                        return true;
                    }
                    case 104: {
                        this.state = 3243;
                        return true;
                    }
                }
                break;
            }
            case 3236: {
                if (59 != current) break;
                this.match = "\u29a8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3237: {
                if (59 != current) break;
                this.match = "\u29a9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3238: {
                if (59 != current) break;
                this.match = "\u29aa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3239: {
                if (59 != current) break;
                this.match = "\u29ab";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3240: {
                if (59 != current) break;
                this.match = "\u29ac";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3241: {
                if (59 != current) break;
                this.match = "\u29ad";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3242: {
                if (59 != current) break;
                this.match = "\u29ae";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3243: {
                if (59 != current) break;
                this.match = "\u29af";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3244: {
                if (116 != current) break;
                this.state = 3245;
                return true;
            }
            case 3245: {
                if (59 == current) {
                    this.match = "\u221f";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (118 != current) break;
                this.state = 3246;
                return true;
            }
            case 3246: {
                if (98 != current) break;
                this.state = 3247;
                return true;
            }
            case 3247: {
                if (59 == current) {
                    this.match = "\u22be";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 3248;
                return true;
            }
            case 3248: {
                if (59 != current) break;
                this.match = "\u299d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3249: {
                if (112 == current) {
                    this.state = 3250;
                    return true;
                }
                if (116 != current) break;
                this.state = 3252;
                return true;
            }
            case 3250: {
                if (104 != current) break;
                this.state = 3251;
                return true;
            }
            case 3251: {
                if (59 != current) break;
                this.match = "\u2222";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3252: {
                if (59 != current) break;
                this.match = "\u00c5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3253: {
                if (97 != current) break;
                this.state = 3254;
                return true;
            }
            case 3254: {
                if (114 != current) break;
                this.state = 3255;
                return true;
            }
            case 3255: {
                if (114 != current) break;
                this.state = 3256;
                return true;
            }
            case 3256: {
                if (59 != current) break;
                this.match = "\u237c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3257: {
                if (103 == current) {
                    this.state = 3258;
                    return true;
                }
                if (112 != current) break;
                this.state = 3261;
                return true;
            }
            case 3258: {
                if (111 != current) break;
                this.state = 3259;
                return true;
            }
            case 3259: {
                if (110 != current) break;
                this.state = 3260;
                return true;
            }
            case 3260: {
                if (59 != current) break;
                this.match = "\u0105";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3261: {
                if (102 != current) break;
                this.state = 3262;
                return true;
            }
            case 3262: {
                if (59 != current) break;
                this.match = "\ud835\udd52";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3263: {
                switch (current) {
                    case 59: {
                        this.match = "\u2248";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 3264;
                        return true;
                    }
                    case 97: {
                        this.state = 3265;
                        return true;
                    }
                    case 101: {
                        this.state = 3269;
                        return true;
                    }
                    case 105: {
                        this.state = 3270;
                        return true;
                    }
                    case 111: {
                        this.state = 3272;
                        return true;
                    }
                    case 112: {
                        this.state = 3274;
                        return true;
                    }
                }
                break;
            }
            case 3264: {
                if (59 != current) break;
                this.match = "\u2a70";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3265: {
                if (99 != current) break;
                this.state = 3266;
                return true;
            }
            case 3266: {
                if (105 != current) break;
                this.state = 3267;
                return true;
            }
            case 3267: {
                if (114 != current) break;
                this.state = 3268;
                return true;
            }
            case 3268: {
                if (59 != current) break;
                this.match = "\u2a6f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3269: {
                if (59 != current) break;
                this.match = "\u224a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3270: {
                if (100 != current) break;
                this.state = 3271;
                return true;
            }
            case 3271: {
                if (59 != current) break;
                this.match = "\u224b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3272: {
                if (115 != current) break;
                this.state = 3273;
                return true;
            }
            case 3273: {
                if (59 != current) break;
                this.match = "'";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3274: {
                if (114 != current) break;
                this.state = 3275;
                return true;
            }
            case 3275: {
                if (111 != current) break;
                this.state = 3276;
                return true;
            }
            case 3276: {
                if (120 != current) break;
                this.state = 3277;
                return true;
            }
            case 3277: {
                if (59 == current) {
                    this.match = "\u2248";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3278;
                return true;
            }
            case 3278: {
                if (113 != current) break;
                this.state = 3279;
                return true;
            }
            case 3279: {
                if (59 != current) break;
                this.match = "\u224a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3280: {
                if (105 != current) break;
                this.state = 3281;
                return true;
            }
            case 3281: {
                if (110 != current) break;
                this.state = 3282;
                return true;
            }
            case 3282: {
                if (103 != current) break;
                this.match = "\u00e5";
                this.matchLength = this.consumedCount;
                this.state = 3283;
                return true;
            }
            case 3283: {
                if (59 != current) break;
                this.match = "\u00e5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3284: {
                switch (current) {
                    case 99: {
                        this.state = 3285;
                        return true;
                    }
                    case 116: {
                        this.state = 3287;
                        return true;
                    }
                    case 121: {
                        this.state = 3288;
                        return true;
                    }
                }
                break;
            }
            case 3285: {
                if (114 != current) break;
                this.state = 3286;
                return true;
            }
            case 3286: {
                if (59 != current) break;
                this.match = "\ud835\udcb6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3287: {
                if (59 != current) break;
                this.match = "*";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3288: {
                if (109 != current) break;
                this.state = 3289;
                return true;
            }
            case 3289: {
                if (112 != current) break;
                this.state = 3290;
                return true;
            }
            case 3290: {
                if (59 == current) {
                    this.match = "\u2248";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3291;
                return true;
            }
            case 3291: {
                if (113 != current) break;
                this.state = 3292;
                return true;
            }
            case 3292: {
                if (59 != current) break;
                this.match = "\u224d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3293: {
                if (105 != current) break;
                this.state = 3294;
                return true;
            }
            case 3294: {
                if (108 != current) break;
                this.state = 3295;
                return true;
            }
            case 3295: {
                if (100 != current) break;
                this.state = 3296;
                return true;
            }
            case 3296: {
                if (101 != current) break;
                this.match = "\u00e3";
                this.matchLength = this.consumedCount;
                this.state = 3297;
                return true;
            }
            case 3297: {
                if (59 != current) break;
                this.match = "\u00e3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3298: {
                if (109 != current) break;
                this.state = 3299;
                return true;
            }
            case 3299: {
                if (108 != current) break;
                this.match = "\u00e4";
                this.matchLength = this.consumedCount;
                this.state = 3300;
                return true;
            }
            case 3300: {
                if (59 != current) break;
                this.match = "\u00e4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3301: {
                if (99 == current) {
                    this.state = 3302;
                    return true;
                }
                if (105 != current) break;
                this.state = 3308;
                return true;
            }
            case 3302: {
                if (111 != current) break;
                this.state = 3303;
                return true;
            }
            case 3303: {
                if (110 != current) break;
                this.state = 3304;
                return true;
            }
            case 3304: {
                if (105 != current) break;
                this.state = 3305;
                return true;
            }
            case 3305: {
                if (110 != current) break;
                this.state = 3306;
                return true;
            }
            case 3306: {
                if (116 != current) break;
                this.state = 3307;
                return true;
            }
            case 3307: {
                if (59 != current) break;
                this.match = "\u2233";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3308: {
                if (110 != current) break;
                this.state = 3309;
                return true;
            }
            case 3309: {
                if (116 != current) break;
                this.state = 3310;
                return true;
            }
            case 3310: {
                if (59 != current) break;
                this.match = "\u2a11";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3311: {
                switch (current) {
                    case 78: {
                        this.state = 3312;
                        return true;
                    }
                    case 97: {
                        this.state = 3315;
                        return true;
                    }
                    case 98: {
                        this.state = 3348;
                        return true;
                    }
                    case 99: {
                        this.state = 3355;
                        return true;
                    }
                    case 100: {
                        this.state = 3360;
                        return true;
                    }
                    case 101: {
                        this.state = 3364;
                        return true;
                    }
                    case 102: {
                        this.state = 3389;
                        return true;
                    }
                    case 105: {
                        this.state = 3391;
                        return true;
                    }
                    case 107: {
                        this.state = 3449;
                        return true;
                    }
                    case 108: {
                        this.state = 3454;
                        return true;
                    }
                    case 110: {
                        this.state = 3503;
                        return true;
                    }
                    case 111: {
                        this.state = 3511;
                        return true;
                    }
                    case 112: {
                        this.state = 3584;
                        return true;
                    }
                    case 114: {
                        this.state = 3589;
                        return true;
                    }
                    case 115: {
                        this.state = 3597;
                        return true;
                    }
                    case 117: {
                        this.state = 3613;
                        return true;
                    }
                }
                break;
            }
            case 3312: {
                if (111 != current) break;
                this.state = 3313;
                return true;
            }
            case 3313: {
                if (116 != current) break;
                this.state = 3314;
                return true;
            }
            case 3314: {
                if (59 != current) break;
                this.match = "\u2aed";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3315: {
                if (99 == current) {
                    this.state = 3316;
                    return true;
                }
                if (114 != current) break;
                this.state = 3339;
                return true;
            }
            case 3316: {
                if (107 != current) break;
                this.state = 3317;
                return true;
            }
            case 3317: {
                switch (current) {
                    case 99: {
                        this.state = 3318;
                        return true;
                    }
                    case 101: {
                        this.state = 3322;
                        return true;
                    }
                    case 112: {
                        this.state = 3329;
                        return true;
                    }
                    case 115: {
                        this.state = 3334;
                        return true;
                    }
                }
                break;
            }
            case 3318: {
                if (111 != current) break;
                this.state = 3319;
                return true;
            }
            case 3319: {
                if (110 != current) break;
                this.state = 3320;
                return true;
            }
            case 3320: {
                if (103 != current) break;
                this.state = 3321;
                return true;
            }
            case 3321: {
                if (59 != current) break;
                this.match = "\u224c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3322: {
                if (112 != current) break;
                this.state = 3323;
                return true;
            }
            case 3323: {
                if (115 != current) break;
                this.state = 3324;
                return true;
            }
            case 3324: {
                if (105 != current) break;
                this.state = 3325;
                return true;
            }
            case 3325: {
                if (108 != current) break;
                this.state = 3326;
                return true;
            }
            case 3326: {
                if (111 != current) break;
                this.state = 3327;
                return true;
            }
            case 3327: {
                if (110 != current) break;
                this.state = 3328;
                return true;
            }
            case 3328: {
                if (59 != current) break;
                this.match = "\u03f6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3329: {
                if (114 != current) break;
                this.state = 3330;
                return true;
            }
            case 3330: {
                if (105 != current) break;
                this.state = 3331;
                return true;
            }
            case 3331: {
                if (109 != current) break;
                this.state = 3332;
                return true;
            }
            case 3332: {
                if (101 != current) break;
                this.state = 3333;
                return true;
            }
            case 3333: {
                if (59 != current) break;
                this.match = "\u2035";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3334: {
                if (105 != current) break;
                this.state = 3335;
                return true;
            }
            case 3335: {
                if (109 != current) break;
                this.state = 3336;
                return true;
            }
            case 3336: {
                if (59 == current) {
                    this.match = "\u223d";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3337;
                return true;
            }
            case 3337: {
                if (113 != current) break;
                this.state = 3338;
                return true;
            }
            case 3338: {
                if (59 != current) break;
                this.match = "\u22cd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3339: {
                if (118 == current) {
                    this.state = 3340;
                    return true;
                }
                if (119 != current) break;
                this.state = 3343;
                return true;
            }
            case 3340: {
                if (101 != current) break;
                this.state = 3341;
                return true;
            }
            case 3341: {
                if (101 != current) break;
                this.state = 3342;
                return true;
            }
            case 3342: {
                if (59 != current) break;
                this.match = "\u22bd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3343: {
                if (101 != current) break;
                this.state = 3344;
                return true;
            }
            case 3344: {
                if (100 != current) break;
                this.state = 3345;
                return true;
            }
            case 3345: {
                if (59 == current) {
                    this.match = "\u2305";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (103 != current) break;
                this.state = 3346;
                return true;
            }
            case 3346: {
                if (101 != current) break;
                this.state = 3347;
                return true;
            }
            case 3347: {
                if (59 != current) break;
                this.match = "\u2305";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3348: {
                if (114 != current) break;
                this.state = 3349;
                return true;
            }
            case 3349: {
                if (107 != current) break;
                this.state = 3350;
                return true;
            }
            case 3350: {
                if (59 == current) {
                    this.match = "\u23b5";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (116 != current) break;
                this.state = 3351;
                return true;
            }
            case 3351: {
                if (98 != current) break;
                this.state = 3352;
                return true;
            }
            case 3352: {
                if (114 != current) break;
                this.state = 3353;
                return true;
            }
            case 3353: {
                if (107 != current) break;
                this.state = 3354;
                return true;
            }
            case 3354: {
                if (59 != current) break;
                this.match = "\u23b6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3355: {
                if (111 == current) {
                    this.state = 3356;
                    return true;
                }
                if (121 != current) break;
                this.state = 3359;
                return true;
            }
            case 3356: {
                if (110 != current) break;
                this.state = 3357;
                return true;
            }
            case 3357: {
                if (103 != current) break;
                this.state = 3358;
                return true;
            }
            case 3358: {
                if (59 != current) break;
                this.match = "\u224c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3359: {
                if (59 != current) break;
                this.match = "\u0431";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3360: {
                if (113 != current) break;
                this.state = 3361;
                return true;
            }
            case 3361: {
                if (117 != current) break;
                this.state = 3362;
                return true;
            }
            case 3362: {
                if (111 != current) break;
                this.state = 3363;
                return true;
            }
            case 3363: {
                if (59 != current) break;
                this.match = "\u201e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3364: {
                switch (current) {
                    case 99: {
                        this.state = 3365;
                        return true;
                    }
                    case 109: {
                        this.state = 3370;
                        return true;
                    }
                    case 112: {
                        this.state = 3375;
                        return true;
                    }
                    case 114: {
                        this.state = 3378;
                        return true;
                    }
                    case 116: {
                        this.state = 3382;
                        return true;
                    }
                }
                break;
            }
            case 3365: {
                if (97 != current) break;
                this.state = 3366;
                return true;
            }
            case 3366: {
                if (117 != current) break;
                this.state = 3367;
                return true;
            }
            case 3367: {
                if (115 != current) break;
                this.state = 3368;
                return true;
            }
            case 3368: {
                if (59 == current) {
                    this.match = "\u2235";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3369;
                return true;
            }
            case 3369: {
                if (59 != current) break;
                this.match = "\u2235";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3370: {
                if (112 != current) break;
                this.state = 3371;
                return true;
            }
            case 3371: {
                if (116 != current) break;
                this.state = 3372;
                return true;
            }
            case 3372: {
                if (121 != current) break;
                this.state = 3373;
                return true;
            }
            case 3373: {
                if (118 != current) break;
                this.state = 3374;
                return true;
            }
            case 3374: {
                if (59 != current) break;
                this.match = "\u29b0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3375: {
                if (115 != current) break;
                this.state = 3376;
                return true;
            }
            case 3376: {
                if (105 != current) break;
                this.state = 3377;
                return true;
            }
            case 3377: {
                if (59 != current) break;
                this.match = "\u03f6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3378: {
                if (110 != current) break;
                this.state = 3379;
                return true;
            }
            case 3379: {
                if (111 != current) break;
                this.state = 3380;
                return true;
            }
            case 3380: {
                if (117 != current) break;
                this.state = 3381;
                return true;
            }
            case 3381: {
                if (59 != current) break;
                this.match = "\u212c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3382: {
                switch (current) {
                    case 97: {
                        this.state = 3383;
                        return true;
                    }
                    case 104: {
                        this.state = 3384;
                        return true;
                    }
                    case 119: {
                        this.state = 3385;
                        return true;
                    }
                }
                break;
            }
            case 3383: {
                if (59 != current) break;
                this.match = "\u03b2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3384: {
                if (59 != current) break;
                this.match = "\u2136";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3385: {
                if (101 != current) break;
                this.state = 3386;
                return true;
            }
            case 3386: {
                if (101 != current) break;
                this.state = 3387;
                return true;
            }
            case 3387: {
                if (110 != current) break;
                this.state = 3388;
                return true;
            }
            case 3388: {
                if (59 != current) break;
                this.match = "\u226c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3389: {
                if (114 != current) break;
                this.state = 3390;
                return true;
            }
            case 3390: {
                if (59 != current) break;
                this.match = "\ud835\udd1f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3391: {
                if (103 != current) break;
                this.state = 3392;
                return true;
            }
            case 3392: {
                switch (current) {
                    case 99: {
                        this.state = 3393;
                        return true;
                    }
                    case 111: {
                        this.state = 3401;
                        return true;
                    }
                    case 115: {
                        this.state = 3414;
                        return true;
                    }
                    case 116: {
                        this.state = 3422;
                        return true;
                    }
                    case 117: {
                        this.state = 3436;
                        return true;
                    }
                    case 118: {
                        this.state = 3441;
                        return true;
                    }
                    case 119: {
                        this.state = 3444;
                        return true;
                    }
                }
                break;
            }
            case 3393: {
                switch (current) {
                    case 97: {
                        this.state = 3394;
                        return true;
                    }
                    case 105: {
                        this.state = 3396;
                        return true;
                    }
                    case 117: {
                        this.state = 3399;
                        return true;
                    }
                }
                break;
            }
            case 3394: {
                if (112 != current) break;
                this.state = 3395;
                return true;
            }
            case 3395: {
                if (59 != current) break;
                this.match = "\u22c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3396: {
                if (114 != current) break;
                this.state = 3397;
                return true;
            }
            case 3397: {
                if (99 != current) break;
                this.state = 3398;
                return true;
            }
            case 3398: {
                if (59 != current) break;
                this.match = "\u25ef";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3399: {
                if (112 != current) break;
                this.state = 3400;
                return true;
            }
            case 3400: {
                if (59 != current) break;
                this.match = "\u22c3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3401: {
                switch (current) {
                    case 100: {
                        this.state = 3402;
                        return true;
                    }
                    case 112: {
                        this.state = 3405;
                        return true;
                    }
                    case 116: {
                        this.state = 3409;
                        return true;
                    }
                }
                break;
            }
            case 3402: {
                if (111 != current) break;
                this.state = 3403;
                return true;
            }
            case 3403: {
                if (116 != current) break;
                this.state = 3404;
                return true;
            }
            case 3404: {
                if (59 != current) break;
                this.match = "\u2a00";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3405: {
                if (108 != current) break;
                this.state = 3406;
                return true;
            }
            case 3406: {
                if (117 != current) break;
                this.state = 3407;
                return true;
            }
            case 3407: {
                if (115 != current) break;
                this.state = 3408;
                return true;
            }
            case 3408: {
                if (59 != current) break;
                this.match = "\u2a01";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3409: {
                if (105 != current) break;
                this.state = 3410;
                return true;
            }
            case 3410: {
                if (109 != current) break;
                this.state = 3411;
                return true;
            }
            case 3411: {
                if (101 != current) break;
                this.state = 3412;
                return true;
            }
            case 3412: {
                if (115 != current) break;
                this.state = 3413;
                return true;
            }
            case 3413: {
                if (59 != current) break;
                this.match = "\u2a02";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3414: {
                if (113 == current) {
                    this.state = 3415;
                    return true;
                }
                if (116 != current) break;
                this.state = 3419;
                return true;
            }
            case 3415: {
                if (99 != current) break;
                this.state = 3416;
                return true;
            }
            case 3416: {
                if (117 != current) break;
                this.state = 3417;
                return true;
            }
            case 3417: {
                if (112 != current) break;
                this.state = 3418;
                return true;
            }
            case 3418: {
                if (59 != current) break;
                this.match = "\u2a06";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3419: {
                if (97 != current) break;
                this.state = 3420;
                return true;
            }
            case 3420: {
                if (114 != current) break;
                this.state = 3421;
                return true;
            }
            case 3421: {
                if (59 != current) break;
                this.match = "\u2605";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3422: {
                if (114 != current) break;
                this.state = 3423;
                return true;
            }
            case 3423: {
                if (105 != current) break;
                this.state = 3424;
                return true;
            }
            case 3424: {
                if (97 != current) break;
                this.state = 3425;
                return true;
            }
            case 3425: {
                if (110 != current) break;
                this.state = 3426;
                return true;
            }
            case 3426: {
                if (103 != current) break;
                this.state = 3427;
                return true;
            }
            case 3427: {
                if (108 != current) break;
                this.state = 3428;
                return true;
            }
            case 3428: {
                if (101 != current) break;
                this.state = 3429;
                return true;
            }
            case 3429: {
                if (100 == current) {
                    this.state = 3430;
                    return true;
                }
                if (117 != current) break;
                this.state = 3434;
                return true;
            }
            case 3430: {
                if (111 != current) break;
                this.state = 3431;
                return true;
            }
            case 3431: {
                if (119 != current) break;
                this.state = 3432;
                return true;
            }
            case 3432: {
                if (110 != current) break;
                this.state = 3433;
                return true;
            }
            case 3433: {
                if (59 != current) break;
                this.match = "\u25bd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3434: {
                if (112 != current) break;
                this.state = 3435;
                return true;
            }
            case 3435: {
                if (59 != current) break;
                this.match = "\u25b3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3436: {
                if (112 != current) break;
                this.state = 3437;
                return true;
            }
            case 3437: {
                if (108 != current) break;
                this.state = 3438;
                return true;
            }
            case 3438: {
                if (117 != current) break;
                this.state = 3439;
                return true;
            }
            case 3439: {
                if (115 != current) break;
                this.state = 3440;
                return true;
            }
            case 3440: {
                if (59 != current) break;
                this.match = "\u2a04";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3441: {
                if (101 != current) break;
                this.state = 3442;
                return true;
            }
            case 3442: {
                if (101 != current) break;
                this.state = 3443;
                return true;
            }
            case 3443: {
                if (59 != current) break;
                this.match = "\u22c1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3444: {
                if (101 != current) break;
                this.state = 3445;
                return true;
            }
            case 3445: {
                if (100 != current) break;
                this.state = 3446;
                return true;
            }
            case 3446: {
                if (103 != current) break;
                this.state = 3447;
                return true;
            }
            case 3447: {
                if (101 != current) break;
                this.state = 3448;
                return true;
            }
            case 3448: {
                if (59 != current) break;
                this.match = "\u22c0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3449: {
                if (97 != current) break;
                this.state = 3450;
                return true;
            }
            case 3450: {
                if (114 != current) break;
                this.state = 3451;
                return true;
            }
            case 3451: {
                if (111 != current) break;
                this.state = 3452;
                return true;
            }
            case 3452: {
                if (119 != current) break;
                this.state = 3453;
                return true;
            }
            case 3453: {
                if (59 != current) break;
                this.match = "\u290d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3454: {
                switch (current) {
                    case 97: {
                        this.state = 3455;
                        return true;
                    }
                    case 107: {
                        this.state = 3494;
                        return true;
                    }
                    case 111: {
                        this.state = 3500;
                        return true;
                    }
                }
                break;
            }
            case 3455: {
                if (99 == current) {
                    this.state = 3456;
                    return true;
                }
                if (110 != current) break;
                this.state = 3492;
                return true;
            }
            case 3456: {
                if (107 != current) break;
                this.state = 3457;
                return true;
            }
            case 3457: {
                switch (current) {
                    case 108: {
                        this.state = 3458;
                        return true;
                    }
                    case 115: {
                        this.state = 3465;
                        return true;
                    }
                    case 116: {
                        this.state = 3471;
                        return true;
                    }
                }
                break;
            }
            case 3458: {
                if (111 != current) break;
                this.state = 3459;
                return true;
            }
            case 3459: {
                if (122 != current) break;
                this.state = 3460;
                return true;
            }
            case 3460: {
                if (101 != current) break;
                this.state = 3461;
                return true;
            }
            case 3461: {
                if (110 != current) break;
                this.state = 3462;
                return true;
            }
            case 3462: {
                if (103 != current) break;
                this.state = 3463;
                return true;
            }
            case 3463: {
                if (101 != current) break;
                this.state = 3464;
                return true;
            }
            case 3464: {
                if (59 != current) break;
                this.match = "\u29eb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3465: {
                if (113 != current) break;
                this.state = 3466;
                return true;
            }
            case 3466: {
                if (117 != current) break;
                this.state = 3467;
                return true;
            }
            case 3467: {
                if (97 != current) break;
                this.state = 3468;
                return true;
            }
            case 3468: {
                if (114 != current) break;
                this.state = 3469;
                return true;
            }
            case 3469: {
                if (101 != current) break;
                this.state = 3470;
                return true;
            }
            case 3470: {
                if (59 != current) break;
                this.match = "\u25aa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3471: {
                if (114 != current) break;
                this.state = 3472;
                return true;
            }
            case 3472: {
                if (105 != current) break;
                this.state = 3473;
                return true;
            }
            case 3473: {
                if (97 != current) break;
                this.state = 3474;
                return true;
            }
            case 3474: {
                if (110 != current) break;
                this.state = 3475;
                return true;
            }
            case 3475: {
                if (103 != current) break;
                this.state = 3476;
                return true;
            }
            case 3476: {
                if (108 != current) break;
                this.state = 3477;
                return true;
            }
            case 3477: {
                if (101 != current) break;
                this.state = 3478;
                return true;
            }
            case 3478: {
                switch (current) {
                    case 59: {
                        this.match = "\u25b4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 100: {
                        this.state = 3479;
                        return true;
                    }
                    case 108: {
                        this.state = 3483;
                        return true;
                    }
                    case 114: {
                        this.state = 3487;
                        return true;
                    }
                }
                break;
            }
            case 3479: {
                if (111 != current) break;
                this.state = 3480;
                return true;
            }
            case 3480: {
                if (119 != current) break;
                this.state = 3481;
                return true;
            }
            case 3481: {
                if (110 != current) break;
                this.state = 3482;
                return true;
            }
            case 3482: {
                if (59 != current) break;
                this.match = "\u25be";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3483: {
                if (101 != current) break;
                this.state = 3484;
                return true;
            }
            case 3484: {
                if (102 != current) break;
                this.state = 3485;
                return true;
            }
            case 3485: {
                if (116 != current) break;
                this.state = 3486;
                return true;
            }
            case 3486: {
                if (59 != current) break;
                this.match = "\u25c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3487: {
                if (105 != current) break;
                this.state = 3488;
                return true;
            }
            case 3488: {
                if (103 != current) break;
                this.state = 3489;
                return true;
            }
            case 3489: {
                if (104 != current) break;
                this.state = 3490;
                return true;
            }
            case 3490: {
                if (116 != current) break;
                this.state = 3491;
                return true;
            }
            case 3491: {
                if (59 != current) break;
                this.match = "\u25b8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3492: {
                if (107 != current) break;
                this.state = 3493;
                return true;
            }
            case 3493: {
                if (59 != current) break;
                this.match = "\u2423";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3494: {
                if (49 == current) {
                    this.state = 3495;
                    return true;
                }
                if (51 != current) break;
                this.state = 3498;
                return true;
            }
            case 3495: {
                if (50 == current) {
                    this.state = 3496;
                    return true;
                }
                if (52 != current) break;
                this.state = 3497;
                return true;
            }
            case 3496: {
                if (59 != current) break;
                this.match = "\u2592";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3497: {
                if (59 != current) break;
                this.match = "\u2591";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3498: {
                if (52 != current) break;
                this.state = 3499;
                return true;
            }
            case 3499: {
                if (59 != current) break;
                this.match = "\u2593";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3500: {
                if (99 != current) break;
                this.state = 3501;
                return true;
            }
            case 3501: {
                if (107 != current) break;
                this.state = 3502;
                return true;
            }
            case 3502: {
                if (59 != current) break;
                this.match = "\u2588";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3503: {
                if (101 == current) {
                    this.state = 3504;
                    return true;
                }
                if (111 != current) break;
                this.state = 3509;
                return true;
            }
            case 3504: {
                if (59 == current) {
                    this.match = "=\u20e5";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (113 != current) break;
                this.state = 3505;
                return true;
            }
            case 3505: {
                if (117 != current) break;
                this.state = 3506;
                return true;
            }
            case 3506: {
                if (105 != current) break;
                this.state = 3507;
                return true;
            }
            case 3507: {
                if (118 != current) break;
                this.state = 3508;
                return true;
            }
            case 3508: {
                if (59 != current) break;
                this.match = "\u2261\u20e5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3509: {
                if (116 != current) break;
                this.state = 3510;
                return true;
            }
            case 3510: {
                if (59 != current) break;
                this.match = "\u2310";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3511: {
                switch (current) {
                    case 112: {
                        this.state = 3512;
                        return true;
                    }
                    case 116: {
                        this.state = 3514;
                        return true;
                    }
                    case 119: {
                        this.state = 3518;
                        return true;
                    }
                    case 120: {
                        this.state = 3522;
                        return true;
                    }
                }
                break;
            }
            case 3512: {
                if (102 != current) break;
                this.state = 3513;
                return true;
            }
            case 3513: {
                if (59 != current) break;
                this.match = "\ud835\udd53";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3514: {
                if (59 == current) {
                    this.match = "\u22a5";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (116 != current) break;
                this.state = 3515;
                return true;
            }
            case 3515: {
                if (111 != current) break;
                this.state = 3516;
                return true;
            }
            case 3516: {
                if (109 != current) break;
                this.state = 3517;
                return true;
            }
            case 3517: {
                if (59 != current) break;
                this.match = "\u22a5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3518: {
                if (116 != current) break;
                this.state = 3519;
                return true;
            }
            case 3519: {
                if (105 != current) break;
                this.state = 3520;
                return true;
            }
            case 3520: {
                if (101 != current) break;
                this.state = 3521;
                return true;
            }
            case 3521: {
                if (59 != current) break;
                this.match = "\u22c8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3522: {
                switch (current) {
                    case 68: {
                        this.state = 3523;
                        return true;
                    }
                    case 72: {
                        this.state = 3528;
                        return true;
                    }
                    case 85: {
                        this.state = 3533;
                        return true;
                    }
                    case 86: {
                        this.state = 3538;
                        return true;
                    }
                    case 98: {
                        this.state = 3545;
                        return true;
                    }
                    case 100: {
                        this.state = 3548;
                        return true;
                    }
                    case 104: {
                        this.state = 3553;
                        return true;
                    }
                    case 109: {
                        this.state = 3558;
                        return true;
                    }
                    case 112: {
                        this.state = 3563;
                        return true;
                    }
                    case 116: {
                        this.state = 3567;
                        return true;
                    }
                    case 117: {
                        this.state = 3572;
                        return true;
                    }
                    case 118: {
                        this.state = 3577;
                        return true;
                    }
                }
                break;
            }
            case 3523: {
                switch (current) {
                    case 76: {
                        this.state = 3524;
                        return true;
                    }
                    case 82: {
                        this.state = 3525;
                        return true;
                    }
                    case 108: {
                        this.state = 3526;
                        return true;
                    }
                    case 114: {
                        this.state = 3527;
                        return true;
                    }
                }
                break;
            }
            case 3524: {
                if (59 != current) break;
                this.match = "\u2557";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3525: {
                if (59 != current) break;
                this.match = "\u2554";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3526: {
                if (59 != current) break;
                this.match = "\u2556";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3527: {
                if (59 != current) break;
                this.match = "\u2553";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3528: {
                switch (current) {
                    case 59: {
                        this.match = "\u2550";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 68: {
                        this.state = 3529;
                        return true;
                    }
                    case 85: {
                        this.state = 3530;
                        return true;
                    }
                    case 100: {
                        this.state = 3531;
                        return true;
                    }
                    case 117: {
                        this.state = 3532;
                        return true;
                    }
                }
                break;
            }
            case 3529: {
                if (59 != current) break;
                this.match = "\u2566";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3530: {
                if (59 != current) break;
                this.match = "\u2569";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3531: {
                if (59 != current) break;
                this.match = "\u2564";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3532: {
                if (59 != current) break;
                this.match = "\u2567";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3533: {
                switch (current) {
                    case 76: {
                        this.state = 3534;
                        return true;
                    }
                    case 82: {
                        this.state = 3535;
                        return true;
                    }
                    case 108: {
                        this.state = 3536;
                        return true;
                    }
                    case 114: {
                        this.state = 3537;
                        return true;
                    }
                }
                break;
            }
            case 3534: {
                if (59 != current) break;
                this.match = "\u255d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3535: {
                if (59 != current) break;
                this.match = "\u255a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3536: {
                if (59 != current) break;
                this.match = "\u255c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3537: {
                if (59 != current) break;
                this.match = "\u2559";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3538: {
                switch (current) {
                    case 59: {
                        this.match = "\u2551";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 72: {
                        this.state = 3539;
                        return true;
                    }
                    case 76: {
                        this.state = 3540;
                        return true;
                    }
                    case 82: {
                        this.state = 3541;
                        return true;
                    }
                    case 104: {
                        this.state = 3542;
                        return true;
                    }
                    case 108: {
                        this.state = 3543;
                        return true;
                    }
                    case 114: {
                        this.state = 3544;
                        return true;
                    }
                }
                break;
            }
            case 3539: {
                if (59 != current) break;
                this.match = "\u256c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3540: {
                if (59 != current) break;
                this.match = "\u2563";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3541: {
                if (59 != current) break;
                this.match = "\u2560";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3542: {
                if (59 != current) break;
                this.match = "\u256b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3543: {
                if (59 != current) break;
                this.match = "\u2562";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3544: {
                if (59 != current) break;
                this.match = "\u255f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3545: {
                if (111 != current) break;
                this.state = 3546;
                return true;
            }
            case 3546: {
                if (120 != current) break;
                this.state = 3547;
                return true;
            }
            case 3547: {
                if (59 != current) break;
                this.match = "\u29c9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3548: {
                switch (current) {
                    case 76: {
                        this.state = 3549;
                        return true;
                    }
                    case 82: {
                        this.state = 3550;
                        return true;
                    }
                    case 108: {
                        this.state = 3551;
                        return true;
                    }
                    case 114: {
                        this.state = 3552;
                        return true;
                    }
                }
                break;
            }
            case 3549: {
                if (59 != current) break;
                this.match = "\u2555";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3550: {
                if (59 != current) break;
                this.match = "\u2552";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3551: {
                if (59 != current) break;
                this.match = "\u2510";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3552: {
                if (59 != current) break;
                this.match = "\u250c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3553: {
                switch (current) {
                    case 59: {
                        this.match = "\u2500";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 68: {
                        this.state = 3554;
                        return true;
                    }
                    case 85: {
                        this.state = 3555;
                        return true;
                    }
                    case 100: {
                        this.state = 3556;
                        return true;
                    }
                    case 117: {
                        this.state = 3557;
                        return true;
                    }
                }
                break;
            }
            case 3554: {
                if (59 != current) break;
                this.match = "\u2565";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3555: {
                if (59 != current) break;
                this.match = "\u2568";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3556: {
                if (59 != current) break;
                this.match = "\u252c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3557: {
                if (59 != current) break;
                this.match = "\u2534";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3558: {
                if (105 != current) break;
                this.state = 3559;
                return true;
            }
            case 3559: {
                if (110 != current) break;
                this.state = 3560;
                return true;
            }
            case 3560: {
                if (117 != current) break;
                this.state = 3561;
                return true;
            }
            case 3561: {
                if (115 != current) break;
                this.state = 3562;
                return true;
            }
            case 3562: {
                if (59 != current) break;
                this.match = "\u229f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3563: {
                if (108 != current) break;
                this.state = 3564;
                return true;
            }
            case 3564: {
                if (117 != current) break;
                this.state = 3565;
                return true;
            }
            case 3565: {
                if (115 != current) break;
                this.state = 3566;
                return true;
            }
            case 3566: {
                if (59 != current) break;
                this.match = "\u229e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3567: {
                if (105 != current) break;
                this.state = 3568;
                return true;
            }
            case 3568: {
                if (109 != current) break;
                this.state = 3569;
                return true;
            }
            case 3569: {
                if (101 != current) break;
                this.state = 3570;
                return true;
            }
            case 3570: {
                if (115 != current) break;
                this.state = 3571;
                return true;
            }
            case 3571: {
                if (59 != current) break;
                this.match = "\u22a0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3572: {
                switch (current) {
                    case 76: {
                        this.state = 3573;
                        return true;
                    }
                    case 82: {
                        this.state = 3574;
                        return true;
                    }
                    case 108: {
                        this.state = 3575;
                        return true;
                    }
                    case 114: {
                        this.state = 3576;
                        return true;
                    }
                }
                break;
            }
            case 3573: {
                if (59 != current) break;
                this.match = "\u255b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3574: {
                if (59 != current) break;
                this.match = "\u2558";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3575: {
                if (59 != current) break;
                this.match = "\u2518";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3576: {
                if (59 != current) break;
                this.match = "\u2514";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3577: {
                switch (current) {
                    case 59: {
                        this.match = "\u2502";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 72: {
                        this.state = 3578;
                        return true;
                    }
                    case 76: {
                        this.state = 3579;
                        return true;
                    }
                    case 82: {
                        this.state = 3580;
                        return true;
                    }
                    case 104: {
                        this.state = 3581;
                        return true;
                    }
                    case 108: {
                        this.state = 3582;
                        return true;
                    }
                    case 114: {
                        this.state = 3583;
                        return true;
                    }
                }
                break;
            }
            case 3578: {
                if (59 != current) break;
                this.match = "\u256a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3579: {
                if (59 != current) break;
                this.match = "\u2561";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3580: {
                if (59 != current) break;
                this.match = "\u255e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3581: {
                if (59 != current) break;
                this.match = "\u253c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3582: {
                if (59 != current) break;
                this.match = "\u2524";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3583: {
                if (59 != current) break;
                this.match = "\u251c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3584: {
                if (114 != current) break;
                this.state = 3585;
                return true;
            }
            case 3585: {
                if (105 != current) break;
                this.state = 3586;
                return true;
            }
            case 3586: {
                if (109 != current) break;
                this.state = 3587;
                return true;
            }
            case 3587: {
                if (101 != current) break;
                this.state = 3588;
                return true;
            }
            case 3588: {
                if (59 != current) break;
                this.match = "\u2035";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3589: {
                if (101 == current) {
                    this.state = 3590;
                    return true;
                }
                if (118 != current) break;
                this.state = 3593;
                return true;
            }
            case 3590: {
                if (118 != current) break;
                this.state = 3591;
                return true;
            }
            case 3591: {
                if (101 != current) break;
                this.state = 3592;
                return true;
            }
            case 3592: {
                if (59 != current) break;
                this.match = "\u02d8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3593: {
                if (98 != current) break;
                this.state = 3594;
                return true;
            }
            case 3594: {
                if (97 != current) break;
                this.state = 3595;
                return true;
            }
            case 3595: {
                if (114 != current) break;
                this.match = "\u00a6";
                this.matchLength = this.consumedCount;
                this.state = 3596;
                return true;
            }
            case 3596: {
                if (59 != current) break;
                this.match = "\u00a6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3597: {
                switch (current) {
                    case 99: {
                        this.state = 3598;
                        return true;
                    }
                    case 101: {
                        this.state = 3600;
                        return true;
                    }
                    case 105: {
                        this.state = 3603;
                        return true;
                    }
                    case 111: {
                        this.state = 3606;
                        return true;
                    }
                }
                break;
            }
            case 3598: {
                if (114 != current) break;
                this.state = 3599;
                return true;
            }
            case 3599: {
                if (59 != current) break;
                this.match = "\ud835\udcb7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3600: {
                if (109 != current) break;
                this.state = 3601;
                return true;
            }
            case 3601: {
                if (105 != current) break;
                this.state = 3602;
                return true;
            }
            case 3602: {
                if (59 != current) break;
                this.match = "\u204f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3603: {
                if (109 != current) break;
                this.state = 3604;
                return true;
            }
            case 3604: {
                if (59 == current) {
                    this.match = "\u223d";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3605;
                return true;
            }
            case 3605: {
                if (59 != current) break;
                this.match = "\u22cd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3606: {
                if (108 != current) break;
                this.state = 3607;
                return true;
            }
            case 3607: {
                switch (current) {
                    case 59: {
                        this.match = "\\";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 98: {
                        this.state = 3608;
                        return true;
                    }
                    case 104: {
                        this.state = 3609;
                        return true;
                    }
                }
                break;
            }
            case 3608: {
                if (59 != current) break;
                this.match = "\u29c5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3609: {
                if (115 != current) break;
                this.state = 3610;
                return true;
            }
            case 3610: {
                if (117 != current) break;
                this.state = 3611;
                return true;
            }
            case 3611: {
                if (98 != current) break;
                this.state = 3612;
                return true;
            }
            case 3612: {
                if (59 != current) break;
                this.match = "\u27c8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3613: {
                if (108 == current) {
                    this.state = 3614;
                    return true;
                }
                if (109 != current) break;
                this.state = 3618;
                return true;
            }
            case 3614: {
                if (108 != current) break;
                this.state = 3615;
                return true;
            }
            case 3615: {
                if (59 == current) {
                    this.match = "\u2022";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3616;
                return true;
            }
            case 3616: {
                if (116 != current) break;
                this.state = 3617;
                return true;
            }
            case 3617: {
                if (59 != current) break;
                this.match = "\u2022";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3618: {
                if (112 != current) break;
                this.state = 3619;
                return true;
            }
            case 3619: {
                switch (current) {
                    case 59: {
                        this.match = "\u224e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 3620;
                        return true;
                    }
                    case 101: {
                        this.state = 3621;
                        return true;
                    }
                }
                break;
            }
            case 3620: {
                if (59 != current) break;
                this.match = "\u2aae";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3621: {
                if (59 == current) {
                    this.match = "\u224f";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (113 != current) break;
                this.state = 3622;
                return true;
            }
            case 3622: {
                if (59 != current) break;
                this.match = "\u224f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3623: {
                switch (current) {
                    case 97: {
                        this.state = 3624;
                        return true;
                    }
                    case 99: {
                        this.state = 3652;
                        return true;
                    }
                    case 100: {
                        this.state = 3671;
                        return true;
                    }
                    case 101: {
                        this.state = 3674;
                        return true;
                    }
                    case 102: {
                        this.state = 3690;
                        return true;
                    }
                    case 104: {
                        this.state = 3692;
                        return true;
                    }
                    case 105: {
                        this.state = 3703;
                        return true;
                    }
                    case 108: {
                        this.state = 3752;
                        return true;
                    }
                    case 111: {
                        this.state = 3759;
                        return true;
                    }
                    case 114: {
                        this.state = 3797;
                        return true;
                    }
                    case 115: {
                        this.state = 3804;
                        return true;
                    }
                    case 116: {
                        this.state = 3812;
                        return true;
                    }
                    case 117: {
                        this.state = 3816;
                        return true;
                    }
                    case 119: {
                        this.state = 3900;
                        return true;
                    }
                    case 121: {
                        this.state = 3910;
                        return true;
                    }
                }
                break;
            }
            case 3624: {
                switch (current) {
                    case 99: {
                        this.state = 3625;
                        return true;
                    }
                    case 112: {
                        this.state = 3629;
                        return true;
                    }
                    case 114: {
                        this.state = 3647;
                        return true;
                    }
                }
                break;
            }
            case 3625: {
                if (117 != current) break;
                this.state = 3626;
                return true;
            }
            case 3626: {
                if (116 != current) break;
                this.state = 3627;
                return true;
            }
            case 3627: {
                if (101 != current) break;
                this.state = 3628;
                return true;
            }
            case 3628: {
                if (59 != current) break;
                this.match = "\u0107";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3629: {
                switch (current) {
                    case 59: {
                        this.match = "\u2229";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 3630;
                        return true;
                    }
                    case 98: {
                        this.state = 3633;
                        return true;
                    }
                    case 99: {
                        this.state = 3638;
                        return true;
                    }
                    case 100: {
                        this.state = 3643;
                        return true;
                    }
                    case 115: {
                        this.state = 3646;
                        return true;
                    }
                }
                break;
            }
            case 3630: {
                if (110 != current) break;
                this.state = 3631;
                return true;
            }
            case 3631: {
                if (100 != current) break;
                this.state = 3632;
                return true;
            }
            case 3632: {
                if (59 != current) break;
                this.match = "\u2a44";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3633: {
                if (114 != current) break;
                this.state = 3634;
                return true;
            }
            case 3634: {
                if (99 != current) break;
                this.state = 3635;
                return true;
            }
            case 3635: {
                if (117 != current) break;
                this.state = 3636;
                return true;
            }
            case 3636: {
                if (112 != current) break;
                this.state = 3637;
                return true;
            }
            case 3637: {
                if (59 != current) break;
                this.match = "\u2a49";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3638: {
                if (97 == current) {
                    this.state = 3639;
                    return true;
                }
                if (117 != current) break;
                this.state = 3641;
                return true;
            }
            case 3639: {
                if (112 != current) break;
                this.state = 3640;
                return true;
            }
            case 3640: {
                if (59 != current) break;
                this.match = "\u2a4b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3641: {
                if (112 != current) break;
                this.state = 3642;
                return true;
            }
            case 3642: {
                if (59 != current) break;
                this.match = "\u2a47";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3643: {
                if (111 != current) break;
                this.state = 3644;
                return true;
            }
            case 3644: {
                if (116 != current) break;
                this.state = 3645;
                return true;
            }
            case 3645: {
                if (59 != current) break;
                this.match = "\u2a40";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3646: {
                if (59 != current) break;
                this.match = "\u2229\ufe00";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3647: {
                if (101 == current) {
                    this.state = 3648;
                    return true;
                }
                if (111 != current) break;
                this.state = 3650;
                return true;
            }
            case 3648: {
                if (116 != current) break;
                this.state = 3649;
                return true;
            }
            case 3649: {
                if (59 != current) break;
                this.match = "\u2041";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3650: {
                if (110 != current) break;
                this.state = 3651;
                return true;
            }
            case 3651: {
                if (59 != current) break;
                this.match = "\u02c7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3652: {
                switch (current) {
                    case 97: {
                        this.state = 3653;
                        return true;
                    }
                    case 101: {
                        this.state = 3659;
                        return true;
                    }
                    case 105: {
                        this.state = 3663;
                        return true;
                    }
                    case 117: {
                        this.state = 3666;
                        return true;
                    }
                }
                break;
            }
            case 3653: {
                if (112 == current) {
                    this.state = 3654;
                    return true;
                }
                if (114 != current) break;
                this.state = 3656;
                return true;
            }
            case 3654: {
                if (115 != current) break;
                this.state = 3655;
                return true;
            }
            case 3655: {
                if (59 != current) break;
                this.match = "\u2a4d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3656: {
                if (111 != current) break;
                this.state = 3657;
                return true;
            }
            case 3657: {
                if (110 != current) break;
                this.state = 3658;
                return true;
            }
            case 3658: {
                if (59 != current) break;
                this.match = "\u010d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3659: {
                if (100 != current) break;
                this.state = 3660;
                return true;
            }
            case 3660: {
                if (105 != current) break;
                this.state = 3661;
                return true;
            }
            case 3661: {
                if (108 != current) break;
                this.match = "\u00e7";
                this.matchLength = this.consumedCount;
                this.state = 3662;
                return true;
            }
            case 3662: {
                if (59 != current) break;
                this.match = "\u00e7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3663: {
                if (114 != current) break;
                this.state = 3664;
                return true;
            }
            case 3664: {
                if (99 != current) break;
                this.state = 3665;
                return true;
            }
            case 3665: {
                if (59 != current) break;
                this.match = "\u0109";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3666: {
                if (112 != current) break;
                this.state = 3667;
                return true;
            }
            case 3667: {
                if (115 != current) break;
                this.state = 3668;
                return true;
            }
            case 3668: {
                if (59 == current) {
                    this.match = "\u2a4c";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (115 != current) break;
                this.state = 3669;
                return true;
            }
            case 3669: {
                if (109 != current) break;
                this.state = 3670;
                return true;
            }
            case 3670: {
                if (59 != current) break;
                this.match = "\u2a50";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3671: {
                if (111 != current) break;
                this.state = 3672;
                return true;
            }
            case 3672: {
                if (116 != current) break;
                this.state = 3673;
                return true;
            }
            case 3673: {
                if (59 != current) break;
                this.match = "\u010b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3674: {
                switch (current) {
                    case 100: {
                        this.state = 3675;
                        return true;
                    }
                    case 109: {
                        this.state = 3678;
                        return true;
                    }
                    case 110: {
                        this.state = 3683;
                        return true;
                    }
                }
                break;
            }
            case 3675: {
                if (105 != current) break;
                this.state = 3676;
                return true;
            }
            case 3676: {
                if (108 != current) break;
                this.match = "\u00b8";
                this.matchLength = this.consumedCount;
                this.state = 3677;
                return true;
            }
            case 3677: {
                if (59 != current) break;
                this.match = "\u00b8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3678: {
                if (112 != current) break;
                this.state = 3679;
                return true;
            }
            case 3679: {
                if (116 != current) break;
                this.state = 3680;
                return true;
            }
            case 3680: {
                if (121 != current) break;
                this.state = 3681;
                return true;
            }
            case 3681: {
                if (118 != current) break;
                this.state = 3682;
                return true;
            }
            case 3682: {
                if (59 != current) break;
                this.match = "\u29b2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3683: {
                if (116 != current) break;
                this.match = "\u00a2";
                this.matchLength = this.consumedCount;
                this.state = 3684;
                return true;
            }
            case 3684: {
                if (59 == current) {
                    this.match = "\u00a2";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3685;
                return true;
            }
            case 3685: {
                if (114 != current) break;
                this.state = 3686;
                return true;
            }
            case 3686: {
                if (100 != current) break;
                this.state = 3687;
                return true;
            }
            case 3687: {
                if (111 != current) break;
                this.state = 3688;
                return true;
            }
            case 3688: {
                if (116 != current) break;
                this.state = 3689;
                return true;
            }
            case 3689: {
                if (59 != current) break;
                this.match = "\u00b7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3690: {
                if (114 != current) break;
                this.state = 3691;
                return true;
            }
            case 3691: {
                if (59 != current) break;
                this.match = "\ud835\udd20";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3692: {
                switch (current) {
                    case 99: {
                        this.state = 3693;
                        return true;
                    }
                    case 101: {
                        this.state = 3695;
                        return true;
                    }
                    case 105: {
                        this.state = 3702;
                        return true;
                    }
                }
                break;
            }
            case 3693: {
                if (121 != current) break;
                this.state = 3694;
                return true;
            }
            case 3694: {
                if (59 != current) break;
                this.match = "\u0447";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3695: {
                if (99 != current) break;
                this.state = 3696;
                return true;
            }
            case 3696: {
                if (107 != current) break;
                this.state = 3697;
                return true;
            }
            case 3697: {
                if (59 == current) {
                    this.match = "\u2713";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (109 != current) break;
                this.state = 3698;
                return true;
            }
            case 3698: {
                if (97 != current) break;
                this.state = 3699;
                return true;
            }
            case 3699: {
                if (114 != current) break;
                this.state = 3700;
                return true;
            }
            case 3700: {
                if (107 != current) break;
                this.state = 3701;
                return true;
            }
            case 3701: {
                if (59 != current) break;
                this.match = "\u2713";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3702: {
                if (59 != current) break;
                this.match = "\u03c7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3703: {
                if (114 != current) break;
                this.state = 3704;
                return true;
            }
            case 3704: {
                switch (current) {
                    case 59: {
                        this.match = "\u25cb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 3705;
                        return true;
                    }
                    case 99: {
                        this.state = 3706;
                        return true;
                    }
                    case 101: {
                        this.state = 3739;
                        return true;
                    }
                    case 102: {
                        this.state = 3740;
                        return true;
                    }
                    case 109: {
                        this.state = 3745;
                        return true;
                    }
                    case 115: {
                        this.state = 3748;
                        return true;
                    }
                }
                break;
            }
            case 3705: {
                if (59 != current) break;
                this.match = "\u29c3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3706: {
                switch (current) {
                    case 59: {
                        this.match = "\u02c6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 3707;
                        return true;
                    }
                    case 108: {
                        this.state = 3709;
                        return true;
                    }
                }
                break;
            }
            case 3707: {
                if (113 != current) break;
                this.state = 3708;
                return true;
            }
            case 3708: {
                if (59 != current) break;
                this.match = "\u2257";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3709: {
                if (101 != current) break;
                this.state = 3710;
                return true;
            }
            case 3710: {
                if (97 == current) {
                    this.state = 3711;
                    return true;
                }
                if (100 != current) break;
                this.state = 3725;
                return true;
            }
            case 3711: {
                if (114 != current) break;
                this.state = 3712;
                return true;
            }
            case 3712: {
                if (114 != current) break;
                this.state = 3713;
                return true;
            }
            case 3713: {
                if (111 != current) break;
                this.state = 3714;
                return true;
            }
            case 3714: {
                if (119 != current) break;
                this.state = 3715;
                return true;
            }
            case 3715: {
                if (108 == current) {
                    this.state = 3716;
                    return true;
                }
                if (114 != current) break;
                this.state = 3720;
                return true;
            }
            case 3716: {
                if (101 != current) break;
                this.state = 3717;
                return true;
            }
            case 3717: {
                if (102 != current) break;
                this.state = 3718;
                return true;
            }
            case 3718: {
                if (116 != current) break;
                this.state = 3719;
                return true;
            }
            case 3719: {
                if (59 != current) break;
                this.match = "\u21ba";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3720: {
                if (105 != current) break;
                this.state = 3721;
                return true;
            }
            case 3721: {
                if (103 != current) break;
                this.state = 3722;
                return true;
            }
            case 3722: {
                if (104 != current) break;
                this.state = 3723;
                return true;
            }
            case 3723: {
                if (116 != current) break;
                this.state = 3724;
                return true;
            }
            case 3724: {
                if (59 != current) break;
                this.match = "\u21bb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3725: {
                switch (current) {
                    case 82: {
                        this.state = 3726;
                        return true;
                    }
                    case 83: {
                        this.state = 3727;
                        return true;
                    }
                    case 97: {
                        this.state = 3728;
                        return true;
                    }
                    case 99: {
                        this.state = 3731;
                        return true;
                    }
                    case 100: {
                        this.state = 3735;
                        return true;
                    }
                }
                break;
            }
            case 3726: {
                if (59 != current) break;
                this.match = "\u00ae";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3727: {
                if (59 != current) break;
                this.match = "\u24c8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3728: {
                if (115 != current) break;
                this.state = 3729;
                return true;
            }
            case 3729: {
                if (116 != current) break;
                this.state = 3730;
                return true;
            }
            case 3730: {
                if (59 != current) break;
                this.match = "\u229b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3731: {
                if (105 != current) break;
                this.state = 3732;
                return true;
            }
            case 3732: {
                if (114 != current) break;
                this.state = 3733;
                return true;
            }
            case 3733: {
                if (99 != current) break;
                this.state = 3734;
                return true;
            }
            case 3734: {
                if (59 != current) break;
                this.match = "\u229a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3735: {
                if (97 != current) break;
                this.state = 3736;
                return true;
            }
            case 3736: {
                if (115 != current) break;
                this.state = 3737;
                return true;
            }
            case 3737: {
                if (104 != current) break;
                this.state = 3738;
                return true;
            }
            case 3738: {
                if (59 != current) break;
                this.match = "\u229d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3739: {
                if (59 != current) break;
                this.match = "\u2257";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3740: {
                if (110 != current) break;
                this.state = 3741;
                return true;
            }
            case 3741: {
                if (105 != current) break;
                this.state = 3742;
                return true;
            }
            case 3742: {
                if (110 != current) break;
                this.state = 3743;
                return true;
            }
            case 3743: {
                if (116 != current) break;
                this.state = 3744;
                return true;
            }
            case 3744: {
                if (59 != current) break;
                this.match = "\u2a10";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3745: {
                if (105 != current) break;
                this.state = 3746;
                return true;
            }
            case 3746: {
                if (100 != current) break;
                this.state = 3747;
                return true;
            }
            case 3747: {
                if (59 != current) break;
                this.match = "\u2aef";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3748: {
                if (99 != current) break;
                this.state = 3749;
                return true;
            }
            case 3749: {
                if (105 != current) break;
                this.state = 3750;
                return true;
            }
            case 3750: {
                if (114 != current) break;
                this.state = 3751;
                return true;
            }
            case 3751: {
                if (59 != current) break;
                this.match = "\u29c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3752: {
                if (117 != current) break;
                this.state = 3753;
                return true;
            }
            case 3753: {
                if (98 != current) break;
                this.state = 3754;
                return true;
            }
            case 3754: {
                if (115 != current) break;
                this.state = 3755;
                return true;
            }
            case 3755: {
                if (59 == current) {
                    this.match = "\u2663";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (117 != current) break;
                this.state = 3756;
                return true;
            }
            case 3756: {
                if (105 != current) break;
                this.state = 3757;
                return true;
            }
            case 3757: {
                if (116 != current) break;
                this.state = 3758;
                return true;
            }
            case 3758: {
                if (59 != current) break;
                this.match = "\u2663";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3759: {
                switch (current) {
                    case 108: {
                        this.state = 3760;
                        return true;
                    }
                    case 109: {
                        this.state = 3765;
                        return true;
                    }
                    case 110: {
                        this.state = 3781;
                        return true;
                    }
                    case 112: {
                        this.state = 3789;
                        return true;
                    }
                }
                break;
            }
            case 3760: {
                if (111 != current) break;
                this.state = 3761;
                return true;
            }
            case 3761: {
                if (110 != current) break;
                this.state = 3762;
                return true;
            }
            case 3762: {
                if (59 == current) {
                    this.match = ":";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3763;
                return true;
            }
            case 3763: {
                if (59 == current) {
                    this.match = "\u2254";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (113 != current) break;
                this.state = 3764;
                return true;
            }
            case 3764: {
                if (59 != current) break;
                this.match = "\u2254";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3765: {
                if (109 == current) {
                    this.state = 3766;
                    return true;
                }
                if (112 != current) break;
                this.state = 3769;
                return true;
            }
            case 3766: {
                if (97 != current) break;
                this.state = 3767;
                return true;
            }
            case 3767: {
                if (59 == current) {
                    this.match = ",";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (116 != current) break;
                this.state = 3768;
                return true;
            }
            case 3768: {
                if (59 != current) break;
                this.match = "@";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3769: {
                switch (current) {
                    case 59: {
                        this.match = "\u2201";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 102: {
                        this.state = 3770;
                        return true;
                    }
                    case 108: {
                        this.state = 3772;
                        return true;
                    }
                }
                break;
            }
            case 3770: {
                if (110 != current) break;
                this.state = 3771;
                return true;
            }
            case 3771: {
                if (59 != current) break;
                this.match = "\u2218";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3772: {
                if (101 != current) break;
                this.state = 3773;
                return true;
            }
            case 3773: {
                if (109 == current) {
                    this.state = 3774;
                    return true;
                }
                if (120 != current) break;
                this.state = 3778;
                return true;
            }
            case 3774: {
                if (101 != current) break;
                this.state = 3775;
                return true;
            }
            case 3775: {
                if (110 != current) break;
                this.state = 3776;
                return true;
            }
            case 3776: {
                if (116 != current) break;
                this.state = 3777;
                return true;
            }
            case 3777: {
                if (59 != current) break;
                this.match = "\u2201";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3778: {
                if (101 != current) break;
                this.state = 3779;
                return true;
            }
            case 3779: {
                if (115 != current) break;
                this.state = 3780;
                return true;
            }
            case 3780: {
                if (59 != current) break;
                this.match = "\u2102";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3781: {
                if (103 == current) {
                    this.state = 3782;
                    return true;
                }
                if (105 != current) break;
                this.state = 3786;
                return true;
            }
            case 3782: {
                if (59 == current) {
                    this.match = "\u2245";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 3783;
                return true;
            }
            case 3783: {
                if (111 != current) break;
                this.state = 3784;
                return true;
            }
            case 3784: {
                if (116 != current) break;
                this.state = 3785;
                return true;
            }
            case 3785: {
                if (59 != current) break;
                this.match = "\u2a6d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3786: {
                if (110 != current) break;
                this.state = 3787;
                return true;
            }
            case 3787: {
                if (116 != current) break;
                this.state = 3788;
                return true;
            }
            case 3788: {
                if (59 != current) break;
                this.match = "\u222e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3789: {
                switch (current) {
                    case 102: {
                        this.state = 3790;
                        return true;
                    }
                    case 114: {
                        this.state = 3791;
                        return true;
                    }
                    case 121: {
                        this.match = "\u00a9";
                        this.matchLength = this.consumedCount;
                        this.state = 3794;
                        return true;
                    }
                }
                break;
            }
            case 3790: {
                if (59 != current) break;
                this.match = "\ud835\udd54";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3791: {
                if (111 != current) break;
                this.state = 3792;
                return true;
            }
            case 3792: {
                if (100 != current) break;
                this.state = 3793;
                return true;
            }
            case 3793: {
                if (59 != current) break;
                this.match = "\u2210";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3794: {
                if (59 == current) {
                    this.match = "\u00a9";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (115 != current) break;
                this.state = 3795;
                return true;
            }
            case 3795: {
                if (114 != current) break;
                this.state = 3796;
                return true;
            }
            case 3796: {
                if (59 != current) break;
                this.match = "\u2117";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3797: {
                if (97 == current) {
                    this.state = 3798;
                    return true;
                }
                if (111 != current) break;
                this.state = 3801;
                return true;
            }
            case 3798: {
                if (114 != current) break;
                this.state = 3799;
                return true;
            }
            case 3799: {
                if (114 != current) break;
                this.state = 3800;
                return true;
            }
            case 3800: {
                if (59 != current) break;
                this.match = "\u21b5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3801: {
                if (115 != current) break;
                this.state = 3802;
                return true;
            }
            case 3802: {
                if (115 != current) break;
                this.state = 3803;
                return true;
            }
            case 3803: {
                if (59 != current) break;
                this.match = "\u2717";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3804: {
                if (99 == current) {
                    this.state = 3805;
                    return true;
                }
                if (117 != current) break;
                this.state = 3807;
                return true;
            }
            case 3805: {
                if (114 != current) break;
                this.state = 3806;
                return true;
            }
            case 3806: {
                if (59 != current) break;
                this.match = "\ud835\udcb8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3807: {
                if (98 == current) {
                    this.state = 3808;
                    return true;
                }
                if (112 != current) break;
                this.state = 3810;
                return true;
            }
            case 3808: {
                if (59 == current) {
                    this.match = "\u2acf";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3809;
                return true;
            }
            case 3809: {
                if (59 != current) break;
                this.match = "\u2ad1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3810: {
                if (59 == current) {
                    this.match = "\u2ad0";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 3811;
                return true;
            }
            case 3811: {
                if (59 != current) break;
                this.match = "\u2ad2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3812: {
                if (100 != current) break;
                this.state = 3813;
                return true;
            }
            case 3813: {
                if (111 != current) break;
                this.state = 3814;
                return true;
            }
            case 3814: {
                if (116 != current) break;
                this.state = 3815;
                return true;
            }
            case 3815: {
                if (59 != current) break;
                this.match = "\u22ef";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3816: {
                switch (current) {
                    case 100: {
                        this.state = 3817;
                        return true;
                    }
                    case 101: {
                        this.state = 3823;
                        return true;
                    }
                    case 108: {
                        this.state = 3828;
                        return true;
                    }
                    case 112: {
                        this.state = 3833;
                        return true;
                    }
                    case 114: {
                        this.state = 3850;
                        return true;
                    }
                    case 118: {
                        this.state = 3894;
                        return true;
                    }
                    case 119: {
                        this.state = 3897;
                        return true;
                    }
                }
                break;
            }
            case 3817: {
                if (97 != current) break;
                this.state = 3818;
                return true;
            }
            case 3818: {
                if (114 != current) break;
                this.state = 3819;
                return true;
            }
            case 3819: {
                if (114 != current) break;
                this.state = 3820;
                return true;
            }
            case 3820: {
                if (108 == current) {
                    this.state = 3821;
                    return true;
                }
                if (114 != current) break;
                this.state = 3822;
                return true;
            }
            case 3821: {
                if (59 != current) break;
                this.match = "\u2938";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3822: {
                if (59 != current) break;
                this.match = "\u2935";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3823: {
                if (112 == current) {
                    this.state = 3824;
                    return true;
                }
                if (115 != current) break;
                this.state = 3826;
                return true;
            }
            case 3824: {
                if (114 != current) break;
                this.state = 3825;
                return true;
            }
            case 3825: {
                if (59 != current) break;
                this.match = "\u22de";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3826: {
                if (99 != current) break;
                this.state = 3827;
                return true;
            }
            case 3827: {
                if (59 != current) break;
                this.match = "\u22df";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3828: {
                if (97 != current) break;
                this.state = 3829;
                return true;
            }
            case 3829: {
                if (114 != current) break;
                this.state = 3830;
                return true;
            }
            case 3830: {
                if (114 != current) break;
                this.state = 3831;
                return true;
            }
            case 3831: {
                if (59 == current) {
                    this.match = "\u21b6";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (112 != current) break;
                this.state = 3832;
                return true;
            }
            case 3832: {
                if (59 != current) break;
                this.match = "\u293d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3833: {
                switch (current) {
                    case 59: {
                        this.match = "\u222a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 98: {
                        this.state = 3834;
                        return true;
                    }
                    case 99: {
                        this.state = 3839;
                        return true;
                    }
                    case 100: {
                        this.state = 3844;
                        return true;
                    }
                    case 111: {
                        this.state = 3847;
                        return true;
                    }
                    case 115: {
                        this.state = 3849;
                        return true;
                    }
                }
                break;
            }
            case 3834: {
                if (114 != current) break;
                this.state = 3835;
                return true;
            }
            case 3835: {
                if (99 != current) break;
                this.state = 3836;
                return true;
            }
            case 3836: {
                if (97 != current) break;
                this.state = 3837;
                return true;
            }
            case 3837: {
                if (112 != current) break;
                this.state = 3838;
                return true;
            }
            case 3838: {
                if (59 != current) break;
                this.match = "\u2a48";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3839: {
                if (97 == current) {
                    this.state = 3840;
                    return true;
                }
                if (117 != current) break;
                this.state = 3842;
                return true;
            }
            case 3840: {
                if (112 != current) break;
                this.state = 3841;
                return true;
            }
            case 3841: {
                if (59 != current) break;
                this.match = "\u2a46";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3842: {
                if (112 != current) break;
                this.state = 3843;
                return true;
            }
            case 3843: {
                if (59 != current) break;
                this.match = "\u2a4a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3844: {
                if (111 != current) break;
                this.state = 3845;
                return true;
            }
            case 3845: {
                if (116 != current) break;
                this.state = 3846;
                return true;
            }
            case 3846: {
                if (59 != current) break;
                this.match = "\u228d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3847: {
                if (114 != current) break;
                this.state = 3848;
                return true;
            }
            case 3848: {
                if (59 != current) break;
                this.match = "\u2a45";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3849: {
                if (59 != current) break;
                this.match = "\u222a\ufe00";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3850: {
                switch (current) {
                    case 97: {
                        this.state = 3851;
                        return true;
                    }
                    case 108: {
                        this.state = 3855;
                        return true;
                    }
                    case 114: {
                        this.state = 3875;
                        return true;
                    }
                    case 118: {
                        this.state = 3878;
                        return true;
                    }
                }
                break;
            }
            case 3851: {
                if (114 != current) break;
                this.state = 3852;
                return true;
            }
            case 3852: {
                if (114 != current) break;
                this.state = 3853;
                return true;
            }
            case 3853: {
                if (59 == current) {
                    this.match = "\u21b7";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (109 != current) break;
                this.state = 3854;
                return true;
            }
            case 3854: {
                if (59 != current) break;
                this.match = "\u293c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3855: {
                if (121 != current) break;
                this.state = 3856;
                return true;
            }
            case 3856: {
                switch (current) {
                    case 101: {
                        this.state = 3857;
                        return true;
                    }
                    case 118: {
                        this.state = 3867;
                        return true;
                    }
                    case 119: {
                        this.state = 3870;
                        return true;
                    }
                }
                break;
            }
            case 3857: {
                if (113 != current) break;
                this.state = 3858;
                return true;
            }
            case 3858: {
                if (112 == current) {
                    this.state = 3859;
                    return true;
                }
                if (115 != current) break;
                this.state = 3863;
                return true;
            }
            case 3859: {
                if (114 != current) break;
                this.state = 3860;
                return true;
            }
            case 3860: {
                if (101 != current) break;
                this.state = 3861;
                return true;
            }
            case 3861: {
                if (99 != current) break;
                this.state = 3862;
                return true;
            }
            case 3862: {
                if (59 != current) break;
                this.match = "\u22de";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3863: {
                if (117 != current) break;
                this.state = 3864;
                return true;
            }
            case 3864: {
                if (99 != current) break;
                this.state = 3865;
                return true;
            }
            case 3865: {
                if (99 != current) break;
                this.state = 3866;
                return true;
            }
            case 3866: {
                if (59 != current) break;
                this.match = "\u22df";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3867: {
                if (101 != current) break;
                this.state = 3868;
                return true;
            }
            case 3868: {
                if (101 != current) break;
                this.state = 3869;
                return true;
            }
            case 3869: {
                if (59 != current) break;
                this.match = "\u22ce";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3870: {
                if (101 != current) break;
                this.state = 3871;
                return true;
            }
            case 3871: {
                if (100 != current) break;
                this.state = 3872;
                return true;
            }
            case 3872: {
                if (103 != current) break;
                this.state = 3873;
                return true;
            }
            case 3873: {
                if (101 != current) break;
                this.state = 3874;
                return true;
            }
            case 3874: {
                if (59 != current) break;
                this.match = "\u22cf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3875: {
                if (101 != current) break;
                this.state = 3876;
                return true;
            }
            case 3876: {
                if (110 != current) break;
                this.match = "\u00a4";
                this.matchLength = this.consumedCount;
                this.state = 3877;
                return true;
            }
            case 3877: {
                if (59 != current) break;
                this.match = "\u00a4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3878: {
                if (101 != current) break;
                this.state = 3879;
                return true;
            }
            case 3879: {
                if (97 != current) break;
                this.state = 3880;
                return true;
            }
            case 3880: {
                if (114 != current) break;
                this.state = 3881;
                return true;
            }
            case 3881: {
                if (114 != current) break;
                this.state = 3882;
                return true;
            }
            case 3882: {
                if (111 != current) break;
                this.state = 3883;
                return true;
            }
            case 3883: {
                if (119 != current) break;
                this.state = 3884;
                return true;
            }
            case 3884: {
                if (108 == current) {
                    this.state = 3885;
                    return true;
                }
                if (114 != current) break;
                this.state = 3889;
                return true;
            }
            case 3885: {
                if (101 != current) break;
                this.state = 3886;
                return true;
            }
            case 3886: {
                if (102 != current) break;
                this.state = 3887;
                return true;
            }
            case 3887: {
                if (116 != current) break;
                this.state = 3888;
                return true;
            }
            case 3888: {
                if (59 != current) break;
                this.match = "\u21b6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3889: {
                if (105 != current) break;
                this.state = 3890;
                return true;
            }
            case 3890: {
                if (103 != current) break;
                this.state = 3891;
                return true;
            }
            case 3891: {
                if (104 != current) break;
                this.state = 3892;
                return true;
            }
            case 3892: {
                if (116 != current) break;
                this.state = 3893;
                return true;
            }
            case 3893: {
                if (59 != current) break;
                this.match = "\u21b7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3894: {
                if (101 != current) break;
                this.state = 3895;
                return true;
            }
            case 3895: {
                if (101 != current) break;
                this.state = 3896;
                return true;
            }
            case 3896: {
                if (59 != current) break;
                this.match = "\u22ce";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3897: {
                if (101 != current) break;
                this.state = 3898;
                return true;
            }
            case 3898: {
                if (100 != current) break;
                this.state = 3899;
                return true;
            }
            case 3899: {
                if (59 != current) break;
                this.match = "\u22cf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3900: {
                if (99 == current) {
                    this.state = 3901;
                    return true;
                }
                if (105 != current) break;
                this.state = 3907;
                return true;
            }
            case 3901: {
                if (111 != current) break;
                this.state = 3902;
                return true;
            }
            case 3902: {
                if (110 != current) break;
                this.state = 3903;
                return true;
            }
            case 3903: {
                if (105 != current) break;
                this.state = 3904;
                return true;
            }
            case 3904: {
                if (110 != current) break;
                this.state = 3905;
                return true;
            }
            case 3905: {
                if (116 != current) break;
                this.state = 3906;
                return true;
            }
            case 3906: {
                if (59 != current) break;
                this.match = "\u2232";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3907: {
                if (110 != current) break;
                this.state = 3908;
                return true;
            }
            case 3908: {
                if (116 != current) break;
                this.state = 3909;
                return true;
            }
            case 3909: {
                if (59 != current) break;
                this.match = "\u2231";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3910: {
                if (108 != current) break;
                this.state = 3911;
                return true;
            }
            case 3911: {
                if (99 != current) break;
                this.state = 3912;
                return true;
            }
            case 3912: {
                if (116 != current) break;
                this.state = 3913;
                return true;
            }
            case 3913: {
                if (121 != current) break;
                this.state = 3914;
                return true;
            }
            case 3914: {
                if (59 != current) break;
                this.match = "\u232d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3915: {
                switch (current) {
                    case 65: {
                        this.state = 3916;
                        return true;
                    }
                    case 72: {
                        this.state = 3919;
                        return true;
                    }
                    case 97: {
                        this.state = 3922;
                        return true;
                    }
                    case 98: {
                        this.state = 3936;
                        return true;
                    }
                    case 99: {
                        this.state = 3945;
                        return true;
                    }
                    case 100: {
                        this.state = 3951;
                        return true;
                    }
                    case 101: {
                        this.state = 3964;
                        return true;
                    }
                    case 102: {
                        this.state = 3974;
                        return true;
                    }
                    case 104: {
                        this.state = 3980;
                        return true;
                    }
                    case 105: {
                        this.state = 3985;
                        return true;
                    }
                    case 106: {
                        this.state = 4019;
                        return true;
                    }
                    case 108: {
                        this.state = 4022;
                        return true;
                    }
                    case 111: {
                        this.state = 4030;
                        return true;
                    }
                    case 114: {
                        this.state = 4103;
                        return true;
                    }
                    case 115: {
                        this.state = 4117;
                        return true;
                    }
                    case 116: {
                        this.state = 4127;
                        return true;
                    }
                    case 117: {
                        this.state = 4134;
                        return true;
                    }
                    case 119: {
                        this.state = 4141;
                        return true;
                    }
                    case 122: {
                        this.state = 4147;
                        return true;
                    }
                }
                break;
            }
            case 3916: {
                if (114 != current) break;
                this.state = 3917;
                return true;
            }
            case 3917: {
                if (114 != current) break;
                this.state = 3918;
                return true;
            }
            case 3918: {
                if (59 != current) break;
                this.match = "\u21d3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3919: {
                if (97 != current) break;
                this.state = 3920;
                return true;
            }
            case 3920: {
                if (114 != current) break;
                this.state = 3921;
                return true;
            }
            case 3921: {
                if (59 != current) break;
                this.match = "\u2965";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3922: {
                switch (current) {
                    case 103: {
                        this.state = 3923;
                        return true;
                    }
                    case 108: {
                        this.state = 3927;
                        return true;
                    }
                    case 114: {
                        this.state = 3931;
                        return true;
                    }
                    case 115: {
                        this.state = 3933;
                        return true;
                    }
                }
                break;
            }
            case 3923: {
                if (103 != current) break;
                this.state = 3924;
                return true;
            }
            case 3924: {
                if (101 != current) break;
                this.state = 3925;
                return true;
            }
            case 3925: {
                if (114 != current) break;
                this.state = 3926;
                return true;
            }
            case 3926: {
                if (59 != current) break;
                this.match = "\u2020";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3927: {
                if (101 != current) break;
                this.state = 3928;
                return true;
            }
            case 3928: {
                if (116 != current) break;
                this.state = 3929;
                return true;
            }
            case 3929: {
                if (104 != current) break;
                this.state = 3930;
                return true;
            }
            case 3930: {
                if (59 != current) break;
                this.match = "\u2138";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3931: {
                if (114 != current) break;
                this.state = 3932;
                return true;
            }
            case 3932: {
                if (59 != current) break;
                this.match = "\u2193";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3933: {
                if (104 != current) break;
                this.state = 3934;
                return true;
            }
            case 3934: {
                if (59 == current) {
                    this.match = "\u2010";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (118 != current) break;
                this.state = 3935;
                return true;
            }
            case 3935: {
                if (59 != current) break;
                this.match = "\u22a3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3936: {
                if (107 == current) {
                    this.state = 3937;
                    return true;
                }
                if (108 != current) break;
                this.state = 3942;
                return true;
            }
            case 3937: {
                if (97 != current) break;
                this.state = 3938;
                return true;
            }
            case 3938: {
                if (114 != current) break;
                this.state = 3939;
                return true;
            }
            case 3939: {
                if (111 != current) break;
                this.state = 3940;
                return true;
            }
            case 3940: {
                if (119 != current) break;
                this.state = 3941;
                return true;
            }
            case 3941: {
                if (59 != current) break;
                this.match = "\u290f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3942: {
                if (97 != current) break;
                this.state = 3943;
                return true;
            }
            case 3943: {
                if (99 != current) break;
                this.state = 3944;
                return true;
            }
            case 3944: {
                if (59 != current) break;
                this.match = "\u02dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3945: {
                if (97 == current) {
                    this.state = 3946;
                    return true;
                }
                if (121 != current) break;
                this.state = 3950;
                return true;
            }
            case 3946: {
                if (114 != current) break;
                this.state = 3947;
                return true;
            }
            case 3947: {
                if (111 != current) break;
                this.state = 3948;
                return true;
            }
            case 3948: {
                if (110 != current) break;
                this.state = 3949;
                return true;
            }
            case 3949: {
                if (59 != current) break;
                this.match = "\u010f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3950: {
                if (59 != current) break;
                this.match = "\u0434";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3951: {
                switch (current) {
                    case 59: {
                        this.match = "\u2146";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 3952;
                        return true;
                    }
                    case 111: {
                        this.state = 3959;
                        return true;
                    }
                }
                break;
            }
            case 3952: {
                if (103 == current) {
                    this.state = 3953;
                    return true;
                }
                if (114 != current) break;
                this.state = 3957;
                return true;
            }
            case 3953: {
                if (103 != current) break;
                this.state = 3954;
                return true;
            }
            case 3954: {
                if (101 != current) break;
                this.state = 3955;
                return true;
            }
            case 3955: {
                if (114 != current) break;
                this.state = 3956;
                return true;
            }
            case 3956: {
                if (59 != current) break;
                this.match = "\u2021";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3957: {
                if (114 != current) break;
                this.state = 3958;
                return true;
            }
            case 3958: {
                if (59 != current) break;
                this.match = "\u21ca";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3959: {
                if (116 != current) break;
                this.state = 3960;
                return true;
            }
            case 3960: {
                if (115 != current) break;
                this.state = 3961;
                return true;
            }
            case 3961: {
                if (101 != current) break;
                this.state = 3962;
                return true;
            }
            case 3962: {
                if (113 != current) break;
                this.state = 3963;
                return true;
            }
            case 3963: {
                if (59 != current) break;
                this.match = "\u2a77";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3964: {
                switch (current) {
                    case 103: {
                        this.match = "\u00b0";
                        this.matchLength = this.consumedCount;
                        this.state = 3965;
                        return true;
                    }
                    case 108: {
                        this.state = 3966;
                        return true;
                    }
                    case 109: {
                        this.state = 3969;
                        return true;
                    }
                }
                break;
            }
            case 3965: {
                if (59 != current) break;
                this.match = "\u00b0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3966: {
                if (116 != current) break;
                this.state = 3967;
                return true;
            }
            case 3967: {
                if (97 != current) break;
                this.state = 3968;
                return true;
            }
            case 3968: {
                if (59 != current) break;
                this.match = "\u03b4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3969: {
                if (112 != current) break;
                this.state = 3970;
                return true;
            }
            case 3970: {
                if (116 != current) break;
                this.state = 3971;
                return true;
            }
            case 3971: {
                if (121 != current) break;
                this.state = 3972;
                return true;
            }
            case 3972: {
                if (118 != current) break;
                this.state = 3973;
                return true;
            }
            case 3973: {
                if (59 != current) break;
                this.match = "\u29b1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3974: {
                if (105 == current) {
                    this.state = 3975;
                    return true;
                }
                if (114 != current) break;
                this.state = 3979;
                return true;
            }
            case 3975: {
                if (115 != current) break;
                this.state = 3976;
                return true;
            }
            case 3976: {
                if (104 != current) break;
                this.state = 3977;
                return true;
            }
            case 3977: {
                if (116 != current) break;
                this.state = 3978;
                return true;
            }
            case 3978: {
                if (59 != current) break;
                this.match = "\u297f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3979: {
                if (59 != current) break;
                this.match = "\ud835\udd21";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3980: {
                if (97 != current) break;
                this.state = 3981;
                return true;
            }
            case 3981: {
                if (114 != current) break;
                this.state = 3982;
                return true;
            }
            case 3982: {
                if (108 == current) {
                    this.state = 3983;
                    return true;
                }
                if (114 != current) break;
                this.state = 3984;
                return true;
            }
            case 3983: {
                if (59 != current) break;
                this.match = "\u21c3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3984: {
                if (59 != current) break;
                this.match = "\u21c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3985: {
                switch (current) {
                    case 97: {
                        this.state = 3986;
                        return true;
                    }
                    case 101: {
                        this.state = 3996;
                        return true;
                    }
                    case 103: {
                        this.state = 3997;
                        return true;
                    }
                    case 115: {
                        this.state = 4002;
                        return true;
                    }
                    case 118: {
                        this.state = 4005;
                        return true;
                    }
                }
                break;
            }
            case 3986: {
                if (109 != current) break;
                this.state = 3987;
                return true;
            }
            case 3987: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 111: {
                        this.state = 3988;
                        return true;
                    }
                    case 115: {
                        this.state = 3995;
                        return true;
                    }
                }
                break;
            }
            case 3988: {
                if (110 != current) break;
                this.state = 3989;
                return true;
            }
            case 3989: {
                if (100 != current) break;
                this.state = 3990;
                return true;
            }
            case 3990: {
                if (59 == current) {
                    this.match = "\u22c4";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (115 != current) break;
                this.state = 3991;
                return true;
            }
            case 3991: {
                if (117 != current) break;
                this.state = 3992;
                return true;
            }
            case 3992: {
                if (105 != current) break;
                this.state = 3993;
                return true;
            }
            case 3993: {
                if (116 != current) break;
                this.state = 3994;
                return true;
            }
            case 3994: {
                if (59 != current) break;
                this.match = "\u2666";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3995: {
                if (59 != current) break;
                this.match = "\u2666";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3996: {
                if (59 != current) break;
                this.match = "\u00a8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 3997: {
                if (97 != current) break;
                this.state = 3998;
                return true;
            }
            case 3998: {
                if (109 != current) break;
                this.state = 3999;
                return true;
            }
            case 3999: {
                if (109 != current) break;
                this.state = 4000;
                return true;
            }
        }
        return false;
    }

    private boolean parse5(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 4000: {
                if (97 != current) break;
                this.state = 4001;
                return true;
            }
            case 4001: {
                if (59 != current) break;
                this.match = "\u03dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4002: {
                if (105 != current) break;
                this.state = 4003;
                return true;
            }
            case 4003: {
                if (110 != current) break;
                this.state = 4004;
                return true;
            }
            case 4004: {
                if (59 != current) break;
                this.match = "\u22f2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4005: {
                switch (current) {
                    case 59: {
                        this.match = "\u00f7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 105: {
                        this.state = 4006;
                        return true;
                    }
                    case 111: {
                        this.state = 4016;
                        return true;
                    }
                }
                break;
            }
            case 4006: {
                if (100 != current) break;
                this.state = 4007;
                return true;
            }
            case 4007: {
                if (101 != current) break;
                this.match = "\u00f7";
                this.matchLength = this.consumedCount;
                this.state = 4008;
                return true;
            }
            case 4008: {
                if (59 == current) {
                    this.match = "\u00f7";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (111 != current) break;
                this.state = 4009;
                return true;
            }
            case 4009: {
                if (110 != current) break;
                this.state = 4010;
                return true;
            }
            case 4010: {
                if (116 != current) break;
                this.state = 4011;
                return true;
            }
            case 4011: {
                if (105 != current) break;
                this.state = 4012;
                return true;
            }
            case 4012: {
                if (109 != current) break;
                this.state = 4013;
                return true;
            }
            case 4013: {
                if (101 != current) break;
                this.state = 4014;
                return true;
            }
            case 4014: {
                if (115 != current) break;
                this.state = 4015;
                return true;
            }
            case 4015: {
                if (59 != current) break;
                this.match = "\u22c7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4016: {
                if (110 != current) break;
                this.state = 4017;
                return true;
            }
            case 4017: {
                if (120 != current) break;
                this.state = 4018;
                return true;
            }
            case 4018: {
                if (59 != current) break;
                this.match = "\u22c7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4019: {
                if (99 != current) break;
                this.state = 4020;
                return true;
            }
            case 4020: {
                if (121 != current) break;
                this.state = 4021;
                return true;
            }
            case 4021: {
                if (59 != current) break;
                this.match = "\u0452";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4022: {
                if (99 != current) break;
                this.state = 4023;
                return true;
            }
            case 4023: {
                if (111 == current) {
                    this.state = 4024;
                    return true;
                }
                if (114 != current) break;
                this.state = 4027;
                return true;
            }
            case 4024: {
                if (114 != current) break;
                this.state = 4025;
                return true;
            }
            case 4025: {
                if (110 != current) break;
                this.state = 4026;
                return true;
            }
            case 4026: {
                if (59 != current) break;
                this.match = "\u231e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4027: {
                if (111 != current) break;
                this.state = 4028;
                return true;
            }
            case 4028: {
                if (112 != current) break;
                this.state = 4029;
                return true;
            }
            case 4029: {
                if (59 != current) break;
                this.match = "\u230d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4030: {
                switch (current) {
                    case 108: {
                        this.state = 4031;
                        return true;
                    }
                    case 112: {
                        this.state = 4035;
                        return true;
                    }
                    case 116: {
                        this.state = 4037;
                        return true;
                    }
                    case 117: {
                        this.state = 4058;
                        return true;
                    }
                    case 119: {
                        this.state = 4070;
                        return true;
                    }
                }
                break;
            }
            case 4031: {
                if (108 != current) break;
                this.state = 4032;
                return true;
            }
            case 4032: {
                if (97 != current) break;
                this.state = 4033;
                return true;
            }
            case 4033: {
                if (114 != current) break;
                this.state = 4034;
                return true;
            }
            case 4034: {
                if (59 != current) break;
                this.match = "$";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4035: {
                if (102 != current) break;
                this.state = 4036;
                return true;
            }
            case 4036: {
                if (59 != current) break;
                this.match = "\ud835\udd55";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4037: {
                switch (current) {
                    case 59: {
                        this.match = "\u02d9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 4038;
                        return true;
                    }
                    case 109: {
                        this.state = 4043;
                        return true;
                    }
                    case 112: {
                        this.state = 4048;
                        return true;
                    }
                    case 115: {
                        this.state = 4052;
                        return true;
                    }
                }
                break;
            }
            case 4038: {
                if (113 != current) break;
                this.state = 4039;
                return true;
            }
            case 4039: {
                if (59 == current) {
                    this.match = "\u2250";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 4040;
                return true;
            }
            case 4040: {
                if (111 != current) break;
                this.state = 4041;
                return true;
            }
            case 4041: {
                if (116 != current) break;
                this.state = 4042;
                return true;
            }
            case 4042: {
                if (59 != current) break;
                this.match = "\u2251";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4043: {
                if (105 != current) break;
                this.state = 4044;
                return true;
            }
            case 4044: {
                if (110 != current) break;
                this.state = 4045;
                return true;
            }
            case 4045: {
                if (117 != current) break;
                this.state = 4046;
                return true;
            }
            case 4046: {
                if (115 != current) break;
                this.state = 4047;
                return true;
            }
            case 4047: {
                if (59 != current) break;
                this.match = "\u2238";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4048: {
                if (108 != current) break;
                this.state = 4049;
                return true;
            }
            case 4049: {
                if (117 != current) break;
                this.state = 4050;
                return true;
            }
            case 4050: {
                if (115 != current) break;
                this.state = 4051;
                return true;
            }
            case 4051: {
                if (59 != current) break;
                this.match = "\u2214";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4052: {
                if (113 != current) break;
                this.state = 4053;
                return true;
            }
            case 4053: {
                if (117 != current) break;
                this.state = 4054;
                return true;
            }
            case 4054: {
                if (97 != current) break;
                this.state = 4055;
                return true;
            }
            case 4055: {
                if (114 != current) break;
                this.state = 4056;
                return true;
            }
            case 4056: {
                if (101 != current) break;
                this.state = 4057;
                return true;
            }
            case 4057: {
                if (59 != current) break;
                this.match = "\u22a1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4058: {
                if (98 != current) break;
                this.state = 4059;
                return true;
            }
            case 4059: {
                if (108 != current) break;
                this.state = 4060;
                return true;
            }
            case 4060: {
                if (101 != current) break;
                this.state = 4061;
                return true;
            }
            case 4061: {
                if (98 != current) break;
                this.state = 4062;
                return true;
            }
            case 4062: {
                if (97 != current) break;
                this.state = 4063;
                return true;
            }
            case 4063: {
                if (114 != current) break;
                this.state = 4064;
                return true;
            }
            case 4064: {
                if (119 != current) break;
                this.state = 4065;
                return true;
            }
            case 4065: {
                if (101 != current) break;
                this.state = 4066;
                return true;
            }
            case 4066: {
                if (100 != current) break;
                this.state = 4067;
                return true;
            }
            case 4067: {
                if (103 != current) break;
                this.state = 4068;
                return true;
            }
            case 4068: {
                if (101 != current) break;
                this.state = 4069;
                return true;
            }
            case 4069: {
                if (59 != current) break;
                this.match = "\u2306";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4070: {
                if (110 != current) break;
                this.state = 4071;
                return true;
            }
            case 4071: {
                switch (current) {
                    case 97: {
                        this.state = 4072;
                        return true;
                    }
                    case 100: {
                        this.state = 4077;
                        return true;
                    }
                    case 104: {
                        this.state = 4087;
                        return true;
                    }
                }
                break;
            }
            case 4072: {
                if (114 != current) break;
                this.state = 4073;
                return true;
            }
            case 4073: {
                if (114 != current) break;
                this.state = 4074;
                return true;
            }
            case 4074: {
                if (111 != current) break;
                this.state = 4075;
                return true;
            }
            case 4075: {
                if (119 != current) break;
                this.state = 4076;
                return true;
            }
            case 4076: {
                if (59 != current) break;
                this.match = "\u2193";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4077: {
                if (111 != current) break;
                this.state = 4078;
                return true;
            }
            case 4078: {
                if (119 != current) break;
                this.state = 4079;
                return true;
            }
            case 4079: {
                if (110 != current) break;
                this.state = 4080;
                return true;
            }
            case 4080: {
                if (97 != current) break;
                this.state = 4081;
                return true;
            }
            case 4081: {
                if (114 != current) break;
                this.state = 4082;
                return true;
            }
            case 4082: {
                if (114 != current) break;
                this.state = 4083;
                return true;
            }
            case 4083: {
                if (111 != current) break;
                this.state = 4084;
                return true;
            }
            case 4084: {
                if (119 != current) break;
                this.state = 4085;
                return true;
            }
            case 4085: {
                if (115 != current) break;
                this.state = 4086;
                return true;
            }
            case 4086: {
                if (59 != current) break;
                this.match = "\u21ca";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4087: {
                if (97 != current) break;
                this.state = 4088;
                return true;
            }
            case 4088: {
                if (114 != current) break;
                this.state = 4089;
                return true;
            }
            case 4089: {
                if (112 != current) break;
                this.state = 4090;
                return true;
            }
            case 4090: {
                if (111 != current) break;
                this.state = 4091;
                return true;
            }
            case 4091: {
                if (111 != current) break;
                this.state = 4092;
                return true;
            }
            case 4092: {
                if (110 != current) break;
                this.state = 4093;
                return true;
            }
            case 4093: {
                if (108 == current) {
                    this.state = 4094;
                    return true;
                }
                if (114 != current) break;
                this.state = 4098;
                return true;
            }
            case 4094: {
                if (101 != current) break;
                this.state = 4095;
                return true;
            }
            case 4095: {
                if (102 != current) break;
                this.state = 4096;
                return true;
            }
            case 4096: {
                if (116 != current) break;
                this.state = 4097;
                return true;
            }
            case 4097: {
                if (59 != current) break;
                this.match = "\u21c3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4098: {
                if (105 != current) break;
                this.state = 4099;
                return true;
            }
            case 4099: {
                if (103 != current) break;
                this.state = 4100;
                return true;
            }
            case 4100: {
                if (104 != current) break;
                this.state = 4101;
                return true;
            }
            case 4101: {
                if (116 != current) break;
                this.state = 4102;
                return true;
            }
            case 4102: {
                if (59 != current) break;
                this.match = "\u21c2";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4103: {
                if (98 == current) {
                    this.state = 4104;
                    return true;
                }
                if (99 != current) break;
                this.state = 4110;
                return true;
            }
            case 4104: {
                if (107 != current) break;
                this.state = 4105;
                return true;
            }
            case 4105: {
                if (97 != current) break;
                this.state = 4106;
                return true;
            }
            case 4106: {
                if (114 != current) break;
                this.state = 4107;
                return true;
            }
            case 4107: {
                if (111 != current) break;
                this.state = 4108;
                return true;
            }
            case 4108: {
                if (119 != current) break;
                this.state = 4109;
                return true;
            }
            case 4109: {
                if (59 != current) break;
                this.match = "\u2910";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4110: {
                if (111 == current) {
                    this.state = 4111;
                    return true;
                }
                if (114 != current) break;
                this.state = 4114;
                return true;
            }
            case 4111: {
                if (114 != current) break;
                this.state = 4112;
                return true;
            }
            case 4112: {
                if (110 != current) break;
                this.state = 4113;
                return true;
            }
            case 4113: {
                if (59 != current) break;
                this.match = "\u231f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4114: {
                if (111 != current) break;
                this.state = 4115;
                return true;
            }
            case 4115: {
                if (112 != current) break;
                this.state = 4116;
                return true;
            }
            case 4116: {
                if (59 != current) break;
                this.match = "\u230c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4117: {
                switch (current) {
                    case 99: {
                        this.state = 4118;
                        return true;
                    }
                    case 111: {
                        this.state = 4121;
                        return true;
                    }
                    case 116: {
                        this.state = 4123;
                        return true;
                    }
                }
                break;
            }
            case 4118: {
                if (114 == current) {
                    this.state = 4119;
                    return true;
                }
                if (121 != current) break;
                this.state = 4120;
                return true;
            }
            case 4119: {
                if (59 != current) break;
                this.match = "\ud835\udcb9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4120: {
                if (59 != current) break;
                this.match = "\u0455";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4121: {
                if (108 != current) break;
                this.state = 4122;
                return true;
            }
            case 4122: {
                if (59 != current) break;
                this.match = "\u29f6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4123: {
                if (114 != current) break;
                this.state = 4124;
                return true;
            }
            case 4124: {
                if (111 != current) break;
                this.state = 4125;
                return true;
            }
            case 4125: {
                if (107 != current) break;
                this.state = 4126;
                return true;
            }
            case 4126: {
                if (59 != current) break;
                this.match = "\u0111";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4127: {
                if (100 == current) {
                    this.state = 4128;
                    return true;
                }
                if (114 != current) break;
                this.state = 4131;
                return true;
            }
            case 4128: {
                if (111 != current) break;
                this.state = 4129;
                return true;
            }
            case 4129: {
                if (116 != current) break;
                this.state = 4130;
                return true;
            }
            case 4130: {
                if (59 != current) break;
                this.match = "\u22f1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4131: {
                if (105 != current) break;
                this.state = 4132;
                return true;
            }
            case 4132: {
                if (59 == current) {
                    this.match = "\u25bf";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (102 != current) break;
                this.state = 4133;
                return true;
            }
            case 4133: {
                if (59 != current) break;
                this.match = "\u25be";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4134: {
                if (97 == current) {
                    this.state = 4135;
                    return true;
                }
                if (104 != current) break;
                this.state = 4138;
                return true;
            }
            case 4135: {
                if (114 != current) break;
                this.state = 4136;
                return true;
            }
            case 4136: {
                if (114 != current) break;
                this.state = 4137;
                return true;
            }
            case 4137: {
                if (59 != current) break;
                this.match = "\u21f5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4138: {
                if (97 != current) break;
                this.state = 4139;
                return true;
            }
            case 4139: {
                if (114 != current) break;
                this.state = 4140;
                return true;
            }
            case 4140: {
                if (59 != current) break;
                this.match = "\u296f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4141: {
                if (97 != current) break;
                this.state = 4142;
                return true;
            }
            case 4142: {
                if (110 != current) break;
                this.state = 4143;
                return true;
            }
            case 4143: {
                if (103 != current) break;
                this.state = 4144;
                return true;
            }
            case 4144: {
                if (108 != current) break;
                this.state = 4145;
                return true;
            }
            case 4145: {
                if (101 != current) break;
                this.state = 4146;
                return true;
            }
            case 4146: {
                if (59 != current) break;
                this.match = "\u29a6";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4147: {
                if (99 == current) {
                    this.state = 4148;
                    return true;
                }
                if (105 != current) break;
                this.state = 4150;
                return true;
            }
            case 4148: {
                if (121 != current) break;
                this.state = 4149;
                return true;
            }
            case 4149: {
                if (59 != current) break;
                this.match = "\u045f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4150: {
                if (103 != current) break;
                this.state = 4151;
                return true;
            }
            case 4151: {
                if (114 != current) break;
                this.state = 4152;
                return true;
            }
            case 4152: {
                if (97 != current) break;
                this.state = 4153;
                return true;
            }
            case 4153: {
                if (114 != current) break;
                this.state = 4154;
                return true;
            }
            case 4154: {
                if (114 != current) break;
                this.state = 4155;
                return true;
            }
            case 4155: {
                if (59 != current) break;
                this.match = "\u27ff";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4156: {
                switch (current) {
                    case 68: {
                        this.state = 4157;
                        return true;
                    }
                    case 97: {
                        this.state = 4163;
                        return true;
                    }
                    case 99: {
                        this.state = 4172;
                        return true;
                    }
                    case 100: {
                        this.state = 4185;
                        return true;
                    }
                    case 101: {
                        this.state = 4188;
                        return true;
                    }
                    case 102: {
                        this.state = 4189;
                        return true;
                    }
                    case 103: {
                        this.state = 4194;
                        return true;
                    }
                    case 108: {
                        this.state = 4203;
                        return true;
                    }
                    case 109: {
                        this.state = 4215;
                        return true;
                    }
                    case 110: {
                        this.state = 4231;
                        return true;
                    }
                    case 111: {
                        this.state = 4235;
                        return true;
                    }
                    case 112: {
                        this.state = 4241;
                        return true;
                    }
                    case 113: {
                        this.state = 4255;
                        return true;
                    }
                    case 114: {
                        this.state = 4295;
                        return true;
                    }
                    case 115: {
                        this.state = 4302;
                        return true;
                    }
                    case 116: {
                        this.state = 4310;
                        return true;
                    }
                    case 117: {
                        this.state = 4313;
                        return true;
                    }
                    case 120: {
                        this.state = 4318;
                        return true;
                    }
                }
                break;
            }
            case 4157: {
                if (68 == current) {
                    this.state = 4158;
                    return true;
                }
                if (111 != current) break;
                this.state = 4161;
                return true;
            }
            case 4158: {
                if (111 != current) break;
                this.state = 4159;
                return true;
            }
            case 4159: {
                if (116 != current) break;
                this.state = 4160;
                return true;
            }
            case 4160: {
                if (59 != current) break;
                this.match = "\u2a77";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4161: {
                if (116 != current) break;
                this.state = 4162;
                return true;
            }
            case 4162: {
                if (59 != current) break;
                this.match = "\u2251";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4163: {
                if (99 == current) {
                    this.state = 4164;
                    return true;
                }
                if (115 != current) break;
                this.state = 4168;
                return true;
            }
            case 4164: {
                if (117 != current) break;
                this.state = 4165;
                return true;
            }
            case 4165: {
                if (116 != current) break;
                this.state = 4166;
                return true;
            }
            case 4166: {
                if (101 != current) break;
                this.match = "\u00e9";
                this.matchLength = this.consumedCount;
                this.state = 4167;
                return true;
            }
            case 4167: {
                if (59 != current) break;
                this.match = "\u00e9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4168: {
                if (116 != current) break;
                this.state = 4169;
                return true;
            }
            case 4169: {
                if (101 != current) break;
                this.state = 4170;
                return true;
            }
            case 4170: {
                if (114 != current) break;
                this.state = 4171;
                return true;
            }
            case 4171: {
                if (59 != current) break;
                this.match = "\u2a6e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4172: {
                switch (current) {
                    case 97: {
                        this.state = 4173;
                        return true;
                    }
                    case 105: {
                        this.state = 4177;
                        return true;
                    }
                    case 111: {
                        this.state = 4180;
                        return true;
                    }
                    case 121: {
                        this.state = 4184;
                        return true;
                    }
                }
                break;
            }
            case 4173: {
                if (114 != current) break;
                this.state = 4174;
                return true;
            }
            case 4174: {
                if (111 != current) break;
                this.state = 4175;
                return true;
            }
            case 4175: {
                if (110 != current) break;
                this.state = 4176;
                return true;
            }
            case 4176: {
                if (59 != current) break;
                this.match = "\u011b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4177: {
                if (114 != current) break;
                this.state = 4178;
                return true;
            }
            case 4178: {
                if (59 == current) {
                    this.match = "\u2256";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (99 != current) break;
                this.match = "\u00ea";
                this.matchLength = this.consumedCount;
                this.state = 4179;
                return true;
            }
            case 4179: {
                if (59 != current) break;
                this.match = "\u00ea";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4180: {
                if (108 != current) break;
                this.state = 4181;
                return true;
            }
            case 4181: {
                if (111 != current) break;
                this.state = 4182;
                return true;
            }
            case 4182: {
                if (110 != current) break;
                this.state = 4183;
                return true;
            }
            case 4183: {
                if (59 != current) break;
                this.match = "\u2255";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4184: {
                if (59 != current) break;
                this.match = "\u044d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4185: {
                if (111 != current) break;
                this.state = 4186;
                return true;
            }
            case 4186: {
                if (116 != current) break;
                this.state = 4187;
                return true;
            }
            case 4187: {
                if (59 != current) break;
                this.match = "\u0117";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4188: {
                if (59 != current) break;
                this.match = "\u2147";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4189: {
                if (68 == current) {
                    this.state = 4190;
                    return true;
                }
                if (114 != current) break;
                this.state = 4193;
                return true;
            }
            case 4190: {
                if (111 != current) break;
                this.state = 4191;
                return true;
            }
            case 4191: {
                if (116 != current) break;
                this.state = 4192;
                return true;
            }
            case 4192: {
                if (59 != current) break;
                this.match = "\u2252";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4193: {
                if (59 != current) break;
                this.match = "\ud835\udd22";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4194: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a9a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 114: {
                        this.state = 4195;
                        return true;
                    }
                    case 115: {
                        this.state = 4199;
                        return true;
                    }
                }
                break;
            }
            case 4195: {
                if (97 != current) break;
                this.state = 4196;
                return true;
            }
            case 4196: {
                if (118 != current) break;
                this.state = 4197;
                return true;
            }
            case 4197: {
                if (101 != current) break;
                this.match = "\u00e8";
                this.matchLength = this.consumedCount;
                this.state = 4198;
                return true;
            }
            case 4198: {
                if (59 != current) break;
                this.match = "\u00e8";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4199: {
                if (59 == current) {
                    this.match = "\u2a96";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 4200;
                return true;
            }
            case 4200: {
                if (111 != current) break;
                this.state = 4201;
                return true;
            }
            case 4201: {
                if (116 != current) break;
                this.state = 4202;
                return true;
            }
            case 4202: {
                if (59 != current) break;
                this.match = "\u2a98";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4203: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a99";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 105: {
                        this.state = 4204;
                        return true;
                    }
                    case 108: {
                        this.state = 4210;
                        return true;
                    }
                    case 115: {
                        this.state = 4211;
                        return true;
                    }
                }
                break;
            }
            case 4204: {
                if (110 != current) break;
                this.state = 4205;
                return true;
            }
            case 4205: {
                if (116 != current) break;
                this.state = 4206;
                return true;
            }
            case 4206: {
                if (101 != current) break;
                this.state = 4207;
                return true;
            }
            case 4207: {
                if (114 != current) break;
                this.state = 4208;
                return true;
            }
            case 4208: {
                if (115 != current) break;
                this.state = 4209;
                return true;
            }
            case 4209: {
                if (59 != current) break;
                this.match = "\u23e7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4210: {
                if (59 != current) break;
                this.match = "\u2113";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4211: {
                if (59 == current) {
                    this.match = "\u2a95";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 4212;
                return true;
            }
            case 4212: {
                if (111 != current) break;
                this.state = 4213;
                return true;
            }
            case 4213: {
                if (116 != current) break;
                this.state = 4214;
                return true;
            }
            case 4214: {
                if (59 != current) break;
                this.match = "\u2a97";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4215: {
                switch (current) {
                    case 97: {
                        this.state = 4216;
                        return true;
                    }
                    case 112: {
                        this.state = 4219;
                        return true;
                    }
                    case 115: {
                        this.state = 4226;
                        return true;
                    }
                }
                break;
            }
            case 4216: {
                if (99 != current) break;
                this.state = 4217;
                return true;
            }
            case 4217: {
                if (114 != current) break;
                this.state = 4218;
                return true;
            }
            case 4218: {
                if (59 != current) break;
                this.match = "\u0113";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4219: {
                if (116 != current) break;
                this.state = 4220;
                return true;
            }
            case 4220: {
                if (121 != current) break;
                this.state = 4221;
                return true;
            }
            case 4221: {
                switch (current) {
                    case 59: {
                        this.match = "\u2205";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 115: {
                        this.state = 4222;
                        return true;
                    }
                    case 118: {
                        this.state = 4225;
                        return true;
                    }
                }
                break;
            }
            case 4222: {
                if (101 != current) break;
                this.state = 4223;
                return true;
            }
            case 4223: {
                if (116 != current) break;
                this.state = 4224;
                return true;
            }
            case 4224: {
                if (59 != current) break;
                this.match = "\u2205";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4225: {
                if (59 != current) break;
                this.match = "\u2205";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4226: {
                if (112 != current) break;
                this.state = 4227;
                return true;
            }
            case 4227: {
                if (49 == current) {
                    this.state = 4228;
                    return true;
                }
                if (59 != current) break;
                this.match = "\u2003";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4228: {
                if (51 == current) {
                    this.state = 4229;
                    return true;
                }
                if (52 != current) break;
                this.state = 4230;
                return true;
            }
            case 4229: {
                if (59 != current) break;
                this.match = "\u2004";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4230: {
                if (59 != current) break;
                this.match = "\u2005";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4231: {
                if (103 == current) {
                    this.state = 4232;
                    return true;
                }
                if (115 != current) break;
                this.state = 4233;
                return true;
            }
            case 4232: {
                if (59 != current) break;
                this.match = "\u014b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4233: {
                if (112 != current) break;
                this.state = 4234;
                return true;
            }
            case 4234: {
                if (59 != current) break;
                this.match = "\u2002";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4235: {
                if (103 == current) {
                    this.state = 4236;
                    return true;
                }
                if (112 != current) break;
                this.state = 4239;
                return true;
            }
            case 4236: {
                if (111 != current) break;
                this.state = 4237;
                return true;
            }
            case 4237: {
                if (110 != current) break;
                this.state = 4238;
                return true;
            }
            case 4238: {
                if (59 != current) break;
                this.match = "\u0119";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4239: {
                if (102 != current) break;
                this.state = 4240;
                return true;
            }
            case 4240: {
                if (59 != current) break;
                this.match = "\ud835\udd56";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4241: {
                switch (current) {
                    case 97: {
                        this.state = 4242;
                        return true;
                    }
                    case 108: {
                        this.state = 4246;
                        return true;
                    }
                    case 115: {
                        this.state = 4249;
                        return true;
                    }
                }
                break;
            }
            case 4242: {
                if (114 != current) break;
                this.state = 4243;
                return true;
            }
            case 4243: {
                if (59 == current) {
                    this.match = "\u22d5";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (115 != current) break;
                this.state = 4244;
                return true;
            }
            case 4244: {
                if (108 != current) break;
                this.state = 4245;
                return true;
            }
            case 4245: {
                if (59 != current) break;
                this.match = "\u29e3";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4246: {
                if (117 != current) break;
                this.state = 4247;
                return true;
            }
            case 4247: {
                if (115 != current) break;
                this.state = 4248;
                return true;
            }
            case 4248: {
                if (59 != current) break;
                this.match = "\u2a71";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4249: {
                if (105 != current) break;
                this.state = 4250;
                return true;
            }
            case 4250: {
                switch (current) {
                    case 59: {
                        this.match = "\u03b5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 108: {
                        this.state = 4251;
                        return true;
                    }
                    case 118: {
                        this.state = 4254;
                        return true;
                    }
                }
                break;
            }
            case 4251: {
                if (111 != current) break;
                this.state = 4252;
                return true;
            }
            case 4252: {
                if (110 != current) break;
                this.state = 4253;
                return true;
            }
            case 4253: {
                if (59 != current) break;
                this.match = "\u03b5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4254: {
                if (59 != current) break;
                this.match = "\u03f5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4255: {
                switch (current) {
                    case 99: {
                        this.state = 4256;
                        return true;
                    }
                    case 115: {
                        this.state = 4264;
                        return true;
                    }
                    case 117: {
                        this.state = 4278;
                        return true;
                    }
                    case 118: {
                        this.state = 4289;
                        return true;
                    }
                }
                break;
            }
            case 4256: {
                if (105 == current) {
                    this.state = 4257;
                    return true;
                }
                if (111 != current) break;
                this.state = 4260;
                return true;
            }
            case 4257: {
                if (114 != current) break;
                this.state = 4258;
                return true;
            }
            case 4258: {
                if (99 != current) break;
                this.state = 4259;
                return true;
            }
            case 4259: {
                if (59 != current) break;
                this.match = "\u2256";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4260: {
                if (108 != current) break;
                this.state = 4261;
                return true;
            }
            case 4261: {
                if (111 != current) break;
                this.state = 4262;
                return true;
            }
            case 4262: {
                if (110 != current) break;
                this.state = 4263;
                return true;
            }
            case 4263: {
                if (59 != current) break;
                this.match = "\u2255";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4264: {
                if (105 == current) {
                    this.state = 4265;
                    return true;
                }
                if (108 != current) break;
                this.state = 4267;
                return true;
            }
            case 4265: {
                if (109 != current) break;
                this.state = 4266;
                return true;
            }
            case 4266: {
                if (59 != current) break;
                this.match = "\u2242";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4267: {
                if (97 != current) break;
                this.state = 4268;
                return true;
            }
            case 4268: {
                if (110 != current) break;
                this.state = 4269;
                return true;
            }
            case 4269: {
                if (116 != current) break;
                this.state = 4270;
                return true;
            }
            case 4270: {
                if (103 == current) {
                    this.state = 4271;
                    return true;
                }
                if (108 != current) break;
                this.state = 4274;
                return true;
            }
            case 4271: {
                if (116 != current) break;
                this.state = 4272;
                return true;
            }
            case 4272: {
                if (114 != current) break;
                this.state = 4273;
                return true;
            }
            case 4273: {
                if (59 != current) break;
                this.match = "\u2a96";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4274: {
                if (101 != current) break;
                this.state = 4275;
                return true;
            }
            case 4275: {
                if (115 != current) break;
                this.state = 4276;
                return true;
            }
            case 4276: {
                if (115 != current) break;
                this.state = 4277;
                return true;
            }
            case 4277: {
                if (59 != current) break;
                this.match = "\u2a95";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4278: {
                switch (current) {
                    case 97: {
                        this.state = 4279;
                        return true;
                    }
                    case 101: {
                        this.state = 4282;
                        return true;
                    }
                    case 105: {
                        this.state = 4285;
                        return true;
                    }
                }
                break;
            }
            case 4279: {
                if (108 != current) break;
                this.state = 4280;
                return true;
            }
            case 4280: {
                if (115 != current) break;
                this.state = 4281;
                return true;
            }
            case 4281: {
                if (59 != current) break;
                this.match = "=";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4282: {
                if (115 != current) break;
                this.state = 4283;
                return true;
            }
            case 4283: {
                if (116 != current) break;
                this.state = 4284;
                return true;
            }
            case 4284: {
                if (59 != current) break;
                this.match = "\u225f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4285: {
                if (118 != current) break;
                this.state = 4286;
                return true;
            }
            case 4286: {
                if (59 == current) {
                    this.match = "\u2261";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (68 != current) break;
                this.state = 4287;
                return true;
            }
            case 4287: {
                if (68 != current) break;
                this.state = 4288;
                return true;
            }
            case 4288: {
                if (59 != current) break;
                this.match = "\u2a78";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4289: {
                if (112 != current) break;
                this.state = 4290;
                return true;
            }
            case 4290: {
                if (97 != current) break;
                this.state = 4291;
                return true;
            }
            case 4291: {
                if (114 != current) break;
                this.state = 4292;
                return true;
            }
            case 4292: {
                if (115 != current) break;
                this.state = 4293;
                return true;
            }
            case 4293: {
                if (108 != current) break;
                this.state = 4294;
                return true;
            }
            case 4294: {
                if (59 != current) break;
                this.match = "\u29e5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4295: {
                if (68 == current) {
                    this.state = 4296;
                    return true;
                }
                if (97 != current) break;
                this.state = 4299;
                return true;
            }
            case 4296: {
                if (111 != current) break;
                this.state = 4297;
                return true;
            }
            case 4297: {
                if (116 != current) break;
                this.state = 4298;
                return true;
            }
            case 4298: {
                if (59 != current) break;
                this.match = "\u2253";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4299: {
                if (114 != current) break;
                this.state = 4300;
                return true;
            }
            case 4300: {
                if (114 != current) break;
                this.state = 4301;
                return true;
            }
            case 4301: {
                if (59 != current) break;
                this.match = "\u2971";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4302: {
                switch (current) {
                    case 99: {
                        this.state = 4303;
                        return true;
                    }
                    case 100: {
                        this.state = 4305;
                        return true;
                    }
                    case 105: {
                        this.state = 4308;
                        return true;
                    }
                }
                break;
            }
            case 4303: {
                if (114 != current) break;
                this.state = 4304;
                return true;
            }
            case 4304: {
                if (59 != current) break;
                this.match = "\u212f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4305: {
                if (111 != current) break;
                this.state = 4306;
                return true;
            }
            case 4306: {
                if (116 != current) break;
                this.state = 4307;
                return true;
            }
            case 4307: {
                if (59 != current) break;
                this.match = "\u2250";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4308: {
                if (109 != current) break;
                this.state = 4309;
                return true;
            }
            case 4309: {
                if (59 != current) break;
                this.match = "\u2242";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4310: {
                if (97 == current) {
                    this.state = 4311;
                    return true;
                }
                if (104 != current) break;
                this.match = "\u00f0";
                this.matchLength = this.consumedCount;
                this.state = 4312;
                return true;
            }
            case 4311: {
                if (59 != current) break;
                this.match = "\u03b7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4312: {
                if (59 != current) break;
                this.match = "\u00f0";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4313: {
                if (109 == current) {
                    this.state = 4314;
                    return true;
                }
                if (114 != current) break;
                this.state = 4316;
                return true;
            }
            case 4314: {
                if (108 != current) break;
                this.match = "\u00eb";
                this.matchLength = this.consumedCount;
                this.state = 4315;
                return true;
            }
            case 4315: {
                if (59 != current) break;
                this.match = "\u00eb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4316: {
                if (111 != current) break;
                this.state = 4317;
                return true;
            }
            case 4317: {
                if (59 != current) break;
                this.match = "\u20ac";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4318: {
                switch (current) {
                    case 99: {
                        this.state = 4319;
                        return true;
                    }
                    case 105: {
                        this.state = 4321;
                        return true;
                    }
                    case 112: {
                        this.state = 4324;
                        return true;
                    }
                }
                break;
            }
            case 4319: {
                if (108 != current) break;
                this.state = 4320;
                return true;
            }
            case 4320: {
                if (59 != current) break;
                this.match = "!";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4321: {
                if (115 != current) break;
                this.state = 4322;
                return true;
            }
            case 4322: {
                if (116 != current) break;
                this.state = 4323;
                return true;
            }
            case 4323: {
                if (59 != current) break;
                this.match = "\u2203";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4324: {
                if (101 == current) {
                    this.state = 4325;
                    return true;
                }
                if (111 != current) break;
                this.state = 4333;
                return true;
            }
            case 4325: {
                if (99 != current) break;
                this.state = 4326;
                return true;
            }
            case 4326: {
                if (116 != current) break;
                this.state = 4327;
                return true;
            }
            case 4327: {
                if (97 != current) break;
                this.state = 4328;
                return true;
            }
            case 4328: {
                if (116 != current) break;
                this.state = 4329;
                return true;
            }
            case 4329: {
                if (105 != current) break;
                this.state = 4330;
                return true;
            }
            case 4330: {
                if (111 != current) break;
                this.state = 4331;
                return true;
            }
            case 4331: {
                if (110 != current) break;
                this.state = 4332;
                return true;
            }
            case 4332: {
                if (59 != current) break;
                this.match = "\u2130";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4333: {
                if (110 != current) break;
                this.state = 4334;
                return true;
            }
            case 4334: {
                if (101 != current) break;
                this.state = 4335;
                return true;
            }
            case 4335: {
                if (110 != current) break;
                this.state = 4336;
                return true;
            }
            case 4336: {
                if (116 != current) break;
                this.state = 4337;
                return true;
            }
            case 4337: {
                if (105 != current) break;
                this.state = 4338;
                return true;
            }
            case 4338: {
                if (97 != current) break;
                this.state = 4339;
                return true;
            }
            case 4339: {
                if (108 != current) break;
                this.state = 4340;
                return true;
            }
            case 4340: {
                if (101 != current) break;
                this.state = 4341;
                return true;
            }
            case 4341: {
                if (59 != current) break;
                this.match = "\u2147";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4342: {
                switch (current) {
                    case 97: {
                        this.state = 4343;
                        return true;
                    }
                    case 99: {
                        this.state = 4355;
                        return true;
                    }
                    case 101: {
                        this.state = 4357;
                        return true;
                    }
                    case 102: {
                        this.state = 4362;
                        return true;
                    }
                    case 105: {
                        this.state = 4374;
                        return true;
                    }
                    case 106: {
                        this.state = 4378;
                        return true;
                    }
                    case 108: {
                        this.state = 4382;
                        return true;
                    }
                    case 110: {
                        this.state = 4391;
                        return true;
                    }
                    case 111: {
                        this.state = 4394;
                        return true;
                    }
                    case 112: {
                        this.state = 4403;
                        return true;
                    }
                    case 114: {
                        this.state = 4410;
                        return true;
                    }
                    case 115: {
                        this.state = 4439;
                        return true;
                    }
                }
                break;
            }
            case 4343: {
                if (108 != current) break;
                this.state = 4344;
                return true;
            }
            case 4344: {
                if (108 != current) break;
                this.state = 4345;
                return true;
            }
            case 4345: {
                if (105 != current) break;
                this.state = 4346;
                return true;
            }
            case 4346: {
                if (110 != current) break;
                this.state = 4347;
                return true;
            }
            case 4347: {
                if (103 != current) break;
                this.state = 4348;
                return true;
            }
            case 4348: {
                if (100 != current) break;
                this.state = 4349;
                return true;
            }
            case 4349: {
                if (111 != current) break;
                this.state = 4350;
                return true;
            }
            case 4350: {
                if (116 != current) break;
                this.state = 4351;
                return true;
            }
            case 4351: {
                if (115 != current) break;
                this.state = 4352;
                return true;
            }
            case 4352: {
                if (101 != current) break;
                this.state = 4353;
                return true;
            }
            case 4353: {
                if (113 != current) break;
                this.state = 4354;
                return true;
            }
            case 4354: {
                if (59 != current) break;
                this.match = "\u2252";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4355: {
                if (121 != current) break;
                this.state = 4356;
                return true;
            }
            case 4356: {
                if (59 != current) break;
                this.match = "\u0444";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4357: {
                if (109 != current) break;
                this.state = 4358;
                return true;
            }
            case 4358: {
                if (97 != current) break;
                this.state = 4359;
                return true;
            }
            case 4359: {
                if (108 != current) break;
                this.state = 4360;
                return true;
            }
            case 4360: {
                if (101 != current) break;
                this.state = 4361;
                return true;
            }
            case 4361: {
                if (59 != current) break;
                this.match = "\u2640";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4362: {
                switch (current) {
                    case 105: {
                        this.state = 4363;
                        return true;
                    }
                    case 108: {
                        this.state = 4367;
                        return true;
                    }
                    case 114: {
                        this.state = 4373;
                        return true;
                    }
                }
                break;
            }
            case 4363: {
                if (108 != current) break;
                this.state = 4364;
                return true;
            }
            case 4364: {
                if (105 != current) break;
                this.state = 4365;
                return true;
            }
            case 4365: {
                if (103 != current) break;
                this.state = 4366;
                return true;
            }
            case 4366: {
                if (59 != current) break;
                this.match = "\ufb03";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4367: {
                if (105 == current) {
                    this.state = 4368;
                    return true;
                }
                if (108 != current) break;
                this.state = 4370;
                return true;
            }
            case 4368: {
                if (103 != current) break;
                this.state = 4369;
                return true;
            }
            case 4369: {
                if (59 != current) break;
                this.match = "\ufb00";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4370: {
                if (105 != current) break;
                this.state = 4371;
                return true;
            }
            case 4371: {
                if (103 != current) break;
                this.state = 4372;
                return true;
            }
            case 4372: {
                if (59 != current) break;
                this.match = "\ufb04";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4373: {
                if (59 != current) break;
                this.match = "\ud835\udd23";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4374: {
                if (108 != current) break;
                this.state = 4375;
                return true;
            }
            case 4375: {
                if (105 != current) break;
                this.state = 4376;
                return true;
            }
            case 4376: {
                if (103 != current) break;
                this.state = 4377;
                return true;
            }
            case 4377: {
                if (59 != current) break;
                this.match = "\ufb01";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4378: {
                if (108 != current) break;
                this.state = 4379;
                return true;
            }
            case 4379: {
                if (105 != current) break;
                this.state = 4380;
                return true;
            }
            case 4380: {
                if (103 != current) break;
                this.state = 4381;
                return true;
            }
            case 4381: {
                if (59 != current) break;
                this.match = "fj";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4382: {
                switch (current) {
                    case 97: {
                        this.state = 4383;
                        return true;
                    }
                    case 108: {
                        this.state = 4385;
                        return true;
                    }
                    case 116: {
                        this.state = 4388;
                        return true;
                    }
                }
                break;
            }
            case 4383: {
                if (116 != current) break;
                this.state = 4384;
                return true;
            }
            case 4384: {
                if (59 != current) break;
                this.match = "\u266d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4385: {
                if (105 != current) break;
                this.state = 4386;
                return true;
            }
            case 4386: {
                if (103 != current) break;
                this.state = 4387;
                return true;
            }
            case 4387: {
                if (59 != current) break;
                this.match = "\ufb02";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4388: {
                if (110 != current) break;
                this.state = 4389;
                return true;
            }
            case 4389: {
                if (115 != current) break;
                this.state = 4390;
                return true;
            }
            case 4390: {
                if (59 != current) break;
                this.match = "\u25b1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4391: {
                if (111 != current) break;
                this.state = 4392;
                return true;
            }
            case 4392: {
                if (102 != current) break;
                this.state = 4393;
                return true;
            }
            case 4393: {
                if (59 != current) break;
                this.match = "\u0192";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4394: {
                if (112 == current) {
                    this.state = 4395;
                    return true;
                }
                if (114 != current) break;
                this.state = 4397;
                return true;
            }
            case 4395: {
                if (102 != current) break;
                this.state = 4396;
                return true;
            }
            case 4396: {
                if (59 != current) break;
                this.match = "\ud835\udd57";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4397: {
                if (97 == current) {
                    this.state = 4398;
                    return true;
                }
                if (107 != current) break;
                this.state = 4401;
                return true;
            }
            case 4398: {
                if (108 != current) break;
                this.state = 4399;
                return true;
            }
            case 4399: {
                if (108 != current) break;
                this.state = 4400;
                return true;
            }
            case 4400: {
                if (59 != current) break;
                this.match = "\u2200";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4401: {
                if (59 == current) {
                    this.match = "\u22d4";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (118 != current) break;
                this.state = 4402;
                return true;
            }
            case 4402: {
                if (59 != current) break;
                this.match = "\u2ad9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4403: {
                if (97 != current) break;
                this.state = 4404;
                return true;
            }
            case 4404: {
                if (114 != current) break;
                this.state = 4405;
                return true;
            }
            case 4405: {
                if (116 != current) break;
                this.state = 4406;
                return true;
            }
            case 4406: {
                if (105 != current) break;
                this.state = 4407;
                return true;
            }
            case 4407: {
                if (110 != current) break;
                this.state = 4408;
                return true;
            }
            case 4408: {
                if (116 != current) break;
                this.state = 4409;
                return true;
            }
            case 4409: {
                if (59 != current) break;
                this.match = "\u2a0d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4410: {
                if (97 == current) {
                    this.state = 4411;
                    return true;
                }
                if (111 != current) break;
                this.state = 4436;
                return true;
            }
            case 4411: {
                if (99 == current) {
                    this.state = 4412;
                    return true;
                }
                if (115 != current) break;
                this.state = 4434;
                return true;
            }
            case 4412: {
                switch (current) {
                    case 49: {
                        this.state = 4413;
                        return true;
                    }
                    case 50: {
                        this.state = 4420;
                        return true;
                    }
                    case 51: {
                        this.state = 4423;
                        return true;
                    }
                    case 52: {
                        this.state = 4427;
                        return true;
                    }
                    case 53: {
                        this.state = 4429;
                        return true;
                    }
                    case 55: {
                        this.state = 4432;
                        return true;
                    }
                }
                break;
            }
            case 4413: {
                switch (current) {
                    case 50: {
                        this.match = "\u00bd";
                        this.matchLength = this.consumedCount;
                        this.state = 4414;
                        return true;
                    }
                    case 51: {
                        this.state = 4415;
                        return true;
                    }
                    case 52: {
                        this.match = "\u00bc";
                        this.matchLength = this.consumedCount;
                        this.state = 4416;
                        return true;
                    }
                    case 53: {
                        this.state = 4417;
                        return true;
                    }
                    case 54: {
                        this.state = 4418;
                        return true;
                    }
                    case 56: {
                        this.state = 4419;
                        return true;
                    }
                }
                break;
            }
            case 4414: {
                if (59 != current) break;
                this.match = "\u00bd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4415: {
                if (59 != current) break;
                this.match = "\u2153";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4416: {
                if (59 != current) break;
                this.match = "\u00bc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4417: {
                if (59 != current) break;
                this.match = "\u2155";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4418: {
                if (59 != current) break;
                this.match = "\u2159";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4419: {
                if (59 != current) break;
                this.match = "\u215b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4420: {
                if (51 == current) {
                    this.state = 4421;
                    return true;
                }
                if (53 != current) break;
                this.state = 4422;
                return true;
            }
            case 4421: {
                if (59 != current) break;
                this.match = "\u2154";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4422: {
                if (59 != current) break;
                this.match = "\u2156";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4423: {
                switch (current) {
                    case 52: {
                        this.match = "\u00be";
                        this.matchLength = this.consumedCount;
                        this.state = 4424;
                        return true;
                    }
                    case 53: {
                        this.state = 4425;
                        return true;
                    }
                    case 56: {
                        this.state = 4426;
                        return true;
                    }
                }
                break;
            }
            case 4424: {
                if (59 != current) break;
                this.match = "\u00be";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4425: {
                if (59 != current) break;
                this.match = "\u2157";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4426: {
                if (59 != current) break;
                this.match = "\u215c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4427: {
                if (53 != current) break;
                this.state = 4428;
                return true;
            }
            case 4428: {
                if (59 != current) break;
                this.match = "\u2158";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4429: {
                if (54 == current) {
                    this.state = 4430;
                    return true;
                }
                if (56 != current) break;
                this.state = 4431;
                return true;
            }
            case 4430: {
                if (59 != current) break;
                this.match = "\u215a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4431: {
                if (59 != current) break;
                this.match = "\u215d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4432: {
                if (56 != current) break;
                this.state = 4433;
                return true;
            }
            case 4433: {
                if (59 != current) break;
                this.match = "\u215e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4434: {
                if (108 != current) break;
                this.state = 4435;
                return true;
            }
            case 4435: {
                if (59 != current) break;
                this.match = "\u2044";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4436: {
                if (119 != current) break;
                this.state = 4437;
                return true;
            }
            case 4437: {
                if (110 != current) break;
                this.state = 4438;
                return true;
            }
            case 4438: {
                if (59 != current) break;
                this.match = "\u2322";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4439: {
                if (99 != current) break;
                this.state = 4440;
                return true;
            }
            case 4440: {
                if (114 != current) break;
                this.state = 4441;
                return true;
            }
            case 4441: {
                if (59 != current) break;
                this.match = "\ud835\udcbb";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4442: {
                switch (current) {
                    case 69: {
                        this.state = 4443;
                        return true;
                    }
                    case 97: {
                        this.state = 4445;
                        return true;
                    }
                    case 98: {
                        this.state = 4455;
                        return true;
                    }
                    case 99: {
                        this.state = 4460;
                        return true;
                    }
                    case 100: {
                        this.state = 4465;
                        return true;
                    }
                    case 101: {
                        this.state = 4468;
                        return true;
                    }
                    case 102: {
                        this.state = 4488;
                        return true;
                    }
                    case 103: {
                        this.state = 4490;
                        return true;
                    }
                    case 105: {
                        this.state = 4492;
                        return true;
                    }
                    case 106: {
                        this.state = 4496;
                        return true;
                    }
                    case 108: {
                        this.state = 4499;
                        return true;
                    }
                    case 110: {
                        this.state = 4503;
                        return true;
                    }
                    case 111: {
                        this.state = 4517;
                        return true;
                    }
                    case 114: {
                        this.state = 4520;
                        return true;
                    }
                    case 115: {
                        this.state = 4524;
                        return true;
                    }
                    case 116: {
                        this.match = ">";
                        this.matchLength = this.consumedCount;
                        this.state = 4531;
                        return true;
                    }
                    case 118: {
                        this.state = 4578;
                        return true;
                    }
                }
                break;
            }
            case 4443: {
                if (59 == current) {
                    this.match = "\u2267";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (108 != current) break;
                this.state = 4444;
                return true;
            }
            case 4444: {
                if (59 != current) break;
                this.match = "\u2a8c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4445: {
                switch (current) {
                    case 99: {
                        this.state = 4446;
                        return true;
                    }
                    case 109: {
                        this.state = 4450;
                        return true;
                    }
                    case 112: {
                        this.state = 4454;
                        return true;
                    }
                }
                break;
            }
            case 4446: {
                if (117 != current) break;
                this.state = 4447;
                return true;
            }
            case 4447: {
                if (116 != current) break;
                this.state = 4448;
                return true;
            }
            case 4448: {
                if (101 != current) break;
                this.state = 4449;
                return true;
            }
            case 4449: {
                if (59 != current) break;
                this.match = "\u01f5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4450: {
                if (109 != current) break;
                this.state = 4451;
                return true;
            }
            case 4451: {
                if (97 != current) break;
                this.state = 4452;
                return true;
            }
            case 4452: {
                if (59 == current) {
                    this.match = "\u03b3";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (100 != current) break;
                this.state = 4453;
                return true;
            }
            case 4453: {
                if (59 != current) break;
                this.match = "\u03dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4454: {
                if (59 != current) break;
                this.match = "\u2a86";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4455: {
                if (114 != current) break;
                this.state = 4456;
                return true;
            }
            case 4456: {
                if (101 != current) break;
                this.state = 4457;
                return true;
            }
            case 4457: {
                if (118 != current) break;
                this.state = 4458;
                return true;
            }
            case 4458: {
                if (101 != current) break;
                this.state = 4459;
                return true;
            }
            case 4459: {
                if (59 != current) break;
                this.match = "\u011f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4460: {
                if (105 == current) {
                    this.state = 4461;
                    return true;
                }
                if (121 != current) break;
                this.state = 4464;
                return true;
            }
            case 4461: {
                if (114 != current) break;
                this.state = 4462;
                return true;
            }
            case 4462: {
                if (99 != current) break;
                this.state = 4463;
                return true;
            }
            case 4463: {
                if (59 != current) break;
                this.match = "\u011d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4464: {
                if (59 != current) break;
                this.match = "\u0433";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4465: {
                if (111 != current) break;
                this.state = 4466;
                return true;
            }
            case 4466: {
                if (116 != current) break;
                this.state = 4467;
                return true;
            }
            case 4467: {
                if (59 != current) break;
                this.match = "\u0121";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4468: {
                switch (current) {
                    case 59: {
                        this.match = "\u2265";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 108: {
                        this.state = 4469;
                        return true;
                    }
                    case 113: {
                        this.state = 4470;
                        return true;
                    }
                    case 115: {
                        this.state = 4477;
                        return true;
                    }
                }
                break;
            }
            case 4469: {
                if (59 != current) break;
                this.match = "\u22db";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4470: {
                switch (current) {
                    case 59: {
                        this.match = "\u2265";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 113: {
                        this.state = 4471;
                        return true;
                    }
                    case 115: {
                        this.state = 4472;
                        return true;
                    }
                }
                break;
            }
            case 4471: {
                if (59 != current) break;
                this.match = "\u2267";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4472: {
                if (108 != current) break;
                this.state = 4473;
                return true;
            }
            case 4473: {
                if (97 != current) break;
                this.state = 4474;
                return true;
            }
            case 4474: {
                if (110 != current) break;
                this.state = 4475;
                return true;
            }
            case 4475: {
                if (116 != current) break;
                this.state = 4476;
                return true;
            }
            case 4476: {
                if (59 != current) break;
                this.match = "\u2a7e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4477: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a7e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 99: {
                        this.state = 4478;
                        return true;
                    }
                    case 100: {
                        this.state = 4480;
                        return true;
                    }
                    case 108: {
                        this.state = 4485;
                        return true;
                    }
                }
                break;
            }
            case 4478: {
                if (99 != current) break;
                this.state = 4479;
                return true;
            }
            case 4479: {
                if (59 != current) break;
                this.match = "\u2aa9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4480: {
                if (111 != current) break;
                this.state = 4481;
                return true;
            }
            case 4481: {
                if (116 != current) break;
                this.state = 4482;
                return true;
            }
            case 4482: {
                if (59 == current) {
                    this.match = "\u2a80";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (111 != current) break;
                this.state = 4483;
                return true;
            }
            case 4483: {
                if (59 == current) {
                    this.match = "\u2a82";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (108 != current) break;
                this.state = 4484;
                return true;
            }
            case 4484: {
                if (59 != current) break;
                this.match = "\u2a84";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4485: {
                if (59 == current) {
                    this.match = "\u22db\ufe00";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (101 != current) break;
                this.state = 4486;
                return true;
            }
            case 4486: {
                if (115 != current) break;
                this.state = 4487;
                return true;
            }
            case 4487: {
                if (59 != current) break;
                this.match = "\u2a94";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4488: {
                if (114 != current) break;
                this.state = 4489;
                return true;
            }
            case 4489: {
                if (59 != current) break;
                this.match = "\ud835\udd24";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4490: {
                if (59 == current) {
                    this.match = "\u226b";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (103 != current) break;
                this.state = 4491;
                return true;
            }
            case 4491: {
                if (59 != current) break;
                this.match = "\u22d9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4492: {
                if (109 != current) break;
                this.state = 4493;
                return true;
            }
            case 4493: {
                if (101 != current) break;
                this.state = 4494;
                return true;
            }
            case 4494: {
                if (108 != current) break;
                this.state = 4495;
                return true;
            }
            case 4495: {
                if (59 != current) break;
                this.match = "\u2137";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4496: {
                if (99 != current) break;
                this.state = 4497;
                return true;
            }
            case 4497: {
                if (121 != current) break;
                this.state = 4498;
                return true;
            }
            case 4498: {
                if (59 != current) break;
                this.match = "\u0453";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4499: {
                switch (current) {
                    case 59: {
                        this.match = "\u2277";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 4500;
                        return true;
                    }
                    case 97: {
                        this.state = 4501;
                        return true;
                    }
                    case 106: {
                        this.state = 4502;
                        return true;
                    }
                }
                break;
            }
            case 4500: {
                if (59 != current) break;
                this.match = "\u2a92";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4501: {
                if (59 != current) break;
                this.match = "\u2aa5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4502: {
                if (59 != current) break;
                this.match = "\u2aa4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4503: {
                switch (current) {
                    case 69: {
                        this.state = 4504;
                        return true;
                    }
                    case 97: {
                        this.state = 4505;
                        return true;
                    }
                    case 101: {
                        this.state = 4511;
                        return true;
                    }
                    case 115: {
                        this.state = 4514;
                        return true;
                    }
                }
                break;
            }
            case 4504: {
                if (59 != current) break;
                this.match = "\u2269";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4505: {
                if (112 != current) break;
                this.state = 4506;
                return true;
            }
            case 4506: {
                if (59 == current) {
                    this.match = "\u2a8a";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (112 != current) break;
                this.state = 4507;
                return true;
            }
            case 4507: {
                if (114 != current) break;
                this.state = 4508;
                return true;
            }
            case 4508: {
                if (111 != current) break;
                this.state = 4509;
                return true;
            }
            case 4509: {
                if (120 != current) break;
                this.state = 4510;
                return true;
            }
            case 4510: {
                if (59 != current) break;
                this.match = "\u2a8a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4511: {
                if (59 == current) {
                    this.match = "\u2a88";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (113 != current) break;
                this.state = 4512;
                return true;
            }
            case 4512: {
                if (59 == current) {
                    this.match = "\u2a88";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (113 != current) break;
                this.state = 4513;
                return true;
            }
            case 4513: {
                if (59 != current) break;
                this.match = "\u2269";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4514: {
                if (105 != current) break;
                this.state = 4515;
                return true;
            }
            case 4515: {
                if (109 != current) break;
                this.state = 4516;
                return true;
            }
            case 4516: {
                if (59 != current) break;
                this.match = "\u22e7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4517: {
                if (112 != current) break;
                this.state = 4518;
                return true;
            }
            case 4518: {
                if (102 != current) break;
                this.state = 4519;
                return true;
            }
            case 4519: {
                if (59 != current) break;
                this.match = "\ud835\udd58";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4520: {
                if (97 != current) break;
                this.state = 4521;
                return true;
            }
            case 4521: {
                if (118 != current) break;
                this.state = 4522;
                return true;
            }
            case 4522: {
                if (101 != current) break;
                this.state = 4523;
                return true;
            }
            case 4523: {
                if (59 != current) break;
                this.match = "`";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4524: {
                if (99 == current) {
                    this.state = 4525;
                    return true;
                }
                if (105 != current) break;
                this.state = 4527;
                return true;
            }
            case 4525: {
                if (114 != current) break;
                this.state = 4526;
                return true;
            }
            case 4526: {
                if (59 != current) break;
                this.match = "\u210a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4527: {
                if (109 != current) break;
                this.state = 4528;
                return true;
            }
            case 4528: {
                switch (current) {
                    case 59: {
                        this.match = "\u2273";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 4529;
                        return true;
                    }
                    case 108: {
                        this.state = 4530;
                        return true;
                    }
                }
                break;
            }
            case 4529: {
                if (59 != current) break;
                this.match = "\u2a8e";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4530: {
                if (59 != current) break;
                this.match = "\u2a90";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4531: {
                switch (current) {
                    case 59: {
                        this.match = ">";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 99: {
                        this.state = 4532;
                        return true;
                    }
                    case 100: {
                        this.state = 4536;
                        return true;
                    }
                    case 108: {
                        this.state = 4539;
                        return true;
                    }
                    case 113: {
                        this.state = 4543;
                        return true;
                    }
                    case 114: {
                        this.state = 4548;
                        return true;
                    }
                }
                break;
            }
            case 4532: {
                if (99 == current) {
                    this.state = 4533;
                    return true;
                }
                if (105 != current) break;
                this.state = 4534;
                return true;
            }
            case 4533: {
                if (59 != current) break;
                this.match = "\u2aa7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4534: {
                if (114 != current) break;
                this.state = 4535;
                return true;
            }
            case 4535: {
                if (59 != current) break;
                this.match = "\u2a7a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4536: {
                if (111 != current) break;
                this.state = 4537;
                return true;
            }
            case 4537: {
                if (116 != current) break;
                this.state = 4538;
                return true;
            }
            case 4538: {
                if (59 != current) break;
                this.match = "\u22d7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4539: {
                if (80 != current) break;
                this.state = 4540;
                return true;
            }
            case 4540: {
                if (97 != current) break;
                this.state = 4541;
                return true;
            }
            case 4541: {
                if (114 != current) break;
                this.state = 4542;
                return true;
            }
            case 4542: {
                if (59 != current) break;
                this.match = "\u2995";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4543: {
                if (117 != current) break;
                this.state = 4544;
                return true;
            }
            case 4544: {
                if (101 != current) break;
                this.state = 4545;
                return true;
            }
            case 4545: {
                if (115 != current) break;
                this.state = 4546;
                return true;
            }
            case 4546: {
                if (116 != current) break;
                this.state = 4547;
                return true;
            }
            case 4547: {
                if (59 != current) break;
                this.match = "\u2a7c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4548: {
                switch (current) {
                    case 97: {
                        this.state = 4549;
                        return true;
                    }
                    case 100: {
                        this.state = 4557;
                        return true;
                    }
                    case 101: {
                        this.state = 4560;
                        return true;
                    }
                    case 108: {
                        this.state = 4571;
                        return true;
                    }
                    case 115: {
                        this.state = 4575;
                        return true;
                    }
                }
                break;
            }
            case 4549: {
                if (112 == current) {
                    this.state = 4550;
                    return true;
                }
                if (114 != current) break;
                this.state = 4555;
                return true;
            }
            case 4550: {
                if (112 != current) break;
                this.state = 4551;
                return true;
            }
            case 4551: {
                if (114 != current) break;
                this.state = 4552;
                return true;
            }
            case 4552: {
                if (111 != current) break;
                this.state = 4553;
                return true;
            }
            case 4553: {
                if (120 != current) break;
                this.state = 4554;
                return true;
            }
            case 4554: {
                if (59 != current) break;
                this.match = "\u2a86";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4555: {
                if (114 != current) break;
                this.state = 4556;
                return true;
            }
            case 4556: {
                if (59 != current) break;
                this.match = "\u2978";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4557: {
                if (111 != current) break;
                this.state = 4558;
                return true;
            }
            case 4558: {
                if (116 != current) break;
                this.state = 4559;
                return true;
            }
            case 4559: {
                if (59 != current) break;
                this.match = "\u22d7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4560: {
                if (113 != current) break;
                this.state = 4561;
                return true;
            }
            case 4561: {
                if (108 == current) {
                    this.state = 4562;
                    return true;
                }
                if (113 != current) break;
                this.state = 4566;
                return true;
            }
            case 4562: {
                if (101 != current) break;
                this.state = 4563;
                return true;
            }
            case 4563: {
                if (115 != current) break;
                this.state = 4564;
                return true;
            }
            case 4564: {
                if (115 != current) break;
                this.state = 4565;
                return true;
            }
            case 4565: {
                if (59 != current) break;
                this.match = "\u22db";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4566: {
                if (108 != current) break;
                this.state = 4567;
                return true;
            }
            case 4567: {
                if (101 != current) break;
                this.state = 4568;
                return true;
            }
            case 4568: {
                if (115 != current) break;
                this.state = 4569;
                return true;
            }
            case 4569: {
                if (115 != current) break;
                this.state = 4570;
                return true;
            }
            case 4570: {
                if (59 != current) break;
                this.match = "\u2a8c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4571: {
                if (101 != current) break;
                this.state = 4572;
                return true;
            }
            case 4572: {
                if (115 != current) break;
                this.state = 4573;
                return true;
            }
            case 4573: {
                if (115 != current) break;
                this.state = 4574;
                return true;
            }
            case 4574: {
                if (59 != current) break;
                this.match = "\u2277";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4575: {
                if (105 != current) break;
                this.state = 4576;
                return true;
            }
            case 4576: {
                if (109 != current) break;
                this.state = 4577;
                return true;
            }
            case 4577: {
                if (59 != current) break;
                this.match = "\u2273";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4578: {
                if (101 == current) {
                    this.state = 4579;
                    return true;
                }
                if (110 != current) break;
                this.state = 4586;
                return true;
            }
            case 4579: {
                if (114 != current) break;
                this.state = 4580;
                return true;
            }
            case 4580: {
                if (116 != current) break;
                this.state = 4581;
                return true;
            }
            case 4581: {
                if (110 != current) break;
                this.state = 4582;
                return true;
            }
            case 4582: {
                if (101 != current) break;
                this.state = 4583;
                return true;
            }
            case 4583: {
                if (113 != current) break;
                this.state = 4584;
                return true;
            }
            case 4584: {
                if (113 != current) break;
                this.state = 4585;
                return true;
            }
            case 4585: {
                if (59 != current) break;
                this.match = "\u2269\ufe00";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4586: {
                if (69 != current) break;
                this.state = 4587;
                return true;
            }
            case 4587: {
                if (59 != current) break;
                this.match = "\u2269\ufe00";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4588: {
                switch (current) {
                    case 65: {
                        this.state = 4589;
                        return true;
                    }
                    case 97: {
                        this.state = 4592;
                        return true;
                    }
                    case 98: {
                        this.state = 4612;
                        return true;
                    }
                    case 99: {
                        this.state = 4615;
                        return true;
                    }
                    case 101: {
                        this.state = 4619;
                        return true;
                    }
                    case 102: {
                        this.state = 4635;
                        return true;
                    }
                    case 107: {
                        this.state = 4637;
                        return true;
                    }
                    case 111: {
                        this.state = 4649;
                        return true;
                    }
                    case 115: {
                        this.state = 4684;
                        return true;
                    }
                    case 121: {
                        this.state = 4695;
                        return true;
                    }
                }
                break;
            }
            case 4589: {
                if (114 != current) break;
                this.state = 4590;
                return true;
            }
            case 4590: {
                if (114 != current) break;
                this.state = 4591;
                return true;
            }
            case 4591: {
                if (59 != current) break;
                this.match = "\u21d4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4592: {
                switch (current) {
                    case 105: {
                        this.state = 4593;
                        return true;
                    }
                    case 108: {
                        this.state = 4597;
                        return true;
                    }
                    case 109: {
                        this.state = 4599;
                        return true;
                    }
                    case 114: {
                        this.state = 4603;
                        return true;
                    }
                }
                break;
            }
            case 4593: {
                if (114 != current) break;
                this.state = 4594;
                return true;
            }
            case 4594: {
                if (115 != current) break;
                this.state = 4595;
                return true;
            }
            case 4595: {
                if (112 != current) break;
                this.state = 4596;
                return true;
            }
            case 4596: {
                if (59 != current) break;
                this.match = "\u200a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4597: {
                if (102 != current) break;
                this.state = 4598;
                return true;
            }
            case 4598: {
                if (59 != current) break;
                this.match = "\u00bd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4599: {
                if (105 != current) break;
                this.state = 4600;
                return true;
            }
            case 4600: {
                if (108 != current) break;
                this.state = 4601;
                return true;
            }
            case 4601: {
                if (116 != current) break;
                this.state = 4602;
                return true;
            }
            case 4602: {
                if (59 != current) break;
                this.match = "\u210b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4603: {
                if (100 == current) {
                    this.state = 4604;
                    return true;
                }
                if (114 != current) break;
                this.state = 4607;
                return true;
            }
            case 4604: {
                if (99 != current) break;
                this.state = 4605;
                return true;
            }
            case 4605: {
                if (121 != current) break;
                this.state = 4606;
                return true;
            }
            case 4606: {
                if (59 != current) break;
                this.match = "\u044a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4607: {
                switch (current) {
                    case 59: {
                        this.match = "\u2194";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 99: {
                        this.state = 4608;
                        return true;
                    }
                    case 119: {
                        this.state = 4611;
                        return true;
                    }
                }
                break;
            }
            case 4608: {
                if (105 != current) break;
                this.state = 4609;
                return true;
            }
            case 4609: {
                if (114 != current) break;
                this.state = 4610;
                return true;
            }
            case 4610: {
                if (59 != current) break;
                this.match = "\u2948";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4611: {
                if (59 != current) break;
                this.match = "\u21ad";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4612: {
                if (97 != current) break;
                this.state = 4613;
                return true;
            }
            case 4613: {
                if (114 != current) break;
                this.state = 4614;
                return true;
            }
            case 4614: {
                if (59 != current) break;
                this.match = "\u210f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4615: {
                if (105 != current) break;
                this.state = 4616;
                return true;
            }
            case 4616: {
                if (114 != current) break;
                this.state = 4617;
                return true;
            }
            case 4617: {
                if (99 != current) break;
                this.state = 4618;
                return true;
            }
            case 4618: {
                if (59 != current) break;
                this.match = "\u0125";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4619: {
                switch (current) {
                    case 97: {
                        this.state = 4620;
                        return true;
                    }
                    case 108: {
                        this.state = 4627;
                        return true;
                    }
                    case 114: {
                        this.state = 4631;
                        return true;
                    }
                }
                break;
            }
            case 4620: {
                if (114 != current) break;
                this.state = 4621;
                return true;
            }
            case 4621: {
                if (116 != current) break;
                this.state = 4622;
                return true;
            }
            case 4622: {
                if (115 != current) break;
                this.state = 4623;
                return true;
            }
            case 4623: {
                if (59 == current) {
                    this.match = "\u2665";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (117 != current) break;
                this.state = 4624;
                return true;
            }
            case 4624: {
                if (105 != current) break;
                this.state = 4625;
                return true;
            }
            case 4625: {
                if (116 != current) break;
                this.state = 4626;
                return true;
            }
            case 4626: {
                if (59 != current) break;
                this.match = "\u2665";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4627: {
                if (108 != current) break;
                this.state = 4628;
                return true;
            }
            case 4628: {
                if (105 != current) break;
                this.state = 4629;
                return true;
            }
            case 4629: {
                if (112 != current) break;
                this.state = 4630;
                return true;
            }
            case 4630: {
                if (59 != current) break;
                this.match = "\u2026";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4631: {
                if (99 != current) break;
                this.state = 4632;
                return true;
            }
            case 4632: {
                if (111 != current) break;
                this.state = 4633;
                return true;
            }
            case 4633: {
                if (110 != current) break;
                this.state = 4634;
                return true;
            }
            case 4634: {
                if (59 != current) break;
                this.match = "\u22b9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4635: {
                if (114 != current) break;
                this.state = 4636;
                return true;
            }
            case 4636: {
                if (59 != current) break;
                this.match = "\ud835\udd25";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4637: {
                if (115 != current) break;
                this.state = 4638;
                return true;
            }
            case 4638: {
                if (101 == current) {
                    this.state = 4639;
                    return true;
                }
                if (119 != current) break;
                this.state = 4644;
                return true;
            }
            case 4639: {
                if (97 != current) break;
                this.state = 4640;
                return true;
            }
            case 4640: {
                if (114 != current) break;
                this.state = 4641;
                return true;
            }
            case 4641: {
                if (111 != current) break;
                this.state = 4642;
                return true;
            }
            case 4642: {
                if (119 != current) break;
                this.state = 4643;
                return true;
            }
            case 4643: {
                if (59 != current) break;
                this.match = "\u2925";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4644: {
                if (97 != current) break;
                this.state = 4645;
                return true;
            }
            case 4645: {
                if (114 != current) break;
                this.state = 4646;
                return true;
            }
            case 4646: {
                if (111 != current) break;
                this.state = 4647;
                return true;
            }
            case 4647: {
                if (119 != current) break;
                this.state = 4648;
                return true;
            }
            case 4648: {
                if (59 != current) break;
                this.match = "\u2926";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4649: {
                switch (current) {
                    case 97: {
                        this.state = 4650;
                        return true;
                    }
                    case 109: {
                        this.state = 4653;
                        return true;
                    }
                    case 111: {
                        this.state = 4657;
                        return true;
                    }
                    case 112: {
                        this.state = 4678;
                        return true;
                    }
                    case 114: {
                        this.state = 4680;
                        return true;
                    }
                }
                break;
            }
            case 4650: {
                if (114 != current) break;
                this.state = 4651;
                return true;
            }
            case 4651: {
                if (114 != current) break;
                this.state = 4652;
                return true;
            }
            case 4652: {
                if (59 != current) break;
                this.match = "\u21ff";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4653: {
                if (116 != current) break;
                this.state = 4654;
                return true;
            }
            case 4654: {
                if (104 != current) break;
                this.state = 4655;
                return true;
            }
            case 4655: {
                if (116 != current) break;
                this.state = 4656;
                return true;
            }
            case 4656: {
                if (59 != current) break;
                this.match = "\u223b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4657: {
                if (107 != current) break;
                this.state = 4658;
                return true;
            }
            case 4658: {
                if (108 == current) {
                    this.state = 4659;
                    return true;
                }
                if (114 != current) break;
                this.state = 4668;
                return true;
            }
            case 4659: {
                if (101 != current) break;
                this.state = 4660;
                return true;
            }
            case 4660: {
                if (102 != current) break;
                this.state = 4661;
                return true;
            }
            case 4661: {
                if (116 != current) break;
                this.state = 4662;
                return true;
            }
            case 4662: {
                if (97 != current) break;
                this.state = 4663;
                return true;
            }
            case 4663: {
                if (114 != current) break;
                this.state = 4664;
                return true;
            }
            case 4664: {
                if (114 != current) break;
                this.state = 4665;
                return true;
            }
            case 4665: {
                if (111 != current) break;
                this.state = 4666;
                return true;
            }
            case 4666: {
                if (119 != current) break;
                this.state = 4667;
                return true;
            }
            case 4667: {
                if (59 != current) break;
                this.match = "\u21a9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4668: {
                if (105 != current) break;
                this.state = 4669;
                return true;
            }
            case 4669: {
                if (103 != current) break;
                this.state = 4670;
                return true;
            }
            case 4670: {
                if (104 != current) break;
                this.state = 4671;
                return true;
            }
            case 4671: {
                if (116 != current) break;
                this.state = 4672;
                return true;
            }
            case 4672: {
                if (97 != current) break;
                this.state = 4673;
                return true;
            }
            case 4673: {
                if (114 != current) break;
                this.state = 4674;
                return true;
            }
            case 4674: {
                if (114 != current) break;
                this.state = 4675;
                return true;
            }
            case 4675: {
                if (111 != current) break;
                this.state = 4676;
                return true;
            }
            case 4676: {
                if (119 != current) break;
                this.state = 4677;
                return true;
            }
            case 4677: {
                if (59 != current) break;
                this.match = "\u21aa";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4678: {
                if (102 != current) break;
                this.state = 4679;
                return true;
            }
            case 4679: {
                if (59 != current) break;
                this.match = "\ud835\udd59";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4680: {
                if (98 != current) break;
                this.state = 4681;
                return true;
            }
            case 4681: {
                if (97 != current) break;
                this.state = 4682;
                return true;
            }
            case 4682: {
                if (114 != current) break;
                this.state = 4683;
                return true;
            }
            case 4683: {
                if (59 != current) break;
                this.match = "\u2015";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4684: {
                switch (current) {
                    case 99: {
                        this.state = 4685;
                        return true;
                    }
                    case 108: {
                        this.state = 4687;
                        return true;
                    }
                    case 116: {
                        this.state = 4691;
                        return true;
                    }
                }
                break;
            }
            case 4685: {
                if (114 != current) break;
                this.state = 4686;
                return true;
            }
            case 4686: {
                if (59 != current) break;
                this.match = "\ud835\udcbd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4687: {
                if (97 != current) break;
                this.state = 4688;
                return true;
            }
            case 4688: {
                if (115 != current) break;
                this.state = 4689;
                return true;
            }
            case 4689: {
                if (104 != current) break;
                this.state = 4690;
                return true;
            }
            case 4690: {
                if (59 != current) break;
                this.match = "\u210f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4691: {
                if (114 != current) break;
                this.state = 4692;
                return true;
            }
            case 4692: {
                if (111 != current) break;
                this.state = 4693;
                return true;
            }
            case 4693: {
                if (107 != current) break;
                this.state = 4694;
                return true;
            }
            case 4694: {
                if (59 != current) break;
                this.match = "\u0127";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4695: {
                if (98 == current) {
                    this.state = 4696;
                    return true;
                }
                if (112 != current) break;
                this.state = 4700;
                return true;
            }
            case 4696: {
                if (117 != current) break;
                this.state = 4697;
                return true;
            }
            case 4697: {
                if (108 != current) break;
                this.state = 4698;
                return true;
            }
            case 4698: {
                if (108 != current) break;
                this.state = 4699;
                return true;
            }
            case 4699: {
                if (59 != current) break;
                this.match = "\u2043";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4700: {
                if (104 != current) break;
                this.state = 4701;
                return true;
            }
            case 4701: {
                if (101 != current) break;
                this.state = 4702;
                return true;
            }
            case 4702: {
                if (110 != current) break;
                this.state = 4703;
                return true;
            }
            case 4703: {
                if (59 != current) break;
                this.match = "\u2010";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4704: {
                switch (current) {
                    case 97: {
                        this.state = 4705;
                        return true;
                    }
                    case 99: {
                        this.state = 4710;
                        return true;
                    }
                    case 101: {
                        this.state = 4715;
                        return true;
                    }
                    case 102: {
                        this.state = 4721;
                        return true;
                    }
                    case 103: {
                        this.state = 4724;
                        return true;
                    }
                    case 105: {
                        this.state = 4729;
                        return true;
                    }
                    case 106: {
                        this.state = 4743;
                        return true;
                    }
                    case 109: {
                        this.state = 4747;
                        return true;
                    }
                    case 110: {
                        this.state = 4768;
                        return true;
                    }
                    case 111: {
                        this.state = 4805;
                        return true;
                    }
                    case 112: {
                        this.state = 4815;
                        return true;
                    }
                    case 113: {
                        this.state = 4819;
                        return true;
                    }
                    case 115: {
                        this.state = 4824;
                        return true;
                    }
                    case 116: {
                        this.state = 4836;
                        return true;
                    }
                    case 117: {
                        this.state = 4841;
                        return true;
                    }
                }
                break;
            }
            case 4705: {
                if (99 != current) break;
                this.state = 4706;
                return true;
            }
            case 4706: {
                if (117 != current) break;
                this.state = 4707;
                return true;
            }
            case 4707: {
                if (116 != current) break;
                this.state = 4708;
                return true;
            }
            case 4708: {
                if (101 != current) break;
                this.match = "\u00ed";
                this.matchLength = this.consumedCount;
                this.state = 4709;
                return true;
            }
            case 4709: {
                if (59 != current) break;
                this.match = "\u00ed";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4710: {
                switch (current) {
                    case 59: {
                        this.match = "\u2063";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 105: {
                        this.state = 4711;
                        return true;
                    }
                    case 121: {
                        this.state = 4714;
                        return true;
                    }
                }
                break;
            }
            case 4711: {
                if (114 != current) break;
                this.state = 4712;
                return true;
            }
            case 4712: {
                if (99 != current) break;
                this.match = "\u00ee";
                this.matchLength = this.consumedCount;
                this.state = 4713;
                return true;
            }
            case 4713: {
                if (59 != current) break;
                this.match = "\u00ee";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4714: {
                if (59 != current) break;
                this.match = "\u0438";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4715: {
                if (99 == current) {
                    this.state = 4716;
                    return true;
                }
                if (120 != current) break;
                this.state = 4718;
                return true;
            }
            case 4716: {
                if (121 != current) break;
                this.state = 4717;
                return true;
            }
            case 4717: {
                if (59 != current) break;
                this.match = "\u0435";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4718: {
                if (99 != current) break;
                this.state = 4719;
                return true;
            }
            case 4719: {
                if (108 != current) break;
                this.match = "\u00a1";
                this.matchLength = this.consumedCount;
                this.state = 4720;
                return true;
            }
            case 4720: {
                if (59 != current) break;
                this.match = "\u00a1";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4721: {
                if (102 == current) {
                    this.state = 4722;
                    return true;
                }
                if (114 != current) break;
                this.state = 4723;
                return true;
            }
            case 4722: {
                if (59 != current) break;
                this.match = "\u21d4";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4723: {
                if (59 != current) break;
                this.match = "\ud835\udd26";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4724: {
                if (114 != current) break;
                this.state = 4725;
                return true;
            }
            case 4725: {
                if (97 != current) break;
                this.state = 4726;
                return true;
            }
            case 4726: {
                if (118 != current) break;
                this.state = 4727;
                return true;
            }
            case 4727: {
                if (101 != current) break;
                this.match = "\u00ec";
                this.matchLength = this.consumedCount;
                this.state = 4728;
                return true;
            }
            case 4728: {
                if (59 != current) break;
                this.match = "\u00ec";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4729: {
                switch (current) {
                    case 59: {
                        this.match = "\u2148";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 105: {
                        this.state = 4730;
                        return true;
                    }
                    case 110: {
                        this.state = 4736;
                        return true;
                    }
                    case 111: {
                        this.state = 4740;
                        return true;
                    }
                }
                break;
            }
            case 4730: {
                if (105 == current) {
                    this.state = 4731;
                    return true;
                }
                if (110 != current) break;
                this.state = 4734;
                return true;
            }
            case 4731: {
                if (110 != current) break;
                this.state = 4732;
                return true;
            }
            case 4732: {
                if (116 != current) break;
                this.state = 4733;
                return true;
            }
            case 4733: {
                if (59 != current) break;
                this.match = "\u2a0c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4734: {
                if (116 != current) break;
                this.state = 4735;
                return true;
            }
            case 4735: {
                if (59 != current) break;
                this.match = "\u222d";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4736: {
                if (102 != current) break;
                this.state = 4737;
                return true;
            }
            case 4737: {
                if (105 != current) break;
                this.state = 4738;
                return true;
            }
            case 4738: {
                if (110 != current) break;
                this.state = 4739;
                return true;
            }
            case 4739: {
                if (59 != current) break;
                this.match = "\u29dc";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4740: {
                if (116 != current) break;
                this.state = 4741;
                return true;
            }
            case 4741: {
                if (97 != current) break;
                this.state = 4742;
                return true;
            }
            case 4742: {
                if (59 != current) break;
                this.match = "\u2129";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4743: {
                if (108 != current) break;
                this.state = 4744;
                return true;
            }
            case 4744: {
                if (105 != current) break;
                this.state = 4745;
                return true;
            }
            case 4745: {
                if (103 != current) break;
                this.state = 4746;
                return true;
            }
            case 4746: {
                if (59 != current) break;
                this.match = "\u0133";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4747: {
                switch (current) {
                    case 97: {
                        this.state = 4748;
                        return true;
                    }
                    case 111: {
                        this.state = 4763;
                        return true;
                    }
                    case 112: {
                        this.state = 4765;
                        return true;
                    }
                }
                break;
            }
            case 4748: {
                switch (current) {
                    case 99: {
                        this.state = 4749;
                        return true;
                    }
                    case 103: {
                        this.state = 4751;
                        return true;
                    }
                    case 116: {
                        this.state = 4761;
                        return true;
                    }
                }
                break;
            }
            case 4749: {
                if (114 != current) break;
                this.state = 4750;
                return true;
            }
            case 4750: {
                if (59 != current) break;
                this.match = "\u012b";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4751: {
                switch (current) {
                    case 101: {
                        this.state = 4752;
                        return true;
                    }
                    case 108: {
                        this.state = 4753;
                        return true;
                    }
                    case 112: {
                        this.state = 4757;
                        return true;
                    }
                }
                break;
            }
            case 4752: {
                if (59 != current) break;
                this.match = "\u2111";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4753: {
                if (105 != current) break;
                this.state = 4754;
                return true;
            }
            case 4754: {
                if (110 != current) break;
                this.state = 4755;
                return true;
            }
            case 4755: {
                if (101 != current) break;
                this.state = 4756;
                return true;
            }
            case 4756: {
                if (59 != current) break;
                this.match = "\u2110";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4757: {
                if (97 != current) break;
                this.state = 4758;
                return true;
            }
            case 4758: {
                if (114 != current) break;
                this.state = 4759;
                return true;
            }
            case 4759: {
                if (116 != current) break;
                this.state = 4760;
                return true;
            }
            case 4760: {
                if (59 != current) break;
                this.match = "\u2111";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4761: {
                if (104 != current) break;
                this.state = 4762;
                return true;
            }
            case 4762: {
                if (59 != current) break;
                this.match = "\u0131";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4763: {
                if (102 != current) break;
                this.state = 4764;
                return true;
            }
            case 4764: {
                if (59 != current) break;
                this.match = "\u22b7";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4765: {
                if (101 != current) break;
                this.state = 4766;
                return true;
            }
            case 4766: {
                if (100 != current) break;
                this.state = 4767;
                return true;
            }
            case 4767: {
                if (59 != current) break;
                this.match = "\u01b5";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4768: {
                switch (current) {
                    case 59: {
                        this.match = "\u2208";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 99: {
                        this.state = 4769;
                        return true;
                    }
                    case 102: {
                        this.state = 4773;
                        return true;
                    }
                    case 111: {
                        this.state = 4779;
                        return true;
                    }
                    case 116: {
                        this.state = 4783;
                        return true;
                    }
                }
                break;
            }
            case 4769: {
                if (97 != current) break;
                this.state = 4770;
                return true;
            }
            case 4770: {
                if (114 != current) break;
                this.state = 4771;
                return true;
            }
            case 4771: {
                if (101 != current) break;
                this.state = 4772;
                return true;
            }
            case 4772: {
                if (59 != current) break;
                this.match = "\u2105";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4773: {
                if (105 != current) break;
                this.state = 4774;
                return true;
            }
            case 4774: {
                if (110 != current) break;
                this.state = 4775;
                return true;
            }
            case 4775: {
                if (59 == current) {
                    this.match = "\u221e";
                    this.matchLength = this.consumedCount;
                    this.state = -2;
                    return false;
                }
                if (116 != current) break;
                this.state = 4776;
                return true;
            }
            case 4776: {
                if (105 != current) break;
                this.state = 4777;
                return true;
            }
            case 4777: {
                if (101 != current) break;
                this.state = 4778;
                return true;
            }
            case 4778: {
                if (59 != current) break;
                this.match = "\u29dd";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4779: {
                if (100 != current) break;
                this.state = 4780;
                return true;
            }
            case 4780: {
                if (111 != current) break;
                this.state = 4781;
                return true;
            }
            case 4781: {
                if (116 != current) break;
                this.state = 4782;
                return true;
            }
            case 4782: {
                if (59 != current) break;
                this.match = "\u0131";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4783: {
                switch (current) {
                    case 59: {
                        this.match = "\u222b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 99: {
                        this.state = 4784;
                        return true;
                    }
                    case 101: {
                        this.state = 4787;
                        return true;
                    }
                    case 108: {
                        this.state = 4796;
                        return true;
                    }
                    case 112: {
                        this.state = 4801;
                        return true;
                    }
                }
                break;
            }
            case 4784: {
                if (97 != current) break;
                this.state = 4785;
                return true;
            }
            case 4785: {
                if (108 != current) break;
                this.state = 4786;
                return true;
            }
            case 4786: {
                if (59 != current) break;
                this.match = "\u22ba";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4787: {
                if (103 == current) {
                    this.state = 4788;
                    return true;
                }
                if (114 != current) break;
                this.state = 4792;
                return true;
            }
            case 4788: {
                if (101 != current) break;
                this.state = 4789;
                return true;
            }
            case 4789: {
                if (114 != current) break;
                this.state = 4790;
                return true;
            }
            case 4790: {
                if (115 != current) break;
                this.state = 4791;
                return true;
            }
            case 4791: {
                if (59 != current) break;
                this.match = "\u2124";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4792: {
                if (99 != current) break;
                this.state = 4793;
                return true;
            }
            case 4793: {
                if (97 != current) break;
                this.state = 4794;
                return true;
            }
            case 4794: {
                if (108 != current) break;
                this.state = 4795;
                return true;
            }
            case 4795: {
                if (59 != current) break;
                this.match = "\u22ba";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4796: {
                if (97 != current) break;
                this.state = 4797;
                return true;
            }
            case 4797: {
                if (114 != current) break;
                this.state = 4798;
                return true;
            }
            case 4798: {
                if (104 != current) break;
                this.state = 4799;
                return true;
            }
            case 4799: {
                if (107 != current) break;
                this.state = 4800;
                return true;
            }
            case 4800: {
                if (59 != current) break;
                this.match = "\u2a17";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4801: {
                if (114 != current) break;
                this.state = 4802;
                return true;
            }
            case 4802: {
                if (111 != current) break;
                this.state = 4803;
                return true;
            }
            case 4803: {
                if (100 != current) break;
                this.state = 4804;
                return true;
            }
            case 4804: {
                if (59 != current) break;
                this.match = "\u2a3c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4805: {
                switch (current) {
                    case 99: {
                        this.state = 4806;
                        return true;
                    }
                    case 103: {
                        this.state = 4808;
                        return true;
                    }
                    case 112: {
                        this.state = 4811;
                        return true;
                    }
                    case 116: {
                        this.state = 4813;
                        return true;
                    }
                }
                break;
            }
            case 4806: {
                if (121 != current) break;
                this.state = 4807;
                return true;
            }
            case 4807: {
                if (59 != current) break;
                this.match = "\u0451";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4808: {
                if (111 != current) break;
                this.state = 4809;
                return true;
            }
            case 4809: {
                if (110 != current) break;
                this.state = 4810;
                return true;
            }
            case 4810: {
                if (59 != current) break;
                this.match = "\u012f";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4811: {
                if (102 != current) break;
                this.state = 4812;
                return true;
            }
            case 4812: {
                if (59 != current) break;
                this.match = "\ud835\udd5a";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4813: {
                if (97 != current) break;
                this.state = 4814;
                return true;
            }
            case 4814: {
                if (59 != current) break;
                this.match = "\u03b9";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4815: {
                if (114 != current) break;
                this.state = 4816;
                return true;
            }
            case 4816: {
                if (111 != current) break;
                this.state = 4817;
                return true;
            }
            case 4817: {
                if (100 != current) break;
                this.state = 4818;
                return true;
            }
            case 4818: {
                if (59 != current) break;
                this.match = "\u2a3c";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4819: {
                if (117 != current) break;
                this.state = 4820;
                return true;
            }
            case 4820: {
                if (101 != current) break;
                this.state = 4821;
                return true;
            }
            case 4821: {
                if (115 != current) break;
                this.state = 4822;
                return true;
            }
            case 4822: {
                if (116 != current) break;
                this.match = "\u00bf";
                this.matchLength = this.consumedCount;
                this.state = 4823;
                return true;
            }
            case 4823: {
                if (59 != current) break;
                this.match = "\u00bf";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4824: {
                if (99 == current) {
                    this.state = 4825;
                    return true;
                }
                if (105 != current) break;
                this.state = 4827;
                return true;
            }
            case 4825: {
                if (114 != current) break;
                this.state = 4826;
                return true;
            }
            case 4826: {
                if (59 != current) break;
                this.match = "\ud835\udcbe";
                this.matchLength = this.consumedCount;
                this.state = -2;
                return false;
            }
            case 4827: {
                if (110 