/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_0;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"column", "hidden", "legendSet", "meta", "name", "optionSet", "programStage", "repeatableStageParams", "stageOffset", "type", "valueType"})
public class GridHeader
implements Serializable {
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="hidden")
    private Boolean hidden;
    @JsonProperty(value="legendSet")
    private String legendSet;
    @JsonProperty(value="meta")
    private Boolean meta;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="optionSet")
    private String optionSet;
    @JsonProperty(value="programStage")
    private String programStage;
    @JsonProperty(value="repeatableStageParams")
    private String repeatableStageParams;
    @JsonProperty(value="stageOffset")
    private Integer stageOffset;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="valueType")
    private ValueType valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -6519320612437176619L;

    public GridHeader() {
    }

    public GridHeader(GridHeader source) {
        this.column = source.column;
        this.hidden = source.hidden;
        this.legendSet = source.legendSet;
        this.meta = source.meta;
        this.name = source.name;
        this.optionSet = source.optionSet;
        this.programStage = source.programStage;
        this.repeatableStageParams = source.repeatableStageParams;
        this.stageOffset = source.stageOffset;
        this.type = source.type;
        this.valueType = source.valueType;
    }

    public GridHeader(String column, Boolean hidden, String legendSet, Boolean meta, String name, String optionSet, String programStage, String repeatableStageParams, Integer stageOffset, String type, ValueType valueType) {
        this.column = column;
        this.hidden = hidden;
        this.legendSet = legendSet;
        this.meta = meta;
        this.name = name;
        this.optionSet = optionSet;
        this.programStage = programStage;
        this.repeatableStageParams = repeatableStageParams;
        this.stageOffset = stageOffset;
        this.type = type;
        this.valueType = valueType;
    }

    @JsonProperty(value="column")
    public Optional<String> getColumn() {
        return Optional.ofNullable(this.column);
    }

    @JsonProperty(value="column")
    public void setColumn(String column) {
        this.column = column;
    }

    public GridHeader withColumn(String column) {
        this.column = column;
        return this;
    }

    @JsonProperty(value="hidden")
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public GridHeader withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @JsonProperty(value="legendSet")
    public Optional<String> getLegendSet() {
        return Optional.ofNullable(this.legendSet);
    }

    @JsonProperty(value="legendSet")
    public void setLegendSet(String legendSet) {
        this.legendSet = legendSet;
    }

    public GridHeader withLegendSet(String legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty(value="meta")
    public Boolean getMeta() {
        return this.meta;
    }

    @JsonProperty(value="meta")
    public void setMeta(Boolean meta) {
        this.meta = meta;
    }

    public GridHeader withMeta(Boolean meta) {
        this.meta = meta;
        return this;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GridHeader withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="optionSet")
    public Optional<String> getOptionSet() {
        return Optional.ofNullable(this.optionSet);
    }

    @JsonProperty(value="optionSet")
    public void setOptionSet(String optionSet) {
        this.optionSet = optionSet;
    }

    public GridHeader withOptionSet(String optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    @JsonProperty(value="programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(this.programStage);
    }

    @JsonProperty(value="programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public GridHeader withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty(value="repeatableStageParams")
    public Optional<String> getRepeatableStageParams() {
        return Optional.ofNullable(this.repeatableStageParams);
    }

    @JsonProperty(value="repeatableStageParams")
    public void setRepeatableStageParams(String repeatableStageParams) {
        this.repeatableStageParams = repeatableStageParams;
    }

    public GridHeader withRepeatableStageParams(String repeatableStageParams) {
        this.repeatableStageParams = repeatableStageParams;
        return this;
    }

    @JsonProperty(value="stageOffset")
    public Optional<Integer> getStageOffset() {
        return Optional.ofNullable(this.stageOffset);
    }

    @JsonProperty(value="stageOffset")
    public void setStageOffset(Integer stageOffset) {
        this.stageOffset = stageOffset;
    }

    public GridHeader withStageOffset(Integer stageOffset) {
        this.stageOffset = stageOffset;
        return this;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public GridHeader withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="valueType")
    public ValueType getValueType() {
        return this.valueType;
    }

    @JsonProperty(value="valueType")
    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public GridHeader withValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GridHeader withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("column".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"column\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setColumn((String)value);
            return true;
        }
        if ("hidden".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"hidden\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setHidden((Boolean)value);
            return true;
        }
        if ("legendSet".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"legendSet\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setLegendSet((String)value);
            return true;
        }
        if ("meta".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"meta\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setMeta((Boolean)value);
            return true;
        }
        if ("name".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"name\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setName((String)value);
            return true;
        }
        if ("optionSet".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"optionSet\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setOptionSet((String)value);
            return true;
        }
        if ("programStage".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"programStage\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setProgramStage((String)value);
            return true;
        }
        if ("repeatableStageParams".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"repeatableStageParams\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRepeatableStageParams((String)value);
            return true;
        }
        if ("stageOffset".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"stageOffset\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setStageOffset((Integer)value);
            return true;
        }
        if ("type".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"type\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setType((String)value);
            return true;
        }
        if ("valueType".equals(name)) {
            if (!(value instanceof ValueType)) {
                throw new IllegalArgumentException("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_0.GridHeader.ValueType\", but got " + value.getClass().toString());
            }
            this.setValueType((ValueType)((Object)value));
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("column".equals(name)) {
            return this.getColumn();
        }
        if ("hidden".equals(name)) {
            return this.getHidden();
        }
        if ("legendSet".equals(name)) {
            return this.getLegendSet();
        }
        if ("meta".equals(name)) {
            return this.getMeta();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("optionSet".equals(name)) {
            return this.getOptionSet();
        }
        if ("programStage".equals(name)) {
            return this.getProgramStage();
        }
        if ("repeatableStageParams".equals(name)) {
            return this.getRepeatableStageParams();
        }
        if ("stageOffset".equals(name)) {
            return this.getStageOffset();
        }
        if ("type".equals(name)) {
            return this.getType();
        }
        if ("valueType".equals(name)) {
            return this.getValueType();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public GridHeader with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GridHeader.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("column");
        sb.append('=');
        sb.append(this.column == null ? "<null>" : this.column);
        sb.append(',');
        sb.append("hidden");
        sb.append('=');
        sb.append(this.hidden == null ? "<null>" : this.hidden);
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(this.legendSet == null ? "<null>" : this.legendSet);
        sb.append(',');
        sb.append("meta");
        sb.append('=');
        sb.append(this.meta == null ? "<null>" : this.meta);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(this.optionSet == null ? "<null>" : this.optionSet);
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(this.programStage == null ? "<null>" : this.programStage);
        sb.append(',');
        sb.append("repeatableStageParams");
        sb.append('=');
        sb.append(this.repeatableStageParams == null ? "<null>" : this.repeatableStageParams);
        sb.append(',');
        sb.append("stageOffset");
        sb.append('=');
        sb.append(this.stageOffset == null ? "<null>" : this.stageOffset);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(this.valueType == null ? "<null>" : this.valueType);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.programStage == null ? 0 : this.programStage.hashCode());
        result = result * 31 + (this.hidden == null ? 0 : this.hidden.hashCode());
        result = result * 31 + (this.column == null ? 0 : this.column.hashCode());
        result = result * 31 + (this.repeatableStageParams == null ? 0 : this.repeatableStageParams.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.stageOffset == null ? 0 : this.stageOffset.hashCode());
        result = result * 31 + (this.optionSet == null ? 0 : this.optionSet.hashCode());
        result = result * 31 + (this.meta == null ? 0 : this.meta.hashCode());
        result = result * 31 + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = result * 31 + (this.legendSet == null ? 0 : this.legendSet.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GridHeader)) {
            return false;
        }
        GridHeader rhs = (GridHeader)other;
        return (this.programStage == rhs.programStage || this.programStage != null && this.programStage.equals(rhs.programStage)) && (this.hidden == rhs.hidden || this.hidden != null && this.hidden.equals(rhs.hidden)) && (this.column == rhs.column || this.column != null && this.column.equals(rhs.column)) && (this.repeatableStageParams == rhs.repeatableStageParams || this.repeatableStageParams != null && this.repeatableStageParams.equals(rhs.repeatableStageParams)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.stageOffset == rhs.stageOffset || this.stageOffset != null && this.stageOffset.equals(rhs.stageOffset)) && (this.optionSet == rhs.optionSet || this.optionSet != null && this.optionSet.equals(rhs.optionSet)) && (this.meta == rhs.meta || this.meta != null && this.meta.equals(rhs.meta)) && (this.valueType == rhs.valueType || this.valueType != null && this.valueType.equals((Object)rhs.valueType)) && (this.legendSet == rhs.legendSet || this.legendSet != null && this.legendSet.equals(rhs.legendSet)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }

    public static enum ValueType {
        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");

        private final String value;
        private static final Map<String, ValueType> CONSTANTS;

        private ValueType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ValueType fromValue(String value) {
            ValueType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, ValueType>();
            for (ValueType c : ValueType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

