/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum QueryableDataItem {
    INDICATOR("INDICATOR"),
    DATA_ELEMENT("DATA_ELEMENT"),
    DATA_SET("DATA_SET"),
    PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
    PROGRAM_DATA_ELEMENT("PROGRAM_DATA_ELEMENT"),
    PROGRAM_ATTRIBUTE("PROGRAM_ATTRIBUTE");

    private final String value;
    private static final Map<String, QueryableDataItem> CONSTANTS;

    private QueryableDataItem(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static QueryableDataItem fromValue(String value) {
        QueryableDataItem constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, QueryableDataItem>();
        for (QueryableDataItem c : QueryableDataItem.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

