/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Permission {
    READ("READ"),
    WRITE("WRITE"),
    DATA_READ("DATA_READ"),
    DATA_WRITE("DATA_WRITE");

    private final String value;
    private static final Map<String, Permission> CONSTANTS;

    private Permission(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Permission fromValue(String value) {
        Permission constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Permission>();
        for (Permission c : Permission.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

