/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ParserType {
    KEY_VALUE_PARSER("KEY_VALUE_PARSER"),
    J_2_ME_PARSER("J2ME_PARSER"),
    ALERT_PARSER("ALERT_PARSER"),
    UNREGISTERED_PARSER("UNREGISTERED_PARSER"),
    TRACKED_ENTITY_REGISTRATION_PARSER("TRACKED_ENTITY_REGISTRATION_PARSER"),
    PROGRAM_STAGE_DATAENTRY_PARSER("PROGRAM_STAGE_DATAENTRY_PARSER"),
    EVENT_REGISTRATION_PARSER("EVENT_REGISTRATION_PARSER");

    private final String value;
    private static final Map<String, ParserType> CONSTANTS;

    private ParserType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ParserType fromValue(String value) {
        ParserType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ParserType>();
        for (ParserType c : ParserType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

