/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ParseType {
    INDICATOR_EXPRESSION("INDICATOR_EXPRESSION"),
    VALIDATION_RULE_EXPRESSION("VALIDATION_RULE_EXPRESSION"),
    PREDICTOR_EXPRESSION("PREDICTOR_EXPRESSION"),
    PREDICTOR_SKIP_TEST("PREDICTOR_SKIP_TEST"),
    SIMPLE_TEST("SIMPLE_TEST");

    private final String value;
    private static final Map<String, ParseType> CONSTANTS;

    private ParseType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ParseType fromValue(String value) {
        ParseType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ParseType>();
        for (ParseType c : ParseType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

