/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v2_38_1.OutlierLine;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enabled", "extremeLines", "normalizationMethod", "outlierMethod", "thresholdFactor"})
public class OutlierAnalysis
implements Serializable {
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="extremeLines")
    private OutlierLine extremeLines;
    @JsonProperty(value="normalizationMethod")
    private String normalizationMethod;
    @JsonProperty(value="outlierMethod")
    private OutlierMethod outlierMethod;
    @JsonProperty(value="thresholdFactor")
    private Double thresholdFactor;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 7869592876356761401L;

    public OutlierAnalysis() {
    }

    public OutlierAnalysis(OutlierAnalysis source) {
        this.enabled = source.enabled;
        this.extremeLines = source.extremeLines;
        this.normalizationMethod = source.normalizationMethod;
        this.outlierMethod = source.outlierMethod;
        this.thresholdFactor = source.thresholdFactor;
    }

    public OutlierAnalysis(Boolean enabled, OutlierLine extremeLines, String normalizationMethod, OutlierMethod outlierMethod, Double thresholdFactor) {
        this.enabled = enabled;
        this.extremeLines = extremeLines;
        this.normalizationMethod = normalizationMethod;
        this.outlierMethod = outlierMethod;
        this.thresholdFactor = thresholdFactor;
    }

    @JsonProperty(value="enabled")
    public Optional<Boolean> getEnabled() {
        return Optional.ofNullable(this.enabled);
    }

    @JsonProperty(value="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public OutlierAnalysis withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @JsonProperty(value="extremeLines")
    public Optional<OutlierLine> getExtremeLines() {
        return Optional.ofNullable(this.extremeLines);
    }

    @JsonProperty(value="extremeLines")
    public void setExtremeLines(OutlierLine extremeLines) {
        this.extremeLines = extremeLines;
    }

    public OutlierAnalysis withExtremeLines(OutlierLine extremeLines) {
        this.extremeLines = extremeLines;
        return this;
    }

    @JsonProperty(value="normalizationMethod")
    public Optional<String> getNormalizationMethod() {
        return Optional.ofNullable(this.normalizationMethod);
    }

    @JsonProperty(value="normalizationMethod")
    public void setNormalizationMethod(String normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
    }

    public OutlierAnalysis withNormalizationMethod(String normalizationMethod) {
        this.normalizationMethod = normalizationMethod;
        return this;
    }

    @JsonProperty(value="outlierMethod")
    public Optional<OutlierMethod> getOutlierMethod() {
        return Optional.ofNullable(this.outlierMethod);
    }

    @JsonProperty(value="outlierMethod")
    public void setOutlierMethod(OutlierMethod outlierMethod) {
        this.outlierMethod = outlierMethod;
    }

    public OutlierAnalysis withOutlierMethod(OutlierMethod outlierMethod) {
        this.outlierMethod = outlierMethod;
        return this;
    }

    @JsonProperty(value="thresholdFactor")
    public Optional<Double> getThresholdFactor() {
        return Optional.ofNullable(this.thresholdFactor);
    }

    @JsonProperty(value="thresholdFactor")
    public void setThresholdFactor(Double thresholdFactor) {
        this.thresholdFactor = thresholdFactor;
    }

    public OutlierAnalysis withThresholdFactor(Double thresholdFactor) {
        this.thresholdFactor = thresholdFactor;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierAnalysis withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("enabled".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"enabled\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setEnabled((Boolean)value);
            return true;
        }
        if ("extremeLines".equals(name)) {
            if (!(value instanceof OutlierLine)) {
                throw new IllegalArgumentException("property \"extremeLines\" is of type \"org.hisp.dhis.api.model.v2_38_1.OutlierLine\", but got " + value.getClass().toString());
            }
            this.setExtremeLines((OutlierLine)value);
            return true;
        }
        if ("normalizationMethod".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"normalizationMethod\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setNormalizationMethod((String)value);
            return true;
        }
        if ("outlierMethod".equals(name)) {
            if (!(value instanceof OutlierMethod)) {
                throw new IllegalArgumentException("property \"outlierMethod\" is of type \"org.hisp.dhis.api.model.v2_38_1.OutlierAnalysis.OutlierMethod\", but got " + value.getClass().toString());
            }
            this.setOutlierMethod((OutlierMethod)((Object)value));
            return true;
        }
        if ("thresholdFactor".equals(name)) {
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("property \"thresholdFactor\" is of type \"java.lang.Double\", but got " + value.getClass().toString());
            }
            this.setThresholdFactor((Double)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("enabled".equals(name)) {
            return this.getEnabled();
        }
        if ("extremeLines".equals(name)) {
            return this.getExtremeLines();
        }
        if ("normalizationMethod".equals(name)) {
            return this.getNormalizationMethod();
        }
        if ("outlierMethod".equals(name)) {
            return this.getOutlierMethod();
        }
        if ("thresholdFactor".equals(name)) {
            return this.getThresholdFactor();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public OutlierAnalysis with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierAnalysis.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("enabled");
        sb.append('=');
        sb.append(this.enabled == null ? "<null>" : this.enabled);
        sb.append(',');
        sb.append("extremeLines");
        sb.append('=');
        sb.append(this.extremeLines == null ? "<null>" : this.extremeLines);
        sb.append(',');
        sb.append("normalizationMethod");
        sb.append('=');
        sb.append(this.normalizationMethod == null ? "<null>" : this.normalizationMethod);
        sb.append(',');
        sb.append("outlierMethod");
        sb.append('=');
        sb.append(this.outlierMethod == null ? "<null>" : this.outlierMethod);
        sb.append(',');
        sb.append("thresholdFactor");
        sb.append('=');
        sb.append(this.thresholdFactor == null ? "<null>" : this.thresholdFactor);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.thresholdFactor == null ? 0 : this.thresholdFactor.hashCode());
        result = result * 31 + (this.extremeLines == null ? 0 : this.extremeLines.hashCode());
        result = result * 31 + (this.normalizationMethod == null ? 0 : this.normalizationMethod.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = result * 31 + (this.outlierMethod == null ? 0 : this.outlierMethod.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OutlierAnalysis)) {
            return false;
        }
        OutlierAnalysis rhs = (OutlierAnalysis)other;
        return (this.thresholdFactor == rhs.thresholdFactor || this.thresholdFactor != null && this.thresholdFactor.equals(rhs.thresholdFactor)) && (this.extremeLines == rhs.extremeLines || this.extremeLines != null && this.extremeLines.equals(rhs.extremeLines)) && (this.normalizationMethod == rhs.normalizationMethod || this.normalizationMethod != null && this.normalizationMethod.equals(rhs.normalizationMethod)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.enabled == rhs.enabled || this.enabled != null && this.enabled.equals(rhs.enabled)) && (this.outlierMethod == rhs.outlierMethod || this.outlierMethod != null && this.outlierMethod.equals((Object)rhs.outlierMethod));
    }

    public static enum OutlierMethod {
        IQR("IQR"),
        STANDARD_Z_SCORE("STANDARD_Z_SCORE"),
        MODIFIED_Z_SCORE("MODIFIED_Z_SCORE");

        private final String value;
        private static final Map<String, OutlierMethod> CONSTANTS;

        private OutlierMethod(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutlierMethod fromValue(String value) {
            OutlierMethod constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OutlierMethod>();
            for (OutlierMethod c : OutlierMethod.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

