/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_38_1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"description", "introduction", "name", "recommendation", "section", "severity"})
public class DataIntegrityCheck
implements Serializable {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="introduction")
    private String introduction;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="recommendation")
    private String recommendation;
    @JsonProperty(value="section")
    private String section;
    @JsonProperty(value="severity")
    private DataIntegritySeverity severity;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 2867841401485606943L;

    public DataIntegrityCheck() {
    }

    public DataIntegrityCheck(DataIntegrityCheck source) {
        this.description = source.description;
        this.introduction = source.introduction;
        this.name = source.name;
        this.recommendation = source.recommendation;
        this.section = source.section;
        this.severity = source.severity;
    }

    public DataIntegrityCheck(String description, String introduction, String name, String recommendation, String section, DataIntegritySeverity severity) {
        this.description = description;
        this.introduction = introduction;
        this.name = name;
        this.recommendation = recommendation;
        this.section = section;
        this.severity = severity;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataIntegrityCheck withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="introduction")
    public Optional<String> getIntroduction() {
        return Optional.ofNullable(this.introduction);
    }

    @JsonProperty(value="introduction")
    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public DataIntegrityCheck withIntroduction(String introduction) {
        this.introduction = introduction;
        return this;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public DataIntegrityCheck withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="recommendation")
    public Optional<String> getRecommendation() {
        return Optional.ofNullable(this.recommendation);
    }

    @JsonProperty(value="recommendation")
    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    public DataIntegrityCheck withRecommendation(String recommendation) {
        this.recommendation = recommendation;
        return this;
    }

    @JsonProperty(value="section")
    public Optional<String> getSection() {
        return Optional.ofNullable(this.section);
    }

    @JsonProperty(value="section")
    public void setSection(String section) {
        this.section = section;
    }

    public DataIntegrityCheck withSection(String section) {
        this.section = section;
        return this;
    }

    @JsonProperty(value="severity")
    public Optional<DataIntegritySeverity> getSeverity() {
        return Optional.ofNullable(this.severity);
    }

    @JsonProperty(value="severity")
    public void setSeverity(DataIntegritySeverity severity) {
        this.severity = severity;
    }

    public DataIntegrityCheck withSeverity(DataIntegritySeverity severity) {
        this.severity = severity;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataIntegrityCheck withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("description".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"description\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDescription((String)value);
            return true;
        }
        if ("introduction".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"introduction\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setIntroduction((String)value);
            return true;
        }
        if ("name".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"name\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setName((String)value);
            return true;
        }
        if ("recommendation".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"recommendation\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setRecommendation((String)value);
            return true;
        }
        if ("section".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"section\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setSection((String)value);
            return true;
        }
        if ("severity".equals(name)) {
            if (!(value instanceof DataIntegritySeverity)) {
                throw new IllegalArgumentException("property \"severity\" is of type \"org.hisp.dhis.api.model.v2_38_1.DataIntegrityCheck.DataIntegritySeverity\", but got " + value.getClass().toString());
            }
            this.setSeverity((DataIntegritySeverity)((Object)value));
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("description".equals(name)) {
            return this.getDescription();
        }
        if ("introduction".equals(name)) {
            return this.getIntroduction();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("recommendation".equals(name)) {
            return this.getRecommendation();
        }
        if ("section".equals(name)) {
            return this.getSection();
        }
        if ("severity".equals(name)) {
            return this.getSeverity();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public DataIntegrityCheck with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataIntegrityCheck.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("introduction");
        sb.append('=');
        sb.append(this.introduction == null ? "<null>" : this.introduction);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("recommendation");
        sb.append('=');
        sb.append(this.recommendation == null ? "<null>" : this.recommendation);
        sb.append(',');
        sb.append("section");
        sb.append('=');
        sb.append(this.section == null ? "<null>" : this.section);
        sb.append(',');
        sb.append("severity");
        sb.append('=');
        sb.append(this.severity == null ? "<null>" : this.severity);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.severity == null ? 0 : this.severity.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.recommendation == null ? 0 : this.recommendation.hashCode());
        result = result * 31 + (this.section == null ? 0 : this.section.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.introduction == null ? 0 : this.introduction.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataIntegrityCheck)) {
            return false;
        }
        DataIntegrityCheck rhs = (DataIntegrityCheck)other;
        return (this.severity == rhs.severity || this.severity != null && this.severity.equals((Object)rhs.severity)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.recommendation == rhs.recommendation || this.recommendation != null && this.recommendation.equals(rhs.recommendation)) && (this.section == rhs.section || this.section != null && this.section.equals(rhs.section)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.introduction == rhs.introduction || this.introduction != null && this.introduction.equals(rhs.introduction));
    }

    public static enum DataIntegritySeverity {
        INFO("INFO"),
        WARNING("WARNING"),
        SEVERE("SEVERE"),
        CRITICAL("CRITICAL");

        private final String value;
        private static final Map<String, DataIntegritySeverity> CONSTANTS;

        private DataIntegritySeverity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataIntegritySeverity fromValue(String value) {
            DataIntegritySeverity constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DataIntegritySeverity>();
            for (DataIntegritySeverity c : DataIntegritySeverity.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

