/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SystemJob {
    FILE_RESOURCE("FILE_RESOURCE"),
    DATA_STATISTICS("DATA_STATISTICS"),
    VALIDATION_RESULTS_NOTIFICATION("VALIDATION_RESULTS_NOTIFICATION"),
    CREDENTIALS_EXPIRY_ALERT("CREDENTIALS_EXPIRY_ALERT"),
    ACCOUNT_EXPIRY_ALERT("ACCOUNT_EXPIRY_ALERT"),
    DATA_SET_NOTIFICATION("DATA_SET_NOTIFICATION"),
    REMOVE_EXPIRED_OR_USED_RESERVED_VALUES("REMOVE_EXPIRED_OR_USED_RESERVED_VALUES"),
    LEADER_ELECTION("LEADER_ELECTION");

    private final String value;
    private static final Map<String, SystemJob> CONSTANTS;

    private SystemJob(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SystemJob fromValue(String value) {
        SystemJob constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SystemJob>();
        for (SystemJob c : SystemJob.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

