/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v2_37_7.DeliveryChannel;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"batchType", "errorMessage", "failed", "pending", "responseMessage", "sent", "status", "total"})
public class OutboundMessageResponseSummary
implements Serializable {
    @JsonProperty(value="batchType")
    private DeliveryChannel batchType;
    @JsonProperty(value="errorMessage")
    private String errorMessage;
    @JsonProperty(value="failed")
    private Integer failed;
    @JsonProperty(value="pending")
    private Integer pending;
    @JsonProperty(value="responseMessage")
    private String responseMessage;
    @JsonProperty(value="sent")
    private Integer sent;
    @JsonProperty(value="status")
    private OutboundMessageBatchStatus status;
    @JsonProperty(value="total")
    private Integer total;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -8563845232412919804L;

    public OutboundMessageResponseSummary() {
    }

    public OutboundMessageResponseSummary(OutboundMessageResponseSummary source) {
        this.batchType = source.batchType;
        this.errorMessage = source.errorMessage;
        this.failed = source.failed;
        this.pending = source.pending;
        this.responseMessage = source.responseMessage;
        this.sent = source.sent;
        this.status = source.status;
        this.total = source.total;
    }

    public OutboundMessageResponseSummary(DeliveryChannel batchType, String errorMessage, Integer failed, Integer pending, String responseMessage, Integer sent, OutboundMessageBatchStatus status, Integer total) {
        this.batchType = batchType;
        this.errorMessage = errorMessage;
        this.failed = failed;
        this.pending = pending;
        this.responseMessage = responseMessage;
        this.sent = sent;
        this.status = status;
        this.total = total;
    }

    @JsonProperty(value="batchType")
    public Optional<DeliveryChannel> getBatchType() {
        return Optional.ofNullable(this.batchType);
    }

    @JsonProperty(value="batchType")
    public void setBatchType(DeliveryChannel batchType) {
        this.batchType = batchType;
    }

    public OutboundMessageResponseSummary withBatchType(DeliveryChannel batchType) {
        this.batchType = batchType;
        return this;
    }

    @JsonProperty(value="errorMessage")
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    @JsonProperty(value="errorMessage")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public OutboundMessageResponseSummary withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @JsonProperty(value="failed")
    public Optional<Integer> getFailed() {
        return Optional.ofNullable(this.failed);
    }

    @JsonProperty(value="failed")
    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public OutboundMessageResponseSummary withFailed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @JsonProperty(value="pending")
    public Optional<Integer> getPending() {
        return Optional.ofNullable(this.pending);
    }

    @JsonProperty(value="pending")
    public void setPending(Integer pending) {
        this.pending = pending;
    }

    public OutboundMessageResponseSummary withPending(Integer pending) {
        this.pending = pending;
        return this;
    }

    @JsonProperty(value="responseMessage")
    public Optional<String> getResponseMessage() {
        return Optional.ofNullable(this.responseMessage);
    }

    @JsonProperty(value="responseMessage")
    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public OutboundMessageResponseSummary withResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    @JsonProperty(value="sent")
    public Optional<Integer> getSent() {
        return Optional.ofNullable(this.sent);
    }

    @JsonProperty(value="sent")
    public void setSent(Integer sent) {
        this.sent = sent;
    }

    public OutboundMessageResponseSummary withSent(Integer sent) {
        this.sent = sent;
        return this;
    }

    @JsonProperty(value="status")
    public Optional<OutboundMessageBatchStatus> getStatus() {
        return Optional.ofNullable(this.status);
    }

    @JsonProperty(value="status")
    public void setStatus(OutboundMessageBatchStatus status) {
        this.status = status;
    }

    public OutboundMessageResponseSummary withStatus(OutboundMessageBatchStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="total")
    public Optional<Integer> getTotal() {
        return Optional.ofNullable(this.total);
    }

    @JsonProperty(value="total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public OutboundMessageResponseSummary withTotal(Integer total) {
        this.total = total;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutboundMessageResponseSummary withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("batchType".equals(name)) {
            if (!(value instanceof DeliveryChannel)) {
                throw new IllegalArgumentException("property \"batchType\" is of type \"org.hisp.dhis.api.model.v2_37_7.DeliveryChannel\", but got " + value.getClass().toString());
            }
            this.setBatchType((DeliveryChannel)((Object)value));
            return true;
        }
        if ("errorMessage".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"errorMessage\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setErrorMessage((String)value);
            return true;
        }
        if ("failed".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"failed\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setFailed((Integer)value);
            return true;
        }
        if ("pending".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"pending\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setPending((Integer)value);
            return true;
        }
        if ("responseMessage".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"responseMessage\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setResponseMessage((String)value);
            return true;
        }
        if ("sent".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"sent\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setSent((Integer)value);
            return true;
        }
        if ("status".equals(name)) {
            if (!(value instanceof OutboundMessageBatchStatus)) {
                throw new IllegalArgumentException("property \"status\" is of type \"org.hisp.dhis.api.model.v2_37_7.OutboundMessageResponseSummary.OutboundMessageBatchStatus\", but got " + value.getClass().toString());
            }
            this.setStatus((OutboundMessageBatchStatus)((Object)value));
            return true;
        }
        if ("total".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"total\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setTotal((Integer)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("batchType".equals(name)) {
            return this.getBatchType();
        }
        if ("errorMessage".equals(name)) {
            return this.getErrorMessage();
        }
        if ("failed".equals(name)) {
            return this.getFailed();
        }
        if ("pending".equals(name)) {
            return this.getPending();
        }
        if ("responseMessage".equals(name)) {
            return this.getResponseMessage();
        }
        if ("sent".equals(name)) {
            return this.getSent();
        }
        if ("status".equals(name)) {
            return this.getStatus();
        }
        if ("total".equals(name)) {
            return this.getTotal();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public OutboundMessageResponseSummary with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutboundMessageResponseSummary.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("batchType");
        sb.append('=');
        sb.append(this.batchType == null ? "<null>" : this.batchType);
        sb.append(',');
        sb.append("errorMessage");
        sb.append('=');
        sb.append(this.errorMessage == null ? "<null>" : this.errorMessage);
        sb.append(',');
        sb.append("failed");
        sb.append('=');
        sb.append(this.failed == null ? "<null>" : this.failed);
        sb.append(',');
        sb.append("pending");
        sb.append('=');
        sb.append(this.pending == null ? "<null>" : this.pending);
        sb.append(',');
        sb.append("responseMessage");
        sb.append('=');
        sb.append(this.responseMessage == null ? "<null>" : this.responseMessage);
        sb.append(',');
        sb.append("sent");
        sb.append('=');
        sb.append(this.sent == null ? "<null>" : this.sent);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(this.total == null ? "<null>" : this.total);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.total == null ? 0 : this.total.hashCode());
        result = result * 31 + (this.pending == null ? 0 : this.pending.hashCode());
        result = result * 31 + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        result = result * 31 + (this.failed == null ? 0 : this.failed.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.batchType == null ? 0 : this.batchType.hashCode());
        result = result * 31 + (this.responseMessage == null ? 0 : this.responseMessage.hashCode());
        result = result * 31 + (this.sent == null ? 0 : this.sent.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OutboundMessageResponseSummary)) {
            return false;
        }
        OutboundMessageResponseSummary rhs = (OutboundMessageResponseSummary)other;
        return (this.total == rhs.total || this.total != null && this.total.equals(rhs.total)) && (this.pending == rhs.pending || this.pending != null && this.pending.equals(rhs.pending)) && (this.errorMessage == rhs.errorMessage || this.errorMessage != null && this.errorMessage.equals(rhs.errorMessage)) && (this.failed == rhs.failed || this.failed != null && this.failed.equals(rhs.failed)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.batchType == rhs.batchType || this.batchType != null && this.batchType.equals((Object)rhs.batchType)) && (this.responseMessage == rhs.responseMessage || this.responseMessage != null && this.responseMessage.equals(rhs.responseMessage)) && (this.sent == rhs.sent || this.sent != null && this.sent.equals(rhs.sent)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum OutboundMessageBatchStatus {
        COMPLETED("COMPLETED"),
        FAILED("FAILED"),
        PENDING("PENDING"),
        ABORTED("ABORTED");

        private final String value;
        private static final Map<String, OutboundMessageBatchStatus> CONSTANTS;

        private OutboundMessageBatchStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OutboundMessageBatchStatus fromValue(String value) {
            OutboundMessageBatchStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OutboundMessageBatchStatus>();
            for (OutboundMessageBatchStatus c : OutboundMessageBatchStatus.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

