/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_37_7;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"operation", "path", "value"})
public class Mutation
implements Serializable {
    @JsonProperty(value="operation")
    private Operation operation;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="value")
    private Object value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -6077009250872400605L;

    public Mutation() {
    }

    public Mutation(Mutation source) {
        this.operation = source.operation;
        this.path = source.path;
        this.value = source.value;
    }

    public Mutation(Operation operation, String path, Object value) {
        this.operation = operation;
        this.path = path;
        this.value = value;
    }

    @JsonProperty(value="operation")
    public Optional<Operation> getOperation() {
        return Optional.ofNullable(this.operation);
    }

    @JsonProperty(value="operation")
    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Mutation withOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    @JsonProperty(value="path")
    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public Mutation withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="value")
    public Optional<Object> getValue() {
        return Optional.ofNullable(this.value);
    }

    @JsonProperty(value="value")
    public void setValue(Object value) {
        this.value = value;
    }

    public Mutation withValue(Object value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Mutation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("operation".equals(name)) {
            if (!(value instanceof Operation)) {
                throw new IllegalArgumentException("property \"operation\" is of type \"org.hisp.dhis.api.model.v2_37_7.Mutation.Operation\", but got " + value.getClass().toString());
            }
            this.setOperation((Operation)((Object)value));
            return true;
        }
        if ("path".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"path\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setPath((String)value);
            return true;
        }
        if ("value".equals(name)) {
            if (!(value instanceof Object)) {
                throw new IllegalArgumentException("property \"value\" is of type \"java.lang.Object\", but got " + value.getClass().toString());
            }
            this.setValue(value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("operation".equals(name)) {
            return this.getOperation();
        }
        if ("path".equals(name)) {
            return this.getPath();
        }
        if ("value".equals(name)) {
            return this.getValue();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Mutation with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Mutation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("operation");
        sb.append('=');
        sb.append(this.operation == null ? "<null>" : this.operation);
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(this.path == null ? "<null>" : this.path);
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(this.value == null ? "<null>" : this.value);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.operation == null ? 0 : this.operation.hashCode());
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Mutation)) {
            return false;
        }
        Mutation rhs = (Mutation)other;
        return (this.path == rhs.path || this.path != null && this.path.equals(rhs.path)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.operation == rhs.operation || this.operation != null && this.operation.equals((Object)rhs.operation)) && (this.value == rhs.value || this.value != null && this.value.equals(rhs.value));
    }

    public static enum Operation {
        ADDITION("ADDITION"),
        DELETION("DELETION");

        private final String value;
        private static final Map<String, Operation> CONSTANTS;

        private Operation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Operation fromValue(String value) {
            Operation constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Operation>();
            for (Operation c : Operation.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

