/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ValueType {
    INT("INT"),
    FLOAT("FLOAT"),
    DATE("DATE"),
    BOOL("BOOL"),
    STRING("STRING");

    private final String value;
    private static final Map<String, ValueType> CONSTANTS;

    private ValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ValueType fromValue(String value) {
        ValueType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ValueType>();
        for (ValueType c : ValueType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

