/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_36_11;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Order {
    MEAN_ABS_DEV("MEAN_ABS_DEV"),
    Z_SCORE("Z_SCORE");

    private final String value;
    private static final Map<String, Order> CONSTANTS;

    private Order(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Order fromValue(String value) {
        Order constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Order>();
        for (Order c : Order.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

