/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_35_13;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v2_35_13.TrackerBundleParams;
import org.hisp.dhis.api.model.v2_35_13.TrackerStats;
import org.hisp.dhis.api.model.v2_35_13.TypeReportMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"bundleParams", "stats", "status", "typeReportMap"})
public class TrackerBundleReport
implements Serializable {
    @JsonProperty(value="bundleParams")
    private TrackerBundleParams bundleParams;
    @JsonProperty(value="stats")
    private TrackerStats stats;
    @JsonProperty(value="status")
    private TrackerStatus status;
    @JsonProperty(value="typeReportMap")
    private TypeReportMap typeReportMap;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -4266001146403735524L;

    public TrackerBundleReport() {
    }

    public TrackerBundleReport(TrackerBundleReport source) {
        this.bundleParams = source.bundleParams;
        this.stats = source.stats;
        this.status = source.status;
        this.typeReportMap = source.typeReportMap;
    }

    public TrackerBundleReport(TrackerBundleParams bundleParams, TrackerStats stats, TrackerStatus status, TypeReportMap typeReportMap) {
        this.bundleParams = bundleParams;
        this.stats = stats;
        this.status = status;
        this.typeReportMap = typeReportMap;
    }

    @JsonProperty(value="bundleParams")
    public Optional<TrackerBundleParams> getBundleParams() {
        return Optional.ofNullable(this.bundleParams);
    }

    @JsonProperty(value="bundleParams")
    public void setBundleParams(TrackerBundleParams bundleParams) {
        this.bundleParams = bundleParams;
    }

    public TrackerBundleReport withBundleParams(TrackerBundleParams bundleParams) {
        this.bundleParams = bundleParams;
        return this;
    }

    @JsonProperty(value="stats")
    public Optional<TrackerStats> getStats() {
        return Optional.ofNullable(this.stats);
    }

    @JsonProperty(value="stats")
    public void setStats(TrackerStats stats) {
        this.stats = stats;
    }

    public TrackerBundleReport withStats(TrackerStats stats) {
        this.stats = stats;
        return this;
    }

    @JsonProperty(value="status")
    public Optional<TrackerStatus> getStatus() {
        return Optional.ofNullable(this.status);
    }

    @JsonProperty(value="status")
    public void setStatus(TrackerStatus status) {
        this.status = status;
    }

    public TrackerBundleReport withStatus(TrackerStatus status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="typeReportMap")
    public Optional<TypeReportMap> getTypeReportMap() {
        return Optional.ofNullable(this.typeReportMap);
    }

    @JsonProperty(value="typeReportMap")
    public void setTypeReportMap(TypeReportMap typeReportMap) {
        this.typeReportMap = typeReportMap;
    }

    public TrackerBundleReport withTypeReportMap(TypeReportMap typeReportMap) {
        this.typeReportMap = typeReportMap;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerBundleReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("bundleParams".equals(name)) {
            if (!(value instanceof TrackerBundleParams)) {
                throw new IllegalArgumentException("property \"bundleParams\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleParams\", but got " + value.getClass().toString());
            }
            this.setBundleParams((TrackerBundleParams)value);
            return true;
        }
        if ("stats".equals(name)) {
            if (!(value instanceof TrackerStats)) {
                throw new IllegalArgumentException("property \"stats\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerStats\", but got " + value.getClass().toString());
            }
            this.setStats((TrackerStats)value);
            return true;
        }
        if ("status".equals(name)) {
            if (!(value instanceof TrackerStatus)) {
                throw new IllegalArgumentException("property \"status\" is of type \"org.hisp.dhis.api.model.v2_35_13.TrackerBundleReport.TrackerStatus\", but got " + value.getClass().toString());
            }
            this.setStatus((TrackerStatus)((Object)value));
            return true;
        }
        if ("typeReportMap".equals(name)) {
            if (!(value instanceof TypeReportMap)) {
                throw new IllegalArgumentException("property \"typeReportMap\" is of type \"org.hisp.dhis.api.model.v2_35_13.TypeReportMap\", but got " + value.getClass().toString());
            }
            this.setTypeReportMap((TypeReportMap)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("bundleParams".equals(name)) {
            return this.getBundleParams();
        }
        if ("stats".equals(name)) {
            return this.getStats();
        }
        if ("status".equals(name)) {
            return this.getStatus();
        }
        if ("typeReportMap".equals(name)) {
            return this.getTypeReportMap();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public TrackerBundleReport with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerBundleReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bundleParams");
        sb.append('=');
        sb.append(this.bundleParams == null ? "<null>" : this.bundleParams);
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(this.stats == null ? "<null>" : this.stats);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("typeReportMap");
        sb.append('=');
        sb.append(this.typeReportMap == null ? "<null>" : this.typeReportMap);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.stats == null ? 0 : this.stats.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.bundleParams == null ? 0 : this.bundleParams.hashCode());
        result = result * 31 + (this.typeReportMap == null ? 0 : this.typeReportMap.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TrackerBundleReport)) {
            return false;
        }
        TrackerBundleReport rhs = (TrackerBundleReport)other;
        return (this.stats == rhs.stats || this.stats != null && this.stats.equals(rhs.stats)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.bundleParams == rhs.bundleParams || this.bundleParams != null && this.bundleParams.equals(rhs.bundleParams)) && (this.typeReportMap == rhs.typeReportMap || this.typeReportMap != null && this.typeReportMap.equals(rhs.typeReportMap)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }

    public static enum TrackerStatus {
        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");

        private final String value;
        private static final Map<String, TrackerStatus> CONSTANTS;

        private TrackerStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerStatus fromValue(String value) {
            TrackerStatus constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TrackerStatus>();
            for (TrackerStatus c : TrackerStatus.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

