/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_35_13;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum RuleValueType {
    TEXT("TEXT"),
    NUMERIC("NUMERIC"),
    BOOLEAN("BOOLEAN"),
    DATE("DATE");

    private final String value;
    private static final Map<String, RuleValueType> CONSTANTS;

    private RuleValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static RuleValueType fromValue(String value) {
        RuleValueType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, RuleValueType>();
        for (RuleValueType c : RuleValueType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

