/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_35_13;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"description", "expression", "missingValueStrategy", "slidingWindow"})
public class Expression
implements Serializable {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="expression")
    private String expression;
    @JsonProperty(value="missingValueStrategy")
    private MissingValueStrategy missingValueStrategy;
    @JsonProperty(value="slidingWindow")
    private Boolean slidingWindow;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -7325181488676859561L;

    public Expression() {
    }

    public Expression(Expression source) {
        this.description = source.description;
        this.expression = source.expression;
        this.missingValueStrategy = source.missingValueStrategy;
        this.slidingWindow = source.slidingWindow;
    }

    public Expression(String description, String expression, MissingValueStrategy missingValueStrategy, Boolean slidingWindow) {
        this.description = description;
        this.expression = expression;
        this.missingValueStrategy = missingValueStrategy;
        this.slidingWindow = slidingWindow;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Expression withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="expression")
    public Optional<String> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    @JsonProperty(value="expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Expression withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    @JsonProperty(value="missingValueStrategy")
    public Optional<MissingValueStrategy> getMissingValueStrategy() {
        return Optional.ofNullable(this.missingValueStrategy);
    }

    @JsonProperty(value="missingValueStrategy")
    public void setMissingValueStrategy(MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
    }

    public Expression withMissingValueStrategy(MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    @JsonProperty(value="slidingWindow")
    public Optional<Boolean> getSlidingWindow() {
        return Optional.ofNullable(this.slidingWindow);
    }

    @JsonProperty(value="slidingWindow")
    public void setSlidingWindow(Boolean slidingWindow) {
        this.slidingWindow = slidingWindow;
    }

    public Expression withSlidingWindow(Boolean slidingWindow) {
        this.slidingWindow = slidingWindow;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Expression withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("description".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"description\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDescription((String)value);
            return true;
        }
        if ("expression".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"expression\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setExpression((String)value);
            return true;
        }
        if ("missingValueStrategy".equals(name)) {
            if (!(value instanceof MissingValueStrategy)) {
                throw new IllegalArgumentException("property \"missingValueStrategy\" is of type \"org.hisp.dhis.api.model.v2_35_13.Expression.MissingValueStrategy\", but got " + value.getClass().toString());
            }
            this.setMissingValueStrategy((MissingValueStrategy)((Object)value));
            return true;
        }
        if ("slidingWindow".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"slidingWindow\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setSlidingWindow((Boolean)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("description".equals(name)) {
            return this.getDescription();
        }
        if ("expression".equals(name)) {
            return this.getExpression();
        }
        if ("missingValueStrategy".equals(name)) {
            return this.getMissingValueStrategy();
        }
        if ("slidingWindow".equals(name)) {
            return this.getSlidingWindow();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Expression with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Expression.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("expression");
        sb.append('=');
        sb.append(this.expression == null ? "<null>" : this.expression);
        sb.append(',');
        sb.append("missingValueStrategy");
        sb.append('=');
        sb.append(this.missingValueStrategy == null ? "<null>" : this.missingValueStrategy);
        sb.append(',');
        sb.append("slidingWindow");
        sb.append('=');
        sb.append(this.slidingWindow == null ? "<null>" : this.slidingWindow);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.expression == null ? 0 : this.expression.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.missingValueStrategy == null ? 0 : this.missingValueStrategy.hashCode());
        result = result * 31 + (this.slidingWindow == null ? 0 : this.slidingWindow.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Expression)) {
            return false;
        }
        Expression rhs = (Expression)other;
        return (this.expression == rhs.expression || this.expression != null && this.expression.equals(rhs.expression)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.missingValueStrategy == rhs.missingValueStrategy || this.missingValueStrategy != null && this.missingValueStrategy.equals((Object)rhs.missingValueStrategy)) && (this.slidingWindow == rhs.slidingWindow || this.slidingWindow != null && this.slidingWindow.equals(rhs.slidingWindow));
    }

    public static enum MissingValueStrategy {
        SKIP_IF_ANY_VALUE_MISSING("SKIP_IF_ANY_VALUE_MISSING"),
        SKIP_IF_ALL_VALUES_MISSING("SKIP_IF_ALL_VALUES_MISSING"),
        NEVER_SKIP("NEVER_SKIP");

        private final String value;
        private static final Map<String, MissingValueStrategy> CONSTANTS;

        private MissingValueStrategy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static MissingValueStrategy fromValue(String value) {
            MissingValueStrategy constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, MissingValueStrategy>();
            for (MissingValueStrategy c : MissingValueStrategy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

