
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "appType",
    "created",
    "description",
    "developer",
    "id",
    "images",
    "lastUpdated",
    "name",
    "owner",
    "reviews",
    "sourceUrl",
    "status",
    "versions"
})
@Generated("jsonschema2pojo")
public class WebApp implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("appType")
    private WebApp.AppTypeRef appType;
    @JsonProperty("created")
    private Date created;
    @JsonProperty("description")
    private String description;
    @JsonProperty("developer")
    private Developer developer;
    @JsonProperty("id")
    private String id;
    @JsonProperty("images")
    private List<ImageResource> images;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    @JsonProperty("name")
    private String name;
    @JsonProperty("owner")
    private String owner;
    @JsonProperty("reviews")
    private List<Review> reviews;
    @JsonProperty("sourceUrl")
    private String sourceUrl;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private WebApp.StatusRef status;
    @JsonProperty("versions")
    private List<AppVersion> versions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -1412625745098404802L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public WebApp() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public WebApp(WebApp source) {
        super();
        this.appType = source.appType;
        this.created = source.created;
        this.description = source.description;
        this.developer = source.developer;
        this.id = source.id;
        this.images = source.images;
        this.lastUpdated = source.lastUpdated;
        this.name = source.name;
        this.owner = source.owner;
        this.reviews = source.reviews;
        this.sourceUrl = source.sourceUrl;
        this.status = source.status;
        this.versions = source.versions;
    }

    public WebApp(WebApp.AppTypeRef appType, Date created, String description, Developer developer, String id, List<ImageResource> images, Date lastUpdated, String name, String owner, List<Review> reviews, String sourceUrl, WebApp.StatusRef status, List<AppVersion> versions) {
        super();
        this.appType = appType;
        this.created = created;
        this.description = description;
        this.developer = developer;
        this.id = id;
        this.images = images;
        this.lastUpdated = lastUpdated;
        this.name = name;
        this.owner = owner;
        this.reviews = reviews;
        this.sourceUrl = sourceUrl;
        this.status = status;
        this.versions = versions;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("appType")
    public WebApp.AppTypeRef getAppType() {
        return appType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("appType")
    public void setAppType(WebApp.AppTypeRef appType) {
        this.appType = appType;
    }

    public WebApp withAppType(WebApp.AppTypeRef appType) {
        this.appType = appType;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public WebApp withCreated(Date created) {
        this.created = created;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public WebApp withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("developer")
    public Optional<Developer> getDeveloper() {
        return Optional.ofNullable(developer);
    }

    @JsonProperty("developer")
    public void setDeveloper(Developer developer) {
        this.developer = developer;
    }

    public WebApp withDeveloper(Developer developer) {
        this.developer = developer;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public WebApp withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("images")
    public Optional<List<ImageResource>> getImages() {
        return Optional.ofNullable(images);
    }

    @JsonProperty("images")
    public void setImages(List<ImageResource> images) {
        this.images = images;
    }

    public WebApp withImages(List<ImageResource> images) {
        this.images = images;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public WebApp withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public WebApp withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("owner")
    public Optional<String> getOwner() {
        return Optional.ofNullable(owner);
    }

    @JsonProperty("owner")
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public WebApp withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    @JsonProperty("reviews")
    public Optional<List<Review>> getReviews() {
        return Optional.ofNullable(reviews);
    }

    @JsonProperty("reviews")
    public void setReviews(List<Review> reviews) {
        this.reviews = reviews;
    }

    public WebApp withReviews(List<Review> reviews) {
        this.reviews = reviews;
        return this;
    }

    @JsonProperty("sourceUrl")
    public Optional<String> getSourceUrl() {
        return Optional.ofNullable(sourceUrl);
    }

    @JsonProperty("sourceUrl")
    public void setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public WebApp withSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public WebApp.StatusRef getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(WebApp.StatusRef status) {
        this.status = status;
    }

    public WebApp withStatus(WebApp.StatusRef status) {
        this.status = status;
        return this;
    }

    @JsonProperty("versions")
    public Optional<List<AppVersion>> getVersions() {
        return Optional.ofNullable(versions);
    }

    @JsonProperty("versions")
    public void setVersions(List<AppVersion> versions) {
        this.versions = versions;
    }

    public WebApp withVersions(List<AppVersion> versions) {
        this.versions = versions;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public WebApp withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("appType".equals(name)) {
            if (value instanceof WebApp.AppTypeRef) {
                setAppType(((WebApp.AppTypeRef) value));
            } else {
                throw new IllegalArgumentException(("property \"appType\" is of type \"org.hisp.dhis.api.model.v40_2_2.WebApp.AppTypeRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("created".equals(name)) {
                if (value instanceof Date) {
                    setCreated(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("description".equals(name)) {
                    if (value instanceof String) {
                        setDescription(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("developer".equals(name)) {
                        if (value instanceof Developer) {
                            setDeveloper(((Developer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"developer\" is of type \"org.hisp.dhis.api.model.v40_2_2.Developer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("id".equals(name)) {
                            if (value instanceof String) {
                                setId(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("images".equals(name)) {
                                if (value instanceof List) {
                                    setImages(((List<ImageResource> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"images\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.ImageResource>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("lastUpdated".equals(name)) {
                                    if (value instanceof Date) {
                                        setLastUpdated(((Date) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("name".equals(name)) {
                                        if (value instanceof String) {
                                            setName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("owner".equals(name)) {
                                            if (value instanceof String) {
                                                setOwner(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"owner\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("reviews".equals(name)) {
                                                if (value instanceof List) {
                                                    setReviews(((List<Review> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"reviews\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Review>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("sourceUrl".equals(name)) {
                                                    if (value instanceof String) {
                                                        setSourceUrl(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"sourceUrl\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("status".equals(name)) {
                                                        if (value instanceof WebApp.StatusRef) {
                                                            setStatus(((WebApp.StatusRef) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_2_2.WebApp.StatusRef\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("versions".equals(name)) {
                                                            if (value instanceof List) {
                                                                setVersions(((List<AppVersion> ) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"versions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AppVersion>\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("appType".equals(name)) {
            return getAppType();
        } else {
            if ("created".equals(name)) {
                return getCreated();
            } else {
                if ("description".equals(name)) {
                    return getDescription();
                } else {
                    if ("developer".equals(name)) {
                        return getDeveloper();
                    } else {
                        if ("id".equals(name)) {
                            return getId();
                        } else {
                            if ("images".equals(name)) {
                                return getImages();
                            } else {
                                if ("lastUpdated".equals(name)) {
                                    return getLastUpdated();
                                } else {
                                    if ("name".equals(name)) {
                                        return getName();
                                    } else {
                                        if ("owner".equals(name)) {
                                            return getOwner();
                                        } else {
                                            if ("reviews".equals(name)) {
                                                return getReviews();
                                            } else {
                                                if ("sourceUrl".equals(name)) {
                                                    return getSourceUrl();
                                                } else {
                                                    if ("status".equals(name)) {
                                                        return getStatus();
                                                    } else {
                                                        if ("versions".equals(name)) {
                                                            return getVersions();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, WebApp.NOT_FOUND_VALUE);
        if (WebApp.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public WebApp with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(WebApp.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("appType");
        sb.append('=');
        sb.append(((this.appType == null)?"<null>":this.appType));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("developer");
        sb.append('=');
        sb.append(((this.developer == null)?"<null>":this.developer));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("images");
        sb.append('=');
        sb.append(((this.images == null)?"<null>":this.images));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("owner");
        sb.append('=');
        sb.append(((this.owner == null)?"<null>":this.owner));
        sb.append(',');
        sb.append("reviews");
        sb.append('=');
        sb.append(((this.reviews == null)?"<null>":this.reviews));
        sb.append(',');
        sb.append("sourceUrl");
        sb.append('=');
        sb.append(((this.sourceUrl == null)?"<null>":this.sourceUrl));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("versions");
        sb.append('=');
        sb.append(((this.versions == null)?"<null>":this.versions));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.owner == null)? 0 :this.owner.hashCode()));
        result = ((result* 31)+((this.images == null)? 0 :this.images.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.sourceUrl == null)? 0 :this.sourceUrl.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.reviews == null)? 0 :this.reviews.hashCode()));
        result = ((result* 31)+((this.versions == null)? 0 :this.versions.hashCode()));
        result = ((result* 31)+((this.appType == null)? 0 :this.appType.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.developer == null)? 0 :this.developer.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof WebApp) == false) {
            return false;
        }
        WebApp rhs = ((WebApp) other);
        return (((((((((((((((this.owner == rhs.owner)||((this.owner!= null)&&this.owner.equals(rhs.owner)))&&((this.images == rhs.images)||((this.images!= null)&&this.images.equals(rhs.images))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.sourceUrl == rhs.sourceUrl)||((this.sourceUrl!= null)&&this.sourceUrl.equals(rhs.sourceUrl))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.reviews == rhs.reviews)||((this.reviews!= null)&&this.reviews.equals(rhs.reviews))))&&((this.versions == rhs.versions)||((this.versions!= null)&&this.versions.equals(rhs.versions))))&&((this.appType == rhs.appType)||((this.appType!= null)&&this.appType.equals(rhs.appType))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.developer == rhs.developer)||((this.developer!= null)&&this.developer.equals(rhs.developer))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum AppTypeRef {

        APP("APP"),
        RESOURCE("RESOURCE"),
        DASHBOARD_WIDGET("DASHBOARD_WIDGET"),
        TRACKER_DASHBOARD_WIDGET("TRACKER_DASHBOARD_WIDGET");
        private final String value;
        private final static Map<String, WebApp.AppTypeRef> CONSTANTS = new HashMap<String, WebApp.AppTypeRef>();

        static {
            for (WebApp.AppTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AppTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static WebApp.AppTypeRef fromValue(String value) {
            WebApp.AppTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum StatusRef {

        OK("OK"),
        INVALID_BUNDLED_APP_OVERRIDE("INVALID_BUNDLED_APP_OVERRIDE"),
        INVALID_CORE_APP("INVALID_CORE_APP"),
        NAMESPACE_TAKEN("NAMESPACE_TAKEN"),
        INVALID_ZIP_FORMAT("INVALID_ZIP_FORMAT"),
        MISSING_MANIFEST("MISSING_MANIFEST"),
        INVALID_MANIFEST_JSON("INVALID_MANIFEST_JSON"),
        INSTALLATION_FAILED("INSTALLATION_FAILED"),
        NOT_FOUND("NOT_FOUND"),
        MISSING_SYSTEM_BASE_URL("MISSING_SYSTEM_BASE_URL"),
        APPROVED("APPROVED"),
        PENDING("PENDING"),
        NOT_APPROVED("NOT_APPROVED"),
        DELETION_IN_PROGRESS("DELETION_IN_PROGRESS");
        private final String value;
        private final static Map<String, WebApp.StatusRef> CONSTANTS = new HashMap<String, WebApp.StatusRef>();

        static {
            for (WebApp.StatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static WebApp.StatusRef fromValue(String value) {
            WebApp.StatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
