
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "bundleReport",
    "message",
    "stats",
    "status",
    "timingsStats",
    "validationReport"
})
@Generated("jsonschema2pojo")
public class TrackerImportReport implements Serializable
{

    @JsonProperty("bundleReport")
    private PersistenceReport bundleReport;
    @JsonProperty("message")
    private String message;
    @JsonProperty("stats")
    private TrackerStats stats;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private TrackerImportReport.StatusRef status;
    @JsonProperty("timingsStats")
    private TimingsStats timingsStats;
    @JsonProperty("validationReport")
    private ValidationReport validationReport;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5481629495930859206L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackerImportReport() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackerImportReport(TrackerImportReport source) {
        super();
        this.bundleReport = source.bundleReport;
        this.message = source.message;
        this.stats = source.stats;
        this.status = source.status;
        this.timingsStats = source.timingsStats;
        this.validationReport = source.validationReport;
    }

    public TrackerImportReport(PersistenceReport bundleReport, String message, TrackerStats stats, TrackerImportReport.StatusRef status, TimingsStats timingsStats, ValidationReport validationReport) {
        super();
        this.bundleReport = bundleReport;
        this.message = message;
        this.stats = stats;
        this.status = status;
        this.timingsStats = timingsStats;
        this.validationReport = validationReport;
    }

    @JsonProperty("bundleReport")
    public Optional<PersistenceReport> getBundleReport() {
        return Optional.ofNullable(bundleReport);
    }

    @JsonProperty("bundleReport")
    public void setBundleReport(PersistenceReport bundleReport) {
        this.bundleReport = bundleReport;
    }

    public TrackerImportReport withBundleReport(PersistenceReport bundleReport) {
        this.bundleReport = bundleReport;
        return this;
    }

    @JsonProperty("message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    public TrackerImportReport withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty("stats")
    public Optional<TrackerStats> getStats() {
        return Optional.ofNullable(stats);
    }

    @JsonProperty("stats")
    public void setStats(TrackerStats stats) {
        this.stats = stats;
    }

    public TrackerImportReport withStats(TrackerStats stats) {
        this.stats = stats;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public TrackerImportReport.StatusRef getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(TrackerImportReport.StatusRef status) {
        this.status = status;
    }

    public TrackerImportReport withStatus(TrackerImportReport.StatusRef status) {
        this.status = status;
        return this;
    }

    @JsonProperty("timingsStats")
    public Optional<TimingsStats> getTimingsStats() {
        return Optional.ofNullable(timingsStats);
    }

    @JsonProperty("timingsStats")
    public void setTimingsStats(TimingsStats timingsStats) {
        this.timingsStats = timingsStats;
    }

    public TrackerImportReport withTimingsStats(TimingsStats timingsStats) {
        this.timingsStats = timingsStats;
        return this;
    }

    @JsonProperty("validationReport")
    public Optional<ValidationReport> getValidationReport() {
        return Optional.ofNullable(validationReport);
    }

    @JsonProperty("validationReport")
    public void setValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
    }

    public TrackerImportReport withValidationReport(ValidationReport validationReport) {
        this.validationReport = validationReport;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackerImportReport withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("bundleReport".equals(name)) {
            if (value instanceof PersistenceReport) {
                setBundleReport(((PersistenceReport) value));
            } else {
                throw new IllegalArgumentException(("property \"bundleReport\" is of type \"org.hisp.dhis.api.model.v40_2_2.PersistenceReport\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("message".equals(name)) {
                if (value instanceof String) {
                    setMessage(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"message\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("stats".equals(name)) {
                    if (value instanceof TrackerStats) {
                        setStats(((TrackerStats) value));
                    } else {
                        throw new IllegalArgumentException(("property \"stats\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackerStats\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("status".equals(name)) {
                        if (value instanceof TrackerImportReport.StatusRef) {
                            setStatus(((TrackerImportReport.StatusRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackerImportReport.StatusRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("timingsStats".equals(name)) {
                            if (value instanceof TimingsStats) {
                                setTimingsStats(((TimingsStats) value));
                            } else {
                                throw new IllegalArgumentException(("property \"timingsStats\" is of type \"org.hisp.dhis.api.model.v40_2_2.TimingsStats\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("validationReport".equals(name)) {
                                if (value instanceof ValidationReport) {
                                    setValidationReport(((ValidationReport) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"validationReport\" is of type \"org.hisp.dhis.api.model.v40_2_2.ValidationReport\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("bundleReport".equals(name)) {
            return getBundleReport();
        } else {
            if ("message".equals(name)) {
                return getMessage();
            } else {
                if ("stats".equals(name)) {
                    return getStats();
                } else {
                    if ("status".equals(name)) {
                        return getStatus();
                    } else {
                        if ("timingsStats".equals(name)) {
                            return getTimingsStats();
                        } else {
                            if ("validationReport".equals(name)) {
                                return getValidationReport();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackerImportReport.NOT_FOUND_VALUE);
        if (TrackerImportReport.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackerImportReport with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackerImportReport.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("bundleReport");
        sb.append('=');
        sb.append(((this.bundleReport == null)?"<null>":this.bundleReport));
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(((this.message == null)?"<null>":this.message));
        sb.append(',');
        sb.append("stats");
        sb.append('=');
        sb.append(((this.stats == null)?"<null>":this.stats));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("timingsStats");
        sb.append('=');
        sb.append(((this.timingsStats == null)?"<null>":this.timingsStats));
        sb.append(',');
        sb.append("validationReport");
        sb.append('=');
        sb.append(((this.validationReport == null)?"<null>":this.validationReport));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.bundleReport == null)? 0 :this.bundleReport.hashCode()));
        result = ((result* 31)+((this.stats == null)? 0 :this.stats.hashCode()));
        result = ((result* 31)+((this.validationReport == null)? 0 :this.validationReport.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.message == null)? 0 :this.message.hashCode()));
        result = ((result* 31)+((this.timingsStats == null)? 0 :this.timingsStats.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackerImportReport) == false) {
            return false;
        }
        TrackerImportReport rhs = ((TrackerImportReport) other);
        return ((((((((this.bundleReport == rhs.bundleReport)||((this.bundleReport!= null)&&this.bundleReport.equals(rhs.bundleReport)))&&((this.stats == rhs.stats)||((this.stats!= null)&&this.stats.equals(rhs.stats))))&&((this.validationReport == rhs.validationReport)||((this.validationReport!= null)&&this.validationReport.equals(rhs.validationReport))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.message == rhs.message)||((this.message!= null)&&this.message.equals(rhs.message))))&&((this.timingsStats == rhs.timingsStats)||((this.timingsStats!= null)&&this.timingsStats.equals(rhs.timingsStats))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum StatusRef {

        OK("OK"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, TrackerImportReport.StatusRef> CONSTANTS = new HashMap<String, TrackerImportReport.StatusRef>();

        static {
            for (TrackerImportReport.StatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackerImportReport.StatusRef fromValue(String value) {
            TrackerImportReport.StatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
