
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "allowAuditLog",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "description",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "featureType",
    "formName",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "maxTeiCountToReturn",
    "minAttributesRequiredToSearch",
    "name",
    "publicAccess",
    "sharing",
    "shortName",
    "style",
    "trackedEntityTypeAttributes",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class TrackedEntityType implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("allowAuditLog")
    private Boolean allowAuditLog;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__89 createdBy;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    private TrackedEntityType.FeatureTypeRef featureType;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__89 lastUpdatedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("maxTeiCountToReturn")
    private Integer maxTeiCountToReturn;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("minAttributesRequiredToSearch")
    private Integer minAttributesRequiredToSearch;
    @JsonProperty("name")
    private String name;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("style")
    private ObjectStyle style;
    @JsonProperty("trackedEntityTypeAttributes")
    private List<TrackedEntityTypeAttribute> trackedEntityTypeAttributes;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__93 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -3412463431274578459L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrackedEntityType() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public TrackedEntityType(TrackedEntityType source) {
        super();
        this.access = source.access;
        this.allowAuditLog = source.allowAuditLog;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.featureType = source.featureType;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.maxTeiCountToReturn = source.maxTeiCountToReturn;
        this.minAttributesRequiredToSearch = source.minAttributesRequiredToSearch;
        this.name = source.name;
        this.publicAccess = source.publicAccess;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.style = source.style;
        this.trackedEntityTypeAttributes = source.trackedEntityTypeAttributes;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public TrackedEntityType(Access access, Boolean allowAuditLog, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__89 createdBy, String description, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, TrackedEntityType.FeatureTypeRef featureType, String formName, String href, String id, Date lastUpdated, LastUpdatedByRef__89 lastUpdatedBy, Integer maxTeiCountToReturn, Integer minAttributesRequiredToSearch, String name, String publicAccess, Sharing sharing, String shortName, ObjectStyle style, List<TrackedEntityTypeAttribute> trackedEntityTypeAttributes, List<Translation> translations, UserRef__93 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.allowAuditLog = allowAuditLog;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.featureType = featureType;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.maxTeiCountToReturn = maxTeiCountToReturn;
        this.minAttributesRequiredToSearch = minAttributesRequiredToSearch;
        this.name = name;
        this.publicAccess = publicAccess;
        this.sharing = sharing;
        this.shortName = shortName;
        this.style = style;
        this.trackedEntityTypeAttributes = trackedEntityTypeAttributes;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public TrackedEntityType withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("allowAuditLog")
    public Optional<Boolean> getAllowAuditLog() {
        return Optional.ofNullable(allowAuditLog);
    }

    @JsonProperty("allowAuditLog")
    public void setAllowAuditLog(Boolean allowAuditLog) {
        this.allowAuditLog = allowAuditLog;
    }

    public TrackedEntityType withAllowAuditLog(Boolean allowAuditLog) {
        this.allowAuditLog = allowAuditLog;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public TrackedEntityType withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public TrackedEntityType withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public TrackedEntityType withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__89> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__89 createdBy) {
        this.createdBy = createdBy;
    }

    public TrackedEntityType withCreatedBy(CreatedByRef__89 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public TrackedEntityType withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public TrackedEntityType withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public TrackedEntityType withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public TrackedEntityType withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public TrackedEntityType withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public TrackedEntityType withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public TrackedEntityType withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public TrackedEntityType withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public TrackedEntityType.FeatureTypeRef getFeatureType() {
        return featureType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("featureType")
    public void setFeatureType(TrackedEntityType.FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public TrackedEntityType withFeatureType(TrackedEntityType.FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public TrackedEntityType withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public TrackedEntityType withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public TrackedEntityType withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public TrackedEntityType withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__89> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__89 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public TrackedEntityType withLastUpdatedBy(LastUpdatedByRef__89 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("maxTeiCountToReturn")
    public Integer getMaxTeiCountToReturn() {
        return maxTeiCountToReturn;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("maxTeiCountToReturn")
    public void setMaxTeiCountToReturn(Integer maxTeiCountToReturn) {
        this.maxTeiCountToReturn = maxTeiCountToReturn;
    }

    public TrackedEntityType withMaxTeiCountToReturn(Integer maxTeiCountToReturn) {
        this.maxTeiCountToReturn = maxTeiCountToReturn;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("minAttributesRequiredToSearch")
    public Integer getMinAttributesRequiredToSearch() {
        return minAttributesRequiredToSearch;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("minAttributesRequiredToSearch")
    public void setMinAttributesRequiredToSearch(Integer minAttributesRequiredToSearch) {
        this.minAttributesRequiredToSearch = minAttributesRequiredToSearch;
    }

    public TrackedEntityType withMinAttributesRequiredToSearch(Integer minAttributesRequiredToSearch) {
        this.minAttributesRequiredToSearch = minAttributesRequiredToSearch;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public TrackedEntityType withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public TrackedEntityType withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public TrackedEntityType withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public TrackedEntityType withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("style")
    public Optional<ObjectStyle> getStyle() {
        return Optional.ofNullable(style);
    }

    @JsonProperty("style")
    public void setStyle(ObjectStyle style) {
        this.style = style;
    }

    public TrackedEntityType withStyle(ObjectStyle style) {
        this.style = style;
        return this;
    }

    @JsonProperty("trackedEntityTypeAttributes")
    public Optional<List<TrackedEntityTypeAttribute>> getTrackedEntityTypeAttributes() {
        return Optional.ofNullable(trackedEntityTypeAttributes);
    }

    @JsonProperty("trackedEntityTypeAttributes")
    public void setTrackedEntityTypeAttributes(List<TrackedEntityTypeAttribute> trackedEntityTypeAttributes) {
        this.trackedEntityTypeAttributes = trackedEntityTypeAttributes;
    }

    public TrackedEntityType withTrackedEntityTypeAttributes(List<TrackedEntityTypeAttribute> trackedEntityTypeAttributes) {
        this.trackedEntityTypeAttributes = trackedEntityTypeAttributes;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public TrackedEntityType withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__93> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__93 user) {
        this.user = user;
    }

    public TrackedEntityType withUser(UserRef__93 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public TrackedEntityType withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public TrackedEntityType withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TrackedEntityType withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("allowAuditLog".equals(name)) {
                if (value instanceof Boolean) {
                    setAllowAuditLog(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowAuditLog\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdBy".equals(name)) {
                                if (value instanceof CreatedByRef__89) {
                                    setCreatedBy(((CreatedByRef__89) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__89\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("description".equals(name)) {
                                    if (value instanceof String) {
                                        setDescription(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayDescription".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayDescription(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("displayFormName".equals(name)) {
                                            if (value instanceof String) {
                                                setDisplayFormName(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("displayName".equals(name)) {
                                                if (value instanceof String) {
                                                    setDisplayName(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayShortName".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayShortName(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("featureType".equals(name)) {
                                                                    if (value instanceof TrackedEntityType.FeatureTypeRef) {
                                                                        setFeatureType(((TrackedEntityType.FeatureTypeRef) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"featureType\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackedEntityType.FeatureTypeRef\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("formName".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setFormName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("href".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setHref(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("id".equals(name)) {
                                                                                if (value instanceof String) {
                                                                                    setId(((String) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("lastUpdated".equals(name)) {
                                                                                    if (value instanceof Date) {
                                                                                        setLastUpdated(((Date) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                        if (value instanceof LastUpdatedByRef__89) {
                                                                                            setLastUpdatedBy(((LastUpdatedByRef__89) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__89\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("maxTeiCountToReturn".equals(name)) {
                                                                                            if (value instanceof Integer) {
                                                                                                setMaxTeiCountToReturn(((Integer) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"maxTeiCountToReturn\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("minAttributesRequiredToSearch".equals(name)) {
                                                                                                if (value instanceof Integer) {
                                                                                                    setMinAttributesRequiredToSearch(((Integer) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"minAttributesRequiredToSearch\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("name".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setName(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setPublicAccess(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("sharing".equals(name)) {
                                                                                                            if (value instanceof Sharing) {
                                                                                                                setSharing(((Sharing) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("shortName".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setShortName(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("style".equals(name)) {
                                                                                                                    if (value instanceof ObjectStyle) {
                                                                                                                        setStyle(((ObjectStyle) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_2_2.ObjectStyle\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("trackedEntityTypeAttributes".equals(name)) {
                                                                                                                        if (value instanceof List) {
                                                                                                                            setTrackedEntityTypeAttributes(((List<TrackedEntityTypeAttribute> ) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"trackedEntityTypeAttributes\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.TrackedEntityTypeAttribute>\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("translations".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setTranslations(((List<Translation> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("user".equals(name)) {
                                                                                                                                if (value instanceof UserRef__93) {
                                                                                                                                    setUser(((UserRef__93) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__93\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                    if (value instanceof List) {
                                                                                                                                        setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        return false;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("allowAuditLog".equals(name)) {
                return getAllowAuditLog();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdBy".equals(name)) {
                                return getCreatedBy();
                            } else {
                                if ("description".equals(name)) {
                                    return getDescription();
                                } else {
                                    if ("displayDescription".equals(name)) {
                                        return getDisplayDescription();
                                    } else {
                                        if ("displayFormName".equals(name)) {
                                            return getDisplayFormName();
                                        } else {
                                            if ("displayName".equals(name)) {
                                                return getDisplayName();
                                            } else {
                                                if ("displayShortName".equals(name)) {
                                                    return getDisplayShortName();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("featureType".equals(name)) {
                                                                    return getFeatureType();
                                                                } else {
                                                                    if ("formName".equals(name)) {
                                                                        return getFormName();
                                                                    } else {
                                                                        if ("href".equals(name)) {
                                                                            return getHref();
                                                                        } else {
                                                                            if ("id".equals(name)) {
                                                                                return getId();
                                                                            } else {
                                                                                if ("lastUpdated".equals(name)) {
                                                                                    return getLastUpdated();
                                                                                } else {
                                                                                    if ("lastUpdatedBy".equals(name)) {
                                                                                        return getLastUpdatedBy();
                                                                                    } else {
                                                                                        if ("maxTeiCountToReturn".equals(name)) {
                                                                                            return getMaxTeiCountToReturn();
                                                                                        } else {
                                                                                            if ("minAttributesRequiredToSearch".equals(name)) {
                                                                                                return getMinAttributesRequiredToSearch();
                                                                                            } else {
                                                                                                if ("name".equals(name)) {
                                                                                                    return getName();
                                                                                                } else {
                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                        return getPublicAccess();
                                                                                                    } else {
                                                                                                        if ("sharing".equals(name)) {
                                                                                                            return getSharing();
                                                                                                        } else {
                                                                                                            if ("shortName".equals(name)) {
                                                                                                                return getShortName();
                                                                                                            } else {
                                                                                                                if ("style".equals(name)) {
                                                                                                                    return getStyle();
                                                                                                                } else {
                                                                                                                    if ("trackedEntityTypeAttributes".equals(name)) {
                                                                                                                        return getTrackedEntityTypeAttributes();
                                                                                                                    } else {
                                                                                                                        if ("translations".equals(name)) {
                                                                                                                            return getTranslations();
                                                                                                                        } else {
                                                                                                                            if ("user".equals(name)) {
                                                                                                                                return getUser();
                                                                                                                            } else {
                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                    return getUserAccesses();
                                                                                                                                } else {
                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                        return getUserGroupAccesses();
                                                                                                                                    } else {
                                                                                                                                        return notFoundValue;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, TrackedEntityType.NOT_FOUND_VALUE);
        if (TrackedEntityType.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public TrackedEntityType with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TrackedEntityType.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("allowAuditLog");
        sb.append('=');
        sb.append(((this.allowAuditLog == null)?"<null>":this.allowAuditLog));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("featureType");
        sb.append('=');
        sb.append(((this.featureType == null)?"<null>":this.featureType));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("maxTeiCountToReturn");
        sb.append('=');
        sb.append(((this.maxTeiCountToReturn == null)?"<null>":this.maxTeiCountToReturn));
        sb.append(',');
        sb.append("minAttributesRequiredToSearch");
        sb.append('=');
        sb.append(((this.minAttributesRequiredToSearch == null)?"<null>":this.minAttributesRequiredToSearch));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("trackedEntityTypeAttributes");
        sb.append('=');
        sb.append(((this.trackedEntityTypeAttributes == null)?"<null>":this.trackedEntityTypeAttributes));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.trackedEntityTypeAttributes == null)? 0 :this.trackedEntityTypeAttributes.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.allowAuditLog == null)? 0 :this.allowAuditLog.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.featureType == null)? 0 :this.featureType.hashCode()));
        result = ((result* 31)+((this.minAttributesRequiredToSearch == null)? 0 :this.minAttributesRequiredToSearch.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.maxTeiCountToReturn == null)? 0 :this.maxTeiCountToReturn.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof TrackedEntityType) == false) {
            return false;
        }
        TrackedEntityType rhs = ((TrackedEntityType) other);
        return ((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.trackedEntityTypeAttributes == rhs.trackedEntityTypeAttributes)||((this.trackedEntityTypeAttributes!= null)&&this.trackedEntityTypeAttributes.equals(rhs.trackedEntityTypeAttributes))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.allowAuditLog == rhs.allowAuditLog)||((this.allowAuditLog!= null)&&this.allowAuditLog.equals(rhs.allowAuditLog))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.featureType == rhs.featureType)||((this.featureType!= null)&&this.featureType.equals(rhs.featureType))))&&((this.minAttributesRequiredToSearch == rhs.minAttributesRequiredToSearch)||((this.minAttributesRequiredToSearch!= null)&&this.minAttributesRequiredToSearch.equals(rhs.minAttributesRequiredToSearch))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.maxTeiCountToReturn == rhs.maxTeiCountToReturn)||((this.maxTeiCountToReturn!= null)&&this.maxTeiCountToReturn.equals(rhs.maxTeiCountToReturn))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum FeatureTypeRef {

        NONE("NONE"),
        MULTI_POLYGON("MULTI_POLYGON"),
        POLYGON("POLYGON"),
        POINT("POINT"),
        SYMBOL("SYMBOL");
        private final String value;
        private final static Map<String, TrackedEntityType.FeatureTypeRef> CONSTANTS = new HashMap<String, TrackedEntityType.FeatureTypeRef>();

        static {
            for (TrackedEntityType.FeatureTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        FeatureTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TrackedEntityType.FeatureTypeRef fromValue(String value) {
            TrackedEntityType.FeatureTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
