
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dimension",
    "direction"
})
@Generated("jsonschema2pojo")
public class Sorting implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimension")
    private String dimension;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("direction")
    private Sorting.DirectionRef direction;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5317677492288921263L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Sorting() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Sorting(Sorting source) {
        super();
        this.dimension = source.dimension;
        this.direction = source.direction;
    }

    public Sorting(String dimension, Sorting.DirectionRef direction) {
        super();
        this.dimension = dimension;
        this.direction = direction;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimension")
    public String getDimension() {
        return dimension;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dimension")
    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public Sorting withDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("direction")
    public Sorting.DirectionRef getDirection() {
        return direction;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("direction")
    public void setDirection(Sorting.DirectionRef direction) {
        this.direction = direction;
    }

    public Sorting withDirection(Sorting.DirectionRef direction) {
        this.direction = direction;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Sorting withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dimension".equals(name)) {
            if (value instanceof String) {
                setDimension(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"dimension\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("direction".equals(name)) {
                if (value instanceof Sorting.DirectionRef) {
                    setDirection(((Sorting.DirectionRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"direction\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sorting.DirectionRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                return false;
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dimension".equals(name)) {
            return getDimension();
        } else {
            if ("direction".equals(name)) {
                return getDirection();
            } else {
                return notFoundValue;
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Sorting.NOT_FOUND_VALUE);
        if (Sorting.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Sorting with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Sorting.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dimension");
        sb.append('=');
        sb.append(((this.dimension == null)?"<null>":this.dimension));
        sb.append(',');
        sb.append("direction");
        sb.append('=');
        sb.append(((this.direction == null)?"<null>":this.direction));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dimension == null)? 0 :this.dimension.hashCode()));
        result = ((result* 31)+((this.direction == null)? 0 :this.direction.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Sorting) == false) {
            return false;
        }
        Sorting rhs = ((Sorting) other);
        return ((((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties)))&&((this.dimension == rhs.dimension)||((this.dimension!= null)&&this.dimension.equals(rhs.dimension))))&&((this.direction == rhs.direction)||((this.direction!= null)&&this.direction.equals(rhs.direction))));
    }

    @Generated("jsonschema2pojo")
    public enum DirectionRef {

        ASC("ASC"),
        DESC("DESC");
        private final String value;
        private final static Map<String, Sorting.DirectionRef> CONSTANTS = new HashMap<String, Sorting.DirectionRef>();

        static {
            for (Sorting.DirectionRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DirectionRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Sorting.DirectionRef fromValue(String value) {
            Sorting.DirectionRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
