
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dimension",
    "parent",
    "values"
})
@Generated("jsonschema2pojo")
public class SimpleDimension implements Serializable
{

    @JsonProperty("dimension")
    private String dimension;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("parent")
    private SimpleDimension.ParentRef parent;
    @JsonProperty("values")
    private List<String> values;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6931388756016003163L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SimpleDimension() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public SimpleDimension(SimpleDimension source) {
        super();
        this.dimension = source.dimension;
        this.parent = source.parent;
        this.values = source.values;
    }

    public SimpleDimension(String dimension, SimpleDimension.ParentRef parent, List<String> values) {
        super();
        this.dimension = dimension;
        this.parent = parent;
        this.values = values;
    }

    @JsonProperty("dimension")
    public Optional<String> getDimension() {
        return Optional.ofNullable(dimension);
    }

    @JsonProperty("dimension")
    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public SimpleDimension withDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("parent")
    public SimpleDimension.ParentRef getParent() {
        return parent;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("parent")
    public void setParent(SimpleDimension.ParentRef parent) {
        this.parent = parent;
    }

    public SimpleDimension withParent(SimpleDimension.ParentRef parent) {
        this.parent = parent;
        return this;
    }

    @JsonProperty("values")
    public Optional<List<String>> getValues() {
        return Optional.ofNullable(values);
    }

    @JsonProperty("values")
    public void setValues(List<String> values) {
        this.values = values;
    }

    public SimpleDimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public SimpleDimension withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("dimension".equals(name)) {
            if (value instanceof String) {
                setDimension(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"dimension\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("parent".equals(name)) {
                if (value instanceof SimpleDimension.ParentRef) {
                    setParent(((SimpleDimension.ParentRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"parent\" is of type \"org.hisp.dhis.api.model.v40_2_2.SimpleDimension.ParentRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("values".equals(name)) {
                    if (value instanceof List) {
                        setValues(((List<String> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"values\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("dimension".equals(name)) {
            return getDimension();
        } else {
            if ("parent".equals(name)) {
                return getParent();
            } else {
                if ("values".equals(name)) {
                    return getValues();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, SimpleDimension.NOT_FOUND_VALUE);
        if (SimpleDimension.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public SimpleDimension with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SimpleDimension.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("dimension");
        sb.append('=');
        sb.append(((this.dimension == null)?"<null>":this.dimension));
        sb.append(',');
        sb.append("parent");
        sb.append('=');
        sb.append(((this.parent == null)?"<null>":this.parent));
        sb.append(',');
        sb.append("values");
        sb.append('=');
        sb.append(((this.values == null)?"<null>":this.values));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.parent == null)? 0 :this.parent.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dimension == null)? 0 :this.dimension.hashCode()));
        result = ((result* 31)+((this.values == null)? 0 :this.values.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SimpleDimension) == false) {
            return false;
        }
        SimpleDimension rhs = ((SimpleDimension) other);
        return (((((this.parent == rhs.parent)||((this.parent!= null)&&this.parent.equals(rhs.parent)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dimension == rhs.dimension)||((this.dimension!= null)&&this.dimension.equals(rhs.dimension))))&&((this.values == rhs.values)||((this.values!= null)&&this.values.equals(rhs.values))));
    }

    @Generated("jsonschema2pojo")
    public enum ParentRef {

        COLUMN("COLUMN"),
        ROW("ROW"),
        FILTER("FILTER");
        private final String value;
        private final static Map<String, SimpleDimension.ParentRef> CONSTANTS = new HashMap<String, SimpleDimension.ParentRef>();

        static {
            for (SimpleDimension.ParentRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ParentRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static SimpleDimension.ParentRef fromValue(String value) {
            SimpleDimension.ParentRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
