
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "program",
    "programStage",
    "relationshipEntity",
    "trackedEntityType",
    "trackerDataView"
})
@Generated("jsonschema2pojo")
public class RelationshipConstraint implements Serializable
{

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private ProgramRef__11 program;
    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    @JsonPropertyDescription("A UID reference to a ProgramStage  \n(Java name `org.hisp.dhis.program.ProgramStage`)")
    private ProgramStageRef__16 programStage;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("relationshipEntity")
    private RelationshipConstraint.RelationshipEntityRef relationshipEntity;
    /**
     * A UID reference to a TrackedEntityType  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityType`)
     * 
     */
    @JsonProperty("trackedEntityType")
    @JsonPropertyDescription("A UID reference to a TrackedEntityType  \n(Java name `org.hisp.dhis.trackedentity.TrackedEntityType`)")
    private TrackedEntityTypeRef__2 trackedEntityType;
    @JsonProperty("trackerDataView")
    private TrackerDataView trackerDataView;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4823786827718371900L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RelationshipConstraint() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public RelationshipConstraint(RelationshipConstraint source) {
        super();
        this.program = source.program;
        this.programStage = source.programStage;
        this.relationshipEntity = source.relationshipEntity;
        this.trackedEntityType = source.trackedEntityType;
        this.trackerDataView = source.trackerDataView;
    }

    /**
     * 
     * @param programStage
     *     A UID reference to a ProgramStage  
     *     (Java name `org.hisp.dhis.program.ProgramStage`).
     * @param trackedEntityType
     *     A UID reference to a TrackedEntityType  
     *     (Java name `org.hisp.dhis.trackedentity.TrackedEntityType`).
     * @param program
     *     A UID reference to a Program  
     *     (Java name `org.hisp.dhis.program.Program`).
     */
    public RelationshipConstraint(ProgramRef__11 program, ProgramStageRef__16 programStage, RelationshipConstraint.RelationshipEntityRef relationshipEntity, TrackedEntityTypeRef__2 trackedEntityType, TrackerDataView trackerDataView) {
        super();
        this.program = program;
        this.programStage = programStage;
        this.relationshipEntity = relationshipEntity;
        this.trackedEntityType = trackedEntityType;
        this.trackerDataView = trackerDataView;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<ProgramRef__11> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(ProgramRef__11 program) {
        this.program = program;
    }

    public RelationshipConstraint withProgram(ProgramRef__11 program) {
        this.program = program;
        return this;
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public Optional<ProgramStageRef__16> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public void setProgramStage(ProgramStageRef__16 programStage) {
        this.programStage = programStage;
    }

    public RelationshipConstraint withProgramStage(ProgramStageRef__16 programStage) {
        this.programStage = programStage;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("relationshipEntity")
    public RelationshipConstraint.RelationshipEntityRef getRelationshipEntity() {
        return relationshipEntity;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("relationshipEntity")
    public void setRelationshipEntity(RelationshipConstraint.RelationshipEntityRef relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
    }

    public RelationshipConstraint withRelationshipEntity(RelationshipConstraint.RelationshipEntityRef relationshipEntity) {
        this.relationshipEntity = relationshipEntity;
        return this;
    }

    /**
     * A UID reference to a TrackedEntityType  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityType`)
     * 
     */
    @JsonProperty("trackedEntityType")
    public Optional<TrackedEntityTypeRef__2> getTrackedEntityType() {
        return Optional.ofNullable(trackedEntityType);
    }

    /**
     * A UID reference to a TrackedEntityType  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityType`)
     * 
     */
    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(TrackedEntityTypeRef__2 trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public RelationshipConstraint withTrackedEntityType(TrackedEntityTypeRef__2 trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonProperty("trackerDataView")
    public Optional<TrackerDataView> getTrackerDataView() {
        return Optional.ofNullable(trackerDataView);
    }

    @JsonProperty("trackerDataView")
    public void setTrackerDataView(TrackerDataView trackerDataView) {
        this.trackerDataView = trackerDataView;
    }

    public RelationshipConstraint withTrackerDataView(TrackerDataView trackerDataView) {
        this.trackerDataView = trackerDataView;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public RelationshipConstraint withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("program".equals(name)) {
            if (value instanceof ProgramRef__11) {
                setProgram(((ProgramRef__11) value));
            } else {
                throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramRef__11\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("programStage".equals(name)) {
                if (value instanceof ProgramStageRef__16) {
                    setProgramStage(((ProgramStageRef__16) value));
                } else {
                    throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramStageRef__16\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("relationshipEntity".equals(name)) {
                    if (value instanceof RelationshipConstraint.RelationshipEntityRef) {
                        setRelationshipEntity(((RelationshipConstraint.RelationshipEntityRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"relationshipEntity\" is of type \"org.hisp.dhis.api.model.v40_2_2.RelationshipConstraint.RelationshipEntityRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("trackedEntityType".equals(name)) {
                        if (value instanceof TrackedEntityTypeRef__2) {
                            setTrackedEntityType(((TrackedEntityTypeRef__2) value));
                        } else {
                            throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackedEntityTypeRef__2\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("trackerDataView".equals(name)) {
                            if (value instanceof TrackerDataView) {
                                setTrackerDataView(((TrackerDataView) value));
                            } else {
                                throw new IllegalArgumentException(("property \"trackerDataView\" is of type \"org.hisp.dhis.api.model.v40_2_2.TrackerDataView\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("program".equals(name)) {
            return getProgram();
        } else {
            if ("programStage".equals(name)) {
                return getProgramStage();
            } else {
                if ("relationshipEntity".equals(name)) {
                    return getRelationshipEntity();
                } else {
                    if ("trackedEntityType".equals(name)) {
                        return getTrackedEntityType();
                    } else {
                        if ("trackerDataView".equals(name)) {
                            return getTrackerDataView();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, RelationshipConstraint.NOT_FOUND_VALUE);
        if (RelationshipConstraint.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public RelationshipConstraint with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(RelationshipConstraint.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("relationshipEntity");
        sb.append('=');
        sb.append(((this.relationshipEntity == null)?"<null>":this.relationshipEntity));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("trackerDataView");
        sb.append('=');
        sb.append(((this.trackerDataView == null)?"<null>":this.trackerDataView));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.trackerDataView == null)? 0 :this.trackerDataView.hashCode()));
        result = ((result* 31)+((this.relationshipEntity == null)? 0 :this.relationshipEntity.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RelationshipConstraint) == false) {
            return false;
        }
        RelationshipConstraint rhs = ((RelationshipConstraint) other);
        return (((((((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage)))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.trackerDataView == rhs.trackerDataView)||((this.trackerDataView!= null)&&this.trackerDataView.equals(rhs.trackerDataView))))&&((this.relationshipEntity == rhs.relationshipEntity)||((this.relationshipEntity!= null)&&this.relationshipEntity.equals(rhs.relationshipEntity))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum RelationshipEntityRef {

        TRACKED_ENTITY_INSTANCE("TRACKED_ENTITY_INSTANCE"),
        PROGRAM_INSTANCE("PROGRAM_INSTANCE"),
        PROGRAM_STAGE_INSTANCE("PROGRAM_STAGE_INSTANCE");
        private final String value;
        private final static Map<String, RelationshipConstraint.RelationshipEntityRef> CONSTANTS = new HashMap<String, RelationshipConstraint.RelationshipEntityRef>();

        static {
            for (RelationshipConstraint.RelationshipEntityRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RelationshipEntityRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static RelationshipConstraint.RelationshipEntityRef fromValue(String value) {
            RelationshipConstraint.RelationshipEntityRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
