
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "aggregationType",
    "maxDate",
    "minDate",
    "periodOffset",
    "valueType",
    "yearToDate"
})
@Generated("jsonschema2pojo")
public class QueryModifiers implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private QueryModifiers.AggregationTypeRef aggregationType;
    @JsonProperty("maxDate")
    private Date maxDate;
    @JsonProperty("minDate")
    private Date minDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("periodOffset")
    private Integer periodOffset;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private QueryModifiers.ValueTypeRef valueType;
    @JsonProperty("yearToDate")
    private Boolean yearToDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2765978518913256958L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public QueryModifiers() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public QueryModifiers(QueryModifiers source) {
        super();
        this.aggregationType = source.aggregationType;
        this.maxDate = source.maxDate;
        this.minDate = source.minDate;
        this.periodOffset = source.periodOffset;
        this.valueType = source.valueType;
        this.yearToDate = source.yearToDate;
    }

    public QueryModifiers(QueryModifiers.AggregationTypeRef aggregationType, Date maxDate, Date minDate, Integer periodOffset, QueryModifiers.ValueTypeRef valueType, Boolean yearToDate) {
        super();
        this.aggregationType = aggregationType;
        this.maxDate = maxDate;
        this.minDate = minDate;
        this.periodOffset = periodOffset;
        this.valueType = valueType;
        this.yearToDate = yearToDate;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public QueryModifiers.AggregationTypeRef getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(QueryModifiers.AggregationTypeRef aggregationType) {
        this.aggregationType = aggregationType;
    }

    public QueryModifiers withAggregationType(QueryModifiers.AggregationTypeRef aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("maxDate")
    public Optional<Date> getMaxDate() {
        return Optional.ofNullable(maxDate);
    }

    @JsonProperty("maxDate")
    public void setMaxDate(Date maxDate) {
        this.maxDate = maxDate;
    }

    public QueryModifiers withMaxDate(Date maxDate) {
        this.maxDate = maxDate;
        return this;
    }

    @JsonProperty("minDate")
    public Optional<Date> getMinDate() {
        return Optional.ofNullable(minDate);
    }

    @JsonProperty("minDate")
    public void setMinDate(Date minDate) {
        this.minDate = minDate;
    }

    public QueryModifiers withMinDate(Date minDate) {
        this.minDate = minDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("periodOffset")
    public Integer getPeriodOffset() {
        return periodOffset;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("periodOffset")
    public void setPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
    }

    public QueryModifiers withPeriodOffset(Integer periodOffset) {
        this.periodOffset = periodOffset;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public QueryModifiers.ValueTypeRef getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(QueryModifiers.ValueTypeRef valueType) {
        this.valueType = valueType;
    }

    public QueryModifiers withValueType(QueryModifiers.ValueTypeRef valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonProperty("yearToDate")
    public Optional<Boolean> getYearToDate() {
        return Optional.ofNullable(yearToDate);
    }

    @JsonProperty("yearToDate")
    public void setYearToDate(Boolean yearToDate) {
        this.yearToDate = yearToDate;
    }

    public QueryModifiers withYearToDate(Boolean yearToDate) {
        this.yearToDate = yearToDate;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public QueryModifiers withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("aggregationType".equals(name)) {
            if (value instanceof QueryModifiers.AggregationTypeRef) {
                setAggregationType(((QueryModifiers.AggregationTypeRef) value));
            } else {
                throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_2_2.QueryModifiers.AggregationTypeRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("maxDate".equals(name)) {
                if (value instanceof Date) {
                    setMaxDate(((Date) value));
                } else {
                    throw new IllegalArgumentException(("property \"maxDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("minDate".equals(name)) {
                    if (value instanceof Date) {
                        setMinDate(((Date) value));
                    } else {
                        throw new IllegalArgumentException(("property \"minDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("periodOffset".equals(name)) {
                        if (value instanceof Integer) {
                            setPeriodOffset(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"periodOffset\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("valueType".equals(name)) {
                            if (value instanceof QueryModifiers.ValueTypeRef) {
                                setValueType(((QueryModifiers.ValueTypeRef) value));
                            } else {
                                throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_2_2.QueryModifiers.ValueTypeRef\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("yearToDate".equals(name)) {
                                if (value instanceof Boolean) {
                                    setYearToDate(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"yearToDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("aggregationType".equals(name)) {
            return getAggregationType();
        } else {
            if ("maxDate".equals(name)) {
                return getMaxDate();
            } else {
                if ("minDate".equals(name)) {
                    return getMinDate();
                } else {
                    if ("periodOffset".equals(name)) {
                        return getPeriodOffset();
                    } else {
                        if ("valueType".equals(name)) {
                            return getValueType();
                        } else {
                            if ("yearToDate".equals(name)) {
                                return getYearToDate();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, QueryModifiers.NOT_FOUND_VALUE);
        if (QueryModifiers.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public QueryModifiers with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(QueryModifiers.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("maxDate");
        sb.append('=');
        sb.append(((this.maxDate == null)?"<null>":this.maxDate));
        sb.append(',');
        sb.append("minDate");
        sb.append('=');
        sb.append(((this.minDate == null)?"<null>":this.minDate));
        sb.append(',');
        sb.append("periodOffset");
        sb.append('=');
        sb.append(((this.periodOffset == null)?"<null>":this.periodOffset));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("yearToDate");
        sb.append('=');
        sb.append(((this.yearToDate == null)?"<null>":this.yearToDate));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.minDate == null)? 0 :this.minDate.hashCode()));
        result = ((result* 31)+((this.periodOffset == null)? 0 :this.periodOffset.hashCode()));
        result = ((result* 31)+((this.yearToDate == null)? 0 :this.yearToDate.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.maxDate == null)? 0 :this.maxDate.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof QueryModifiers) == false) {
            return false;
        }
        QueryModifiers rhs = ((QueryModifiers) other);
        return ((((((((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType)))&&((this.minDate == rhs.minDate)||((this.minDate!= null)&&this.minDate.equals(rhs.minDate))))&&((this.periodOffset == rhs.periodOffset)||((this.periodOffset!= null)&&this.periodOffset.equals(rhs.periodOffset))))&&((this.yearToDate == rhs.yearToDate)||((this.yearToDate!= null)&&this.yearToDate.equals(rhs.yearToDate))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.maxDate == rhs.maxDate)||((this.maxDate!= null)&&this.maxDate.equals(rhs.maxDate))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationTypeRef {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, QueryModifiers.AggregationTypeRef> CONSTANTS = new HashMap<String, QueryModifiers.AggregationTypeRef>();

        static {
            for (QueryModifiers.AggregationTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static QueryModifiers.AggregationTypeRef fromValue(String value) {
            QueryModifiers.AggregationTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValueTypeRef {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, QueryModifiers.ValueTypeRef> CONSTANTS = new HashMap<String, QueryModifiers.ValueTypeRef>();

        static {
            for (QueryModifiers.ValueTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static QueryModifiers.ValueTypeRef fromValue(String value) {
            QueryModifiers.ValueTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
