
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attribute",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "description",
    "displayDescription",
    "displayFormName",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "program",
    "publicAccess",
    "queryMods",
    "sharing",
    "shortName",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramTrackedEntityAttributeDimensionItem implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("attribute")
    @JsonPropertyDescription("A UID reference to a TrackedEntityAttribute  \n(Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)")
    private AttributeRef__1 attribute;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__18 createdBy;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__18 lastUpdatedBy;
    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private LegendSetRef__6 legendSet;
    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    @JsonPropertyDescription("A UID reference to a Program  \n(Java name `org.hisp.dhis.program.Program`)")
    private ProgramRef program;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("queryMods")
    private QueryModifiers queryMods;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__19 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -282004120605092897L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramTrackedEntityAttributeDimensionItem() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramTrackedEntityAttributeDimensionItem(ProgramTrackedEntityAttributeDimensionItem source) {
        super();
        this.access = source.access;
        this.attribute = source.attribute;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.program = source.program;
        this.publicAccess = source.publicAccess;
        this.queryMods = source.queryMods;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param legendSet
     *     A UID reference to a LegendSet  
     *     (Java name `org.hisp.dhis.legend.LegendSet`).
     * @param attribute
     *     A UID reference to a TrackedEntityAttribute  
     *     (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`).
     * @param program
     *     A UID reference to a Program  
     *     (Java name `org.hisp.dhis.program.Program`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public ProgramTrackedEntityAttributeDimensionItem(Access access, AttributeRef__1 attribute, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__18 createdBy, String description, String displayDescription, String displayFormName, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, String id, Date lastUpdated, LastUpdatedByRef__18 lastUpdatedBy, LegendSetRef__6 legendSet, ProgramRef program, String publicAccess, QueryModifiers queryMods, Sharing sharing, String shortName, List<Translation> translations, UserRef__19 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attribute = attribute;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.program = program;
        this.publicAccess = publicAccess;
        this.queryMods = queryMods;
        this.sharing = sharing;
        this.shortName = shortName;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramTrackedEntityAttributeDimensionItem withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("attribute")
    public Optional<AttributeRef__1> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    /**
     * A UID reference to a TrackedEntityAttribute  
     * (Java name `org.hisp.dhis.trackedentity.TrackedEntityAttribute`)
     * 
     */
    @JsonProperty("attribute")
    public void setAttribute(AttributeRef__1 attribute) {
        this.attribute = attribute;
    }

    public ProgramTrackedEntityAttributeDimensionItem withAttribute(AttributeRef__1 attribute) {
        this.attribute = attribute;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramTrackedEntityAttributeDimensionItem withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramTrackedEntityAttributeDimensionItem withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramTrackedEntityAttributeDimensionItem withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__18> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__18 createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramTrackedEntityAttributeDimensionItem withCreatedBy(CreatedByRef__18 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public ProgramTrackedEntityAttributeDimensionItem withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public ProgramTrackedEntityAttributeDimensionItem withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public ProgramTrackedEntityAttributeDimensionItem withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramTrackedEntityAttributeDimensionItem withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramTrackedEntityAttributeDimensionItem withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramTrackedEntityAttributeDimensionItem withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public ProgramTrackedEntityAttributeDimensionItem withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramTrackedEntityAttributeDimensionItem withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramTrackedEntityAttributeDimensionItem withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramTrackedEntityAttributeDimensionItem withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__18> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__18 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramTrackedEntityAttributeDimensionItem withLastUpdatedBy(LastUpdatedByRef__18 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public Optional<LegendSetRef__6> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(LegendSetRef__6 legendSet) {
        this.legendSet = legendSet;
    }

    public ProgramTrackedEntityAttributeDimensionItem withLegendSet(LegendSetRef__6 legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public Optional<ProgramRef> getProgram() {
        return Optional.ofNullable(program);
    }

    /**
     * A UID reference to a Program  
     * (Java name `org.hisp.dhis.program.Program`)
     * 
     */
    @JsonProperty("program")
    public void setProgram(ProgramRef program) {
        this.program = program;
    }

    public ProgramTrackedEntityAttributeDimensionItem withProgram(ProgramRef program) {
        this.program = program;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramTrackedEntityAttributeDimensionItem withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("queryMods")
    public Optional<QueryModifiers> getQueryMods() {
        return Optional.ofNullable(queryMods);
    }

    @JsonProperty("queryMods")
    public void setQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
    }

    public ProgramTrackedEntityAttributeDimensionItem withQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramTrackedEntityAttributeDimensionItem withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public ProgramTrackedEntityAttributeDimensionItem withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramTrackedEntityAttributeDimensionItem withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__19> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__19 user) {
        this.user = user;
    }

    public ProgramTrackedEntityAttributeDimensionItem withUser(UserRef__19 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramTrackedEntityAttributeDimensionItem withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramTrackedEntityAttributeDimensionItem withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramTrackedEntityAttributeDimensionItem withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attribute".equals(name)) {
                if (value instanceof AttributeRef__1) {
                    setAttribute(((AttributeRef__1) value));
                } else {
                    throw new IllegalArgumentException(("property \"attribute\" is of type \"org.hisp.dhis.api.model.v40_2_2.AttributeRef__1\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("code".equals(name)) {
                        if (value instanceof String) {
                            setCode(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdBy".equals(name)) {
                                if (value instanceof CreatedByRef__18) {
                                    setCreatedBy(((CreatedByRef__18) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__18\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("description".equals(name)) {
                                    if (value instanceof String) {
                                        setDescription(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayDescription".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayDescription(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("displayFormName".equals(name)) {
                                            if (value instanceof String) {
                                                setDisplayFormName(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setExternalAccess(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    if (value instanceof Boolean) {
                                                        setFavorite(((Boolean) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        if (value instanceof List) {
                                                            setFavorites(((List<String> ) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("formName".equals(name)) {
                                                            if (value instanceof String) {
                                                                setFormName(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("href".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setHref(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("id".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setId(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("lastUpdated".equals(name)) {
                                                                        if (value instanceof Date) {
                                                                            setLastUpdated(((Date) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                            if (value instanceof LastUpdatedByRef__18) {
                                                                                setLastUpdatedBy(((LastUpdatedByRef__18) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__18\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("legendSet".equals(name)) {
                                                                                if (value instanceof LegendSetRef__6) {
                                                                                    setLegendSet(((LegendSetRef__6) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.LegendSetRef__6\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("program".equals(name)) {
                                                                                    if (value instanceof ProgramRef) {
                                                                                        setProgram(((ProgramRef) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"program\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramRef\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("publicAccess".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setPublicAccess(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("queryMods".equals(name)) {
                                                                                            if (value instanceof QueryModifiers) {
                                                                                                setQueryMods(((QueryModifiers) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"queryMods\" is of type \"org.hisp.dhis.api.model.v40_2_2.QueryModifiers\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("sharing".equals(name)) {
                                                                                                if (value instanceof Sharing) {
                                                                                                    setSharing(((Sharing) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("shortName".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setShortName(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            if (value instanceof UserRef__19) {
                                                                                                                setUser(((UserRef__19) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__19\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attribute".equals(name)) {
                return getAttribute();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("code".equals(name)) {
                        return getCode();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdBy".equals(name)) {
                                return getCreatedBy();
                            } else {
                                if ("description".equals(name)) {
                                    return getDescription();
                                } else {
                                    if ("displayDescription".equals(name)) {
                                        return getDisplayDescription();
                                    } else {
                                        if ("displayFormName".equals(name)) {
                                            return getDisplayFormName();
                                        } else {
                                            if ("externalAccess".equals(name)) {
                                                return getExternalAccess();
                                            } else {
                                                if ("favorite".equals(name)) {
                                                    return getFavorite();
                                                } else {
                                                    if ("favorites".equals(name)) {
                                                        return getFavorites();
                                                    } else {
                                                        if ("formName".equals(name)) {
                                                            return getFormName();
                                                        } else {
                                                            if ("href".equals(name)) {
                                                                return getHref();
                                                            } else {
                                                                if ("id".equals(name)) {
                                                                    return getId();
                                                                } else {
                                                                    if ("lastUpdated".equals(name)) {
                                                                        return getLastUpdated();
                                                                    } else {
                                                                        if ("lastUpdatedBy".equals(name)) {
                                                                            return getLastUpdatedBy();
                                                                        } else {
                                                                            if ("legendSet".equals(name)) {
                                                                                return getLegendSet();
                                                                            } else {
                                                                                if ("program".equals(name)) {
                                                                                    return getProgram();
                                                                                } else {
                                                                                    if ("publicAccess".equals(name)) {
                                                                                        return getPublicAccess();
                                                                                    } else {
                                                                                        if ("queryMods".equals(name)) {
                                                                                            return getQueryMods();
                                                                                        } else {
                                                                                            if ("sharing".equals(name)) {
                                                                                                return getSharing();
                                                                                            } else {
                                                                                                if ("shortName".equals(name)) {
                                                                                                    return getShortName();
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        return getTranslations();
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            return getUser();
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                return getUserAccesses();
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    return getUserGroupAccesses();
                                                                                                                } else {
                                                                                                                    return notFoundValue;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramTrackedEntityAttributeDimensionItem.NOT_FOUND_VALUE);
        if (ProgramTrackedEntityAttributeDimensionItem.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramTrackedEntityAttributeDimensionItem with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramTrackedEntityAttributeDimensionItem.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("program");
        sb.append('=');
        sb.append(((this.program == null)?"<null>":this.program));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("queryMods");
        sb.append('=');
        sb.append(((this.queryMods == null)?"<null>":this.queryMods));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.program == null)? 0 :this.program.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.queryMods == null)? 0 :this.queryMods.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramTrackedEntityAttributeDimensionItem) == false) {
            return false;
        }
        ProgramTrackedEntityAttributeDimensionItem rhs = ((ProgramTrackedEntityAttributeDimensionItem) other);
        return (((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.program == rhs.program)||((this.program!= null)&&this.program.equals(rhs.program))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.queryMods == rhs.queryMods)||((this.queryMods!= null)&&this.queryMods.equals(rhs.queryMods))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
