
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "allowFutureDate",
    "allowProvidedElsewhere",
    "attributeValues",
    "code",
    "compulsory",
    "created",
    "createdBy",
    "dataElement",
    "displayInReports",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "name",
    "programStage",
    "publicAccess",
    "renderOptionsAsRadio",
    "renderType",
    "sharing",
    "skipAnalytics",
    "skipSynchronization",
    "sortOrder",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramStageDataElement implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("allowFutureDate")
    private Boolean allowFutureDate;
    @JsonProperty("allowProvidedElsewhere")
    private Boolean allowProvidedElsewhere;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("compulsory")
    private Boolean compulsory;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__74 createdBy;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private DataElementRef__7 dataElement;
    @JsonProperty("displayInReports")
    private Boolean displayInReports;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__74 lastUpdatedBy;
    @JsonProperty("name")
    private String name;
    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    @JsonPropertyDescription("A UID reference to a ProgramStage  \n(Java name `org.hisp.dhis.program.ProgramStage`)")
    private ProgramStageRef__12 programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("renderOptionsAsRadio")
    private Boolean renderOptionsAsRadio;
    /**
     * The exact type is unknown.  
     * (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)
     * 
     */
    @JsonProperty("renderType")
    @JsonPropertyDescription("The exact type is unknown.  \n(Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)")
    private Object renderType;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("skipAnalytics")
    private Boolean skipAnalytics;
    @JsonProperty("skipSynchronization")
    private Boolean skipSynchronization;
    @JsonProperty("sortOrder")
    private Integer sortOrder;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__76 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 7798534361157072585L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramStageDataElement() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramStageDataElement(ProgramStageDataElement source) {
        super();
        this.access = source.access;
        this.allowFutureDate = source.allowFutureDate;
        this.allowProvidedElsewhere = source.allowProvidedElsewhere;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.compulsory = source.compulsory;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataElement = source.dataElement;
        this.displayInReports = source.displayInReports;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.name = source.name;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.renderOptionsAsRadio = source.renderOptionsAsRadio;
        this.renderType = source.renderType;
        this.sharing = source.sharing;
        this.skipAnalytics = source.skipAnalytics;
        this.skipSynchronization = source.skipSynchronization;
        this.sortOrder = source.sortOrder;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param programStage
     *     A UID reference to a ProgramStage  
     *     (Java name `org.hisp.dhis.program.ProgramStage`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param dataElement
     *     A UID reference to a DataElement  
     *     (Java name `org.hisp.dhis.dataelement.DataElement`).
     * @param renderType
     *     The exact type is unknown.  
     *     (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public ProgramStageDataElement(Access access, Boolean allowFutureDate, Boolean allowProvidedElsewhere, List<AttributeValue> attributeValues, String code, Boolean compulsory, Date created, CreatedByRef__74 createdBy, DataElementRef__7 dataElement, Boolean displayInReports, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, LastUpdatedByRef__74 lastUpdatedBy, String name, ProgramStageRef__12 programStage, String publicAccess, Boolean renderOptionsAsRadio, Object renderType, Sharing sharing, Boolean skipAnalytics, Boolean skipSynchronization, Integer sortOrder, List<Translation> translations, UserRef__76 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.allowFutureDate = allowFutureDate;
        this.allowProvidedElsewhere = allowProvidedElsewhere;
        this.attributeValues = attributeValues;
        this.code = code;
        this.compulsory = compulsory;
        this.created = created;
        this.createdBy = createdBy;
        this.dataElement = dataElement;
        this.displayInReports = displayInReports;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.name = name;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.renderOptionsAsRadio = renderOptionsAsRadio;
        this.renderType = renderType;
        this.sharing = sharing;
        this.skipAnalytics = skipAnalytics;
        this.skipSynchronization = skipSynchronization;
        this.sortOrder = sortOrder;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramStageDataElement withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("allowFutureDate")
    public Optional<Boolean> getAllowFutureDate() {
        return Optional.ofNullable(allowFutureDate);
    }

    @JsonProperty("allowFutureDate")
    public void setAllowFutureDate(Boolean allowFutureDate) {
        this.allowFutureDate = allowFutureDate;
    }

    public ProgramStageDataElement withAllowFutureDate(Boolean allowFutureDate) {
        this.allowFutureDate = allowFutureDate;
        return this;
    }

    @JsonProperty("allowProvidedElsewhere")
    public Optional<Boolean> getAllowProvidedElsewhere() {
        return Optional.ofNullable(allowProvidedElsewhere);
    }

    @JsonProperty("allowProvidedElsewhere")
    public void setAllowProvidedElsewhere(Boolean allowProvidedElsewhere) {
        this.allowProvidedElsewhere = allowProvidedElsewhere;
    }

    public ProgramStageDataElement withAllowProvidedElsewhere(Boolean allowProvidedElsewhere) {
        this.allowProvidedElsewhere = allowProvidedElsewhere;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramStageDataElement withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramStageDataElement withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("compulsory")
    public Optional<Boolean> getCompulsory() {
        return Optional.ofNullable(compulsory);
    }

    @JsonProperty("compulsory")
    public void setCompulsory(Boolean compulsory) {
        this.compulsory = compulsory;
    }

    public ProgramStageDataElement withCompulsory(Boolean compulsory) {
        this.compulsory = compulsory;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramStageDataElement withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__74> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__74 createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramStageDataElement withCreatedBy(CreatedByRef__74 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<DataElementRef__7> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(DataElementRef__7 dataElement) {
        this.dataElement = dataElement;
    }

    public ProgramStageDataElement withDataElement(DataElementRef__7 dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("displayInReports")
    public Optional<Boolean> getDisplayInReports() {
        return Optional.ofNullable(displayInReports);
    }

    @JsonProperty("displayInReports")
    public void setDisplayInReports(Boolean displayInReports) {
        this.displayInReports = displayInReports;
    }

    public ProgramStageDataElement withDisplayInReports(Boolean displayInReports) {
        this.displayInReports = displayInReports;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramStageDataElement withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramStageDataElement withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramStageDataElement withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramStageDataElement withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramStageDataElement withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramStageDataElement withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramStageDataElement withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__74> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__74 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramStageDataElement withLastUpdatedBy(LastUpdatedByRef__74 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramStageDataElement withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public Optional<ProgramStageRef__12> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public void setProgramStage(ProgramStageRef__12 programStage) {
        this.programStage = programStage;
    }

    public ProgramStageDataElement withProgramStage(ProgramStageRef__12 programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramStageDataElement withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("renderOptionsAsRadio")
    public Optional<Boolean> getRenderOptionsAsRadio() {
        return Optional.ofNullable(renderOptionsAsRadio);
    }

    @JsonProperty("renderOptionsAsRadio")
    public void setRenderOptionsAsRadio(Boolean renderOptionsAsRadio) {
        this.renderOptionsAsRadio = renderOptionsAsRadio;
    }

    public ProgramStageDataElement withRenderOptionsAsRadio(Boolean renderOptionsAsRadio) {
        this.renderOptionsAsRadio = renderOptionsAsRadio;
        return this;
    }

    /**
     * The exact type is unknown.  
     * (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)
     * 
     */
    @JsonProperty("renderType")
    public Optional<Object> getRenderType() {
        return Optional.ofNullable(renderType);
    }

    /**
     * The exact type is unknown.  
     * (Java type was: `org.hisp.dhis.render.DeviceRenderTypeMap<org.hisp.dhis.render.type.ValueTypeRenderingObject>`)
     * 
     */
    @JsonProperty("renderType")
    public void setRenderType(Object renderType) {
        this.renderType = renderType;
    }

    public ProgramStageDataElement withRenderType(Object renderType) {
        this.renderType = renderType;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramStageDataElement withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("skipAnalytics")
    public Optional<Boolean> getSkipAnalytics() {
        return Optional.ofNullable(skipAnalytics);
    }

    @JsonProperty("skipAnalytics")
    public void setSkipAnalytics(Boolean skipAnalytics) {
        this.skipAnalytics = skipAnalytics;
    }

    public ProgramStageDataElement withSkipAnalytics(Boolean skipAnalytics) {
        this.skipAnalytics = skipAnalytics;
        return this;
    }

    @JsonProperty("skipSynchronization")
    public Optional<Boolean> getSkipSynchronization() {
        return Optional.ofNullable(skipSynchronization);
    }

    @JsonProperty("skipSynchronization")
    public void setSkipSynchronization(Boolean skipSynchronization) {
        this.skipSynchronization = skipSynchronization;
    }

    public ProgramStageDataElement withSkipSynchronization(Boolean skipSynchronization) {
        this.skipSynchronization = skipSynchronization;
        return this;
    }

    @JsonProperty("sortOrder")
    public Optional<Integer> getSortOrder() {
        return Optional.ofNullable(sortOrder);
    }

    @JsonProperty("sortOrder")
    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public ProgramStageDataElement withSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramStageDataElement withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__76> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__76 user) {
        this.user = user;
    }

    public ProgramStageDataElement withUser(UserRef__76 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramStageDataElement withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramStageDataElement withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramStageDataElement withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("allowFutureDate".equals(name)) {
                if (value instanceof Boolean) {
                    setAllowFutureDate(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"allowFutureDate\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("allowProvidedElsewhere".equals(name)) {
                    if (value instanceof Boolean) {
                        setAllowProvidedElsewhere(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"allowProvidedElsewhere\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("attributeValues".equals(name)) {
                        if (value instanceof List) {
                            setAttributeValues(((List<AttributeValue> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("code".equals(name)) {
                            if (value instanceof String) {
                                setCode(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("compulsory".equals(name)) {
                                if (value instanceof Boolean) {
                                    setCompulsory(((Boolean) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"compulsory\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("created".equals(name)) {
                                    if (value instanceof Date) {
                                        setCreated(((Date) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("createdBy".equals(name)) {
                                        if (value instanceof CreatedByRef__74) {
                                            setCreatedBy(((CreatedByRef__74) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__74\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dataElement".equals(name)) {
                                            if (value instanceof DataElementRef__7) {
                                                setDataElement(((DataElementRef__7) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataElementRef__7\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("displayInReports".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setDisplayInReports(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"displayInReports\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayName".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayName(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setHref(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setId(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setLastUpdated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                if (value instanceof LastUpdatedByRef__74) {
                                                                                    setLastUpdatedBy(((LastUpdatedByRef__74) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__74\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("name".equals(name)) {
                                                                                    if (value instanceof String) {
                                                                                        setName(((String) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("programStage".equals(name)) {
                                                                                        if (value instanceof ProgramStageRef__12) {
                                                                                            setProgramStage(((ProgramStageRef__12) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramStageRef__12\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setPublicAccess(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("renderOptionsAsRadio".equals(name)) {
                                                                                                if (value instanceof Boolean) {
                                                                                                    setRenderOptionsAsRadio(((Boolean) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"renderOptionsAsRadio\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("renderType".equals(name)) {
                                                                                                    if (value instanceof Object) {
                                                                                                        setRenderType(((Object) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"renderType\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("sharing".equals(name)) {
                                                                                                        if (value instanceof Sharing) {
                                                                                                            setSharing(((Sharing) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("skipAnalytics".equals(name)) {
                                                                                                            if (value instanceof Boolean) {
                                                                                                                setSkipAnalytics(((Boolean) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"skipAnalytics\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("skipSynchronization".equals(name)) {
                                                                                                                if (value instanceof Boolean) {
                                                                                                                    setSkipSynchronization(((Boolean) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"skipSynchronization\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("sortOrder".equals(name)) {
                                                                                                                    if (value instanceof Integer) {
                                                                                                                        setSortOrder(((Integer) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"sortOrder\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("translations".equals(name)) {
                                                                                                                        if (value instanceof List) {
                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("user".equals(name)) {
                                                                                                                            if (value instanceof UserRef__76) {
                                                                                                                                setUser(((UserRef__76) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__76\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                    if (value instanceof List) {
                                                                                                                                        setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    return false;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("allowFutureDate".equals(name)) {
                return getAllowFutureDate();
            } else {
                if ("allowProvidedElsewhere".equals(name)) {
                    return getAllowProvidedElsewhere();
                } else {
                    if ("attributeValues".equals(name)) {
                        return getAttributeValues();
                    } else {
                        if ("code".equals(name)) {
                            return getCode();
                        } else {
                            if ("compulsory".equals(name)) {
                                return getCompulsory();
                            } else {
                                if ("created".equals(name)) {
                                    return getCreated();
                                } else {
                                    if ("createdBy".equals(name)) {
                                        return getCreatedBy();
                                    } else {
                                        if ("dataElement".equals(name)) {
                                            return getDataElement();
                                        } else {
                                            if ("displayInReports".equals(name)) {
                                                return getDisplayInReports();
                                            } else {
                                                if ("displayName".equals(name)) {
                                                    return getDisplayName();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    return getHref();
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        return getId();
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            return getLastUpdated();
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                return getLastUpdatedBy();
                                                                            } else {
                                                                                if ("name".equals(name)) {
                                                                                    return getName();
                                                                                } else {
                                                                                    if ("programStage".equals(name)) {
                                                                                        return getProgramStage();
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            return getPublicAccess();
                                                                                        } else {
                                                                                            if ("renderOptionsAsRadio".equals(name)) {
                                                                                                return getRenderOptionsAsRadio();
                                                                                            } else {
                                                                                                if ("renderType".equals(name)) {
                                                                                                    return getRenderType();
                                                                                                } else {
                                                                                                    if ("sharing".equals(name)) {
                                                                                                        return getSharing();
                                                                                                    } else {
                                                                                                        if ("skipAnalytics".equals(name)) {
                                                                                                            return getSkipAnalytics();
                                                                                                        } else {
                                                                                                            if ("skipSynchronization".equals(name)) {
                                                                                                                return getSkipSynchronization();
                                                                                                            } else {
                                                                                                                if ("sortOrder".equals(name)) {
                                                                                                                    return getSortOrder();
                                                                                                                } else {
                                                                                                                    if ("translations".equals(name)) {
                                                                                                                        return getTranslations();
                                                                                                                    } else {
                                                                                                                        if ("user".equals(name)) {
                                                                                                                            return getUser();
                                                                                                                        } else {
                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                return getUserAccesses();
                                                                                                                            } else {
                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                } else {
                                                                                                                                    return notFoundValue;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramStageDataElement.NOT_FOUND_VALUE);
        if (ProgramStageDataElement.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramStageDataElement with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramStageDataElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("allowFutureDate");
        sb.append('=');
        sb.append(((this.allowFutureDate == null)?"<null>":this.allowFutureDate));
        sb.append(',');
        sb.append("allowProvidedElsewhere");
        sb.append('=');
        sb.append(((this.allowProvidedElsewhere == null)?"<null>":this.allowProvidedElsewhere));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("compulsory");
        sb.append('=');
        sb.append(((this.compulsory == null)?"<null>":this.compulsory));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("displayInReports");
        sb.append('=');
        sb.append(((this.displayInReports == null)?"<null>":this.displayInReports));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("renderOptionsAsRadio");
        sb.append('=');
        sb.append(((this.renderOptionsAsRadio == null)?"<null>":this.renderOptionsAsRadio));
        sb.append(',');
        sb.append("renderType");
        sb.append('=');
        sb.append(((this.renderType == null)?"<null>":this.renderType));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("skipAnalytics");
        sb.append('=');
        sb.append(((this.skipAnalytics == null)?"<null>":this.skipAnalytics));
        sb.append(',');
        sb.append("skipSynchronization");
        sb.append('=');
        sb.append(((this.skipSynchronization == null)?"<null>":this.skipSynchronization));
        sb.append(',');
        sb.append("sortOrder");
        sb.append('=');
        sb.append(((this.sortOrder == null)?"<null>":this.sortOrder));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.displayInReports == null)? 0 :this.displayInReports.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.skipSynchronization == null)? 0 :this.skipSynchronization.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.renderOptionsAsRadio == null)? 0 :this.renderOptionsAsRadio.hashCode()));
        result = ((result* 31)+((this.skipAnalytics == null)? 0 :this.skipAnalytics.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.allowFutureDate == null)? 0 :this.allowFutureDate.hashCode()));
        result = ((result* 31)+((this.renderType == null)? 0 :this.renderType.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.compulsory == null)? 0 :this.compulsory.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.allowProvidedElsewhere == null)? 0 :this.allowProvidedElsewhere.hashCode()));
        result = ((result* 31)+((this.sortOrder == null)? 0 :this.sortOrder.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramStageDataElement) == false) {
            return false;
        }
        ProgramStageDataElement rhs = ((ProgramStageDataElement) other);
        return (((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.displayInReports == rhs.displayInReports)||((this.displayInReports!= null)&&this.displayInReports.equals(rhs.displayInReports))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.skipSynchronization == rhs.skipSynchronization)||((this.skipSynchronization!= null)&&this.skipSynchronization.equals(rhs.skipSynchronization))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.renderOptionsAsRadio == rhs.renderOptionsAsRadio)||((this.renderOptionsAsRadio!= null)&&this.renderOptionsAsRadio.equals(rhs.renderOptionsAsRadio))))&&((this.skipAnalytics == rhs.skipAnalytics)||((this.skipAnalytics!= null)&&this.skipAnalytics.equals(rhs.skipAnalytics))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.allowFutureDate == rhs.allowFutureDate)||((this.allowFutureDate!= null)&&this.allowFutureDate.equals(rhs.allowFutureDate))))&&((this.renderType == rhs.renderType)||((this.renderType!= null)&&this.renderType.equals(rhs.renderType))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.compulsory == rhs.compulsory)||((this.compulsory!= null)&&this.compulsory.equals(rhs.compulsory))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.allowProvidedElsewhere == rhs.allowProvidedElsewhere)||((this.allowProvidedElsewhere!= null)&&this.allowProvidedElsewhere.equals(rhs.allowProvidedElsewhere))))&&((this.sortOrder == rhs.sortOrder)||((this.sortOrder!= null)&&this.sortOrder.equals(rhs.sortOrder))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
