
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "deliveryChannels",
    "displayName",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "messageStatus",
    "name",
    "notificationTemplate",
    "processedDate",
    "programInstance",
    "programStageInstance",
    "publicAccess",
    "recipients",
    "sharing",
    "storeCopy",
    "subject",
    "text",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class ProgramMessage implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__67 createdBy;
    @JsonProperty("deliveryChannels")
    private List<DeliveryChannelsRefRef_> deliveryChannels;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__67 lastUpdatedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageStatus")
    private ProgramMessage.MessageStatusRef messageStatus;
    @JsonProperty("name")
    private String name;
    @JsonProperty("notificationTemplate")
    private String notificationTemplate;
    @JsonProperty("processedDate")
    private Date processedDate;
    /**
     * A UID reference to a ProgramInstance  
     * (Java name `org.hisp.dhis.program.ProgramInstance`)
     * 
     */
    @JsonProperty("programInstance")
    @JsonPropertyDescription("A UID reference to a ProgramInstance  \n(Java name `org.hisp.dhis.program.ProgramInstance`)")
    private ProgramInstanceRef programInstance;
    /**
     * A UID reference to a ProgramStageInstance  
     * (Java name `org.hisp.dhis.program.ProgramStageInstance`)
     * 
     */
    @JsonProperty("programStageInstance")
    @JsonPropertyDescription("A UID reference to a ProgramStageInstance  \n(Java name `org.hisp.dhis.program.ProgramStageInstance`)")
    private ProgramStageInstanceRef programStageInstance;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("recipients")
    private ProgramMessageRecipients recipients;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("storeCopy")
    private Boolean storeCopy;
    @JsonProperty("subject")
    private String subject;
    @JsonProperty("text")
    private String text;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__70 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 6350705207403201077L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProgramMessage() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ProgramMessage(ProgramMessage source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.deliveryChannels = source.deliveryChannels;
        this.displayName = source.displayName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.messageStatus = source.messageStatus;
        this.name = source.name;
        this.notificationTemplate = source.notificationTemplate;
        this.processedDate = source.processedDate;
        this.programInstance = source.programInstance;
        this.programStageInstance = source.programStageInstance;
        this.publicAccess = source.publicAccess;
        this.recipients = source.recipients;
        this.sharing = source.sharing;
        this.storeCopy = source.storeCopy;
        this.subject = source.subject;
        this.text = source.text;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param programInstance
     *     A UID reference to a ProgramInstance  
     *     (Java name `org.hisp.dhis.program.ProgramInstance`).
     * @param programStageInstance
     *     A UID reference to a ProgramStageInstance  
     *     (Java name `org.hisp.dhis.program.ProgramStageInstance`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public ProgramMessage(Access access, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__67 createdBy, List<DeliveryChannelsRefRef_> deliveryChannels, String displayName, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, LastUpdatedByRef__67 lastUpdatedBy, ProgramMessage.MessageStatusRef messageStatus, String name, String notificationTemplate, Date processedDate, ProgramInstanceRef programInstance, ProgramStageInstanceRef programStageInstance, String publicAccess, ProgramMessageRecipients recipients, Sharing sharing, Boolean storeCopy, String subject, String text, List<Translation> translations, UserRef__70 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.deliveryChannels = deliveryChannels;
        this.displayName = displayName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.messageStatus = messageStatus;
        this.name = name;
        this.notificationTemplate = notificationTemplate;
        this.processedDate = processedDate;
        this.programInstance = programInstance;
        this.programStageInstance = programStageInstance;
        this.publicAccess = publicAccess;
        this.recipients = recipients;
        this.sharing = sharing;
        this.storeCopy = storeCopy;
        this.subject = subject;
        this.text = text;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public ProgramMessage withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public ProgramMessage withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public ProgramMessage withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public ProgramMessage withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__67> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__67 createdBy) {
        this.createdBy = createdBy;
    }

    public ProgramMessage withCreatedBy(CreatedByRef__67 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("deliveryChannels")
    public Optional<List<DeliveryChannelsRefRef_>> getDeliveryChannels() {
        return Optional.ofNullable(deliveryChannels);
    }

    @JsonProperty("deliveryChannels")
    public void setDeliveryChannels(List<DeliveryChannelsRefRef_> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
    }

    public ProgramMessage withDeliveryChannels(List<DeliveryChannelsRefRef_> deliveryChannels) {
        this.deliveryChannels = deliveryChannels;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ProgramMessage withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public ProgramMessage withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public ProgramMessage withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public ProgramMessage withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public ProgramMessage withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public ProgramMessage withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public ProgramMessage withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__67> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__67 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public ProgramMessage withLastUpdatedBy(LastUpdatedByRef__67 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageStatus")
    public ProgramMessage.MessageStatusRef getMessageStatus() {
        return messageStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("messageStatus")
    public void setMessageStatus(ProgramMessage.MessageStatusRef messageStatus) {
        this.messageStatus = messageStatus;
    }

    public ProgramMessage withMessageStatus(ProgramMessage.MessageStatusRef messageStatus) {
        this.messageStatus = messageStatus;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public ProgramMessage withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("notificationTemplate")
    public Optional<String> getNotificationTemplate() {
        return Optional.ofNullable(notificationTemplate);
    }

    @JsonProperty("notificationTemplate")
    public void setNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public ProgramMessage withNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
        return this;
    }

    @JsonProperty("processedDate")
    public Optional<Date> getProcessedDate() {
        return Optional.ofNullable(processedDate);
    }

    @JsonProperty("processedDate")
    public void setProcessedDate(Date processedDate) {
        this.processedDate = processedDate;
    }

    public ProgramMessage withProcessedDate(Date processedDate) {
        this.processedDate = processedDate;
        return this;
    }

    /**
     * A UID reference to a ProgramInstance  
     * (Java name `org.hisp.dhis.program.ProgramInstance`)
     * 
     */
    @JsonProperty("programInstance")
    public Optional<ProgramInstanceRef> getProgramInstance() {
        return Optional.ofNullable(programInstance);
    }

    /**
     * A UID reference to a ProgramInstance  
     * (Java name `org.hisp.dhis.program.ProgramInstance`)
     * 
     */
    @JsonProperty("programInstance")
    public void setProgramInstance(ProgramInstanceRef programInstance) {
        this.programInstance = programInstance;
    }

    public ProgramMessage withProgramInstance(ProgramInstanceRef programInstance) {
        this.programInstance = programInstance;
        return this;
    }

    /**
     * A UID reference to a ProgramStageInstance  
     * (Java name `org.hisp.dhis.program.ProgramStageInstance`)
     * 
     */
    @JsonProperty("programStageInstance")
    public Optional<ProgramStageInstanceRef> getProgramStageInstance() {
        return Optional.ofNullable(programStageInstance);
    }

    /**
     * A UID reference to a ProgramStageInstance  
     * (Java name `org.hisp.dhis.program.ProgramStageInstance`)
     * 
     */
    @JsonProperty("programStageInstance")
    public void setProgramStageInstance(ProgramStageInstanceRef programStageInstance) {
        this.programStageInstance = programStageInstance;
    }

    public ProgramMessage withProgramStageInstance(ProgramStageInstanceRef programStageInstance) {
        this.programStageInstance = programStageInstance;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public ProgramMessage withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("recipients")
    public Optional<ProgramMessageRecipients> getRecipients() {
        return Optional.ofNullable(recipients);
    }

    @JsonProperty("recipients")
    public void setRecipients(ProgramMessageRecipients recipients) {
        this.recipients = recipients;
    }

    public ProgramMessage withRecipients(ProgramMessageRecipients recipients) {
        this.recipients = recipients;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public ProgramMessage withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("storeCopy")
    public Optional<Boolean> getStoreCopy() {
        return Optional.ofNullable(storeCopy);
    }

    @JsonProperty("storeCopy")
    public void setStoreCopy(Boolean storeCopy) {
        this.storeCopy = storeCopy;
    }

    public ProgramMessage withStoreCopy(Boolean storeCopy) {
        this.storeCopy = storeCopy;
        return this;
    }

    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    @JsonProperty("subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public ProgramMessage withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public ProgramMessage withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public ProgramMessage withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__70> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__70 user) {
        this.user = user;
    }

    public ProgramMessage withUser(UserRef__70 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public ProgramMessage withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public ProgramMessage withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ProgramMessage withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("createdBy".equals(name)) {
                            if (value instanceof CreatedByRef__67) {
                                setCreatedBy(((CreatedByRef__67) value));
                            } else {
                                throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__67\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("deliveryChannels".equals(name)) {
                                if (value instanceof List) {
                                    setDeliveryChannels(((List<DeliveryChannelsRefRef_> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"deliveryChannels\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.DeliveryChannelsRefRef_>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("displayName".equals(name)) {
                                    if (value instanceof String) {
                                        setDisplayName(((String) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("externalAccess".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setExternalAccess(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("favorite".equals(name)) {
                                            if (value instanceof Boolean) {
                                                setFavorite(((Boolean) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("favorites".equals(name)) {
                                                if (value instanceof List) {
                                                    setFavorites(((List<String> ) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("href".equals(name)) {
                                                    if (value instanceof String) {
                                                        setHref(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("id".equals(name)) {
                                                        if (value instanceof String) {
                                                            setId(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            if (value instanceof Date) {
                                                                setLastUpdated(((Date) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                if (value instanceof LastUpdatedByRef__67) {
                                                                    setLastUpdatedBy(((LastUpdatedByRef__67) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__67\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("messageStatus".equals(name)) {
                                                                    if (value instanceof ProgramMessage.MessageStatusRef) {
                                                                        setMessageStatus(((ProgramMessage.MessageStatusRef) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"messageStatus\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramMessage.MessageStatusRef\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("name".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("notificationTemplate".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setNotificationTemplate(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"notificationTemplate\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("processedDate".equals(name)) {
                                                                                if (value instanceof Date) {
                                                                                    setProcessedDate(((Date) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"processedDate\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("programInstance".equals(name)) {
                                                                                    if (value instanceof ProgramInstanceRef) {
                                                                                        setProgramInstance(((ProgramInstanceRef) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"programInstance\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramInstanceRef\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("programStageInstance".equals(name)) {
                                                                                        if (value instanceof ProgramStageInstanceRef) {
                                                                                            setProgramStageInstance(((ProgramStageInstanceRef) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"programStageInstance\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramStageInstanceRef\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setPublicAccess(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("recipients".equals(name)) {
                                                                                                if (value instanceof ProgramMessageRecipients) {
                                                                                                    setRecipients(((ProgramMessageRecipients) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"recipients\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramMessageRecipients\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    if (value instanceof Sharing) {
                                                                                                        setSharing(((Sharing) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("storeCopy".equals(name)) {
                                                                                                        if (value instanceof Boolean) {
                                                                                                            setStoreCopy(((Boolean) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"storeCopy\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("subject".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setSubject(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"subject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("text".equals(name)) {
                                                                                                                if (value instanceof String) {
                                                                                                                    setText(((String) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("translations".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setTranslations(((List<Translation> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("user".equals(name)) {
                                                                                                                        if (value instanceof UserRef__70) {
                                                                                                                            setUser(((UserRef__70) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__70\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                if (value instanceof List) {
                                                                                                                                    setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("createdBy".equals(name)) {
                            return getCreatedBy();
                        } else {
                            if ("deliveryChannels".equals(name)) {
                                return getDeliveryChannels();
                            } else {
                                if ("displayName".equals(name)) {
                                    return getDisplayName();
                                } else {
                                    if ("externalAccess".equals(name)) {
                                        return getExternalAccess();
                                    } else {
                                        if ("favorite".equals(name)) {
                                            return getFavorite();
                                        } else {
                                            if ("favorites".equals(name)) {
                                                return getFavorites();
                                            } else {
                                                if ("href".equals(name)) {
                                                    return getHref();
                                                } else {
                                                    if ("id".equals(name)) {
                                                        return getId();
                                                    } else {
                                                        if ("lastUpdated".equals(name)) {
                                                            return getLastUpdated();
                                                        } else {
                                                            if ("lastUpdatedBy".equals(name)) {
                                                                return getLastUpdatedBy();
                                                            } else {
                                                                if ("messageStatus".equals(name)) {
                                                                    return getMessageStatus();
                                                                } else {
                                                                    if ("name".equals(name)) {
                                                                        return getName();
                                                                    } else {
                                                                        if ("notificationTemplate".equals(name)) {
                                                                            return getNotificationTemplate();
                                                                        } else {
                                                                            if ("processedDate".equals(name)) {
                                                                                return getProcessedDate();
                                                                            } else {
                                                                                if ("programInstance".equals(name)) {
                                                                                    return getProgramInstance();
                                                                                } else {
                                                                                    if ("programStageInstance".equals(name)) {
                                                                                        return getProgramStageInstance();
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            return getPublicAccess();
                                                                                        } else {
                                                                                            if ("recipients".equals(name)) {
                                                                                                return getRecipients();
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    return getSharing();
                                                                                                } else {
                                                                                                    if ("storeCopy".equals(name)) {
                                                                                                        return getStoreCopy();
                                                                                                    } else {
                                                                                                        if ("subject".equals(name)) {
                                                                                                            return getSubject();
                                                                                                        } else {
                                                                                                            if ("text".equals(name)) {
                                                                                                                return getText();
                                                                                                            } else {
                                                                                                                if ("translations".equals(name)) {
                                                                                                                    return getTranslations();
                                                                                                                } else {
                                                                                                                    if ("user".equals(name)) {
                                                                                                                        return getUser();
                                                                                                                    } else {
                                                                                                                        if ("userAccesses".equals(name)) {
                                                                                                                            return getUserAccesses();
                                                                                                                        } else {
                                                                                                                            if ("userGroupAccesses".equals(name)) {
                                                                                                                                return getUserGroupAccesses();
                                                                                                                            } else {
                                                                                                                                return notFoundValue;
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ProgramMessage.NOT_FOUND_VALUE);
        if (ProgramMessage.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ProgramMessage with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ProgramMessage.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("deliveryChannels");
        sb.append('=');
        sb.append(((this.deliveryChannels == null)?"<null>":this.deliveryChannels));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("messageStatus");
        sb.append('=');
        sb.append(((this.messageStatus == null)?"<null>":this.messageStatus));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("notificationTemplate");
        sb.append('=');
        sb.append(((this.notificationTemplate == null)?"<null>":this.notificationTemplate));
        sb.append(',');
        sb.append("processedDate");
        sb.append('=');
        sb.append(((this.processedDate == null)?"<null>":this.processedDate));
        sb.append(',');
        sb.append("programInstance");
        sb.append('=');
        sb.append(((this.programInstance == null)?"<null>":this.programInstance));
        sb.append(',');
        sb.append("programStageInstance");
        sb.append('=');
        sb.append(((this.programStageInstance == null)?"<null>":this.programStageInstance));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("recipients");
        sb.append('=');
        sb.append(((this.recipients == null)?"<null>":this.recipients));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("storeCopy");
        sb.append('=');
        sb.append(((this.storeCopy == null)?"<null>":this.storeCopy));
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(((this.subject == null)?"<null>":this.subject));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.subject == null)? 0 :this.subject.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.processedDate == null)? 0 :this.processedDate.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.notificationTemplate == null)? 0 :this.notificationTemplate.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStageInstance == null)? 0 :this.programStageInstance.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.deliveryChannels == null)? 0 :this.deliveryChannels.hashCode()));
        result = ((result* 31)+((this.storeCopy == null)? 0 :this.storeCopy.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.messageStatus == null)? 0 :this.messageStatus.hashCode()));
        result = ((result* 31)+((this.programInstance == null)? 0 :this.programInstance.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.recipients == null)? 0 :this.recipients.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ProgramMessage) == false) {
            return false;
        }
        ProgramMessage rhs = ((ProgramMessage) other);
        return ((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.subject == rhs.subject)||((this.subject!= null)&&this.subject.equals(rhs.subject))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.processedDate == rhs.processedDate)||((this.processedDate!= null)&&this.processedDate.equals(rhs.processedDate))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.notificationTemplate == rhs.notificationTemplate)||((this.notificationTemplate!= null)&&this.notificationTemplate.equals(rhs.notificationTemplate))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStageInstance == rhs.programStageInstance)||((this.programStageInstance!= null)&&this.programStageInstance.equals(rhs.programStageInstance))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.deliveryChannels == rhs.deliveryChannels)||((this.deliveryChannels!= null)&&this.deliveryChannels.equals(rhs.deliveryChannels))))&&((this.storeCopy == rhs.storeCopy)||((this.storeCopy!= null)&&this.storeCopy.equals(rhs.storeCopy))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.messageStatus == rhs.messageStatus)||((this.messageStatus!= null)&&this.messageStatus.equals(rhs.messageStatus))))&&((this.programInstance == rhs.programInstance)||((this.programInstance!= null)&&this.programInstance.equals(rhs.programInstance))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.recipients == rhs.recipients)||((this.recipients!= null)&&this.recipients.equals(rhs.recipients))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum MessageStatusRef {

        SENT("SENT"),
        FAILED("FAILED"),
        SCHEDULED("SCHEDULED"),
        OUTBOUND("OUTBOUND");
        private final String value;
        private final static Map<String, ProgramMessage.MessageStatusRef> CONSTANTS = new HashMap<String, ProgramMessage.MessageStatusRef>();

        static {
            for (ProgramMessage.MessageStatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MessageStatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ProgramMessage.MessageStatusRef fromValue(String value) {
            ProgramMessage.MessageStatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
