
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "aggregationType",
    "allItems",
    "attributeValues",
    "code",
    "created",
    "createdBy",
    "dataDimension",
    "dataDimensionType",
    "description",
    "dimension",
    "dimensionItemKeywords",
    "displayDescription",
    "displayFormName",
    "displayName",
    "displayShortName",
    "externalAccess",
    "favorite",
    "favorites",
    "filter",
    "formName",
    "href",
    "id",
    "items",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "name",
    "optionGroups",
    "optionSet",
    "programStage",
    "publicAccess",
    "repetition",
    "sharing",
    "shortName",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "valueType"
})
@Generated("jsonschema2pojo")
public class OptionGroupSet implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    private OptionGroupSet.AggregationTypeRef aggregationType;
    @JsonProperty("allItems")
    private Boolean allItems;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__53 createdBy;
    @JsonProperty("dataDimension")
    private Boolean dataDimension;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionType")
    private OptionGroupSet.DataDimensionTypeRef dataDimensionType;
    @JsonProperty("description")
    private String description;
    @JsonProperty("dimension")
    private String dimension;
    @JsonProperty("dimensionItemKeywords")
    private DimensionItemKeywords dimensionItemKeywords;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("displayShortName")
    private String displayShortName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("filter")
    private String filter;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("items")
    private List<ItemsRefRef__4> items;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__53 lastUpdatedBy;
    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private LegendSetRef__21 legendSet;
    @JsonProperty("name")
    private String name;
    @JsonProperty("optionGroups")
    private List<OptionGroupsRefRef> optionGroups;
    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    @JsonPropertyDescription("A UID reference to a OptionSet  \n(Java name `org.hisp.dhis.option.OptionSet`)")
    private OptionSetRef__8 optionSet;
    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    @JsonPropertyDescription("A UID reference to a ProgramStage  \n(Java name `org.hisp.dhis.program.ProgramStage`)")
    private ProgramStageRef__7 programStage;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("repetition")
    private EventRepetition repetition;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("shortName")
    private String shortName;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__56 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    private OptionGroupSet.ValueTypeRef valueType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -944404846247184188L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OptionGroupSet() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public OptionGroupSet(OptionGroupSet source) {
        super();
        this.access = source.access;
        this.aggregationType = source.aggregationType;
        this.allItems = source.allItems;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataDimension = source.dataDimension;
        this.dataDimensionType = source.dataDimensionType;
        this.description = source.description;
        this.dimension = source.dimension;
        this.dimensionItemKeywords = source.dimensionItemKeywords;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.displayName = source.displayName;
        this.displayShortName = source.displayShortName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.filter = source.filter;
        this.formName = source.formName;
        this.href = source.href;
        this.id = source.id;
        this.items = source.items;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.name = source.name;
        this.optionGroups = source.optionGroups;
        this.optionSet = source.optionSet;
        this.programStage = source.programStage;
        this.publicAccess = source.publicAccess;
        this.repetition = source.repetition;
        this.sharing = source.sharing;
        this.shortName = source.shortName;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.valueType = source.valueType;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param programStage
     *     A UID reference to a ProgramStage  
     *     (Java name `org.hisp.dhis.program.ProgramStage`).
     * @param optionSet
     *     A UID reference to a OptionSet  
     *     (Java name `org.hisp.dhis.option.OptionSet`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param legendSet
     *     A UID reference to a LegendSet  
     *     (Java name `org.hisp.dhis.legend.LegendSet`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public OptionGroupSet(Access access, OptionGroupSet.AggregationTypeRef aggregationType, Boolean allItems, List<AttributeValue> attributeValues, String code, Date created, CreatedByRef__53 createdBy, Boolean dataDimension, OptionGroupSet.DataDimensionTypeRef dataDimensionType, String description, String dimension, DimensionItemKeywords dimensionItemKeywords, String displayDescription, String displayFormName, String displayName, String displayShortName, Boolean externalAccess, Boolean favorite, List<String> favorites, String filter, String formName, String href, String id, List<ItemsRefRef__4> items, Date lastUpdated, LastUpdatedByRef__53 lastUpdatedBy, LegendSetRef__21 legendSet, String name, List<OptionGroupsRefRef> optionGroups, OptionSetRef__8 optionSet, ProgramStageRef__7 programStage, String publicAccess, EventRepetition repetition, Sharing sharing, String shortName, List<Translation> translations, UserRef__56 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses, OptionGroupSet.ValueTypeRef valueType) {
        super();
        this.access = access;
        this.aggregationType = aggregationType;
        this.allItems = allItems;
        this.attributeValues = attributeValues;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dataDimension = dataDimension;
        this.dataDimensionType = dataDimensionType;
        this.description = description;
        this.dimension = dimension;
        this.dimensionItemKeywords = dimensionItemKeywords;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.displayName = displayName;
        this.displayShortName = displayShortName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.filter = filter;
        this.formName = formName;
        this.href = href;
        this.id = id;
        this.items = items;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.name = name;
        this.optionGroups = optionGroups;
        this.optionSet = optionSet;
        this.programStage = programStage;
        this.publicAccess = publicAccess;
        this.repetition = repetition;
        this.sharing = sharing;
        this.shortName = shortName;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.valueType = valueType;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public OptionGroupSet withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public OptionGroupSet.AggregationTypeRef getAggregationType() {
        return aggregationType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("aggregationType")
    public void setAggregationType(OptionGroupSet.AggregationTypeRef aggregationType) {
        this.aggregationType = aggregationType;
    }

    public OptionGroupSet withAggregationType(OptionGroupSet.AggregationTypeRef aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    @JsonProperty("allItems")
    public Optional<Boolean> getAllItems() {
        return Optional.ofNullable(allItems);
    }

    @JsonProperty("allItems")
    public void setAllItems(Boolean allItems) {
        this.allItems = allItems;
    }

    public OptionGroupSet withAllItems(Boolean allItems) {
        this.allItems = allItems;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public OptionGroupSet withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public OptionGroupSet withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public OptionGroupSet withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__53> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__53 createdBy) {
        this.createdBy = createdBy;
    }

    public OptionGroupSet withCreatedBy(CreatedByRef__53 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @JsonProperty("dataDimension")
    public Optional<Boolean> getDataDimension() {
        return Optional.ofNullable(dataDimension);
    }

    @JsonProperty("dataDimension")
    public void setDataDimension(Boolean dataDimension) {
        this.dataDimension = dataDimension;
    }

    public OptionGroupSet withDataDimension(Boolean dataDimension) {
        this.dataDimension = dataDimension;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionType")
    public OptionGroupSet.DataDimensionTypeRef getDataDimensionType() {
        return dataDimensionType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("dataDimensionType")
    public void setDataDimensionType(OptionGroupSet.DataDimensionTypeRef dataDimensionType) {
        this.dataDimensionType = dataDimensionType;
    }

    public OptionGroupSet withDataDimensionType(OptionGroupSet.DataDimensionTypeRef dataDimensionType) {
        this.dataDimensionType = dataDimensionType;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public OptionGroupSet withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("dimension")
    public Optional<String> getDimension() {
        return Optional.ofNullable(dimension);
    }

    @JsonProperty("dimension")
    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public OptionGroupSet withDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @JsonProperty("dimensionItemKeywords")
    public Optional<DimensionItemKeywords> getDimensionItemKeywords() {
        return Optional.ofNullable(dimensionItemKeywords);
    }

    @JsonProperty("dimensionItemKeywords")
    public void setDimensionItemKeywords(DimensionItemKeywords dimensionItemKeywords) {
        this.dimensionItemKeywords = dimensionItemKeywords;
    }

    public OptionGroupSet withDimensionItemKeywords(DimensionItemKeywords dimensionItemKeywords) {
        this.dimensionItemKeywords = dimensionItemKeywords;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public OptionGroupSet withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public OptionGroupSet withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public OptionGroupSet withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("displayShortName")
    public Optional<String> getDisplayShortName() {
        return Optional.ofNullable(displayShortName);
    }

    @JsonProperty("displayShortName")
    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public OptionGroupSet withDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public OptionGroupSet withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public OptionGroupSet withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public OptionGroupSet withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(filter);
    }

    @JsonProperty("filter")
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public OptionGroupSet withFilter(String filter) {
        this.filter = filter;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public OptionGroupSet withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public OptionGroupSet withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public OptionGroupSet withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("items")
    public Optional<List<ItemsRefRef__4>> getItems() {
        return Optional.ofNullable(items);
    }

    @JsonProperty("items")
    public void setItems(List<ItemsRefRef__4> items) {
        this.items = items;
    }

    public OptionGroupSet withItems(List<ItemsRefRef__4> items) {
        this.items = items;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public OptionGroupSet withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__53> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__53 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public OptionGroupSet withLastUpdatedBy(LastUpdatedByRef__53 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public Optional<LegendSetRef__21> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(LegendSetRef__21 legendSet) {
        this.legendSet = legendSet;
    }

    public OptionGroupSet withLegendSet(LegendSetRef__21 legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public OptionGroupSet withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("optionGroups")
    public Optional<List<OptionGroupsRefRef>> getOptionGroups() {
        return Optional.ofNullable(optionGroups);
    }

    @JsonProperty("optionGroups")
    public void setOptionGroups(List<OptionGroupsRefRef> optionGroups) {
        this.optionGroups = optionGroups;
    }

    public OptionGroupSet withOptionGroups(List<OptionGroupsRefRef> optionGroups) {
        this.optionGroups = optionGroups;
        return this;
    }

    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    public Optional<OptionSetRef__8> getOptionSet() {
        return Optional.ofNullable(optionSet);
    }

    /**
     * A UID reference to a OptionSet  
     * (Java name `org.hisp.dhis.option.OptionSet`)
     * 
     */
    @JsonProperty("optionSet")
    public void setOptionSet(OptionSetRef__8 optionSet) {
        this.optionSet = optionSet;
    }

    public OptionGroupSet withOptionSet(OptionSetRef__8 optionSet) {
        this.optionSet = optionSet;
        return this;
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public Optional<ProgramStageRef__7> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    /**
     * A UID reference to a ProgramStage  
     * (Java name `org.hisp.dhis.program.ProgramStage`)
     * 
     */
    @JsonProperty("programStage")
    public void setProgramStage(ProgramStageRef__7 programStage) {
        this.programStage = programStage;
    }

    public OptionGroupSet withProgramStage(ProgramStageRef__7 programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public OptionGroupSet withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("repetition")
    public Optional<EventRepetition> getRepetition() {
        return Optional.ofNullable(repetition);
    }

    @JsonProperty("repetition")
    public void setRepetition(EventRepetition repetition) {
        this.repetition = repetition;
    }

    public OptionGroupSet withRepetition(EventRepetition repetition) {
        this.repetition = repetition;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public OptionGroupSet withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("shortName")
    public Optional<String> getShortName() {
        return Optional.ofNullable(shortName);
    }

    @JsonProperty("shortName")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public OptionGroupSet withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public OptionGroupSet withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__56> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__56 user) {
        this.user = user;
    }

    public OptionGroupSet withUser(UserRef__56 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public OptionGroupSet withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public OptionGroupSet withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public OptionGroupSet.ValueTypeRef getValueType() {
        return valueType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("valueType")
    public void setValueType(OptionGroupSet.ValueTypeRef valueType) {
        this.valueType = valueType;
    }

    public OptionGroupSet withValueType(OptionGroupSet.ValueTypeRef valueType) {
        this.valueType = valueType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OptionGroupSet withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("aggregationType".equals(name)) {
                if (value instanceof OptionGroupSet.AggregationTypeRef) {
                    setAggregationType(((OptionGroupSet.AggregationTypeRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"aggregationType\" is of type \"org.hisp.dhis.api.model.v40_2_2.OptionGroupSet.AggregationTypeRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("allItems".equals(name)) {
                    if (value instanceof Boolean) {
                        setAllItems(((Boolean) value));
                    } else {
                        throw new IllegalArgumentException(("property \"allItems\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("attributeValues".equals(name)) {
                        if (value instanceof List) {
                            setAttributeValues(((List<AttributeValue> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("code".equals(name)) {
                            if (value instanceof String) {
                                setCode(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("created".equals(name)) {
                                if (value instanceof Date) {
                                    setCreated(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdBy".equals(name)) {
                                    if (value instanceof CreatedByRef__53) {
                                        setCreatedBy(((CreatedByRef__53) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__53\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("dataDimension".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setDataDimension(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"dataDimension\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("dataDimensionType".equals(name)) {
                                            if (value instanceof OptionGroupSet.DataDimensionTypeRef) {
                                                setDataDimensionType(((OptionGroupSet.DataDimensionTypeRef) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"dataDimensionType\" is of type \"org.hisp.dhis.api.model.v40_2_2.OptionGroupSet.DataDimensionTypeRef\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("description".equals(name)) {
                                                if (value instanceof String) {
                                                    setDescription(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("dimension".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDimension(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"dimension\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("dimensionItemKeywords".equals(name)) {
                                                        if (value instanceof DimensionItemKeywords) {
                                                            setDimensionItemKeywords(((DimensionItemKeywords) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"dimensionItemKeywords\" is of type \"org.hisp.dhis.api.model.v40_2_2.DimensionItemKeywords\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("displayDescription".equals(name)) {
                                                            if (value instanceof String) {
                                                                setDisplayDescription(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("displayFormName".equals(name)) {
                                                                if (value instanceof String) {
                                                                    setDisplayFormName(((String) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("displayName".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setDisplayName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("displayShortName".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setDisplayShortName(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"displayShortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("externalAccess".equals(name)) {
                                                                            if (value instanceof Boolean) {
                                                                                setExternalAccess(((Boolean) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("favorite".equals(name)) {
                                                                                if (value instanceof Boolean) {
                                                                                    setFavorite(((Boolean) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("favorites".equals(name)) {
                                                                                    if (value instanceof List) {
                                                                                        setFavorites(((List<String> ) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("filter".equals(name)) {
                                                                                        if (value instanceof String) {
                                                                                            setFilter(((String) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"filter\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("formName".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setFormName(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("href".equals(name)) {
                                                                                                if (value instanceof String) {
                                                                                                    setHref(((String) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("id".equals(name)) {
                                                                                                    if (value instanceof String) {
                                                                                                        setId(((String) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("items".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setItems(((List<ItemsRefRef__4> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"items\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.ItemsRefRef__4>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("lastUpdated".equals(name)) {
                                                                                                            if (value instanceof Date) {
                                                                                                                setLastUpdated(((Date) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                                                if (value instanceof LastUpdatedByRef__53) {
                                                                                                                    setLastUpdatedBy(((LastUpdatedByRef__53) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__53\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("legendSet".equals(name)) {
                                                                                                                    if (value instanceof LegendSetRef__21) {
                                                                                                                        setLegendSet(((LegendSetRef__21) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.LegendSetRef__21\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("name".equals(name)) {
                                                                                                                        if (value instanceof String) {
                                                                                                                            setName(((String) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("optionGroups".equals(name)) {
                                                                                                                            if (value instanceof List) {
                                                                                                                                setOptionGroups(((List<OptionGroupsRefRef> ) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"optionGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.OptionGroupsRefRef>\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("optionSet".equals(name)) {
                                                                                                                                if (value instanceof OptionSetRef__8) {
                                                                                                                                    setOptionSet(((OptionSetRef__8) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"optionSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.OptionSetRef__8\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("programStage".equals(name)) {
                                                                                                                                    if (value instanceof ProgramStageRef__7) {
                                                                                                                                        setProgramStage(((ProgramStageRef__7) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"programStage\" is of type \"org.hisp.dhis.api.model.v40_2_2.ProgramStageRef__7\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                                                        if (value instanceof String) {
                                                                                                                                            setPublicAccess(((String) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("repetition".equals(name)) {
                                                                                                                                            if (value instanceof EventRepetition) {
                                                                                                                                                setRepetition(((EventRepetition) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"repetition\" is of type \"org.hisp.dhis.api.model.v40_2_2.EventRepetition\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            if ("sharing".equals(name)) {
                                                                                                                                                if (value instanceof Sharing) {
                                                                                                                                                    setSharing(((Sharing) value));
                                                                                                                                                } else {
                                                                                                                                                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                                                }
                                                                                                                                                return true;
                                                                                                                                            } else {
                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                    if (value instanceof String) {
                                                                                                                                                        setShortName(((String) value));
                                                                                                                                                    } else {
                                                                                                                                                        throw new IllegalArgumentException(("property \"shortName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                                                    }
                                                                                                                                                    return true;
                                                                                                                                                } else {
                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                        if (value instanceof List) {
                                                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                                                        } else {
                                                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                                                        }
                                                                                                                                                        return true;
                                                                                                                                                    } else {
                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                            if (value instanceof UserRef__56) {
                                                                                                                                                                setUser(((UserRef__56) value));
                                                                                                                                                            } else {
                                                                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__56\", but got "+ value.getClass().toString()));
                                                                                                                                                            }
                                                                                                                                                            return true;
                                                                                                                                                        } else {
                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                if (value instanceof List) {
                                                                                                                                                                    setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                                                                } else {
                                                                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                }
                                                                                                                                                                return true;
                                                                                                                                                            } else {
                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                    if (value instanceof List) {
                                                                                                                                                                        setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                                                    } else {
                                                                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                                                    }
                                                                                                                                                                    return true;
                                                                                                                                                                } else {
                                                                                                                                                                    if ("valueType".equals(name)) {
                                                                                                                                                                        if (value instanceof OptionGroupSet.ValueTypeRef) {
                                                                                                                                                                            setValueType(((OptionGroupSet.ValueTypeRef) value));
                                                                                                                                                                        } else {
                                                                                                                                                                            throw new IllegalArgumentException(("property \"valueType\" is of type \"org.hisp.dhis.api.model.v40_2_2.OptionGroupSet.ValueTypeRef\", but got "+ value.getClass().toString()));
                                                                                                                                                                        }
                                                                                                                                                                        return true;
                                                                                                                                                                    } else {
                                                                                                                                                                        return false;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("aggregationType".equals(name)) {
                return getAggregationType();
            } else {
                if ("allItems".equals(name)) {
                    return getAllItems();
                } else {
                    if ("attributeValues".equals(name)) {
                        return getAttributeValues();
                    } else {
                        if ("code".equals(name)) {
                            return getCode();
                        } else {
                            if ("created".equals(name)) {
                                return getCreated();
                            } else {
                                if ("createdBy".equals(name)) {
                                    return getCreatedBy();
                                } else {
                                    if ("dataDimension".equals(name)) {
                                        return getDataDimension();
                                    } else {
                                        if ("dataDimensionType".equals(name)) {
                                            return getDataDimensionType();
                                        } else {
                                            if ("description".equals(name)) {
                                                return getDescription();
                                            } else {
                                                if ("dimension".equals(name)) {
                                                    return getDimension();
                                                } else {
                                                    if ("dimensionItemKeywords".equals(name)) {
                                                        return getDimensionItemKeywords();
                                                    } else {
                                                        if ("displayDescription".equals(name)) {
                                                            return getDisplayDescription();
                                                        } else {
                                                            if ("displayFormName".equals(name)) {
                                                                return getDisplayFormName();
                                                            } else {
                                                                if ("displayName".equals(name)) {
                                                                    return getDisplayName();
                                                                } else {
                                                                    if ("displayShortName".equals(name)) {
                                                                        return getDisplayShortName();
                                                                    } else {
                                                                        if ("externalAccess".equals(name)) {
                                                                            return getExternalAccess();
                                                                        } else {
                                                                            if ("favorite".equals(name)) {
                                                                                return getFavorite();
                                                                            } else {
                                                                                if ("favorites".equals(name)) {
                                                                                    return getFavorites();
                                                                                } else {
                                                                                    if ("filter".equals(name)) {
                                                                                        return getFilter();
                                                                                    } else {
                                                                                        if ("formName".equals(name)) {
                                                                                            return getFormName();
                                                                                        } else {
                                                                                            if ("href".equals(name)) {
                                                                                                return getHref();
                                                                                            } else {
                                                                                                if ("id".equals(name)) {
                                                                                                    return getId();
                                                                                                } else {
                                                                                                    if ("items".equals(name)) {
                                                                                                        return getItems();
                                                                                                    } else {
                                                                                                        if ("lastUpdated".equals(name)) {
                                                                                                            return getLastUpdated();
                                                                                                        } else {
                                                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                                                return getLastUpdatedBy();
                                                                                                            } else {
                                                                                                                if ("legendSet".equals(name)) {
                                                                                                                    return getLegendSet();
                                                                                                                } else {
                                                                                                                    if ("name".equals(name)) {
                                                                                                                        return getName();
                                                                                                                    } else {
                                                                                                                        if ("optionGroups".equals(name)) {
                                                                                                                            return getOptionGroups();
                                                                                                                        } else {
                                                                                                                            if ("optionSet".equals(name)) {
                                                                                                                                return getOptionSet();
                                                                                                                            } else {
                                                                                                                                if ("programStage".equals(name)) {
                                                                                                                                    return getProgramStage();
                                                                                                                                } else {
                                                                                                                                    if ("publicAccess".equals(name)) {
                                                                                                                                        return getPublicAccess();
                                                                                                                                    } else {
                                                                                                                                        if ("repetition".equals(name)) {
                                                                                                                                            return getRepetition();
                                                                                                                                        } else {
                                                                                                                                            if ("sharing".equals(name)) {
                                                                                                                                                return getSharing();
                                                                                                                                            } else {
                                                                                                                                                if ("shortName".equals(name)) {
                                                                                                                                                    return getShortName();
                                                                                                                                                } else {
                                                                                                                                                    if ("translations".equals(name)) {
                                                                                                                                                        return getTranslations();
                                                                                                                                                    } else {
                                                                                                                                                        if ("user".equals(name)) {
                                                                                                                                                            return getUser();
                                                                                                                                                        } else {
                                                                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                                                                return getUserAccesses();
                                                                                                                                                            } else {
                                                                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                                                                    return getUserGroupAccesses();
                                                                                                                                                                } else {
                                                                                                                                                                    if ("valueType".equals(name)) {
                                                                                                                                                                        return getValueType();
                                                                                                                                                                    } else {
                                                                                                                                                                        return notFoundValue;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, OptionGroupSet.NOT_FOUND_VALUE);
        if (OptionGroupSet.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public OptionGroupSet with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OptionGroupSet.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("aggregationType");
        sb.append('=');
        sb.append(((this.aggregationType == null)?"<null>":this.aggregationType));
        sb.append(',');
        sb.append("allItems");
        sb.append('=');
        sb.append(((this.allItems == null)?"<null>":this.allItems));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataDimension");
        sb.append('=');
        sb.append(((this.dataDimension == null)?"<null>":this.dataDimension));
        sb.append(',');
        sb.append("dataDimensionType");
        sb.append('=');
        sb.append(((this.dataDimensionType == null)?"<null>":this.dataDimensionType));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("dimension");
        sb.append('=');
        sb.append(((this.dimension == null)?"<null>":this.dimension));
        sb.append(',');
        sb.append("dimensionItemKeywords");
        sb.append('=');
        sb.append(((this.dimensionItemKeywords == null)?"<null>":this.dimensionItemKeywords));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("displayShortName");
        sb.append('=');
        sb.append(((this.displayShortName == null)?"<null>":this.displayShortName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("filter");
        sb.append('=');
        sb.append(((this.filter == null)?"<null>":this.filter));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("items");
        sb.append('=');
        sb.append(((this.items == null)?"<null>":this.items));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("optionGroups");
        sb.append('=');
        sb.append(((this.optionGroups == null)?"<null>":this.optionGroups));
        sb.append(',');
        sb.append("optionSet");
        sb.append('=');
        sb.append(((this.optionSet == null)?"<null>":this.optionSet));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("repetition");
        sb.append('=');
        sb.append(((this.repetition == null)?"<null>":this.repetition));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(((this.shortName == null)?"<null>":this.shortName));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("valueType");
        sb.append('=');
        sb.append(((this.valueType == null)?"<null>":this.valueType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataDimensionType == null)? 0 :this.dataDimensionType.hashCode()));
        result = ((result* 31)+((this.dimensionItemKeywords == null)? 0 :this.dimensionItemKeywords.hashCode()));
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.aggregationType == null)? 0 :this.aggregationType.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.optionGroups == null)? 0 :this.optionGroups.hashCode()));
        result = ((result* 31)+((this.repetition == null)? 0 :this.repetition.hashCode()));
        result = ((result* 31)+((this.displayShortName == null)? 0 :this.displayShortName.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.optionSet == null)? 0 :this.optionSet.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.valueType == null)? 0 :this.valueType.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.dimension == null)? 0 :this.dimension.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.allItems == null)? 0 :this.allItems.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.filter == null)? 0 :this.filter.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataDimension == null)? 0 :this.dataDimension.hashCode()));
        result = ((result* 31)+((this.shortName == null)? 0 :this.shortName.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.items == null)? 0 :this.items.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof OptionGroupSet) == false) {
            return false;
        }
        OptionGroupSet rhs = ((OptionGroupSet) other);
        return ((((((((((((((((((((((((((((((((((((((((((this.dataDimensionType == rhs.dataDimensionType)||((this.dataDimensionType!= null)&&this.dataDimensionType.equals(rhs.dataDimensionType)))&&((this.dimensionItemKeywords == rhs.dimensionItemKeywords)||((this.dimensionItemKeywords!= null)&&this.dimensionItemKeywords.equals(rhs.dimensionItemKeywords))))&&((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites))))&&((this.aggregationType == rhs.aggregationType)||((this.aggregationType!= null)&&this.aggregationType.equals(rhs.aggregationType))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.optionGroups == rhs.optionGroups)||((this.optionGroups!= null)&&this.optionGroups.equals(rhs.optionGroups))))&&((this.repetition == rhs.repetition)||((this.repetition!= null)&&this.repetition.equals(rhs.repetition))))&&((this.displayShortName == rhs.displayShortName)||((this.displayShortName!= null)&&this.displayShortName.equals(rhs.displayShortName))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.optionSet == rhs.optionSet)||((this.optionSet!= null)&&this.optionSet.equals(rhs.optionSet))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.valueType == rhs.valueType)||((this.valueType!= null)&&this.valueType.equals(rhs.valueType))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.dimension == rhs.dimension)||((this.dimension!= null)&&this.dimension.equals(rhs.dimension))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.allItems == rhs.allItems)||((this.allItems!= null)&&this.allItems.equals(rhs.allItems))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.filter == rhs.filter)||((this.filter!= null)&&this.filter.equals(rhs.filter))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataDimension == rhs.dataDimension)||((this.dataDimension!= null)&&this.dataDimension.equals(rhs.dataDimension))))&&((this.shortName == rhs.shortName)||((this.shortName!= null)&&this.shortName.equals(rhs.shortName))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.items == rhs.items)||((this.items!= null)&&this.items.equals(rhs.items))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum AggregationTypeRef {

        SUM("SUM"),
        AVERAGE("AVERAGE"),
        AVERAGE_SUM_ORG_UNIT("AVERAGE_SUM_ORG_UNIT"),
        LAST("LAST"),
        LAST_AVERAGE_ORG_UNIT("LAST_AVERAGE_ORG_UNIT"),
        LAST_LAST_ORG_UNIT("LAST_LAST_ORG_UNIT"),
        LAST_IN_PERIOD("LAST_IN_PERIOD"),
        LAST_IN_PERIOD_AVERAGE_ORG_UNIT("LAST_IN_PERIOD_AVERAGE_ORG_UNIT"),
        FIRST("FIRST"),
        FIRST_AVERAGE_ORG_UNIT("FIRST_AVERAGE_ORG_UNIT"),
        FIRST_FIRST_ORG_UNIT("FIRST_FIRST_ORG_UNIT"),
        COUNT("COUNT"),
        STDDEV("STDDEV"),
        VARIANCE("VARIANCE"),
        MIN("MIN"),
        MAX("MAX"),
        MIN_SUM_ORG_UNIT("MIN_SUM_ORG_UNIT"),
        MAX_SUM_ORG_UNIT("MAX_SUM_ORG_UNIT"),
        NONE("NONE"),
        CUSTOM("CUSTOM"),
        DEFAULT("DEFAULT");
        private final String value;
        private final static Map<String, OptionGroupSet.AggregationTypeRef> CONSTANTS = new HashMap<String, OptionGroupSet.AggregationTypeRef>();

        static {
            for (OptionGroupSet.AggregationTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AggregationTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OptionGroupSet.AggregationTypeRef fromValue(String value) {
            OptionGroupSet.AggregationTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum DataDimensionTypeRef {

        DISAGGREGATION("DISAGGREGATION"),
        ATTRIBUTE("ATTRIBUTE");
        private final String value;
        private final static Map<String, OptionGroupSet.DataDimensionTypeRef> CONSTANTS = new HashMap<String, OptionGroupSet.DataDimensionTypeRef>();

        static {
            for (OptionGroupSet.DataDimensionTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        DataDimensionTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OptionGroupSet.DataDimensionTypeRef fromValue(String value) {
            OptionGroupSet.DataDimensionTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ValueTypeRef {

        TEXT("TEXT"),
        LONG_TEXT("LONG_TEXT"),
        MULTI_TEXT("MULTI_TEXT"),
        LETTER("LETTER"),
        PHONE_NUMBER("PHONE_NUMBER"),
        EMAIL("EMAIL"),
        BOOLEAN("BOOLEAN"),
        TRUE_ONLY("TRUE_ONLY"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        TIME("TIME"),
        NUMBER("NUMBER"),
        UNIT_INTERVAL("UNIT_INTERVAL"),
        PERCENTAGE("PERCENTAGE"),
        INTEGER("INTEGER"),
        INTEGER_POSITIVE("INTEGER_POSITIVE"),
        INTEGER_NEGATIVE("INTEGER_NEGATIVE"),
        INTEGER_ZERO_OR_POSITIVE("INTEGER_ZERO_OR_POSITIVE"),
        TRACKER_ASSOCIATE("TRACKER_ASSOCIATE"),
        USERNAME("USERNAME"),
        COORDINATE("COORDINATE"),
        ORGANISATION_UNIT("ORGANISATION_UNIT"),
        REFERENCE("REFERENCE"),
        AGE("AGE"),
        URL("URL"),
        FILE_RESOURCE("FILE_RESOURCE"),
        IMAGE("IMAGE"),
        GEOJSON("GEOJSON");
        private final String value;
        private final static Map<String, OptionGroupSet.ValueTypeRef> CONSTANTS = new HashMap<String, OptionGroupSet.ValueTypeRef>();

        static {
            for (OptionGroupSet.ValueTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ValueTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OptionGroupSet.ValueTypeRef fromValue(String value) {
            OptionGroupSet.ValueTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
