
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "categoryOptionCombo",
    "dataElement",
    "maxValue",
    "minValue",
    "orgUnit"
})
@Generated("jsonschema2pojo")
public class MinMaxValueDto implements Serializable
{

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String categoryOptionCombo;
    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID for an DataElement object  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private String dataElement;
    @JsonProperty("maxValue")
    private Integer maxValue;
    @JsonProperty("minValue")
    private Integer minValue;
    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    @JsonPropertyDescription("A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String orgUnit;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -7455546376198992077L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MinMaxValueDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MinMaxValueDto(MinMaxValueDto source) {
        super();
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.dataElement = source.dataElement;
        this.maxValue = source.maxValue;
        this.minValue = source.minValue;
        this.orgUnit = source.orgUnit;
    }

    /**
     * 
     * @param orgUnit
     *     A UID for an OrganisationUnit object  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`).
     * @param categoryOptionCombo
     *     A UID for an CategoryOptionCombo object  
     *     (Java name `org.hisp.dhis.category.CategoryOptionCombo`).
     * @param dataElement
     *     A UID for an DataElement object  
     *     (Java name `org.hisp.dhis.dataelement.DataElement`).
     */
    public MinMaxValueDto(String categoryOptionCombo, String dataElement, Integer maxValue, Integer minValue, String orgUnit) {
        super();
        this.categoryOptionCombo = categoryOptionCombo;
        this.dataElement = dataElement;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.orgUnit = orgUnit;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public MinMaxValueDto withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public MinMaxValueDto withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("maxValue")
    public Optional<Integer> getMaxValue() {
        return Optional.ofNullable(maxValue);
    }

    @JsonProperty("maxValue")
    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public MinMaxValueDto withMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @JsonProperty("minValue")
    public Optional<Integer> getMinValue() {
        return Optional.ofNullable(minValue);
    }

    @JsonProperty("minValue")
    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public MinMaxValueDto withMinValue(Integer minValue) {
        this.minValue = minValue;
        return this;
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public MinMaxValueDto withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MinMaxValueDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("categoryOptionCombo".equals(name)) {
            if (value instanceof String) {
                setCategoryOptionCombo(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataElement".equals(name)) {
                if (value instanceof String) {
                    setDataElement(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("maxValue".equals(name)) {
                    if (value instanceof Integer) {
                        setMaxValue(((Integer) value));
                    } else {
                        throw new IllegalArgumentException(("property \"maxValue\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("minValue".equals(name)) {
                        if (value instanceof Integer) {
                            setMinValue(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"minValue\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("orgUnit".equals(name)) {
                            if (value instanceof String) {
                                setOrgUnit(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("categoryOptionCombo".equals(name)) {
            return getCategoryOptionCombo();
        } else {
            if ("dataElement".equals(name)) {
                return getDataElement();
            } else {
                if ("maxValue".equals(name)) {
                    return getMaxValue();
                } else {
                    if ("minValue".equals(name)) {
                        return getMinValue();
                    } else {
                        if ("orgUnit".equals(name)) {
                            return getOrgUnit();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MinMaxValueDto.NOT_FOUND_VALUE);
        if (MinMaxValueDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MinMaxValueDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MinMaxValueDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("maxValue");
        sb.append('=');
        sb.append(((this.maxValue == null)?"<null>":this.maxValue));
        sb.append(',');
        sb.append("minValue");
        sb.append('=');
        sb.append(((this.minValue == null)?"<null>":this.minValue));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.minValue == null)? 0 :this.minValue.hashCode()));
        result = ((result* 31)+((this.maxValue == null)? 0 :this.maxValue.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MinMaxValueDto) == false) {
            return false;
        }
        MinMaxValueDto rhs = ((MinMaxValueDto) other);
        return (((((((this.minValue == rhs.minValue)||((this.minValue!= null)&&this.minValue.equals(rhs.minValue)))&&((this.maxValue == rhs.maxValue)||((this.maxValue!= null)&&this.maxValue.equals(rhs.maxValue))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
