
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attachments",
    "organisationUnits",
    "subject",
    "text",
    "userGroups",
    "users"
})
@Generated("jsonschema2pojo")
public class MessageConversationInfo implements Serializable
{

    @JsonProperty("attachments")
    private List<AttachmentsRefRef> attachments;
    @JsonProperty("organisationUnits")
    private List<OrganisationUnitsRefRef__6> organisationUnits;
    @JsonProperty("subject")
    private String subject;
    @JsonProperty("text")
    private String text;
    @JsonProperty("userGroups")
    private List<UserGroupsRefRef__1> userGroups;
    @JsonProperty("users")
    private List<UsersRefRef__2> users;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -2078305915539815703L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MessageConversationInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public MessageConversationInfo(MessageConversationInfo source) {
        super();
        this.attachments = source.attachments;
        this.organisationUnits = source.organisationUnits;
        this.subject = source.subject;
        this.text = source.text;
        this.userGroups = source.userGroups;
        this.users = source.users;
    }

    public MessageConversationInfo(List<AttachmentsRefRef> attachments, List<OrganisationUnitsRefRef__6> organisationUnits, String subject, String text, List<UserGroupsRefRef__1> userGroups, List<UsersRefRef__2> users) {
        super();
        this.attachments = attachments;
        this.organisationUnits = organisationUnits;
        this.subject = subject;
        this.text = text;
        this.userGroups = userGroups;
        this.users = users;
    }

    @JsonProperty("attachments")
    public Optional<List<AttachmentsRefRef>> getAttachments() {
        return Optional.ofNullable(attachments);
    }

    @JsonProperty("attachments")
    public void setAttachments(List<AttachmentsRefRef> attachments) {
        this.attachments = attachments;
    }

    public MessageConversationInfo withAttachments(List<AttachmentsRefRef> attachments) {
        this.attachments = attachments;
        return this;
    }

    @JsonProperty("organisationUnits")
    public Optional<List<OrganisationUnitsRefRef__6>> getOrganisationUnits() {
        return Optional.ofNullable(organisationUnits);
    }

    @JsonProperty("organisationUnits")
    public void setOrganisationUnits(List<OrganisationUnitsRefRef__6> organisationUnits) {
        this.organisationUnits = organisationUnits;
    }

    public MessageConversationInfo withOrganisationUnits(List<OrganisationUnitsRefRef__6> organisationUnits) {
        this.organisationUnits = organisationUnits;
        return this;
    }

    @JsonProperty("subject")
    public Optional<String> getSubject() {
        return Optional.ofNullable(subject);
    }

    @JsonProperty("subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MessageConversationInfo withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public MessageConversationInfo withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("userGroups")
    public Optional<List<UserGroupsRefRef__1>> getUserGroups() {
        return Optional.ofNullable(userGroups);
    }

    @JsonProperty("userGroups")
    public void setUserGroups(List<UserGroupsRefRef__1> userGroups) {
        this.userGroups = userGroups;
    }

    public MessageConversationInfo withUserGroups(List<UserGroupsRefRef__1> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    @JsonProperty("users")
    public Optional<List<UsersRefRef__2>> getUsers() {
        return Optional.ofNullable(users);
    }

    @JsonProperty("users")
    public void setUsers(List<UsersRefRef__2> users) {
        this.users = users;
    }

    public MessageConversationInfo withUsers(List<UsersRefRef__2> users) {
        this.users = users;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public MessageConversationInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attachments".equals(name)) {
            if (value instanceof List) {
                setAttachments(((List<AttachmentsRefRef> ) value));
            } else {
                throw new IllegalArgumentException(("property \"attachments\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttachmentsRefRef>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("organisationUnits".equals(name)) {
                if (value instanceof List) {
                    setOrganisationUnits(((List<OrganisationUnitsRefRef__6> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"organisationUnits\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.OrganisationUnitsRefRef__6>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("subject".equals(name)) {
                    if (value instanceof String) {
                        setSubject(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"subject\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("text".equals(name)) {
                        if (value instanceof String) {
                            setText(((String) value));
                        } else {
                            throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("userGroups".equals(name)) {
                            if (value instanceof List) {
                                setUserGroups(((List<UserGroupsRefRef__1> ) value));
                            } else {
                                throw new IllegalArgumentException(("property \"userGroups\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.UserGroupsRefRef__1>\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("users".equals(name)) {
                                if (value instanceof List) {
                                    setUsers(((List<UsersRefRef__2> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"users\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.UsersRefRef__2>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attachments".equals(name)) {
            return getAttachments();
        } else {
            if ("organisationUnits".equals(name)) {
                return getOrganisationUnits();
            } else {
                if ("subject".equals(name)) {
                    return getSubject();
                } else {
                    if ("text".equals(name)) {
                        return getText();
                    } else {
                        if ("userGroups".equals(name)) {
                            return getUserGroups();
                        } else {
                            if ("users".equals(name)) {
                                return getUsers();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, MessageConversationInfo.NOT_FOUND_VALUE);
        if (MessageConversationInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public MessageConversationInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageConversationInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attachments");
        sb.append('=');
        sb.append(((this.attachments == null)?"<null>":this.attachments));
        sb.append(',');
        sb.append("organisationUnits");
        sb.append('=');
        sb.append(((this.organisationUnits == null)?"<null>":this.organisationUnits));
        sb.append(',');
        sb.append("subject");
        sb.append('=');
        sb.append(((this.subject == null)?"<null>":this.subject));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("userGroups");
        sb.append('=');
        sb.append(((this.userGroups == null)?"<null>":this.userGroups));
        sb.append(',');
        sb.append("users");
        sb.append('=');
        sb.append(((this.users == null)?"<null>":this.users));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.userGroups == null)? 0 :this.userGroups.hashCode()));
        result = ((result* 31)+((this.attachments == null)? 0 :this.attachments.hashCode()));
        result = ((result* 31)+((this.subject == null)? 0 :this.subject.hashCode()));
        result = ((result* 31)+((this.organisationUnits == null)? 0 :this.organisationUnits.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.users == null)? 0 :this.users.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof MessageConversationInfo) == false) {
            return false;
        }
        MessageConversationInfo rhs = ((MessageConversationInfo) other);
        return ((((((((this.userGroups == rhs.userGroups)||((this.userGroups!= null)&&this.userGroups.equals(rhs.userGroups)))&&((this.attachments == rhs.attachments)||((this.attachments!= null)&&this.attachments.equals(rhs.attachments))))&&((this.subject == rhs.subject)||((this.subject!= null)&&this.subject.equals(rhs.subject))))&&((this.organisationUnits == rhs.organisationUnits)||((this.organisationUnits!= null)&&this.organisationUnits.equals(rhs.organisationUnits))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.users == rhs.users)||((this.users!= null)&&this.users.equals(rhs.users))));
    }

}
