
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "set",
    "showKey",
    "strategy",
    "style"
})
@Generated("jsonschema2pojo")
public class LegendDefinitions implements Serializable
{

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("set")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private SetRef set;
    @JsonProperty("showKey")
    private Boolean showKey;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strategy")
    private LegendDefinitions.StrategyRef strategy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("style")
    private LegendDefinitions.StyleRef style;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4151623784916641529L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LegendDefinitions() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public LegendDefinitions(LegendDefinitions source) {
        super();
        this.set = source.set;
        this.showKey = source.showKey;
        this.strategy = source.strategy;
        this.style = source.style;
    }

    /**
     * 
     * @param set
     *     A UID reference to a LegendSet  
     *     (Java name `org.hisp.dhis.legend.LegendSet`).
     */
    public LegendDefinitions(SetRef set, Boolean showKey, LegendDefinitions.StrategyRef strategy, LegendDefinitions.StyleRef style) {
        super();
        this.set = set;
        this.showKey = showKey;
        this.strategy = strategy;
        this.style = style;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("set")
    public Optional<SetRef> getSet() {
        return Optional.ofNullable(set);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("set")
    public void setSet(SetRef set) {
        this.set = set;
    }

    public LegendDefinitions withSet(SetRef set) {
        this.set = set;
        return this;
    }

    @JsonProperty("showKey")
    public Optional<Boolean> getShowKey() {
        return Optional.ofNullable(showKey);
    }

    @JsonProperty("showKey")
    public void setShowKey(Boolean showKey) {
        this.showKey = showKey;
    }

    public LegendDefinitions withShowKey(Boolean showKey) {
        this.showKey = showKey;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strategy")
    public LegendDefinitions.StrategyRef getStrategy() {
        return strategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("strategy")
    public void setStrategy(LegendDefinitions.StrategyRef strategy) {
        this.strategy = strategy;
    }

    public LegendDefinitions withStrategy(LegendDefinitions.StrategyRef strategy) {
        this.strategy = strategy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("style")
    public LegendDefinitions.StyleRef getStyle() {
        return style;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("style")
    public void setStyle(LegendDefinitions.StyleRef style) {
        this.style = style;
    }

    public LegendDefinitions withStyle(LegendDefinitions.StyleRef style) {
        this.style = style;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LegendDefinitions withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("set".equals(name)) {
            if (value instanceof SetRef) {
                setSet(((SetRef) value));
            } else {
                throw new IllegalArgumentException(("property \"set\" is of type \"org.hisp.dhis.api.model.v40_2_2.SetRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("showKey".equals(name)) {
                if (value instanceof Boolean) {
                    setShowKey(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"showKey\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("strategy".equals(name)) {
                    if (value instanceof LegendDefinitions.StrategyRef) {
                        setStrategy(((LegendDefinitions.StrategyRef) value));
                    } else {
                        throw new IllegalArgumentException(("property \"strategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LegendDefinitions.StrategyRef\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("style".equals(name)) {
                        if (value instanceof LegendDefinitions.StyleRef) {
                            setStyle(((LegendDefinitions.StyleRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"style\" is of type \"org.hisp.dhis.api.model.v40_2_2.LegendDefinitions.StyleRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("set".equals(name)) {
            return getSet();
        } else {
            if ("showKey".equals(name)) {
                return getShowKey();
            } else {
                if ("strategy".equals(name)) {
                    return getStrategy();
                } else {
                    if ("style".equals(name)) {
                        return getStyle();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, LegendDefinitions.NOT_FOUND_VALUE);
        if (LegendDefinitions.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public LegendDefinitions with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LegendDefinitions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("set");
        sb.append('=');
        sb.append(((this.set == null)?"<null>":this.set));
        sb.append(',');
        sb.append("showKey");
        sb.append('=');
        sb.append(((this.showKey == null)?"<null>":this.showKey));
        sb.append(',');
        sb.append("strategy");
        sb.append('=');
        sb.append(((this.strategy == null)?"<null>":this.strategy));
        sb.append(',');
        sb.append("style");
        sb.append('=');
        sb.append(((this.style == null)?"<null>":this.style));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.set == null)? 0 :this.set.hashCode()));
        result = ((result* 31)+((this.showKey == null)? 0 :this.showKey.hashCode()));
        result = ((result* 31)+((this.style == null)? 0 :this.style.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.strategy == null)? 0 :this.strategy.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LegendDefinitions) == false) {
            return false;
        }
        LegendDefinitions rhs = ((LegendDefinitions) other);
        return ((((((this.set == rhs.set)||((this.set!= null)&&this.set.equals(rhs.set)))&&((this.showKey == rhs.showKey)||((this.showKey!= null)&&this.showKey.equals(rhs.showKey))))&&((this.style == rhs.style)||((this.style!= null)&&this.style.equals(rhs.style))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.strategy == rhs.strategy)||((this.strategy!= null)&&this.strategy.equals(rhs.strategy))));
    }

    @Generated("jsonschema2pojo")
    public enum StrategyRef {

        FIXED("FIXED"),
        BY_DATA_ITEM("BY_DATA_ITEM");
        private final String value;
        private final static Map<String, LegendDefinitions.StrategyRef> CONSTANTS = new HashMap<String, LegendDefinitions.StrategyRef>();

        static {
            for (LegendDefinitions.StrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LegendDefinitions.StrategyRef fromValue(String value) {
            LegendDefinitions.StrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum StyleRef {

        FILL("FILL"),
        TEXT("TEXT");
        private final String value;
        private final static Map<String, LegendDefinitions.StyleRef> CONSTANTS = new HashMap<String, LegendDefinitions.StyleRef>();

        static {
            for (LegendDefinitions.StyleRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StyleRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LegendDefinitions.StyleRef fromValue(String value) {
            LegendDefinitions.StyleRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
