
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "displayName",
    "id",
    "userGroup",
    "userGroupUid"
})
@Generated("jsonschema2pojo")
public class LegacyUserGroupAccess implements Serializable
{

    @JsonProperty("access")
    private String access;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("id")
    private String id;
    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * (Required)
     * 
     */
    @JsonProperty("userGroup")
    @JsonPropertyDescription("A UID reference to a UserGroup  \n(Java name `org.hisp.dhis.user.UserGroup`)")
    private UserGroupRef userGroup;
    @JsonProperty("userGroupUid")
    private String userGroupUid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 4018010909664272702L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LegacyUserGroupAccess() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public LegacyUserGroupAccess(LegacyUserGroupAccess source) {
        super();
        this.access = source.access;
        this.displayName = source.displayName;
        this.id = source.id;
        this.userGroup = source.userGroup;
        this.userGroupUid = source.userGroupUid;
    }

    /**
     * 
     * @param userGroup
     *     A UID reference to a UserGroup  
     *     (Java name `org.hisp.dhis.user.UserGroup`).
     */
    public LegacyUserGroupAccess(String access, String displayName, String id, UserGroupRef userGroup, String userGroupUid) {
        super();
        this.access = access;
        this.displayName = displayName;
        this.id = id;
        this.userGroup = userGroup;
        this.userGroupUid = userGroupUid;
    }

    @JsonProperty("access")
    public Optional<String> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(String access) {
        this.access = access;
    }

    public LegacyUserGroupAccess withAccess(String access) {
        this.access = access;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public LegacyUserGroupAccess withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public LegacyUserGroupAccess withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * (Required)
     * 
     */
    @JsonProperty("userGroup")
    public UserGroupRef getUserGroup() {
        return userGroup;
    }

    /**
     * A UID reference to a UserGroup  
     * (Java name `org.hisp.dhis.user.UserGroup`)
     * (Required)
     * 
     */
    @JsonProperty("userGroup")
    public void setUserGroup(UserGroupRef userGroup) {
        this.userGroup = userGroup;
    }

    public LegacyUserGroupAccess withUserGroup(UserGroupRef userGroup) {
        this.userGroup = userGroup;
        return this;
    }

    @JsonProperty("userGroupUid")
    public Optional<String> getUserGroupUid() {
        return Optional.ofNullable(userGroupUid);
    }

    @JsonProperty("userGroupUid")
    public void setUserGroupUid(String userGroupUid) {
        this.userGroupUid = userGroupUid;
    }

    public LegacyUserGroupAccess withUserGroupUid(String userGroupUid) {
        this.userGroupUid = userGroupUid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LegacyUserGroupAccess withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof String) {
                setAccess(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("displayName".equals(name)) {
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("id".equals(name)) {
                    if (value instanceof String) {
                        setId(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("userGroup".equals(name)) {
                        if (value instanceof UserGroupRef) {
                            setUserGroup(((UserGroupRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"userGroup\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserGroupRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("userGroupUid".equals(name)) {
                            if (value instanceof String) {
                                setUserGroupUid(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"userGroupUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("displayName".equals(name)) {
                return getDisplayName();
            } else {
                if ("id".equals(name)) {
                    return getId();
                } else {
                    if ("userGroup".equals(name)) {
                        return getUserGroup();
                    } else {
                        if ("userGroupUid".equals(name)) {
                            return getUserGroupUid();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, LegacyUserGroupAccess.NOT_FOUND_VALUE);
        if (LegacyUserGroupAccess.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public LegacyUserGroupAccess with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LegacyUserGroupAccess.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("userGroup");
        sb.append('=');
        sb.append(((this.userGroup == null)?"<null>":this.userGroup));
        sb.append(',');
        sb.append("userGroupUid");
        sb.append('=');
        sb.append(((this.userGroupUid == null)?"<null>":this.userGroupUid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.userGroupUid == null)? 0 :this.userGroupUid.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.userGroup == null)? 0 :this.userGroup.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LegacyUserGroupAccess) == false) {
            return false;
        }
        LegacyUserGroupAccess rhs = ((LegacyUserGroupAccess) other);
        return (((((((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access)))&&((this.userGroupUid == rhs.userGroupUid)||((this.userGroupUid!= null)&&this.userGroupUid.equals(rhs.userGroupUid))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.userGroup == rhs.userGroup)||((this.userGroup!= null)&&this.userGroup.equals(rhs.userGroup))));
    }

}
