
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "displayName",
    "id",
    "user",
    "userUid"
})
@Generated("jsonschema2pojo")
public class LegacyUserAccess implements Serializable
{

    @JsonProperty("access")
    private String access;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("id")
    private String id;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * (Required)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__1 user;
    @JsonProperty("userUid")
    private String userUid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -2375533414582102212L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public LegacyUserAccess() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public LegacyUserAccess(LegacyUserAccess source) {
        super();
        this.access = source.access;
        this.displayName = source.displayName;
        this.id = source.id;
        this.user = source.user;
        this.userUid = source.userUid;
    }

    /**
     * 
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public LegacyUserAccess(String access, String displayName, String id, UserRef__1 user, String userUid) {
        super();
        this.access = access;
        this.displayName = displayName;
        this.id = id;
        this.user = user;
        this.userUid = userUid;
    }

    @JsonProperty("access")
    public Optional<String> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(String access) {
        this.access = access;
    }

    public LegacyUserAccess withAccess(String access) {
        this.access = access;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public LegacyUserAccess withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public LegacyUserAccess withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * (Required)
     * 
     */
    @JsonProperty("user")
    public UserRef__1 getUser() {
        return user;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * (Required)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__1 user) {
        this.user = user;
    }

    public LegacyUserAccess withUser(UserRef__1 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userUid")
    public Optional<String> getUserUid() {
        return Optional.ofNullable(userUid);
    }

    @JsonProperty("userUid")
    public void setUserUid(String userUid) {
        this.userUid = userUid;
    }

    public LegacyUserAccess withUserUid(String userUid) {
        this.userUid = userUid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public LegacyUserAccess withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof String) {
                setAccess(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("displayName".equals(name)) {
                if (value instanceof String) {
                    setDisplayName(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("id".equals(name)) {
                    if (value instanceof String) {
                        setId(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("user".equals(name)) {
                        if (value instanceof UserRef__1) {
                            setUser(((UserRef__1) value));
                        } else {
                            throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__1\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("userUid".equals(name)) {
                            if (value instanceof String) {
                                setUserUid(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"userUid\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            return false;
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("displayName".equals(name)) {
                return getDisplayName();
            } else {
                if ("id".equals(name)) {
                    return getId();
                } else {
                    if ("user".equals(name)) {
                        return getUser();
                    } else {
                        if ("userUid".equals(name)) {
                            return getUserUid();
                        } else {
                            return notFoundValue;
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, LegacyUserAccess.NOT_FOUND_VALUE);
        if (LegacyUserAccess.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public LegacyUserAccess with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(LegacyUserAccess.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userUid");
        sb.append('=');
        sb.append(((this.userUid == null)?"<null>":this.userUid));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        result = ((result* 31)+((this.userUid == null)? 0 :this.userUid.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof LegacyUserAccess) == false) {
            return false;
        }
        LegacyUserAccess rhs = ((LegacyUserAccess) other);
        return (((((((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access)))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))))&&((this.userUid == rhs.userUid)||((this.userUid!= null)&&this.userUid.equals(rhs.userUid))));
    }

}
