
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "jobParameters",
    "jobType",
    "name",
    "schedulingType"
})
@Generated("jsonschema2pojo")
public class JobTypeInfo implements Serializable
{

    @JsonProperty("jobParameters")
    private List<Property> jobParameters;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("jobType")
    private JobTypeInfo.JobTypeRef jobType;
    @JsonProperty("name")
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("schedulingType")
    private JobTypeInfo.SchedulingTypeRef schedulingType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2084261574103558191L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public JobTypeInfo() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public JobTypeInfo(JobTypeInfo source) {
        super();
        this.jobParameters = source.jobParameters;
        this.jobType = source.jobType;
        this.name = source.name;
        this.schedulingType = source.schedulingType;
    }

    public JobTypeInfo(List<Property> jobParameters, JobTypeInfo.JobTypeRef jobType, String name, JobTypeInfo.SchedulingTypeRef schedulingType) {
        super();
        this.jobParameters = jobParameters;
        this.jobType = jobType;
        this.name = name;
        this.schedulingType = schedulingType;
    }

    @JsonProperty("jobParameters")
    public Optional<List<Property>> getJobParameters() {
        return Optional.ofNullable(jobParameters);
    }

    @JsonProperty("jobParameters")
    public void setJobParameters(List<Property> jobParameters) {
        this.jobParameters = jobParameters;
    }

    public JobTypeInfo withJobParameters(List<Property> jobParameters) {
        this.jobParameters = jobParameters;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("jobType")
    public JobTypeInfo.JobTypeRef getJobType() {
        return jobType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("jobType")
    public void setJobType(JobTypeInfo.JobTypeRef jobType) {
        this.jobType = jobType;
    }

    public JobTypeInfo withJobType(JobTypeInfo.JobTypeRef jobType) {
        this.jobType = jobType;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public JobTypeInfo withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("schedulingType")
    public JobTypeInfo.SchedulingTypeRef getSchedulingType() {
        return schedulingType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("schedulingType")
    public void setSchedulingType(JobTypeInfo.SchedulingTypeRef schedulingType) {
        this.schedulingType = schedulingType;
    }

    public JobTypeInfo withSchedulingType(JobTypeInfo.SchedulingTypeRef schedulingType) {
        this.schedulingType = schedulingType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public JobTypeInfo withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("jobParameters".equals(name)) {
            if (value instanceof List) {
                setJobParameters(((List<Property> ) value));
            } else {
                throw new IllegalArgumentException(("property \"jobParameters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Property>\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("jobType".equals(name)) {
                if (value instanceof JobTypeInfo.JobTypeRef) {
                    setJobType(((JobTypeInfo.JobTypeRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"jobType\" is of type \"org.hisp.dhis.api.model.v40_2_2.JobTypeInfo.JobTypeRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("name".equals(name)) {
                    if (value instanceof String) {
                        setName(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("schedulingType".equals(name)) {
                        if (value instanceof JobTypeInfo.SchedulingTypeRef) {
                            setSchedulingType(((JobTypeInfo.SchedulingTypeRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"schedulingType\" is of type \"org.hisp.dhis.api.model.v40_2_2.JobTypeInfo.SchedulingTypeRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("jobParameters".equals(name)) {
            return getJobParameters();
        } else {
            if ("jobType".equals(name)) {
                return getJobType();
            } else {
                if ("name".equals(name)) {
                    return getName();
                } else {
                    if ("schedulingType".equals(name)) {
                        return getSchedulingType();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, JobTypeInfo.NOT_FOUND_VALUE);
        if (JobTypeInfo.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public JobTypeInfo with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(JobTypeInfo.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("jobParameters");
        sb.append('=');
        sb.append(((this.jobParameters == null)?"<null>":this.jobParameters));
        sb.append(',');
        sb.append("jobType");
        sb.append('=');
        sb.append(((this.jobType == null)?"<null>":this.jobType));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("schedulingType");
        sb.append('=');
        sb.append(((this.schedulingType == null)?"<null>":this.schedulingType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.schedulingType == null)? 0 :this.schedulingType.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.jobParameters == null)? 0 :this.jobParameters.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.jobType == null)? 0 :this.jobType.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof JobTypeInfo) == false) {
            return false;
        }
        JobTypeInfo rhs = ((JobTypeInfo) other);
        return ((((((this.schedulingType == rhs.schedulingType)||((this.schedulingType!= null)&&this.schedulingType.equals(rhs.schedulingType)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.jobParameters == rhs.jobParameters)||((this.jobParameters!= null)&&this.jobParameters.equals(rhs.jobParameters))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.jobType == rhs.jobType)||((this.jobType!= null)&&this.jobType.equals(rhs.jobType))));
    }

    @Generated("jsonschema2pojo")
    public enum JobTypeRef {

        DATA_STATISTICS("DATA_STATISTICS"),
        DATA_INTEGRITY("DATA_INTEGRITY"),
        RESOURCE_TABLE("RESOURCE_TABLE"),
        ANALYTICS_TABLE("ANALYTICS_TABLE"),
        CONTINUOUS_ANALYTICS_TABLE("CONTINUOUS_ANALYTICS_TABLE"),
        DATA_SYNC("DATA_SYNC"),
        TRACKER_PROGRAMS_DATA_SYNC("TRACKER_PROGRAMS_DATA_SYNC"),
        EVENT_PROGRAMS_DATA_SYNC("EVENT_PROGRAMS_DATA_SYNC"),
        FILE_RESOURCE_CLEANUP("FILE_RESOURCE_CLEANUP"),
        IMAGE_PROCESSING("IMAGE_PROCESSING"),
        META_DATA_SYNC("META_DATA_SYNC"),
        AGGREGATE_DATA_EXCHANGE("AGGREGATE_DATA_EXCHANGE"),
        SMS_SEND("SMS_SEND"),
        SEND_SCHEDULED_MESSAGE("SEND_SCHEDULED_MESSAGE"),
        PROGRAM_NOTIFICATIONS("PROGRAM_NOTIFICATIONS"),
        VALIDATION_RESULTS_NOTIFICATION("VALIDATION_RESULTS_NOTIFICATION"),
        CREDENTIALS_EXPIRY_ALERT("CREDENTIALS_EXPIRY_ALERT"),
        MONITORING("MONITORING"),
        PUSH_ANALYSIS("PUSH_ANALYSIS"),
        TRACKER_SEARCH_OPTIMIZATION("TRACKER_SEARCH_OPTIMIZATION"),
        PREDICTOR("PREDICTOR"),
        DATA_SET_NOTIFICATION("DATA_SET_NOTIFICATION"),
        REMOVE_USED_OR_EXPIRED_RESERVED_VALUES("REMOVE_USED_OR_EXPIRED_RESERVED_VALUES"),
        TRACKER_IMPORT_JOB("TRACKER_IMPORT_JOB"),
        TRACKER_IMPORT_NOTIFICATION_JOB("TRACKER_IMPORT_NOTIFICATION_JOB"),
        TRACKER_IMPORT_RULE_ENGINE_JOB("TRACKER_IMPORT_RULE_ENGINE_JOB"),
        MATERIALIZED_SQL_VIEW_UPDATE("MATERIALIZED_SQL_VIEW_UPDATE"),
        LEADER_ELECTION("LEADER_ELECTION"),
        LEADER_RENEWAL("LEADER_RENEWAL"),
        COMPLETE_DATA_SET_REGISTRATION_IMPORT("COMPLETE_DATA_SET_REGISTRATION_IMPORT"),
        DATAVALUE_IMPORT_INTERNAL("DATAVALUE_IMPORT_INTERNAL"),
        METADATA_IMPORT("METADATA_IMPORT"),
        DATAVALUE_IMPORT("DATAVALUE_IMPORT"),
        GEOJSON_IMPORT("GEOJSON_IMPORT"),
        EVENT_IMPORT("EVENT_IMPORT"),
        ENROLLMENT_IMPORT("ENROLLMENT_IMPORT"),
        TEI_IMPORT("TEI_IMPORT"),
        DISABLE_INACTIVE_USERS("DISABLE_INACTIVE_USERS"),
        ACCOUNT_EXPIRY_ALERT("ACCOUNT_EXPIRY_ALERT"),
        SYSTEM_VERSION_UPDATE_CHECK("SYSTEM_VERSION_UPDATE_CHECK"),
        TEST("TEST"),
        MOCK("MOCK"),
        GML_IMPORT("GML_IMPORT"),
        ANALYTICSTABLE_UPDATE("ANALYTICSTABLE_UPDATE"),
        PROGRAM_DATA_SYNC("PROGRAM_DATA_SYNC");
        private final String value;
        private final static Map<String, JobTypeInfo.JobTypeRef> CONSTANTS = new HashMap<String, JobTypeInfo.JobTypeRef>();

        static {
            for (JobTypeInfo.JobTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        JobTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JobTypeInfo.JobTypeRef fromValue(String value) {
            JobTypeInfo.JobTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum SchedulingTypeRef {

        CRON("CRON"),
        FIXED_DELAY("FIXED_DELAY");
        private final String value;
        private final static Map<String, JobTypeInfo.SchedulingTypeRef> CONSTANTS = new HashMap<String, JobTypeInfo.SchedulingTypeRef>();

        static {
            for (JobTypeInfo.SchedulingTypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SchedulingTypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JobTypeInfo.SchedulingTypeRef fromValue(String value) {
            JobTypeInfo.SchedulingTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
