
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeValues",
    "code",
    "comments",
    "created",
    "createdBy",
    "dataSet",
    "displayName",
    "eventChart",
    "eventReport",
    "eventVisualization",
    "externalAccess",
    "favorite",
    "favorites",
    "href",
    "id",
    "lastUpdated",
    "lastUpdatedBy",
    "likedBy",
    "likes",
    "map",
    "mentions",
    "organisationUnit",
    "period",
    "publicAccess",
    "sharing",
    "text",
    "translations",
    "type",
    "user",
    "userAccesses",
    "userGroupAccesses",
    "visualization"
})
@Generated("jsonschema2pojo")
public class Interpretation implements Serializable
{

    @JsonProperty("access")
    private Access access;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    @JsonProperty("code")
    private String code;
    @JsonProperty("comments")
    private List<CommentsRefRef> comments;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__42 createdBy;
    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    @JsonPropertyDescription("A UID reference to a DataSet  \n(Java name `org.hisp.dhis.dataset.DataSet`)")
    private DataSetRef__2 dataSet;
    @JsonProperty("displayName")
    private String displayName;
    /**
     * A UID reference to a EventChart  
     * (Java name `org.hisp.dhis.eventchart.EventChart`)
     * 
     */
    @JsonProperty("eventChart")
    @JsonPropertyDescription("A UID reference to a EventChart  \n(Java name `org.hisp.dhis.eventchart.EventChart`)")
    private EventChartRef__1 eventChart;
    /**
     * A UID reference to a EventReport  
     * (Java name `org.hisp.dhis.eventreport.EventReport`)
     * 
     */
    @JsonProperty("eventReport")
    @JsonPropertyDescription("A UID reference to a EventReport  \n(Java name `org.hisp.dhis.eventreport.EventReport`)")
    private EventReportRef__1 eventReport;
    /**
     * A UID reference to a EventVisualization  
     * (Java name `org.hisp.dhis.eventvisualization.EventVisualization`)
     * 
     */
    @JsonProperty("eventVisualization")
    @JsonPropertyDescription("A UID reference to a EventVisualization  \n(Java name `org.hisp.dhis.eventvisualization.EventVisualization`)")
    private EventVisualizationRef__1 eventVisualization;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("href")
    private String href;
    @JsonProperty("id")
    private String id;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__42 lastUpdatedBy;
    @JsonProperty("likedBy")
    private List<LikedByRefRef> likedBy;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("likes")
    private Integer likes;
    /**
     * A UID reference to a Map  
     * (Java name `org.hisp.dhis.mapping.Map`)
     * 
     */
    @JsonProperty("map")
    @JsonPropertyDescription("A UID reference to a Map  \n(Java name `org.hisp.dhis.mapping.Map`)")
    private MapRef__1 map;
    @JsonProperty("mentions")
    private List<Mention> mentions;
    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    @JsonPropertyDescription("A UID reference to a OrganisationUnit  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private OrganisationUnitRef organisationUnit;
    @JsonProperty("period")
    private String period;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("text")
    private String text;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    private Interpretation.TypeRef type;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__43 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    /**
     * A UID reference to a Visualization  
     * (Java name `org.hisp.dhis.visualization.Visualization`)
     * 
     */
    @JsonProperty("visualization")
    @JsonPropertyDescription("A UID reference to a Visualization  \n(Java name `org.hisp.dhis.visualization.Visualization`)")
    private VisualizationRef__1 visualization;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8629784603364218506L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Interpretation() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Interpretation(Interpretation source) {
        super();
        this.access = source.access;
        this.attributeValues = source.attributeValues;
        this.code = source.code;
        this.comments = source.comments;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataSet = source.dataSet;
        this.displayName = source.displayName;
        this.eventChart = source.eventChart;
        this.eventReport = source.eventReport;
        this.eventVisualization = source.eventVisualization;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.href = source.href;
        this.id = source.id;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.likedBy = source.likedBy;
        this.likes = source.likes;
        this.map = source.map;
        this.mentions = source.mentions;
        this.organisationUnit = source.organisationUnit;
        this.period = source.period;
        this.publicAccess = source.publicAccess;
        this.sharing = source.sharing;
        this.text = source.text;
        this.translations = source.translations;
        this.type = source.type;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
        this.visualization = source.visualization;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param visualization
     *     A UID reference to a Visualization  
     *     (Java name `org.hisp.dhis.visualization.Visualization`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param organisationUnit
     *     A UID reference to a OrganisationUnit  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`).
     * @param eventReport
     *     A UID reference to a EventReport  
     *     (Java name `org.hisp.dhis.eventreport.EventReport`).
     * @param eventChart
     *     A UID reference to a EventChart  
     *     (Java name `org.hisp.dhis.eventchart.EventChart`).
     * @param eventVisualization
     *     A UID reference to a EventVisualization  
     *     (Java name `org.hisp.dhis.eventvisualization.EventVisualization`).
     * @param dataSet
     *     A UID reference to a DataSet  
     *     (Java name `org.hisp.dhis.dataset.DataSet`).
     * @param map
     *     A UID reference to a Map  
     *     (Java name `org.hisp.dhis.mapping.Map`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public Interpretation(Access access, List<AttributeValue> attributeValues, String code, List<CommentsRefRef> comments, Date created, CreatedByRef__42 createdBy, DataSetRef__2 dataSet, String displayName, EventChartRef__1 eventChart, EventReportRef__1 eventReport, EventVisualizationRef__1 eventVisualization, Boolean externalAccess, Boolean favorite, List<String> favorites, String href, String id, Date lastUpdated, LastUpdatedByRef__42 lastUpdatedBy, List<LikedByRefRef> likedBy, Integer likes, MapRef__1 map, List<Mention> mentions, OrganisationUnitRef organisationUnit, String period, String publicAccess, Sharing sharing, String text, List<Translation> translations, Interpretation.TypeRef type, UserRef__43 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses, VisualizationRef__1 visualization) {
        super();
        this.access = access;
        this.attributeValues = attributeValues;
        this.code = code;
        this.comments = comments;
        this.created = created;
        this.createdBy = createdBy;
        this.dataSet = dataSet;
        this.displayName = displayName;
        this.eventChart = eventChart;
        this.eventReport = eventReport;
        this.eventVisualization = eventVisualization;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.href = href;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.likedBy = likedBy;
        this.likes = likes;
        this.map = map;
        this.mentions = mentions;
        this.organisationUnit = organisationUnit;
        this.period = period;
        this.publicAccess = publicAccess;
        this.sharing = sharing;
        this.text = text;
        this.translations = translations;
        this.type = type;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
        this.visualization = visualization;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public Interpretation withAccess(Access access) {
        this.access = access;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public Interpretation withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Interpretation withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("comments")
    public Optional<List<CommentsRefRef>> getComments() {
        return Optional.ofNullable(comments);
    }

    @JsonProperty("comments")
    public void setComments(List<CommentsRefRef> comments) {
        this.comments = comments;
    }

    public Interpretation withComments(List<CommentsRefRef> comments) {
        this.comments = comments;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public Interpretation withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__42> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__42 createdBy) {
        this.createdBy = createdBy;
    }

    public Interpretation withCreatedBy(CreatedByRef__42 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    public Optional<DataSetRef__2> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    public void setDataSet(DataSetRef__2 dataSet) {
        this.dataSet = dataSet;
    }

    public Interpretation withDataSet(DataSetRef__2 dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("displayName")
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public Interpretation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * A UID reference to a EventChart  
     * (Java name `org.hisp.dhis.eventchart.EventChart`)
     * 
     */
    @JsonProperty("eventChart")
    public Optional<EventChartRef__1> getEventChart() {
        return Optional.ofNullable(eventChart);
    }

    /**
     * A UID reference to a EventChart  
     * (Java name `org.hisp.dhis.eventchart.EventChart`)
     * 
     */
    @JsonProperty("eventChart")
    public void setEventChart(EventChartRef__1 eventChart) {
        this.eventChart = eventChart;
    }

    public Interpretation withEventChart(EventChartRef__1 eventChart) {
        this.eventChart = eventChart;
        return this;
    }

    /**
     * A UID reference to a EventReport  
     * (Java name `org.hisp.dhis.eventreport.EventReport`)
     * 
     */
    @JsonProperty("eventReport")
    public Optional<EventReportRef__1> getEventReport() {
        return Optional.ofNullable(eventReport);
    }

    /**
     * A UID reference to a EventReport  
     * (Java name `org.hisp.dhis.eventreport.EventReport`)
     * 
     */
    @JsonProperty("eventReport")
    public void setEventReport(EventReportRef__1 eventReport) {
        this.eventReport = eventReport;
    }

    public Interpretation withEventReport(EventReportRef__1 eventReport) {
        this.eventReport = eventReport;
        return this;
    }

    /**
     * A UID reference to a EventVisualization  
     * (Java name `org.hisp.dhis.eventvisualization.EventVisualization`)
     * 
     */
    @JsonProperty("eventVisualization")
    public Optional<EventVisualizationRef__1> getEventVisualization() {
        return Optional.ofNullable(eventVisualization);
    }

    /**
     * A UID reference to a EventVisualization  
     * (Java name `org.hisp.dhis.eventvisualization.EventVisualization`)
     * 
     */
    @JsonProperty("eventVisualization")
    public void setEventVisualization(EventVisualizationRef__1 eventVisualization) {
        this.eventVisualization = eventVisualization;
    }

    public Interpretation withEventVisualization(EventVisualizationRef__1 eventVisualization) {
        this.eventVisualization = eventVisualization;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public Interpretation withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public Interpretation withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public Interpretation withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public Interpretation withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    @JsonProperty("id")
    public void setId(String id) {
        this.id = id;
    }

    public Interpretation withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public Interpretation withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__42> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__42 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public Interpretation withLastUpdatedBy(LastUpdatedByRef__42 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    @JsonProperty("likedBy")
    public Optional<List<LikedByRefRef>> getLikedBy() {
        return Optional.ofNullable(likedBy);
    }

    @JsonProperty("likedBy")
    public void setLikedBy(List<LikedByRefRef> likedBy) {
        this.likedBy = likedBy;
    }

    public Interpretation withLikedBy(List<LikedByRefRef> likedBy) {
        this.likedBy = likedBy;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("likes")
    public Integer getLikes() {
        return likes;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("likes")
    public void setLikes(Integer likes) {
        this.likes = likes;
    }

    public Interpretation withLikes(Integer likes) {
        this.likes = likes;
        return this;
    }

    /**
     * A UID reference to a Map  
     * (Java name `org.hisp.dhis.mapping.Map`)
     * 
     */
    @JsonProperty("map")
    public Optional<MapRef__1> getMap() {
        return Optional.ofNullable(map);
    }

    /**
     * A UID reference to a Map  
     * (Java name `org.hisp.dhis.mapping.Map`)
     * 
     */
    @JsonProperty("map")
    public void setMap(MapRef__1 map) {
        this.map = map;
    }

    public Interpretation withMap(MapRef__1 map) {
        this.map = map;
        return this;
    }

    @JsonProperty("mentions")
    public Optional<List<Mention>> getMentions() {
        return Optional.ofNullable(mentions);
    }

    @JsonProperty("mentions")
    public void setMentions(List<Mention> mentions) {
        this.mentions = mentions;
    }

    public Interpretation withMentions(List<Mention> mentions) {
        this.mentions = mentions;
        return this;
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    public Optional<OrganisationUnitRef> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    /**
     * A UID reference to a OrganisationUnit  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(OrganisationUnitRef organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public Interpretation withOrganisationUnit(OrganisationUnitRef organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public Interpretation withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public Interpretation withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public Interpretation withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("text")
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    public Interpretation withText(String text) {
        this.text = text;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Interpretation withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public Interpretation.TypeRef getType() {
        return type;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("type")
    public void setType(Interpretation.TypeRef type) {
        this.type = type;
    }

    public Interpretation withType(Interpretation.TypeRef type) {
        this.type = type;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__43> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__43 user) {
        this.user = user;
    }

    public Interpretation withUser(UserRef__43 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public Interpretation withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public Interpretation withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    /**
     * A UID reference to a Visualization  
     * (Java name `org.hisp.dhis.visualization.Visualization`)
     * 
     */
    @JsonProperty("visualization")
    public Optional<VisualizationRef__1> getVisualization() {
        return Optional.ofNullable(visualization);
    }

    /**
     * A UID reference to a Visualization  
     * (Java name `org.hisp.dhis.visualization.Visualization`)
     * 
     */
    @JsonProperty("visualization")
    public void setVisualization(VisualizationRef__1 visualization) {
        this.visualization = visualization;
    }

    public Interpretation withVisualization(VisualizationRef__1 visualization) {
        this.visualization = visualization;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Interpretation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeValues".equals(name)) {
                if (value instanceof List) {
                    setAttributeValues(((List<AttributeValue> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("code".equals(name)) {
                    if (value instanceof String) {
                        setCode(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("comments".equals(name)) {
                        if (value instanceof List) {
                            setComments(((List<CommentsRefRef> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"comments\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.CommentsRefRef>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("created".equals(name)) {
                            if (value instanceof Date) {
                                setCreated(((Date) value));
                            } else {
                                throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("createdBy".equals(name)) {
                                if (value instanceof CreatedByRef__42) {
                                    setCreatedBy(((CreatedByRef__42) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__42\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("dataSet".equals(name)) {
                                    if (value instanceof DataSetRef__2) {
                                        setDataSet(((DataSetRef__2) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"dataSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataSetRef__2\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("displayName".equals(name)) {
                                        if (value instanceof String) {
                                            setDisplayName(((String) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"displayName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("eventChart".equals(name)) {
                                            if (value instanceof EventChartRef__1) {
                                                setEventChart(((EventChartRef__1) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"eventChart\" is of type \"org.hisp.dhis.api.model.v40_2_2.EventChartRef__1\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("eventReport".equals(name)) {
                                                if (value instanceof EventReportRef__1) {
                                                    setEventReport(((EventReportRef__1) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"eventReport\" is of type \"org.hisp.dhis.api.model.v40_2_2.EventReportRef__1\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("eventVisualization".equals(name)) {
                                                    if (value instanceof EventVisualizationRef__1) {
                                                        setEventVisualization(((EventVisualizationRef__1) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"eventVisualization\" is of type \"org.hisp.dhis.api.model.v40_2_2.EventVisualizationRef__1\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setHref(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setId(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"id\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setLastUpdated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                if (value instanceof LastUpdatedByRef__42) {
                                                                                    setLastUpdatedBy(((LastUpdatedByRef__42) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__42\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("likedBy".equals(name)) {
                                                                                    if (value instanceof List) {
                                                                                        setLikedBy(((List<LikedByRefRef> ) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"likedBy\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LikedByRefRef>\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("likes".equals(name)) {
                                                                                        if (value instanceof Integer) {
                                                                                            setLikes(((Integer) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"likes\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("map".equals(name)) {
                                                                                            if (value instanceof MapRef__1) {
                                                                                                setMap(((MapRef__1) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"map\" is of type \"org.hisp.dhis.api.model.v40_2_2.MapRef__1\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("mentions".equals(name)) {
                                                                                                if (value instanceof List) {
                                                                                                    setMentions(((List<Mention> ) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"mentions\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Mention>\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("organisationUnit".equals(name)) {
                                                                                                    if (value instanceof OrganisationUnitRef) {
                                                                                                        setOrganisationUnit(((OrganisationUnitRef) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"org.hisp.dhis.api.model.v40_2_2.OrganisationUnitRef\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("period".equals(name)) {
                                                                                                        if (value instanceof String) {
                                                                                                            setPeriod(((String) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            if (value instanceof String) {
                                                                                                                setPublicAccess(((String) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("sharing".equals(name)) {
                                                                                                                if (value instanceof Sharing) {
                                                                                                                    setSharing(((Sharing) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("text".equals(name)) {
                                                                                                                    if (value instanceof String) {
                                                                                                                        setText(((String) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"text\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    if ("translations".equals(name)) {
                                                                                                                        if (value instanceof List) {
                                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                                        } else {
                                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                                        }
                                                                                                                        return true;
                                                                                                                    } else {
                                                                                                                        if ("type".equals(name)) {
                                                                                                                            if (value instanceof Interpretation.TypeRef) {
                                                                                                                                setType(((Interpretation.TypeRef) value));
                                                                                                                            } else {
                                                                                                                                throw new IllegalArgumentException(("property \"type\" is of type \"org.hisp.dhis.api.model.v40_2_2.Interpretation.TypeRef\", but got "+ value.getClass().toString()));
                                                                                                                            }
                                                                                                                            return true;
                                                                                                                        } else {
                                                                                                                            if ("user".equals(name)) {
                                                                                                                                if (value instanceof UserRef__43) {
                                                                                                                                    setUser(((UserRef__43) value));
                                                                                                                                } else {
                                                                                                                                    throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__43\", but got "+ value.getClass().toString()));
                                                                                                                                }
                                                                                                                                return true;
                                                                                                                            } else {
                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                    if (value instanceof List) {
                                                                                                                                        setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                                    } else {
                                                                                                                                        throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                    }
                                                                                                                                    return true;
                                                                                                                                } else {
                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                        if (value instanceof List) {
                                                                                                                                            setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                                        } else {
                                                                                                                                            throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                                        }
                                                                                                                                        return true;
                                                                                                                                    } else {
                                                                                                                                        if ("visualization".equals(name)) {
                                                                                                                                            if (value instanceof VisualizationRef__1) {
                                                                                                                                                setVisualization(((VisualizationRef__1) value));
                                                                                                                                            } else {
                                                                                                                                                throw new IllegalArgumentException(("property \"visualization\" is of type \"org.hisp.dhis.api.model.v40_2_2.VisualizationRef__1\", but got "+ value.getClass().toString()));
                                                                                                                                            }
                                                                                                                                            return true;
                                                                                                                                        } else {
                                                                                                                                            return false;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeValues".equals(name)) {
                return getAttributeValues();
            } else {
                if ("code".equals(name)) {
                    return getCode();
                } else {
                    if ("comments".equals(name)) {
                        return getComments();
                    } else {
                        if ("created".equals(name)) {
                            return getCreated();
                        } else {
                            if ("createdBy".equals(name)) {
                                return getCreatedBy();
                            } else {
                                if ("dataSet".equals(name)) {
                                    return getDataSet();
                                } else {
                                    if ("displayName".equals(name)) {
                                        return getDisplayName();
                                    } else {
                                        if ("eventChart".equals(name)) {
                                            return getEventChart();
                                        } else {
                                            if ("eventReport".equals(name)) {
                                                return getEventReport();
                                            } else {
                                                if ("eventVisualization".equals(name)) {
                                                    return getEventVisualization();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("href".equals(name)) {
                                                                    return getHref();
                                                                } else {
                                                                    if ("id".equals(name)) {
                                                                        return getId();
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            return getLastUpdated();
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                return getLastUpdatedBy();
                                                                            } else {
                                                                                if ("likedBy".equals(name)) {
                                                                                    return getLikedBy();
                                                                                } else {
                                                                                    if ("likes".equals(name)) {
                                                                                        return getLikes();
                                                                                    } else {
                                                                                        if ("map".equals(name)) {
                                                                                            return getMap();
                                                                                        } else {
                                                                                            if ("mentions".equals(name)) {
                                                                                                return getMentions();
                                                                                            } else {
                                                                                                if ("organisationUnit".equals(name)) {
                                                                                                    return getOrganisationUnit();
                                                                                                } else {
                                                                                                    if ("period".equals(name)) {
                                                                                                        return getPeriod();
                                                                                                    } else {
                                                                                                        if ("publicAccess".equals(name)) {
                                                                                                            return getPublicAccess();
                                                                                                        } else {
                                                                                                            if ("sharing".equals(name)) {
                                                                                                                return getSharing();
                                                                                                            } else {
                                                                                                                if ("text".equals(name)) {
                                                                                                                    return getText();
                                                                                                                } else {
                                                                                                                    if ("translations".equals(name)) {
                                                                                                                        return getTranslations();
                                                                                                                    } else {
                                                                                                                        if ("type".equals(name)) {
                                                                                                                            return getType();
                                                                                                                        } else {
                                                                                                                            if ("user".equals(name)) {
                                                                                                                                return getUser();
                                                                                                                            } else {
                                                                                                                                if ("userAccesses".equals(name)) {
                                                                                                                                    return getUserAccesses();
                                                                                                                                } else {
                                                                                                                                    if ("userGroupAccesses".equals(name)) {
                                                                                                                                        return getUserGroupAccesses();
                                                                                                                                    } else {
                                                                                                                                        if ("visualization".equals(name)) {
                                                                                                                                            return getVisualization();
                                                                                                                                        } else {
                                                                                                                                            return notFoundValue;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Interpretation.NOT_FOUND_VALUE);
        if (Interpretation.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Interpretation with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Interpretation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("comments");
        sb.append('=');
        sb.append(((this.comments == null)?"<null>":this.comments));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("displayName");
        sb.append('=');
        sb.append(((this.displayName == null)?"<null>":this.displayName));
        sb.append(',');
        sb.append("eventChart");
        sb.append('=');
        sb.append(((this.eventChart == null)?"<null>":this.eventChart));
        sb.append(',');
        sb.append("eventReport");
        sb.append('=');
        sb.append(((this.eventReport == null)?"<null>":this.eventReport));
        sb.append(',');
        sb.append("eventVisualization");
        sb.append('=');
        sb.append(((this.eventVisualization == null)?"<null>":this.eventVisualization));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("likedBy");
        sb.append('=');
        sb.append(((this.likedBy == null)?"<null>":this.likedBy));
        sb.append(',');
        sb.append("likes");
        sb.append('=');
        sb.append(((this.likes == null)?"<null>":this.likes));
        sb.append(',');
        sb.append("map");
        sb.append('=');
        sb.append(((this.map == null)?"<null>":this.map));
        sb.append(',');
        sb.append("mentions");
        sb.append('=');
        sb.append(((this.mentions == null)?"<null>":this.mentions));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(((this.type == null)?"<null>":this.type));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("visualization");
        sb.append('=');
        sb.append(((this.visualization == null)?"<null>":this.visualization));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.visualization == null)? 0 :this.visualization.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.likedBy == null)? 0 :this.likedBy.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.displayName == null)? 0 :this.displayName.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.type == null)? 0 :this.type.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.eventVisualization == null)? 0 :this.eventVisualization.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        result = ((result* 31)+((this.map == null)? 0 :this.map.hashCode()));
        result = ((result* 31)+((this.likes == null)? 0 :this.likes.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.comments == null)? 0 :this.comments.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.eventReport == null)? 0 :this.eventReport.hashCode()));
        result = ((result* 31)+((this.mentions == null)? 0 :this.mentions.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.eventChart == null)? 0 :this.eventChart.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Interpretation) == false) {
            return false;
        }
        Interpretation rhs = ((Interpretation) other);
        return (((((((((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.visualization == rhs.visualization)||((this.visualization!= null)&&this.visualization.equals(rhs.visualization))))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.likedBy == rhs.likedBy)||((this.likedBy!= null)&&this.likedBy.equals(rhs.likedBy))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.displayName == rhs.displayName)||((this.displayName!= null)&&this.displayName.equals(rhs.displayName))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.type == rhs.type)||((this.type!= null)&&this.type.equals(rhs.type))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.eventVisualization == rhs.eventVisualization)||((this.eventVisualization!= null)&&this.eventVisualization.equals(rhs.eventVisualization))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))))&&((this.map == rhs.map)||((this.map!= null)&&this.map.equals(rhs.map))))&&((this.likes == rhs.likes)||((this.likes!= null)&&this.likes.equals(rhs.likes))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period))))&&((this.comments == rhs.comments)||((this.comments!= null)&&this.comments.equals(rhs.comments))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.eventReport == rhs.eventReport)||((this.eventReport!= null)&&this.eventReport.equals(rhs.eventReport))))&&((this.mentions == rhs.mentions)||((this.mentions!= null)&&this.mentions.equals(rhs.mentions))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.eventChart == rhs.eventChart)||((this.eventChart!= null)&&this.eventChart.equals(rhs.eventChart))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

    @Generated("jsonschema2pojo")
    public enum TypeRef {

        VISUALIZATION("VISUALIZATION"),
        EVENT_VISUALIZATION("EVENT_VISUALIZATION"),
        MAP("MAP"),
        EVENT_REPORT("EVENT_REPORT"),
        EVENT_CHART("EVENT_CHART"),
        DATASET_REPORT("DATASET_REPORT");
        private final String value;
        private final static Map<String, Interpretation.TypeRef> CONSTANTS = new HashMap<String, Interpretation.TypeRef>();

        static {
            for (Interpretation.TypeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TypeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Interpretation.TypeRef fromValue(String value) {
            Interpretation.TypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
