
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "deleted",
    "ignored",
    "importOptions",
    "importSummaries",
    "imported",
    "responseType",
    "status",
    "total",
    "updated"
})
@Generated("jsonschema2pojo")
public class ImportSummaries implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    private Integer deleted;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ignored")
    private Integer ignored;
    @JsonProperty("importOptions")
    private ImportOptions importOptions;
    @JsonProperty("importSummaries")
    private List<ImportSummary> importSummaries;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("imported")
    private Integer imported;
    @JsonProperty("responseType")
    private String responseType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    private ImportSummaries.StatusRef status;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("total")
    private Integer total;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("updated")
    private Integer updated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -6247048915097626525L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportSummaries() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportSummaries(ImportSummaries source) {
        super();
        this.deleted = source.deleted;
        this.ignored = source.ignored;
        this.importOptions = source.importOptions;
        this.importSummaries = source.importSummaries;
        this.imported = source.imported;
        this.responseType = source.responseType;
        this.status = source.status;
        this.total = source.total;
        this.updated = source.updated;
    }

    public ImportSummaries(Integer deleted, Integer ignored, ImportOptions importOptions, List<ImportSummary> importSummaries, Integer imported, String responseType, ImportSummaries.StatusRef status, Integer total, Integer updated) {
        super();
        this.deleted = deleted;
        this.ignored = ignored;
        this.importOptions = importOptions;
        this.importSummaries = importSummaries;
        this.imported = imported;
        this.responseType = responseType;
        this.status = status;
        this.total = total;
        this.updated = updated;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public Integer getDeleted() {
        return deleted;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("deleted")
    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public ImportSummaries withDeleted(Integer deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ignored")
    public Integer getIgnored() {
        return ignored;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ignored")
    public void setIgnored(Integer ignored) {
        this.ignored = ignored;
    }

    public ImportSummaries withIgnored(Integer ignored) {
        this.ignored = ignored;
        return this;
    }

    @JsonProperty("importOptions")
    public Optional<ImportOptions> getImportOptions() {
        return Optional.ofNullable(importOptions);
    }

    @JsonProperty("importOptions")
    public void setImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    public ImportSummaries withImportOptions(ImportOptions importOptions) {
        this.importOptions = importOptions;
        return this;
    }

    @JsonProperty("importSummaries")
    public Optional<List<ImportSummary>> getImportSummaries() {
        return Optional.ofNullable(importSummaries);
    }

    @JsonProperty("importSummaries")
    public void setImportSummaries(List<ImportSummary> importSummaries) {
        this.importSummaries = importSummaries;
    }

    public ImportSummaries withImportSummaries(List<ImportSummary> importSummaries) {
        this.importSummaries = importSummaries;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("imported")
    public Integer getImported() {
        return imported;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("imported")
    public void setImported(Integer imported) {
        this.imported = imported;
    }

    public ImportSummaries withImported(Integer imported) {
        this.imported = imported;
        return this;
    }

    @JsonProperty("responseType")
    public Optional<String> getResponseType() {
        return Optional.ofNullable(responseType);
    }

    @JsonProperty("responseType")
    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public ImportSummaries withResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public ImportSummaries.StatusRef getStatus() {
        return status;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("status")
    public void setStatus(ImportSummaries.StatusRef status) {
        this.status = status;
    }

    public ImportSummaries withStatus(ImportSummaries.StatusRef status) {
        this.status = status;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("total")
    public Integer getTotal() {
        return total;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("total")
    public void setTotal(Integer total) {
        this.total = total;
    }

    public ImportSummaries withTotal(Integer total) {
        this.total = total;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("updated")
    public Integer getUpdated() {
        return updated;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("updated")
    public void setUpdated(Integer updated) {
        this.updated = updated;
    }

    public ImportSummaries withUpdated(Integer updated) {
        this.updated = updated;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportSummaries withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("deleted".equals(name)) {
            if (value instanceof Integer) {
                setDeleted(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"deleted\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("ignored".equals(name)) {
                if (value instanceof Integer) {
                    setIgnored(((Integer) value));
                } else {
                    throw new IllegalArgumentException(("property \"ignored\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("importOptions".equals(name)) {
                    if (value instanceof ImportOptions) {
                        setImportOptions(((ImportOptions) value));
                    } else {
                        throw new IllegalArgumentException(("property \"importOptions\" is of type \"org.hisp.dhis.api.model.v40_2_2.ImportOptions\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("importSummaries".equals(name)) {
                        if (value instanceof List) {
                            setImportSummaries(((List<ImportSummary> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"importSummaries\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.ImportSummary>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("imported".equals(name)) {
                            if (value instanceof Integer) {
                                setImported(((Integer) value));
                            } else {
                                throw new IllegalArgumentException(("property \"imported\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("responseType".equals(name)) {
                                if (value instanceof String) {
                                    setResponseType(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"responseType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("status".equals(name)) {
                                    if (value instanceof ImportSummaries.StatusRef) {
                                        setStatus(((ImportSummaries.StatusRef) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"status\" is of type \"org.hisp.dhis.api.model.v40_2_2.ImportSummaries.StatusRef\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("total".equals(name)) {
                                        if (value instanceof Integer) {
                                            setTotal(((Integer) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"total\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("updated".equals(name)) {
                                            if (value instanceof Integer) {
                                                setUpdated(((Integer) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"updated\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("deleted".equals(name)) {
            return getDeleted();
        } else {
            if ("ignored".equals(name)) {
                return getIgnored();
            } else {
                if ("importOptions".equals(name)) {
                    return getImportOptions();
                } else {
                    if ("importSummaries".equals(name)) {
                        return getImportSummaries();
                    } else {
                        if ("imported".equals(name)) {
                            return getImported();
                        } else {
                            if ("responseType".equals(name)) {
                                return getResponseType();
                            } else {
                                if ("status".equals(name)) {
                                    return getStatus();
                                } else {
                                    if ("total".equals(name)) {
                                        return getTotal();
                                    } else {
                                        if ("updated".equals(name)) {
                                            return getUpdated();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportSummaries.NOT_FOUND_VALUE);
        if (ImportSummaries.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportSummaries with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportSummaries.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("deleted");
        sb.append('=');
        sb.append(((this.deleted == null)?"<null>":this.deleted));
        sb.append(',');
        sb.append("ignored");
        sb.append('=');
        sb.append(((this.ignored == null)?"<null>":this.ignored));
        sb.append(',');
        sb.append("importOptions");
        sb.append('=');
        sb.append(((this.importOptions == null)?"<null>":this.importOptions));
        sb.append(',');
        sb.append("importSummaries");
        sb.append('=');
        sb.append(((this.importSummaries == null)?"<null>":this.importSummaries));
        sb.append(',');
        sb.append("imported");
        sb.append('=');
        sb.append(((this.imported == null)?"<null>":this.imported));
        sb.append(',');
        sb.append("responseType");
        sb.append('=');
        sb.append(((this.responseType == null)?"<null>":this.responseType));
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(((this.status == null)?"<null>":this.status));
        sb.append(',');
        sb.append("total");
        sb.append('=');
        sb.append(((this.total == null)?"<null>":this.total));
        sb.append(',');
        sb.append("updated");
        sb.append('=');
        sb.append(((this.updated == null)?"<null>":this.updated));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.ignored == null)? 0 :this.ignored.hashCode()));
        result = ((result* 31)+((this.importOptions == null)? 0 :this.importOptions.hashCode()));
        result = ((result* 31)+((this.responseType == null)? 0 :this.responseType.hashCode()));
        result = ((result* 31)+((this.total == null)? 0 :this.total.hashCode()));
        result = ((result* 31)+((this.deleted == null)? 0 :this.deleted.hashCode()));
        result = ((result* 31)+((this.imported == null)? 0 :this.imported.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.importSummaries == null)? 0 :this.importSummaries.hashCode()));
        result = ((result* 31)+((this.updated == null)? 0 :this.updated.hashCode()));
        result = ((result* 31)+((this.status == null)? 0 :this.status.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportSummaries) == false) {
            return false;
        }
        ImportSummaries rhs = ((ImportSummaries) other);
        return (((((((((((this.ignored == rhs.ignored)||((this.ignored!= null)&&this.ignored.equals(rhs.ignored)))&&((this.importOptions == rhs.importOptions)||((this.importOptions!= null)&&this.importOptions.equals(rhs.importOptions))))&&((this.responseType == rhs.responseType)||((this.responseType!= null)&&this.responseType.equals(rhs.responseType))))&&((this.total == rhs.total)||((this.total!= null)&&this.total.equals(rhs.total))))&&((this.deleted == rhs.deleted)||((this.deleted!= null)&&this.deleted.equals(rhs.deleted))))&&((this.imported == rhs.imported)||((this.imported!= null)&&this.imported.equals(rhs.imported))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.importSummaries == rhs.importSummaries)||((this.importSummaries!= null)&&this.importSummaries.equals(rhs.importSummaries))))&&((this.updated == rhs.updated)||((this.updated!= null)&&this.updated.equals(rhs.updated))))&&((this.status == rhs.status)||((this.status!= null)&&this.status.equals(rhs.status))));
    }

    @Generated("jsonschema2pojo")
    public enum StatusRef {

        SUCCESS("SUCCESS"),
        WARNING("WARNING"),
        ERROR("ERROR");
        private final String value;
        private final static Map<String, ImportSummaries.StatusRef> CONSTANTS = new HashMap<String, ImportSummaries.StatusRef>();

        static {
            for (ImportSummaries.StatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        StatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ImportSummaries.StatusRef fromValue(String value) {
            ImportSummaries.StatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
