
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "conflictCount",
    "conflicts",
    "conflictsDescription",
    "totalConflictOccurrenceCount"
})
@Generated("jsonschema2pojo")
public class ImportConflicts implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("conflictCount")
    private Integer conflictCount;
    @JsonProperty("conflicts")
    private List<ImportConflict> conflicts;
    @JsonProperty("conflictsDescription")
    private String conflictsDescription;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalConflictOccurrenceCount")
    private Integer totalConflictOccurrenceCount;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -4861521938167107317L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImportConflicts() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public ImportConflicts(ImportConflicts source) {
        super();
        this.conflictCount = source.conflictCount;
        this.conflicts = source.conflicts;
        this.conflictsDescription = source.conflictsDescription;
        this.totalConflictOccurrenceCount = source.totalConflictOccurrenceCount;
    }

    public ImportConflicts(Integer conflictCount, List<ImportConflict> conflicts, String conflictsDescription, Integer totalConflictOccurrenceCount) {
        super();
        this.conflictCount = conflictCount;
        this.conflicts = conflicts;
        this.conflictsDescription = conflictsDescription;
        this.totalConflictOccurrenceCount = totalConflictOccurrenceCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("conflictCount")
    public Integer getConflictCount() {
        return conflictCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("conflictCount")
    public void setConflictCount(Integer conflictCount) {
        this.conflictCount = conflictCount;
    }

    public ImportConflicts withConflictCount(Integer conflictCount) {
        this.conflictCount = conflictCount;
        return this;
    }

    @JsonProperty("conflicts")
    public Optional<List<ImportConflict>> getConflicts() {
        return Optional.ofNullable(conflicts);
    }

    @JsonProperty("conflicts")
    public void setConflicts(List<ImportConflict> conflicts) {
        this.conflicts = conflicts;
    }

    public ImportConflicts withConflicts(List<ImportConflict> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    @JsonProperty("conflictsDescription")
    public Optional<String> getConflictsDescription() {
        return Optional.ofNullable(conflictsDescription);
    }

    @JsonProperty("conflictsDescription")
    public void setConflictsDescription(String conflictsDescription) {
        this.conflictsDescription = conflictsDescription;
    }

    public ImportConflicts withConflictsDescription(String conflictsDescription) {
        this.conflictsDescription = conflictsDescription;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalConflictOccurrenceCount")
    public Integer getTotalConflictOccurrenceCount() {
        return totalConflictOccurrenceCount;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("totalConflictOccurrenceCount")
    public void setTotalConflictOccurrenceCount(Integer totalConflictOccurrenceCount) {
        this.totalConflictOccurrenceCount = totalConflictOccurrenceCount;
    }

    public ImportConflicts withTotalConflictOccurrenceCount(Integer totalConflictOccurrenceCount) {
        this.totalConflictOccurrenceCount = totalConflictOccurrenceCount;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public ImportConflicts withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("conflictCount".equals(name)) {
            if (value instanceof Integer) {
                setConflictCount(((Integer) value));
            } else {
                throw new IllegalArgumentException(("property \"conflictCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("conflicts".equals(name)) {
                if (value instanceof List) {
                    setConflicts(((List<ImportConflict> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"conflicts\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.ImportConflict>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("conflictsDescription".equals(name)) {
                    if (value instanceof String) {
                        setConflictsDescription(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"conflictsDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("totalConflictOccurrenceCount".equals(name)) {
                        if (value instanceof Integer) {
                            setTotalConflictOccurrenceCount(((Integer) value));
                        } else {
                            throw new IllegalArgumentException(("property \"totalConflictOccurrenceCount\" is of type \"java.lang.Integer\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("conflictCount".equals(name)) {
            return getConflictCount();
        } else {
            if ("conflicts".equals(name)) {
                return getConflicts();
            } else {
                if ("conflictsDescription".equals(name)) {
                    return getConflictsDescription();
                } else {
                    if ("totalConflictOccurrenceCount".equals(name)) {
                        return getTotalConflictOccurrenceCount();
                    } else {
                        return notFoundValue;
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ImportConflicts.NOT_FOUND_VALUE);
        if (ImportConflicts.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public ImportConflicts with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ImportConflicts.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("conflictCount");
        sb.append('=');
        sb.append(((this.conflictCount == null)?"<null>":this.conflictCount));
        sb.append(',');
        sb.append("conflicts");
        sb.append('=');
        sb.append(((this.conflicts == null)?"<null>":this.conflicts));
        sb.append(',');
        sb.append("conflictsDescription");
        sb.append('=');
        sb.append(((this.conflictsDescription == null)?"<null>":this.conflictsDescription));
        sb.append(',');
        sb.append("totalConflictOccurrenceCount");
        sb.append('=');
        sb.append(((this.totalConflictOccurrenceCount == null)?"<null>":this.totalConflictOccurrenceCount));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.conflictsDescription == null)? 0 :this.conflictsDescription.hashCode()));
        result = ((result* 31)+((this.conflicts == null)? 0 :this.conflicts.hashCode()));
        result = ((result* 31)+((this.totalConflictOccurrenceCount == null)? 0 :this.totalConflictOccurrenceCount.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.conflictCount == null)? 0 :this.conflictCount.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ImportConflicts) == false) {
            return false;
        }
        ImportConflicts rhs = ((ImportConflicts) other);
        return ((((((this.conflictsDescription == rhs.conflictsDescription)||((this.conflictsDescription!= null)&&this.conflictsDescription.equals(rhs.conflictsDescription)))&&((this.conflicts == rhs.conflicts)||((this.conflicts!= null)&&this.conflicts.equals(rhs.conflicts))))&&((this.totalConflictOccurrenceCount == rhs.totalConflictOccurrenceCount)||((this.totalConflictOccurrenceCount!= null)&&this.totalConflictOccurrenceCount.equals(rhs.totalConflictOccurrenceCount))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.conflictCount == rhs.conflictCount)||((this.conflictCount!= null)&&this.conflictCount.equals(rhs.conflictCount))));
    }

}
