
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "exclude",
    "fullPath",
    "name",
    "path",
    "preset",
    "property",
    "root",
    "transformer",
    "transformers"
})
@Generated("jsonschema2pojo")
public class FieldPath implements Serializable
{

    @JsonProperty("exclude")
    private Boolean exclude;
    @JsonProperty("fullPath")
    private String fullPath;
    @JsonProperty("name")
    private String name;
    @JsonProperty("path")
    private List<String> path;
    @JsonProperty("preset")
    private Boolean preset;
    @JsonProperty("property")
    private Property property;
    @JsonProperty("root")
    private Boolean root;
    @JsonProperty("transformer")
    private Boolean transformer;
    @JsonProperty("transformers")
    private List<FieldPathTransformer> transformers;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5156508764440022096L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FieldPath() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public FieldPath(FieldPath source) {
        super();
        this.exclude = source.exclude;
        this.fullPath = source.fullPath;
        this.name = source.name;
        this.path = source.path;
        this.preset = source.preset;
        this.property = source.property;
        this.root = source.root;
        this.transformer = source.transformer;
        this.transformers = source.transformers;
    }

    public FieldPath(Boolean exclude, String fullPath, String name, List<String> path, Boolean preset, Property property, Boolean root, Boolean transformer, List<FieldPathTransformer> transformers) {
        super();
        this.exclude = exclude;
        this.fullPath = fullPath;
        this.name = name;
        this.path = path;
        this.preset = preset;
        this.property = property;
        this.root = root;
        this.transformer = transformer;
        this.transformers = transformers;
    }

    @JsonProperty("exclude")
    public Optional<Boolean> getExclude() {
        return Optional.ofNullable(exclude);
    }

    @JsonProperty("exclude")
    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    public FieldPath withExclude(Boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    @JsonProperty("fullPath")
    public Optional<String> getFullPath() {
        return Optional.ofNullable(fullPath);
    }

    @JsonProperty("fullPath")
    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public FieldPath withFullPath(String fullPath) {
        this.fullPath = fullPath;
        return this;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public FieldPath withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("path")
    public Optional<List<String>> getPath() {
        return Optional.ofNullable(path);
    }

    @JsonProperty("path")
    public void setPath(List<String> path) {
        this.path = path;
    }

    public FieldPath withPath(List<String> path) {
        this.path = path;
        return this;
    }

    @JsonProperty("preset")
    public Optional<Boolean> getPreset() {
        return Optional.ofNullable(preset);
    }

    @JsonProperty("preset")
    public void setPreset(Boolean preset) {
        this.preset = preset;
    }

    public FieldPath withPreset(Boolean preset) {
        this.preset = preset;
        return this;
    }

    @JsonProperty("property")
    public Optional<Property> getProperty() {
        return Optional.ofNullable(property);
    }

    @JsonProperty("property")
    public void setProperty(Property property) {
        this.property = property;
    }

    public FieldPath withProperty(Property property) {
        this.property = property;
        return this;
    }

    @JsonProperty("root")
    public Optional<Boolean> getRoot() {
        return Optional.ofNullable(root);
    }

    @JsonProperty("root")
    public void setRoot(Boolean root) {
        this.root = root;
    }

    public FieldPath withRoot(Boolean root) {
        this.root = root;
        return this;
    }

    @JsonProperty("transformer")
    public Optional<Boolean> getTransformer() {
        return Optional.ofNullable(transformer);
    }

    @JsonProperty("transformer")
    public void setTransformer(Boolean transformer) {
        this.transformer = transformer;
    }

    public FieldPath withTransformer(Boolean transformer) {
        this.transformer = transformer;
        return this;
    }

    @JsonProperty("transformers")
    public Optional<List<FieldPathTransformer>> getTransformers() {
        return Optional.ofNullable(transformers);
    }

    @JsonProperty("transformers")
    public void setTransformers(List<FieldPathTransformer> transformers) {
        this.transformers = transformers;
    }

    public FieldPath withTransformers(List<FieldPathTransformer> transformers) {
        this.transformers = transformers;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public FieldPath withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("exclude".equals(name)) {
            if (value instanceof Boolean) {
                setExclude(((Boolean) value));
            } else {
                throw new IllegalArgumentException(("property \"exclude\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("fullPath".equals(name)) {
                if (value instanceof String) {
                    setFullPath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"fullPath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("name".equals(name)) {
                    if (value instanceof String) {
                        setName(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"name\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("path".equals(name)) {
                        if (value instanceof List) {
                            setPath(((List<String> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"path\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("preset".equals(name)) {
                            if (value instanceof Boolean) {
                                setPreset(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"preset\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("property".equals(name)) {
                                if (value instanceof Property) {
                                    setProperty(((Property) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"property\" is of type \"org.hisp.dhis.api.model.v40_2_2.Property\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("root".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setRoot(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"root\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("transformer".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setTransformer(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"transformer\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("transformers".equals(name)) {
                                            if (value instanceof List) {
                                                setTransformers(((List<FieldPathTransformer> ) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"transformers\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.FieldPathTransformer>\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            return false;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("exclude".equals(name)) {
            return getExclude();
        } else {
            if ("fullPath".equals(name)) {
                return getFullPath();
            } else {
                if ("name".equals(name)) {
                    return getName();
                } else {
                    if ("path".equals(name)) {
                        return getPath();
                    } else {
                        if ("preset".equals(name)) {
                            return getPreset();
                        } else {
                            if ("property".equals(name)) {
                                return getProperty();
                            } else {
                                if ("root".equals(name)) {
                                    return getRoot();
                                } else {
                                    if ("transformer".equals(name)) {
                                        return getTransformer();
                                    } else {
                                        if ("transformers".equals(name)) {
                                            return getTransformers();
                                        } else {
                                            return notFoundValue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, FieldPath.NOT_FOUND_VALUE);
        if (FieldPath.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public FieldPath with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(FieldPath.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("exclude");
        sb.append('=');
        sb.append(((this.exclude == null)?"<null>":this.exclude));
        sb.append(',');
        sb.append("fullPath");
        sb.append('=');
        sb.append(((this.fullPath == null)?"<null>":this.fullPath));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("path");
        sb.append('=');
        sb.append(((this.path == null)?"<null>":this.path));
        sb.append(',');
        sb.append("preset");
        sb.append('=');
        sb.append(((this.preset == null)?"<null>":this.preset));
        sb.append(',');
        sb.append("property");
        sb.append('=');
        sb.append(((this.property == null)?"<null>":this.property));
        sb.append(',');
        sb.append("root");
        sb.append('=');
        sb.append(((this.root == null)?"<null>":this.root));
        sb.append(',');
        sb.append("transformer");
        sb.append('=');
        sb.append(((this.transformer == null)?"<null>":this.transformer));
        sb.append(',');
        sb.append("transformers");
        sb.append('=');
        sb.append(((this.transformers == null)?"<null>":this.transformers));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.fullPath == null)? 0 :this.fullPath.hashCode()));
        result = ((result* 31)+((this.path == null)? 0 :this.path.hashCode()));
        result = ((result* 31)+((this.transformers == null)? 0 :this.transformers.hashCode()));
        result = ((result* 31)+((this.root == null)? 0 :this.root.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.property == null)? 0 :this.property.hashCode()));
        result = ((result* 31)+((this.transformer == null)? 0 :this.transformer.hashCode()));
        result = ((result* 31)+((this.exclude == null)? 0 :this.exclude.hashCode()));
        result = ((result* 31)+((this.preset == null)? 0 :this.preset.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof FieldPath) == false) {
            return false;
        }
        FieldPath rhs = ((FieldPath) other);
        return (((((((((((this.fullPath == rhs.fullPath)||((this.fullPath!= null)&&this.fullPath.equals(rhs.fullPath)))&&((this.path == rhs.path)||((this.path!= null)&&this.path.equals(rhs.path))))&&((this.transformers == rhs.transformers)||((this.transformers!= null)&&this.transformers.equals(rhs.transformers))))&&((this.root == rhs.root)||((this.root!= null)&&this.root.equals(rhs.root))))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.property == rhs.property)||((this.property!= null)&&this.property.equals(rhs.property))))&&((this.transformer == rhs.transformer)||((this.transformer!= null)&&this.transformer.equals(rhs.transformer))))&&((this.exclude == rhs.exclude)||((this.exclude!= null)&&this.exclude.equals(rhs.exclude))))&&((this.preset == rhs.preset)||((this.preset!= null)&&this.preset.equals(rhs.preset))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))));
    }

}
