
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "description",
    "displayDescription",
    "expression",
    "missingValueStrategy",
    "slidingWindow",
    "translations"
})
@Generated("jsonschema2pojo")
public class Expression implements Serializable
{

    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("expression")
    private String expression;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("missingValueStrategy")
    private Expression.MissingValueStrategyRef missingValueStrategy;
    @JsonProperty("slidingWindow")
    private Boolean slidingWindow;
    @JsonProperty("translations")
    private List<Translation> translations;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 1538662518326857341L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Expression() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public Expression(Expression source) {
        super();
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.expression = source.expression;
        this.missingValueStrategy = source.missingValueStrategy;
        this.slidingWindow = source.slidingWindow;
        this.translations = source.translations;
    }

    public Expression(String description, String displayDescription, String expression, Expression.MissingValueStrategyRef missingValueStrategy, Boolean slidingWindow, List<Translation> translations) {
        super();
        this.description = description;
        this.displayDescription = displayDescription;
        this.expression = expression;
        this.missingValueStrategy = missingValueStrategy;
        this.slidingWindow = slidingWindow;
        this.translations = translations;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Expression withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public Expression withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("expression")
    public Optional<String> getExpression() {
        return Optional.ofNullable(expression);
    }

    @JsonProperty("expression")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Expression withExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("missingValueStrategy")
    public Expression.MissingValueStrategyRef getMissingValueStrategy() {
        return missingValueStrategy;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("missingValueStrategy")
    public void setMissingValueStrategy(Expression.MissingValueStrategyRef missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
    }

    public Expression withMissingValueStrategy(Expression.MissingValueStrategyRef missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    @JsonProperty("slidingWindow")
    public Optional<Boolean> getSlidingWindow() {
        return Optional.ofNullable(slidingWindow);
    }

    @JsonProperty("slidingWindow")
    public void setSlidingWindow(Boolean slidingWindow) {
        this.slidingWindow = slidingWindow;
    }

    public Expression withSlidingWindow(Boolean slidingWindow) {
        this.slidingWindow = slidingWindow;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public Expression withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Expression withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("description".equals(name)) {
            if (value instanceof String) {
                setDescription(((String) value));
            } else {
                throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("displayDescription".equals(name)) {
                if (value instanceof String) {
                    setDisplayDescription(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("expression".equals(name)) {
                    if (value instanceof String) {
                        setExpression(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"expression\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("missingValueStrategy".equals(name)) {
                        if (value instanceof Expression.MissingValueStrategyRef) {
                            setMissingValueStrategy(((Expression.MissingValueStrategyRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"missingValueStrategy\" is of type \"org.hisp.dhis.api.model.v40_2_2.Expression.MissingValueStrategyRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("slidingWindow".equals(name)) {
                            if (value instanceof Boolean) {
                                setSlidingWindow(((Boolean) value));
                            } else {
                                throw new IllegalArgumentException(("property \"slidingWindow\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("translations".equals(name)) {
                                if (value instanceof List) {
                                    setTranslations(((List<Translation> ) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("description".equals(name)) {
            return getDescription();
        } else {
            if ("displayDescription".equals(name)) {
                return getDisplayDescription();
            } else {
                if ("expression".equals(name)) {
                    return getExpression();
                } else {
                    if ("missingValueStrategy".equals(name)) {
                        return getMissingValueStrategy();
                    } else {
                        if ("slidingWindow".equals(name)) {
                            return getSlidingWindow();
                        } else {
                            if ("translations".equals(name)) {
                                return getTranslations();
                            } else {
                                return notFoundValue;
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, Expression.NOT_FOUND_VALUE);
        if (Expression.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public Expression with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Expression.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("expression");
        sb.append('=');
        sb.append(((this.expression == null)?"<null>":this.expression));
        sb.append(',');
        sb.append("missingValueStrategy");
        sb.append('=');
        sb.append(((this.missingValueStrategy == null)?"<null>":this.missingValueStrategy));
        sb.append(',');
        sb.append("slidingWindow");
        sb.append('=');
        sb.append(((this.slidingWindow == null)?"<null>":this.slidingWindow));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.expression == null)? 0 :this.expression.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.missingValueStrategy == null)? 0 :this.missingValueStrategy.hashCode()));
        result = ((result* 31)+((this.slidingWindow == null)? 0 :this.slidingWindow.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Expression) == false) {
            return false;
        }
        Expression rhs = ((Expression) other);
        return ((((((((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription)))&&((this.expression == rhs.expression)||((this.expression!= null)&&this.expression.equals(rhs.expression))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.missingValueStrategy == rhs.missingValueStrategy)||((this.missingValueStrategy!= null)&&this.missingValueStrategy.equals(rhs.missingValueStrategy))))&&((this.slidingWindow == rhs.slidingWindow)||((this.slidingWindow!= null)&&this.slidingWindow.equals(rhs.slidingWindow))));
    }

    @Generated("jsonschema2pojo")
    public enum MissingValueStrategyRef {

        SKIP_IF_ANY_VALUE_MISSING("SKIP_IF_ANY_VALUE_MISSING"),
        SKIP_IF_ALL_VALUES_MISSING("SKIP_IF_ALL_VALUES_MISSING"),
        NEVER_SKIP("NEVER_SKIP");
        private final String value;
        private final static Map<String, Expression.MissingValueStrategyRef> CONSTANTS = new HashMap<String, Expression.MissingValueStrategyRef>();

        static {
            for (Expression.MissingValueStrategyRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        MissingValueStrategyRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Expression.MissingValueStrategyRef fromValue(String value) {
            Expression.MissingValueStrategyRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
