
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "assignedUserMode",
    "assignedUsers",
    "attributeValueFilters",
    "displayColumnOrder",
    "enrollmentCreatedDate",
    "enrollmentIncidentDate",
    "enrollmentStatus",
    "eventDate",
    "eventStatus",
    "followUp",
    "lastUpdatedDate",
    "order",
    "organisationUnit",
    "ouMode",
    "programStage",
    "trackedEntityInstances",
    "trackedEntityType"
})
@Generated("jsonschema2pojo")
public class EntityQueryCriteria implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("assignedUserMode")
    private EntityQueryCriteria.AssignedUserModeRef assignedUserMode;
    @JsonProperty("assignedUsers")
    private List<String> assignedUsers;
    @JsonProperty("attributeValueFilters")
    private List<AttributeValueFilter> attributeValueFilters;
    @JsonProperty("displayColumnOrder")
    private List<String> displayColumnOrder;
    @JsonProperty("enrollmentCreatedDate")
    private DateFilterPeriod enrollmentCreatedDate;
    @JsonProperty("enrollmentIncidentDate")
    private DateFilterPeriod enrollmentIncidentDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    private EntityQueryCriteria.EnrollmentStatusRef enrollmentStatus;
    @JsonProperty("eventDate")
    private DateFilterPeriod eventDate;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventStatus")
    private EntityQueryCriteria.EventStatusRef eventStatus;
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("lastUpdatedDate")
    private DateFilterPeriod lastUpdatedDate;
    @JsonProperty("order")
    private String order;
    @JsonProperty("organisationUnit")
    private String organisationUnit;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ouMode")
    private EntityQueryCriteria.OuModeRef ouMode;
    @JsonProperty("programStage")
    private String programStage;
    @JsonProperty("trackedEntityInstances")
    private List<String> trackedEntityInstances;
    @JsonProperty("trackedEntityType")
    private String trackedEntityType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = 2859564850455796210L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EntityQueryCriteria() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public EntityQueryCriteria(EntityQueryCriteria source) {
        super();
        this.assignedUserMode = source.assignedUserMode;
        this.assignedUsers = source.assignedUsers;
        this.attributeValueFilters = source.attributeValueFilters;
        this.displayColumnOrder = source.displayColumnOrder;
        this.enrollmentCreatedDate = source.enrollmentCreatedDate;
        this.enrollmentIncidentDate = source.enrollmentIncidentDate;
        this.enrollmentStatus = source.enrollmentStatus;
        this.eventDate = source.eventDate;
        this.eventStatus = source.eventStatus;
        this.followUp = source.followUp;
        this.lastUpdatedDate = source.lastUpdatedDate;
        this.order = source.order;
        this.organisationUnit = source.organisationUnit;
        this.ouMode = source.ouMode;
        this.programStage = source.programStage;
        this.trackedEntityInstances = source.trackedEntityInstances;
        this.trackedEntityType = source.trackedEntityType;
    }

    public EntityQueryCriteria(EntityQueryCriteria.AssignedUserModeRef assignedUserMode, List<String> assignedUsers, List<AttributeValueFilter> attributeValueFilters, List<String> displayColumnOrder, DateFilterPeriod enrollmentCreatedDate, DateFilterPeriod enrollmentIncidentDate, EntityQueryCriteria.EnrollmentStatusRef enrollmentStatus, DateFilterPeriod eventDate, EntityQueryCriteria.EventStatusRef eventStatus, Boolean followUp, DateFilterPeriod lastUpdatedDate, String order, String organisationUnit, EntityQueryCriteria.OuModeRef ouMode, String programStage, List<String> trackedEntityInstances, String trackedEntityType) {
        super();
        this.assignedUserMode = assignedUserMode;
        this.assignedUsers = assignedUsers;
        this.attributeValueFilters = attributeValueFilters;
        this.displayColumnOrder = displayColumnOrder;
        this.enrollmentCreatedDate = enrollmentCreatedDate;
        this.enrollmentIncidentDate = enrollmentIncidentDate;
        this.enrollmentStatus = enrollmentStatus;
        this.eventDate = eventDate;
        this.eventStatus = eventStatus;
        this.followUp = followUp;
        this.lastUpdatedDate = lastUpdatedDate;
        this.order = order;
        this.organisationUnit = organisationUnit;
        this.ouMode = ouMode;
        this.programStage = programStage;
        this.trackedEntityInstances = trackedEntityInstances;
        this.trackedEntityType = trackedEntityType;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("assignedUserMode")
    public EntityQueryCriteria.AssignedUserModeRef getAssignedUserMode() {
        return assignedUserMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("assignedUserMode")
    public void setAssignedUserMode(EntityQueryCriteria.AssignedUserModeRef assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
    }

    public EntityQueryCriteria withAssignedUserMode(EntityQueryCriteria.AssignedUserModeRef assignedUserMode) {
        this.assignedUserMode = assignedUserMode;
        return this;
    }

    @JsonProperty("assignedUsers")
    public Optional<List<String>> getAssignedUsers() {
        return Optional.ofNullable(assignedUsers);
    }

    @JsonProperty("assignedUsers")
    public void setAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
    }

    public EntityQueryCriteria withAssignedUsers(List<String> assignedUsers) {
        this.assignedUsers = assignedUsers;
        return this;
    }

    @JsonProperty("attributeValueFilters")
    public Optional<List<AttributeValueFilter>> getAttributeValueFilters() {
        return Optional.ofNullable(attributeValueFilters);
    }

    @JsonProperty("attributeValueFilters")
    public void setAttributeValueFilters(List<AttributeValueFilter> attributeValueFilters) {
        this.attributeValueFilters = attributeValueFilters;
    }

    public EntityQueryCriteria withAttributeValueFilters(List<AttributeValueFilter> attributeValueFilters) {
        this.attributeValueFilters = attributeValueFilters;
        return this;
    }

    @JsonProperty("displayColumnOrder")
    public Optional<List<String>> getDisplayColumnOrder() {
        return Optional.ofNullable(displayColumnOrder);
    }

    @JsonProperty("displayColumnOrder")
    public void setDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
    }

    public EntityQueryCriteria withDisplayColumnOrder(List<String> displayColumnOrder) {
        this.displayColumnOrder = displayColumnOrder;
        return this;
    }

    @JsonProperty("enrollmentCreatedDate")
    public Optional<DateFilterPeriod> getEnrollmentCreatedDate() {
        return Optional.ofNullable(enrollmentCreatedDate);
    }

    @JsonProperty("enrollmentCreatedDate")
    public void setEnrollmentCreatedDate(DateFilterPeriod enrollmentCreatedDate) {
        this.enrollmentCreatedDate = enrollmentCreatedDate;
    }

    public EntityQueryCriteria withEnrollmentCreatedDate(DateFilterPeriod enrollmentCreatedDate) {
        this.enrollmentCreatedDate = enrollmentCreatedDate;
        return this;
    }

    @JsonProperty("enrollmentIncidentDate")
    public Optional<DateFilterPeriod> getEnrollmentIncidentDate() {
        return Optional.ofNullable(enrollmentIncidentDate);
    }

    @JsonProperty("enrollmentIncidentDate")
    public void setEnrollmentIncidentDate(DateFilterPeriod enrollmentIncidentDate) {
        this.enrollmentIncidentDate = enrollmentIncidentDate;
    }

    public EntityQueryCriteria withEnrollmentIncidentDate(DateFilterPeriod enrollmentIncidentDate) {
        this.enrollmentIncidentDate = enrollmentIncidentDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    public EntityQueryCriteria.EnrollmentStatusRef getEnrollmentStatus() {
        return enrollmentStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("enrollmentStatus")
    public void setEnrollmentStatus(EntityQueryCriteria.EnrollmentStatusRef enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public EntityQueryCriteria withEnrollmentStatus(EntityQueryCriteria.EnrollmentStatusRef enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
        return this;
    }

    @JsonProperty("eventDate")
    public Optional<DateFilterPeriod> getEventDate() {
        return Optional.ofNullable(eventDate);
    }

    @JsonProperty("eventDate")
    public void setEventDate(DateFilterPeriod eventDate) {
        this.eventDate = eventDate;
    }

    public EntityQueryCriteria withEventDate(DateFilterPeriod eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventStatus")
    public EntityQueryCriteria.EventStatusRef getEventStatus() {
        return eventStatus;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("eventStatus")
    public void setEventStatus(EntityQueryCriteria.EventStatusRef eventStatus) {
        this.eventStatus = eventStatus;
    }

    public EntityQueryCriteria withEventStatus(EntityQueryCriteria.EventStatusRef eventStatus) {
        this.eventStatus = eventStatus;
        return this;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public EntityQueryCriteria withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("lastUpdatedDate")
    public Optional<DateFilterPeriod> getLastUpdatedDate() {
        return Optional.ofNullable(lastUpdatedDate);
    }

    @JsonProperty("lastUpdatedDate")
    public void setLastUpdatedDate(DateFilterPeriod lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public EntityQueryCriteria withLastUpdatedDate(DateFilterPeriod lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @JsonProperty("order")
    public Optional<String> getOrder() {
        return Optional.ofNullable(order);
    }

    @JsonProperty("order")
    public void setOrder(String order) {
        this.order = order;
    }

    public EntityQueryCriteria withOrder(String order) {
        this.order = order;
        return this;
    }

    @JsonProperty("organisationUnit")
    public Optional<String> getOrganisationUnit() {
        return Optional.ofNullable(organisationUnit);
    }

    @JsonProperty("organisationUnit")
    public void setOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public EntityQueryCriteria withOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ouMode")
    public EntityQueryCriteria.OuModeRef getOuMode() {
        return ouMode;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("ouMode")
    public void setOuMode(EntityQueryCriteria.OuModeRef ouMode) {
        this.ouMode = ouMode;
    }

    public EntityQueryCriteria withOuMode(EntityQueryCriteria.OuModeRef ouMode) {
        this.ouMode = ouMode;
        return this;
    }

    @JsonProperty("programStage")
    public Optional<String> getProgramStage() {
        return Optional.ofNullable(programStage);
    }

    @JsonProperty("programStage")
    public void setProgramStage(String programStage) {
        this.programStage = programStage;
    }

    public EntityQueryCriteria withProgramStage(String programStage) {
        this.programStage = programStage;
        return this;
    }

    @JsonProperty("trackedEntityInstances")
    public Optional<List<String>> getTrackedEntityInstances() {
        return Optional.ofNullable(trackedEntityInstances);
    }

    @JsonProperty("trackedEntityInstances")
    public void setTrackedEntityInstances(List<String> trackedEntityInstances) {
        this.trackedEntityInstances = trackedEntityInstances;
    }

    public EntityQueryCriteria withTrackedEntityInstances(List<String> trackedEntityInstances) {
        this.trackedEntityInstances = trackedEntityInstances;
        return this;
    }

    @JsonProperty("trackedEntityType")
    public Optional<String> getTrackedEntityType() {
        return Optional.ofNullable(trackedEntityType);
    }

    @JsonProperty("trackedEntityType")
    public void setTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
    }

    public EntityQueryCriteria withTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = trackedEntityType;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public EntityQueryCriteria withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("assignedUserMode".equals(name)) {
            if (value instanceof EntityQueryCriteria.AssignedUserModeRef) {
                setAssignedUserMode(((EntityQueryCriteria.AssignedUserModeRef) value));
            } else {
                throw new IllegalArgumentException(("property \"assignedUserMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.EntityQueryCriteria.AssignedUserModeRef\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("assignedUsers".equals(name)) {
                if (value instanceof List) {
                    setAssignedUsers(((List<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"assignedUsers\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValueFilters".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValueFilters(((List<AttributeValueFilter> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValueFilters\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValueFilter>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("displayColumnOrder".equals(name)) {
                        if (value instanceof List) {
                            setDisplayColumnOrder(((List<String> ) value));
                        } else {
                            throw new IllegalArgumentException(("property \"displayColumnOrder\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("enrollmentCreatedDate".equals(name)) {
                            if (value instanceof DateFilterPeriod) {
                                setEnrollmentCreatedDate(((DateFilterPeriod) value));
                            } else {
                                throw new IllegalArgumentException(("property \"enrollmentCreatedDate\" is of type \"org.hisp.dhis.api.model.v40_2_2.DateFilterPeriod\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("enrollmentIncidentDate".equals(name)) {
                                if (value instanceof DateFilterPeriod) {
                                    setEnrollmentIncidentDate(((DateFilterPeriod) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"enrollmentIncidentDate\" is of type \"org.hisp.dhis.api.model.v40_2_2.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("enrollmentStatus".equals(name)) {
                                    if (value instanceof EntityQueryCriteria.EnrollmentStatusRef) {
                                        setEnrollmentStatus(((EntityQueryCriteria.EnrollmentStatusRef) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"enrollmentStatus\" is of type \"org.hisp.dhis.api.model.v40_2_2.EntityQueryCriteria.EnrollmentStatusRef\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("eventDate".equals(name)) {
                                        if (value instanceof DateFilterPeriod) {
                                            setEventDate(((DateFilterPeriod) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"eventDate\" is of type \"org.hisp.dhis.api.model.v40_2_2.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("eventStatus".equals(name)) {
                                            if (value instanceof EntityQueryCriteria.EventStatusRef) {
                                                setEventStatus(((EntityQueryCriteria.EventStatusRef) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"eventStatus\" is of type \"org.hisp.dhis.api.model.v40_2_2.EntityQueryCriteria.EventStatusRef\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("followUp".equals(name)) {
                                                if (value instanceof Boolean) {
                                                    setFollowUp(((Boolean) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("lastUpdatedDate".equals(name)) {
                                                    if (value instanceof DateFilterPeriod) {
                                                        setLastUpdatedDate(((DateFilterPeriod) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"lastUpdatedDate\" is of type \"org.hisp.dhis.api.model.v40_2_2.DateFilterPeriod\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("order".equals(name)) {
                                                        if (value instanceof String) {
                                                            setOrder(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"order\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("organisationUnit".equals(name)) {
                                                            if (value instanceof String) {
                                                                setOrganisationUnit(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"organisationUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("ouMode".equals(name)) {
                                                                if (value instanceof EntityQueryCriteria.OuModeRef) {
                                                                    setOuMode(((EntityQueryCriteria.OuModeRef) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"ouMode\" is of type \"org.hisp.dhis.api.model.v40_2_2.EntityQueryCriteria.OuModeRef\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("programStage".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setProgramStage(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"programStage\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("trackedEntityInstances".equals(name)) {
                                                                        if (value instanceof List) {
                                                                            setTrackedEntityInstances(((List<String> ) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"trackedEntityInstances\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("trackedEntityType".equals(name)) {
                                                                            if (value instanceof String) {
                                                                                setTrackedEntityType(((String) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"trackedEntityType\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            return false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("assignedUserMode".equals(name)) {
            return getAssignedUserMode();
        } else {
            if ("assignedUsers".equals(name)) {
                return getAssignedUsers();
            } else {
                if ("attributeValueFilters".equals(name)) {
                    return getAttributeValueFilters();
                } else {
                    if ("displayColumnOrder".equals(name)) {
                        return getDisplayColumnOrder();
                    } else {
                        if ("enrollmentCreatedDate".equals(name)) {
                            return getEnrollmentCreatedDate();
                        } else {
                            if ("enrollmentIncidentDate".equals(name)) {
                                return getEnrollmentIncidentDate();
                            } else {
                                if ("enrollmentStatus".equals(name)) {
                                    return getEnrollmentStatus();
                                } else {
                                    if ("eventDate".equals(name)) {
                                        return getEventDate();
                                    } else {
                                        if ("eventStatus".equals(name)) {
                                            return getEventStatus();
                                        } else {
                                            if ("followUp".equals(name)) {
                                                return getFollowUp();
                                            } else {
                                                if ("lastUpdatedDate".equals(name)) {
                                                    return getLastUpdatedDate();
                                                } else {
                                                    if ("order".equals(name)) {
                                                        return getOrder();
                                                    } else {
                                                        if ("organisationUnit".equals(name)) {
                                                            return getOrganisationUnit();
                                                        } else {
                                                            if ("ouMode".equals(name)) {
                                                                return getOuMode();
                                                            } else {
                                                                if ("programStage".equals(name)) {
                                                                    return getProgramStage();
                                                                } else {
                                                                    if ("trackedEntityInstances".equals(name)) {
                                                                        return getTrackedEntityInstances();
                                                                    } else {
                                                                        if ("trackedEntityType".equals(name)) {
                                                                            return getTrackedEntityType();
                                                                        } else {
                                                                            return notFoundValue;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, EntityQueryCriteria.NOT_FOUND_VALUE);
        if (EntityQueryCriteria.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public EntityQueryCriteria with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EntityQueryCriteria.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("assignedUserMode");
        sb.append('=');
        sb.append(((this.assignedUserMode == null)?"<null>":this.assignedUserMode));
        sb.append(',');
        sb.append("assignedUsers");
        sb.append('=');
        sb.append(((this.assignedUsers == null)?"<null>":this.assignedUsers));
        sb.append(',');
        sb.append("attributeValueFilters");
        sb.append('=');
        sb.append(((this.attributeValueFilters == null)?"<null>":this.attributeValueFilters));
        sb.append(',');
        sb.append("displayColumnOrder");
        sb.append('=');
        sb.append(((this.displayColumnOrder == null)?"<null>":this.displayColumnOrder));
        sb.append(',');
        sb.append("enrollmentCreatedDate");
        sb.append('=');
        sb.append(((this.enrollmentCreatedDate == null)?"<null>":this.enrollmentCreatedDate));
        sb.append(',');
        sb.append("enrollmentIncidentDate");
        sb.append('=');
        sb.append(((this.enrollmentIncidentDate == null)?"<null>":this.enrollmentIncidentDate));
        sb.append(',');
        sb.append("enrollmentStatus");
        sb.append('=');
        sb.append(((this.enrollmentStatus == null)?"<null>":this.enrollmentStatus));
        sb.append(',');
        sb.append("eventDate");
        sb.append('=');
        sb.append(((this.eventDate == null)?"<null>":this.eventDate));
        sb.append(',');
        sb.append("eventStatus");
        sb.append('=');
        sb.append(((this.eventStatus == null)?"<null>":this.eventStatus));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("lastUpdatedDate");
        sb.append('=');
        sb.append(((this.lastUpdatedDate == null)?"<null>":this.lastUpdatedDate));
        sb.append(',');
        sb.append("order");
        sb.append('=');
        sb.append(((this.order == null)?"<null>":this.order));
        sb.append(',');
        sb.append("organisationUnit");
        sb.append('=');
        sb.append(((this.organisationUnit == null)?"<null>":this.organisationUnit));
        sb.append(',');
        sb.append("ouMode");
        sb.append('=');
        sb.append(((this.ouMode == null)?"<null>":this.ouMode));
        sb.append(',');
        sb.append("programStage");
        sb.append('=');
        sb.append(((this.programStage == null)?"<null>":this.programStage));
        sb.append(',');
        sb.append("trackedEntityInstances");
        sb.append('=');
        sb.append(((this.trackedEntityInstances == null)?"<null>":this.trackedEntityInstances));
        sb.append(',');
        sb.append("trackedEntityType");
        sb.append('=');
        sb.append(((this.trackedEntityType == null)?"<null>":this.trackedEntityType));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.assignedUserMode == null)? 0 :this.assignedUserMode.hashCode()));
        result = ((result* 31)+((this.programStage == null)? 0 :this.programStage.hashCode()));
        result = ((result* 31)+((this.organisationUnit == null)? 0 :this.organisationUnit.hashCode()));
        result = ((result* 31)+((this.enrollmentIncidentDate == null)? 0 :this.enrollmentIncidentDate.hashCode()));
        result = ((result* 31)+((this.trackedEntityInstances == null)? 0 :this.trackedEntityInstances.hashCode()));
        result = ((result* 31)+((this.assignedUsers == null)? 0 :this.assignedUsers.hashCode()));
        result = ((result* 31)+((this.enrollmentCreatedDate == null)? 0 :this.enrollmentCreatedDate.hashCode()));
        result = ((result* 31)+((this.attributeValueFilters == null)? 0 :this.attributeValueFilters.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.lastUpdatedDate == null)? 0 :this.lastUpdatedDate.hashCode()));
        result = ((result* 31)+((this.trackedEntityType == null)? 0 :this.trackedEntityType.hashCode()));
        result = ((result* 31)+((this.enrollmentStatus == null)? 0 :this.enrollmentStatus.hashCode()));
        result = ((result* 31)+((this.ouMode == null)? 0 :this.ouMode.hashCode()));
        result = ((result* 31)+((this.displayColumnOrder == null)? 0 :this.displayColumnOrder.hashCode()));
        result = ((result* 31)+((this.eventStatus == null)? 0 :this.eventStatus.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.eventDate == null)? 0 :this.eventDate.hashCode()));
        result = ((result* 31)+((this.order == null)? 0 :this.order.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof EntityQueryCriteria) == false) {
            return false;
        }
        EntityQueryCriteria rhs = ((EntityQueryCriteria) other);
        return (((((((((((((((((((this.assignedUserMode == rhs.assignedUserMode)||((this.assignedUserMode!= null)&&this.assignedUserMode.equals(rhs.assignedUserMode)))&&((this.programStage == rhs.programStage)||((this.programStage!= null)&&this.programStage.equals(rhs.programStage))))&&((this.organisationUnit == rhs.organisationUnit)||((this.organisationUnit!= null)&&this.organisationUnit.equals(rhs.organisationUnit))))&&((this.enrollmentIncidentDate == rhs.enrollmentIncidentDate)||((this.enrollmentIncidentDate!= null)&&this.enrollmentIncidentDate.equals(rhs.enrollmentIncidentDate))))&&((this.trackedEntityInstances == rhs.trackedEntityInstances)||((this.trackedEntityInstances!= null)&&this.trackedEntityInstances.equals(rhs.trackedEntityInstances))))&&((this.assignedUsers == rhs.assignedUsers)||((this.assignedUsers!= null)&&this.assignedUsers.equals(rhs.assignedUsers))))&&((this.enrollmentCreatedDate == rhs.enrollmentCreatedDate)||((this.enrollmentCreatedDate!= null)&&this.enrollmentCreatedDate.equals(rhs.enrollmentCreatedDate))))&&((this.attributeValueFilters == rhs.attributeValueFilters)||((this.attributeValueFilters!= null)&&this.attributeValueFilters.equals(rhs.attributeValueFilters))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.lastUpdatedDate == rhs.lastUpdatedDate)||((this.lastUpdatedDate!= null)&&this.lastUpdatedDate.equals(rhs.lastUpdatedDate))))&&((this.trackedEntityType == rhs.trackedEntityType)||((this.trackedEntityType!= null)&&this.trackedEntityType.equals(rhs.trackedEntityType))))&&((this.enrollmentStatus == rhs.enrollmentStatus)||((this.enrollmentStatus!= null)&&this.enrollmentStatus.equals(rhs.enrollmentStatus))))&&((this.ouMode == rhs.ouMode)||((this.ouMode!= null)&&this.ouMode.equals(rhs.ouMode))))&&((this.displayColumnOrder == rhs.displayColumnOrder)||((this.displayColumnOrder!= null)&&this.displayColumnOrder.equals(rhs.displayColumnOrder))))&&((this.eventStatus == rhs.eventStatus)||((this.eventStatus!= null)&&this.eventStatus.equals(rhs.eventStatus))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.eventDate == rhs.eventDate)||((this.eventDate!= null)&&this.eventDate.equals(rhs.eventDate))))&&((this.order == rhs.order)||((this.order!= null)&&this.order.equals(rhs.order))));
    }

    @Generated("jsonschema2pojo")
    public enum AssignedUserModeRef {

        CURRENT("CURRENT"),
        PROVIDED("PROVIDED"),
        NONE("NONE"),
        ANY("ANY"),
        ALL("ALL");
        private final String value;
        private final static Map<String, EntityQueryCriteria.AssignedUserModeRef> CONSTANTS = new HashMap<String, EntityQueryCriteria.AssignedUserModeRef>();

        static {
            for (EntityQueryCriteria.AssignedUserModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AssignedUserModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EntityQueryCriteria.AssignedUserModeRef fromValue(String value) {
            EntityQueryCriteria.AssignedUserModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum EnrollmentStatusRef {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        CANCELLED("CANCELLED");
        private final String value;
        private final static Map<String, EntityQueryCriteria.EnrollmentStatusRef> CONSTANTS = new HashMap<String, EntityQueryCriteria.EnrollmentStatusRef>();

        static {
            for (EntityQueryCriteria.EnrollmentStatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        EnrollmentStatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EntityQueryCriteria.EnrollmentStatusRef fromValue(String value) {
            EntityQueryCriteria.EnrollmentStatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum EventStatusRef {

        ACTIVE("ACTIVE"),
        COMPLETED("COMPLETED"),
        VISITED("VISITED"),
        SCHEDULE("SCHEDULE"),
        OVERDUE("OVERDUE"),
        SKIPPED("SKIPPED");
        private final String value;
        private final static Map<String, EntityQueryCriteria.EventStatusRef> CONSTANTS = new HashMap<String, EntityQueryCriteria.EventStatusRef>();

        static {
            for (EntityQueryCriteria.EventStatusRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        EventStatusRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EntityQueryCriteria.EventStatusRef fromValue(String value) {
            EntityQueryCriteria.EventStatusRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum OuModeRef {

        SELECTED("SELECTED"),
        CHILDREN("CHILDREN"),
        DESCENDANTS("DESCENDANTS"),
        ACCESSIBLE("ACCESSIBLE"),
        CAPTURE("CAPTURE"),
        ALL("ALL");
        private final String value;
        private final static Map<String, EntityQueryCriteria.OuModeRef> CONSTANTS = new HashMap<String, EntityQueryCriteria.OuModeRef>();

        static {
            for (EntityQueryCriteria.OuModeRef c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        OuModeRef(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static EntityQueryCriteria.OuModeRef fromValue(String value) {
            EntityQueryCriteria.OuModeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
