
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "attribute",
    "categoryOptionCombo",
    "comment",
    "created",
    "dataElement",
    "dataSet",
    "followUp",
    "force",
    "lastUpdated",
    "orgUnit",
    "period",
    "storedBy",
    "value"
})
@Generated("jsonschema2pojo")
public class DataValueDto implements Serializable
{

    @JsonProperty("attribute")
    private DataValueCategoryDto attribute;
    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    @JsonPropertyDescription("A UID for an CategoryOptionCombo object  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private String categoryOptionCombo;
    @JsonProperty("comment")
    private String comment;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID for an DataElement object  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private String dataElement;
    /**
     * A UID for an DataSet object  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    @JsonPropertyDescription("A UID for an DataSet object  \n(Java name `org.hisp.dhis.dataset.DataSet`)")
    private String dataSet;
    @JsonProperty("followUp")
    private Boolean followUp;
    @JsonProperty("force")
    private Boolean force;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    @JsonPropertyDescription("A UID for an OrganisationUnit object  \n(Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)")
    private String orgUnit;
    @JsonProperty("period")
    private String period;
    @JsonProperty("storedBy")
    private String storedBy;
    @JsonProperty("value")
    private String value;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -5096046306268090795L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataValueDto() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataValueDto(DataValueDto source) {
        super();
        this.attribute = source.attribute;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.comment = source.comment;
        this.created = source.created;
        this.dataElement = source.dataElement;
        this.dataSet = source.dataSet;
        this.followUp = source.followUp;
        this.force = source.force;
        this.lastUpdated = source.lastUpdated;
        this.orgUnit = source.orgUnit;
        this.period = source.period;
        this.storedBy = source.storedBy;
        this.value = source.value;
    }

    /**
     * 
     * @param orgUnit
     *     A UID for an OrganisationUnit object  
     *     (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`).
     * @param categoryOptionCombo
     *     A UID for an CategoryOptionCombo object  
     *     (Java name `org.hisp.dhis.category.CategoryOptionCombo`).
     * @param dataElement
     *     A UID for an DataElement object  
     *     (Java name `org.hisp.dhis.dataelement.DataElement`).
     * @param dataSet
     *     A UID for an DataSet object  
     *     (Java name `org.hisp.dhis.dataset.DataSet`).
     */
    public DataValueDto(DataValueCategoryDto attribute, String categoryOptionCombo, String comment, Date created, String dataElement, String dataSet, Boolean followUp, Boolean force, Date lastUpdated, String orgUnit, String period, String storedBy, String value) {
        super();
        this.attribute = attribute;
        this.categoryOptionCombo = categoryOptionCombo;
        this.comment = comment;
        this.created = created;
        this.dataElement = dataElement;
        this.dataSet = dataSet;
        this.followUp = followUp;
        this.force = force;
        this.lastUpdated = lastUpdated;
        this.orgUnit = orgUnit;
        this.period = period;
        this.storedBy = storedBy;
        this.value = value;
    }

    @JsonProperty("attribute")
    public Optional<DataValueCategoryDto> getAttribute() {
        return Optional.ofNullable(attribute);
    }

    @JsonProperty("attribute")
    public void setAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
    }

    public DataValueDto withAttribute(DataValueCategoryDto attribute) {
        this.attribute = attribute;
        return this;
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public Optional<String> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    /**
     * A UID for an CategoryOptionCombo object  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataValueDto withCategoryOptionCombo(String categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("comment")
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    @JsonProperty("comment")
    public void setComment(String comment) {
        this.comment = comment;
    }

    public DataValueDto withComment(String comment) {
        this.comment = comment;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataValueDto withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<String> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID for an DataElement object  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(String dataElement) {
        this.dataElement = dataElement;
    }

    public DataValueDto withDataElement(String dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    /**
     * A UID for an DataSet object  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    public Optional<String> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    /**
     * A UID for an DataSet object  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public DataValueDto withDataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonProperty("followUp")
    public Optional<Boolean> getFollowUp() {
        return Optional.ofNullable(followUp);
    }

    @JsonProperty("followUp")
    public void setFollowUp(Boolean followUp) {
        this.followUp = followUp;
    }

    public DataValueDto withFollowUp(Boolean followUp) {
        this.followUp = followUp;
        return this;
    }

    @JsonProperty("force")
    public Optional<Boolean> getForce() {
        return Optional.ofNullable(force);
    }

    @JsonProperty("force")
    public void setForce(Boolean force) {
        this.force = force;
    }

    public DataValueDto withForce(Boolean force) {
        this.force = force;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataValueDto withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public Optional<String> getOrgUnit() {
        return Optional.ofNullable(orgUnit);
    }

    /**
     * A UID for an OrganisationUnit object  
     * (Java name `org.hisp.dhis.organisationunit.OrganisationUnit`)
     * 
     */
    @JsonProperty("orgUnit")
    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public DataValueDto withOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
        return this;
    }

    @JsonProperty("period")
    public Optional<String> getPeriod() {
        return Optional.ofNullable(period);
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    public DataValueDto withPeriod(String period) {
        this.period = period;
        return this;
    }

    @JsonProperty("storedBy")
    public Optional<String> getStoredBy() {
        return Optional.ofNullable(storedBy);
    }

    @JsonProperty("storedBy")
    public void setStoredBy(String storedBy) {
        this.storedBy = storedBy;
    }

    public DataValueDto withStoredBy(String storedBy) {
        this.storedBy = storedBy;
        return this;
    }

    @JsonProperty("value")
    public Optional<String> getValue() {
        return Optional.ofNullable(value);
    }

    @JsonProperty("value")
    public void setValue(String value) {
        this.value = value;
    }

    public DataValueDto withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataValueDto withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("attribute".equals(name)) {
            if (value instanceof DataValueCategoryDto) {
                setAttribute(((DataValueCategoryDto) value));
            } else {
                throw new IllegalArgumentException(("property \"attribute\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataValueCategoryDto\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("categoryOptionCombo".equals(name)) {
                if (value instanceof String) {
                    setCategoryOptionCombo(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("comment".equals(name)) {
                    if (value instanceof String) {
                        setComment(((String) value));
                    } else {
                        throw new IllegalArgumentException(("property \"comment\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("created".equals(name)) {
                        if (value instanceof Date) {
                            setCreated(((Date) value));
                        } else {
                            throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("dataElement".equals(name)) {
                            if (value instanceof String) {
                                setDataElement(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"dataElement\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("dataSet".equals(name)) {
                                if (value instanceof String) {
                                    setDataSet(((String) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"dataSet\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("followUp".equals(name)) {
                                    if (value instanceof Boolean) {
                                        setFollowUp(((Boolean) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"followUp\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("force".equals(name)) {
                                        if (value instanceof Boolean) {
                                            setForce(((Boolean) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"force\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("lastUpdated".equals(name)) {
                                            if (value instanceof Date) {
                                                setLastUpdated(((Date) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("orgUnit".equals(name)) {
                                                if (value instanceof String) {
                                                    setOrgUnit(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"orgUnit\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("period".equals(name)) {
                                                    if (value instanceof String) {
                                                        setPeriod(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"period\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("storedBy".equals(name)) {
                                                        if (value instanceof String) {
                                                            setStoredBy(((String) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"storedBy\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("value".equals(name)) {
                                                            if (value instanceof String) {
                                                                setValue(((String) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"value\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            return false;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("attribute".equals(name)) {
            return getAttribute();
        } else {
            if ("categoryOptionCombo".equals(name)) {
                return getCategoryOptionCombo();
            } else {
                if ("comment".equals(name)) {
                    return getComment();
                } else {
                    if ("created".equals(name)) {
                        return getCreated();
                    } else {
                        if ("dataElement".equals(name)) {
                            return getDataElement();
                        } else {
                            if ("dataSet".equals(name)) {
                                return getDataSet();
                            } else {
                                if ("followUp".equals(name)) {
                                    return getFollowUp();
                                } else {
                                    if ("force".equals(name)) {
                                        return getForce();
                                    } else {
                                        if ("lastUpdated".equals(name)) {
                                            return getLastUpdated();
                                        } else {
                                            if ("orgUnit".equals(name)) {
                                                return getOrgUnit();
                                            } else {
                                                if ("period".equals(name)) {
                                                    return getPeriod();
                                                } else {
                                                    if ("storedBy".equals(name)) {
                                                        return getStoredBy();
                                                    } else {
                                                        if ("value".equals(name)) {
                                                            return getValue();
                                                        } else {
                                                            return notFoundValue;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataValueDto.NOT_FOUND_VALUE);
        if (DataValueDto.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataValueDto with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataValueDto.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("attribute");
        sb.append('=');
        sb.append(((this.attribute == null)?"<null>":this.attribute));
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("comment");
        sb.append('=');
        sb.append(((this.comment == null)?"<null>":this.comment));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("followUp");
        sb.append('=');
        sb.append(((this.followUp == null)?"<null>":this.followUp));
        sb.append(',');
        sb.append("force");
        sb.append('=');
        sb.append(((this.force == null)?"<null>":this.force));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("orgUnit");
        sb.append('=');
        sb.append(((this.orgUnit == null)?"<null>":this.orgUnit));
        sb.append(',');
        sb.append("period");
        sb.append('=');
        sb.append(((this.period == null)?"<null>":this.period));
        sb.append(',');
        sb.append("storedBy");
        sb.append('=');
        sb.append(((this.storedBy == null)?"<null>":this.storedBy));
        sb.append(',');
        sb.append("value");
        sb.append('=');
        sb.append(((this.value == null)?"<null>":this.value));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.period == null)? 0 :this.period.hashCode()));
        result = ((result* 31)+((this.storedBy == null)? 0 :this.storedBy.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.orgUnit == null)? 0 :this.orgUnit.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.followUp == null)? 0 :this.followUp.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.comment == null)? 0 :this.comment.hashCode()));
        result = ((result* 31)+((this.force == null)? 0 :this.force.hashCode()));
        result = ((result* 31)+((this.attribute == null)? 0 :this.attribute.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        result = ((result* 31)+((this.value == null)? 0 :this.value.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataValueDto) == false) {
            return false;
        }
        DataValueDto rhs = ((DataValueDto) other);
        return (((((((((((((((this.period == rhs.period)||((this.period!= null)&&this.period.equals(rhs.period)))&&((this.storedBy == rhs.storedBy)||((this.storedBy!= null)&&this.storedBy.equals(rhs.storedBy))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.orgUnit == rhs.orgUnit)||((this.orgUnit!= null)&&this.orgUnit.equals(rhs.orgUnit))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.followUp == rhs.followUp)||((this.followUp!= null)&&this.followUp.equals(rhs.followUp))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.comment == rhs.comment)||((this.comment!= null)&&this.comment.equals(rhs.comment))))&&((this.force == rhs.force)||((this.force!= null)&&this.force.equals(rhs.force))))&&((this.attribute == rhs.attribute)||((this.attribute!= null)&&this.attribute.equals(rhs.attribute))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))))&&((this.value == rhs.value)||((this.value!= null)&&this.value.equals(rhs.value))));
    }

}
