
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "categoryCombo",
    "dataElement",
    "dataSet"
})
@Generated("jsonschema2pojo")
public class DataSetElement implements Serializable
{

    /**
     * A UID reference to a CategoryCombo  
     * (Java name `org.hisp.dhis.category.CategoryCombo`)
     * 
     */
    @JsonProperty("categoryCombo")
    @JsonPropertyDescription("A UID reference to a CategoryCombo  \n(Java name `org.hisp.dhis.category.CategoryCombo`)")
    private CategoryComboRef__3 categoryCombo;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private DataElementRef__3 dataElement;
    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    @JsonPropertyDescription("A UID reference to a DataSet  \n(Java name `org.hisp.dhis.dataset.DataSet`)")
    private DataSetRef__1 dataSet;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8316728506150915626L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataSetElement() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataSetElement(DataSetElement source) {
        super();
        this.categoryCombo = source.categoryCombo;
        this.dataElement = source.dataElement;
        this.dataSet = source.dataSet;
    }

    /**
     * 
     * @param categoryCombo
     *     A UID reference to a CategoryCombo  
     *     (Java name `org.hisp.dhis.category.CategoryCombo`).
     * @param dataElement
     *     A UID reference to a DataElement  
     *     (Java name `org.hisp.dhis.dataelement.DataElement`).
     * @param dataSet
     *     A UID reference to a DataSet  
     *     (Java name `org.hisp.dhis.dataset.DataSet`).
     */
    public DataSetElement(CategoryComboRef__3 categoryCombo, DataElementRef__3 dataElement, DataSetRef__1 dataSet) {
        super();
        this.categoryCombo = categoryCombo;
        this.dataElement = dataElement;
        this.dataSet = dataSet;
    }

    /**
     * A UID reference to a CategoryCombo  
     * (Java name `org.hisp.dhis.category.CategoryCombo`)
     * 
     */
    @JsonProperty("categoryCombo")
    public Optional<CategoryComboRef__3> getCategoryCombo() {
        return Optional.ofNullable(categoryCombo);
    }

    /**
     * A UID reference to a CategoryCombo  
     * (Java name `org.hisp.dhis.category.CategoryCombo`)
     * 
     */
    @JsonProperty("categoryCombo")
    public void setCategoryCombo(CategoryComboRef__3 categoryCombo) {
        this.categoryCombo = categoryCombo;
    }

    public DataSetElement withCategoryCombo(CategoryComboRef__3 categoryCombo) {
        this.categoryCombo = categoryCombo;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<DataElementRef__3> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(DataElementRef__3 dataElement) {
        this.dataElement = dataElement;
    }

    public DataSetElement withDataElement(DataElementRef__3 dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    public Optional<DataSetRef__1> getDataSet() {
        return Optional.ofNullable(dataSet);
    }

    /**
     * A UID reference to a DataSet  
     * (Java name `org.hisp.dhis.dataset.DataSet`)
     * 
     */
    @JsonProperty("dataSet")
    public void setDataSet(DataSetRef__1 dataSet) {
        this.dataSet = dataSet;
    }

    public DataSetElement withDataSet(DataSetRef__1 dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataSetElement withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("categoryCombo".equals(name)) {
            if (value instanceof CategoryComboRef__3) {
                setCategoryCombo(((CategoryComboRef__3) value));
            } else {
                throw new IllegalArgumentException(("property \"categoryCombo\" is of type \"org.hisp.dhis.api.model.v40_2_2.CategoryComboRef__3\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("dataElement".equals(name)) {
                if (value instanceof DataElementRef__3) {
                    setDataElement(((DataElementRef__3) value));
                } else {
                    throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataElementRef__3\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("dataSet".equals(name)) {
                    if (value instanceof DataSetRef__1) {
                        setDataSet(((DataSetRef__1) value));
                    } else {
                        throw new IllegalArgumentException(("property \"dataSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataSetRef__1\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("categoryCombo".equals(name)) {
            return getCategoryCombo();
        } else {
            if ("dataElement".equals(name)) {
                return getDataElement();
            } else {
                if ("dataSet".equals(name)) {
                    return getDataSet();
                } else {
                    return notFoundValue;
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataSetElement.NOT_FOUND_VALUE);
        if (DataSetElement.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataSetElement with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataSetElement.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("categoryCombo");
        sb.append('=');
        sb.append(((this.categoryCombo == null)?"<null>":this.categoryCombo));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("dataSet");
        sb.append('=');
        sb.append(((this.dataSet == null)?"<null>":this.dataSet));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.categoryCombo == null)? 0 :this.categoryCombo.hashCode()));
        result = ((result* 31)+((this.dataSet == null)? 0 :this.dataSet.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataSetElement) == false) {
            return false;
        }
        DataSetElement rhs = ((DataSetElement) other);
        return (((((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement)))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.categoryCombo == rhs.categoryCombo)||((this.categoryCombo!= null)&&this.categoryCombo.equals(rhs.categoryCombo))))&&((this.dataSet == rhs.dataSet)||((this.dataSet!= null)&&this.dataSet.equals(rhs.dataSet))));
    }

}
