
package org.hisp.dhis.api.model.v40_2_2;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "access",
    "attributeOptionCombo",
    "attributeValues",
    "categoryOptionCombo",
    "code",
    "created",
    "createdBy",
    "dataElement",
    "description",
    "displayDescription",
    "displayFormName",
    "externalAccess",
    "favorite",
    "favorites",
    "formName",
    "href",
    "lastUpdated",
    "lastUpdatedBy",
    "legendSet",
    "legendSets",
    "publicAccess",
    "queryMods",
    "sharing",
    "translations",
    "user",
    "userAccesses",
    "userGroupAccesses"
})
@Generated("jsonschema2pojo")
public class DataElementOperand implements Serializable
{

    @JsonProperty("access")
    private Access access;
    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    @JsonPropertyDescription("A UID reference to a CategoryOptionCombo  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private AttributeOptionComboRef attributeOptionCombo;
    @JsonProperty("attributeValues")
    private List<AttributeValue> attributeValues;
    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    @JsonPropertyDescription("A UID reference to a CategoryOptionCombo  \n(Java name `org.hisp.dhis.category.CategoryOptionCombo`)")
    private CategoryOptionComboRef categoryOptionCombo;
    @JsonProperty("code")
    private String code;
    @JsonProperty("created")
    private Date created;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private CreatedByRef__17 createdBy;
    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    @JsonPropertyDescription("A UID reference to a DataElement  \n(Java name `org.hisp.dhis.dataelement.DataElement`)")
    private DataElementRef__1 dataElement;
    @JsonProperty("description")
    private String description;
    @JsonProperty("displayDescription")
    private String displayDescription;
    @JsonProperty("displayFormName")
    private String displayFormName;
    @JsonProperty("externalAccess")
    private Boolean externalAccess;
    @JsonProperty("favorite")
    private Boolean favorite;
    @JsonProperty("favorites")
    private List<String> favorites;
    @JsonProperty("formName")
    private String formName;
    @JsonProperty("href")
    private String href;
    @JsonProperty("lastUpdated")
    private Date lastUpdated;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private LastUpdatedByRef__17 lastUpdatedBy;
    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    @JsonPropertyDescription("A UID reference to a LegendSet  \n(Java name `org.hisp.dhis.legend.LegendSet`)")
    private LegendSetRef__5 legendSet;
    @JsonProperty("legendSets")
    private List<LegendSetsRefRef__3> legendSets;
    @JsonProperty("publicAccess")
    private String publicAccess;
    @JsonProperty("queryMods")
    private QueryModifiers queryMods;
    @JsonProperty("sharing")
    private Sharing sharing;
    @JsonProperty("translations")
    private List<Translation> translations;
    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    @JsonPropertyDescription("A UID reference to a User  \n(Java name `org.hisp.dhis.user.User`)")
    private UserRef__18 user;
    @JsonProperty("userAccesses")
    private List<LegacyUserAccess> userAccesses;
    @JsonProperty("userGroupAccesses")
    private List<LegacyUserGroupAccess> userGroupAccesses;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();
    private final static long serialVersionUID = -8532157400897768987L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DataElementOperand() {
    }

    /**
     * 
     * @param source
     *     the object being copied
     */
    public DataElementOperand(DataElementOperand source) {
        super();
        this.access = source.access;
        this.attributeOptionCombo = source.attributeOptionCombo;
        this.attributeValues = source.attributeValues;
        this.categoryOptionCombo = source.categoryOptionCombo;
        this.code = source.code;
        this.created = source.created;
        this.createdBy = source.createdBy;
        this.dataElement = source.dataElement;
        this.description = source.description;
        this.displayDescription = source.displayDescription;
        this.displayFormName = source.displayFormName;
        this.externalAccess = source.externalAccess;
        this.favorite = source.favorite;
        this.favorites = source.favorites;
        this.formName = source.formName;
        this.href = source.href;
        this.lastUpdated = source.lastUpdated;
        this.lastUpdatedBy = source.lastUpdatedBy;
        this.legendSet = source.legendSet;
        this.legendSets = source.legendSets;
        this.publicAccess = source.publicAccess;
        this.queryMods = source.queryMods;
        this.sharing = source.sharing;
        this.translations = source.translations;
        this.user = source.user;
        this.userAccesses = source.userAccesses;
        this.userGroupAccesses = source.userGroupAccesses;
    }

    /**
     * 
     * @param lastUpdatedBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param createdBy
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     * @param attributeOptionCombo
     *     A UID reference to a CategoryOptionCombo  
     *     (Java name `org.hisp.dhis.category.CategoryOptionCombo`).
     * @param legendSet
     *     A UID reference to a LegendSet  
     *     (Java name `org.hisp.dhis.legend.LegendSet`).
     * @param categoryOptionCombo
     *     A UID reference to a CategoryOptionCombo  
     *     (Java name `org.hisp.dhis.category.CategoryOptionCombo`).
     * @param dataElement
     *     A UID reference to a DataElement  
     *     (Java name `org.hisp.dhis.dataelement.DataElement`).
     * @param user
     *     A UID reference to a User  
     *     (Java name `org.hisp.dhis.user.User`).
     */
    public DataElementOperand(Access access, AttributeOptionComboRef attributeOptionCombo, List<AttributeValue> attributeValues, CategoryOptionComboRef categoryOptionCombo, String code, Date created, CreatedByRef__17 createdBy, DataElementRef__1 dataElement, String description, String displayDescription, String displayFormName, Boolean externalAccess, Boolean favorite, List<String> favorites, String formName, String href, Date lastUpdated, LastUpdatedByRef__17 lastUpdatedBy, LegendSetRef__5 legendSet, List<LegendSetsRefRef__3> legendSets, String publicAccess, QueryModifiers queryMods, Sharing sharing, List<Translation> translations, UserRef__18 user, List<LegacyUserAccess> userAccesses, List<LegacyUserGroupAccess> userGroupAccesses) {
        super();
        this.access = access;
        this.attributeOptionCombo = attributeOptionCombo;
        this.attributeValues = attributeValues;
        this.categoryOptionCombo = categoryOptionCombo;
        this.code = code;
        this.created = created;
        this.createdBy = createdBy;
        this.dataElement = dataElement;
        this.description = description;
        this.displayDescription = displayDescription;
        this.displayFormName = displayFormName;
        this.externalAccess = externalAccess;
        this.favorite = favorite;
        this.favorites = favorites;
        this.formName = formName;
        this.href = href;
        this.lastUpdated = lastUpdated;
        this.lastUpdatedBy = lastUpdatedBy;
        this.legendSet = legendSet;
        this.legendSets = legendSets;
        this.publicAccess = publicAccess;
        this.queryMods = queryMods;
        this.sharing = sharing;
        this.translations = translations;
        this.user = user;
        this.userAccesses = userAccesses;
        this.userGroupAccesses = userGroupAccesses;
    }

    @JsonProperty("access")
    public Optional<Access> getAccess() {
        return Optional.ofNullable(access);
    }

    @JsonProperty("access")
    public void setAccess(Access access) {
        this.access = access;
    }

    public DataElementOperand withAccess(Access access) {
        this.access = access;
        return this;
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public Optional<AttributeOptionComboRef> getAttributeOptionCombo() {
        return Optional.ofNullable(attributeOptionCombo);
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("attributeOptionCombo")
    public void setAttributeOptionCombo(AttributeOptionComboRef attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
    }

    public DataElementOperand withAttributeOptionCombo(AttributeOptionComboRef attributeOptionCombo) {
        this.attributeOptionCombo = attributeOptionCombo;
        return this;
    }

    @JsonProperty("attributeValues")
    public Optional<List<AttributeValue>> getAttributeValues() {
        return Optional.ofNullable(attributeValues);
    }

    @JsonProperty("attributeValues")
    public void setAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public DataElementOperand withAttributeValues(List<AttributeValue> attributeValues) {
        this.attributeValues = attributeValues;
        return this;
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public Optional<CategoryOptionComboRef> getCategoryOptionCombo() {
        return Optional.ofNullable(categoryOptionCombo);
    }

    /**
     * A UID reference to a CategoryOptionCombo  
     * (Java name `org.hisp.dhis.category.CategoryOptionCombo`)
     * 
     */
    @JsonProperty("categoryOptionCombo")
    public void setCategoryOptionCombo(CategoryOptionComboRef categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
    }

    public DataElementOperand withCategoryOptionCombo(CategoryOptionComboRef categoryOptionCombo) {
        this.categoryOptionCombo = categoryOptionCombo;
        return this;
    }

    @JsonProperty("code")
    public Optional<String> getCode() {
        return Optional.ofNullable(code);
    }

    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public DataElementOperand withCode(String code) {
        this.code = code;
        return this;
    }

    @JsonProperty("created")
    public Optional<Date> getCreated() {
        return Optional.ofNullable(created);
    }

    @JsonProperty("created")
    public void setCreated(Date created) {
        this.created = created;
    }

    public DataElementOperand withCreated(Date created) {
        this.created = created;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public Optional<CreatedByRef__17> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("createdBy")
    public void setCreatedBy(CreatedByRef__17 createdBy) {
        this.createdBy = createdBy;
    }

    public DataElementOperand withCreatedBy(CreatedByRef__17 createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public Optional<DataElementRef__1> getDataElement() {
        return Optional.ofNullable(dataElement);
    }

    /**
     * A UID reference to a DataElement  
     * (Java name `org.hisp.dhis.dataelement.DataElement`)
     * 
     */
    @JsonProperty("dataElement")
    public void setDataElement(DataElementRef__1 dataElement) {
        this.dataElement = dataElement;
    }

    public DataElementOperand withDataElement(DataElementRef__1 dataElement) {
        this.dataElement = dataElement;
        return this;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    public DataElementOperand withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty("displayDescription")
    public Optional<String> getDisplayDescription() {
        return Optional.ofNullable(displayDescription);
    }

    @JsonProperty("displayDescription")
    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public DataElementOperand withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    @JsonProperty("displayFormName")
    public Optional<String> getDisplayFormName() {
        return Optional.ofNullable(displayFormName);
    }

    @JsonProperty("displayFormName")
    public void setDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
    }

    public DataElementOperand withDisplayFormName(String displayFormName) {
        this.displayFormName = displayFormName;
        return this;
    }

    @JsonProperty("externalAccess")
    public Optional<Boolean> getExternalAccess() {
        return Optional.ofNullable(externalAccess);
    }

    @JsonProperty("externalAccess")
    public void setExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
    }

    public DataElementOperand withExternalAccess(Boolean externalAccess) {
        this.externalAccess = externalAccess;
        return this;
    }

    @JsonProperty("favorite")
    public Optional<Boolean> getFavorite() {
        return Optional.ofNullable(favorite);
    }

    @JsonProperty("favorite")
    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DataElementOperand withFavorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @JsonProperty("favorites")
    public Optional<List<String>> getFavorites() {
        return Optional.ofNullable(favorites);
    }

    @JsonProperty("favorites")
    public void setFavorites(List<String> favorites) {
        this.favorites = favorites;
    }

    public DataElementOperand withFavorites(List<String> favorites) {
        this.favorites = favorites;
        return this;
    }

    @JsonProperty("formName")
    public Optional<String> getFormName() {
        return Optional.ofNullable(formName);
    }

    @JsonProperty("formName")
    public void setFormName(String formName) {
        this.formName = formName;
    }

    public DataElementOperand withFormName(String formName) {
        this.formName = formName;
        return this;
    }

    @JsonProperty("href")
    public Optional<String> getHref() {
        return Optional.ofNullable(href);
    }

    @JsonProperty("href")
    public void setHref(String href) {
        this.href = href;
    }

    public DataElementOperand withHref(String href) {
        this.href = href;
        return this;
    }

    @JsonProperty("lastUpdated")
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(lastUpdated);
    }

    @JsonProperty("lastUpdated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public DataElementOperand withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public Optional<LastUpdatedByRef__17> getLastUpdatedBy() {
        return Optional.ofNullable(lastUpdatedBy);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("lastUpdatedBy")
    public void setLastUpdatedBy(LastUpdatedByRef__17 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public DataElementOperand withLastUpdatedBy(LastUpdatedByRef__17 lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return this;
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public Optional<LegendSetRef__5> getLegendSet() {
        return Optional.ofNullable(legendSet);
    }

    /**
     * A UID reference to a LegendSet  
     * (Java name `org.hisp.dhis.legend.LegendSet`)
     * 
     */
    @JsonProperty("legendSet")
    public void setLegendSet(LegendSetRef__5 legendSet) {
        this.legendSet = legendSet;
    }

    public DataElementOperand withLegendSet(LegendSetRef__5 legendSet) {
        this.legendSet = legendSet;
        return this;
    }

    @JsonProperty("legendSets")
    public Optional<List<LegendSetsRefRef__3>> getLegendSets() {
        return Optional.ofNullable(legendSets);
    }

    @JsonProperty("legendSets")
    public void setLegendSets(List<LegendSetsRefRef__3> legendSets) {
        this.legendSets = legendSets;
    }

    public DataElementOperand withLegendSets(List<LegendSetsRefRef__3> legendSets) {
        this.legendSets = legendSets;
        return this;
    }

    @JsonProperty("publicAccess")
    public Optional<String> getPublicAccess() {
        return Optional.ofNullable(publicAccess);
    }

    @JsonProperty("publicAccess")
    public void setPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
    }

    public DataElementOperand withPublicAccess(String publicAccess) {
        this.publicAccess = publicAccess;
        return this;
    }

    @JsonProperty("queryMods")
    public Optional<QueryModifiers> getQueryMods() {
        return Optional.ofNullable(queryMods);
    }

    @JsonProperty("queryMods")
    public void setQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
    }

    public DataElementOperand withQueryMods(QueryModifiers queryMods) {
        this.queryMods = queryMods;
        return this;
    }

    @JsonProperty("sharing")
    public Optional<Sharing> getSharing() {
        return Optional.ofNullable(sharing);
    }

    @JsonProperty("sharing")
    public void setSharing(Sharing sharing) {
        this.sharing = sharing;
    }

    public DataElementOperand withSharing(Sharing sharing) {
        this.sharing = sharing;
        return this;
    }

    @JsonProperty("translations")
    public Optional<List<Translation>> getTranslations() {
        return Optional.ofNullable(translations);
    }

    @JsonProperty("translations")
    public void setTranslations(List<Translation> translations) {
        this.translations = translations;
    }

    public DataElementOperand withTranslations(List<Translation> translations) {
        this.translations = translations;
        return this;
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public Optional<UserRef__18> getUser() {
        return Optional.ofNullable(user);
    }

    /**
     * A UID reference to a User  
     * (Java name `org.hisp.dhis.user.User`)
     * 
     */
    @JsonProperty("user")
    public void setUser(UserRef__18 user) {
        this.user = user;
    }

    public DataElementOperand withUser(UserRef__18 user) {
        this.user = user;
        return this;
    }

    @JsonProperty("userAccesses")
    public Optional<List<LegacyUserAccess>> getUserAccesses() {
        return Optional.ofNullable(userAccesses);
    }

    @JsonProperty("userAccesses")
    public void setUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
    }

    public DataElementOperand withUserAccesses(List<LegacyUserAccess> userAccesses) {
        this.userAccesses = userAccesses;
        return this;
    }

    @JsonProperty("userGroupAccesses")
    public Optional<List<LegacyUserGroupAccess>> getUserGroupAccesses() {
        return Optional.ofNullable(userGroupAccesses);
    }

    @JsonProperty("userGroupAccesses")
    public void setUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
    }

    public DataElementOperand withUserGroupAccesses(List<LegacyUserGroupAccess> userGroupAccesses) {
        this.userGroupAccesses = userGroupAccesses;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public DataElementOperand withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("access".equals(name)) {
            if (value instanceof Access) {
                setAccess(((Access) value));
            } else {
                throw new IllegalArgumentException(("property \"access\" is of type \"org.hisp.dhis.api.model.v40_2_2.Access\", but got "+ value.getClass().toString()));
            }
            return true;
        } else {
            if ("attributeOptionCombo".equals(name)) {
                if (value instanceof AttributeOptionComboRef) {
                    setAttributeOptionCombo(((AttributeOptionComboRef) value));
                } else {
                    throw new IllegalArgumentException(("property \"attributeOptionCombo\" is of type \"org.hisp.dhis.api.model.v40_2_2.AttributeOptionComboRef\", but got "+ value.getClass().toString()));
                }
                return true;
            } else {
                if ("attributeValues".equals(name)) {
                    if (value instanceof List) {
                        setAttributeValues(((List<AttributeValue> ) value));
                    } else {
                        throw new IllegalArgumentException(("property \"attributeValues\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.AttributeValue>\", but got "+ value.getClass().toString()));
                    }
                    return true;
                } else {
                    if ("categoryOptionCombo".equals(name)) {
                        if (value instanceof CategoryOptionComboRef) {
                            setCategoryOptionCombo(((CategoryOptionComboRef) value));
                        } else {
                            throw new IllegalArgumentException(("property \"categoryOptionCombo\" is of type \"org.hisp.dhis.api.model.v40_2_2.CategoryOptionComboRef\", but got "+ value.getClass().toString()));
                        }
                        return true;
                    } else {
                        if ("code".equals(name)) {
                            if (value instanceof String) {
                                setCode(((String) value));
                            } else {
                                throw new IllegalArgumentException(("property \"code\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                            }
                            return true;
                        } else {
                            if ("created".equals(name)) {
                                if (value instanceof Date) {
                                    setCreated(((Date) value));
                                } else {
                                    throw new IllegalArgumentException(("property \"created\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                }
                                return true;
                            } else {
                                if ("createdBy".equals(name)) {
                                    if (value instanceof CreatedByRef__17) {
                                        setCreatedBy(((CreatedByRef__17) value));
                                    } else {
                                        throw new IllegalArgumentException(("property \"createdBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.CreatedByRef__17\", but got "+ value.getClass().toString()));
                                    }
                                    return true;
                                } else {
                                    if ("dataElement".equals(name)) {
                                        if (value instanceof DataElementRef__1) {
                                            setDataElement(((DataElementRef__1) value));
                                        } else {
                                            throw new IllegalArgumentException(("property \"dataElement\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataElementRef__1\", but got "+ value.getClass().toString()));
                                        }
                                        return true;
                                    } else {
                                        if ("description".equals(name)) {
                                            if (value instanceof String) {
                                                setDescription(((String) value));
                                            } else {
                                                throw new IllegalArgumentException(("property \"description\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                            }
                                            return true;
                                        } else {
                                            if ("displayDescription".equals(name)) {
                                                if (value instanceof String) {
                                                    setDisplayDescription(((String) value));
                                                } else {
                                                    throw new IllegalArgumentException(("property \"displayDescription\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                }
                                                return true;
                                            } else {
                                                if ("displayFormName".equals(name)) {
                                                    if (value instanceof String) {
                                                        setDisplayFormName(((String) value));
                                                    } else {
                                                        throw new IllegalArgumentException(("property \"displayFormName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                    }
                                                    return true;
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        if (value instanceof Boolean) {
                                                            setExternalAccess(((Boolean) value));
                                                        } else {
                                                            throw new IllegalArgumentException(("property \"externalAccess\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                        }
                                                        return true;
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            if (value instanceof Boolean) {
                                                                setFavorite(((Boolean) value));
                                                            } else {
                                                                throw new IllegalArgumentException(("property \"favorite\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                                                            }
                                                            return true;
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                if (value instanceof List) {
                                                                    setFavorites(((List<String> ) value));
                                                                } else {
                                                                    throw new IllegalArgumentException(("property \"favorites\" is of type \"java.util.List<java.lang.String>\", but got "+ value.getClass().toString()));
                                                                }
                                                                return true;
                                                            } else {
                                                                if ("formName".equals(name)) {
                                                                    if (value instanceof String) {
                                                                        setFormName(((String) value));
                                                                    } else {
                                                                        throw new IllegalArgumentException(("property \"formName\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                    }
                                                                    return true;
                                                                } else {
                                                                    if ("href".equals(name)) {
                                                                        if (value instanceof String) {
                                                                            setHref(((String) value));
                                                                        } else {
                                                                            throw new IllegalArgumentException(("property \"href\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                        }
                                                                        return true;
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            if (value instanceof Date) {
                                                                                setLastUpdated(((Date) value));
                                                                            } else {
                                                                                throw new IllegalArgumentException(("property \"lastUpdated\" is of type \"java.util.Date\", but got "+ value.getClass().toString()));
                                                                            }
                                                                            return true;
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                if (value instanceof LastUpdatedByRef__17) {
                                                                                    setLastUpdatedBy(((LastUpdatedByRef__17) value));
                                                                                } else {
                                                                                    throw new IllegalArgumentException(("property \"lastUpdatedBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.LastUpdatedByRef__17\", but got "+ value.getClass().toString()));
                                                                                }
                                                                                return true;
                                                                            } else {
                                                                                if ("legendSet".equals(name)) {
                                                                                    if (value instanceof LegendSetRef__5) {
                                                                                        setLegendSet(((LegendSetRef__5) value));
                                                                                    } else {
                                                                                        throw new IllegalArgumentException(("property \"legendSet\" is of type \"org.hisp.dhis.api.model.v40_2_2.LegendSetRef__5\", but got "+ value.getClass().toString()));
                                                                                    }
                                                                                    return true;
                                                                                } else {
                                                                                    if ("legendSets".equals(name)) {
                                                                                        if (value instanceof List) {
                                                                                            setLegendSets(((List<LegendSetsRefRef__3> ) value));
                                                                                        } else {
                                                                                            throw new IllegalArgumentException(("property \"legendSets\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegendSetsRefRef__3>\", but got "+ value.getClass().toString()));
                                                                                        }
                                                                                        return true;
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            if (value instanceof String) {
                                                                                                setPublicAccess(((String) value));
                                                                                            } else {
                                                                                                throw new IllegalArgumentException(("property \"publicAccess\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                                                                                            }
                                                                                            return true;
                                                                                        } else {
                                                                                            if ("queryMods".equals(name)) {
                                                                                                if (value instanceof QueryModifiers) {
                                                                                                    setQueryMods(((QueryModifiers) value));
                                                                                                } else {
                                                                                                    throw new IllegalArgumentException(("property \"queryMods\" is of type \"org.hisp.dhis.api.model.v40_2_2.QueryModifiers\", but got "+ value.getClass().toString()));
                                                                                                }
                                                                                                return true;
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    if (value instanceof Sharing) {
                                                                                                        setSharing(((Sharing) value));
                                                                                                    } else {
                                                                                                        throw new IllegalArgumentException(("property \"sharing\" is of type \"org.hisp.dhis.api.model.v40_2_2.Sharing\", but got "+ value.getClass().toString()));
                                                                                                    }
                                                                                                    return true;
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        if (value instanceof List) {
                                                                                                            setTranslations(((List<Translation> ) value));
                                                                                                        } else {
                                                                                                            throw new IllegalArgumentException(("property \"translations\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.Translation>\", but got "+ value.getClass().toString()));
                                                                                                        }
                                                                                                        return true;
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            if (value instanceof UserRef__18) {
                                                                                                                setUser(((UserRef__18) value));
                                                                                                            } else {
                                                                                                                throw new IllegalArgumentException(("property \"user\" is of type \"org.hisp.dhis.api.model.v40_2_2.UserRef__18\", but got "+ value.getClass().toString()));
                                                                                                            }
                                                                                                            return true;
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                if (value instanceof List) {
                                                                                                                    setUserAccesses(((List<LegacyUserAccess> ) value));
                                                                                                                } else {
                                                                                                                    throw new IllegalArgumentException(("property \"userAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserAccess>\", but got "+ value.getClass().toString()));
                                                                                                                }
                                                                                                                return true;
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    if (value instanceof List) {
                                                                                                                        setUserGroupAccesses(((List<LegacyUserGroupAccess> ) value));
                                                                                                                    } else {
                                                                                                                        throw new IllegalArgumentException(("property \"userGroupAccesses\" is of type \"java.util.List<org.hisp.dhis.api.model.v40_2_2.LegacyUserGroupAccess>\", but got "+ value.getClass().toString()));
                                                                                                                    }
                                                                                                                    return true;
                                                                                                                } else {
                                                                                                                    return false;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("access".equals(name)) {
            return getAccess();
        } else {
            if ("attributeOptionCombo".equals(name)) {
                return getAttributeOptionCombo();
            } else {
                if ("attributeValues".equals(name)) {
                    return getAttributeValues();
                } else {
                    if ("categoryOptionCombo".equals(name)) {
                        return getCategoryOptionCombo();
                    } else {
                        if ("code".equals(name)) {
                            return getCode();
                        } else {
                            if ("created".equals(name)) {
                                return getCreated();
                            } else {
                                if ("createdBy".equals(name)) {
                                    return getCreatedBy();
                                } else {
                                    if ("dataElement".equals(name)) {
                                        return getDataElement();
                                    } else {
                                        if ("description".equals(name)) {
                                            return getDescription();
                                        } else {
                                            if ("displayDescription".equals(name)) {
                                                return getDisplayDescription();
                                            } else {
                                                if ("displayFormName".equals(name)) {
                                                    return getDisplayFormName();
                                                } else {
                                                    if ("externalAccess".equals(name)) {
                                                        return getExternalAccess();
                                                    } else {
                                                        if ("favorite".equals(name)) {
                                                            return getFavorite();
                                                        } else {
                                                            if ("favorites".equals(name)) {
                                                                return getFavorites();
                                                            } else {
                                                                if ("formName".equals(name)) {
                                                                    return getFormName();
                                                                } else {
                                                                    if ("href".equals(name)) {
                                                                        return getHref();
                                                                    } else {
                                                                        if ("lastUpdated".equals(name)) {
                                                                            return getLastUpdated();
                                                                        } else {
                                                                            if ("lastUpdatedBy".equals(name)) {
                                                                                return getLastUpdatedBy();
                                                                            } else {
                                                                                if ("legendSet".equals(name)) {
                                                                                    return getLegendSet();
                                                                                } else {
                                                                                    if ("legendSets".equals(name)) {
                                                                                        return getLegendSets();
                                                                                    } else {
                                                                                        if ("publicAccess".equals(name)) {
                                                                                            return getPublicAccess();
                                                                                        } else {
                                                                                            if ("queryMods".equals(name)) {
                                                                                                return getQueryMods();
                                                                                            } else {
                                                                                                if ("sharing".equals(name)) {
                                                                                                    return getSharing();
                                                                                                } else {
                                                                                                    if ("translations".equals(name)) {
                                                                                                        return getTranslations();
                                                                                                    } else {
                                                                                                        if ("user".equals(name)) {
                                                                                                            return getUser();
                                                                                                        } else {
                                                                                                            if ("userAccesses".equals(name)) {
                                                                                                                return getUserAccesses();
                                                                                                            } else {
                                                                                                                if ("userGroupAccesses".equals(name)) {
                                                                                                                    return getUserGroupAccesses();
                                                                                                                } else {
                                                                                                                    return notFoundValue;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataElementOperand.NOT_FOUND_VALUE);
        if (DataElementOperand.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    public DataElementOperand with(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataElementOperand.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("access");
        sb.append('=');
        sb.append(((this.access == null)?"<null>":this.access));
        sb.append(',');
        sb.append("attributeOptionCombo");
        sb.append('=');
        sb.append(((this.attributeOptionCombo == null)?"<null>":this.attributeOptionCombo));
        sb.append(',');
        sb.append("attributeValues");
        sb.append('=');
        sb.append(((this.attributeValues == null)?"<null>":this.attributeValues));
        sb.append(',');
        sb.append("categoryOptionCombo");
        sb.append('=');
        sb.append(((this.categoryOptionCombo == null)?"<null>":this.categoryOptionCombo));
        sb.append(',');
        sb.append("code");
        sb.append('=');
        sb.append(((this.code == null)?"<null>":this.code));
        sb.append(',');
        sb.append("created");
        sb.append('=');
        sb.append(((this.created == null)?"<null>":this.created));
        sb.append(',');
        sb.append("createdBy");
        sb.append('=');
        sb.append(((this.createdBy == null)?"<null>":this.createdBy));
        sb.append(',');
        sb.append("dataElement");
        sb.append('=');
        sb.append(((this.dataElement == null)?"<null>":this.dataElement));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("displayDescription");
        sb.append('=');
        sb.append(((this.displayDescription == null)?"<null>":this.displayDescription));
        sb.append(',');
        sb.append("displayFormName");
        sb.append('=');
        sb.append(((this.displayFormName == null)?"<null>":this.displayFormName));
        sb.append(',');
        sb.append("externalAccess");
        sb.append('=');
        sb.append(((this.externalAccess == null)?"<null>":this.externalAccess));
        sb.append(',');
        sb.append("favorite");
        sb.append('=');
        sb.append(((this.favorite == null)?"<null>":this.favorite));
        sb.append(',');
        sb.append("favorites");
        sb.append('=');
        sb.append(((this.favorites == null)?"<null>":this.favorites));
        sb.append(',');
        sb.append("formName");
        sb.append('=');
        sb.append(((this.formName == null)?"<null>":this.formName));
        sb.append(',');
        sb.append("href");
        sb.append('=');
        sb.append(((this.href == null)?"<null>":this.href));
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(((this.lastUpdated == null)?"<null>":this.lastUpdated));
        sb.append(',');
        sb.append("lastUpdatedBy");
        sb.append('=');
        sb.append(((this.lastUpdatedBy == null)?"<null>":this.lastUpdatedBy));
        sb.append(',');
        sb.append("legendSet");
        sb.append('=');
        sb.append(((this.legendSet == null)?"<null>":this.legendSet));
        sb.append(',');
        sb.append("legendSets");
        sb.append('=');
        sb.append(((this.legendSets == null)?"<null>":this.legendSets));
        sb.append(',');
        sb.append("publicAccess");
        sb.append('=');
        sb.append(((this.publicAccess == null)?"<null>":this.publicAccess));
        sb.append(',');
        sb.append("queryMods");
        sb.append('=');
        sb.append(((this.queryMods == null)?"<null>":this.queryMods));
        sb.append(',');
        sb.append("sharing");
        sb.append('=');
        sb.append(((this.sharing == null)?"<null>":this.sharing));
        sb.append(',');
        sb.append("translations");
        sb.append('=');
        sb.append(((this.translations == null)?"<null>":this.translations));
        sb.append(',');
        sb.append("user");
        sb.append('=');
        sb.append(((this.user == null)?"<null>":this.user));
        sb.append(',');
        sb.append("userAccesses");
        sb.append('=');
        sb.append(((this.userAccesses == null)?"<null>":this.userAccesses));
        sb.append(',');
        sb.append("userGroupAccesses");
        sb.append('=');
        sb.append(((this.userGroupAccesses == null)?"<null>":this.userGroupAccesses));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(((this.additionalProperties == null)?"<null>":this.additionalProperties));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.favorites == null)? 0 :this.favorites.hashCode()));
        result = ((result* 31)+((this.access == null)? 0 :this.access.hashCode()));
        result = ((result* 31)+((this.code == null)? 0 :this.code.hashCode()));
        result = ((result* 31)+((this.publicAccess == null)? 0 :this.publicAccess.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.categoryOptionCombo == null)? 0 :this.categoryOptionCombo.hashCode()));
        result = ((result* 31)+((this.externalAccess == null)? 0 :this.externalAccess.hashCode()));
        result = ((result* 31)+((this.lastUpdated == null)? 0 :this.lastUpdated.hashCode()));
        result = ((result* 31)+((this.queryMods == null)? 0 :this.queryMods.hashCode()));
        result = ((result* 31)+((this.translations == null)? 0 :this.translations.hashCode()));
        result = ((result* 31)+((this.formName == null)? 0 :this.formName.hashCode()));
        result = ((result* 31)+((this.href == null)? 0 :this.href.hashCode()));
        result = ((result* 31)+((this.displayDescription == null)? 0 :this.displayDescription.hashCode()));
        result = ((result* 31)+((this.lastUpdatedBy == null)? 0 :this.lastUpdatedBy.hashCode()));
        result = ((result* 31)+((this.userGroupAccesses == null)? 0 :this.userGroupAccesses.hashCode()));
        result = ((result* 31)+((this.created == null)? 0 :this.created.hashCode()));
        result = ((result* 31)+((this.attributeValues == null)? 0 :this.attributeValues.hashCode()));
        result = ((result* 31)+((this.dataElement == null)? 0 :this.dataElement.hashCode()));
        result = ((result* 31)+((this.sharing == null)? 0 :this.sharing.hashCode()));
        result = ((result* 31)+((this.displayFormName == null)? 0 :this.displayFormName.hashCode()));
        result = ((result* 31)+((this.createdBy == null)? 0 :this.createdBy.hashCode()));
        result = ((result* 31)+((this.attributeOptionCombo == null)? 0 :this.attributeOptionCombo.hashCode()));
        result = ((result* 31)+((this.userAccesses == null)? 0 :this.userAccesses.hashCode()));
        result = ((result* 31)+((this.legendSet == null)? 0 :this.legendSet.hashCode()));
        result = ((result* 31)+((this.legendSets == null)? 0 :this.legendSets.hashCode()));
        result = ((result* 31)+((this.additionalProperties == null)? 0 :this.additionalProperties.hashCode()));
        result = ((result* 31)+((this.favorite == null)? 0 :this.favorite.hashCode()));
        result = ((result* 31)+((this.user == null)? 0 :this.user.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof DataElementOperand) == false) {
            return false;
        }
        DataElementOperand rhs = ((DataElementOperand) other);
        return (((((((((((((((((((((((((((((this.favorites == rhs.favorites)||((this.favorites!= null)&&this.favorites.equals(rhs.favorites)))&&((this.access == rhs.access)||((this.access!= null)&&this.access.equals(rhs.access))))&&((this.code == rhs.code)||((this.code!= null)&&this.code.equals(rhs.code))))&&((this.publicAccess == rhs.publicAccess)||((this.publicAccess!= null)&&this.publicAccess.equals(rhs.publicAccess))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.categoryOptionCombo == rhs.categoryOptionCombo)||((this.categoryOptionCombo!= null)&&this.categoryOptionCombo.equals(rhs.categoryOptionCombo))))&&((this.externalAccess == rhs.externalAccess)||((this.externalAccess!= null)&&this.externalAccess.equals(rhs.externalAccess))))&&((this.lastUpdated == rhs.lastUpdated)||((this.lastUpdated!= null)&&this.lastUpdated.equals(rhs.lastUpdated))))&&((this.queryMods == rhs.queryMods)||((this.queryMods!= null)&&this.queryMods.equals(rhs.queryMods))))&&((this.translations == rhs.translations)||((this.translations!= null)&&this.translations.equals(rhs.translations))))&&((this.formName == rhs.formName)||((this.formName!= null)&&this.formName.equals(rhs.formName))))&&((this.href == rhs.href)||((this.href!= null)&&this.href.equals(rhs.href))))&&((this.displayDescription == rhs.displayDescription)||((this.displayDescription!= null)&&this.displayDescription.equals(rhs.displayDescription))))&&((this.lastUpdatedBy == rhs.lastUpdatedBy)||((this.lastUpdatedBy!= null)&&this.lastUpdatedBy.equals(rhs.lastUpdatedBy))))&&((this.userGroupAccesses == rhs.userGroupAccesses)||((this.userGroupAccesses!= null)&&this.userGroupAccesses.equals(rhs.userGroupAccesses))))&&((this.created == rhs.created)||((this.created!= null)&&this.created.equals(rhs.created))))&&((this.attributeValues == rhs.attributeValues)||((this.attributeValues!= null)&&this.attributeValues.equals(rhs.attributeValues))))&&((this.dataElement == rhs.dataElement)||((this.dataElement!= null)&&this.dataElement.equals(rhs.dataElement))))&&((this.sharing == rhs.sharing)||((this.sharing!= null)&&this.sharing.equals(rhs.sharing))))&&((this.displayFormName == rhs.displayFormName)||((this.displayFormName!= null)&&this.displayFormName.equals(rhs.displayFormName))))&&((this.createdBy == rhs.createdBy)||((this.createdBy!= null)&&this.createdBy.equals(rhs.createdBy))))&&((this.attributeOptionCombo == rhs.attributeOptionCombo)||((this.attributeOptionCombo!= null)&&this.attributeOptionCombo.equals(rhs.attributeOptionCombo))))&&((this.userAccesses == rhs.userAccesses)||((this.userAccesses!= null)&&this.userAccesses.equals(rhs.userAccesses))))&&((this.legendSet == rhs.legendSet)||((this.legendSet!= null)&&this.legendSet.equals(rhs.legendSet))))&&((this.legendSets == rhs.legendSets)||((this.legendSets!= null)&&this.legendSets.equals(rhs.legendSets))))&&((this.additionalProperties == rhs.additionalProperties)||((this.additionalProperties!= null)&&this.additionalProperties.equals(rhs.additionalProperties))))&&((this.favorite == rhs.favorite)||((this.favorite!= null)&&this.favorite.equals(rhs.favorite))))&&((this.user == rhs.user)||((this.user!= null)&&this.user.equals(rhs.user))));
    }

}
